import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import {
  Handler,
  HttpHandlerOptions as __HttpHandlerOptions,
  MetadataBearer as __MetadataBearer,
  MiddlewareStack,
} from "@aws-sdk/types";
import {
  EC2ClientResolvedConfig,
  ServiceInputTypes,
  ServiceOutputTypes,
} from "../EC2Client";
import {
  CreateNetworkInsightsPathRequest,
  CreateNetworkInsightsPathResult,
} from "../models/models_1";
export interface CreateNetworkInsightsPathCommandInput
  extends CreateNetworkInsightsPathRequest {}
export interface CreateNetworkInsightsPathCommandOutput
  extends CreateNetworkInsightsPathResult,
    __MetadataBearer {}
export declare class CreateNetworkInsightsPathCommand extends $Command<
  CreateNetworkInsightsPathCommandInput,
  CreateNetworkInsightsPathCommandOutput,
  EC2ClientResolvedConfig
> {
  readonly input: CreateNetworkInsightsPathCommandInput;
  static getEndpointParameterInstructions(): EndpointParameterInstructions;
  constructor(input: CreateNetworkInsightsPathCommandInput);
  resolveMiddleware(
    clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>,
    configuration: EC2ClientResolvedConfig,
    options?: __HttpHandlerOptions
  ): Handler<
    CreateNetworkInsightsPathCommandInput,
    CreateNetworkInsightsPathCommandOutput
  >;
  private serialize;
  private deserialize;
}
