import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import {
  Handler,
  HttpHandlerOptions as __HttpHandlerOptions,
  MetadataBearer as __MetadataBearer,
  MiddlewareStack,
} from "@aws-sdk/types";
import {
  EC2ClientResolvedConfig,
  ServiceInputTypes,
  ServiceOutputTypes,
} from "../EC2Client";
import {
  CreateCapacityReservationFleetRequest,
  CreateCapacityReservationFleetResult,
} from "../models/models_0";
export interface CreateCapacityReservationFleetCommandInput
  extends CreateCapacityReservationFleetRequest {}
export interface CreateCapacityReservationFleetCommandOutput
  extends CreateCapacityReservationFleetResult,
    __MetadataBearer {}
export declare class CreateCapacityReservationFleetCommand extends $Command<
  CreateCapacityReservationFleetCommandInput,
  CreateCapacityReservationFleetCommandOutput,
  EC2ClientResolvedConfig
> {
  readonly input: CreateCapacityReservationFleetCommandInput;
  static getEndpointParameterInstructions(): EndpointParameterInstructions;
  constructor(input: CreateCapacityReservationFleetCommandInput);
  resolveMiddleware(
    clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>,
    configuration: EC2ClientResolvedConfig,
    options?: __HttpHandlerOptions
  ): Handler<
    CreateCapacityReservationFleetCommandInput,
    CreateCapacityReservationFleetCommandOutput
  >;
  private serialize;
  private deserialize;
}
