import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import {
  Handler,
  HttpHandlerOptions as __HttpHandlerOptions,
  MetadataBearer as __MetadataBearer,
  MiddlewareStack,
} from "@aws-sdk/types";
import {
  EC2ClientResolvedConfig,
  ServiceInputTypes,
  ServiceOutputTypes,
} from "../EC2Client";
import {
  CreateCapacityReservationRequest,
  CreateCapacityReservationResult,
} from "../models/models_0";
export interface CreateCapacityReservationCommandInput
  extends CreateCapacityReservationRequest {}
export interface CreateCapacityReservationCommandOutput
  extends CreateCapacityReservationResult,
    __MetadataBearer {}
export declare class CreateCapacityReservationCommand extends $Command<
  CreateCapacityReservationCommandInput,
  CreateCapacityReservationCommandOutput,
  EC2ClientResolvedConfig
> {
  readonly input: CreateCapacityReservationCommandInput;
  static getEndpointParameterInstructions(): EndpointParameterInstructions;
  constructor(input: CreateCapacityReservationCommandInput);
  resolveMiddleware(
    clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>,
    configuration: EC2ClientResolvedConfig,
    options?: __HttpHandlerOptions
  ): Handler<
    CreateCapacityReservationCommandInput,
    CreateCapacityReservationCommandOutput
  >;
  private serialize;
  private deserialize;
}
