import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import {
  Handler,
  HttpHandlerOptions as __HttpHandlerOptions,
  MetadataBearer as __MetadataBearer,
  MiddlewareStack,
} from "@aws-sdk/types";
import {
  EC2ClientResolvedConfig,
  ServiceInputTypes,
  ServiceOutputTypes,
} from "../EC2Client";
import {
  CancelReservedInstancesListingRequest,
  CancelReservedInstancesListingResult,
} from "../models/models_0";
export interface CancelReservedInstancesListingCommandInput
  extends CancelReservedInstancesListingRequest {}
export interface CancelReservedInstancesListingCommandOutput
  extends CancelReservedInstancesListingResult,
    __MetadataBearer {}
export declare class CancelReservedInstancesListingCommand extends $Command<
  CancelReservedInstancesListingCommandInput,
  CancelReservedInstancesListingCommandOutput,
  EC2ClientResolvedConfig
> {
  readonly input: CancelReservedInstancesListingCommandInput;
  static getEndpointParameterInstructions(): EndpointParameterInstructions;
  constructor(input: CancelReservedInstancesListingCommandInput);
  resolveMiddleware(
    clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>,
    configuration: EC2ClientResolvedConfig,
    options?: __HttpHandlerOptions
  ): Handler<
    CancelReservedInstancesListingCommandInput,
    CancelReservedInstancesListingCommandOutput
  >;
  private serialize;
  private deserialize;
}
