import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { ModifySnapshotTierRequest, ModifySnapshotTierResult } from "../models/models_6";
export interface ModifySnapshotTierCommandInput extends ModifySnapshotTierRequest {
}
export interface ModifySnapshotTierCommandOutput extends ModifySnapshotTierResult, __MetadataBearer {
}
/**
 * <p>Archives an Amazon EBS snapshot. When you archive a snapshot, it is converted to a full
 *       snapshot that includes all of the blocks of data that were written to the volume at the
 *       time the snapshot was created, and moved from the standard tier to the archive
 *       tier. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/snapshot-archive.html">Archive Amazon EBS snapshots</a>
 *       in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, ModifySnapshotTierCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, ModifySnapshotTierCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * const client = new EC2Client(config);
 * const command = new ModifySnapshotTierCommand(input);
 * const response = await client.send(command);
 * ```
 *
 * @see {@link ModifySnapshotTierCommandInput} for command's `input` shape.
 * @see {@link ModifySnapshotTierCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 */
export declare class ModifySnapshotTierCommand extends $Command<ModifySnapshotTierCommandInput, ModifySnapshotTierCommandOutput, EC2ClientResolvedConfig> {
    readonly input: ModifySnapshotTierCommandInput;
    static getEndpointParameterInstructions(): EndpointParameterInstructions;
    constructor(input: ModifySnapshotTierCommandInput);
    /**
     * @internal
     */
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: EC2ClientResolvedConfig, options?: __HttpHandlerOptions): Handler<ModifySnapshotTierCommandInput, ModifySnapshotTierCommandOutput>;
    private serialize;
    private deserialize;
}
