import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { ModifyLocalGatewayRouteRequest, ModifyLocalGatewayRouteResult } from "../models/models_6";
export interface ModifyLocalGatewayRouteCommandInput extends ModifyLocalGatewayRouteRequest {
}
export interface ModifyLocalGatewayRouteCommandOutput extends ModifyLocalGatewayRouteResult, __MetadataBearer {
}
/**
 * <p>Modifies the specified local gateway route.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, ModifyLocalGatewayRouteCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, ModifyLocalGatewayRouteCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * const client = new EC2Client(config);
 * const command = new ModifyLocalGatewayRouteCommand(input);
 * const response = await client.send(command);
 * ```
 *
 * @see {@link ModifyLocalGatewayRouteCommandInput} for command's `input` shape.
 * @see {@link ModifyLocalGatewayRouteCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 */
export declare class ModifyLocalGatewayRouteCommand extends $Command<ModifyLocalGatewayRouteCommandInput, ModifyLocalGatewayRouteCommandOutput, EC2ClientResolvedConfig> {
    readonly input: ModifyLocalGatewayRouteCommandInput;
    static getEndpointParameterInstructions(): EndpointParameterInstructions;
    constructor(input: ModifyLocalGatewayRouteCommandInput);
    /**
     * @internal
     */
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: EC2ClientResolvedConfig, options?: __HttpHandlerOptions): Handler<ModifyLocalGatewayRouteCommandInput, ModifyLocalGatewayRouteCommandOutput>;
    private serialize;
    private deserialize;
}
