import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { DetachVerifiedAccessTrustProviderRequest, DetachVerifiedAccessTrustProviderResult } from "../models/models_5";
export interface DetachVerifiedAccessTrustProviderCommandInput extends DetachVerifiedAccessTrustProviderRequest {
}
export interface DetachVerifiedAccessTrustProviderCommandOutput extends DetachVerifiedAccessTrustProviderResult, __MetadataBearer {
}
/**
 * <p>Detach a trust provider from an Amazon Web Services Verified Access instance.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, DetachVerifiedAccessTrustProviderCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, DetachVerifiedAccessTrustProviderCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * const client = new EC2Client(config);
 * const command = new DetachVerifiedAccessTrustProviderCommand(input);
 * const response = await client.send(command);
 * ```
 *
 * @see {@link DetachVerifiedAccessTrustProviderCommandInput} for command's `input` shape.
 * @see {@link DetachVerifiedAccessTrustProviderCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 */
export declare class DetachVerifiedAccessTrustProviderCommand extends $Command<DetachVerifiedAccessTrustProviderCommandInput, DetachVerifiedAccessTrustProviderCommandOutput, EC2ClientResolvedConfig> {
    readonly input: DetachVerifiedAccessTrustProviderCommandInput;
    static getEndpointParameterInstructions(): EndpointParameterInstructions;
    constructor(input: DetachVerifiedAccessTrustProviderCommandInput);
    /**
     * @internal
     */
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: EC2ClientResolvedConfig, options?: __HttpHandlerOptions): Handler<DetachVerifiedAccessTrustProviderCommandInput, DetachVerifiedAccessTrustProviderCommandOutput>;
    private serialize;
    private deserialize;
}
