import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { DescribeVerifiedAccessInstanceLoggingConfigurationsRequest, DescribeVerifiedAccessInstanceLoggingConfigurationsResult } from "../models/models_4";
export interface DescribeVerifiedAccessInstanceLoggingConfigurationsCommandInput extends DescribeVerifiedAccessInstanceLoggingConfigurationsRequest {
}
export interface DescribeVerifiedAccessInstanceLoggingConfigurationsCommandOutput extends DescribeVerifiedAccessInstanceLoggingConfigurationsResult, __MetadataBearer {
}
/**
 * <p>Describes the current logging configuration for the Amazon Web Services Verified Access instances.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, DescribeVerifiedAccessInstanceLoggingConfigurationsCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, DescribeVerifiedAccessInstanceLoggingConfigurationsCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * const client = new EC2Client(config);
 * const command = new DescribeVerifiedAccessInstanceLoggingConfigurationsCommand(input);
 * const response = await client.send(command);
 * ```
 *
 * @see {@link DescribeVerifiedAccessInstanceLoggingConfigurationsCommandInput} for command's `input` shape.
 * @see {@link DescribeVerifiedAccessInstanceLoggingConfigurationsCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 */
export declare class DescribeVerifiedAccessInstanceLoggingConfigurationsCommand extends $Command<DescribeVerifiedAccessInstanceLoggingConfigurationsCommandInput, DescribeVerifiedAccessInstanceLoggingConfigurationsCommandOutput, EC2ClientResolvedConfig> {
    readonly input: DescribeVerifiedAccessInstanceLoggingConfigurationsCommandInput;
    static getEndpointParameterInstructions(): EndpointParameterInstructions;
    constructor(input: DescribeVerifiedAccessInstanceLoggingConfigurationsCommandInput);
    /**
     * @internal
     */
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: EC2ClientResolvedConfig, options?: __HttpHandlerOptions): Handler<DescribeVerifiedAccessInstanceLoggingConfigurationsCommandInput, DescribeVerifiedAccessInstanceLoggingConfigurationsCommandOutput>;
    private serialize;
    private deserialize;
}
