import { getEndpointPlugin } from "@aws-sdk/middleware-endpoint";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { EnableVpcClassicLinkDnsSupportRequestFilterSensitiveLog, EnableVpcClassicLinkDnsSupportResultFilterSensitiveLog, } from "../models/models_5";
import { deserializeAws_ec2EnableVpcClassicLinkDnsSupportCommand, serializeAws_ec2EnableVpcClassicLinkDnsSupportCommand, } from "../protocols/Aws_ec2";
export class EnableVpcClassicLinkDnsSupportCommand extends $Command {
    constructor(input) {
        super();
        this.input = input;
    }
    static getEndpointParameterInstructions() {
        return {
            UseFIPS: { type: "builtInParams", name: "useFipsEndpoint" },
            Endpoint: { type: "builtInParams", name: "endpoint" },
            Region: { type: "builtInParams", name: "region" },
            UseDualStack: { type: "builtInParams", name: "useDualstackEndpoint" },
        };
    }
    resolveMiddleware(clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use(getEndpointPlugin(configuration, EnableVpcClassicLinkDnsSupportCommand.getEndpointParameterInstructions()));
        const stack = clientStack.concat(this.middlewareStack);
        const { logger } = configuration;
        const clientName = "EC2Client";
        const commandName = "EnableVpcClassicLinkDnsSupportCommand";
        const handlerExecutionContext = {
            logger,
            clientName,
            commandName,
            inputFilterSensitiveLog: EnableVpcClassicLinkDnsSupportRequestFilterSensitiveLog,
            outputFilterSensitiveLog: EnableVpcClassicLinkDnsSupportResultFilterSensitiveLog,
        };
        const { requestHandler } = configuration;
        return stack.resolve((request) => requestHandler.handle(request.request, options || {}), handlerExecutionContext);
    }
    serialize(input, context) {
        return serializeAws_ec2EnableVpcClassicLinkDnsSupportCommand(input, context);
    }
    deserialize(output, context) {
        return deserializeAws_ec2EnableVpcClassicLinkDnsSupportCommand(output, context);
    }
}
