import { getEndpointPlugin } from "@aws-sdk/middleware-endpoint";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DisassociateInstanceEventWindowRequestFilterSensitiveLog, DisassociateInstanceEventWindowResultFilterSensitiveLog, } from "../models/models_5";
import { deserializeAws_ec2DisassociateInstanceEventWindowCommand, serializeAws_ec2DisassociateInstanceEventWindowCommand, } from "../protocols/Aws_ec2";
export class DisassociateInstanceEventWindowCommand extends $Command {
    constructor(input) {
        super();
        this.input = input;
    }
    static getEndpointParameterInstructions() {
        return {
            UseFIPS: { type: "builtInParams", name: "useFipsEndpoint" },
            Endpoint: { type: "builtInParams", name: "endpoint" },
            Region: { type: "builtInParams", name: "region" },
            UseDualStack: { type: "builtInParams", name: "useDualstackEndpoint" },
        };
    }
    resolveMiddleware(clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use(getEndpointPlugin(configuration, DisassociateInstanceEventWindowCommand.getEndpointParameterInstructions()));
        const stack = clientStack.concat(this.middlewareStack);
        const { logger } = configuration;
        const clientName = "EC2Client";
        const commandName = "DisassociateInstanceEventWindowCommand";
        const handlerExecutionContext = {
            logger,
            clientName,
            commandName,
            inputFilterSensitiveLog: DisassociateInstanceEventWindowRequestFilterSensitiveLog,
            outputFilterSensitiveLog: DisassociateInstanceEventWindowResultFilterSensitiveLog,
        };
        const { requestHandler } = configuration;
        return stack.resolve((request) => requestHandler.handle(request.request, options || {}), handlerExecutionContext);
    }
    serialize(input, context) {
        return serializeAws_ec2DisassociateInstanceEventWindowCommand(input, context);
    }
    deserialize(output, context) {
        return deserializeAws_ec2DisassociateInstanceEventWindowCommand(output, context);
    }
}
