import { getEndpointPlugin } from "@aws-sdk/middleware-endpoint";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DescribeClassicLinkInstancesRequestFilterSensitiveLog, DescribeClassicLinkInstancesResultFilterSensitiveLog, } from "../models/models_3";
import { deserializeAws_ec2DescribeClassicLinkInstancesCommand, serializeAws_ec2DescribeClassicLinkInstancesCommand, } from "../protocols/Aws_ec2";
export class DescribeClassicLinkInstancesCommand extends $Command {
    constructor(input) {
        super();
        this.input = input;
    }
    static getEndpointParameterInstructions() {
        return {
            UseFIPS: { type: "builtInParams", name: "useFipsEndpoint" },
            Endpoint: { type: "builtInParams", name: "endpoint" },
            Region: { type: "builtInParams", name: "region" },
            UseDualStack: { type: "builtInParams", name: "useDualstackEndpoint" },
        };
    }
    resolveMiddleware(clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use(getEndpointPlugin(configuration, DescribeClassicLinkInstancesCommand.getEndpointParameterInstructions()));
        const stack = clientStack.concat(this.middlewareStack);
        const { logger } = configuration;
        const clientName = "EC2Client";
        const commandName = "DescribeClassicLinkInstancesCommand";
        const handlerExecutionContext = {
            logger,
            clientName,
            commandName,
            inputFilterSensitiveLog: DescribeClassicLinkInstancesRequestFilterSensitiveLog,
            outputFilterSensitiveLog: DescribeClassicLinkInstancesResultFilterSensitiveLog,
        };
        const { requestHandler } = configuration;
        return stack.resolve((request) => requestHandler.handle(request.request, options || {}), handlerExecutionContext);
    }
    serialize(input, context) {
        return serializeAws_ec2DescribeClassicLinkInstancesCommand(input, context);
    }
    deserialize(output, context) {
        return deserializeAws_ec2DescribeClassicLinkInstancesCommand(output, context);
    }
}
