import { getEndpointPlugin } from "@aws-sdk/middleware-endpoint";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DeprovisionPublicIpv4PoolCidrRequestFilterSensitiveLog, DeprovisionPublicIpv4PoolCidrResultFilterSensitiveLog, } from "../models/models_3";
import { deserializeAws_ec2DeprovisionPublicIpv4PoolCidrCommand, serializeAws_ec2DeprovisionPublicIpv4PoolCidrCommand, } from "../protocols/Aws_ec2";
export class DeprovisionPublicIpv4PoolCidrCommand extends $Command {
    constructor(input) {
        super();
        this.input = input;
    }
    static getEndpointParameterInstructions() {
        return {
            UseFIPS: { type: "builtInParams", name: "useFipsEndpoint" },
            Endpoint: { type: "builtInParams", name: "endpoint" },
            Region: { type: "builtInParams", name: "region" },
            UseDualStack: { type: "builtInParams", name: "useDualstackEndpoint" },
        };
    }
    resolveMiddleware(clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use(getEndpointPlugin(configuration, DeprovisionPublicIpv4PoolCidrCommand.getEndpointParameterInstructions()));
        const stack = clientStack.concat(this.middlewareStack);
        const { logger } = configuration;
        const clientName = "EC2Client";
        const commandName = "DeprovisionPublicIpv4PoolCidrCommand";
        const handlerExecutionContext = {
            logger,
            clientName,
            commandName,
            inputFilterSensitiveLog: DeprovisionPublicIpv4PoolCidrRequestFilterSensitiveLog,
            outputFilterSensitiveLog: DeprovisionPublicIpv4PoolCidrResultFilterSensitiveLog,
        };
        const { requestHandler } = configuration;
        return stack.resolve((request) => requestHandler.handle(request.request, options || {}), handlerExecutionContext);
    }
    serialize(input, context) {
        return serializeAws_ec2DeprovisionPublicIpv4PoolCidrCommand(input, context);
    }
    deserialize(output, context) {
        return deserializeAws_ec2DeprovisionPublicIpv4PoolCidrCommand(output, context);
    }
}
