"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CopySnapshotCommand = void 0;
const middleware_endpoint_1 = require("@aws-sdk/middleware-endpoint");
const middleware_sdk_ec2_1 = require("@aws-sdk/middleware-sdk-ec2");
const middleware_serde_1 = require("@aws-sdk/middleware-serde");
const smithy_client_1 = require("@aws-sdk/smithy-client");
const models_0_1 = require("../models/models_0");
const Aws_ec2_1 = require("../protocols/Aws_ec2");
class CopySnapshotCommand extends smithy_client_1.Command {
    constructor(input) {
        super();
        this.input = input;
    }
    static getEndpointParameterInstructions() {
        return {
            UseFIPS: { type: "builtInParams", name: "useFipsEndpoint" },
            Endpoint: { type: "builtInParams", name: "endpoint" },
            Region: { type: "builtInParams", name: "region" },
            UseDualStack: { type: "builtInParams", name: "useDualstackEndpoint" },
        };
    }
    resolveMiddleware(clientStack, configuration, options) {
        this.middlewareStack.use((0, middleware_serde_1.getSerdePlugin)(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use((0, middleware_endpoint_1.getEndpointPlugin)(configuration, CopySnapshotCommand.getEndpointParameterInstructions()));
        this.middlewareStack.use((0, middleware_sdk_ec2_1.getCopySnapshotPresignedUrlPlugin)(configuration));
        const stack = clientStack.concat(this.middlewareStack);
        const { logger } = configuration;
        const clientName = "EC2Client";
        const commandName = "CopySnapshotCommand";
        const handlerExecutionContext = {
            logger,
            clientName,
            commandName,
            inputFilterSensitiveLog: models_0_1.CopySnapshotRequestFilterSensitiveLog,
            outputFilterSensitiveLog: models_0_1.CopySnapshotResultFilterSensitiveLog,
        };
        const { requestHandler } = configuration;
        return stack.resolve((request) => requestHandler.handle(request.request, options || {}), handlerExecutionContext);
    }
    serialize(input, context) {
        return (0, Aws_ec2_1.serializeAws_ec2CopySnapshotCommand)(input, context);
    }
    deserialize(output, context) {
        return (0, Aws_ec2_1.deserializeAws_ec2CopySnapshotCommand)(output, context);
    }
}
exports.CopySnapshotCommand = CopySnapshotCommand;
