# Generated by Django 4.1.13 on 2025-09-08 04:51

import django.core.validators
import django.db.models.deletion
from django.conf import settings
from django.db import migrations, models

import simple_oauth2.utils


class Migration(migrations.Migration):
    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name="Session",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("_provider", models.CharField(db_column="provider", max_length=255)),
                (
                    "nonce",
                    models.CharField(default=simple_oauth2.utils.generate_nonce, max_length=255),
                ),
                (
                    "state",
                    models.CharField(default=simple_oauth2.utils.generate_state, max_length=255),
                ),
                (
                    "code_verifier",
                    models.CharField(
                        default=simple_oauth2.utils.generate_code_verifier,
                        max_length=128,
                        validators=[
                            django.core.validators.RegexValidator(
                                message="code_verifier must be 43–128 chars of unreserved URL characters (RFC 7636).",
                                regex="^[A-Za-z0-9\\-._~]{43,128}$",
                            )
                        ],
                    ),
                ),
                (
                    "status",
                    models.CharField(
                        choices=[
                            ("PENDING", "Pending"),
                            ("TOKEN_FAILED", "Token Failed"),
                            ("USERINFO_FAILED", "Userinfo Failed"),
                            ("EXPIRED", "Expired"),
                            ("COMPLETED", "Completed"),
                        ],
                        default="PENDING",
                        max_length=20,
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("completed_at", models.DateTimeField(null=True)),
            ],
        ),
        migrations.CreateModel(
            name="Sub",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("_provider", models.CharField(db_column="provider", max_length=255)),
                ("sub", models.CharField(max_length=255)),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("last_login", models.DateTimeField(auto_now=True)),
                (
                    "user",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
        ),
        migrations.AddIndex(
            model_name="session",
            index=models.Index(fields=["created_at"], name="simple_oaut_created_7c172d_idx"),
        ),
        migrations.AddConstraint(
            model_name="session",
            constraint=models.UniqueConstraint(fields=("_provider", "state"), name="session_provider_state_key"),
        ),
        migrations.AddIndex(
            model_name="sub",
            index=models.Index(fields=["sub"], name="simple_oaut_sub_7eb942_idx"),
        ),
        migrations.AddConstraint(
            model_name="sub",
            constraint=models.UniqueConstraint(fields=("_provider", "sub"), name="sub_provider_sub_key"),
        ),
    ]
