"""
Django settings for {{ project_name }} project.

Based on the Django 3.2 template, with wq-specific modifications noted as such.
Generated by 'wq create' {{ wq_create_version }}.

For more information on this file, see
https://docs.djangoproject.com/en/3.2/topics/settings/

For the full list of settings and their values, see
https://docs.djangoproject.com/en/3.2/ref/settings/

For more information about wq.db's Django settings see
https://wq.io/wq.db/settings

"""

from pathlib import Path

# Build paths inside the project like this: BASE_DIR / 'subdir'.
# wq: extra .parent.parent to account for db/ and settings/ folders
BASE_DIR = Path(__file__).resolve().parent.parent.parent.parent

# wq: SECRET_KEY, DEBUG, and ALLOWED_HOSTS are defined in dev.py/prod.py


# Application definition

INSTALLED_APPS = [
    'django.contrib.admin',
    'django.contrib.auth',
    'django.contrib.contenttypes',
    'django.contrib.sessions',
    'django.contrib.messages',
    'django.contrib.staticfiles',
    {% if not with_gis %}# {% endif %}'django.contrib.gis',
    'rest_framework',

    'wq.db.rest',
    'wq.db.rest.auth',{% if not with_npm %}
    'wq.app',{% endif %}
    'wq.build',

    # Project apps
    '{{ project_name }}_survey',
]

MIDDLEWARE = [
    'django.middleware.security.SecurityMiddleware',
    'django.contrib.sessions.middleware.SessionMiddleware',
    'django.middleware.common.CommonMiddleware',
    'django.middleware.csrf.CsrfViewMiddleware',
    'django.contrib.auth.middleware.AuthenticationMiddleware',
    'django.contrib.messages.middleware.MessageMiddleware',
    'django.middleware.clickjacking.XFrameOptionsMiddleware',
]

ROOT_URLCONF = '{{ project_name }}.urls'

# wq: Leverage wq.db for Django REST Framework defaults
REST_FRAMEWORK = {

    'DEFAULT_RENDERER_CLASSES': (
        'wq.db.rest.renderers.HTMLRenderer',
        'wq.db.rest.renderers.JSONRenderer',
        'wq.db.rest.renderers.GeoJSONRenderer',
    ),

    'DEFAULT_PAGINATION_CLASS': 'wq.db.rest.pagination.Pagination',
    'PAGE_SIZE': 50,

    'DEFAULT_PERMISSION_CLASSES': (
        'wq.db.rest.permissions.ModelPermissions',
    ),

    'DEFAULT_FILTER_BACKENDS': (
        'wq.db.rest.filters.FilterBackend',
    ),

    'DEFAULT_CONTENT_NEGOTIATION_CLASS':
        'wq.db.rest.negotiation.ContentNegotiation'
}

TEMPLATES = [
    {
        'BACKEND': 'django.template.backends.django.DjangoTemplates',
        'DIRS': [],
        'APP_DIRS': True,
        'OPTIONS': {
            'context_processors': [
                'django.template.context_processors.debug',
                'django.template.context_processors.request',
                'django.contrib.auth.context_processors.auth',
                'django.contrib.messages.context_processors.messages',
            ],
        },
    },
]

WSGI_APPLICATION = '{{ project_name }}.wsgi.application'


# wq: DATABASES is defined in dev.py/prod.py

# Password validation
# https://docs.djangoproject.com/en/3.2/ref/settings/#auth-password-validators

AUTH_PASSWORD_VALIDATORS = [
    {
        'NAME': 'django.contrib.auth.password_validation.UserAttributeSimilarityValidator',
    },
    {
        'NAME': 'django.contrib.auth.password_validation.MinimumLengthValidator',
    },
    {
        'NAME': 'django.contrib.auth.password_validation.CommonPasswordValidator',
    },
    {
        'NAME': 'django.contrib.auth.password_validation.NumericPasswordValidator',
    },
]


# Internationalization
# https://docs.djangoproject.com/en/3.2/topics/i18n/

LANGUAGE_CODE = 'en-us'

TIME_ZONE = 'UTC'

USE_I18N = True

USE_L10N = True

USE_TZ = True


# Static files (CSS, JavaScript, Images)
# https://docs.djangoproject.com/en/3.2/howto/static-files/

STATIC_URL = '/static/'
STATICFILES_DIRS = [
    {% if with_npm %}BASE_DIR / 'app' / 'build' / 'static'{% else %}('app', BASE_DIR / 'app'){% endif %},
]

# wq: Configure paths for default project layout
PROJECT_NAME = '{{ title }}'
STATIC_ROOT = BASE_DIR / 'htdocs' / 'static'
MEDIA_ROOT = BASE_DIR / 'media'
WQ_APP_TEMPLATE = BASE_DIR / 'htdocs' / 'index.html'
VERSION_TXT = BASE_DIR / 'version.txt'
MEDIA_URL = '/media/'
WQ_CONFIG = {
    "material": {
        "theme": {
            "primary": "#7500ae",
            "secondary": "#0088bd"
        }
    },
    "map": {
	"bounds": [[-180, -70], [180, 70]]
    }
}

# Default primary key field type
# https://docs.djangoproject.com/en/3.2/ref/settings/#default-auto-field

DEFAULT_AUTO_FIELD = 'django.db.models.BigAutoField'
