# coding: utf-8

"""
    REST API

    Rockset's REST API allows for creating and managing all resources in Rockset. Each supported endpoint is documented below.  All requests must be authorized with a Rockset API key, which can be created in the [Rockset console](https://console.rockset.com). The API key must be provided as `ApiKey <api_key>` in the `Authorization` request header. For example: ``` Authorization: ApiKey aB35kDjg93J5nsf4GjwMeErAVd832F7ad4vhsW1S02kfZiab42sTsfW5Sxt25asT ```  All endpoints are only accessible via https.  Build something awesome!  # noqa: E501

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from rockset.configuration import Configuration


class StatusDynamoDbV2(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'initial_dump_completion_percentage': 'float',
        'state': 'str',
        'stream_last_processed_at': 'str'
    }

    attribute_map = {
        'initial_dump_completion_percentage': 'initial_dump_completion_percentage',
        'state': 'state',
        'stream_last_processed_at': 'stream_last_processed_at'
    }

    def __init__(self, initial_dump_completion_percentage=None, state=None, stream_last_processed_at=None, local_vars_configuration=None):  # noqa: E501
        """StatusDynamoDbV2 - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._initial_dump_completion_percentage = None
        self._state = None
        self._stream_last_processed_at = None
        self.discriminator = None

        if initial_dump_completion_percentage is not None:
            self.initial_dump_completion_percentage = initial_dump_completion_percentage
        if state is not None:
            self.state = state
        if stream_last_processed_at is not None:
            self.stream_last_processed_at = stream_last_processed_at

    @property
    def initial_dump_completion_percentage(self):
        """Gets the initial_dump_completion_percentage of this StatusDynamoDbV2.  # noqa: E501


        :return: The initial_dump_completion_percentage of this StatusDynamoDbV2.  # noqa: E501
        :rtype: float
        """
        return self._initial_dump_completion_percentage

    @initial_dump_completion_percentage.setter
    def initial_dump_completion_percentage(self, initial_dump_completion_percentage):
        """Sets the initial_dump_completion_percentage of this StatusDynamoDbV2.


        :param initial_dump_completion_percentage: The initial_dump_completion_percentage of this StatusDynamoDbV2.  # noqa: E501
        :type initial_dump_completion_percentage: float
        """

        self._initial_dump_completion_percentage = initial_dump_completion_percentage

    @property
    def state(self):
        """Gets the state of this StatusDynamoDbV2.  # noqa: E501

        state of current ingest for this table  # noqa: E501

        :return: The state of this StatusDynamoDbV2.  # noqa: E501
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state):
        """Sets the state of this StatusDynamoDbV2.

        state of current ingest for this table  # noqa: E501

        :param state: The state of this StatusDynamoDbV2.  # noqa: E501
        :type state: str
        """
        allowed_values = ["INITIALIZING", "SCANNING", "EXPORTING_TO_S3", "DOWNLOADING_FROM_S3", "PROCESSING_STREAM"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and state not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `state` ({0}), must be one of {1}"  # noqa: E501
                .format(state, allowed_values)
            )

        self._state = state

    @property
    def stream_last_processed_at(self):
        """Gets the stream_last_processed_at of this StatusDynamoDbV2.  # noqa: E501

        ISO-8601 date when source was last processed  # noqa: E501

        :return: The stream_last_processed_at of this StatusDynamoDbV2.  # noqa: E501
        :rtype: str
        """
        return self._stream_last_processed_at

    @stream_last_processed_at.setter
    def stream_last_processed_at(self, stream_last_processed_at):
        """Sets the stream_last_processed_at of this StatusDynamoDbV2.

        ISO-8601 date when source was last processed  # noqa: E501

        :param stream_last_processed_at: The stream_last_processed_at of this StatusDynamoDbV2.  # noqa: E501
        :type stream_last_processed_at: str
        """

        self._stream_last_processed_at = stream_last_processed_at

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, StatusDynamoDbV2):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, StatusDynamoDbV2):
            return True

        return self.to_dict() != other.to_dict()
