# coding: utf-8

"""
    REST API

    Rockset's REST API allows for creating and managing all resources in Rockset. Each supported endpoint is documented below.  All requests must be authorized with a Rockset API key, which can be created in the [Rockset console](https://console.rockset.com). The API key must be provided as `ApiKey <api_key>` in the `Authorization` request header. For example: ``` Authorization: ApiKey aB35kDjg93J5nsf4GjwMeErAVd832F7ad4vhsW1S02kfZiab42sTsfW5Sxt25asT ```  All endpoints are only accessible via https.  Build something awesome!  # noqa: E501

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from rockset.configuration import Configuration


class SourceDynamoDb(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'aws_region': 'str',
        'current_status': 'StatusDynamoDbV2',
        'rcu': 'int',
        'status': 'StatusDynamoDb',
        'table_name': 'str',
        'use_scan_api': 'bool'
    }

    attribute_map = {
        'aws_region': 'aws_region',
        'current_status': 'current_status',
        'rcu': 'rcu',
        'status': 'status',
        'table_name': 'table_name',
        'use_scan_api': 'use_scan_api'
    }

    def __init__(self, aws_region=None, current_status=None, rcu=None, status=None, table_name=None, use_scan_api=None, local_vars_configuration=None):  # noqa: E501
        """SourceDynamoDb - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._aws_region = None
        self._current_status = None
        self._rcu = None
        self._status = None
        self._table_name = None
        self._use_scan_api = None
        self.discriminator = None

        if aws_region is not None:
            self.aws_region = aws_region
        if current_status is not None:
            self.current_status = current_status
        if rcu is not None:
            self.rcu = rcu
        if status is not None:
            self.status = status
        self.table_name = table_name
        if use_scan_api is not None:
            self.use_scan_api = use_scan_api

    @property
    def aws_region(self):
        """Gets the aws_region of this SourceDynamoDb.  # noqa: E501

        AWS region name of DynamoDB table, by default us-west-2 is used  # noqa: E501

        :return: The aws_region of this SourceDynamoDb.  # noqa: E501
        :rtype: str
        """
        return self._aws_region

    @aws_region.setter
    def aws_region(self, aws_region):
        """Sets the aws_region of this SourceDynamoDb.

        AWS region name of DynamoDB table, by default us-west-2 is used  # noqa: E501

        :param aws_region: The aws_region of this SourceDynamoDb.  # noqa: E501
        :type aws_region: str
        """

        self._aws_region = aws_region

    @property
    def current_status(self):
        """Gets the current_status of this SourceDynamoDb.  # noqa: E501


        :return: The current_status of this SourceDynamoDb.  # noqa: E501
        :rtype: StatusDynamoDbV2
        """
        return self._current_status

    @current_status.setter
    def current_status(self, current_status):
        """Sets the current_status of this SourceDynamoDb.


        :param current_status: The current_status of this SourceDynamoDb.  # noqa: E501
        :type current_status: StatusDynamoDbV2
        """

        self._current_status = current_status

    @property
    def rcu(self):
        """Gets the rcu of this SourceDynamoDb.  # noqa: E501

        Max RCU usage for scan  # noqa: E501

        :return: The rcu of this SourceDynamoDb.  # noqa: E501
        :rtype: int
        """
        return self._rcu

    @rcu.setter
    def rcu(self, rcu):
        """Sets the rcu of this SourceDynamoDb.

        Max RCU usage for scan  # noqa: E501

        :param rcu: The rcu of this SourceDynamoDb.  # noqa: E501
        :type rcu: int
        """

        self._rcu = rcu

    @property
    def status(self):
        """Gets the status of this SourceDynamoDb.  # noqa: E501


        :return: The status of this SourceDynamoDb.  # noqa: E501
        :rtype: StatusDynamoDb
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this SourceDynamoDb.


        :param status: The status of this SourceDynamoDb.  # noqa: E501
        :type status: StatusDynamoDb
        """

        self._status = status

    @property
    def table_name(self):
        """Gets the table_name of this SourceDynamoDb.  # noqa: E501

        name of DynamoDB table containing data  # noqa: E501

        :return: The table_name of this SourceDynamoDb.  # noqa: E501
        :rtype: str
        """
        return self._table_name

    @table_name.setter
    def table_name(self, table_name):
        """Sets the table_name of this SourceDynamoDb.

        name of DynamoDB table containing data  # noqa: E501

        :param table_name: The table_name of this SourceDynamoDb.  # noqa: E501
        :type table_name: str
        """
        if self.local_vars_configuration.client_side_validation and table_name is None:  # noqa: E501
            raise ValueError("Invalid value for `table_name`, must not be `None`")  # noqa: E501

        self._table_name = table_name

    @property
    def use_scan_api(self):
        """Gets the use_scan_api of this SourceDynamoDb.  # noqa: E501

        Whether to use DynamoDB Scan API for the initial scan  # noqa: E501

        :return: The use_scan_api of this SourceDynamoDb.  # noqa: E501
        :rtype: bool
        """
        return self._use_scan_api

    @use_scan_api.setter
    def use_scan_api(self, use_scan_api):
        """Sets the use_scan_api of this SourceDynamoDb.

        Whether to use DynamoDB Scan API for the initial scan  # noqa: E501

        :param use_scan_api: The use_scan_api of this SourceDynamoDb.  # noqa: E501
        :type use_scan_api: bool
        """

        self._use_scan_api = use_scan_api

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SourceDynamoDb):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, SourceDynamoDb):
            return True

        return self.to_dict() != other.to_dict()
