# coding: utf-8

"""
    REST API

    Rockset's REST API allows for creating and managing all resources in Rockset. Each supported endpoint is documented below.  All requests must be authorized with a Rockset API key, which can be created in the [Rockset console](https://console.rockset.com). The API key must be provided as `ApiKey <api_key>` in the `Authorization` request header. For example: ``` Authorization: ApiKey aB35kDjg93J5nsf4GjwMeErAVd832F7ad4vhsW1S02kfZiab42sTsfW5Sxt25asT ```  All endpoints are only accessible via https.  Build something awesome!  # noqa: E501

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from rockset.configuration import Configuration


class Organization(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'clusters': 'list[Cluster]',
        'created_at': 'str',
        'deletion_scheduled_at': 'str',
        'display_name': 'str',
        'external_id': 'str',
        'id': 'str',
        'rockset_user': 'str'
    }

    attribute_map = {
        'clusters': 'clusters',
        'created_at': 'created_at',
        'deletion_scheduled_at': 'deletionScheduledAt',
        'display_name': 'display_name',
        'external_id': 'external_id',
        'id': 'id',
        'rockset_user': 'rockset_user'
    }

    def __init__(self, clusters=None, created_at=None, deletion_scheduled_at=None, display_name=None, external_id=None, id=None, rockset_user=None, local_vars_configuration=None):  # noqa: E501
        """Organization - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._clusters = None
        self._created_at = None
        self._deletion_scheduled_at = None
        self._display_name = None
        self._external_id = None
        self._id = None
        self._rockset_user = None
        self.discriminator = None

        if clusters is not None:
            self.clusters = clusters
        if created_at is not None:
            self.created_at = created_at
        if deletion_scheduled_at is not None:
            self.deletion_scheduled_at = deletion_scheduled_at
        if display_name is not None:
            self.display_name = display_name
        if external_id is not None:
            self.external_id = external_id
        if id is not None:
            self.id = id
        if rockset_user is not None:
            self.rockset_user = rockset_user

    @property
    def clusters(self):
        """Gets the clusters of this Organization.  # noqa: E501

        list of clusters associated with this org  # noqa: E501

        :return: The clusters of this Organization.  # noqa: E501
        :rtype: list[Cluster]
        """
        return self._clusters

    @clusters.setter
    def clusters(self, clusters):
        """Sets the clusters of this Organization.

        list of clusters associated with this org  # noqa: E501

        :param clusters: The clusters of this Organization.  # noqa: E501
        :type clusters: list[Cluster]
        """

        self._clusters = clusters

    @property
    def created_at(self):
        """Gets the created_at of this Organization.  # noqa: E501

        ISO-8601 date  # noqa: E501

        :return: The created_at of this Organization.  # noqa: E501
        :rtype: str
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """Sets the created_at of this Organization.

        ISO-8601 date  # noqa: E501

        :param created_at: The created_at of this Organization.  # noqa: E501
        :type created_at: str
        """

        self._created_at = created_at

    @property
    def deletion_scheduled_at(self):
        """Gets the deletion_scheduled_at of this Organization.  # noqa: E501


        :return: The deletion_scheduled_at of this Organization.  # noqa: E501
        :rtype: str
        """
        return self._deletion_scheduled_at

    @deletion_scheduled_at.setter
    def deletion_scheduled_at(self, deletion_scheduled_at):
        """Sets the deletion_scheduled_at of this Organization.


        :param deletion_scheduled_at: The deletion_scheduled_at of this Organization.  # noqa: E501
        :type deletion_scheduled_at: str
        """

        self._deletion_scheduled_at = deletion_scheduled_at

    @property
    def display_name(self):
        """Gets the display_name of this Organization.  # noqa: E501

        name of the organization  # noqa: E501

        :return: The display_name of this Organization.  # noqa: E501
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """Sets the display_name of this Organization.

        name of the organization  # noqa: E501

        :param display_name: The display_name of this Organization.  # noqa: E501
        :type display_name: str
        """

        self._display_name = display_name

    @property
    def external_id(self):
        """Gets the external_id of this Organization.  # noqa: E501

        organization's unique external ID within Rockset  # noqa: E501

        :return: The external_id of this Organization.  # noqa: E501
        :rtype: str
        """
        return self._external_id

    @external_id.setter
    def external_id(self, external_id):
        """Sets the external_id of this Organization.

        organization's unique external ID within Rockset  # noqa: E501

        :param external_id: The external_id of this Organization.  # noqa: E501
        :type external_id: str
        """

        self._external_id = external_id

    @property
    def id(self):
        """Gets the id of this Organization.  # noqa: E501

        unique identifier for the organization  # noqa: E501

        :return: The id of this Organization.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this Organization.

        unique identifier for the organization  # noqa: E501

        :param id: The id of this Organization.  # noqa: E501
        :type id: str
        """

        self._id = id

    @property
    def rockset_user(self):
        """Gets the rockset_user of this Organization.  # noqa: E501

        Rockset's global AWS user  # noqa: E501

        :return: The rockset_user of this Organization.  # noqa: E501
        :rtype: str
        """
        return self._rockset_user

    @rockset_user.setter
    def rockset_user(self, rockset_user):
        """Sets the rockset_user of this Organization.

        Rockset's global AWS user  # noqa: E501

        :param rockset_user: The rockset_user of this Organization.  # noqa: E501
        :type rockset_user: str
        """

        self._rockset_user = rockset_user

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Organization):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Organization):
            return True

        return self.to_dict() != other.to_dict()
