# coding: utf-8

"""
    REST API

    Rockset's REST API allows for creating and managing all resources in Rockset. Each supported endpoint is documented below.  All requests must be authorized with a Rockset API key, which can be created in the [Rockset console](https://console.rockset.com). The API key must be provided as `ApiKey <api_key>` in the `Authorization` request header. For example: ``` Authorization: ApiKey aB35kDjg93J5nsf4GjwMeErAVd832F7ad4vhsW1S02kfZiab42sTsfW5Sxt25asT ```  All endpoints are only accessible via https.  Build something awesome!  # noqa: E501

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from rockset.configuration import Configuration


class GcsCollectionCreationRequest(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'clustering_key': 'list[FieldPartition]',
        'description': 'str',
        'event_time_info': 'EventTimeInfo',
        'field_mapping_query': 'FieldMappingQuery',
        'field_mappings': 'list[FieldMappingV2]',
        'field_schemas': 'list[FieldSchema]',
        'insert_only': 'bool',
        'inverted_index_group_encoding_options': 'InvertedIndexGroupEncodingOptions',
        'name': 'str',
        'retention_secs': 'int',
        'sources': 'list[GcsSourceWrapper]',
        'time_partition_resolution_secs': 'int'
    }

    attribute_map = {
        'clustering_key': 'clustering_key',
        'description': 'description',
        'event_time_info': 'event_time_info',
        'field_mapping_query': 'field_mapping_query',
        'field_mappings': 'field_mappings',
        'field_schemas': 'field_schemas',
        'insert_only': 'insert_only',
        'inverted_index_group_encoding_options': 'inverted_index_group_encoding_options',
        'name': 'name',
        'retention_secs': 'retention_secs',
        'sources': 'sources',
        'time_partition_resolution_secs': 'time_partition_resolution_secs'
    }

    def __init__(self, clustering_key=None, description=None, event_time_info=None, field_mapping_query=None, field_mappings=None, field_schemas=None, insert_only=None, inverted_index_group_encoding_options=None, name=None, retention_secs=None, sources=None, time_partition_resolution_secs=None, local_vars_configuration=None):  # noqa: E501
        """GcsCollectionCreationRequest - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._clustering_key = None
        self._description = None
        self._event_time_info = None
        self._field_mapping_query = None
        self._field_mappings = None
        self._field_schemas = None
        self._insert_only = None
        self._inverted_index_group_encoding_options = None
        self._name = None
        self._retention_secs = None
        self._sources = None
        self._time_partition_resolution_secs = None
        self.discriminator = None

        if clustering_key is not None:
            self.clustering_key = clustering_key
        if description is not None:
            self.description = description
        if event_time_info is not None:
            self.event_time_info = event_time_info
        if field_mapping_query is not None:
            self.field_mapping_query = field_mapping_query
        if field_mappings is not None:
            self.field_mappings = field_mappings
        if field_schemas is not None:
            self.field_schemas = field_schemas
        if insert_only is not None:
            self.insert_only = insert_only
        if inverted_index_group_encoding_options is not None:
            self.inverted_index_group_encoding_options = inverted_index_group_encoding_options
        self.name = name
        if retention_secs is not None:
            self.retention_secs = retention_secs
        if sources is not None:
            self.sources = sources
        if time_partition_resolution_secs is not None:
            self.time_partition_resolution_secs = time_partition_resolution_secs

    @property
    def clustering_key(self):
        """Gets the clustering_key of this GcsCollectionCreationRequest.  # noqa: E501

        list of clustering fields  # noqa: E501

        :return: The clustering_key of this GcsCollectionCreationRequest.  # noqa: E501
        :rtype: list[FieldPartition]
        """
        return self._clustering_key

    @clustering_key.setter
    def clustering_key(self, clustering_key):
        """Sets the clustering_key of this GcsCollectionCreationRequest.

        list of clustering fields  # noqa: E501

        :param clustering_key: The clustering_key of this GcsCollectionCreationRequest.  # noqa: E501
        :type clustering_key: list[FieldPartition]
        """

        self._clustering_key = clustering_key

    @property
    def description(self):
        """Gets the description of this GcsCollectionCreationRequest.  # noqa: E501

        text describing the collection  # noqa: E501

        :return: The description of this GcsCollectionCreationRequest.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this GcsCollectionCreationRequest.

        text describing the collection  # noqa: E501

        :param description: The description of this GcsCollectionCreationRequest.  # noqa: E501
        :type description: str
        """

        self._description = description

    @property
    def event_time_info(self):
        """Gets the event_time_info of this GcsCollectionCreationRequest.  # noqa: E501


        :return: The event_time_info of this GcsCollectionCreationRequest.  # noqa: E501
        :rtype: EventTimeInfo
        """
        return self._event_time_info

    @event_time_info.setter
    def event_time_info(self, event_time_info):
        """Sets the event_time_info of this GcsCollectionCreationRequest.


        :param event_time_info: The event_time_info of this GcsCollectionCreationRequest.  # noqa: E501
        :type event_time_info: EventTimeInfo
        """

        self._event_time_info = event_time_info

    @property
    def field_mapping_query(self):
        """Gets the field_mapping_query of this GcsCollectionCreationRequest.  # noqa: E501


        :return: The field_mapping_query of this GcsCollectionCreationRequest.  # noqa: E501
        :rtype: FieldMappingQuery
        """
        return self._field_mapping_query

    @field_mapping_query.setter
    def field_mapping_query(self, field_mapping_query):
        """Sets the field_mapping_query of this GcsCollectionCreationRequest.


        :param field_mapping_query: The field_mapping_query of this GcsCollectionCreationRequest.  # noqa: E501
        :type field_mapping_query: FieldMappingQuery
        """

        self._field_mapping_query = field_mapping_query

    @property
    def field_mappings(self):
        """Gets the field_mappings of this GcsCollectionCreationRequest.  # noqa: E501

        list of mappings  # noqa: E501

        :return: The field_mappings of this GcsCollectionCreationRequest.  # noqa: E501
        :rtype: list[FieldMappingV2]
        """
        return self._field_mappings

    @field_mappings.setter
    def field_mappings(self, field_mappings):
        """Sets the field_mappings of this GcsCollectionCreationRequest.

        list of mappings  # noqa: E501

        :param field_mappings: The field_mappings of this GcsCollectionCreationRequest.  # noqa: E501
        :type field_mappings: list[FieldMappingV2]
        """

        self._field_mappings = field_mappings

    @property
    def field_schemas(self):
        """Gets the field_schemas of this GcsCollectionCreationRequest.  # noqa: E501

        list of field schemas  # noqa: E501

        :return: The field_schemas of this GcsCollectionCreationRequest.  # noqa: E501
        :rtype: list[FieldSchema]
        """
        return self._field_schemas

    @field_schemas.setter
    def field_schemas(self, field_schemas):
        """Sets the field_schemas of this GcsCollectionCreationRequest.

        list of field schemas  # noqa: E501

        :param field_schemas: The field_schemas of this GcsCollectionCreationRequest.  # noqa: E501
        :type field_schemas: list[FieldSchema]
        """

        self._field_schemas = field_schemas

    @property
    def insert_only(self):
        """Gets the insert_only of this GcsCollectionCreationRequest.  # noqa: E501

        If true disallows updates and deletes, but makes indexing more efficient  # noqa: E501

        :return: The insert_only of this GcsCollectionCreationRequest.  # noqa: E501
        :rtype: bool
        """
        return self._insert_only

    @insert_only.setter
    def insert_only(self, insert_only):
        """Sets the insert_only of this GcsCollectionCreationRequest.

        If true disallows updates and deletes, but makes indexing more efficient  # noqa: E501

        :param insert_only: The insert_only of this GcsCollectionCreationRequest.  # noqa: E501
        :type insert_only: bool
        """

        self._insert_only = insert_only

    @property
    def inverted_index_group_encoding_options(self):
        """Gets the inverted_index_group_encoding_options of this GcsCollectionCreationRequest.  # noqa: E501


        :return: The inverted_index_group_encoding_options of this GcsCollectionCreationRequest.  # noqa: E501
        :rtype: InvertedIndexGroupEncodingOptions
        """
        return self._inverted_index_group_encoding_options

    @inverted_index_group_encoding_options.setter
    def inverted_index_group_encoding_options(self, inverted_index_group_encoding_options):
        """Sets the inverted_index_group_encoding_options of this GcsCollectionCreationRequest.


        :param inverted_index_group_encoding_options: The inverted_index_group_encoding_options of this GcsCollectionCreationRequest.  # noqa: E501
        :type inverted_index_group_encoding_options: InvertedIndexGroupEncodingOptions
        """

        self._inverted_index_group_encoding_options = inverted_index_group_encoding_options

    @property
    def name(self):
        """Gets the name of this GcsCollectionCreationRequest.  # noqa: E501

        unique identifier for collection, can contain alphanumeric or dash characters  # noqa: E501

        :return: The name of this GcsCollectionCreationRequest.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this GcsCollectionCreationRequest.

        unique identifier for collection, can contain alphanumeric or dash characters  # noqa: E501

        :param name: The name of this GcsCollectionCreationRequest.  # noqa: E501
        :type name: str
        """
        if self.local_vars_configuration.client_side_validation and name is None:  # noqa: E501
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def retention_secs(self):
        """Gets the retention_secs of this GcsCollectionCreationRequest.  # noqa: E501

        number of seconds after which data is purged, based on event time  # noqa: E501

        :return: The retention_secs of this GcsCollectionCreationRequest.  # noqa: E501
        :rtype: int
        """
        return self._retention_secs

    @retention_secs.setter
    def retention_secs(self, retention_secs):
        """Sets the retention_secs of this GcsCollectionCreationRequest.

        number of seconds after which data is purged, based on event time  # noqa: E501

        :param retention_secs: The retention_secs of this GcsCollectionCreationRequest.  # noqa: E501
        :type retention_secs: int
        """

        self._retention_secs = retention_secs

    @property
    def sources(self):
        """Gets the sources of this GcsCollectionCreationRequest.  # noqa: E501

        List of sources from which to ingest data  # noqa: E501

        :return: The sources of this GcsCollectionCreationRequest.  # noqa: E501
        :rtype: list[GcsSourceWrapper]
        """
        return self._sources

    @sources.setter
    def sources(self, sources):
        """Sets the sources of this GcsCollectionCreationRequest.

        List of sources from which to ingest data  # noqa: E501

        :param sources: The sources of this GcsCollectionCreationRequest.  # noqa: E501
        :type sources: list[GcsSourceWrapper]
        """

        self._sources = sources

    @property
    def time_partition_resolution_secs(self):
        """Gets the time_partition_resolution_secs of this GcsCollectionCreationRequest.  # noqa: E501

        If non-null, the collection will be time partitioned and each partition will be time_partition_resolution_secs wide.  # noqa: E501

        :return: The time_partition_resolution_secs of this GcsCollectionCreationRequest.  # noqa: E501
        :rtype: int
        """
        return self._time_partition_resolution_secs

    @time_partition_resolution_secs.setter
    def time_partition_resolution_secs(self, time_partition_resolution_secs):
        """Sets the time_partition_resolution_secs of this GcsCollectionCreationRequest.

        If non-null, the collection will be time partitioned and each partition will be time_partition_resolution_secs wide.  # noqa: E501

        :param time_partition_resolution_secs: The time_partition_resolution_secs of this GcsCollectionCreationRequest.  # noqa: E501
        :type time_partition_resolution_secs: int
        """

        self._time_partition_resolution_secs = time_partition_resolution_secs

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, GcsCollectionCreationRequest):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, GcsCollectionCreationRequest):
            return True

        return self.to_dict() != other.to_dict()
