# coding: utf-8

"""
    REST API

    Rockset's REST API allows for creating and managing all resources in Rockset. Each supported endpoint is documented below.  All requests must be authorized with a Rockset API key, which can be created in the [Rockset console](https://console.rockset.com). The API key must be provided as `ApiKey <api_key>` in the `Authorization` request header. For example: ``` Authorization: ApiKey aB35kDjg93J5nsf4GjwMeErAVd832F7ad4vhsW1S02kfZiab42sTsfW5Sxt25asT ```  All endpoints are only accessible via https.  Build something awesome!  # noqa: E501

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from rockset.configuration import Configuration


class CsvParams(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'column_names': 'list[str]',
        'column_types': 'list[str]',
        'encoding': 'str',
        'escape_char': 'str',
        'first_line_as_column_names': 'bool',
        'quote_char': 'str',
        'separator': 'str'
    }

    attribute_map = {
        'column_names': 'columnNames',
        'column_types': 'columnTypes',
        'encoding': 'encoding',
        'escape_char': 'escapeChar',
        'first_line_as_column_names': 'firstLineAsColumnNames',
        'quote_char': 'quoteChar',
        'separator': 'separator'
    }

    def __init__(self, column_names=None, column_types=None, encoding=None, escape_char=None, first_line_as_column_names=None, quote_char=None, separator=None, local_vars_configuration=None):  # noqa: E501
        """CsvParams - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._column_names = None
        self._column_types = None
        self._encoding = None
        self._escape_char = None
        self._first_line_as_column_names = None
        self._quote_char = None
        self._separator = None
        self.discriminator = None

        if column_names is not None:
            self.column_names = column_names
        if column_types is not None:
            self.column_types = column_types
        if encoding is not None:
            self.encoding = encoding
        if escape_char is not None:
            self.escape_char = escape_char
        if first_line_as_column_names is not None:
            self.first_line_as_column_names = first_line_as_column_names
        if quote_char is not None:
            self.quote_char = quote_char
        if separator is not None:
            self.separator = separator

    @property
    def column_names(self):
        """Gets the column_names of this CsvParams.  # noqa: E501

        names of columns  # noqa: E501

        :return: The column_names of this CsvParams.  # noqa: E501
        :rtype: list[str]
        """
        return self._column_names

    @column_names.setter
    def column_names(self, column_names):
        """Sets the column_names of this CsvParams.

        names of columns  # noqa: E501

        :param column_names: The column_names of this CsvParams.  # noqa: E501
        :type column_names: list[str]
        """

        self._column_names = column_names

    @property
    def column_types(self):
        """Gets the column_types of this CsvParams.  # noqa: E501

        names of columns  # noqa: E501

        :return: The column_types of this CsvParams.  # noqa: E501
        :rtype: list[str]
        """
        return self._column_types

    @column_types.setter
    def column_types(self, column_types):
        """Sets the column_types of this CsvParams.

        names of columns  # noqa: E501

        :param column_types: The column_types of this CsvParams.  # noqa: E501
        :type column_types: list[str]
        """
        allowed_values = ["UNKNOWN", "BOOLEAN", "BOOL", "INTEGER", "INT", "FLOAT", "TIME", "DATE", "DATETIME", "TIMESTAMP", "STRING"]  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                not set(column_types).issubset(set(allowed_values))):  # noqa: E501
            raise ValueError(
                "Invalid values for `column_types` [{0}], must be a subset of [{1}]"  # noqa: E501
                .format(", ".join(map(str, set(column_types) - set(allowed_values))),  # noqa: E501
                        ", ".join(map(str, allowed_values)))
            )

        self._column_types = column_types

    @property
    def encoding(self):
        """Gets the encoding of this CsvParams.  # noqa: E501

        can be one of: UTF-8, ISO_8859_1, UTF-16  # noqa: E501

        :return: The encoding of this CsvParams.  # noqa: E501
        :rtype: str
        """
        return self._encoding

    @encoding.setter
    def encoding(self, encoding):
        """Sets the encoding of this CsvParams.

        can be one of: UTF-8, ISO_8859_1, UTF-16  # noqa: E501

        :param encoding: The encoding of this CsvParams.  # noqa: E501
        :type encoding: str
        """

        self._encoding = encoding

    @property
    def escape_char(self):
        """Gets the escape_char of this CsvParams.  # noqa: E501

        escape character removes any special meaning from the following character,default is '\\'  # noqa: E501

        :return: The escape_char of this CsvParams.  # noqa: E501
        :rtype: str
        """
        return self._escape_char

    @escape_char.setter
    def escape_char(self, escape_char):
        """Sets the escape_char of this CsvParams.

        escape character removes any special meaning from the following character,default is '\\'  # noqa: E501

        :param escape_char: The escape_char of this CsvParams.  # noqa: E501
        :type escape_char: str
        """

        self._escape_char = escape_char

    @property
    def first_line_as_column_names(self):
        """Gets the first_line_as_column_names of this CsvParams.  # noqa: E501

        If the first line in every object specifies the column names  # noqa: E501

        :return: The first_line_as_column_names of this CsvParams.  # noqa: E501
        :rtype: bool
        """
        return self._first_line_as_column_names

    @first_line_as_column_names.setter
    def first_line_as_column_names(self, first_line_as_column_names):
        """Sets the first_line_as_column_names of this CsvParams.

        If the first line in every object specifies the column names  # noqa: E501

        :param first_line_as_column_names: The first_line_as_column_names of this CsvParams.  # noqa: E501
        :type first_line_as_column_names: bool
        """

        self._first_line_as_column_names = first_line_as_column_names

    @property
    def quote_char(self):
        """Gets the quote_char of this CsvParams.  # noqa: E501

        character within which a cell value is enclosed,null character if no such character, default is '\"'  # noqa: E501

        :return: The quote_char of this CsvParams.  # noqa: E501
        :rtype: str
        """
        return self._quote_char

    @quote_char.setter
    def quote_char(self, quote_char):
        """Sets the quote_char of this CsvParams.

        character within which a cell value is enclosed,null character if no such character, default is '\"'  # noqa: E501

        :param quote_char: The quote_char of this CsvParams.  # noqa: E501
        :type quote_char: str
        """

        self._quote_char = quote_char

    @property
    def separator(self):
        """Gets the separator of this CsvParams.  # noqa: E501

        a single character that is the column separator  # noqa: E501

        :return: The separator of this CsvParams.  # noqa: E501
        :rtype: str
        """
        return self._separator

    @separator.setter
    def separator(self, separator):
        """Sets the separator of this CsvParams.

        a single character that is the column separator  # noqa: E501

        :param separator: The separator of this CsvParams.  # noqa: E501
        :type separator: str
        """

        self._separator = separator

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, CsvParams):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, CsvParams):
            return True

        return self.to_dict() != other.to_dict()
