# coding: utf-8

"""
    REST API

    Rockset's REST API allows for creating and managing all resources in Rockset. Each supported endpoint is documented below.  All requests must be authorized with a Rockset API key, which can be created in the [Rockset console](https://console.rockset.com). The API key must be provided as `ApiKey <api_key>` in the `Authorization` request header. For example: ``` Authorization: ApiKey aB35kDjg93J5nsf4GjwMeErAVd832F7ad4vhsW1S02kfZiab42sTsfW5Sxt25asT ```  All endpoints are only accessible via https.  Build something awesome!  # noqa: E501

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from rockset.configuration import Configuration


class CreateIntegrationRequest(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'azure_blob_storage': 'AzureBlobStorageIntegration',
        'azure_event_hub': 'AzEventHubIntegration',
        'description': 'str',
        'dynamodb': 'DynamodbIntegration',
        'gcs': 'GcsIntegration',
        'kafka': 'KafkaIntegration',
        'kinesis': 'KinesisIntegration',
        'mongodb': 'MongoDbIntegration',
        'name': 'str',
        'redshift': 'RedshiftIntegration',
        's3': 'S3Integration',
        'segment': 'SegmentIntegration'
    }

    attribute_map = {
        'azure_blob_storage': 'azure_blob_storage',
        'azure_event_hub': 'azure_event_hub',
        'description': 'description',
        'dynamodb': 'dynamodb',
        'gcs': 'gcs',
        'kafka': 'kafka',
        'kinesis': 'kinesis',
        'mongodb': 'mongodb',
        'name': 'name',
        'redshift': 'redshift',
        's3': 's3',
        'segment': 'segment'
    }

    def __init__(self, azure_blob_storage=None, azure_event_hub=None, description=None, dynamodb=None, gcs=None, kafka=None, kinesis=None, mongodb=None, name=None, redshift=None, s3=None, segment=None, local_vars_configuration=None):  # noqa: E501
        """CreateIntegrationRequest - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._azure_blob_storage = None
        self._azure_event_hub = None
        self._description = None
        self._dynamodb = None
        self._gcs = None
        self._kafka = None
        self._kinesis = None
        self._mongodb = None
        self._name = None
        self._redshift = None
        self._s3 = None
        self._segment = None
        self.discriminator = None

        if azure_blob_storage is not None:
            self.azure_blob_storage = azure_blob_storage
        if azure_event_hub is not None:
            self.azure_event_hub = azure_event_hub
        if description is not None:
            self.description = description
        if dynamodb is not None:
            self.dynamodb = dynamodb
        if gcs is not None:
            self.gcs = gcs
        if kafka is not None:
            self.kafka = kafka
        if kinesis is not None:
            self.kinesis = kinesis
        if mongodb is not None:
            self.mongodb = mongodb
        self.name = name
        if redshift is not None:
            self.redshift = redshift
        if s3 is not None:
            self.s3 = s3
        if segment is not None:
            self.segment = segment

    @property
    def azure_blob_storage(self):
        """Gets the azure_blob_storage of this CreateIntegrationRequest.  # noqa: E501


        :return: The azure_blob_storage of this CreateIntegrationRequest.  # noqa: E501
        :rtype: AzureBlobStorageIntegration
        """
        return self._azure_blob_storage

    @azure_blob_storage.setter
    def azure_blob_storage(self, azure_blob_storage):
        """Sets the azure_blob_storage of this CreateIntegrationRequest.


        :param azure_blob_storage: The azure_blob_storage of this CreateIntegrationRequest.  # noqa: E501
        :type azure_blob_storage: AzureBlobStorageIntegration
        """

        self._azure_blob_storage = azure_blob_storage

    @property
    def azure_event_hub(self):
        """Gets the azure_event_hub of this CreateIntegrationRequest.  # noqa: E501


        :return: The azure_event_hub of this CreateIntegrationRequest.  # noqa: E501
        :rtype: AzEventHubIntegration
        """
        return self._azure_event_hub

    @azure_event_hub.setter
    def azure_event_hub(self, azure_event_hub):
        """Sets the azure_event_hub of this CreateIntegrationRequest.


        :param azure_event_hub: The azure_event_hub of this CreateIntegrationRequest.  # noqa: E501
        :type azure_event_hub: AzEventHubIntegration
        """

        self._azure_event_hub = azure_event_hub

    @property
    def description(self):
        """Gets the description of this CreateIntegrationRequest.  # noqa: E501

        longer explanation for the integration  # noqa: E501

        :return: The description of this CreateIntegrationRequest.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this CreateIntegrationRequest.

        longer explanation for the integration  # noqa: E501

        :param description: The description of this CreateIntegrationRequest.  # noqa: E501
        :type description: str
        """

        self._description = description

    @property
    def dynamodb(self):
        """Gets the dynamodb of this CreateIntegrationRequest.  # noqa: E501


        :return: The dynamodb of this CreateIntegrationRequest.  # noqa: E501
        :rtype: DynamodbIntegration
        """
        return self._dynamodb

    @dynamodb.setter
    def dynamodb(self, dynamodb):
        """Sets the dynamodb of this CreateIntegrationRequest.


        :param dynamodb: The dynamodb of this CreateIntegrationRequest.  # noqa: E501
        :type dynamodb: DynamodbIntegration
        """

        self._dynamodb = dynamodb

    @property
    def gcs(self):
        """Gets the gcs of this CreateIntegrationRequest.  # noqa: E501


        :return: The gcs of this CreateIntegrationRequest.  # noqa: E501
        :rtype: GcsIntegration
        """
        return self._gcs

    @gcs.setter
    def gcs(self, gcs):
        """Sets the gcs of this CreateIntegrationRequest.


        :param gcs: The gcs of this CreateIntegrationRequest.  # noqa: E501
        :type gcs: GcsIntegration
        """

        self._gcs = gcs

    @property
    def kafka(self):
        """Gets the kafka of this CreateIntegrationRequest.  # noqa: E501


        :return: The kafka of this CreateIntegrationRequest.  # noqa: E501
        :rtype: KafkaIntegration
        """
        return self._kafka

    @kafka.setter
    def kafka(self, kafka):
        """Sets the kafka of this CreateIntegrationRequest.


        :param kafka: The kafka of this CreateIntegrationRequest.  # noqa: E501
        :type kafka: KafkaIntegration
        """

        self._kafka = kafka

    @property
    def kinesis(self):
        """Gets the kinesis of this CreateIntegrationRequest.  # noqa: E501


        :return: The kinesis of this CreateIntegrationRequest.  # noqa: E501
        :rtype: KinesisIntegration
        """
        return self._kinesis

    @kinesis.setter
    def kinesis(self, kinesis):
        """Sets the kinesis of this CreateIntegrationRequest.


        :param kinesis: The kinesis of this CreateIntegrationRequest.  # noqa: E501
        :type kinesis: KinesisIntegration
        """

        self._kinesis = kinesis

    @property
    def mongodb(self):
        """Gets the mongodb of this CreateIntegrationRequest.  # noqa: E501


        :return: The mongodb of this CreateIntegrationRequest.  # noqa: E501
        :rtype: MongoDbIntegration
        """
        return self._mongodb

    @mongodb.setter
    def mongodb(self, mongodb):
        """Sets the mongodb of this CreateIntegrationRequest.


        :param mongodb: The mongodb of this CreateIntegrationRequest.  # noqa: E501
        :type mongodb: MongoDbIntegration
        """

        self._mongodb = mongodb

    @property
    def name(self):
        """Gets the name of this CreateIntegrationRequest.  # noqa: E501

        descriptive label  # noqa: E501

        :return: The name of this CreateIntegrationRequest.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this CreateIntegrationRequest.

        descriptive label  # noqa: E501

        :param name: The name of this CreateIntegrationRequest.  # noqa: E501
        :type name: str
        """
        if self.local_vars_configuration.client_side_validation and name is None:  # noqa: E501
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def redshift(self):
        """Gets the redshift of this CreateIntegrationRequest.  # noqa: E501


        :return: The redshift of this CreateIntegrationRequest.  # noqa: E501
        :rtype: RedshiftIntegration
        """
        return self._redshift

    @redshift.setter
    def redshift(self, redshift):
        """Sets the redshift of this CreateIntegrationRequest.


        :param redshift: The redshift of this CreateIntegrationRequest.  # noqa: E501
        :type redshift: RedshiftIntegration
        """

        self._redshift = redshift

    @property
    def s3(self):
        """Gets the s3 of this CreateIntegrationRequest.  # noqa: E501


        :return: The s3 of this CreateIntegrationRequest.  # noqa: E501
        :rtype: S3Integration
        """
        return self._s3

    @s3.setter
    def s3(self, s3):
        """Sets the s3 of this CreateIntegrationRequest.


        :param s3: The s3 of this CreateIntegrationRequest.  # noqa: E501
        :type s3: S3Integration
        """

        self._s3 = s3

    @property
    def segment(self):
        """Gets the segment of this CreateIntegrationRequest.  # noqa: E501


        :return: The segment of this CreateIntegrationRequest.  # noqa: E501
        :rtype: SegmentIntegration
        """
        return self._segment

    @segment.setter
    def segment(self, segment):
        """Sets the segment of this CreateIntegrationRequest.


        :param segment: The segment of this CreateIntegrationRequest.  # noqa: E501
        :type segment: SegmentIntegration
        """

        self._segment = segment

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, CreateIntegrationRequest):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, CreateIntegrationRequest):
            return True

        return self.to_dict() != other.to_dict()
