# coding: utf-8

"""
    REST API

    Rockset's REST API allows for creating and managing all resources in Rockset. Each supported endpoint is documented below.  All requests must be authorized with a Rockset API key, which can be created in the [Rockset console](https://console.rockset.com). The API key must be provided as `ApiKey <api_key>` in the `Authorization` request header. For example: ``` Authorization: ApiKey aB35kDjg93J5nsf4GjwMeErAVd832F7ad4vhsW1S02kfZiab42sTsfW5Sxt25asT ```  All endpoints are only accessible via https.  Build something awesome!  # noqa: E501

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from rockset.configuration import Configuration


class ApiKey(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'created_at': 'str',
        'created_by': 'str',
        'key': 'str',
        'last_access_time': 'str',
        'name': 'str',
        'role': 'str',
        'state': 'str'
    }

    attribute_map = {
        'created_at': 'created_at',
        'created_by': 'created_by',
        'key': 'key',
        'last_access_time': 'last_access_time',
        'name': 'name',
        'role': 'role',
        'state': 'state'
    }

    def __init__(self, created_at=None, created_by=None, key=None, last_access_time=None, name=None, role=None, state=None, local_vars_configuration=None):  # noqa: E501
        """ApiKey - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._created_at = None
        self._created_by = None
        self._key = None
        self._last_access_time = None
        self._name = None
        self._role = None
        self._state = None
        self.discriminator = None

        if created_at is not None:
            self.created_at = created_at
        if created_by is not None:
            self.created_by = created_by
        self.key = key
        if last_access_time is not None:
            self.last_access_time = last_access_time
        self.name = name
        if role is not None:
            self.role = role
        if state is not None:
            self.state = state

    @property
    def created_at(self):
        """Gets the created_at of this ApiKey.  # noqa: E501

        Date that API key was created (ISO-8601 format).  # noqa: E501

        :return: The created_at of this ApiKey.  # noqa: E501
        :rtype: str
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """Sets the created_at of this ApiKey.

        Date that API key was created (ISO-8601 format).  # noqa: E501

        :param created_at: The created_at of this ApiKey.  # noqa: E501
        :type created_at: str
        """

        self._created_at = created_at

    @property
    def created_by(self):
        """Gets the created_by of this ApiKey.  # noqa: E501

        Email of API key owner.  # noqa: E501

        :return: The created_by of this ApiKey.  # noqa: E501
        :rtype: str
        """
        return self._created_by

    @created_by.setter
    def created_by(self, created_by):
        """Sets the created_by of this ApiKey.

        Email of API key owner.  # noqa: E501

        :param created_by: The created_by of this ApiKey.  # noqa: E501
        :type created_by: str
        """

        self._created_by = created_by

    @property
    def key(self):
        """Gets the key of this ApiKey.  # noqa: E501

        API key string of 64 alphanumeric characters.  # noqa: E501

        :return: The key of this ApiKey.  # noqa: E501
        :rtype: str
        """
        return self._key

    @key.setter
    def key(self, key):
        """Sets the key of this ApiKey.

        API key string of 64 alphanumeric characters.  # noqa: E501

        :param key: The key of this ApiKey.  # noqa: E501
        :type key: str
        """
        if self.local_vars_configuration.client_side_validation and key is None:  # noqa: E501
            raise ValueError("Invalid value for `key`, must not be `None`")  # noqa: E501

        self._key = key

    @property
    def last_access_time(self):
        """Gets the last_access_time of this ApiKey.  # noqa: E501

        Date that API key was most recently used (ISO-8601 format).  # noqa: E501

        :return: The last_access_time of this ApiKey.  # noqa: E501
        :rtype: str
        """
        return self._last_access_time

    @last_access_time.setter
    def last_access_time(self, last_access_time):
        """Sets the last_access_time of this ApiKey.

        Date that API key was most recently used (ISO-8601 format).  # noqa: E501

        :param last_access_time: The last_access_time of this ApiKey.  # noqa: E501
        :type last_access_time: str
        """

        self._last_access_time = last_access_time

    @property
    def name(self):
        """Gets the name of this ApiKey.  # noqa: E501

        Name of the API key.  # noqa: E501

        :return: The name of this ApiKey.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this ApiKey.

        Name of the API key.  # noqa: E501

        :param name: The name of this ApiKey.  # noqa: E501
        :type name: str
        """
        if self.local_vars_configuration.client_side_validation and name is None:  # noqa: E501
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def role(self):
        """Gets the role of this ApiKey.  # noqa: E501


        :return: The role of this ApiKey.  # noqa: E501
        :rtype: str
        """
        return self._role

    @role.setter
    def role(self, role):
        """Sets the role of this ApiKey.


        :param role: The role of this ApiKey.  # noqa: E501
        :type role: str
        """

        self._role = role

    @property
    def state(self):
        """Gets the state of this ApiKey.  # noqa: E501

        current state of this key  # noqa: E501

        :return: The state of this ApiKey.  # noqa: E501
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state):
        """Sets the state of this ApiKey.

        current state of this key  # noqa: E501

        :param state: The state of this ApiKey.  # noqa: E501
        :type state: str
        """
        allowed_values = ["ACTIVE", "SUSPENDED"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and state not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `state` ({0}), must be one of {1}"  # noqa: E501
                .format(state, allowed_values)
            )

        self._state = state

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ApiKey):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ApiKey):
            return True

        return self.to_dict() != other.to_dict()
