"""
    REST API

    Rockset's REST API allows for creating and managing all resources in Rockset. Each supported endpoint is documented below.  All requests must be authorized with a Rockset API key, which can be created in the [Rockset console](https://console.rockset.com). The API key must be provided as `ApiKey <api_key>` in the `Authorization` request header. For example: ``` Authorization: ApiKey aB35kDjg93J5nsf4GjwMeErAVd832F7ad4vhsW1S02kfZiab42sTsfW5Sxt25asT ```  All endpoints are only accessible via https.  Build something awesome!  # noqa: E501

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401
import typing  # noqa: F401

import asyncio

from rockset.api_client import ApiClient, Endpoint as _Endpoint
from rockset.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from rockset.model.azure_blob_storage_collection_creation_request import AzureBlobStorageCollectionCreationRequest
from rockset.model.azure_event_hubs_collection_creation_request import AzureEventHubsCollectionCreationRequest
from rockset.model.azure_service_bus_collection_creation_request import AzureServiceBusCollectionCreationRequest
from rockset.model.create_collection_response import CreateCollectionResponse
from rockset.model.delete_collection_response import DeleteCollectionResponse
from rockset.model.dynamodb_collection_creation_request import DynamodbCollectionCreationRequest
from rockset.model.error_model import ErrorModel
from rockset.model.file_upload_collection_creation_request import FileUploadCollectionCreationRequest
from rockset.model.gcs_collection_creation_request import GcsCollectionCreationRequest
from rockset.model.get_collection_response import GetCollectionResponse
from rockset.model.kafka_collection_creation_request import KafkaCollectionCreationRequest
from rockset.model.kinesis_collection_creation_request import KinesisCollectionCreationRequest
from rockset.model.list_collections_response import ListCollectionsResponse
from rockset.model.mongodb_collection_creation_request import MongodbCollectionCreationRequest
from rockset.model.s3_collection_creation_request import S3CollectionCreationRequest
from rockset.models import *


class CollectionsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.create_azure_blob_storage_collection_endpoint = _Endpoint(
            settings={
                'response_type': (CreateCollectionResponse,),
                'auth': [
                    'apikey'
                ],
                'endpoint_path': '/v1/orgs/self/ws/{workspace}/collections#AzureBlobStorage'.split('#')[0],
                'operation_id': 'create_azure_blob_storage_collection',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace',
                    'azure_blob_storage_collection_creation_request',
                ],
                'required': [
                    'workspace',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'workspace':
                        (str,),
                    'azure_blob_storage_collection_creation_request':
                        (AzureBlobStorageCollectionCreationRequest,),
                },
                'attribute_map': {
                    'workspace': 'workspace',
                },
                'location_map': {
                    'workspace': 'path',
                    'azure_blob_storage_collection_creation_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.create_azure_event_hubs_collection_endpoint = _Endpoint(
            settings={
                'response_type': (CreateCollectionResponse,),
                'auth': [
                    'apikey'
                ],
                'endpoint_path': '/v1/orgs/self/ws/{workspace}/collections#AzureEventHubs'.split('#')[0],
                'operation_id': 'create_azure_event_hubs_collection',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace',
                    'azure_event_hubs_collection_creation_request',
                ],
                'required': [
                    'workspace',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'workspace':
                        (str,),
                    'azure_event_hubs_collection_creation_request':
                        (AzureEventHubsCollectionCreationRequest,),
                },
                'attribute_map': {
                    'workspace': 'workspace',
                },
                'location_map': {
                    'workspace': 'path',
                    'azure_event_hubs_collection_creation_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.create_azure_service_bus_collection_endpoint = _Endpoint(
            settings={
                'response_type': (CreateCollectionResponse,),
                'auth': [
                    'apikey'
                ],
                'endpoint_path': '/v1/orgs/self/ws/{workspace}/collections#AzureServiceBus'.split('#')[0],
                'operation_id': 'create_azure_service_bus_collection',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace',
                    'azure_service_bus_collection_creation_request',
                ],
                'required': [
                    'workspace',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'workspace':
                        (str,),
                    'azure_service_bus_collection_creation_request':
                        (AzureServiceBusCollectionCreationRequest,),
                },
                'attribute_map': {
                    'workspace': 'workspace',
                },
                'location_map': {
                    'workspace': 'path',
                    'azure_service_bus_collection_creation_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.create_dynamodb_collection_endpoint = _Endpoint(
            settings={
                'response_type': (CreateCollectionResponse,),
                'auth': [
                    'apikey'
                ],
                'endpoint_path': '/v1/orgs/self/ws/{workspace}/collections#Dynamodb'.split('#')[0],
                'operation_id': 'create_dynamodb_collection',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace',
                    'dynamodb_collection_creation_request',
                ],
                'required': [
                    'workspace',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'workspace':
                        (str,),
                    'dynamodb_collection_creation_request':
                        (DynamodbCollectionCreationRequest,),
                },
                'attribute_map': {
                    'workspace': 'workspace',
                },
                'location_map': {
                    'workspace': 'path',
                    'dynamodb_collection_creation_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.create_file_upload_collection_endpoint = _Endpoint(
            settings={
                'response_type': (CreateCollectionResponse,),
                'auth': [
                    'apikey'
                ],
                'endpoint_path': '/v1/orgs/self/ws/{workspace}/collections#FileUpload'.split('#')[0],
                'operation_id': 'create_file_upload_collection',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace',
                    'file_upload_collection_creation_request',
                ],
                'required': [
                    'workspace',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'workspace':
                        (str,),
                    'file_upload_collection_creation_request':
                        (FileUploadCollectionCreationRequest,),
                },
                'attribute_map': {
                    'workspace': 'workspace',
                },
                'location_map': {
                    'workspace': 'path',
                    'file_upload_collection_creation_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.create_gcs_collection_endpoint = _Endpoint(
            settings={
                'response_type': (CreateCollectionResponse,),
                'auth': [
                    'apikey'
                ],
                'endpoint_path': '/v1/orgs/self/ws/{workspace}/collections#Gcs'.split('#')[0],
                'operation_id': 'create_gcs_collection',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace',
                    'gcs_collection_creation_request',
                ],
                'required': [
                    'workspace',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'workspace':
                        (str,),
                    'gcs_collection_creation_request':
                        (GcsCollectionCreationRequest,),
                },
                'attribute_map': {
                    'workspace': 'workspace',
                },
                'location_map': {
                    'workspace': 'path',
                    'gcs_collection_creation_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.create_kafka_collection_endpoint = _Endpoint(
            settings={
                'response_type': (CreateCollectionResponse,),
                'auth': [
                    'apikey'
                ],
                'endpoint_path': '/v1/orgs/self/ws/{workspace}/collections#Kafka'.split('#')[0],
                'operation_id': 'create_kafka_collection',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace',
                    'kafka_collection_creation_request',
                ],
                'required': [
                    'workspace',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'workspace':
                        (str,),
                    'kafka_collection_creation_request':
                        (KafkaCollectionCreationRequest,),
                },
                'attribute_map': {
                    'workspace': 'workspace',
                },
                'location_map': {
                    'workspace': 'path',
                    'kafka_collection_creation_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.create_kinesis_collection_endpoint = _Endpoint(
            settings={
                'response_type': (CreateCollectionResponse,),
                'auth': [
                    'apikey'
                ],
                'endpoint_path': '/v1/orgs/self/ws/{workspace}/collections#Kinesis'.split('#')[0],
                'operation_id': 'create_kinesis_collection',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace',
                    'kinesis_collection_creation_request',
                ],
                'required': [
                    'workspace',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'workspace':
                        (str,),
                    'kinesis_collection_creation_request':
                        (KinesisCollectionCreationRequest,),
                },
                'attribute_map': {
                    'workspace': 'workspace',
                },
                'location_map': {
                    'workspace': 'path',
                    'kinesis_collection_creation_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.create_mongodb_collection_endpoint = _Endpoint(
            settings={
                'response_type': (CreateCollectionResponse,),
                'auth': [
                    'apikey'
                ],
                'endpoint_path': '/v1/orgs/self/ws/{workspace}/collections#Mongodb'.split('#')[0],
                'operation_id': 'create_mongodb_collection',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace',
                    'mongodb_collection_creation_request',
                ],
                'required': [
                    'workspace',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'workspace':
                        (str,),
                    'mongodb_collection_creation_request':
                        (MongodbCollectionCreationRequest,),
                },
                'attribute_map': {
                    'workspace': 'workspace',
                },
                'location_map': {
                    'workspace': 'path',
                    'mongodb_collection_creation_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.create_s3_collection_endpoint = _Endpoint(
            settings={
                'response_type': (CreateCollectionResponse,),
                'auth': [
                    'apikey'
                ],
                'endpoint_path': '/v1/orgs/self/ws/{workspace}/collections#S3'.split('#')[0],
                'operation_id': 'create_s3_collection',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace',
                    's3_collection_creation_request',
                ],
                'required': [
                    'workspace',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'workspace':
                        (str,),
                    's3_collection_creation_request':
                        (S3CollectionCreationRequest,),
                },
                'attribute_map': {
                    'workspace': 'workspace',
                },
                'location_map': {
                    'workspace': 'path',
                    's3_collection_creation_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.delete_collection_endpoint = _Endpoint(
            settings={
                'response_type': (DeleteCollectionResponse,),
                'auth': [
                    'apikey'
                ],
                'endpoint_path': '/v1/orgs/self/ws/{workspace}/collections/{collection}'.split('#')[0],
                'operation_id': 'delete_collection',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace',
                    'collection',
                ],
                'required': [
                    'workspace',
                    'collection',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'workspace':
                        (str,),
                    'collection':
                        (str,),
                },
                'attribute_map': {
                    'workspace': 'workspace',
                    'collection': 'collection',
                },
                'location_map': {
                    'workspace': 'path',
                    'collection': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_collection_endpoint = _Endpoint(
            settings={
                'response_type': (GetCollectionResponse,),
                'auth': [
                    'apikey'
                ],
                'endpoint_path': '/v1/orgs/self/ws/{workspace}/collections/{collection}'.split('#')[0],
                'operation_id': 'get_collection',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace',
                    'collection',
                ],
                'required': [
                    'workspace',
                    'collection',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'workspace':
                        (str,),
                    'collection':
                        (str,),
                },
                'attribute_map': {
                    'workspace': 'workspace',
                    'collection': 'collection',
                },
                'location_map': {
                    'workspace': 'path',
                    'collection': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_collections_endpoint = _Endpoint(
            settings={
                'response_type': (ListCollectionsResponse,),
                'auth': [
                    'apikey'
                ],
                'endpoint_path': '/v1/orgs/self/collections'.split('#')[0],
                'operation_id': 'list_collections',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                },
                'attribute_map': {
                },
                'location_map': {
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.workspace_collections_endpoint = _Endpoint(
            settings={
                'response_type': (ListCollectionsResponse,),
                'auth': [
                    'apikey'
                ],
                'endpoint_path': '/v1/orgs/self/ws/{workspace}/collections'.split('#')[0],
                'operation_id': 'workspace_collections',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace',
                ],
                'required': [
                    'workspace',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'workspace':
                        (str,),
                },
                'attribute_map': {
                    'workspace': 'workspace',
                },
                'location_map': {
                    'workspace': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

    def create_azure_blob_storage_collection(
        self,
        *,
        name: str,
        clustering_key: typing.Sequence[FieldPartition] = None,
        description: str = None,
        event_time_info: EventTimeInfo = None,
        field_mapping_query: FieldMappingQuery = None,
        field_mappings: typing.Sequence[FieldMappingV2] = None,
        insert_only: bool = None,
        retention_secs: int = None,
        sources: typing.Sequence[AzureBlobStorageSourceWrapper] = None,
        workspace = "commons",
        **kwargs
    ) -> typing.Union[CreateCollectionResponse, asyncio.Future]:
        """Create azure blob storage collection  # noqa: E501

        Create new collection in a workspace.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        ```python
        rs = RocksetClient(apikey=APIKEY)
        future = rs.CollectionsApi.create_azure_blob_storage_collection(
            clustering_key=[
                FieldPartition(
                    field_name="address.city.zipcode",
                    keys=["value1","value2"],
                    type="AUTO",
                ),
            ],
            description="transactions from stores worldwide",
            event_time_info=EventTimeInfo(
                field="timestamp",
                format="seconds_since_epoch",
                time_zone="UTC",
            ),
            field_mapping_query=FieldMappingQuery(
                sql="sql",
            ),
            field_mappings=[
                FieldMappingV2(
                    input_fields=[
                        InputField(
                            field_name="address.city.zipcode",
                            if_missing="SKIP",
                            is_drop=True,
                            param="zip",
                        ),
                    ],
                    is_drop_all_fields=True,
                    name="myTestMapping",
                    output_field=OutputField(
                        field_name="zip_hash",
                        on_error="SKIP",
                        value=SqlExpression(
                            sql="SHA256()",
                        ),
                    ),
                ),
            ],
            insert_only=True,
            name="global-transactions",
            retention_secs=1000000,
            sources=[
                AzureBlobStorageSourceWrapper(
                    azure_blob_storage=SourceAzureBlobStorage(
                        container="server-logs",
                        pattern="prefix/to/**/keys/*.format",
                        prefix="prefix/to/blobs",
                    ),
                    format_params=FormatParams(
                        csv=CsvParams(
                            column_names=["c1","c2","c3"],
                            column_types=["BOOLEAN","INTEGER","FLOAT","STRING"],
                            encoding="UTF-8",
                            escape_char="\\",
                            first_line_as_column_names=True,
                            quote_char="\"",
                            separator=",",
                        ),
                        json=True,
                        mssql_dms=True,
                        mysql_dms=True,
                        oracle_dms=True,
                        postgres_dms=True,
                        xml=XmlParams(
                            attribute_prefix="_attr",
                            doc_tag="row",
                            encoding="UTF-8",
                            root_tag="root",
                            value_tag="value",
                        ),
                    ),
                    integration_name="aws-integration",
                ),
            ],
            async_req=True,
        )
        result = await future
        ```

        Keyword Args:
            workspace (str): name of the workspace. [required] if omitted the server will use the default value of "commons"
            clustering_key ([FieldPartition]): list of clustering fields. [optional]
            description (str): text describing the collection. [optional]
            event_time_info (EventTimeInfo): [optional]
            field_mapping_query (FieldMappingQuery): [optional]
            field_mappings ([FieldMappingV2]): list of mappings. [optional]
            insert_only (bool): If true disallows updates and deletes, but makes indexing more efficient. [optional]
            name (str): unique identifier for collection, can contain alphanumeric or dash characters. [required]
            retention_secs (int): number of seconds after which data is purged, based on event time. [optional]
            sources ([AzureBlobStorageSourceWrapper]): List of sources from which to ingest data. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is False.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            CreateCollectionResponse
                If the method is called asynchronously, returns an asyncio.Future which resolves to the response.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', False
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['workspace'] = \
            workspace
        kwargs['azure_blob_storage_collection_creation_request'] = \
            kwargs['azure_blob_storage_collection_creation_request']
        return self.create_azure_blob_storage_collection_endpoint.call_with_http_info(**kwargs)

    def create_azure_event_hubs_collection(
        self,
        *,
        name: str,
        clustering_key: typing.Sequence[FieldPartition] = None,
        description: str = None,
        event_time_info: EventTimeInfo = None,
        field_mapping_query: FieldMappingQuery = None,
        field_mappings: typing.Sequence[FieldMappingV2] = None,
        insert_only: bool = None,
        retention_secs: int = None,
        sources: typing.Sequence[AzureEventHubsSourceWrapper] = None,
        workspace = "commons",
        **kwargs
    ) -> typing.Union[CreateCollectionResponse, asyncio.Future]:
        """Create azure event hubs collection  # noqa: E501

        Create new collection in a workspace.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        ```python
        rs = RocksetClient(apikey=APIKEY)
        future = rs.CollectionsApi.create_azure_event_hubs_collection(
            clustering_key=[
                FieldPartition(
                    field_name="address.city.zipcode",
                    keys=["value1","value2"],
                    type="AUTO",
                ),
            ],
            description="transactions from stores worldwide",
            event_time_info=EventTimeInfo(
                field="timestamp",
                format="seconds_since_epoch",
                time_zone="UTC",
            ),
            field_mapping_query=FieldMappingQuery(
                sql="sql",
            ),
            field_mappings=[
                FieldMappingV2(
                    input_fields=[
                        InputField(
                            field_name="address.city.zipcode",
                            if_missing="SKIP",
                            is_drop=True,
                            param="zip",
                        ),
                    ],
                    is_drop_all_fields=True,
                    name="myTestMapping",
                    output_field=OutputField(
                        field_name="zip_hash",
                        on_error="SKIP",
                        value=SqlExpression(
                            sql="SHA256()",
                        ),
                    ),
                ),
            ],
            insert_only=True,
            name="global-transactions",
            retention_secs=1000000,
            sources=[
                AzureEventHubsSourceWrapper(
                    azure_event_hubs=SourceAzureEventHubs(
                        hub_id="event-hub-1",
                        offset_reset_policy="EARLIEST",
                    ),
                    format_params=FormatParams(
                        csv=CsvParams(
                            column_names=["c1","c2","c3"],
                            column_types=["BOOLEAN","INTEGER","FLOAT","STRING"],
                            encoding="UTF-8",
                            escape_char="\\",
                            first_line_as_column_names=True,
                            quote_char="\"",
                            separator=",",
                        ),
                        json=True,
                        mssql_dms=True,
                        mysql_dms=True,
                        oracle_dms=True,
                        postgres_dms=True,
                        xml=XmlParams(
                            attribute_prefix="_attr",
                            doc_tag="row",
                            encoding="UTF-8",
                            root_tag="root",
                            value_tag="value",
                        ),
                    ),
                    integration_name="aws-integration",
                ),
            ],
            async_req=True,
        )
        result = await future
        ```

        Keyword Args:
            workspace (str): name of the workspace. [required] if omitted the server will use the default value of "commons"
            clustering_key ([FieldPartition]): list of clustering fields. [optional]
            description (str): text describing the collection. [optional]
            event_time_info (EventTimeInfo): [optional]
            field_mapping_query (FieldMappingQuery): [optional]
            field_mappings ([FieldMappingV2]): list of mappings. [optional]
            insert_only (bool): If true disallows updates and deletes, but makes indexing more efficient. [optional]
            name (str): unique identifier for collection, can contain alphanumeric or dash characters. [required]
            retention_secs (int): number of seconds after which data is purged, based on event time. [optional]
            sources ([AzureEventHubsSourceWrapper]): List of sources from which to ingest data. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is False.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            CreateCollectionResponse
                If the method is called asynchronously, returns an asyncio.Future which resolves to the response.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', False
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['workspace'] = \
            workspace
        kwargs['azure_event_hubs_collection_creation_request'] = \
            kwargs['azure_event_hubs_collection_creation_request']
        return self.create_azure_event_hubs_collection_endpoint.call_with_http_info(**kwargs)

    def create_azure_service_bus_collection(
        self,
        *,
        name: str,
        clustering_key: typing.Sequence[FieldPartition] = None,
        description: str = None,
        event_time_info: EventTimeInfo = None,
        field_mapping_query: FieldMappingQuery = None,
        field_mappings: typing.Sequence[FieldMappingV2] = None,
        insert_only: bool = None,
        retention_secs: int = None,
        sources: typing.Sequence[AzureServiceBusSourceWrapper] = None,
        workspace = "commons",
        **kwargs
    ) -> typing.Union[CreateCollectionResponse, asyncio.Future]:
        """Create azure service bus collection  # noqa: E501

        Create new collection in a workspace.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        ```python
        rs = RocksetClient(apikey=APIKEY)
        future = rs.CollectionsApi.create_azure_service_bus_collection(
            clustering_key=[
                FieldPartition(
                    field_name="address.city.zipcode",
                    keys=["value1","value2"],
                    type="AUTO",
                ),
            ],
            description="transactions from stores worldwide",
            event_time_info=EventTimeInfo(
                field="timestamp",
                format="seconds_since_epoch",
                time_zone="UTC",
            ),
            field_mapping_query=FieldMappingQuery(
                sql="sql",
            ),
            field_mappings=[
                FieldMappingV2(
                    input_fields=[
                        InputField(
                            field_name="address.city.zipcode",
                            if_missing="SKIP",
                            is_drop=True,
                            param="zip",
                        ),
                    ],
                    is_drop_all_fields=True,
                    name="myTestMapping",
                    output_field=OutputField(
                        field_name="zip_hash",
                        on_error="SKIP",
                        value=SqlExpression(
                            sql="SHA256()",
                        ),
                    ),
                ),
            ],
            insert_only=True,
            name="global-transactions",
            retention_secs=1000000,
            sources=[
                AzureServiceBusSourceWrapper(
                    azure_service_bus=SourceAzureServiceBus(
                        subscription="rockset-subscription",
                        topic="rockset-topic",
                    ),
                    format_params=FormatParams(
                        csv=CsvParams(
                            column_names=["c1","c2","c3"],
                            column_types=["BOOLEAN","INTEGER","FLOAT","STRING"],
                            encoding="UTF-8",
                            escape_char="\\",
                            first_line_as_column_names=True,
                            quote_char="\"",
                            separator=",",
                        ),
                        json=True,
                        mssql_dms=True,
                        mysql_dms=True,
                        oracle_dms=True,
                        postgres_dms=True,
                        xml=XmlParams(
                            attribute_prefix="_attr",
                            doc_tag="row",
                            encoding="UTF-8",
                            root_tag="root",
                            value_tag="value",
                        ),
                    ),
                    integration_name="aws-integration",
                ),
            ],
            async_req=True,
        )
        result = await future
        ```

        Keyword Args:
            workspace (str): name of the workspace. [required] if omitted the server will use the default value of "commons"
            clustering_key ([FieldPartition]): list of clustering fields. [optional]
            description (str): text describing the collection. [optional]
            event_time_info (EventTimeInfo): [optional]
            field_mapping_query (FieldMappingQuery): [optional]
            field_mappings ([FieldMappingV2]): list of mappings. [optional]
            insert_only (bool): If true disallows updates and deletes, but makes indexing more efficient. [optional]
            name (str): unique identifier for collection, can contain alphanumeric or dash characters. [required]
            retention_secs (int): number of seconds after which data is purged, based on event time. [optional]
            sources ([AzureServiceBusSourceWrapper]): List of sources from which to ingest data. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is False.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            CreateCollectionResponse
                If the method is called asynchronously, returns an asyncio.Future which resolves to the response.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', False
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['workspace'] = \
            workspace
        kwargs['azure_service_bus_collection_creation_request'] = \
            kwargs['azure_service_bus_collection_creation_request']
        return self.create_azure_service_bus_collection_endpoint.call_with_http_info(**kwargs)

    def create_dynamodb_collection(
        self,
        *,
        name: str,
        clustering_key: typing.Sequence[FieldPartition] = None,
        description: str = None,
        event_time_info: EventTimeInfo = None,
        field_mapping_query: FieldMappingQuery = None,
        field_mappings: typing.Sequence[FieldMappingV2] = None,
        insert_only: bool = None,
        retention_secs: int = None,
        sources: typing.Sequence[DynamodbSourceWrapper] = None,
        workspace = "commons",
        **kwargs
    ) -> typing.Union[CreateCollectionResponse, asyncio.Future]:
        """Create dynamodb collection  # noqa: E501

        Create new collection in a workspace.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        ```python
        rs = RocksetClient(apikey=APIKEY)
        future = rs.CollectionsApi.create_dynamodb_collection(
            clustering_key=[
                FieldPartition(
                    field_name="address.city.zipcode",
                    keys=["value1","value2"],
                    type="AUTO",
                ),
            ],
            description="transactions from stores worldwide",
            event_time_info=EventTimeInfo(
                field="timestamp",
                format="seconds_since_epoch",
                time_zone="UTC",
            ),
            field_mapping_query=FieldMappingQuery(
                sql="sql",
            ),
            field_mappings=[
                FieldMappingV2(
                    input_fields=[
                        InputField(
                            field_name="address.city.zipcode",
                            if_missing="SKIP",
                            is_drop=True,
                            param="zip",
                        ),
                    ],
                    is_drop_all_fields=True,
                    name="myTestMapping",
                    output_field=OutputField(
                        field_name="zip_hash",
                        on_error="SKIP",
                        value=SqlExpression(
                            sql="SHA256()",
                        ),
                    ),
                ),
            ],
            insert_only=True,
            name="global-transactions",
            retention_secs=1000000,
            sources=[
                DynamodbSourceWrapper(
                    dynamodb=SourceDynamoDb(
                        aws_region="us-east-2",
                        rcu=1000,
                        table_name="dynamodb_table_name",
                        use_scan_api=True,
                    ),
                    format_params=FormatParams(
                        csv=CsvParams(
                            column_names=["c1","c2","c3"],
                            column_types=["BOOLEAN","INTEGER","FLOAT","STRING"],
                            encoding="UTF-8",
                            escape_char="\\",
                            first_line_as_column_names=True,
                            quote_char="\"",
                            separator=",",
                        ),
                        json=True,
                        mssql_dms=True,
                        mysql_dms=True,
                        oracle_dms=True,
                        postgres_dms=True,
                        xml=XmlParams(
                            attribute_prefix="_attr",
                            doc_tag="row",
                            encoding="UTF-8",
                            root_tag="root",
                            value_tag="value",
                        ),
                    ),
                    integration_name="aws-integration",
                ),
            ],
            async_req=True,
        )
        result = await future
        ```

        Keyword Args:
            workspace (str): name of the workspace. [required] if omitted the server will use the default value of "commons"
            clustering_key ([FieldPartition]): list of clustering fields. [optional]
            description (str): text describing the collection. [optional]
            event_time_info (EventTimeInfo): [optional]
            field_mapping_query (FieldMappingQuery): [optional]
            field_mappings ([FieldMappingV2]): list of mappings. [optional]
            insert_only (bool): If true disallows updates and deletes, but makes indexing more efficient. [optional]
            name (str): unique identifier for collection, can contain alphanumeric or dash characters. [required]
            retention_secs (int): number of seconds after which data is purged, based on event time. [optional]
            sources ([DynamodbSourceWrapper]): List of sources from which to ingest data. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is False.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            CreateCollectionResponse
                If the method is called asynchronously, returns an asyncio.Future which resolves to the response.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', False
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['workspace'] = \
            workspace
        kwargs['dynamodb_collection_creation_request'] = \
            kwargs['dynamodb_collection_creation_request']
        return self.create_dynamodb_collection_endpoint.call_with_http_info(**kwargs)

    def create_file_upload_collection(
        self,
        *,
        name: str,
        clustering_key: typing.Sequence[FieldPartition] = None,
        description: str = None,
        event_time_info: EventTimeInfo = None,
        field_mapping_query: FieldMappingQuery = None,
        field_mappings: typing.Sequence[FieldMappingV2] = None,
        insert_only: bool = None,
        retention_secs: int = None,
        sources: typing.Sequence[FileUploadSourceWrapper] = None,
        workspace = "commons",
        **kwargs
    ) -> typing.Union[CreateCollectionResponse, asyncio.Future]:
        """Create file upload collection  # noqa: E501

        Create new collection in a workspace.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        ```python
        rs = RocksetClient(apikey=APIKEY)
        future = rs.CollectionsApi.create_file_upload_collection(
            clustering_key=[
                FieldPartition(
                    field_name="address.city.zipcode",
                    keys=["value1","value2"],
                    type="AUTO",
                ),
            ],
            description="transactions from stores worldwide",
            event_time_info=EventTimeInfo(
                field="timestamp",
                format="seconds_since_epoch",
                time_zone="UTC",
            ),
            field_mapping_query=FieldMappingQuery(
                sql="sql",
            ),
            field_mappings=[
                FieldMappingV2(
                    input_fields=[
                        InputField(
                            field_name="address.city.zipcode",
                            if_missing="SKIP",
                            is_drop=True,
                            param="zip",
                        ),
                    ],
                    is_drop_all_fields=True,
                    name="myTestMapping",
                    output_field=OutputField(
                        field_name="zip_hash",
                        on_error="SKIP",
                        value=SqlExpression(
                            sql="SHA256()",
                        ),
                    ),
                ),
            ],
            insert_only=True,
            name="global-transactions",
            retention_secs=1000000,
            sources=[
                FileUploadSourceWrapper(
                    file_upload=SourceFileUpload(
                        file_name="file1.json",
                        file_size=12345,
                        file_upload_time="2019-01-15T21:48:23Z",
                    ),
                    format_params=FormatParams(
                        csv=CsvParams(
                            column_names=["c1","c2","c3"],
                            column_types=["BOOLEAN","INTEGER","FLOAT","STRING"],
                            encoding="UTF-8",
                            escape_char="\\",
                            first_line_as_column_names=True,
                            quote_char="\"",
                            separator=",",
                        ),
                        json=True,
                        mssql_dms=True,
                        mysql_dms=True,
                        oracle_dms=True,
                        postgres_dms=True,
                        xml=XmlParams(
                            attribute_prefix="_attr",
                            doc_tag="row",
                            encoding="UTF-8",
                            root_tag="root",
                            value_tag="value",
                        ),
                    ),
                    integration_name="aws-integration",
                ),
            ],
            async_req=True,
        )
        result = await future
        ```

        Keyword Args:
            workspace (str): name of the workspace. [required] if omitted the server will use the default value of "commons"
            clustering_key ([FieldPartition]): list of clustering fields. [optional]
            description (str): text describing the collection. [optional]
            event_time_info (EventTimeInfo): [optional]
            field_mapping_query (FieldMappingQuery): [optional]
            field_mappings ([FieldMappingV2]): list of mappings. [optional]
            insert_only (bool): If true disallows updates and deletes, but makes indexing more efficient. [optional]
            name (str): unique identifier for collection, can contain alphanumeric or dash characters. [required]
            retention_secs (int): number of seconds after which data is purged, based on event time. [optional]
            sources ([FileUploadSourceWrapper]): List of sources from which to ingest data. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is False.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            CreateCollectionResponse
                If the method is called asynchronously, returns an asyncio.Future which resolves to the response.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', False
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['workspace'] = \
            workspace
        kwargs['file_upload_collection_creation_request'] = \
            kwargs['file_upload_collection_creation_request']
        return self.create_file_upload_collection_endpoint.call_with_http_info(**kwargs)

    def create_gcs_collection(
        self,
        *,
        name: str,
        clustering_key: typing.Sequence[FieldPartition] = None,
        description: str = None,
        event_time_info: EventTimeInfo = None,
        field_mapping_query: FieldMappingQuery = None,
        field_mappings: typing.Sequence[FieldMappingV2] = None,
        insert_only: bool = None,
        retention_secs: int = None,
        sources: typing.Sequence[GcsSourceWrapper] = None,
        workspace = "commons",
        **kwargs
    ) -> typing.Union[CreateCollectionResponse, asyncio.Future]:
        """Create gcs collection  # noqa: E501

        Create new collection in a workspace.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        ```python
        rs = RocksetClient(apikey=APIKEY)
        future = rs.CollectionsApi.create_gcs_collection(
            clustering_key=[
                FieldPartition(
                    field_name="address.city.zipcode",
                    keys=["value1","value2"],
                    type="AUTO",
                ),
            ],
            description="transactions from stores worldwide",
            event_time_info=EventTimeInfo(
                field="timestamp",
                format="seconds_since_epoch",
                time_zone="UTC",
            ),
            field_mapping_query=FieldMappingQuery(
                sql="sql",
            ),
            field_mappings=[
                FieldMappingV2(
                    input_fields=[
                        InputField(
                            field_name="address.city.zipcode",
                            if_missing="SKIP",
                            is_drop=True,
                            param="zip",
                        ),
                    ],
                    is_drop_all_fields=True,
                    name="myTestMapping",
                    output_field=OutputField(
                        field_name="zip_hash",
                        on_error="SKIP",
                        value=SqlExpression(
                            sql="SHA256()",
                        ),
                    ),
                ),
            ],
            insert_only=True,
            name="global-transactions",
            retention_secs=1000000,
            sources=[
                GcsSourceWrapper(
                    format_params=FormatParams(
                        csv=CsvParams(
                            column_names=["c1","c2","c3"],
                            column_types=["BOOLEAN","INTEGER","FLOAT","STRING"],
                            encoding="UTF-8",
                            escape_char="\\",
                            first_line_as_column_names=True,
                            quote_char="\"",
                            separator=",",
                        ),
                        json=True,
                        mssql_dms=True,
                        mysql_dms=True,
                        oracle_dms=True,
                        postgres_dms=True,
                        xml=XmlParams(
                            attribute_prefix="_attr",
                            doc_tag="row",
                            encoding="UTF-8",
                            root_tag="root",
                            value_tag="value",
                        ),
                    ),
                    gcs=SourceGcs(
                        bucket="server-logs",
                        pattern="prefix/to/**/keys/*.format",
                        prefix="prefix/to/keys",
                    ),
                    integration_name="aws-integration",
                ),
            ],
            async_req=True,
        )
        result = await future
        ```

        Keyword Args:
            workspace (str): name of the workspace. [required] if omitted the server will use the default value of "commons"
            clustering_key ([FieldPartition]): list of clustering fields. [optional]
            description (str): text describing the collection. [optional]
            event_time_info (EventTimeInfo): [optional]
            field_mapping_query (FieldMappingQuery): [optional]
            field_mappings ([FieldMappingV2]): list of mappings. [optional]
            insert_only (bool): If true disallows updates and deletes, but makes indexing more efficient. [optional]
            name (str): unique identifier for collection, can contain alphanumeric or dash characters. [required]
            retention_secs (int): number of seconds after which data is purged, based on event time. [optional]
            sources ([GcsSourceWrapper]): List of sources from which to ingest data. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is False.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            CreateCollectionResponse
                If the method is called asynchronously, returns an asyncio.Future which resolves to the response.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', False
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['workspace'] = \
            workspace
        kwargs['gcs_collection_creation_request'] = \
            kwargs['gcs_collection_creation_request']
        return self.create_gcs_collection_endpoint.call_with_http_info(**kwargs)

    def create_kafka_collection(
        self,
        *,
        name: str,
        clustering_key: typing.Sequence[FieldPartition] = None,
        description: str = None,
        event_time_info: EventTimeInfo = None,
        field_mapping_query: FieldMappingQuery = None,
        field_mappings: typing.Sequence[FieldMappingV2] = None,
        insert_only: bool = None,
        retention_secs: int = None,
        sources: typing.Sequence[KafkaSourceWrapper] = None,
        workspace = "commons",
        **kwargs
    ) -> typing.Union[CreateCollectionResponse, asyncio.Future]:
        """Create kafka collection  # noqa: E501

        Create new collection in a workspace.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        ```python
        rs = RocksetClient(apikey=APIKEY)
        future = rs.CollectionsApi.create_kafka_collection(
            clustering_key=[
                FieldPartition(
                    field_name="address.city.zipcode",
                    keys=["value1","value2"],
                    type="AUTO",
                ),
            ],
            description="transactions from stores worldwide",
            event_time_info=EventTimeInfo(
                field="timestamp",
                format="seconds_since_epoch",
                time_zone="UTC",
            ),
            field_mapping_query=FieldMappingQuery(
                sql="sql",
            ),
            field_mappings=[
                FieldMappingV2(
                    input_fields=[
                        InputField(
                            field_name="address.city.zipcode",
                            if_missing="SKIP",
                            is_drop=True,
                            param="zip",
                        ),
                    ],
                    is_drop_all_fields=True,
                    name="myTestMapping",
                    output_field=OutputField(
                        field_name="zip_hash",
                        on_error="SKIP",
                        value=SqlExpression(
                            sql="SHA256()",
                        ),
                    ),
                ),
            ],
            insert_only=True,
            name="global-transactions",
            retention_secs=1000000,
            sources=[
                KafkaSourceWrapper(
                    format_params=FormatParams(
                        csv=CsvParams(
                            column_names=["c1","c2","c3"],
                            column_types=["BOOLEAN","INTEGER","FLOAT","STRING"],
                            encoding="UTF-8",
                            escape_char="\\",
                            first_line_as_column_names=True,
                            quote_char="\"",
                            separator=",",
                        ),
                        json=True,
                        mssql_dms=True,
                        mysql_dms=True,
                        oracle_dms=True,
                        postgres_dms=True,
                        xml=XmlParams(
                            attribute_prefix="_attr",
                            doc_tag="row",
                            encoding="UTF-8",
                            root_tag="root",
                            value_tag="value",
                        ),
                    ),
                    integration_name="aws-integration",
                    kafka=SourceKafka(
                        kafka_topic_name="example-topic",
                        offset_reset_policy="LATEST",
                        use_v3=True,
                    ),
                ),
            ],
            async_req=True,
        )
        result = await future
        ```

        Keyword Args:
            workspace (str): name of the workspace. [required] if omitted the server will use the default value of "commons"
            clustering_key ([FieldPartition]): list of clustering fields. [optional]
            description (str): text describing the collection. [optional]
            event_time_info (EventTimeInfo): [optional]
            field_mapping_query (FieldMappingQuery): [optional]
            field_mappings ([FieldMappingV2]): list of mappings. [optional]
            insert_only (bool): If true disallows updates and deletes, but makes indexing more efficient. [optional]
            name (str): unique identifier for collection, can contain alphanumeric or dash characters. [required]
            retention_secs (int): number of seconds after which data is purged, based on event time. [optional]
            sources ([KafkaSourceWrapper]): List of sources from which to ingest data. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is False.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            CreateCollectionResponse
                If the method is called asynchronously, returns an asyncio.Future which resolves to the response.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', False
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['workspace'] = \
            workspace
        kwargs['kafka_collection_creation_request'] = \
            kwargs['kafka_collection_creation_request']
        return self.create_kafka_collection_endpoint.call_with_http_info(**kwargs)

    def create_kinesis_collection(
        self,
        *,
        name: str,
        clustering_key: typing.Sequence[FieldPartition] = None,
        description: str = None,
        event_time_info: EventTimeInfo = None,
        field_mapping_query: FieldMappingQuery = None,
        field_mappings: typing.Sequence[FieldMappingV2] = None,
        insert_only: bool = None,
        retention_secs: int = None,
        sources: typing.Sequence[KinesisStorageSourceWrapper] = None,
        workspace = "commons",
        **kwargs
    ) -> typing.Union[CreateCollectionResponse, asyncio.Future]:
        """Create kinesis collection  # noqa: E501

        Create new collection in a workspace.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        ```python
        rs = RocksetClient(apikey=APIKEY)
        future = rs.CollectionsApi.create_kinesis_collection(
            clustering_key=[
                FieldPartition(
                    field_name="address.city.zipcode",
                    keys=["value1","value2"],
                    type="AUTO",
                ),
            ],
            description="transactions from stores worldwide",
            event_time_info=EventTimeInfo(
                field="timestamp",
                format="seconds_since_epoch",
                time_zone="UTC",
            ),
            field_mapping_query=FieldMappingQuery(
                sql="sql",
            ),
            field_mappings=[
                FieldMappingV2(
                    input_fields=[
                        InputField(
                            field_name="address.city.zipcode",
                            if_missing="SKIP",
                            is_drop=True,
                            param="zip",
                        ),
                    ],
                    is_drop_all_fields=True,
                    name="myTestMapping",
                    output_field=OutputField(
                        field_name="zip_hash",
                        on_error="SKIP",
                        value=SqlExpression(
                            sql="SHA256()",
                        ),
                    ),
                ),
            ],
            insert_only=True,
            name="global-transactions",
            retention_secs=1000000,
            sources=[
                KinesisStorageSourceWrapper(
                    format_params=FormatParams(
                        csv=CsvParams(
                            column_names=["c1","c2","c3"],
                            column_types=["BOOLEAN","INTEGER","FLOAT","STRING"],
                            encoding="UTF-8",
                            escape_char="\\",
                            first_line_as_column_names=True,
                            quote_char="\"",
                            separator=",",
                        ),
                        json=True,
                        mssql_dms=True,
                        mysql_dms=True,
                        oracle_dms=True,
                        postgres_dms=True,
                        xml=XmlParams(
                            attribute_prefix="_attr",
                            doc_tag="row",
                            encoding="UTF-8",
                            root_tag="root",
                            value_tag="value",
                        ),
                    ),
                    integration_name="aws-integration",
                    kinesis=SourceKinesis(
                        aws_region="us-east-2",
                        dms_primary_key=[
                            "dms_primary_key_example",
                        ],
                        offset_reset_policy="EARLIEST",
                        stream_name="click_stream",
                    ),
                ),
            ],
            async_req=True,
        )
        result = await future
        ```

        Keyword Args:
            workspace (str): name of the workspace. [required] if omitted the server will use the default value of "commons"
            clustering_key ([FieldPartition]): list of clustering fields. [optional]
            description (str): text describing the collection. [optional]
            event_time_info (EventTimeInfo): [optional]
            field_mapping_query (FieldMappingQuery): [optional]
            field_mappings ([FieldMappingV2]): list of mappings. [optional]
            insert_only (bool): If true disallows updates and deletes, but makes indexing more efficient. [optional]
            name (str): unique identifier for collection, can contain alphanumeric or dash characters. [required]
            retention_secs (int): number of seconds after which data is purged, based on event time. [optional]
            sources ([KinesisStorageSourceWrapper]): List of sources from which to ingest data. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is False.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            CreateCollectionResponse
                If the method is called asynchronously, returns an asyncio.Future which resolves to the response.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', False
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['workspace'] = \
            workspace
        kwargs['kinesis_collection_creation_request'] = \
            kwargs['kinesis_collection_creation_request']
        return self.create_kinesis_collection_endpoint.call_with_http_info(**kwargs)

    def create_mongodb_collection(
        self,
        *,
        name: str,
        clustering_key: typing.Sequence[FieldPartition] = None,
        description: str = None,
        event_time_info: EventTimeInfo = None,
        field_mapping_query: FieldMappingQuery = None,
        field_mappings: typing.Sequence[FieldMappingV2] = None,
        insert_only: bool = None,
        retention_secs: int = None,
        sources: typing.Sequence[MongodbSourceWrapper] = None,
        workspace = "commons",
        **kwargs
    ) -> typing.Union[CreateCollectionResponse, asyncio.Future]:
        """Create mongodb collection  # noqa: E501

        Create new collection in a workspace.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        ```python
        rs = RocksetClient(apikey=APIKEY)
        future = rs.CollectionsApi.create_mongodb_collection(
            clustering_key=[
                FieldPartition(
                    field_name="address.city.zipcode",
                    keys=["value1","value2"],
                    type="AUTO",
                ),
            ],
            description="transactions from stores worldwide",
            event_time_info=EventTimeInfo(
                field="timestamp",
                format="seconds_since_epoch",
                time_zone="UTC",
            ),
            field_mapping_query=FieldMappingQuery(
                sql="sql",
            ),
            field_mappings=[
                FieldMappingV2(
                    input_fields=[
                        InputField(
                            field_name="address.city.zipcode",
                            if_missing="SKIP",
                            is_drop=True,
                            param="zip",
                        ),
                    ],
                    is_drop_all_fields=True,
                    name="myTestMapping",
                    output_field=OutputField(
                        field_name="zip_hash",
                        on_error="SKIP",
                        value=SqlExpression(
                            sql="SHA256()",
                        ),
                    ),
                ),
            ],
            insert_only=True,
            name="global-transactions",
            retention_secs=1000000,
            sources=[
                MongodbSourceWrapper(
                    format_params=FormatParams(
                        csv=CsvParams(
                            column_names=["c1","c2","c3"],
                            column_types=["BOOLEAN","INTEGER","FLOAT","STRING"],
                            encoding="UTF-8",
                            escape_char="\\",
                            first_line_as_column_names=True,
                            quote_char="\"",
                            separator=",",
                        ),
                        json=True,
                        mssql_dms=True,
                        mysql_dms=True,
                        oracle_dms=True,
                        postgres_dms=True,
                        xml=XmlParams(
                            attribute_prefix="_attr",
                            doc_tag="row",
                            encoding="UTF-8",
                            root_tag="root",
                            value_tag="value",
                        ),
                    ),
                    integration_name="aws-integration",
                    mongodb=SourceMongoDb(
                        collection_name="my_collection",
                        database_name="my_database",
                    ),
                ),
            ],
            async_req=True,
        )
        result = await future
        ```

        Keyword Args:
            workspace (str): name of the workspace. [required] if omitted the server will use the default value of "commons"
            clustering_key ([FieldPartition]): list of clustering fields. [optional]
            description (str): text describing the collection. [optional]
            event_time_info (EventTimeInfo): [optional]
            field_mapping_query (FieldMappingQuery): [optional]
            field_mappings ([FieldMappingV2]): list of mappings. [optional]
            insert_only (bool): If true disallows updates and deletes, but makes indexing more efficient. [optional]
            name (str): unique identifier for collection, can contain alphanumeric or dash characters. [required]
            retention_secs (int): number of seconds after which data is purged, based on event time. [optional]
            sources ([MongodbSourceWrapper]): List of sources from which to ingest data. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is False.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            CreateCollectionResponse
                If the method is called asynchronously, returns an asyncio.Future which resolves to the response.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', False
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['workspace'] = \
            workspace
        kwargs['mongodb_collection_creation_request'] = \
            kwargs['mongodb_collection_creation_request']
        return self.create_mongodb_collection_endpoint.call_with_http_info(**kwargs)

    def create_s3_collection(
        self,
        *,
        name: str,
        clustering_key: typing.Sequence[FieldPartition] = None,
        description: str = None,
        event_time_info: EventTimeInfo = None,
        field_mapping_query: FieldMappingQuery = None,
        field_mappings: typing.Sequence[FieldMappingV2] = None,
        insert_only: bool = None,
        retention_secs: int = None,
        sources: typing.Sequence[S3SourceWrapper] = None,
        workspace = "commons",
        **kwargs
    ) -> typing.Union[CreateCollectionResponse, asyncio.Future]:
        """Create s3 collection  # noqa: E501

        Create new collection in a workspace.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        ```python
        rs = RocksetClient(apikey=APIKEY)
        future = rs.CollectionsApi.create_s3_collection(
            clustering_key=[
                FieldPartition(
                    field_name="address.city.zipcode",
                    keys=["value1","value2"],
                    type="AUTO",
                ),
            ],
            description="transactions from stores worldwide",
            event_time_info=EventTimeInfo(
                field="timestamp",
                format="seconds_since_epoch",
                time_zone="UTC",
            ),
            field_mapping_query=FieldMappingQuery(
                sql="sql",
            ),
            field_mappings=[
                FieldMappingV2(
                    input_fields=[
                        InputField(
                            field_name="address.city.zipcode",
                            if_missing="SKIP",
                            is_drop=True,
                            param="zip",
                        ),
                    ],
                    is_drop_all_fields=True,
                    name="myTestMapping",
                    output_field=OutputField(
                        field_name="zip_hash",
                        on_error="SKIP",
                        value=SqlExpression(
                            sql="SHA256()",
                        ),
                    ),
                ),
            ],
            insert_only=True,
            name="global-transactions",
            retention_secs=1000000,
            sources=[
                S3SourceWrapper(
                    format_params=FormatParams(
                        csv=CsvParams(
                            column_names=["c1","c2","c3"],
                            column_types=["BOOLEAN","INTEGER","FLOAT","STRING"],
                            encoding="UTF-8",
                            escape_char="\\",
                            first_line_as_column_names=True,
                            quote_char="\"",
                            separator=",",
                        ),
                        json=True,
                        mssql_dms=True,
                        mysql_dms=True,
                        oracle_dms=True,
                        postgres_dms=True,
                        xml=XmlParams(
                            attribute_prefix="_attr",
                            doc_tag="row",
                            encoding="UTF-8",
                            root_tag="root",
                            value_tag="value",
                        ),
                    ),
                    integration_name="aws-integration",
                    s3=SourceS3(
                        bucket="s3://customer-account-info",
                        pattern="prefix/to/**/keys/*.format",
                        prefix="prefix/to/keys",
                        region="us-west-2",
                    ),
                ),
            ],
            async_req=True,
        )
        result = await future
        ```

        Keyword Args:
            workspace (str): name of the workspace. [required] if omitted the server will use the default value of "commons"
            clustering_key ([FieldPartition]): list of clustering fields. [optional]
            description (str): text describing the collection. [optional]
            event_time_info (EventTimeInfo): [optional]
            field_mapping_query (FieldMappingQuery): [optional]
            field_mappings ([FieldMappingV2]): list of mappings. [optional]
            insert_only (bool): If true disallows updates and deletes, but makes indexing more efficient. [optional]
            name (str): unique identifier for collection, can contain alphanumeric or dash characters. [required]
            retention_secs (int): number of seconds after which data is purged, based on event time. [optional]
            sources ([S3SourceWrapper]): List of sources from which to ingest data. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is False.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            CreateCollectionResponse
                If the method is called asynchronously, returns an asyncio.Future which resolves to the response.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', False
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['workspace'] = \
            workspace
        kwargs['s3_collection_creation_request'] = \
            kwargs['s3_collection_creation_request']
        return self.create_s3_collection_endpoint.call_with_http_info(**kwargs)

    def delete_collection(
        self,
        *,
        collection: str,
        workspace = "commons",
        **kwargs
    ) -> typing.Union[DeleteCollectionResponse, asyncio.Future]:
        """Delete Collection  # noqa: E501

        Delete a collection and all its documents from Rockset.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        ```python
        rs = RocksetClient(apikey=APIKEY)
        future = rs.CollectionsApi.delete_collection(
            collection="collection_example",
            async_req=True,
        )
        result = await future
        ```

        Keyword Args:
            workspace (str): name of the workspace. [required] if omitted the server will use the default value of "commons"
            collection (str): name of the collection. [required]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is False.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            DeleteCollectionResponse
                If the method is called asynchronously, returns an asyncio.Future which resolves to the response.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', False
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['workspace'] = \
            workspace
        kwargs['collection'] = \
            collection
        return self.delete_collection_endpoint.call_with_http_info(**kwargs)

    def get_collection(
        self,
        *,
        collection: str,
        workspace = "commons",
        **kwargs
    ) -> typing.Union[GetCollectionResponse, asyncio.Future]:
        """Retrieve Collection  # noqa: E501

        Get details about a collection.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        ```python
        rs = RocksetClient(apikey=APIKEY)
        future = rs.CollectionsApi.get_collection(
            collection="collection_example",
            async_req=True,
        )
        result = await future
        ```

        Keyword Args:
            workspace (str): name of the workspace. [required] if omitted the server will use the default value of "commons"
            collection (str): name of the collection. [required]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is False.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            GetCollectionResponse
                If the method is called asynchronously, returns an asyncio.Future which resolves to the response.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', False
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['workspace'] = \
            workspace
        kwargs['collection'] = \
            collection
        return self.get_collection_endpoint.call_with_http_info(**kwargs)

    def list_collections(
        self,
        **kwargs
    ) -> typing.Union[ListCollectionsResponse, asyncio.Future]:
        """List Collections  # noqa: E501

        Retrieve all collections in an organization.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        ```python
        rs = RocksetClient(apikey=APIKEY)
        future = rs.CollectionsApi.list_collections(
            async_req=True,
        )
        result = await future
        ```

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is False.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            ListCollectionsResponse
                If the method is called asynchronously, returns an asyncio.Future which resolves to the response.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', False
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.list_collections_endpoint.call_with_http_info(**kwargs)

    def workspace_collections(
        self,
        *,
        workspace = "commons",
        **kwargs
    ) -> typing.Union[ListCollectionsResponse, asyncio.Future]:
        """List Collections in Workspace  # noqa: E501

        Retrieve all collections in a workspace.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        ```python
        rs = RocksetClient(apikey=APIKEY)
        future = rs.CollectionsApi.workspace_collections(
            async_req=True,
        )
        result = await future
        ```

        Keyword Args:
            workspace (str): name of the workspace. [required] if omitted the server will use the default value of "commons"
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is False.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            ListCollectionsResponse
                If the method is called asynchronously, returns an asyncio.Future which resolves to the response.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', False
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['workspace'] = \
            workspace
        return self.workspace_collections_endpoint.call_with_http_info(**kwargs)


    body_params_dict = dict()
    return_types_dict = dict()
    body_params_dict['create_azure_blob_storage_collection'] = 'azure_blob_storage_collection_creation_request'
    return_types_dict['create_azure_blob_storage_collection'] = AzureBlobStorageCollectionCreationRequest
    body_params_dict['create_azure_event_hubs_collection'] = 'azure_event_hubs_collection_creation_request'
    return_types_dict['create_azure_event_hubs_collection'] = AzureEventHubsCollectionCreationRequest
    body_params_dict['create_azure_service_bus_collection'] = 'azure_service_bus_collection_creation_request'
    return_types_dict['create_azure_service_bus_collection'] = AzureServiceBusCollectionCreationRequest
    body_params_dict['create_dynamodb_collection'] = 'dynamodb_collection_creation_request'
    return_types_dict['create_dynamodb_collection'] = DynamodbCollectionCreationRequest
    body_params_dict['create_file_upload_collection'] = 'file_upload_collection_creation_request'
    return_types_dict['create_file_upload_collection'] = FileUploadCollectionCreationRequest
    body_params_dict['create_gcs_collection'] = 'gcs_collection_creation_request'
    return_types_dict['create_gcs_collection'] = GcsCollectionCreationRequest
    body_params_dict['create_kafka_collection'] = 'kafka_collection_creation_request'
    return_types_dict['create_kafka_collection'] = KafkaCollectionCreationRequest
    body_params_dict['create_kinesis_collection'] = 'kinesis_collection_creation_request'
    return_types_dict['create_kinesis_collection'] = KinesisCollectionCreationRequest
    body_params_dict['create_mongodb_collection'] = 'mongodb_collection_creation_request'
    return_types_dict['create_mongodb_collection'] = MongodbCollectionCreationRequest
    body_params_dict['create_s3_collection'] = 's3_collection_creation_request'
    return_types_dict['create_s3_collection'] = S3CollectionCreationRequest
