import cv2
from yolov7 import detect_document
import sys

sys.path.insert(0, "./yolov7")

class Document:
    """
    A class for representing documents.

    :param name: The name of the document.
    :type name: str
    """

    def __init__(self, name):
        self.name = name

    def get_name(self):
        """
        Get the name of the document.

        :return: The name of the document.
        :rtype: str
        """

        return self.name

    def get_bounding_box(self):
        """
        Use an object detection model to get bounding boxes for titles, text, figures, lists, and tables in the document.

        :return: A list of bounding boxes of the document.
        :rtype: list
        """
        image = cv2.imread(self.name)
        return detect_document(image)


if __name__ == "__main__":
    document = Document("/home/connor/Development/MachineLearning/document-platform/py-doc/py_doc/yolov7/test.jpg")
    print(document.get_bounding_box())
    