<a id="mypy-boto3-appflow"></a>

# mypy-boto3-appflow

[![PyPI - mypy-boto3-appflow](https://img.shields.io/pypi/v/mypy-boto3-appflow.svg?color=blue)](https://pypi.org/project/mypy-boto3-appflow)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-appflow.svg?color=blue)](https://pypi.org/project/mypy-boto3-appflow)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)
[![PyPI - Downloads](https://img.shields.io/pypi/dw/mypy-boto3-appflow?color=blue)](https://pypistats.org/packages/mypy-boto3-appflow)

![boto3.typed](https://github.com/vemel/mypy_boto3_builder/raw/master/logo.png)

Type annotations for
[boto3.Appflow 1.17.107](https://boto3.amazonaws.com/v1/documentation/api/1.17.107/reference/services/appflow.html#Appflow)
service compatible with [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright) and other tools.

Generated by
[mypy-boto3-buider 4.22.1](https://github.com/vemel/mypy_boto3_builder).

More information can be found on
[boto3-stubs](https://pypi.org/project/boto3-stubs/) page and in
[mypy-boto3-appflow docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_appflow/)

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/vemel/mypy_boto3_builder/raw/master/demo.gif)

- [mypy-boto3-appflow](#mypy-boto3-appflow)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Literals](#literals)
    - [Typed dictionaries](#typed-dictionaries)
  - [Versioning](#versioning)
  - [Documentation](#documentation)
  - [Support and contributing](#support-and-contributing)

<a id="how-to-install"></a>

## How to install

Install `boto3-stubs` for `Appflow` service.

```bash
python -m pip install boto3-stubs[appflow]
```

<a id="usage"></a>

## Usage

<a id="vscode"></a>

### VSCode

- Install
  [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install
  [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[appflow]` in your environment:
  `python -m pip install 'boto3-stubs[appflow]'`

Both type checking and auto-complete should work for `Appflow` service. No
explicit type annotations required, write your `boto3` code as usual.

<a id="pycharm"></a>

### PyCharm

- Install `boto-stubs[appflow]` in your environment:
  `python -m pip install 'boto3-stubs[appflow]'`

Both type checking and auto-complete should work for `Appflow` service. No
explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed
`boto3-stubs` submodules.

<a id="other-ides"></a>

### Other IDEs

Not tested, but as long as your IDE support `mypy` or `pyright`, everything
should work.

<a id="mypy"></a>

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[appflow]` in your environment:
  `python -m pip install 'boto3-stubs[appflow]'`
- Run `mypy` as usual

Type checking should work for `Appflow` service. No explicit type annotations
required, write your `boto3` code as usual.

<a id="pyright"></a>

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[appflow]` in your environment:
  `python -m pip install 'boto3-stubs[appflow]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `Appflow` service. No explicit type annotations
required, write your `boto3` code as usual.

<a id="explicit-type-annotations"></a>

## Explicit type annotations

<a id="client-annotations"></a>

### Client annotations

`AppflowClient` provides annotations for `boto3.client("appflow")`.

```python
import boto3

from mypy_boto3_appflow import AppflowClient

client: AppflowClient = boto3.client("appflow")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: AppflowClient = session.client("appflow")
```

<a id="literals"></a>

### Literals

`mypy_boto3_appflow.literals` module contains literals extracted from shapes
that can be used in user code for type checking.

```python
from mypy_boto3_appflow.literals import (
    AggregationTypeType,
    AmplitudeConnectorOperatorType,
    ConnectionModeType,
    ConnectorTypeType,
    DataPullModeType,
    DatadogConnectorOperatorType,
    DynatraceConnectorOperatorType,
    ExecutionStatusType,
    FileTypeType,
    FlowStatusType,
    GoogleAnalyticsConnectorOperatorType,
    InforNexusConnectorOperatorType,
    MarketoConnectorOperatorType,
    OperatorPropertiesKeysType,
    OperatorType,
    PrefixFormatType,
    PrefixTypeType,
    S3ConnectorOperatorType,
    SalesforceConnectorOperatorType,
    ScheduleFrequencyTypeType,
    ServiceNowConnectorOperatorType,
    SingularConnectorOperatorType,
    SlackConnectorOperatorType,
    TaskTypeType,
    TrendmicroConnectorOperatorType,
    TriggerTypeType,
    VeevaConnectorOperatorType,
    WriteOperationTypeType,
    ZendeskConnectorOperatorType,
)

def check_value(value: AggregationTypeType) -> bool:
    ...
```

<a id="typed-dictionaries"></a>

### Typed dictionaries

`mypy_boto3_appflow.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python
from mypy_boto3_appflow.type_defs import (
    AggregationConfigTypeDef,
    AmplitudeConnectorProfileCredentialsTypeDef,
    AmplitudeSourcePropertiesTypeDef,
    ConnectorConfigurationTypeDef,
    ConnectorEntityFieldTypeDef,
    ConnectorEntityTypeDef,
    ConnectorMetadataTypeDef,
    ConnectorOAuthRequestTypeDef,
    ConnectorOperatorTypeDef,
    ConnectorProfileConfigTypeDef,
    ConnectorProfileCredentialsTypeDef,
    ConnectorProfilePropertiesTypeDef,
    ConnectorProfileTypeDef,
    CreateConnectorProfileRequestRequestTypeDef,
    CreateConnectorProfileResponseTypeDef,
    CreateFlowRequestRequestTypeDef,
    CreateFlowResponseTypeDef,
    CustomerProfilesDestinationPropertiesTypeDef,
    DatadogConnectorProfileCredentialsTypeDef,
    DatadogConnectorProfilePropertiesTypeDef,
    DatadogSourcePropertiesTypeDef,
    DeleteConnectorProfileRequestRequestTypeDef,
    DeleteFlowRequestRequestTypeDef,
    DescribeConnectorEntityRequestRequestTypeDef,
    DescribeConnectorEntityResponseTypeDef,
    DescribeConnectorProfilesRequestRequestTypeDef,
    DescribeConnectorProfilesResponseTypeDef,
    DescribeConnectorsRequestRequestTypeDef,
    DescribeConnectorsResponseTypeDef,
    DescribeFlowExecutionRecordsRequestRequestTypeDef,
    DescribeFlowExecutionRecordsResponseTypeDef,
    DescribeFlowRequestRequestTypeDef,
    DescribeFlowResponseTypeDef,
    DestinationConnectorPropertiesTypeDef,
    DestinationFieldPropertiesTypeDef,
    DestinationFlowConfigTypeDef,
    DynatraceConnectorProfileCredentialsTypeDef,
    DynatraceConnectorProfilePropertiesTypeDef,
    DynatraceSourcePropertiesTypeDef,
    ErrorHandlingConfigTypeDef,
    ErrorInfoTypeDef,
    EventBridgeDestinationPropertiesTypeDef,
    ExecutionDetailsTypeDef,
    ExecutionRecordTypeDef,
    ExecutionResultTypeDef,
    FieldTypeDetailsTypeDef,
    FlowDefinitionTypeDef,
    GoogleAnalyticsConnectorProfileCredentialsTypeDef,
    GoogleAnalyticsMetadataTypeDef,
    GoogleAnalyticsSourcePropertiesTypeDef,
    HoneycodeConnectorProfileCredentialsTypeDef,
    HoneycodeDestinationPropertiesTypeDef,
    HoneycodeMetadataTypeDef,
    IncrementalPullConfigTypeDef,
    InforNexusConnectorProfileCredentialsTypeDef,
    InforNexusConnectorProfilePropertiesTypeDef,
    InforNexusSourcePropertiesTypeDef,
    ListConnectorEntitiesRequestRequestTypeDef,
    ListConnectorEntitiesResponseTypeDef,
    ListFlowsRequestRequestTypeDef,
    ListFlowsResponseTypeDef,
    ListTagsForResourceRequestRequestTypeDef,
    ListTagsForResourceResponseTypeDef,
    MarketoConnectorProfileCredentialsTypeDef,
    MarketoConnectorProfilePropertiesTypeDef,
    MarketoSourcePropertiesTypeDef,
    PrefixConfigTypeDef,
    RedshiftConnectorProfileCredentialsTypeDef,
    RedshiftConnectorProfilePropertiesTypeDef,
    RedshiftDestinationPropertiesTypeDef,
    ResponseMetadataTypeDef,
    S3DestinationPropertiesTypeDef,
    S3OutputFormatConfigTypeDef,
    S3SourcePropertiesTypeDef,
    SalesforceConnectorProfileCredentialsTypeDef,
    SalesforceConnectorProfilePropertiesTypeDef,
    SalesforceDestinationPropertiesTypeDef,
    SalesforceMetadataTypeDef,
    SalesforceSourcePropertiesTypeDef,
    ScheduledTriggerPropertiesTypeDef,
    ServiceNowConnectorProfileCredentialsTypeDef,
    ServiceNowConnectorProfilePropertiesTypeDef,
    ServiceNowSourcePropertiesTypeDef,
    SingularConnectorProfileCredentialsTypeDef,
    SingularSourcePropertiesTypeDef,
    SlackConnectorProfileCredentialsTypeDef,
    SlackConnectorProfilePropertiesTypeDef,
    SlackMetadataTypeDef,
    SlackSourcePropertiesTypeDef,
    SnowflakeConnectorProfileCredentialsTypeDef,
    SnowflakeConnectorProfilePropertiesTypeDef,
    SnowflakeDestinationPropertiesTypeDef,
    SnowflakeMetadataTypeDef,
    SourceConnectorPropertiesTypeDef,
    SourceFieldPropertiesTypeDef,
    SourceFlowConfigTypeDef,
    StartFlowRequestRequestTypeDef,
    StartFlowResponseTypeDef,
    StopFlowRequestRequestTypeDef,
    StopFlowResponseTypeDef,
    SupportedFieldTypeDetailsTypeDef,
    TagResourceRequestRequestTypeDef,
    TaskTypeDef,
    TrendmicroConnectorProfileCredentialsTypeDef,
    TrendmicroSourcePropertiesTypeDef,
    TriggerConfigTypeDef,
    TriggerPropertiesTypeDef,
    UntagResourceRequestRequestTypeDef,
    UpdateConnectorProfileRequestRequestTypeDef,
    UpdateConnectorProfileResponseTypeDef,
    UpdateFlowRequestRequestTypeDef,
    UpdateFlowResponseTypeDef,
    UpsolverDestinationPropertiesTypeDef,
    UpsolverS3OutputFormatConfigTypeDef,
    VeevaConnectorProfileCredentialsTypeDef,
    VeevaConnectorProfilePropertiesTypeDef,
    VeevaSourcePropertiesTypeDef,
    ZendeskConnectorProfileCredentialsTypeDef,
    ZendeskConnectorProfilePropertiesTypeDef,
    ZendeskDestinationPropertiesTypeDef,
    ZendeskMetadataTypeDef,
    ZendeskSourcePropertiesTypeDef,
)

def get_structure() -> AggregationConfigTypeDef:
    return {
      ...
    }
```

<a id="versioning"></a>

## Versioning

`mypy-boto3-appflow` version is the same as related `boto3` version and follows
[PEP 440](https://www.python.org/dev/peps/pep-0440/) format.

<a id="documentation"></a>

## Documentation

All type annotations can be found in
[mypy-boto3-appflow docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_appflow/)

<a id="support-and-contributing"></a>

## Support and contributing

This package is auto-generated. Please reports any bugs or request new features
in [mypy-boto3-builder](https://github.com/vemel/mypy_boto3_builder/issues/)
repository.
