(this["webpackJsonpmasterful-ai-visualize-frontend"]=this["webpackJsonpmasterful-ai-visualize-frontend"]||[]).push([[0],{371:function(e,a,t){e.exports=t.p+"media/react-logo-transparent.f7d45c01.svg"},374:function(e,a,t){e.exports=t.p+"media/masterful_ai_logo.b2d31b9a.svg"},375:function(e,a){e.exports="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAGAAAABgCAYAAADimHc4AAACtElEQVR4Ae3cO05VURyFcRuNGh/XRxgCI7CixjAYaOkMN9I4BBgFgxBFwXdotLGSgoTQYKCCnwUkFIjnHtzcfyDr68/OyreS89iPcyNUEkIIAVOYSu4isIKV5C4AkzjEISaTe8xg2SnLyT1GMIF9p+xjIrnHBBadZTG5xwDuYsdZdnA3uS8ZzDqf2eS+JHAHc9h2PtuYw53kbvvgWsSO0dnBIiaS+//el5dw4OIcYAmTyd3vM30Fh9pxiBVMJXcKqM+dW1B97i7yEC4ir6FF5EOsnExFZDIuuTMdnQUZPMcq9rCJIW6OIXeWJLHg76xjcIm5syiPoX+zgUHL3NmW0iG/QQkduUOH/I4SmhP59SVEfn0JkV9fQuTXlxD5W1UlRP6JUAyLSoj8BteGJgL7j7GOWzHfQv7Fx3oZ+Qz1Y7rhmD8ivz+7eNYx7gC/dLMX+WhZAgbYMBprkd+whJ7yjzAT+Y1K6CkfFiK/XQnTPeUPI7/7VXMauxoT+d18wKOT655hN/IL5B9zWkLkF8hvVULkd/PxjPyOEprLj/xuMB35dfIH7V8167elRH79xqzIL92aWCD/U738+s25lfIfjzjuQ6y3l1+/PT3yqw9oFMj/XCK/4IhS5Bcc0ov8gmOqkX+dD2oXyH/fXn79rwoiv/pnHQXyv+DJiOM+aCD/+hRQIP9de/n1t6DIr38IR375a2jkF3yIFcj/Wi+//m8plfKf9pC/ViD/6kzGYSHyi6ajMYMjo/HtessvWJDBWnv57lfKv1JLkvitm62e8t9Wy78yi/L4bjTmr6H8+m0peGF05hvLD7iJ1/1LiPxm4B7e9CqhXn5KOL2mSn5K+FkoPyUUyE8JBfJTQr38lFAvPyXUy08J9fJTQr38lLCafy8Ugtt4hU3sYRXPYyYcE0IIIYQQQvgDlYF75V2EaQoAAAAASUVORK5CYII="},376:function(e,a){e.exports="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADAAAAAwCAQAAAD9CzEMAAAAkUlEQVRYw+3Xyw2AIBAEUPtAa7UatDL0gjWMJy9emJ2Nv7hzZuclBELousgLg4SMBa2Men0FF41ABh+FQAEuJY5JZo1EmAErIQA2QgIshAjwhAywhAPgCBfAEE4A3wBccwH8EGi9OAFcD8QxjXsQQBzTRwDbB+Sc0gYmF5DbQI9Nrq9IzG4OmLGayxdkqj5ye3ZY2irQOtTXPQAAAABJRU5ErkJggg=="},397:function(e,a,t){e.exports=t(644)},402:function(e,a,t){},644:function(e,a,t){"use strict";t.r(a);var n=t(1),l=t.n(n),r=t(46),i=t.n(r),o=t(97),s=(t(402),t(403),t(404),t(11)),c=t(63),m=t(40),u=t(689),d=t(371),f=t.n(d),h=function(e){var a=e.show;return l.a.createElement("div",{className:"preloader bg-soft flex-column justify-content-center align-items-center ".concat(a?"":"show")},l.a.createElement(u.a,{className:"loader-element animate__animated animate__jackInTheBox",src:f.a,height:40}))},p=t(225),v=(t(710),t(711)),g=t(690),y=t(709),E=t(389),b=t(374),x=t.n(b),A=t(375),N=t.n(A),k=t(376),L=t.n(k),S={path:"/policies"},w={path:"/docs"},T=function(){var e="v".concat("0.4.1"),a=Object(m.g)(),t=a.pathname,r=Object(n.useState)(!1),i=Object(s.a)(r,2),c=i[0],d=i[1],f=c?"show":"",h=function(e){var a=e.title,n=e.link,r=e.external,i=e.target,s=e.icon,c=e.image,m=e.badgeText,f=e.badgeBg,h=void 0===f?"secondary":f,y=e.badgeColor,E=void 0===y?"primary":y,_=m?"d-flex justify-content-start align-items-center justify-content-between":"",b=n===t?"active":"",x=r?{href:n}:{as:o.b,to:n};return l.a.createElement(v.a.Item,{className:b,onClick:function(){return d(!1)}},l.a.createElement(v.a.Link,Object.assign({},x,{target:i,className:_}),l.a.createElement("span",null,s?l.a.createElement("span",{className:"sidebar-icon"},l.a.createElement(p.a,{icon:s})," "):null,c?l.a.createElement(u.a,{src:c,width:20,height:20,className:"sidebar-icon svg-icon"}):null,l.a.createElement("span",{className:"sidebar-text"},a)),m?l.a.createElement(g.a,{pill:!0,bg:h,text:E,className:"badge-md notification-count ms-2"},m):null))};return l.a.createElement(l.a.Fragment,null,l.a.createElement(E.a,{className:"collapse ".concat(f," sidebar d-md-block bg-primary text-white")},l.a.createElement("div",{className:"sidebar-inner px-4 pt-3"},l.a.createElement(v.a,{className:"flex-column pt-3 pt-md-0"},l.a.createElement("div",{className:"masterful-sidebar-div"},l.a.createElement("img",{src:x.a,className:"masterful-sidebar-logo"})),l.a.createElement(y.a.Divider,{className:"my-3 border-indigo"}),l.a.createElement(h,{title:"Training Runs",link:S.path,image:N.a}),l.a.createElement(h,{title:"Docs",link:w.path,image:L.a}),l.a.createElement("div",{className:"sidebar-version-container"},l.a.createElement("p",{className:"sidebar-version"},e))))))},M=t(8),O=t(13),B=t(14),P=t(15),R=t(691),j=t(692),C=t(117),I=t.n(C),D=t(713),F=t(693),V=t(23),W=t(79),H=t.n(W),U="LAYER",Y=function(e,a){var t,n=-1,l=Object(V.a)(e.val_metrics);try{for(l.s();!(t=l.n()).done;){var r=t.value;if(H.a.isEqual(r.node_scalar_map,a)){n=r.metrics.loss;break}}}catch(i){l.e(i)}finally{l.f()}return-1===n&&console.log("No val_loss found for scalar: ".concat(a," in task: ").concat(e.title)),n},z=function(e,a){return e<=0?(console.log("Error: total cannot be <= 0"),-1):100*a/e},K=function(e){if(!e.fit_was_captured)return!1;var a=e.node_search_tasks.length,t=e.node_search_tasks[a-1];return"UNLABELED_DATA_SSL"===t.type&&0!==t.node_optimal_scalar_map.masterful_unlabeled_switch},Q=function(e){var a=e.node_optimal_scalar_map;return Object.values(a).some((function(e){return e>0}))},G=function(e){for(var a=[],t=Object.keys(e.node_scalars_map),n=e.node_scalars_map[t[0]].scalars.length,l=0;l<n;l++){var r,i={},o=Object(V.a)(t);try{for(o.s();!(r=o.n()).done;){var s=r.value;i[s]=e.node_scalars_map[s].scalars[l]}}catch(c){o.e(c)}finally{o.f()}a.push(i)}return a},J=function(e,a){var t=arguments.length>2&&void 0!==arguments[2]&&arguments[2],n=[];if(e.type===U){var l,r=Object(V.a)(e.searched_layers);try{for(r.s();!(l=r.n()).done;){var i=l.value;n=n.concat(q(i,a[i.name],t))}}catch(o){r.e(o)}finally{r.f()}}else n.push(a[e.title]);return n},q=function(e,a){var t=arguments.length>2&&void 0!==arguments[2]&&arguments[2];if("MASTERFUL_SAMPLE_MAG_BY_QUANTILE_LAYER"!==e.layer_type)return[a];if(0===a){if(t)return[0];var n=new Array(e.ordered_actions.length).fill(0);return n}for(var l=[],r=a-1,i=0;i<e.ordered_actions.length;i++){var o=e.max_index_grid[i].values[r],s=o-1,c=e.action_mag_grid[i].values[s];l.push(c)}if(t&&l.length>0){var m=0;l.forEach((function(e){return m+=e}));var u=m/l.length;return[Math.floor(100*u)/100]}return l},X=function(e){var a=e.policies,t=e.onTableRowClick;"object"!==typeof a&&(a=[]);var n=function(e){var a=e.policy_name,t=e.handleClick,n=e.engine_version,r=e.task_type;return l.a.createElement("tr",null,l.a.createElement("th",{scope:"row",onClick:function(){return t(a)}}," ",a),l.a.createElement("td",null,function(e){if("COMPUTER_VISION_TASK_UNKNOWN"===e)return"Unknown";for(var a=e.toLowerCase().split("_"),t=0;t<a.length;t++)a[t]=a[t][0].toUpperCase()+a[t].substring(1);return a.join(" ")}(r)),l.a.createElement("td",null,n))};return l.a.createElement(D.a,{border:"light",className:"shadow-sm"},l.a.createElement(D.a.Header,null,l.a.createElement(R.a,{className:"align-items-center"},l.a.createElement(j.a,null,l.a.createElement("h5",null,"Training Runs"),l.a.createElement("p",null,"Select a training run to visualize")))),l.a.createElement(F.a,{responsive:!0,className:"align-items-center table-flush"},l.a.createElement("thead",{className:"thead-light"},l.a.createElement("tr",null,l.a.createElement("th",{scope:"col"},"Name"),l.a.createElement("th",{scope:"col"},"ML Task"),l.a.createElement("th",{scope:"col"},"Params Engine"))),l.a.createElement("tbody",null,a.map((function(e){return l.a.createElement(n,Object.assign({handleClick:t,key:"policy-".concat(e.policy_name)},e))})))))},Z=function(e){var a=e.datasets,t=e.onTableRowClick;"object"!==typeof a&&(a=[]);var n=function(e){var a=e.title,t=e.task,n=e.handleClick,r=e.total_cardinality,i=e.train_cardinality,o=e.test_cardinality;return l.a.createElement("tr",null,l.a.createElement("th",{scope:"row",onClick:function(){return n(a)}}," ",a),l.a.createElement("td",null,r),l.a.createElement("td",null,i," / ",o),l.a.createElement("td",null,t))};return l.a.createElement(D.a,{border:"light",className:"shadow-sm"},l.a.createElement(D.a.Header,null,l.a.createElement(R.a,{className:"align-items-center"},l.a.createElement(j.a,null,l.a.createElement("h5",null,"Datasets"),l.a.createElement("p",null,"Select a dataset to visualize")))),l.a.createElement(F.a,{responsive:!0,className:"align-items-center table-flush"},l.a.createElement("thead",{className:"thead-light"},l.a.createElement("tr",null,l.a.createElement("th",{scope:"col"},"Dataset"),l.a.createElement("th",{scope:"col"},"Cardinality"),l.a.createElement("th",{scope:"col"},"Train / Test Split"),l.a.createElement("th",{scope:"col"},"Task"))),l.a.createElement("tbody",null,a.map((function(e){return l.a.createElement(n,Object.assign({handleClick:t,key:"dataset-".concat(e.title)},e))})))))},$=t(387),ee=t(388),ae=t(139),te="http://127.0.0.1:7007/",ne={"Access-Control-Allow-Origin":"*","Access-Control-Allow-Methods":"*","Access-Control-Allow-Headers":"*"},le=["CLASSIFICATION","BINARY_CLASSIFICATION"],re=function(e){var a=e.title,t=e.policyName,n=e.policyEngine,r=e.plotData,i=e.plotVariables;return l.a.createElement(D.a,{className:"shadow-sm"},l.a.createElement(D.a.Header,{className:"d-flex flex-row align-items-center flex-0"},l.a.createElement("div",{className:"d-block"},l.a.createElement("h3",{className:"fw-normal mb-2"},a),l.a.createElement("div",null,l.a.createElement("h6",{className:"card-metadata-text"},l.a.createElement("b",null,"Name: "),t),l.a.createElement("h6",{className:"card-metadata-text"},l.a.createElement("b",null,"Version: "),n)))),l.a.createElement(D.a.Body,{className:"p-2",style:{minHeight:800,height:1e3,minWidth:400}},l.a.createElement(ee.a,{data:r,variables:i.reverse().map((function(e){return"selected"===e.actionKey||"masterful_unlabeled_switch"===e.actionKey?{key:e.actionKey,legend:e.actionLegend,type:"point",ticksPosition:"before",legendPosition:"start",legendOffset:20,padding:1,values:e.values}:{key:e.actionKey,legend:e.actionLegend,type:"linear",min:e.min,max:e.max,ticksPosition:"before",legendPosition:"start",legendOffset:20}})),margin:{top:50,right:60,bottom:50,left:60},layout:"vertical",colors:function(e){var a=e.size,t=Array(a);return t.fill("#D32F2F"),t[a-1]="#00e676",t}({size:r.length}),strokeWidth:3,lineOpacity:.8,curve:"linear",motionConfig:"molasses",theme:{fontSize:14,axis:{domain:{line:{stroke:"#dde1e9",strokeWidth:1}}}}})))},ie=function(e){var a=e.title,t=e.policyName,n=e.policyEngine,r=e.data,i=(e.min,e.max,r.map((function(e,a){var t=e.Basline,n=e.classLabel;return{toolTip:n,name:"Basline",value:t,groupId:n,label:{show:!0,color:"white",position:"inside"}}}))),o=r.map((function(e,a){var t=e.Masterful,n=e.classLabel;return{toolTip:n,name:"Masterful",value:t,groupId:n,label:{show:!0,color:"white",position:"inside"}}})),s={tooltip:{trigger:"axis",axisPointer:{type:"shadow"}},dataZoom:[{orient:"horizontal",height:20}],grid:{left:"3%",right:"4%",bottom:"10%",containLabel:!0},legend:{show:!0,textStyle:{fontSize:11,color:"#333333"},itemWidth:17},xAxis:[{type:"category",name:"Class Label",nameLocation:"middle",axisTick:{alignWithLabel:!0},position:"bottom",nameTextStyle:{fontWeight:"bold",lineHeight:36},data:r.map((function(e){return e.classLabel}))}],yAxis:[{type:"value",name:"Recall",nameLocation:"middle",max:function(e){return e.max.toFixed(2)},position:"bottom",nameTextStyle:{fontWeight:"bold",lineHeight:36}}],series:[{name:"Baseline",type:"bar",itemStyle:{color:"#9F9F9F",borderRadius:4},barGap:0,data:i},{name:"Masterful",type:"bar",itemStyle:{color:"#E97551",borderRadius:4},barGap:0,data:o}]};return l.a.createElement(D.a,{className:"shadow-sm"},l.a.createElement(D.a.Header,{className:"d-flex flex-row align-items-center flex-0"},l.a.createElement("div",{className:"d-block"},l.a.createElement("h3",{className:"fw-normal mb-2"},a),l.a.createElement("div",{className:"card-subtitle"},l.a.createElement("h6",{className:"card-subtitle-text"},"Recall is defined as TP / P, or equivalently, TP / (TP + FN). The term Recall has the same meaning as True Positive Rate and sensitivity.")),l.a.createElement("div",null,l.a.createElement("h6",{className:"card-metadata-text"},l.a.createElement("b",null,"Name: "),t),l.a.createElement("h6",{className:"card-metadata-text"},l.a.createElement("b",null,"Version: "),n)))),l.a.createElement(D.a.Body,{className:"p-2",style:{minHeight:600,height:650,minWidth:400}},l.a.createElement(ae.a,{option:s,style:{minHeight:600,height:650,minWidth:400}})))},oe=function(e){var a=e.title,t=e.policyName,n=e.policyEngine,r=e.data,i=(e.min,e.max,r.map((function(e,a){var t=e.Basline,n=e.classLabel;return{toolTip:n,name:"Baseline",value:t,groupId:n,label:{show:!0,color:"white",position:"inside"}}}))),o=r.map((function(e,a){var t=e.Masterful,n=e.classLabel;return{toolTip:n,name:"Masterful",value:t,groupId:n,label:{show:!0,color:"white",position:"inside"}}})),s={tooltip:{trigger:"axis",axisPointer:{type:"cross"}},dataZoom:[{orient:"horizontal",height:20}],grid:{left:"3%",right:"4%",bottom:"10%",containLabel:!0},legend:{show:!0,textStyle:{fontSize:11,color:"#333333"},itemWidth:17},xAxis:[{type:"category",name:"Class Prediction",nameLocation:"middle",position:"bottom",axisTick:{alignWithLabel:!0},nameTextStyle:{fontWeight:"bold",lineHeight:36},data:r.map((function(e){return e.classLabel}))}],yAxis:[{type:"value",name:"Precision",nameLocation:"middle",max:function(e){return e.max.toFixed(2)},position:"bottom",nameTextStyle:{fontWeight:"bold",lineHeight:36}}],series:[{name:"Baseline",type:"bar",itemStyle:{color:"#9F9F9F",borderRadius:4},barGap:0,data:i},{name:"Masterful",type:"bar",itemStyle:{color:"#E97551",borderRadius:4},barGap:0,data:o}]};return l.a.createElement(D.a,{className:"shadow-sm"},l.a.createElement(D.a.Header,{className:"d-flex flex-row align-items-center flex-0"},l.a.createElement("div",{className:"d-block"},l.a.createElement("h3",{className:"fw-normal mb-2"},a),l.a.createElement("div",{className:"card-subtitle"},l.a.createElement("h6",{className:"card-subtitle-text"},"Precision is defined as TP / PP, where PP means Predicted Positives. Or equivalently, TP / (TP + FP). The term Precision has the same meaning as Positive Predictive Value.")),l.a.createElement("div",null,l.a.createElement("h6",{className:"card-metadata-text"},l.a.createElement("b",null,"Name: "),t),l.a.createElement("h6",{className:"card-metadata-text"},l.a.createElement("b",null,"Version: "),n)))),l.a.createElement(D.a.Body,{className:"p-2",style:{minHeight:600,height:650,minWidth:400}},l.a.createElement(ae.a,{option:s,style:{minHeight:600,height:650,minWidth:400}})))},se=function(e){var a=e.title,t=e.datasetTitle,n=e.keys,r=e.data;return l.a.createElement(D.a,{className:"shadow-sm"},l.a.createElement(D.a.Header,{className:"d-flex flex-row align-items-center flex-0"},l.a.createElement("div",{className:"d-block"},l.a.createElement("h3",{className:"fw-normal mb-2"},a),l.a.createElement("h6",{className:"fw-normal mb-2"},"Dataset: ",t))),l.a.createElement(D.a.Body,{className:"p-2",style:{minHeight:1e3,height:1e3,minWidth:400}},l.a.createElement($.a,{data:r,keys:n,indexBy:"classLabel",margin:{top:50,right:60,bottom:50,left:100},padding:.3,colors:function(e){var a=e.id;return"train"===a?"#64dd17":"test"===a?"#c51162":"val"===a?"#ffd600":"#64dd17"},groupMode:"grouped",layout:"horizontal",valueScale:{type:"linear"},indexScale:{type:"band",round:!0},axisTop:null,axisRight:null,borderRadius:8,axisBottom:{tickSize:5,tickPadding:5,tickRotation:0,legend:"# Labels",legendPosition:"middle",legendOffset:32},axisLeft:{tickSize:5,tickPadding:5,tickRotation:0,legend:"Class Labels",legendPosition:"middle",legendOffset:-60},labelSkipWidth:12,labelSkipHeight:12,labelTextColor:"#ffffff",legends:[{dataFrom:"keys",anchor:"bottom-right",direction:"column",justify:!1,translateX:120,translateY:0,itemsSpacing:2,itemWidth:100,itemHeight:20,itemDirection:"left-to-right",itemOpacity:.85,symbolSize:20,effects:[{on:"hover",style:{itemOpacity:1}}]}]})))},ce=function(e){var a=e.title,t=e.policyName,n=e.policyEngine,r=e.data,i=(e.keys,e.maxVal,function(e){return"Basline"===e?"#9F9F9F":"Masterful"===e?"#E97551":"#BDBDBD"}),o=[],s=[];r.map((function(e,a){var t=e.technique,n=e.lowerPart,l=(e.upperPart,e.impValue);o.push({name:t,value:n,itemStyle:{color:"transparent"}}),s.push({name:t,value:l,itemStyle:{color:i(t)}})}));var c=[{name:"Lower Value",type:"bar",stack:"Total",itemStyle:{borderColor:"transparent",color:"transparent"},emphasis:{itemStyle:{borderColor:"transparent",color:"transparent"}},data:o},{name:"Imp Value",type:"bar",stack:"Total",itemStyle:{borderRadius:8},label:{show:!0,color:"white",position:"inside",formatter:function(e){var a=e.data,t=e.value;return"Masterful"===a.name||"Basline"===a.name?t:"-".concat(t)}},data:s}],m={tooltip:{trigger:"axis",axisPointer:{type:"shadow"},textStyle:{fontWeight:"bold"},formatter:function(e){var a=e[1],t=a.data,n=a.value;return"Masterful"===t.name||"Basline"===t.name?" ".concat(t.name,' : <span style="font-weight: normal;"> ').concat(n," </span>"):" ".concat(t.name,' : <span style="font-weight: normal;"> -').concat(n," </span> ")}},grid:{left:"3%",right:"4%",bottom:"3%",containLabel:!0},xAxis:{type:"category",name:"Technique",nameLocation:"middle",position:"bottom",axisLabel:{interval:0},axisTick:{alignWithLabel:!0},nameTextStyle:{fontWeight:"bold",lineHeight:36,overflow:"truncate"},data:r.map((function(e){return e.technique}))},yAxis:{type:"value",name:"Val loss",nameLocation:"middle",max:function(e){return e.max.toFixed(2)},position:"bottom",nameTextStyle:{fontWeight:"bold",lineHeight:36}},series:c};return l.a.createElement(D.a,{className:"shadow-sm"},l.a.createElement(D.a.Header,{className:"d-flex flex-row align-items-center flex-0"},l.a.createElement("div",{className:"d-block"},l.a.createElement("h3",{className:"fw-normal mb-2"},a),l.a.createElement("div",{className:"card-subtitle"},l.a.createElement("h6",{className:"card-subtitle-text"},"Calculated on the validation set.")),l.a.createElement("div",null,l.a.createElement("h6",{className:"card-metadata-text"},l.a.createElement("b",null,"Name: "),t),l.a.createElement("h6",{className:"card-metadata-text"},l.a.createElement("b",null,"Version: "),n)))),l.a.createElement(D.a.Body,{className:"p-2",style:{minHeight:600,height:620,minWidth:420}},l.a.createElement(ae.a,{option:m,style:{minHeight:600,height:600,minWidth:400}})))},me=function(e){var a=e.policyName,t=e.policyEngine,n=e.data,r=e.reductionRate,i=function(e){return"Basline"===e?"#9F9F9F":"#E97551"},o=function(e){return"".concat(e,"%")},s=n.map((function(e,a){var t=e["Error Rate"],n=e.Model;return{name:n,value:t,label:{show:!0,position:"inside",color:"white",formatter:o(t)},itemStyle:{color:i(n),borderRadius:8},groupId:n}})),c={legend:{},xAxis:{name:"Model",nameLocation:"middle",position:"bottom",axisTick:{alignWithLabel:!0},nameTextStyle:{fontWeight:"bold",lineHeight:36},data:n.map((function(e){return e.Model}))},yAxis:{type:"value",name:"Error Rate",nameLocation:"middle",position:"bottom",max:function(e){return e.max.toFixed(2)},nameTextStyle:{fontWeight:"bold",lineHeight:36}},tooltip:{trigger:"axis",axisPointer:{type:"cross",label:{color:"white"}},formatter:function(e){return"Error Rate - ".concat(e[0].name,": ").concat(e[0].value,"%")}},series:{type:"bar",data:s}};return l.a.createElement(D.a,{className:"shadow-sm"},l.a.createElement(D.a.Header,{className:"d-flex flex-row align-items-center flex-0"},l.a.createElement("div",{className:"d-block"},l.a.createElement("h3",{className:"fw-normal mb-2"},"Model Improvement on Error Rate"),l.a.createElement("div",{className:"card-subtitle"},l.a.createElement("h6",{className:"card-subtitle-text"},"Error is defined as (FP + FN) / (TP + TN + FP + FN), or equivalently 100% - accuracy. Calculated on the validation set.")),l.a.createElement("div",null,l.a.createElement("h6",{className:"card-metadata-text"},l.a.createElement("b",null,"Reduction rate: "),r,"%"),l.a.createElement("h6",{className:"card-metadata-text"},l.a.createElement("b",null,"Name: "),a),l.a.createElement("h6",{className:"card-metadata-text"},l.a.createElement("b",null,"Version: "),t)))),l.a.createElement(D.a.Body,{className:"p-2",style:{minHeight:600,height:600,minWidth:400}},l.a.createElement(ae.a,{option:c,style:{minHeight:600,height:600,minWidth:400}})))},ue=(l.a.Component,function(e,a,t){var n=[],l={upperPart:0,lowerPart:0,technique:"Basline"};l.impValue=Math.floor(1e5*e)/1e5,n.push(l);for(var r=0,i=0,o=Object.keys(t);i<o.length;i++){var s=o[i],c=Math.floor(1e5*t[s])/1e5;if(0!==c){var m={};m.upperPart=r,m.technique=s,m.impValue=c,m.lowerPart=e-r-m.impValue,n.push(m),r+=m.impValue}}var u=e-a,d={};return d.upperPart=Math.floor(1e5*u)/1e5,d.lowerPart=0,d.technique="Masterful",d.impValue=Math.floor(1e5*a)/1e5,n.push(d),n}),de=function(e){return Y(e,e.node_optimal_scalar_map)},fe=function(e){return e.presearch_model_val_metrics.loss},he=function(e,a){for(var t={},n=0,l=Object.keys(e);n<l.length;n++){var r=l[n];t[r]=e[r]*a/100}return t},pe=function(e,a,t){var n,l={},r=a,i=Object(V.a)(e.node_search_tasks);try{for(i.s();!(n=i.n()).done;){var o=n.value;if(!o.title.includes("unlabeled")){var s=Ee(o);if(Q(o)){var c=ve(o,r,t);l[s]=c;var m=Y(o,o.node_optimal_scalar_map);if(-1===m)return console.log("Error: did not expect node optimal val loss to be missing."),null;r=m}else l[s]=0}}}catch(u){i.e(u)}finally{i.f()}return l},ve=function(e,a,t){var n=Y(e,e.node_optimal_scalar_map);if(-1===n)return-1;var l=a-n;if(l<0)return console.log("Optimal node val loss cannot be worse than previous optimal val loss."),-1;var r=z(t,l);return-1===r?-1:r},ge=function(e){if(0===e.node_search_tasks.length)return-1;var a=function(e){var a=e.node_search_tasks.length;if(0===a)return console.log("RAY | killing analyze final loss here #1"),null;var t=a-1;e.fit_was_captured&&("UNLABELED_DATA_SSL"!==e.node_search_tasks[a-1].type?console.log("Warning: Detected a policy with fit captured and SSL node missing."):t=a-2);for(var n=t;n>=0;n--){var l=e.node_search_tasks[n];if(Q(l))return l}return null}(e);return null===a?-1:Y(a,a.node_optimal_scalar_map)},ye=function(e){return e.fit_was_captured?e.learned_policy_val_metrics.loss:(console.log("Cannot get Masterful teacher val loss, fit was not captured."),-1)},Ee=function(e){var a="",t=e.type;if("SYNTHETIC_DATA_BLENDING"===t)a="Synthetic Data";else if("UNLABELED_DATA_SSL"===t)a="SSL";else if(t===U){if("MASTERFUL_SAMPLE_MAG_BY_QUANTILE_LAYER"===e.searched_layers[0].layer_type){var n,l=[],r=Object(V.a)(e.searched_layers);try{for(r.s();!(n=r.n()).done;){var i=n.value.name;if(-1!==i.indexOf("masterful")){var o=i.split("_").slice(1).join(" ");l.push(o)}else l.push(i)}}catch(c){r.e(c)}finally{r.f()}var s=l.join(" & ");a=s.length<=25?s:s.slice(0,25)}else a=e.searched_layers[0].ordered_actions[0]}else a=e.title;return a.toLowerCase()},_e=function(e){var a=e.learned_policy_val_metrics.label_recall_map;if(K(e)){var t=e.node_search_tasks.length,n=e.node_search_tasks[t-1];if("UNLABELED_DATA_SSL"!==n.type)console.log("Expected last node to be SSL, instead got: ",n.type),console.log("Will use Masterful teacher fit training result instead.");else{var l,r=Object(V.a)(n.val_metrics);try{for(r.s();!(l=r.n()).done;){var i=l.value;if(H.a.isEqual(i.node_scalar_map,n.node_optimal_scalar_map)){a=i.metrics.label_recall_map;break}}}catch(o){r.e(o)}finally{r.f()}}}return a},be=function(e){var a=e.learned_policy_val_metrics.label_precision_map;if(K(e)){var t=e.node_search_tasks.length,n=e.node_search_tasks[t-1];if("UNLABELED_DATA_SSL"!==n.type)console.log("Expected last node to be SSL, instead got: ",n.type),console.log("Will use Masterful teacher fit training result instead.");else{var l,r=Object(V.a)(n.val_metrics);try{for(r.s();!(l=r.n()).done;){var i=l.value;if(H.a.isEqual(i.node_scalar_map,n.node_optimal_scalar_map)){a=i.metrics.label_precision_map;break}}}catch(o){r.e(o)}finally{r.f()}}}return a},xe=function(e){var a={errPlotData:null,errReductionRate:null},t=Ae(e.presearch_model_val_metrics.confusion_matrix);if(-1===t)return console.error("Cannot create error rate plot: baseline confusion matrix missing."),a;var n=0;if(K(e)){var l=e.node_search_tasks.length,r=e.node_search_tasks[l-1],i=function(e,a){var t,n=null,l=Object(V.a)(e.val_metrics);try{for(l.s();!(t=l.n()).done;){var r=t.value;if(H.a.isEqual(r.node_scalar_map,a)){n=r.metrics.confusion_matrix;break}}}catch(i){l.e(i)}finally{l.f()}return null==n&&console.log("No confusion matrix found for scalar: ".concat(a," in task: ").concat(e.title)),n}(r,r.node_optimal_scalar_map);n=Ae(i)}else n=Ae(e.learned_policy_val_metrics.confusion_matrix);if(-1===n)return console.error("Failed calculating error rate, final error rate unavailable."),a;var o=z(t,t-n);o=Math.floor(100*o)/100;var s=[],c={Model:"Basline"};c["Error Rate"]=Math.floor(100*t)/100,s.push(c);var m={Model:"Masterful"};return m["Error Rate"]=Math.floor(100*n)/100,s.push(m),{errPlotData:s,errReductionRate:o}},Ae=function(e){var a=Ne(e);if(-1===a)return console.log("Failed computing error rate."),-1;for(var t=Object.keys(e).length,n=0,l=0;l<t;l++){var r=0;e[l].values.forEach((function(e){return r+=e})),n+=r}return 0===n?(console.log("Failed computing error rate, totalSum is 0 for: ",e),-1):100*(1-a/n)},Ne=function(e){if(void 0==e)return console.log("Failed computing true positives, no confusion matrix."),-1;for(var a=0,t=Object.keys(e).length,n=0;n<t;n++){if(void 0==e[n])return console.log("Invalid confusion matrix, no data for class: ",n," in: ",e),-1;a+=e[n].values[n]}return a},ke=function(e,a){var t=arguments.length>2&&void 0!==arguments[2]?arguments[2]:"",n=!(arguments.length>3&&void 0!==arguments[3])||arguments[3],l="",r="";if(r=n&&-1!==e.toLowerCase().indexOf("masterful")?e.split("_").slice(1).join(" "):e,a===U)l="MASTERFUL_REPLACEMENT_RATE_LAYER"===t?"(rr)":"(m)";else{if("SYNTHETIC_DATA_BLENDING"!==a)return"UNLABELED_DATA_SSL"===a?"SSL":r;l="(r)"}return String(r.toLowerCase()+" "+l)},Le=function(e){var a=[],t=e.presearch_model_val_metrics.loss;a.push(t);var n,l=Object(V.a)(e.node_search_tasks);try{for(l.s();!(n=l.n()).done;){var r,i=n.value,o=G(i),s=Object(V.a)(o);try{for(s.s();!(r=s.n()).done;){var c=r.value,m=Y(i,c);-1!==m&&a.push(m)}}catch(u){s.e(u)}finally{s.f()}}}catch(u){l.e(u)}finally{l.f()}return a.sort(),{minValLoss:a[0],maxValLoss:a[a.length-1]}},Se=function(e,a){var t=e;if(a.includes(t))for(var n=1;a.includes(t);)t=String(e+"_"+n),n++;return t},we=function(){var e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:"",a=arguments.length>1&&void 0!==arguments[1]?arguments[1]:"",t=0,n=1;return a===U&&("MASTERFUL_SAMPLE_MAG_BY_QUANTILE_LAYER"!==e&&"MASTERFUL_FIXED_MAG_LAYER"!==e||(n=100)),{min:t,max:n}},Te=function(e){var a,t=arguments.length>1&&void 0!==arguments[1]&&arguments[1],n=e.presearch_model_val_metrics.loss,l=[],r=Object(V.a)(e.node_search_tasks);try{for(r.s();!(a=r.n()).done;){var i=a.value;l=l.concat(J(i,i.node_optimal_scalar_map,t))}}catch(c){r.e(c)}finally{r.f()}var o=e.node_search_tasks.length-1,s=Y(e.node_search_tasks[o],e.node_search_tasks[o].node_optimal_scalar_map);if(-1===s)for(;-1===s;){if(-1===(o-=1)){s=n;break}s=Y(e.node_search_tasks[o],e.node_search_tasks[o].node_optimal_scalar_map)}return l.push(s),l.push("SELECTED"),l},Me=function(e,a){if(e.length!==a.length)return console.log("Number of action keys (".concat(e.length,") and values (").concat(a.length,") should be identical.")),[];for(var t=[],n=0;n<e.length;n++){var l=e[n],r=a[n];t[l]="masterful_unlabeled_switch"===l?Oe(r):r}return t},Oe=function(e){return 0===e?"OFF":"ON"},Be=function(e){return e.filter((function(e){return!0===e.fit_was_captured}))},Pe=function(e){return null!==e&&le.includes(e.task_type)},Re=function(e){Object(B.a)(t,e);var a=Object(P.a)(t);function t(e){var n;return Object(M.a)(this,t),(n=a.call(this,e)).state={selectedPolicyIndex:null,policySearchTasks:[],intervalId:null},n}return Object(O.a)(t,[{key:"sync_",value:function(){var e=this;I.a.get(String(te+"scan/"),{headers:ne}).then((function(e){return I.a.get(String(te+"api/search/"),{headers:ne})})).then((function(a){var t;if(a.data.length>0){var n=a.data.slice();e.setState({policySearchTasks:(t=Be(n),t.filter((function(e){return Pe(e)})))})}})).catch((function(e){return console.log(e)}))}},{key:"componentDidMount",value:function(){var e=this;this.sync_();var a=setInterval((function(){e.sync_()}),6e5);this.setState({intervalId:a})}},{key:"componentWillUnmount",value:function(){null!==this.state.intervalId&&(clearInterval(this.state.intervalId),this.setState({intervalId:null}))}},{key:"render",value:function(){var e=this,a={policyName:"",policyEngine:"",taskType:"",plotVariables:[],actionKeys:[],recallByClassData:[],precisionByClassData:[],waterfallChartKeys:[],waterfallChartData:[],waterfallChartMaxVal:1,recallMin:0,recallMax:100,precisionMin:0,precisionMax:100,errorRateReductionValue:0,errorRateReductionData:[]},t=[];if(0!==this.state.policySearchTasks.length&&null!==this.state.selectedPolicyIndex){var n=this.state.selectedPolicyIndex,r=this.state.policySearchTasks[n];a.taskType=r.task_type;var i=function(e,a){var t,n=[],l=[],r=Object(V.a)(e.node_search_tasks);try{for(r.s();!(t=r.n()).done;){var i=t.value,o=i.type;if(o===U){var s=i.searched_layers[0].layer_type;if(a&&"MASTERFUL_SAMPLE_MAG_BY_QUANTILE_LAYER"===s){var c,m=Object(V.a)(i.searched_layers);try{for(m.s();!(c=m.n()).done;){var u=c.value,d=u.name;l.push(d);var f=we(s,o),h=f.min,p=f.max;n.push({actionKey:d,actionLegend:ke(d.toUpperCase(),o,u.layer_type),min:h,max:p})}}catch(P){m.e(P)}finally{m.f()}}else{var v,g=Object(V.a)(i.searched_layers);try{for(g.s();!(v=g.n()).done;)for(var y=v.value,E=y.ordered_actions.length,_=0;_<E;_++){var b=y.ordered_actions[_],x=Se(b,l);l.push(x);var A=we(s,o),N=A.min,k=A.max;n.push({actionKey:x,actionLegend:ke(b,o,s),min:N,max:k})}}catch(P){g.e(P)}finally{g.f()}}}else{var L=Se(i.title,l);if(l.push(L),"UNLABELED_DATA_SSL"===o)n.push({actionKey:L,actionLegend:ke(i.title,o),values:["ON","OFF"]});else{var S=we("",o),w=S.min,T=S.max;n.push({actionKey:L,actionLegend:ke(i.title,o),min:w,max:T})}}}}catch(P){r.e(P)}finally{r.f()}var M=Le(e),O=M.minValLoss,B=M.maxValLoss;return n.push({actionKey:"val_loss",actionLegend:"val_loss",min:O-.05,max:B+.05}),n.push({actionKey:"selected",actionLegend:"Optimal Params",values:["SELECTED","NOT SELECTED"]}),l.push("val_loss"),l.push("selected"),{currentPlotVariables:n,actionKeysSoFar:l}}(r,!0),o=i.actionKeysSoFar,s=i.currentPlotVariables;a.policyName=r.policy_name,a.policyEngine=r.engine_version,a.plotVariables=s,a.actionKeys=o,a.waterfallChartKeys=["lowerPart","impValue","upperPart"],a.waterfallChartData=function(e){var a=fe(e),t=ge(e),n=pe(e,a,a-t),l=ye(e),r=l,i=he(n,a-l);if(K(e)){var o=e.node_search_tasks.length,s=e.node_search_tasks[o-1],c=de(s);i[Ee(s)]=l-c,r=c}return ue(a,r,i)}(r),a.waterfallChartMaxVal=r.presearch_model_val_metrics.loss,t=(t=function(e,a,t){var n=[],l=Te(e,t);n.push(Me(a,l));var r,i=[],o=Object(V.a)(e.node_search_tasks);try{for(o.s();!(r=o.n()).done;){var s,c=r.value,m=G(c),u=Object(V.a)(m);try{for(u.s();!(s=u.n()).done;){var d=s.value;if(!_.isEqual(d,c.node_optimal_scalar_map)){var f=[];f=f.concat(i);var h=J(c,d,t);f=f.concat(h);var p=a.length-f.length-2;if(p>0){var v=new Array(p).fill(0);f=f.concat(v)}var g=Y(c,d);f.push(g),f.push("NOT SELECTED"),n.push(Me(a,f))}}}catch(y){u.e(y)}finally{u.f()}i=i.concat(J(c,c.node_optimal_scalar_map,t))}}catch(y){o.e(y)}finally{o.f()}return n}(r,o,!0)).reverse();var c=function(e){if(!e.fit_was_captured)return console.error("Fit must be captured to comput recall by class data."),[];var a=e.presearch_model_val_metrics.label_recall_map;if(!a)return console.error("Baseline metrics unavailable. Label recall failed."),[];var t=_e(e);if(!t)return console.error("Failed getting final recall map for policy: ",e),[];if(Object.keys(a).length!==Object.keys(t).length)return console.error("BaselineRecallMap & finalRecallMap must same amount : "),[];for(var n=[],l=0;l<Object.keys(a).length;l++){var r={};r.classLabel=l,r.Basline=Math.floor(1e4*a[l])/100,r.Masterful=Math.floor(1e4*t[l])/100,n.push(r)}return n}(r);a.recallByClassData=c;var m=function(e){if(!e.fit_was_captured)return console.error("Fit must be captured to comput precision by class data."),[];var a=e.presearch_model_val_metrics.label_precision_map;if(!a)return console.error("Baseline metrics unavailable. Label precision failed."),[];var t=be(e);if(!t)return console.error("Failed getting final precision map for policy: ",e),[];if(Object.keys(a).length!==Object.keys(t).length)return console.error("baselinePrecisionMap & finalPrecisionMap must same amount : "),[];for(var n=[],l=0;l<Object.keys(a).length;l++){var r={};r.classLabel=l,r.Basline=Math.floor(1e4*a[l])/100,r.Masterful=Math.floor(1e4*t[l])/100,n.push(r)}return n}(r);a.precisionByClassData=m;var u=function(e){if(null===e||0===e.length)return{recallMin:0,recallMax:100};var a,t=100,n=0,l=Object(V.a)(e);try{for(l.s();!(a=l.n()).done;){var r=a.value;if(0!==r["Baseline Recall"]){r["Baseline Recall"]<t&&(t=r["Baseline Recall"]);var i=0;void 0===r["Worse Recall"]?i+=r["Baseline Recall"]+r["Better Recall"]:i+=r["Actual Baseline Recall"],i>n&&(n=i)}}}catch(o){l.e(o)}finally{l.f()}return{recallMin:t=Math.max(0,t-2),recallMax:n=Math.min(100,n+2)}}(c),d=u.recallMin,f=u.recallMax,h=function(e){if(null===e||0===e.length)return{precisionMin:0,precisionMax:100};var a,t=100,n=0,l=Object(V.a)(e);try{for(l.s();!(a=l.n()).done;){var r=a.value;if(0!==r["Baseline Precision"]){r["Baseline Precision"]<t&&(t=r["Baseline Precision"]);var i=0;void 0===r["Worse Precision"]?i+=r["Baseline Precision"]+r["Better Precision"]:i+=r["Actual Baseline Precision"],i>n&&(n=i)}}}catch(o){l.e(o)}finally{l.f()}return{precisionMin:t=Math.max(0,t-2),precisionMax:n=Math.min(100,n+2)}}(m),p=h.precisionMin,v=h.precisionMax;a.recallMin=Math.min(d,p),a.recallMax=Math.max(f,v),a.precisionMin=Math.min(d,p),a.precisionMax=Math.max(f,v);var g=xe(r),y=g.errPlotData,E=g.errReductionRate;a.errorRateReductionValue=E,a.errorRateReductionData=y}var b=function(a){var t=e.state.policySearchTasks.findIndex((function(e){return e.policy_name===a}));e.setState({selectedPolicyIndex:t})};return null!==this.state.selectedPolicyIndex?l.a.createElement(l.a.Fragment,null,l.a.createElement(R.a,{className:"justify-content-md-center",style:{marginTop:12,marginBottom:12}},l.a.createElement(j.a,null,l.a.createElement(X,{policies:this.state.policySearchTasks,onTableRowClick:b}))),l.a.createElement(R.a,{className:"justify-content-md-center",style:{marginTop:12,marginBottom:12}},l.a.createElement(j.a,null,l.a.createElement(ce,{title:"Model Improvement on Loss",policyName:a.policyName,policyEngine:a.policyEngine,data:a.waterfallChartData,keys:a.waterfallChartKeys,maxVal:a.waterfallChartMaxVal})),l.a.createElement(j.a,null,function(){if(null!=a.errorRateReductionData)return l.a.createElement(me,{policyName:a.policyName,policyEngine:a.policyEngine,data:a.errorRateReductionData,reductionRate:a.errorRateReductionValue})}())),l.a.createElement(R.a,{className:"justify-content-md-center",style:{marginTop:12,marginBottom:12}},l.a.createElement(j.a,null,function(e){if(!("CLASSIFICATION"!==e||a.recallByClassData.length<0))return l.a.createElement(ie,{title:"Model Improvement on Recall",policyName:a.policyName,policyEngine:a.policyEngine,data:a.recallByClassData,min:a.recallMin,max:a.recallMax})}(a.taskType)),l.a.createElement(j.a,null,function(e){if(!("CLASSIFICATION"!==e||a.precisionByClassData.length<0))return l.a.createElement(oe,{title:"Model Improvement on Precision",policyName:a.policyName,policyEngine:a.policyEngine,data:a.precisionByClassData,min:a.precisionMin,max:a.precisionMax})}(a.taskType))),l.a.createElement(R.a,{className:"justify-content-md-center",style:{marginTop:12,marginBottom:12,width:"50.8%",minWidth:800}},l.a.createElement(j.a,null,l.a.createElement(re,{title:"Regularization Params",policyName:a.policyName,policyEngine:a.policyEngine,plotVariables:a.plotVariables,plotData:t})))):l.a.createElement(l.a.Fragment,null,l.a.createElement(R.a,null,l.a.createElement(j.a,null,l.a.createElement(X,{policies:this.state.policySearchTasks,onTableRowClick:b}))))}}]),t}(l.a.Component),je=function(e){Object(B.a)(t,e);var a=Object(P.a)(t);function t(e){return Object(M.a)(this,t),a.call(this,e)}return Object(O.a)(t,[{key:"render",value:function(){return l.a.createElement(l.a.Fragment,null,l.a.createElement("iframe",{src:"https://masterful-public.s3.us-west-1.amazonaws.com/933013963/0.4/index.html",title:"Documentation",width:"100%",height:"2000"}))}}]),t}(l.a.Component),Ce=function(e){var a=e.component,t=Object(c.a)(e,["component"]),r=Object(n.useState)(!1),i=Object(s.a)(r,2),o=i[0],u=i[1];Object(n.useEffect)((function(){var e=setTimeout((function(){return u(!0)}),1e3);return function(){return clearTimeout(e)}}),[]);var d=Object(n.useState)((function(){return"false"!==localStorage.getItem("settingsVisible")})),f=Object(s.a)(d,2);f[0],f[1];return l.a.createElement(m.b,Object.assign({},t,{render:function(e){return l.a.createElement(l.a.Fragment,null,l.a.createElement(h,{show:!o}),l.a.createElement(T,null),l.a.createElement("main",{className:"content"},l.a.createElement(a,e)))}}))},Ie=function(){return l.a.createElement(m.d,null,l.a.createElement(Ce,{exact:!0,path:S.path,component:Re}),l.a.createElement(Ce,{exact:!0,path:w.path,component:je}),l.a.createElement(m.a,{to:S.path}))},De=function(){var e=Object(m.g)().pathname;return Object(n.useEffect)((function(){window.scrollTo({top:0,left:0,behavior:"auto"})}),[e]),null};i.a.render(l.a.createElement(o.a,null,l.a.createElement(De,null),l.a.createElement(Ie,null)),document.getElementById("root"))}},[[397,1,2]]]);
//# sourceMappingURL=main.f33b5e2e.chunk.js.map