(this["webpackJsonpmasterful-ai-visualize-frontend"]=this["webpackJsonpmasterful-ai-visualize-frontend"]||[]).push([[0],{395:function(e,a,t){e.exports=t.p+"media/react-logo-transparent.f7d45c01.svg"},398:function(e,a){e.exports="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAGAAAABgCAYAAADimHc4AAAACXBIWXMAAAsTAAALEwEAmpwYAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAABPlJREFUeNrsndFxGjEQhgWT96MD/JZHmDQAqcCkAi4VBFfgcwe4Ah8V5FJBoIEMfswbdMBV4GjjvRnGg08St3vi8L8zN3jGRivtJ61WqwX3Xl5eDCSe9GECAAAACAAAAAQAAAACAAAAAQAAgAAAAEAAAAAgAAAAEAAAAAgAXK18iqW4/PJ5yj9ukz9/Dy3qHdiXsX0OVu82NoBeW1URbPDUPvQ6fPtr+6ztU1ij5AoGJ70z+0xO/Mkz615a3burA2ANQLNt+c7gT8nePgtrjEJA98K+ZPZJPN+yYt2HqwBgDZCy8ZMz3r6yhkgbzPoiAPrb1Thtyz2pAWDjPzVsJhgCG59cyqhJ99uC0Fd0O08CTc1tW1nge5YNjW94xa4ZZifD0EKwrXtriBtP8LTRzoX0EoS8cwDY9QyFm80CZr+k3B6Fy51ZAQuFNucud8Bub6igO+0MAHYVI6W+ziIZatalFXCj2FdX22MlvYnvHnQJADT9pavtQUT4FxcFxZBRFzstDeAQcSwbADBma65TBgDgzuusFXWPOwGAs4i/tDrriEaKDw9A6TTqZQhOnG0+PABriLWiIVyhaKakd6h1FtAKQ+lUWrZ9KmX4D106EasA4Ku9qQKEoSs5ZnXTKlgpTaruHMTYJ5Ox9sJNLzx0k7EepQ96GplR1ZMwQxgLG+OWM58u3QTqq3m9dJcS8T2mzaoIMloulDLYWANPA3ST4e6FhvKV95puAWBDDDhMlbi1+hZSOcETgAyXNNRLLnUsVTnRajKOOs3+WWKTzENCQ8E9aSh51omSDRWCQDO5CLk4Zwgzgehszlev3QRwBKFp2mIUOhuPVkJTCE8SUVHs+4BUwCXQbMzPgCBxd11wJUacTZh98LEf3oXWV/Is+i1gDAo3pyGbo9VNm/itgO7v59a0BgM4KrKdvRNR0NKmgWW+MHgGS0RGpHvmGyby/rETiIwMu9M0NDryBsCzfRk4Y7yKXYUNUen1mgDCZ4SSx5uLAmgYQ+95Vm4dOgjuD8ljB8/IomX4/w+KPGbnaugrG7+Km9ce6QPpewTq709XuMhGkr7MmRjP2tK+x+yQOD0mfHAa1BhiJ5y3OQ4X24ZfhchF0xWwFFyaI4/QLzc6UniEpXsFvRP+kEg4AN5058IdWjiW5VoJwNBlCEXdWd2Y61aARpFtYmouNpQ/EOEaj5buxNTcptUBmCp1yNXuRnEVjCMAMHWTru/w2TEAaEqd7p2i3snZYajSkozhi0lcUVjrgk/KRxYAuGAApZJO12FLs8La1fb+kgBo+eJtw993UffmHABaxa6541S6Vlp9pUeaWmvMRTAATqlKL8m9Z65eIzez9DRUeREAqmN0WweSE8aSNETpA4Azo9LwH+tC3L6jQ7QKVoId8dpX2BCpJHjfmyquLZXKyj67JrFPGLoQ6NCKSwX9T2uvFymPQuBDfftUYMylD/i+z2y0T5P6zodzv3aGod01MMJdKPijFdgEQlUg4Iyqgi7l+UI+M37fw0OhVyZRR8l6Q74FhQywENKdsRfwvRd55HF7ubyzylI4qzgzp5NbtNwLjdwK1+BUT3JiyVe6C2G91deepe9MgmfWnYeOu9fl/6RXVaZJVit76r0xr/VQu6YTrYd/ZRhXkIwDAACAAAAAQAAAACAAAAAQAAAACAAAAAQAAAACAAAAAQAAgADA9co/AQYAxFP6eJtSmv0AAAAASUVORK5CYII="},399:function(e,a){e.exports="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABgAAAAYCAYAAADgdz34AAAAYUlEQVR4Ae3NwQ1AQBQA0e2ODpSjGnVJbBnC04CNlS/swbvOYVI7fuiQlY3RwawsPsEGhTZgVSejrxiEJkt5EATw/cBNNYP9nUFAWwMXmhyAFPD5YPGc7WzQI3vGlH7NOACG5pfo9HAxcQAAAABJRU5ErkJggg=="},400:function(e,a){e.exports="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAGAAAABgCAYAAADimHc4AAACtElEQVR4Ae3cO05VURyFcRuNGh/XRxgCI7CixjAYaOkMN9I4BBgFgxBFwXdotLGSgoTQYKCCnwUkFIjnHtzcfyDr68/OyreS89iPcyNUEkIIAVOYSu4isIKV5C4AkzjEISaTe8xg2SnLyT1GMIF9p+xjIrnHBBadZTG5xwDuYsdZdnA3uS8ZzDqf2eS+JHAHc9h2PtuYw53kbvvgWsSO0dnBIiaS+//el5dw4OIcYAmTyd3vM30Fh9pxiBVMJXcKqM+dW1B97i7yEC4ir6FF5EOsnExFZDIuuTMdnQUZPMcq9rCJIW6OIXeWJLHg76xjcIm5syiPoX+zgUHL3NmW0iG/QQkduUOH/I4SmhP59SVEfn0JkV9fQuTXlxD5W1UlRP6JUAyLSoj8BteGJgL7j7GOWzHfQv7Fx3oZ+Qz1Y7rhmD8ivz+7eNYx7gC/dLMX+WhZAgbYMBprkd+whJ7yjzAT+Y1K6CkfFiK/XQnTPeUPI7/7VXMauxoT+d18wKOT655hN/IL5B9zWkLkF8hvVULkd/PxjPyOEprLj/xuMB35dfIH7V8167elRH79xqzIL92aWCD/U738+s25lfIfjzjuQ6y3l1+/PT3yqw9oFMj/XCK/4IhS5Bcc0ov8gmOqkX+dD2oXyH/fXn79rwoiv/pnHQXyv+DJiOM+aCD/+hRQIP9de/n1t6DIr38IR375a2jkF3yIFcj/Wi+//m8plfKf9pC/ViD/6kzGYSHyi6ajMYMjo/HtessvWJDBWnv57lfKv1JLkvitm62e8t9Wy78yi/L4bjTmr6H8+m0peGF05hvLD7iJ1/1LiPxm4B7e9CqhXn5KOL2mSn5K+FkoPyUUyE8JBfJTQr38lFAvPyXUy08J9fJTQr38lLCafy8Ugtt4hU3sYRXPYyYcE0IIIYQQQvgDlYF75V2EaQoAAAAASUVORK5CYII="},401:function(e,a){e.exports="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADAAAAAwCAQAAAD9CzEMAAAAkUlEQVRYw+3Xyw2AIBAEUPtAa7UatDL0gjWMJy9emJ2Nv7hzZuclBELousgLg4SMBa2Men0FF41ABh+FQAEuJY5JZo1EmAErIQA2QgIshAjwhAywhAPgCBfAEE4A3wBccwH8EGi9OAFcD8QxjXsQQBzTRwDbB+Sc0gYmF5DbQI9Nrq9IzG4OmLGayxdkqj5ye3ZY2irQOtTXPQAAAABJRU5ErkJggg=="},422:function(e,a,t){e.exports=t(762)},427:function(e,a,t){},762:function(e,a,t){"use strict";t.r(a);var n=t(0),l=t.n(n),r=t(42),i=t.n(r),s=t(97),c=(t(427),t(428),t(429),t(11)),o=t(54),m=t(33),u=t(805),d=t(395),f=t.n(d),h=function(e){var a=e.show;return l.a.createElement("div",{className:"preloader bg-soft flex-column justify-content-center align-items-center ".concat(a?"":"show")},l.a.createElement(u.a,{className:"loader-element animate__animated animate__jackInTheBox",src:f.a,height:40}))},p=t(236),g=(t(828),t(829)),v=t(806),y=t(827),A=t(413),E=t(398),b=t.n(E),k=t(399),x=t.n(k),N=t(400),P=t.n(N),S=t(401),w=t.n(S),R={path:"/policies"},B={path:"/datasets"},L={path:"/docs"},O=function(){var e="v".concat("0.3.5.7"),a=Object(m.g)(),t=a.pathname,r=Object(n.useState)(!1),i=Object(c.a)(r,2),o=i[0],d=i[1],f=o?"show":"",h=function(e){var a=e.title,n=e.link,r=e.external,i=e.target,c=e.icon,o=e.image,m=e.badgeText,f=e.badgeBg,h=void 0===f?"secondary":f,y=e.badgeColor,A=void 0===y?"primary":y,E=m?"d-flex justify-content-start align-items-center justify-content-between":"",b=n===t?"active":"",_=r?{href:n}:{as:s.b,to:n};return l.a.createElement(g.a.Item,{className:b,onClick:function(){return d(!1)}},l.a.createElement(g.a.Link,Object.assign({},_,{target:i,className:E}),l.a.createElement("span",null,c?l.a.createElement("span",{className:"sidebar-icon"},l.a.createElement(p.a,{icon:c})," "):null,o?l.a.createElement(u.a,{src:o,width:20,height:20,className:"sidebar-icon svg-icon"}):null,l.a.createElement("span",{className:"sidebar-text"},a)),m?l.a.createElement(v.a,{pill:!0,bg:h,text:A,className:"badge-md notification-count ms-2"},m):null))};return l.a.createElement(l.a.Fragment,null,l.a.createElement(A.a,{className:"collapse ".concat(f," sidebar d-md-block bg-primary text-white")},l.a.createElement("div",{className:"sidebar-inner px-4 pt-3"},l.a.createElement(g.a,{className:"flex-column pt-3 pt-md-0"},l.a.createElement("div",{className:"masterful-sidebar-div"},l.a.createElement("img",{src:b.a,className:"masterful-sidebar-logo"}),l.a.createElement("p",{className:"masterful-sidebar-text"},"Masterful AI")),l.a.createElement(y.a.Divider,{className:"my-3 border-indigo"}),l.a.createElement(h,{title:"Data Health Check",link:B.path,image:x.a}),l.a.createElement(h,{title:"Training Policies",link:R.path,image:P.a}),l.a.createElement(h,{title:"Docs",link:L.path,image:w.a}),l.a.createElement("div",{className:"sidebar-version-container"},l.a.createElement("p",{className:"sidebar-version"},e))))))},D=t(10),M=t(15),T=t(16),j=t(17),C=t(807),I=t(808),F=t(110),W=t.n(F),V=t(831),Q=t(809),U=function(e){var a=e.policies,t=e.onTableRowClick;"object"!==typeof a&&(a=[]);var n=function(e){var a=e.policy_name,t=e.handleClick,n=e.engine_version;return l.a.createElement("tr",null,l.a.createElement("th",{scope:"row",onClick:function(){return t(a)}}," ",a),l.a.createElement("td",null,n))};return l.a.createElement(V.a,{border:"light",className:"shadow-sm"},l.a.createElement(V.a.Header,null,l.a.createElement(C.a,{className:"align-items-center"},l.a.createElement(I.a,null,l.a.createElement("h5",null,"Training Policies"),l.a.createElement("p",null,"Select a training policy to visualize")))),l.a.createElement(Q.a,{responsive:!0,className:"align-items-center table-flush"},l.a.createElement("thead",{className:"thead-light"},l.a.createElement("tr",null,l.a.createElement("th",{scope:"col"},"Policy Name"),l.a.createElement("th",{scope:"col"},"Policy Engine"))),l.a.createElement("tbody",null,a.map((function(e){return l.a.createElement(n,Object.assign({handleClick:t,key:"policy-".concat(e.policy_name)},e))})))))},z=function(e){var a=e.datasets,t=e.onTableRowClick;"object"!==typeof a&&(a=[]);var n=function(e){var a=e.title,t=e.task,n=e.handleClick,r=e.total_cardinality,i=e.train_cardinality,s=e.test_cardinality;return l.a.createElement("tr",null,l.a.createElement("th",{scope:"row",onClick:function(){return n(a)}}," ",a),l.a.createElement("td",null,r),l.a.createElement("td",null,i," / ",s),l.a.createElement("td",null,t))};return l.a.createElement(V.a,{border:"light",className:"shadow-sm"},l.a.createElement(V.a.Header,null,l.a.createElement(C.a,{className:"align-items-center"},l.a.createElement(I.a,null,l.a.createElement("h5",null,"Datasets"),l.a.createElement("p",null,"Select a dataset to visualize")))),l.a.createElement(Q.a,{responsive:!0,className:"align-items-center table-flush"},l.a.createElement("thead",{className:"thead-light"},l.a.createElement("tr",null,l.a.createElement("th",{scope:"col"},"Dataset"),l.a.createElement("th",{scope:"col"},"Cardinality"),l.a.createElement("th",{scope:"col"},"Train / Test Split"),l.a.createElement("th",{scope:"col"},"Task"))),l.a.createElement("tbody",null,a.map((function(e){return l.a.createElement(n,Object.assign({handleClick:t,key:"dataset-".concat(e.title)},e))})))))},Y=t(101),K=t(412),H="LAYER",J=function(e){var a=e.title,t=e.policyName,n=e.policyEngine,r=e.plotData,i=e.plotVariables;return l.a.createElement(V.a,{className:"shadow-sm"},l.a.createElement(V.a.Header,{className:"d-flex flex-row align-items-center flex-0"},l.a.createElement("div",{className:"d-block"},l.a.createElement("h3",{className:"fw-normal mb-2"},a),l.a.createElement("h6",{className:"fw-normal mb-2"},"Policy: ",t),l.a.createElement("h6",{className:"fw-normal mb-2"},"Policy Engine: ",n))),l.a.createElement(V.a.Body,{className:"p-2",style:{minHeight:1e3,height:1200,minWidth:400}},l.a.createElement(K.a,{data:r,variables:i.reverse().map((function(e){return"selected"===e.actionKey||"masterful_unlabeled_switch"===e.actionKey?{key:e.actionKey,legend:e.actionLegend,type:"point",ticksPosition:"before",legendPosition:"start",legendOffset:20,padding:1,values:e.values}:{key:e.actionKey,legend:e.actionLegend,type:"linear",min:e.min,max:e.max,ticksPosition:"before",legendPosition:"start",legendOffset:20}})),margin:{top:50,right:60,bottom:50,left:60},layout:"vertical",colors:function(e){var a=e.size,t=Array(a);return t.fill("#D32F2F"),t[a-1]="#00e676",t}({size:r.length}),strokeWidth:3,lineOpacity:.8,curve:"linear",motionConfig:"molasses",theme:{fontSize:14,axis:{domain:{line:{stroke:"#dde1e9",strokeWidth:1}}}}})))},X=function(e){var a=e.title,t=e.policyName,n=e.policyEngine,r=e.data,i=e.min,s=e.max;return l.a.createElement(V.a,{className:"shadow-sm"},l.a.createElement(V.a.Header,{className:"d-flex flex-row align-items-center flex-0"},l.a.createElement("div",{className:"d-block"},l.a.createElement("h3",{className:"fw-normal mb-2"},a),l.a.createElement("h6",{className:"fw-normal mb-2"},"Policy: ",t),l.a.createElement("h6",{className:"fw-normal mb-2"},"Policy Engine: ",n))),l.a.createElement(V.a.Body,{className:"p-2",style:{minHeight:1e3,height:1e3,minWidth:400}},l.a.createElement(Y.a,{data:r,keys:["Baseline Recall","Better Recall","Worse Recall"],indexBy:"classLabel",margin:{top:50,right:130,bottom:4,left:60},padding:.3,minValue:i,isInteractive:!0,maxValue:s,colors:function(e){var a=e.id;return"Baseline Recall"===a?"#2962ff":"Better Recall"===a?"#64dd17":"#c51162"},label:function(e){var a=e.id,t=e.value,n=e.data;return"Worse Recall"==a?"-".concat(t,"%"):"".concat("Baseline Recall"==a?n["Actual Baseline Recall"]:t,"%")},valueScale:{type:"linear"},indexScale:{type:"band",round:!0},axisBottom:null,axisRight:null,axisTop:{tickSize:5,tickPadding:5,tickRotation:0,legend:"Class Label",legendPosition:"middle",legendOffset:-32},axisLeft:{tickSize:5,tickPadding:5,tickRotation:0,legend:"Recall",legendPosition:"middle",legendOffset:-40},labelSkipWidth:12,labelSkipHeight:12,labelTextColor:"#ffffff",legends:[{dataFrom:"keys",anchor:"bottom-right",direction:"column",justify:!1,translateX:80,translateY:0,itemsSpacing:2,itemWidth:100,itemHeight:20,itemDirection:"left-to-right",itemOpacity:.85,symbolSize:20,effects:[{on:"hover",style:{itemOpacity:1}}]}]})),l.a.createElement("p",{class:"lead chart-description-paragraph"},"Recall is defined as TP / P, or equivalently, TP / (TP + FN). The term Recall has the same meaning as True Positive Rate and sensitivity."))},G=function(e){var a=e.title,t=e.policyName,n=e.policyEngine,r=e.data,i=e.min,s=e.max;return l.a.createElement(V.a,{className:"shadow-sm"},l.a.createElement(V.a.Header,{className:"d-flex flex-row align-items-center flex-0"},l.a.createElement("div",{className:"d-block"},l.a.createElement("h3",{className:"fw-normal mb-2"},a),l.a.createElement("h6",{className:"fw-normal mb-2"},"Policy: ",t),l.a.createElement("h6",{className:"fw-normal mb-2"},"Policy Engine: ",n))),l.a.createElement(V.a.Body,{className:"p-2",style:{minHeight:1e3,height:1e3,minWidth:400}},l.a.createElement(Y.a,{data:r,keys:["Baseline Precision","Better Precision","Worse Precision"],indexBy:"classLabel",margin:{top:50,right:140,bottom:4,left:60},padding:.3,minValue:i,maxValue:s,theme:{fontSize:16},colors:function(e){var a=e.id;return"Baseline Precision"===a?"#2962ff":"Better Precision"===a?"#64dd17":"#c51162"},label:function(e){var a=e.id,t=e.value,n=e.data;return"Worse Precision"==a?"-".concat(t,"%"):"".concat("Baseline Precision"==a?n["Actual Baseline Precision"]:t,"%")},valueScale:{type:"linear"},indexScale:{type:"band",round:!0},axisBottom:null,axisRight:null,axisTop:{tickSize:5,tickPadding:5,tickRotation:0,legend:"Class Prediction",legendPosition:"middle",legendOffset:-32},axisLeft:{tickSize:5,tickPadding:5,tickRotation:0,legend:"Precision",legendPosition:"middle",legendOffset:-40},labelSkipWidth:12,labelSkipHeight:12,labelTextColor:"#ffffff",legends:[{dataFrom:"keys",anchor:"bottom-right",direction:"column",justify:!1,translateX:80,translateY:0,itemsSpacing:2,itemWidth:100,itemHeight:20,itemDirection:"left-to-right",itemOpacity:.85,symbolSize:20,effects:[{on:"hover",style:{itemOpacity:1}}]}]})),l.a.createElement("p",{class:"lead chart-description-paragraph"},"Precision is defined as TP / PP, where PP means Predicted Positives. Or equivalently, TP / (TP + FP). The term Precision has the same meaning as Positive Predictive Value."))},Z=function(e){var a=e.title,t=e.datasetTitle,n=e.keys,r=e.data;return l.a.createElement(V.a,{className:"shadow-sm"},l.a.createElement(V.a.Header,{className:"d-flex flex-row align-items-center flex-0"},l.a.createElement("div",{className:"d-block"},l.a.createElement("h3",{className:"fw-normal mb-2"},a),l.a.createElement("h6",{className:"fw-normal mb-2"},"Dataset: ",t))),l.a.createElement(V.a.Body,{className:"p-2",style:{minHeight:1e3,height:1e3,minWidth:400}},l.a.createElement(Y.a,{data:r,keys:n,indexBy:"classLabel",margin:{top:50,right:130,bottom:50,left:100},padding:.3,colors:function(e){var a=e.id;return"train"===a?"#64dd17":"test"===a?"#c51162":"val"===a?"#ffd600":"#64dd17"},groupMode:"grouped",layout:"horizontal",valueScale:{type:"linear"},indexScale:{type:"band",round:!0},axisTop:null,axisRight:null,axisBottom:{tickSize:5,tickPadding:5,tickRotation:0,legend:"# Labels",legendPosition:"middle",legendOffset:32},axisLeft:{tickSize:5,tickPadding:5,tickRotation:0,legend:"Class Labels",legendPosition:"middle",legendOffset:-60},labelSkipWidth:12,labelSkipHeight:12,labelTextColor:"#ffffff",legends:[{dataFrom:"keys",anchor:"bottom-right",direction:"column",justify:!1,translateX:120,translateY:0,itemsSpacing:2,itemWidth:100,itemHeight:20,itemDirection:"left-to-right",itemOpacity:.85,symbolSize:20,effects:[{on:"hover",style:{itemOpacity:1}}]}]})))},q=function(e){var a=e.title,t=e.policyName,n=e.policyEngine,r=e.data,i=e.keys,s=e.maxVal;return l.a.createElement(V.a,{className:"shadow-sm"},l.a.createElement(V.a.Header,{className:"d-flex flex-row align-items-center flex-0"},l.a.createElement("div",{className:"d-block"},l.a.createElement("h3",{className:"fw-normal mb-2"},a),l.a.createElement("h6",{className:"fw-normal mb-2"},"Policy: ",t),l.a.createElement("h6",{className:"fw-normal mb-2"},"Policy Engine: ",n))),l.a.createElement(V.a.Body,{className:"p-2",style:{minHeight:1e3,height:1e3,minWidth:400}},l.a.createElement(Y.a,{data:r,keys:i,indexBy:"technique",margin:{top:50,right:130,bottom:50,left:60},padding:.3,minValue:0,maxValue:s,colors:function(e){var a=e.id,t=e.data;return"lowerPart"===a||"upperPart"===a?"#0000":"original"===t.technique?"#9e9e9e":"with Masterful"===t.technique?"#00796b":"#80cbc4"},valueScale:{type:"linear"},indexScale:{type:"band",round:!0},axisTop:null,axisRight:null,axisBottom:{tickSize:5,tickPadding:5,tickRotation:0,legend:"Technique",legendPosition:"middle",legendOffset:32},axisLeft:{tickSize:5,tickPadding:5,tickRotation:0,legend:"Val loss",legendPosition:"middle",legendOffset:-50},labelSkipWidth:12,labelSkipHeight:12,labelTextColor:"#ffffff"})))},$=function(e){var a=e.policyName,t=e.policyEngine,n=e.data,r=e.reductionRate;return l.a.createElement(V.a,{className:"shadow-sm"},l.a.createElement(V.a.Header,{className:"d-flex flex-row align-items-center flex-0"},l.a.createElement("div",{className:"d-block"},l.a.createElement("h3",{className:"fw-normal mb-2"},"Error Rate Reduction"),l.a.createElement("h4",{className:"fw-normal mb-2"},"Reduction: ",r,"%"),l.a.createElement("h6",{className:"fw-normal mb-2"},"Policy: ",a),l.a.createElement("h6",{className:"fw-normal mb-2"},"Policy Engine: ",t))),l.a.createElement(V.a.Body,{className:"p-2",style:{minHeight:1e3,height:1e3,minWidth:400}},l.a.createElement(Y.a,{data:n,keys:["errorRate"],indexBy:"Model",margin:{top:50,right:130,bottom:50,left:60},padding:.3,minValue:0,colors:function(e){return"Original"===e.data.Model?"#80cbc4":"#00796b"},label:function(e){var a=e.value;return"".concat(a,"%")},valueScale:{type:"linear"},indexScale:{type:"band",round:!0},theme:{fontSize:14},axisTop:null,axisRight:null,axisBottom:{tickSize:5,tickPadding:5,tickRotation:0,legend:"Model",legendPosition:"middle",legendOffset:32},axisLeft:{tickSize:5,tickPadding:5,tickRotation:0,legend:"Error Rate",legendPosition:"middle",legendOffset:-40},labelSkipWidth:12,labelSkipHeight:12,labelTextColor:"#ffffff"})))},ee="http://127.0.0.1:7007/",ae={"Access-Control-Allow-Origin":"*","Access-Control-Allow-Methods":"*","Access-Control-Allow-Headers":"*"},te=function(e){Object(T.a)(t,e);var a=Object(j.a)(t);function t(e){var n;return Object(D.a)(this,t),(n=a.call(this,e)).state={selectedDatasetIndex:null,datasets:[],intervalId:null},n}return Object(M.a)(t,[{key:"componentDidMount",value:function(){var e=this;this.sync_();var a=setInterval((function(){e.sync_()}),6e5);this.setState({intervalId:a})}},{key:"componentWillUnmount",value:function(){null!==this.state.intervalId&&(clearInterval(this.state.intervalId),this.setState({intervalId:null}))}},{key:"sync_",value:function(){var e=this;W.a.get(String(ee+"scan/"),{headers:ae}).then((function(e){return W.a.get(String(ee+"api/dataset/"),{headers:ae})})).then((function(a){if(a.data.length>0){var t=a.data.slice();e.setState({datasets:t})}})).catch((function(e){console.log(e)}))}},{key:"createLabelDistributionKeys_",value:function(e){var a=[];return"ALL"===e.split?(a.push("train"),a.push("test"),e.val_cardinality>0&&a.push("val")):a.push("overall"),a}},{key:"createLabelDistributionWidgetData_",value:function(e){var a=[];if("ALL"===e.split)for(var t=0;t<e.num_classes;t++){var n={};n.classLabel=e.labels_map[t]?e.labels_map[t]:t,n.train=e.train_label_distribution[t],n.test=e.test_label_distribution[t],e.val_cardinality>0&&(n.val=e.val_label_distribution[t]),a.push(n)}else for(var l=0;l<e.num_classes;l++){var r={};r.classLabel=e.labels_map[l],r.overall=e.total_label_distribution[l],a.push(r)}return a}},{key:"render",value:function(){var e=this,a={datasetTitle:"",labelDistributionWidgetKeys:[],labelDistributionWidgetData:[]};if(0!==this.state.datasets.length&&null!==this.state.selectedDatasetIndex){var t=this.state.selectedDatasetIndex,n=this.state.datasets[t];a.datasetTitle=n.title,a.labelDistributionWidgetKeys=this.createLabelDistributionKeys_(n),a.labelDistributionWidgetData=this.createLabelDistributionWidgetData_(n)}var r=function(a){var t=e.state.datasets.findIndex((function(e){return e.title===a}));e.setState({selectedDatasetIndex:t})};return null!==this.state.selectedDatasetIndex?l.a.createElement(l.a.Fragment,null,l.a.createElement(C.a,{className:"justify-content-md-center"},l.a.createElement(I.a,{xs:12,className:"mb-4"},l.a.createElement(z,{datasets:this.state.datasets,onTableRowClick:r})),l.a.createElement(I.a,{xs:12,className:"mb-4 d-none d-sm-block"},l.a.createElement(Z,{title:"Label Distribution",datasetTitle:a.datasetTitle,data:a.labelDistributionWidgetData,keys:a.labelDistributionWidgetKeys})))):l.a.createElement(l.a.Fragment,null,l.a.createElement(C.a,{className:"justify-content-md-center"},l.a.createElement(I.a,{xs:12,className:"mb-4"},l.a.createElement(z,{datasets:this.state.datasets,onTableRowClick:r}))))}}]),t}(l.a.Component),ne=t(81),le=t.n(ne),re=t(20),ie=function(e,a){var t,n=-1,l=Object(re.a)(e.val_metrics);try{for(l.s();!(t=l.n()).done;){var r=t.value;if(le.a.isEqual(r.node_scalar_map,a)){n=r.metrics.loss;break}}}catch(i){l.e(i)}finally{l.f()}return-1===n&&console.log("No val_loss found for scalar: ".concat(a," in task: ").concat(e.title)),n},se=function(e,a){return e<=0?(console.log("Error: total cannot be <= 0"),-1):100*a/e},ce=function(e){if(!e.fit_was_captured)return!1;var a=e.node_search_tasks.length,t=e.node_search_tasks[a-1];return"UNLABELED_DATA_SSL"===t.type&&0!==t.node_optimal_scalar_map.masterful_unlabeled_switch},oe=function(e){var a=e.node_optimal_scalar_map;return Object.values(a).some((function(e){return e>0}))},me=function(e){for(var a=[],t=Object.keys(e.node_scalars_map),n=e.node_scalars_map[t[0]].scalars.length,l=0;l<n;l++){var r,i={},s=Object(re.a)(t);try{for(s.s();!(r=s.n()).done;){var c=r.value;i[c]=e.node_scalars_map[c].scalars[l]}}catch(o){s.e(o)}finally{s.f()}a.push(i)}return a},ue=function(e,a){var t=arguments.length>2&&void 0!==arguments[2]&&arguments[2],n=[];if(e.type===H){var l,r=Object(re.a)(e.searched_layers);try{for(r.s();!(l=r.n()).done;){var i=l.value;n=n.concat(de(i,a[i.name],t))}}catch(s){r.e(s)}finally{r.f()}}else n.push(a[e.title]);return n},de=function(e,a){var t=arguments.length>2&&void 0!==arguments[2]&&arguments[2];if("MASTERFUL_SAMPLE_MAG_BY_QUANTILE_LAYER"!==e.layer_type)return[a];if(0===a){if(t)return[0];var n=new Array(e.ordered_actions.length).fill(0);return n}for(var l=[],r=a-1,i=0;i<e.ordered_actions.length;i++){var s=e.max_index_grid[i].values[r],c=s-1,o=e.action_mag_grid[i].values[c];l.push(o)}if(t&&l.length>0){var m=0;l.forEach((function(e){return m+=e}));var u=m/l.length;return[Math.floor(100*u)/100]}return l},fe=function(e,a,t){var n=[],l={upperPart:0,lowerPart:0,technique:"original"};l.impValue=Math.floor(1e5*e)/1e5,n.push(l);for(var r=0,i=0,s=Object.keys(t);i<s.length;i++){var c=s[i],o=Math.floor(1e5*t[c])/1e5;if(0!==o){var m={};m.upperPart=r,m.technique=c,m.impValue=o,m.lowerPart=e-r-m.impValue,n.push(m),r+=m.impValue}}var u=e-a,d={};return d.upperPart=Math.floor(1e5*u)/1e5,d.lowerPart=0,d.technique="with Masterful",d.impValue=Math.floor(1e5*a)/1e5,n.push(d),n},he=function(e){return ie(e,e.node_optimal_scalar_map)},pe=function(e){return e.presearch_model_val_metrics.loss},ge=function(e,a){for(var t={},n=0,l=Object.keys(e);n<l.length;n++){var r=l[n];t[r]=e[r]*a/100}return t},ve=function(e,a,t){var n,l={},r=a,i=Object(re.a)(e.node_search_tasks);try{for(i.s();!(n=i.n()).done;){var s=n.value;if(!s.title.includes("unlabeled")){var c=be(s);if(oe(s)){var o=ye(s,r,t);l[c]=o;var m=ie(s,s.node_optimal_scalar_map);if(-1===m)return console.log("Error: did not expect node optimal val loss to be missing."),null;r=m}else l[c]=0}}}catch(u){i.e(u)}finally{i.f()}return l},ye=function(e,a,t){var n=ie(e,e.node_optimal_scalar_map);if(-1===n)return-1;var l=a-n;if(l<0)return console.log("Optimal node val loss cannot be worse than previous optimal val loss."),-1;var r=se(t,l);return-1===r?-1:r},Ae=function(e){if(0===e.node_search_tasks.length)return-1;var a=function(e){var a=e.node_search_tasks.length;if(0===a)return console.log("RAY | killing analyze final loss here #1"),null;var t=a-1;e.fit_was_captured&&("UNLABELED_DATA_SSL"!==e.node_search_tasks[a-1].type?console.log("Warning: Detected a policy with fit captured and SSL node missing."):t=a-2);for(var n=t;n>=0;n--){var l=e.node_search_tasks[n];if(oe(l))return l}return null}(e);return null===a?-1:ie(a,a.node_optimal_scalar_map)},Ee=function(e){return e.fit_was_captured?e.learned_policy_val_metrics.loss:(console.log("Cannot get Masterful teacher val loss, fit was not captured."),-1)},be=function(e){var a="",t=e.type;if("SYNTHETIC_DATA_BLENDING"===t)a="Synthetic Data";else if("UNLABELED_DATA_SSL"===t)a="SSL";else if(t===H){if("MASTERFUL_SAMPLE_MAG_BY_QUANTILE_LAYER"===e.searched_layers[0].layer_type){var n,l=[],r=Object(re.a)(e.searched_layers);try{for(r.s();!(n=r.n()).done;){var i=n.value.name;if(-1!==i.indexOf("masterful")){var s=i.split("_").slice(1).join(" ");l.push(s)}else l.push(i)}}catch(o){r.e(o)}finally{r.f()}var c=l.join(" & ");a=c.length<=25?c:c.slice(0,25)}else a=e.searched_layers[0].ordered_actions[0]}else a=e.title;return a.toLowerCase()},_e=function(e){var a=e.learned_policy_val_metrics.label_recall_map;if(ce(e)){var t=e.node_search_tasks.length,n=e.node_search_tasks[t-1];if("UNLABELED_DATA_SSL"!==n.type)console.log("Expected last node to be SSL, instead got: ",n.type),console.log("Will use Masterful teacher fit training result instead.");else{var l,r=Object(re.a)(n.val_metrics);try{for(r.s();!(l=r.n()).done;){var i=l.value;if(le.a.isEqual(i.node_scalar_map,n.node_optimal_scalar_map)){a=i.metrics.label_recall_map;break}}}catch(s){r.e(s)}finally{r.f()}}}return a},ke=function(e){var a=e.learned_policy_val_metrics.label_precision_map;if(ce(e)){var t=e.node_search_tasks.length,n=e.node_search_tasks[t-1];if("UNLABELED_DATA_SSL"!==n.type)console.log("Expected last node to be SSL, instead got: ",n.type),console.log("Will use Masterful teacher fit training result instead.");else{var l,r=Object(re.a)(n.val_metrics);try{for(r.s();!(l=r.n()).done;){var i=l.value;if(le.a.isEqual(i.node_scalar_map,n.node_optimal_scalar_map)){a=i.metrics.label_precision_map;break}}}catch(s){r.e(s)}finally{r.f()}}}return a},xe=function(e){var a={errPlotData:null,errReductionRate:null},t=Ne(e.presearch_model_val_metrics.confusion_matrix);if(-1===t)return console.error("Cannot create error rate plot: baseline confusion matrix missing."),a;var n=0;if(ce(e)){var l=e.node_search_tasks.length,r=e.node_search_tasks[l-1],i=function(e,a){var t,n=null,l=Object(re.a)(e.val_metrics);try{for(l.s();!(t=l.n()).done;){var r=t.value;if(le.a.isEqual(r.node_scalar_map,a)){n=r.metrics.confusion_matrix;break}}}catch(i){l.e(i)}finally{l.f()}return null==n&&console.log("No confusion matrix found for scalar: ".concat(a," in task: ").concat(e.title)),n}(r,r.node_optimal_scalar_map);n=Ne(i)}else n=Ne(e.learned_policy_val_metrics.confusion_matrix);if(-1===n)return console.error("Failed calculating error rate, final error rate unavailable."),a;var s=se(t,t-n);s=Math.floor(100*s)/100;var c=[],o={Model:"Original"};o.errorRate=Math.floor(100*t)/100,c.push(o);var m={Model:"With Masterful"};return m.errorRate=Math.floor(100*n)/100,c.push(m),{errPlotData:c,errReductionRate:s}},Ne=function(e){var a=Pe(e);if(-1===a)return console.log("Failed computing error rate."),-1;for(var t=Object.keys(e).length,n=0,l=0;l<t;l++){var r=0;e[l].values.forEach((function(e){return r+=e})),n+=r}return 0===n?(console.log("Failed computing error rate, totalSum is 0 for: ",e),-1):100*(1-a/n)},Pe=function(e){if(void 0==e)return console.log("Failed computing true positives, no confusion matrix."),-1;for(var a=0,t=Object.keys(e).length,n=0;n<t;n++){if(void 0==e[n])return console.log("Invalid confusion matrix, no data for class: ",n," in: ",e),-1;a+=e[n].values[n]}return a},Se=function(e,a){var t=arguments.length>2&&void 0!==arguments[2]?arguments[2]:"",n=!(arguments.length>3&&void 0!==arguments[3])||arguments[3],l="",r="";if(r=n&&-1!==e.toLowerCase().indexOf("masterful")?e.split("_").slice(1).join(" "):e,a===H)l="MASTERFUL_REPLACEMENT_RATE_LAYER"===t?"(rr)":"(m)";else{if("SYNTHETIC_DATA_BLENDING"!==a)return"UNLABELED_DATA_SSL"===a?"SSL":r;l="(r)"}return String(r.toLowerCase()+" "+l)},we=function(e){var a=[],t=e.presearch_model_val_metrics.loss;a.push(t);var n,l=Object(re.a)(e.node_search_tasks);try{for(l.s();!(n=l.n()).done;){var r,i=n.value,s=me(i),c=Object(re.a)(s);try{for(c.s();!(r=c.n()).done;){var o=r.value,m=ie(i,o);-1!==m&&a.push(m)}}catch(u){c.e(u)}finally{c.f()}}}catch(u){l.e(u)}finally{l.f()}return a.sort(),{minValLoss:a[0],maxValLoss:a[a.length-1]}},Re=function(e,a){var t=e;if(a.includes(t))for(var n=1;a.includes(t);)t=String(e+"_"+n),n++;return t},Be=function(){var e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:"",a=arguments.length>1&&void 0!==arguments[1]?arguments[1]:"",t=0,n=1;return a===H&&("MASTERFUL_SAMPLE_MAG_BY_QUANTILE_LAYER"!==e&&"MASTERFUL_FIXED_MAG_LAYER"!==e||(n=100)),{min:t,max:n}},Le=function(e){var a,t=arguments.length>1&&void 0!==arguments[1]&&arguments[1],n=e.presearch_model_val_metrics.loss,l=[],r=Object(re.a)(e.node_search_tasks);try{for(r.s();!(a=r.n()).done;){var i=a.value;l=l.concat(ue(i,i.node_optimal_scalar_map,t))}}catch(o){r.e(o)}finally{r.f()}var s=e.node_search_tasks.length-1,c=ie(e.node_search_tasks[s],e.node_search_tasks[s].node_optimal_scalar_map);if(-1===c)for(;-1===c;){if(-1===(s-=1)){c=n;break}c=ie(e.node_search_tasks[s],e.node_search_tasks[s].node_optimal_scalar_map)}return l.push(c),l.push("SELECTED"),l},Oe=function(e,a){if(e.length!==a.length)return console.log("Number of action keys (".concat(e.length,") and values (").concat(a.length,") should be identical.")),[];for(var t=[],n=0;n<e.length;n++){var l=e[n],r=a[n];t[l]="masterful_unlabeled_switch"===l?De(r):r}return t},De=function(e){return 0===e?"OFF":"ON"},Me=function(e){return e.filter((function(e){return!0===e.fit_was_captured}))},Te=function(e){Object(T.a)(t,e);var a=Object(j.a)(t);function t(e){var n;return Object(D.a)(this,t),(n=a.call(this,e)).state={selectedPolicyIndex:null,policySearchTasks:[],intervalId:null},n}return Object(M.a)(t,[{key:"sync_",value:function(){var e=this;W.a.get(String(ee+"scan/"),{headers:ae}).then((function(e){return W.a.get(String(ee+"api/search/"),{headers:ae})})).then((function(a){if(a.data.length>0){var t=a.data.slice();e.setState({policySearchTasks:Me(t)})}})).catch((function(e){return console.log(e)}))}},{key:"componentDidMount",value:function(){var e=this;this.sync_();var a=setInterval((function(){e.sync_()}),6e5);this.setState({intervalId:a})}},{key:"componentWillUnmount",value:function(){null!==this.state.intervalId&&(clearInterval(this.state.intervalId),this.setState({intervalId:null}))}},{key:"render",value:function(){var e=this,a={policyName:"",policyEngine:"",plotVariables:[],actionKeys:[],recallByClassData:[],precisionByClassData:[],waterfallChartKeys:[],waterfallChartData:[],waterfallChartMaxVal:1,recallMin:0,recallMax:100,precisionMin:0,precisionMax:100,errorRateReductionValue:0,errorRateReductionData:[]},t=[];if(0!==this.state.policySearchTasks.length&&null!==this.state.selectedPolicyIndex){var n=this.state.selectedPolicyIndex,r=this.state.policySearchTasks[n],i=function(e,a){var t,n=[],l=[],r=Object(re.a)(e.node_search_tasks);try{for(r.s();!(t=r.n()).done;){var i=t.value,s=i.type;if(s===H){var c=i.searched_layers[0].layer_type;if(a&&"MASTERFUL_SAMPLE_MAG_BY_QUANTILE_LAYER"===c){var o,m=Object(re.a)(i.searched_layers);try{for(m.s();!(o=m.n()).done;){var u=o.value,d=u.name;l.push(d);var f=Be(c,s),h=f.min,p=f.max;n.push({actionKey:d,actionLegend:Se(d.toUpperCase(),s,u.layer_type),min:h,max:p})}}catch(D){m.e(D)}finally{m.f()}}else{var g,v=Object(re.a)(i.searched_layers);try{for(v.s();!(g=v.n()).done;)for(var y=g.value,A=y.ordered_actions.length,E=0;E<A;E++){var b=y.ordered_actions[E],_=Re(b,l);l.push(_);var k=Be(c,s),x=k.min,N=k.max;n.push({actionKey:_,actionLegend:Se(b,s,c),min:x,max:N})}}catch(D){v.e(D)}finally{v.f()}}}else{var P=Re(i.title,l);if(l.push(P),"UNLABELED_DATA_SSL"===s)n.push({actionKey:P,actionLegend:Se(i.title,s),values:["ON","OFF"]});else{var S=Be("",s),w=S.min,R=S.max;n.push({actionKey:P,actionLegend:Se(i.title,s),min:w,max:R})}}}}catch(D){r.e(D)}finally{r.f()}var B=we(e),L=B.minValLoss,O=B.maxValLoss;return n.push({actionKey:"val_loss",actionLegend:"val_loss",min:L-.05,max:O+.05}),n.push({actionKey:"selected",actionLegend:"Optimal Policy",values:["SELECTED","NOT SELECTED"]}),l.push("val_loss"),l.push("selected"),{currentPlotVariables:n,actionKeysSoFar:l}}(r,!0),s=i.actionKeysSoFar,c=i.currentPlotVariables;a.policyName=r.policy_name,a.policyEngine=r.engine_version,a.plotVariables=c,a.actionKeys=s,a.waterfallChartKeys=["lowerPart","impValue","upperPart"],a.waterfallChartData=function(e){var a=pe(e),t=Ae(e),n=ve(e,a,a-t),l=Ee(e),r=l,i=ge(n,a-l);if(ce(e)){var s=e.node_search_tasks.length,c=e.node_search_tasks[s-1],o=he(c);i[be(c)]=l-o,r=o}return fe(a,r,i)}(r),a.waterfallChartMaxVal=r.presearch_model_val_metrics.loss,t=(t=function(e,a,t){var n=[],l=Le(e,t);n.push(Oe(a,l));var r,i=[],s=Object(re.a)(e.node_search_tasks);try{for(s.s();!(r=s.n()).done;){var c,o=r.value,m=me(o),u=Object(re.a)(m);try{for(u.s();!(c=u.n()).done;){var d=c.value;if(!_.isEqual(d,o.node_optimal_scalar_map)){var f=[];f=f.concat(i);var h=ue(o,d,t);f=f.concat(h);var p=a.length-f.length-2;if(p>0){var g=new Array(p).fill(0);f=f.concat(g)}var v=ie(o,d);f.push(v),f.push("NOT SELECTED"),n.push(Oe(a,f))}}}catch(y){u.e(y)}finally{u.f()}i=i.concat(ue(o,o.node_optimal_scalar_map,t))}}catch(y){s.e(y)}finally{s.f()}return n}(r,s,!0)).reverse();var o=function(e){if(!e.fit_was_captured)return console.error("Fit must be captured to comput recall by class data."),[];var a=e.presearch_model_val_metrics.label_recall_map;if(!a)return console.error("Baseline metrics unavailable. Label recall failed."),[];var t=_e(e);if(!t)return console.error("Failed getting final recall map for policy: ",e),[];if(Object.keys(a).length!==Object.keys(t).length)return console.error("BaselineRecallMap & finalRecallMap must same amount : "),[];for(var n=[],l=0;l<Object.keys(a).length;l++){var r={};r.classLabel=l,r["Actual Baseline Recall"]=Math.floor(1e4*a[l])/100;var i=Math.floor(1e4*(t[l]-a[l]))/100;i>0?(r["Better Recall"]=i,r["Baseline Recall"]=r["Actual Baseline Recall"]):(r["Worse Recall"]=Math.abs(i),r["Baseline Recall"]=r["Actual Baseline Recall"]-r["Worse Recall"]),n.push(r)}return n}(r);a.recallByClassData=o;var m=function(e){if(!e.fit_was_captured)return console.error("Fit must be captured to comput precision by class data."),[];var a=e.presearch_model_val_metrics.label_precision_map;if(!a)return console.error("Baseline metrics unavailable. Label precision failed."),[];var t=ke(e);if(!t)return console.error("Failed getting final precision map for policy: ",e),[];if(Object.keys(a).length!==Object.keys(t).length)return console.error("baselinePrecisionMap & finalPrecisionMap must same amount : "),[];for(var n=[],l=0;l<Object.keys(a).length;l++){var r={};r.classLabel=l,r["Actual Baseline Precision"]=Math.floor(1e4*a[l])/100;var i=Math.floor(1e4*(t[l]-a[l]))/100;i>0?(r["Better Precision"]=i,r["Baseline Precision"]=r["Actual Baseline Precision"]):(r["Worse Precision"]=Math.abs(i),r["Baseline Precision"]=r["Actual Baseline Precision"]-r["Worse Precision"]),n.push(r)}return n}(r);a.precisionByClassData=m;var u=function(e){if(null===e||0===e.length)return{recallMin:0,recallMax:100};var a,t=100,n=0,l=Object(re.a)(e);try{for(l.s();!(a=l.n()).done;){var r=a.value;if(0!==r["Baseline Recall"]){r["Baseline Recall"]<t&&(t=r["Baseline Recall"]);var i=0;void 0===r["Worse Recall"]?i+=r["Baseline Recall"]+r["Better Recall"]:i+=r["Actual Baseline Recall"],i>n&&(n=i)}}}catch(s){l.e(s)}finally{l.f()}return{recallMin:t=Math.max(0,t-2),recallMax:n=Math.min(100,n+2)}}(o),d=u.recallMin,f=u.recallMax,h=function(e){if(null===e||0===e.length)return{precisionMin:0,precisionMax:100};var a,t=100,n=0,l=Object(re.a)(e);try{for(l.s();!(a=l.n()).done;){var r=a.value;if(0!==r["Baseline Precision"]){r["Baseline Precision"]<t&&(t=r["Baseline Precision"]);var i=0;void 0===r["Worse Precision"]?i+=r["Baseline Precision"]+r["Better Precision"]:i+=r["Actual Baseline Precision"],i>n&&(n=i)}}}catch(s){l.e(s)}finally{l.f()}return{precisionMin:t=Math.max(0,t-2),precisionMax:n=Math.min(100,n+2)}}(m),p=h.precisionMin,g=h.precisionMax;a.recallMin=Math.min(d,p),a.recallMax=Math.max(f,g),a.precisionMin=Math.min(d,p),a.precisionMax=Math.max(f,g);var v=xe(r),y=v.errPlotData,A=v.errReductionRate;a.errorRateReductionValue=A,a.errorRateReductionData=y}var E=function(a){var t=e.state.policySearchTasks.findIndex((function(e){return e.policy_name===a}));e.setState({selectedPolicyIndex:t})};return null!==this.state.selectedPolicyIndex?l.a.createElement(l.a.Fragment,null,l.a.createElement(C.a,{className:"justify-content-md-center post-search-parallel-coords-card"},l.a.createElement(I.a,{xs:12,className:"mb-4"},l.a.createElement(U,{policies:this.state.policySearchTasks,onTableRowClick:E})),l.a.createElement(I.a,{xs:12,className:"mb-4 d-none d-sm-block"},l.a.createElement(J,{title:"Policy Components",policyName:a.policyName,policyEngine:a.policyEngine,plotVariables:a.plotVariables,plotData:t})),l.a.createElement(I.a,{xs:12,className:"mb-4 d-none d-sm-block"},l.a.createElement(q,{title:"Validation Loss Improvement",policyName:a.policyName,policyEngine:a.policyEngine,data:a.waterfallChartData,keys:a.waterfallChartKeys,maxVal:a.waterfallChartMaxVal})),function(){if(a.recallByClassData.length>0)return l.a.createElement(I.a,{xs:12,className:"mb-4 d-none d-sm-block"},l.a.createElement(X,{title:"Recall Improvement",policyName:a.policyName,policyEngine:a.policyEngine,data:a.recallByClassData,min:a.recallMin,max:a.recallMax}))}(),function(){if(a.precisionByClassData.length>0)return l.a.createElement(I.a,{xs:12,className:"mb-4 d-none d-sm-block"},l.a.createElement(G,{title:"Precision Improvement",policyName:a.policyName,policyEngine:a.policyEngine,data:a.precisionByClassData,min:a.precisionMin,max:a.precisionMax}))}(),function(){if(null!=a.errorRateReductionData)return l.a.createElement(I.a,{xs:12,className:"mb-4 d-none d-sm-block"},l.a.createElement($,{policyName:a.policyName,policyEngine:a.policyEngine,data:a.errorRateReductionData,reductionRate:a.errorRateReductionValue}))}())):l.a.createElement(l.a.Fragment,null,l.a.createElement(C.a,{className:"justify-content-md-center post-search-parallel-coords-card"},l.a.createElement(I.a,{xs:12,className:"mb-4"},l.a.createElement(U,{policies:this.state.policySearchTasks,onTableRowClick:E}))))}}]),t}(l.a.Component),je=function(e){Object(T.a)(t,e);var a=Object(j.a)(t);function t(e){return Object(D.a)(this,t),a.call(this,e)}return Object(M.a)(t,[{key:"render",value:function(){return l.a.createElement(l.a.Fragment,null,l.a.createElement("iframe",{src:" https://masterful-public.s3.us-west-1.amazonaws.com/933013963/0.3.5/index.html",title:"Documentation",width:"100%",height:"2000"}))}}]),t}(l.a.Component),Ce=function(e){var a=e.component,t=Object(o.a)(e,["component"]),r=Object(n.useState)(!1),i=Object(c.a)(r,2),s=i[0],u=i[1];Object(n.useEffect)((function(){var e=setTimeout((function(){return u(!0)}),1e3);return function(){return clearTimeout(e)}}),[]);var d=Object(n.useState)((function(){return"false"!==localStorage.getItem("settingsVisible")})),f=Object(c.a)(d,2);f[0],f[1];return l.a.createElement(m.b,Object.assign({},t,{render:function(e){return l.a.createElement(l.a.Fragment,null,l.a.createElement(h,{show:!s}),l.a.createElement(O,null),l.a.createElement("main",{className:"content"},l.a.createElement(a,e)))}}))},Ie=function(){return l.a.createElement(m.d,null,l.a.createElement(Ce,{exact:!0,path:R.path,component:Te}),l.a.createElement(Ce,{exact:!0,path:B.path,component:te}),l.a.createElement(Ce,{exact:!0,path:L.path,component:je}),l.a.createElement(m.a,{to:R.path}))},Fe=function(){var e=Object(m.g)().pathname;return Object(n.useEffect)((function(){window.scrollTo({top:0,left:0,behavior:"auto"})}),[e]),null};i.a.render(l.a.createElement(s.a,null,l.a.createElement(Fe,null),l.a.createElement(Ie,null)),document.getElementById("root"))}},[[422,1,2]]]);
//# sourceMappingURL=main.28d69b33.chunk.js.map