import { Duration, Resource } from '@aws-cdk/core';
import { Construct } from 'constructs';
/**
 * (experimental) Represents a Cache Policy.
 *
 * @experimental
 */
export interface ICachePolicy {
    /**
     * (experimental) The ID of the cache policy.
     *
     * @experimental
     * @attribute true
     */
    readonly cachePolicyId: string;
}
/**
 * (experimental) Properties for creating a Cache Policy.
 *
 * @experimental
 */
export interface CachePolicyProps {
    /**
     * (experimental) A unique name to identify the cache policy.
     *
     * The name must only include '-', '_', or alphanumeric characters.
     *
     * @default - generated from the `id`
     * @experimental
     */
    readonly cachePolicyName?: string;
    /**
     * (experimental) A comment to describe the cache policy.
     *
     * @default - no comment
     * @experimental
     */
    readonly comment?: string;
    /**
     * (experimental) The default amount of time for objects to stay in the CloudFront cache.
     *
     * Only used when the origin does not send Cache-Control or Expires headers with the object.
     *
     * @default - The greater of 1 day and ``minTtl``
     * @experimental
     */
    readonly defaultTtl?: Duration;
    /**
     * (experimental) The minimum amount of time for objects to stay in the CloudFront cache.
     *
     * @default Duration.seconds(0)
     * @experimental
     */
    readonly minTtl?: Duration;
    /**
     * (experimental) The maximum amount of time for objects to stay in the CloudFront cache.
     *
     * CloudFront uses this value only when the origin sends Cache-Control or Expires headers with the object.
     *
     * @default - The greater of 1 year and ``defaultTtl``
     * @experimental
     */
    readonly maxTtl?: Duration;
    /**
     * (experimental) Determines whether any cookies in viewer requests are included in the cache key and automatically included in requests that CloudFront sends to the origin.
     *
     * @default CacheCookieBehavior.none()
     * @experimental
     */
    readonly cookieBehavior?: CacheCookieBehavior;
    /**
     * (experimental) Determines whether any HTTP headers are included in the cache key and automatically included in requests that CloudFront sends to the origin.
     *
     * @default CacheHeaderBehavior.none()
     * @experimental
     */
    readonly headerBehavior?: CacheHeaderBehavior;
    /**
     * (experimental) Determines whether any query strings are included in the cache key and automatically included in requests that CloudFront sends to the origin.
     *
     * @default CacheQueryStringBehavior.none()
     * @experimental
     */
    readonly queryStringBehavior?: CacheQueryStringBehavior;
    /**
     * (experimental) Whether to normalize and include the `Accept-Encoding` header in the cache key when the `Accept-Encoding` header is 'gzip'.
     *
     * @default false
     * @experimental
     */
    readonly enableAcceptEncodingGzip?: boolean;
}
/**
 * (experimental) A Cache Policy configuration.
 *
 * @experimental
 * @resource AWS::CloudFront::CachePolicy
 */
export declare class CachePolicy extends Resource implements ICachePolicy {
    /**
     * (experimental) Optimize cache efficiency by minimizing the values that CloudFront includes in the cache key.
     *
     * Query strings and cookies are not included in the cache key, and only the normalized 'Accept-Encoding' header is included.
     *
     * @experimental
     */
    static readonly CACHING_OPTIMIZED: ICachePolicy;
    /**
     * (experimental) Optimize cache efficiency by minimizing the values that CloudFront includes in the cache key.
     *
     * Query strings and cookies are not included in the cache key, and only the normalized 'Accept-Encoding' header is included.
     * Disables cache compression.
     *
     * @experimental
     */
    static readonly CACHING_OPTIMIZED_FOR_UNCOMPRESSED_OBJECTS: ICachePolicy;
    /**
     * (experimental) Disables caching.
     *
     * This policy is useful for dynamic content and for requests that are not cacheable.
     *
     * @experimental
     */
    static readonly CACHING_DISABLED: ICachePolicy;
    /**
     * (experimental) Designed for use with an origin that is an AWS Elemental MediaPackage endpoint.
     *
     * @experimental
     */
    static readonly ELEMENTAL_MEDIA_PACKAGE: ICachePolicy;
    /**
     * (experimental) Imports a Cache Policy from its id.
     *
     * @experimental
     */
    static fromCachePolicyId(scope: Construct, id: string, cachePolicyId: string): ICachePolicy;
    /** Use an existing managed cache policy. */
    private static fromManagedCachePolicy;
    /**
     * (experimental) The ID of the cache policy.
     *
     * @experimental
     */
    readonly cachePolicyId: string;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props?: CachePolicyProps);
    private renderCacheKey;
}
/**
 * (experimental) Determines whether any cookies in viewer requests are included in the cache key and automatically included in requests that CloudFront sends to the origin.
 *
 * @experimental
 */
export declare class CacheCookieBehavior {
    /**
     * (experimental) Cookies in viewer requests are not included in the cache key and are not automatically included in requests that CloudFront sends to the origin.
     *
     * @experimental
     */
    static none(): CacheCookieBehavior;
    /**
     * (experimental) All cookies in viewer requests are included in the cache key and are automatically included in requests that CloudFront sends to the origin.
     *
     * @experimental
     */
    static all(): CacheCookieBehavior;
    /**
     * (experimental) Only the provided `cookies` are included in the cache key and automatically included in requests that CloudFront sends to the origin.
     *
     * @experimental
     */
    static allowList(...cookies: string[]): CacheCookieBehavior;
    /**
     * (experimental) All cookies except the provided `cookies` are included in the cache key and automatically included in requests that CloudFront sends to the origin.
     *
     * @experimental
     */
    static denyList(...cookies: string[]): CacheCookieBehavior;
    /**
     * (experimental) The behavior of cookies: allow all, none, an allow list, or a deny list.
     *
     * @experimental
     */
    readonly behavior: string;
    /**
     * (experimental) The cookies to allow or deny, if the behavior is an allow or deny list.
     *
     * @experimental
     */
    readonly cookies?: string[];
    private constructor();
}
/**
 * (experimental) Determines whether any HTTP headers are included in the cache key and automatically included in requests that CloudFront sends to the origin.
 *
 * @experimental
 */
export declare class CacheHeaderBehavior {
    /**
     * (experimental) HTTP headers are not included in the cache key and are not automatically included in requests that CloudFront sends to the origin.
     *
     * @experimental
     */
    static none(): CacheHeaderBehavior;
    /**
     * (experimental) Listed headers are included in the cache key and are automatically included in requests that CloudFront sends to the origin.
     *
     * @experimental
     */
    static allowList(...headers: string[]): CacheHeaderBehavior;
    /**
     * (experimental) If the no headers will be passed, or an allow list of headers.
     *
     * @experimental
     */
    readonly behavior: string;
    /**
     * (experimental) The headers for the allow/deny list, if applicable.
     *
     * @experimental
     */
    readonly headers?: string[];
    private constructor();
}
/**
 * (experimental) Determines whether any URL query strings in viewer requests are included in the cache key and automatically included in requests that CloudFront sends to the origin.
 *
 * @experimental
 */
export declare class CacheQueryStringBehavior {
    /**
     * (experimental) Query strings in viewer requests are not included in the cache key and are not automatically included in requests that CloudFront sends to the origin.
     *
     * @experimental
     */
    static none(): CacheQueryStringBehavior;
    /**
     * (experimental) All query strings in viewer requests are included in the cache key and are automatically included in requests that CloudFront sends to the origin.
     *
     * @experimental
     */
    static all(): CacheQueryStringBehavior;
    /**
     * (experimental) Only the provided `queryStrings` are included in the cache key and automatically included in requests that CloudFront sends to the origin.
     *
     * @experimental
     */
    static allowList(...queryStrings: string[]): CacheQueryStringBehavior;
    /**
     * (experimental) All query strings except the provided `queryStrings` are included in the cache key and automatically included in requests that CloudFront sends to the origin.
     *
     * @experimental
     */
    static denyList(...queryStrings: string[]): CacheQueryStringBehavior;
    /**
     * (experimental) The behavior of query strings -- allow all, none, only an allow list, or a deny list.
     *
     * @experimental
     */
    readonly behavior: string;
    /**
     * (experimental) The query strings to allow or deny, if the behavior is an allow or deny list.
     *
     * @experimental
     */
    readonly queryStrings?: string[];
    private constructor();
}
