# -*- coding: utf-8 -*-
"""
    Secret Sharing
    ~~~~~

    :copyright: (c) 2014 by Halfmoon Labs
    :license: MIT, see LICENSE for more details.
"""

# Comment the following out for posterity. These numbers never change, why are we calculating them?

# def calculate_mersenne_primes():
#     """ Returns all the mersenne primes with less than 500 digits.
#         All primes:
#         3, 7, 31, 127, 8191, 131071, 524287, 2147483647L, 2305843009213693951L,
#         618970019642690137449562111L, 162259276829213363391578010288127L,
#         170141183460469231731687303715884105727L,
#         68647976601306097149...12574028291115057151L, (157 digits)
#         53113799281676709868...70835393219031728127L, (183 digits)
#         10407932194664399081...20710555703168729087L, (386 digits)
#     """
#     mersenne_prime_exponents = [
#         2, 3, 5, 7, 13, 17, 19, 31, 61, 89, 107, 127, 521, 607, 1279
#     ]
#     return [pow(2, exp) - 1 for exp in mersenne_prime_exponents]

# SMALLEST_257BIT_PRIME = (2**256 + 297)
# SMALLEST_321BIT_PRIME = (2**320 + 27)
# SMALLEST_385BIT_PRIME = (2**384 + 231)
# STANDARD_PRIMES = calculate_mersenne_primes() + [
#     SMALLEST_257BIT_PRIME, SMALLEST_321BIT_PRIME, SMALLEST_385BIT_PRIME
# ]
# STANDARD_PRIMES.sort()

def get_large_enough_prime(batch):
    """ Returns a prime number that is greater than all the numbers in the batch.
    """
    # build a list of primes
    # find a prime that is greater than all the numbers in the batch
    # pylint: disable=line-too-long
    standard_primes = [
        3, 7, 31, 127, 8191, 131071, 524287, 2147483647, 2305843009213693951,
        618970019642690137449562111, 162259276829213363391578010288127,
        170141183460469231731687303715884105727,
        115792089237316195423570985008687907853269984665640564039457584007913129640233,
        2135987035920910082395021706169552114602704522356652769947041607822219725780640550022962086936603,
        39402006196394479212279040100143613805079739270465446667948293404245721771497210611414266254884915640806627990307047,
        6864797660130609714981900799081393217269435300143305409394463459185543183397656052122559640661454554977296311391480858037121987999716643812574028291115057151,
        531137992816767098689588206552468627329593117727031923199444138200403559860852242739162502265229285668889329486246501015346579337652707239409519978766587351943831270835393219031728127,
        10407932194664399081925240327364085538615262247266704805319112350403608059673360298012239441732324184842421613954281007791383566248323464908139906605677320762924129509389220345773183349661583550472959420547689811211693677147548478866962501384438260291732348885311160828538416585028255604666224831890918801847068222203140521026698435488732958028878050869736186900714720710555703168729087
    ]
    for prime in standard_primes:
        if not [i for i in batch if i > prime]:
            return prime
    return None
