import { DOMWidgetModel, DOMWidgetView, ISerializers, Dict } from '@jupyter-widgets/base';
export declare class CanvasModel extends DOMWidgetModel {
    defaults(): any;
    static serializers: ISerializers;
    initialize(attributes: any, options: any): void;
    private drawImageData;
    private onCommand;
    private processCommand;
    private drawRects;
    private fillArc;
    private strokeArc;
    private drawArcs;
    private drawImage;
    private _drawImage;
    private putImageData;
    private setAttr;
    private clearCanvas;
    private executeCommand;
    private forEachView;
    private resizeCanvas;
    private syncImageData;
    static model_name: string;
    static model_module: any;
    static model_module_version: any;
    static view_name: string;
    static view_module: any;
    static view_module_version: any;
    canvas: HTMLCanvasElement;
    ctx: CanvasRenderingContext2D;
    views: Dict<Promise<CanvasView>>;
}
export declare class CanvasView extends DOMWidgetView {
    render(): void;
    clear(): void;
    updateCanvas(): void;
    protected resizeCanvas(): void;
    private onMouseMove;
    private onMouseDown;
    private onMouseUp;
    private onMouseOut;
    private onTouchStart;
    private onTouchEnd;
    private onTouchMove;
    private onTouchCancel;
    protected getCoordinates(event: MouseEvent | Touch): {
        x: number;
        y: number;
    };
    canvas: HTMLCanvasElement;
    ctx: CanvasRenderingContext2D;
    model: CanvasModel;
}
export declare class MultiCanvasModel extends DOMWidgetModel {
    defaults(): any;
    static serializers: ISerializers;
    initialize(attributes: any, options: any): void;
    private updateListeners;
    private syncImageData;
    static model_name: string;
    static model_module: any;
    static model_module_version: any;
    static view_name: string;
    static view_module: any;
    static view_module_version: any;
}
export declare class MultiCanvasView extends DOMWidgetView {
    render(): void;
    private updateCanvasViews;
    private createCanvasView;
    private removeCanvasView;
    private container;
    private canvas_views;
}
