import { CustomResourceHandler } from './base';
import { SdkRequest, SdkResult } from './types';
/**
 * Flattens a nested object
 *
 * @param object the object to be flattened
 * @returns a flat object with path as keys
 */
export declare function flatten(object: object): {
    [key: string]: any;
};
export declare class SdkHandler extends CustomResourceHandler<SdkRequest, SdkResult | {
    [key: string]: string;
}> {
    protected processEvent(request: SdkRequest): Promise<SdkResult | {
        [key: string]: string;
    } | undefined>;
}
