"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ResultsCollectionHandler = void 0;
const base_1 = require("./base");
class ResultsCollectionHandler extends base_1.CustomResourceHandler {
    async processEvent(request) {
        const reduced = request.assertionResults.reduce((agg, result, idx) => {
            const msg = result.status === 'pass' ? 'pass' : `fail - ${result.message}`;
            return `${agg}\nTest${idx}: ${msg}`;
        }, '').trim();
        return { message: reduced };
    }
}
exports.ResultsCollectionHandler = ResultsCollectionHandler;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicmVzdWx0cy5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbInJlc3VsdHMudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBQUEsaUNBQStDO0FBRy9DLE1BQWEsd0JBQXlCLFNBQVEsNEJBQXdFO0lBQzFHLEtBQUssQ0FBQyxZQUFZLENBQUMsT0FBaUM7UUFDNUQsTUFBTSxPQUFPLEdBQVcsT0FBTyxDQUFDLGdCQUFnQixDQUFDLE1BQU0sQ0FBQyxDQUFDLEdBQUcsRUFBRSxNQUFNLEVBQUUsR0FBRyxFQUFFLEVBQUU7WUFDM0UsTUFBTSxHQUFHLEdBQUcsTUFBTSxDQUFDLE1BQU0sS0FBSyxNQUFNLENBQUMsQ0FBQyxDQUFDLE1BQU0sQ0FBQyxDQUFDLENBQUMsVUFBVSxNQUFNLENBQUMsT0FBTyxFQUFFLENBQUM7WUFDM0UsT0FBTyxHQUFHLEdBQUcsU0FBUyxHQUFHLEtBQUssR0FBRyxFQUFFLENBQUM7UUFDdEMsQ0FBQyxFQUFFLEVBQUUsQ0FBQyxDQUFDLElBQUksRUFBRSxDQUFDO1FBQ2QsT0FBTyxFQUFFLE9BQU8sRUFBRSxPQUFPLEVBQUUsQ0FBQztLQUM3QjtDQUNGO0FBUkQsNERBUUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBDdXN0b21SZXNvdXJjZUhhbmRsZXIgfSBmcm9tICcuL2Jhc2UnO1xuaW1wb3J0IHsgUmVzdWx0c0NvbGxlY3Rpb25SZXF1ZXN0LCBSZXN1bHRzQ29sbGVjdGlvblJlc3VsdCB9IGZyb20gJy4vdHlwZXMnO1xuXG5leHBvcnQgY2xhc3MgUmVzdWx0c0NvbGxlY3Rpb25IYW5kbGVyIGV4dGVuZHMgQ3VzdG9tUmVzb3VyY2VIYW5kbGVyPFJlc3VsdHNDb2xsZWN0aW9uUmVxdWVzdCwgUmVzdWx0c0NvbGxlY3Rpb25SZXN1bHQ+IHtcbiAgcHJvdGVjdGVkIGFzeW5jIHByb2Nlc3NFdmVudChyZXF1ZXN0OiBSZXN1bHRzQ29sbGVjdGlvblJlcXVlc3QpOiBQcm9taXNlPFJlc3VsdHNDb2xsZWN0aW9uUmVzdWx0IHwgdW5kZWZpbmVkPiB7XG4gICAgY29uc3QgcmVkdWNlZDogc3RyaW5nID0gcmVxdWVzdC5hc3NlcnRpb25SZXN1bHRzLnJlZHVjZSgoYWdnLCByZXN1bHQsIGlkeCkgPT4ge1xuICAgICAgY29uc3QgbXNnID0gcmVzdWx0LnN0YXR1cyA9PT0gJ3Bhc3MnID8gJ3Bhc3MnIDogYGZhaWwgLSAke3Jlc3VsdC5tZXNzYWdlfWA7XG4gICAgICByZXR1cm4gYCR7YWdnfVxcblRlc3Qke2lkeH06ICR7bXNnfWA7XG4gICAgfSwgJycpLnRyaW0oKTtcbiAgICByZXR1cm4geyBtZXNzYWdlOiByZWR1Y2VkIH07XG4gIH1cbn1cbiJdfQ==