"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.handler = void 0;
const assertion_1 = require("./assertion");
const results_1 = require("./results");
const sdk_1 = require("./sdk");
const types = require("./types");
async function handler(event, context) {
    const provider = createResourceHandler(event, context);
    await provider.handle();
}
exports.handler = handler;
function createResourceHandler(event, context) {
    if (event.ResourceType.startsWith(types.SDK_RESOURCE_TYPE_PREFIX)) {
        return new sdk_1.SdkHandler(event, context);
    }
    switch (event.ResourceType) {
        case types.ASSERT_RESOURCE_TYPE: return new assertion_1.AssertionHandler(event, context);
        case types.RESULTS_RESOURCE_TYPE: return new results_1.ResultsCollectionHandler(event, context);
        default:
            throw new Error(`Unsupported resource type "${event.ResourceType}`);
    }
}
//# sourceMappingURL=data:application/json;base64,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