"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AssertionHandler = void 0;
/* eslint-disable no-console */
const assert = require("assert");
const base_1 = require("./base");
class AssertionHandler extends base_1.CustomResourceHandler {
    async processEvent(request) {
        let result;
        switch (request.assertionType) {
            case 'equals':
                console.log(`Testing equality between ${JSON.stringify(request.actual)} and ${JSON.stringify(request.expected)}`);
                try {
                    assert.deepStrictEqual(request.actual, request.expected);
                    result = { data: { status: 'pass' } };
                }
                catch (e) {
                    if (e instanceof assert.AssertionError) {
                        result = {
                            data: {
                                status: 'fail',
                                message: e.message,
                            },
                        };
                    }
                    else {
                        throw e;
                    }
                }
                break;
            default:
                throw new Error(`Unsupported query type ${request.assertionType}`);
        }
        return result;
    }
}
exports.AssertionHandler = AssertionHandler;
//# sourceMappingURL=data:application/json;base64,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