"""
Copyright (C) 2015-2021 Alibaba Group Holding Limited

    HaaS Python driver for fheartbeat

    Author: HaaS
    Date:   2022/05/15
"""

from driver import ADC

class FHEARTBEAT(object):
    """
    This class implements FHEARTBEAT chip's defs.
    """

    def __init__(self, adcObj):
        self._adcObj = None
        if not isinstance(adcObj, ADC):
            raise ValueError("parameter is not an adcObj object")
        self._adcObj = adcObj

    def getVoltage(self):
        if self._adcObj is None:
            raise ValueError("invalid ADC object")
        value = self._adcObj.readVoltage()
        return value
