/**
 * (experimental) Absolute class name of the Hadoop `InputFormat` to use when reading table files.
 *
 * @experimental
 */
export declare class InputFormat {
    readonly className: string;
    /**
     * (experimental) InputFormat for Avro files.
     *
     * @see https://hive.apache.org/javadocs/r1.2.2/api/org/apache/hadoop/hive/ql/io/avro/AvroContainerInputFormat.html
     * @experimental
     */
    static readonly AVRO: InputFormat;
    /**
     * (experimental) InputFormat for Cloudtrail Logs.
     *
     * @see https://docs.aws.amazon.com/athena/latest/ug/cloudtrail.html
     * @experimental
     */
    static readonly CLOUDTRAIL: InputFormat;
    /**
     * (experimental) InputFormat for Orc files.
     *
     * @see https://hive.apache.org/javadocs/r1.2.2/api/org/apache/hadoop/hive/ql/io/orc/OrcInputFormat.html
     * @experimental
     */
    static readonly ORC: InputFormat;
    /**
     * (experimental) InputFormat for Parquet files.
     *
     * @see https://hive.apache.org/javadocs/r1.2.2/api/org/apache/hadoop/hive/ql/io/parquet/MapredParquetInputFormat.html
     * @experimental
     */
    static readonly PARQUET: InputFormat;
    /**
     * (experimental) An InputFormat for plain text files.
     *
     * Files are broken into lines. Either linefeed or
     * carriage-return are used to signal end of line. Keys are the position in the file, and
     * values are the line of text.
     * JSON & CSV files are examples of this InputFormat
     *
     * @see https://hadoop.apache.org/docs/stable/api/org/apache/hadoop/mapred/TextInputFormat.html
     * @experimental
     */
    static readonly TEXT: InputFormat;
    /**
     * @experimental
     */
    constructor(className: string);
}
/**
 * (experimental) Absolute class name of the Hadoop `OutputFormat` to use when writing table files.
 *
 * @experimental
 */
export declare class OutputFormat {
    readonly className: string;
    /**
     * (experimental) Writes text data with a null key (value only).
     *
     * @see https://hive.apache.org/javadocs/r2.2.0/api/org/apache/hadoop/hive/ql/io/HiveIgnoreKeyTextOutputFormat.html
     * @experimental
     */
    static readonly HIVE_IGNORE_KEY_TEXT: OutputFormat;
    /**
     * (experimental) OutputFormat for Avro files.
     *
     * @see https://hive.apache.org/javadocs/r1.2.2/api/org/apache/hadoop/hive/ql/io/avro/AvroContainerOutputFormat.html
     * @experimental
     */
    static readonly AVRO: InputFormat;
    /**
     * (experimental) OutputFormat for Orc files.
     *
     * @see https://hive.apache.org/javadocs/r1.2.2/api/org/apache/hadoop/hive/ql/io/orc/OrcOutputFormat.html
     * @experimental
     */
    static readonly ORC: InputFormat;
    /**
     * (experimental) OutputFormat for Parquet files.
     *
     * @see https://hive.apache.org/javadocs/r1.2.2/api/org/apache/hadoop/hive/ql/io/parquet/MapredParquetOutputFormat.html
     * @experimental
     */
    static readonly PARQUET: OutputFormat;
    /**
     * @experimental
     */
    constructor(className: string);
}
/**
 * (experimental) Serialization library to use when serializing/deserializing (SerDe) table records.
 *
 * @see https://cwiki.apache.org/confluence/display/Hive/SerDe
 * @experimental
 */
export declare class SerializationLibrary {
    readonly className: string;
    /**
     * @see https://hive.apache.org/javadocs/r1.2.2/api/org/apache/hadoop/hive/serde2/avro/AvroSerDe.html
     * @experimental
     */
    static readonly AVRO: SerializationLibrary;
    /**
     * @see https://docs.aws.amazon.com/athena/latest/ug/cloudtrail.html
     * @experimental
     */
    static readonly CLOUDTRAIL: SerializationLibrary;
    /**
     * @see https://docs.aws.amazon.com/athena/latest/ug/grok.html
     * @experimental
     */
    static readonly GROK: SerializationLibrary;
    /**
     * @see https://hive.apache.org/javadocs/r1.2.2/api/org/apache/hive/hcatalog/data/JsonSerDe.html
     * @experimental
     */
    static readonly HIVE_JSON: SerializationLibrary;
    /**
     * @see https://hive.apache.org/javadocs/r1.2.2/api/org/apache/hadoop/hive/serde2/lazy/LazySimpleSerDe.html
     * @experimental
     */
    static readonly LAZY_SIMPLE: SerializationLibrary;
    /**
     * @see https://hive.apache.org/javadocs/r1.2.2/api/org/apache/hadoop/hive/serde2/OpenCSVSerde.html
     * @experimental
     */
    static readonly OPEN_CSV: SerializationLibrary;
    /**
     * @see https://github.com/rcongiu/Hive-JSON-Serde
     * @experimental
     */
    static readonly OPENX_JSON: SerializationLibrary;
    /**
     * @see https://hive.apache.org/javadocs/r1.2.2/api/org/apache/hadoop/hive/ql/io/orc/OrcSerde.html
     * @experimental
     */
    static readonly ORC: SerializationLibrary;
    /**
     * @see https://hive.apache.org/javadocs/r1.2.2/api/org/apache/hadoop/hive/ql/io/parquet/serde/ParquetHiveSerDe.html
     * @experimental
     */
    static readonly PARQUET: SerializationLibrary;
    /**
     * @see https://hive.apache.org/javadocs/r1.2.2/api/org/apache/hadoop/hive/serde2/RegexSerDe.html
     * @experimental
     */
    static readonly REGEXP: SerializationLibrary;
    /**
     * @experimental
     */
    constructor(className: string);
}
/**
 * (experimental) Classification string given to tables with this data format.
 *
 * @see https://docs.aws.amazon.com/glue/latest/dg/add-classifier.html#classifier-built-in
 * @experimental
 */
export declare class ClassificationString {
    readonly value: string;
    /**
     * @see https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-format.html#aws-glue-programming-etl-format-avro
     * @experimental
     */
    static readonly AVRO: ClassificationString;
    /**
     * @see https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-format.html#aws-glue-programming-etl-format-csv
     * @experimental
     */
    static readonly CSV: ClassificationString;
    /**
     * @see https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-format.html#aws-glue-programming-etl-format-json
     * @experimental
     */
    static readonly JSON: ClassificationString;
    /**
     * @see https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-format.html#aws-glue-programming-etl-format-xml
     * @experimental
     */
    static readonly XML: ClassificationString;
    /**
     * @see https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-format.html#aws-glue-programming-etl-format-parquet
     * @experimental
     */
    static readonly PARQUET: ClassificationString;
    /**
     * @see https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-format.html#aws-glue-programming-etl-format-orc
     * @experimental
     */
    static readonly ORC: ClassificationString;
    /**
     * @experimental
     */
    constructor(value: string);
}
/**
 * (experimental) Properties of a DataFormat instance.
 *
 * @experimental
 */
export interface DataFormatProps {
    /**
     * (experimental) `InputFormat` for this data format.
     *
     * @experimental
     */
    readonly inputFormat: InputFormat;
    /**
     * (experimental) `OutputFormat` for this data format.
     *
     * @experimental
     */
    readonly outputFormat: OutputFormat;
    /**
     * (experimental) Serialization library for this data format.
     *
     * @experimental
     */
    readonly serializationLibrary: SerializationLibrary;
    /**
     * (experimental) Classification string given to tables with this data format.
     *
     * @default - No classification is specified.
     * @experimental
     */
    readonly classificationString?: ClassificationString;
}
/**
 * (experimental) Defines the input/output formats and ser/de for a single DataFormat.
 *
 * @experimental
 */
export declare class DataFormat {
    /**
     * (experimental) DataFormat for Apache Web Server Logs.
     *
     * Also works for CloudFront logs
     *
     * @see https://docs.aws.amazon.com/athena/latest/ug/apache.html
     * @experimental
     */
    static readonly APACHE_LOGS: DataFormat;
    /**
     * (experimental) DataFormat for Apache Avro.
     *
     * @see https://docs.aws.amazon.com/athena/latest/ug/avro.html
     * @experimental
     */
    static readonly AVRO: DataFormat;
    /**
     * (experimental) DataFormat for CloudTrail logs stored on S3.
     *
     * @see https://docs.aws.amazon.com/athena/latest/ug/cloudtrail.html
     * @experimental
     */
    static readonly CLOUDTRAIL_LOGS: DataFormat;
    /**
     * (experimental) DataFormat for CSV Files.
     *
     * @see https://docs.aws.amazon.com/athena/latest/ug/csv.html
     * @experimental
     */
    static readonly CSV: DataFormat;
    /**
     * (experimental) Stored as plain text files in JSON format.
     *
     * Uses OpenX Json SerDe for serialization and deseralization.
     *
     * @see https://docs.aws.amazon.com/athena/latest/ug/json.html
     * @experimental
     */
    static readonly JSON: DataFormat;
    /**
     * (experimental) DataFormat for Logstash Logs, using the GROK SerDe.
     *
     * @see https://docs.aws.amazon.com/athena/latest/ug/grok.html
     * @experimental
     */
    static readonly LOGSTASH: DataFormat;
    /**
     * (experimental) DataFormat for Apache ORC (Optimized Row Columnar).
     *
     * @see https://docs.aws.amazon.com/athena/latest/ug/orc.html
     * @experimental
     */
    static readonly ORC: DataFormat;
    /**
     * (experimental) DataFormat for Apache Parquet.
     *
     * @see https://docs.aws.amazon.com/athena/latest/ug/parquet.html
     * @experimental
     */
    static readonly PARQUET: DataFormat;
    /**
     * (experimental) DataFormat for TSV (Tab-Separated Values).
     *
     * @see https://docs.aws.amazon.com/athena/latest/ug/lazy-simple-serde.html
     * @experimental
     */
    static readonly TSV: DataFormat;
    /**
     * (experimental) `InputFormat` for this data format.
     *
     * @experimental
     */
    readonly inputFormat: InputFormat;
    /**
     * (experimental) `OutputFormat` for this data format.
     *
     * @experimental
     */
    readonly outputFormat: OutputFormat;
    /**
     * (experimental) Serialization library for this data format.
     *
     * @experimental
     */
    readonly serializationLibrary: SerializationLibrary;
    /**
     * (experimental) Classification string given to tables with this data format.
     *
     * @experimental
     */
    readonly classificationString?: ClassificationString;
    /**
     * @experimental
     */
    constructor(props: DataFormatProps);
}
