# coding: utf-8

"""
    mParticle

    mParticle Event API

    OpenAPI spec version: 1.0.1
    Contact: support@mparticle.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from pprint import pformat
from six import iteritems
import re


class CrashReportEvent(object):

    def __init__(self, timestamp_unixtime_ms=None, event_id=None, source_message_id=None, session_id=None, session_uuid=None, custom_attributes=None, location=None, device_current_state=None, breadcrumbs=None, class_name=None, severity=None, message=None, stack_trace=None, exception_handled=None, topmost_context=None, pl_crash_report_file_base64=None, ios_image_base_address=None, ios_image_size=None, session_number=None):
        """
        CrashReportEvent - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'timestamp_unixtime_ms': 'int',
            'event_id': 'int',
            'source_message_id': 'str',
            'session_id': 'int',
            'session_uuid': 'str',
            'custom_attributes': 'dict(str, str)',
            'location': 'GeoLocation',
            'device_current_state': 'DeviceCurrentState',
            'breadcrumbs': 'list[BreadcrumbEvent]',
            'class_name': 'str',
            'severity': 'str',
            'message': 'str',
            'stack_trace': 'str',
            'exception_handled': 'bool',
            'topmost_context': 'str',
            'pl_crash_report_file_base64': 'str',
            'ios_image_base_address': 'int',
            'ios_image_size': 'int',
            'session_number': 'int'
        }

        self.attribute_map = {
            'timestamp_unixtime_ms': 'timestamp_unixtime_ms',
            'event_id': 'event_id',
            'source_message_id': 'source_message_id',
            'session_id': 'session_id',
            'session_uuid': 'session_uuid',
            'custom_attributes': 'custom_attributes',
            'location': 'location',
            'device_current_state': 'device_current_state',
            'breadcrumbs': 'breadcrumbs',
            'class_name': 'class_name',
            'severity': 'severity',
            'message': 'message',
            'stack_trace': 'stack_trace',
            'exception_handled': 'exception_handled',
            'topmost_context': 'topmost_context',
            'pl_crash_report_file_base64': 'pl_crash_report_file_base64',
            'ios_image_base_address': 'ios_image_base_address',
            'ios_image_size': 'ios_image_size',
            'session_number': 'session_number'
        }

        self._timestamp_unixtime_ms = timestamp_unixtime_ms
        self._event_id = event_id
        self._source_message_id = source_message_id
        self._session_id = session_id
        self._session_uuid = session_uuid
        self._custom_attributes = custom_attributes
        self._location = location
        self._device_current_state = device_current_state
        self._breadcrumbs = breadcrumbs
        self._class_name = class_name
        self._severity = severity
        self._message = message
        self._stack_trace = stack_trace
        self._exception_handled = exception_handled
        self._topmost_context = topmost_context
        self._pl_crash_report_file_base64 = pl_crash_report_file_base64
        self._ios_image_base_address = ios_image_base_address
        self._ios_image_size = ios_image_size
        self._session_number = session_number

    @property
    def timestamp_unixtime_ms(self):
        """
        Gets the timestamp_unixtime_ms of this CrashReportEvent.


        :return: The timestamp_unixtime_ms of this CrashReportEvent.
        :rtype: int
        """
        return self._timestamp_unixtime_ms

    @timestamp_unixtime_ms.setter
    def timestamp_unixtime_ms(self, timestamp_unixtime_ms):
        """
        Sets the timestamp_unixtime_ms of this CrashReportEvent.


        :param timestamp_unixtime_ms: The timestamp_unixtime_ms of this CrashReportEvent.
        :type: int
        """

        self._timestamp_unixtime_ms = timestamp_unixtime_ms

    @property
    def event_id(self):
        """
        Gets the event_id of this CrashReportEvent.


        :return: The event_id of this CrashReportEvent.
        :rtype: int
        """
        return self._event_id

    @event_id.setter
    def event_id(self, event_id):
        """
        Sets the event_id of this CrashReportEvent.


        :param event_id: The event_id of this CrashReportEvent.
        :type: int
        """

        self._event_id = event_id

    @property
    def source_message_id(self):
        """
        Gets the source_message_id of this CrashReportEvent.


        :return: The source_message_id of this CrashReportEvent.
        :rtype: str
        """
        return self._source_message_id

    @source_message_id.setter
    def source_message_id(self, source_message_id):
        """
        Sets the source_message_id of this CrashReportEvent.


        :param source_message_id: The source_message_id of this CrashReportEvent.
        :type: str
        """

        self._source_message_id = source_message_id

    @property
    def session_id(self):
        """
        Gets the session_id of this CrashReportEvent.


        :return: The session_id of this CrashReportEvent.
        :rtype: int
        """
        return self._session_id

    @session_id.setter
    def session_id(self, session_id):
        """
        Sets the session_id of this CrashReportEvent.


        :param session_id: The session_id of this CrashReportEvent.
        :type: int
        """

        self._session_id = session_id

    @property
    def session_uuid(self):
        """
        Gets the session_uuid of this CrashReportEvent.


        :return: The session_uuid of this CrashReportEvent.
        :rtype: str
        """
        return self._session_uuid

    @session_uuid.setter
    def session_uuid(self, session_uuid):
        """
        Sets the session_uuid of this CrashReportEvent.


        :param session_uuid: The session_uuid of this CrashReportEvent.
        :type: str
        """

        self._session_uuid = session_uuid

    @property
    def custom_attributes(self):
        """
        Gets the custom_attributes of this CrashReportEvent.


        :return: The custom_attributes of this CrashReportEvent.
        :rtype: dict(str, str)
        """
        return self._custom_attributes

    @custom_attributes.setter
    def custom_attributes(self, custom_attributes):
        """
        Sets the custom_attributes of this CrashReportEvent.


        :param custom_attributes: The custom_attributes of this CrashReportEvent.
        :type: dict(str, str)
        """

        self._custom_attributes = custom_attributes

    @property
    def location(self):
        """
        Gets the location of this CrashReportEvent.


        :return: The location of this CrashReportEvent.
        :rtype: GeoLocation
        """
        return self._location

    @location.setter
    def location(self, location):
        """
        Sets the location of this CrashReportEvent.


        :param location: The location of this CrashReportEvent.
        :type: GeoLocation
        """

        self._location = location

    @property
    def device_current_state(self):
        """
        Gets the device_current_state of this CrashReportEvent.


        :return: The device_current_state of this CrashReportEvent.
        :rtype: DeviceCurrentState
        """
        return self._device_current_state

    @device_current_state.setter
    def device_current_state(self, device_current_state):
        """
        Sets the device_current_state of this CrashReportEvent.


        :param device_current_state: The device_current_state of this CrashReportEvent.
        :type: DeviceCurrentState
        """

        self._device_current_state = device_current_state

    @property
    def breadcrumbs(self):
        """
        Gets the breadcrumbs of this CrashReportEvent.


        :return: The breadcrumbs of this CrashReportEvent.
        :rtype: list[BreadcrumbEvent]
        """
        return self._breadcrumbs

    @breadcrumbs.setter
    def breadcrumbs(self, breadcrumbs):
        """
        Sets the breadcrumbs of this CrashReportEvent.


        :param breadcrumbs: The breadcrumbs of this CrashReportEvent.
        :type: list[BreadcrumbEvent]
        """

        self._breadcrumbs = breadcrumbs

    @property
    def class_name(self):
        """
        Gets the class_name of this CrashReportEvent.


        :return: The class_name of this CrashReportEvent.
        :rtype: str
        """
        return self._class_name

    @class_name.setter
    def class_name(self, class_name):
        """
        Sets the class_name of this CrashReportEvent.


        :param class_name: The class_name of this CrashReportEvent.
        :type: str
        """

        self._class_name = class_name

    @property
    def severity(self):
        """
        Gets the severity of this CrashReportEvent.


        :return: The severity of this CrashReportEvent.
        :rtype: str
        """
        return self._severity

    @severity.setter
    def severity(self, severity):
        """
        Sets the severity of this CrashReportEvent.


        :param severity: The severity of this CrashReportEvent.
        :type: str
        """

        self._severity = severity

    @property
    def message(self):
        """
        Gets the message of this CrashReportEvent.


        :return: The message of this CrashReportEvent.
        :rtype: str
        """
        return self._message

    @message.setter
    def message(self, message):
        """
        Sets the message of this CrashReportEvent.


        :param message: The message of this CrashReportEvent.
        :type: str
        """

        self._message = message

    @property
    def stack_trace(self):
        """
        Gets the stack_trace of this CrashReportEvent.


        :return: The stack_trace of this CrashReportEvent.
        :rtype: str
        """
        return self._stack_trace

    @stack_trace.setter
    def stack_trace(self, stack_trace):
        """
        Sets the stack_trace of this CrashReportEvent.


        :param stack_trace: The stack_trace of this CrashReportEvent.
        :type: str
        """

        self._stack_trace = stack_trace

    @property
    def exception_handled(self):
        """
        Gets the exception_handled of this CrashReportEvent.


        :return: The exception_handled of this CrashReportEvent.
        :rtype: bool
        """
        return self._exception_handled

    @exception_handled.setter
    def exception_handled(self, exception_handled):
        """
        Sets the exception_handled of this CrashReportEvent.


        :param exception_handled: The exception_handled of this CrashReportEvent.
        :type: bool
        """

        self._exception_handled = exception_handled

    @property
    def topmost_context(self):
        """
        Gets the topmost_context of this CrashReportEvent.


        :return: The topmost_context of this CrashReportEvent.
        :rtype: str
        """
        return self._topmost_context

    @topmost_context.setter
    def topmost_context(self, topmost_context):
        """
        Sets the topmost_context of this CrashReportEvent.


        :param topmost_context: The topmost_context of this CrashReportEvent.
        :type: str
        """

        self._topmost_context = topmost_context

    @property
    def pl_crash_report_file_base64(self):
        """
        Gets the pl_crash_report_file_base64 of this CrashReportEvent.


        :return: The pl_crash_report_file_base64 of this CrashReportEvent.
        :rtype: str
        """
        return self._pl_crash_report_file_base64

    @pl_crash_report_file_base64.setter
    def pl_crash_report_file_base64(self, pl_crash_report_file_base64):
        """
        Sets the pl_crash_report_file_base64 of this CrashReportEvent.


        :param pl_crash_report_file_base64: The pl_crash_report_file_base64 of this CrashReportEvent.
        :type: str
        """

        self._pl_crash_report_file_base64 = pl_crash_report_file_base64

    @property
    def ios_image_base_address(self):
        """
        Gets the ios_image_base_address of this CrashReportEvent.


        :return: The ios_image_base_address of this CrashReportEvent.
        :rtype: int
        """
        return self._ios_image_base_address

    @ios_image_base_address.setter
    def ios_image_base_address(self, ios_image_base_address):
        """
        Sets the ios_image_base_address of this CrashReportEvent.


        :param ios_image_base_address: The ios_image_base_address of this CrashReportEvent.
        :type: int
        """

        self._ios_image_base_address = ios_image_base_address

    @property
    def ios_image_size(self):
        """
        Gets the ios_image_size of this CrashReportEvent.


        :return: The ios_image_size of this CrashReportEvent.
        :rtype: int
        """
        return self._ios_image_size

    @ios_image_size.setter
    def ios_image_size(self, ios_image_size):
        """
        Sets the ios_image_size of this CrashReportEvent.


        :param ios_image_size: The ios_image_size of this CrashReportEvent.
        :type: int
        """

        self._ios_image_size = ios_image_size

    @property
    def session_number(self):
        """
        Gets the session_number of this CrashReportEvent.


        :return: The session_number of this CrashReportEvent.
        :rtype: int
        """
        return self._session_number

    @session_number.setter
    def session_number(self, session_number):
        """
        Sets the session_number of this CrashReportEvent.


        :param session_number: The session_number of this CrashReportEvent.
        :type: int
        """

        self._session_number = session_number

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
