# coding: utf-8

"""
    mParticle

    mParticle Event API

    OpenAPI spec version: 1.0.1
    Contact: support@mparticle.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from pprint import pformat
from six import iteritems
import re


class ApplicationInformation(object):

    def __init__(self, application_name=None, application_version=None, install_referrer=None, package=None):
        """
        ApplicationInformation - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'application_name': 'str',
            'application_version': 'str',
            'install_referrer': 'str',
            'package': 'str'
        }

        self.attribute_map = {
            'application_name': 'application_name',
            'application_version': 'application_version',
            'install_referrer': 'install_referrer',
            'package': 'package'
        }

        self._application_name = application_name
        self._application_version = application_version
        self._install_referrer = install_referrer
        self._package = package

    @property
    def application_name(self):
        """
        Gets the application_name of this ApplicationInformation.


        :return: The application_name of this ApplicationInformation.
        :rtype: str
        """
        return self._application_name

    @application_name.setter
    def application_name(self, application_name):
        """
        Sets the application_name of this ApplicationInformation.


        :param application_name: The application_name of this ApplicationInformation.
        :type: str
        """

        self._application_name = application_name

    @property
    def application_version(self):
        """
        Gets the application_version of this ApplicationInformation.


        :return: The application_version of this ApplicationInformation.
        :rtype: str
        """
        return self._application_version

    @application_version.setter
    def application_version(self, application_version):
        """
        Sets the application_version of this ApplicationInformation.


        :param application_version: The application_version of this ApplicationInformation.
        :type: str
        """

        self._application_version = application_version

    @property
    def install_referrer(self):
        """
        Gets the install_referrer of this ApplicationInformation.


        :return: The install_referrer of this ApplicationInformation.
        :rtype: str
        """
        return self._install_referrer

    @install_referrer.setter
    def install_referrer(self, install_referrer):
        """
        Sets the install_referrer of this ApplicationInformation.


        :param install_referrer: The install_referrer of this ApplicationInformation.
        :type: str
        """

        self._install_referrer = install_referrer

    @property
    def package(self):
        """
        Gets the package of this ApplicationInformation.


        :return: The package of this ApplicationInformation.
        :rtype: str
        """
        return self._package

    @package.setter
    def package(self, package):
        """
        Sets the package of this ApplicationInformation.


        :param package: The package of this ApplicationInformation.
        :type: str
        """

        self._package = package

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
