# Generated by Django 3.1.1 on 2020-09-13 23:23

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import jutil.modelfields
import uuid


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name="JournalEntry",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("description", models.CharField(blank=True, max_length=256, verbose_name="description")),
                (
                    "timestamp",
                    models.DateTimeField(blank=True, db_index=True, default=django.utils.timezone.now, verbose_name="timestamp"),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        db_index=True,
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name="created",
                    ),
                ),
                ("last_modified", models.DateTimeField(auto_now=True, verbose_name="last modified")),
                (
                    "parent",
                    models.ForeignKey(
                        blank=True,
                        default=None,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="child_set",
                        to="jstocks.journalentry",
                        verbose_name="parent",
                    ),
                ),
            ],
            options={
                "verbose_name": "journal entry",
                "verbose_name_plural": "journal entries",
            },
        ),
        migrations.CreateModel(
            name="Party",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid1,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                        verbose_name="unique identifier",
                    ),
                ),
                (
                    "party_type",
                    models.CharField(
                        blank=True,
                        choices=[("I", "person"), ("O", "organization")],
                        db_index=True,
                        default="I",
                        max_length=1,
                        verbose_name="party type",
                    ),
                ),
                (
                    "first_name",
                    jutil.modelfields.SafeCharField(
                        blank=True,
                        db_index=True,
                        help_text="if the party is a person",
                        max_length=64,
                        verbose_name="first name",
                    ),
                ),
                (
                    "last_name",
                    jutil.modelfields.SafeCharField(
                        blank=True,
                        db_index=True,
                        help_text="if the party is a person",
                        max_length=64,
                        verbose_name="last name",
                    ),
                ),
                (
                    "org_name",
                    jutil.modelfields.SafeCharField(
                        blank=True,
                        db_index=True,
                        help_text="if the party is an organization",
                        max_length=64,
                        verbose_name="organization name",
                    ),
                ),
                (
                    "org_id",
                    jutil.modelfields.SafeCharField(
                        blank=True,
                        db_index=True,
                        help_text="if the party is an organization",
                        max_length=32,
                        verbose_name="organization identifier",
                    ),
                ),
                ("email", models.EmailField(blank=True, db_index=True, max_length=254, verbose_name="email")),
                (
                    "phone",
                    jutil.modelfields.SafeCharField(blank=True, db_index=True, default="", max_length=32, verbose_name="phone number"),
                ),
                (
                    "address",
                    jutil.modelfields.SafeCharField(blank=True, db_index=True, default="", max_length=128, verbose_name="address"),
                ),
                (
                    "city",
                    jutil.modelfields.SafeCharField(blank=True, db_index=True, default="", max_length=128, verbose_name="city"),
                ),
                (
                    "zip_code",
                    jutil.modelfields.SafeCharField(blank=True, db_index=True, default="", max_length=32, verbose_name="zip code"),
                ),
                (
                    "country",
                    jutil.modelfields.SafeCharField(
                        blank=True,
                        choices=[
                            ("AW", "Aruba"),
                            ("AF", "Afghanistan"),
                            ("AO", "Angola"),
                            ("AI", "Anguilla"),
                            ("AX", "Åland Islands"),
                            ("AL", "Albania"),
                            ("AD", "Andorra"),
                            ("AE", "United Arab Emirates"),
                            ("AR", "Argentina"),
                            ("AM", "Armenia"),
                            ("AS", "American Samoa"),
                            ("AQ", "Antarctica"),
                            ("TF", "French Southern Territories"),
                            ("AG", "Antigua and Barbuda"),
                            ("AU", "Australia"),
                            ("AT", "Austria"),
                            ("AZ", "Azerbaijan"),
                            ("BI", "Burundi"),
                            ("BE", "Belgium"),
                            ("BJ", "Benin"),
                            ("BQ", "Bonaire, Sint Eustatius and Saba"),
                            ("BF", "Burkina Faso"),
                            ("BD", "Bangladesh"),
                            ("BG", "Bulgaria"),
                            ("BH", "Bahrain"),
                            ("BS", "Bahamas"),
                            ("BA", "Bosnia and Herzegovina"),
                            ("BL", "Saint Barthélemy"),
                            ("BY", "Belarus"),
                            ("BZ", "Belize"),
                            ("BM", "Bermuda"),
                            ("BO", "Bolivia, Plurinational State of"),
                            ("BR", "Brazil"),
                            ("BB", "Barbados"),
                            ("BN", "Brunei Darussalam"),
                            ("BT", "Bhutan"),
                            ("BV", "Bouvet Island"),
                            ("BW", "Botswana"),
                            ("CF", "Central African Republic"),
                            ("CA", "Canada"),
                            ("CC", "Cocos (Keeling) Islands"),
                            ("CH", "Switzerland"),
                            ("CL", "Chile"),
                            ("CN", "China"),
                            ("CI", "Côte d'Ivoire"),
                            ("CM", "Cameroon"),
                            ("CD", "Congo, The Democratic Republic of the"),
                            ("CG", "Congo"),
                            ("CK", "Cook Islands"),
                            ("CO", "Colombia"),
                            ("KM", "Comoros"),
                            ("CV", "Cabo Verde"),
                            ("CR", "Costa Rica"),
                            ("CU", "Cuba"),
                            ("CW", "Curaçao"),
                            ("CX", "Christmas Island"),
                            ("KY", "Cayman Islands"),
                            ("CY", "Cyprus"),
                            ("CZ", "Czechia"),
                            ("DE", "Germany"),
                            ("DJ", "Djibouti"),
                            ("DM", "Dominica"),
                            ("DK", "Denmark"),
                            ("DO", "Dominican Republic"),
                            ("DZ", "Algeria"),
                            ("EC", "Ecuador"),
                            ("EG", "Egypt"),
                            ("ER", "Eritrea"),
                            ("EH", "Western Sahara"),
                            ("ES", "Spain"),
                            ("EE", "Estonia"),
                            ("ET", "Ethiopia"),
                            ("FI", "Finland"),
                            ("FJ", "Fiji"),
                            ("FK", "Falkland Islands (Malvinas)"),
                            ("FR", "France"),
                            ("FO", "Faroe Islands"),
                            ("FM", "Micronesia, Federated States of"),
                            ("GA", "Gabon"),
                            ("GB", "United Kingdom"),
                            ("GE", "Georgia"),
                            ("GG", "Guernsey"),
                            ("GH", "Ghana"),
                            ("GI", "Gibraltar"),
                            ("GN", "Guinea"),
                            ("GP", "Guadeloupe"),
                            ("GM", "Gambia"),
                            ("GW", "Guinea-Bissau"),
                            ("GQ", "Equatorial Guinea"),
                            ("GR", "Greece"),
                            ("GD", "Grenada"),
                            ("GL", "Greenland"),
                            ("GT", "Guatemala"),
                            ("GF", "French Guiana"),
                            ("GU", "Guam"),
                            ("GY", "Guyana"),
                            ("HK", "Hong Kong"),
                            ("HM", "Heard Island and McDonald Islands"),
                            ("HN", "Honduras"),
                            ("HR", "Croatia"),
                            ("HT", "Haiti"),
                            ("HU", "Hungary"),
                            ("ID", "Indonesia"),
                            ("IM", "Isle of Man"),
                            ("IN", "India"),
                            ("IO", "British Indian Ocean Territory"),
                            ("IE", "Ireland"),
                            ("IR", "Iran, Islamic Republic of"),
                            ("IQ", "Iraq"),
                            ("IS", "Iceland"),
                            ("IL", "Israel"),
                            ("IT", "Italy"),
                            ("JM", "Jamaica"),
                            ("JE", "Jersey"),
                            ("JO", "Jordan"),
                            ("JP", "Japan"),
                            ("KZ", "Kazakhstan"),
                            ("KE", "Kenya"),
                            ("KG", "Kyrgyzstan"),
                            ("KH", "Cambodia"),
                            ("KI", "Kiribati"),
                            ("KN", "Saint Kitts and Nevis"),
                            ("KR", "Korea, Republic of"),
                            ("KW", "Kuwait"),
                            ("LA", "Lao People's Democratic Republic"),
                            ("LB", "Lebanon"),
                            ("LR", "Liberia"),
                            ("LY", "Libya"),
                            ("LC", "Saint Lucia"),
                            ("LI", "Liechtenstein"),
                            ("LK", "Sri Lanka"),
                            ("LS", "Lesotho"),
                            ("LT", "Lithuania"),
                            ("LU", "Luxembourg"),
                            ("LV", "Latvia"),
                            ("MO", "Macao"),
                            ("MF", "Saint Martin (French part)"),
                            ("MA", "Morocco"),
                            ("MC", "Monaco"),
                            ("MD", "Moldova, Republic of"),
                            ("MG", "Madagascar"),
                            ("MV", "Maldives"),
                            ("MX", "Mexico"),
                            ("MH", "Marshall Islands"),
                            ("MK", "North Macedonia"),
                            ("ML", "Mali"),
                            ("MT", "Malta"),
                            ("MM", "Myanmar"),
                            ("ME", "Montenegro"),
                            ("MN", "Mongolia"),
                            ("MP", "Northern Mariana Islands"),
                            ("MZ", "Mozambique"),
                            ("MR", "Mauritania"),
                            ("MS", "Montserrat"),
                            ("MQ", "Martinique"),
                            ("MU", "Mauritius"),
                            ("MW", "Malawi"),
                            ("MY", "Malaysia"),
                            ("YT", "Mayotte"),
                            ("NA", "Namibia"),
                            ("NC", "New Caledonia"),
                            ("NE", "Niger"),
                            ("NF", "Norfolk Island"),
                            ("NG", "Nigeria"),
                            ("NI", "Nicaragua"),
                            ("NU", "Niue"),
                            ("NL", "Netherlands"),
                            ("NO", "Norway"),
                            ("NP", "Nepal"),
                            ("NR", "Nauru"),
                            ("NZ", "New Zealand"),
                            ("OM", "Oman"),
                            ("PK", "Pakistan"),
                            ("PA", "Panama"),
                            ("PN", "Pitcairn"),
                            ("PE", "Peru"),
                            ("PH", "Philippines"),
                            ("PW", "Palau"),
                            ("PG", "Papua New Guinea"),
                            ("PL", "Poland"),
                            ("PR", "Puerto Rico"),
                            ("KP", "Korea, Democratic People's Republic of"),
                            ("PT", "Portugal"),
                            ("PY", "Paraguay"),
                            ("PS", "Palestine, State of"),
                            ("PF", "French Polynesia"),
                            ("QA", "Qatar"),
                            ("RE", "Réunion"),
                            ("RO", "Romania"),
                            ("RU", "Russian Federation"),
                            ("RW", "Rwanda"),
                            ("SA", "Saudi Arabia"),
                            ("SD", "Sudan"),
                            ("SN", "Senegal"),
                            ("SG", "Singapore"),
                            ("GS", "South Georgia and the South Sandwich Islands"),
                            ("SH", "Saint Helena, Ascension and Tristan da Cunha"),
                            ("SJ", "Svalbard and Jan Mayen"),
                            ("SB", "Solomon Islands"),
                            ("SL", "Sierra Leone"),
                            ("SV", "El Salvador"),
                            ("SM", "San Marino"),
                            ("SO", "Somalia"),
                            ("PM", "Saint Pierre and Miquelon"),
                            ("RS", "Serbia"),
                            ("SS", "South Sudan"),
                            ("ST", "Sao Tome and Principe"),
                            ("SR", "Suriname"),
                            ("SK", "Slovakia"),
                            ("SI", "Slovenia"),
                            ("SE", "Sweden"),
                            ("SZ", "Eswatini"),
                            ("SX", "Sint Maarten (Dutch part)"),
                            ("SC", "Seychelles"),
                            ("SY", "Syrian Arab Republic"),
                            ("TC", "Turks and Caicos Islands"),
                            ("TD", "Chad"),
                            ("TG", "Togo"),
                            ("TH", "Thailand"),
                            ("TJ", "Tajikistan"),
                            ("TK", "Tokelau"),
                            ("TM", "Turkmenistan"),
                            ("TL", "Timor-Leste"),
                            ("TO", "Tonga"),
                            ("TT", "Trinidad and Tobago"),
                            ("TN", "Tunisia"),
                            ("TR", "Turkey"),
                            ("TV", "Tuvalu"),
                            ("TW", "Taiwan, Province of China"),
                            ("TZ", "Tanzania, United Republic of"),
                            ("UG", "Uganda"),
                            ("UA", "Ukraine"),
                            ("UM", "United States Minor Outlying Islands"),
                            ("UY", "Uruguay"),
                            ("US", "United States"),
                            ("UZ", "Uzbekistan"),
                            ("VA", "Holy See (Vatican City State)"),
                            ("VC", "Saint Vincent and the Grenadines"),
                            ("VE", "Venezuela, Bolivarian Republic of"),
                            ("VG", "Virgin Islands, British"),
                            ("VI", "Virgin Islands, U.S."),
                            ("VN", "Viet Nam"),
                            ("VU", "Vanuatu"),
                            ("WF", "Wallis and Futuna"),
                            ("WS", "Samoa"),
                            ("YE", "Yemen"),
                            ("ZA", "South Africa"),
                            ("ZM", "Zambia"),
                            ("ZW", "Zimbabwe"),
                        ],
                        db_index=True,
                        max_length=2,
                        verbose_name="country",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        db_index=True,
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name="created",
                    ),
                ),
                ("last_modified", models.DateTimeField(auto_now=True, verbose_name="last modified")),
                ("notes", models.TextField(blank=True, verbose_name="notes")),
                (
                    "name",
                    jutil.modelfields.SafeCharField(blank=True, db_index=True, editable=False, max_length=128, verbose_name="name"),
                ),
                (
                    "owned_share_count",
                    models.IntegerField(blank=True, db_index=True, default=None, editable=False, null=True, verbose_name="owned shares"),
                ),
                (
                    "user",
                    models.ForeignKey(
                        blank=True,
                        default=None,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="party_set",
                        to=settings.AUTH_USER_MODEL,
                        verbose_name="user",
                    ),
                ),
            ],
            options={
                "verbose_name": "party",
                "verbose_name_plural": "parties",
                "ordering": ["name"],
            },
        ),
        migrations.CreateModel(
            name="ShareAllocation",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                (
                    "identifier",
                    models.BigIntegerField(blank=True, db_index=True, help_text="optional", verbose_name="numeric identifier"),
                ),
                ("count", models.BigIntegerField(db_index=True, verbose_name="number of shares")),
                (
                    "begin",
                    models.BigIntegerField(blank=True, db_index=True, default=None, null=True, verbose_name="first share number"),
                ),
                (
                    "last",
                    models.BigIntegerField(blank=True, db_index=True, default=None, null=True, verbose_name="last share number"),
                ),
                (
                    "price",
                    models.DecimalField(
                        blank=True,
                        db_index=True,
                        decimal_places=2,
                        default=None,
                        max_digits=10,
                        null=True,
                        verbose_name="price",
                    ),
                ),
                (
                    "record_date",
                    models.DateTimeField(blank=True, db_index=True, default=None, editable=False, null=True, verbose_name="record date"),
                ),
                (
                    "timestamp",
                    models.DateTimeField(blank=True, db_index=True, default=django.utils.timezone.now, verbose_name="timestamp"),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        db_index=True,
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name="created",
                    ),
                ),
                ("last_modified", models.DateTimeField(auto_now=True, verbose_name="last modified")),
                ("notes", models.TextField(blank=True, verbose_name="notes")),
            ],
            options={
                "verbose_name": "share allocation",
                "verbose_name_plural": "share allocations",
            },
        ),
        migrations.CreateModel(
            name="Shares",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                (
                    "identifier",
                    models.BigIntegerField(blank=True, db_index=True, help_text="optional", verbose_name="numeric identifier"),
                ),
                ("begin", models.BigIntegerField(db_index=True, verbose_name="first share number")),
                ("last", models.BigIntegerField(db_index=True, verbose_name="last share number")),
                (
                    "timestamp",
                    models.DateTimeField(blank=True, db_index=True, default=django.utils.timezone.now, verbose_name="timestamp"),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        db_index=True,
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name="created",
                    ),
                ),
                ("last_modified", models.DateTimeField(auto_now=True, verbose_name="last modified")),
                ("notes", models.TextField(blank=True, verbose_name="notes")),
            ],
            options={
                "verbose_name": "authorized shares",
                "verbose_name_plural": "authorized shares",
            },
        ),
        migrations.CreateModel(
            name="ShareTransfer",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                (
                    "identifier",
                    models.BigIntegerField(blank=True, db_index=True, help_text="optional", verbose_name="numeric identifier"),
                ),
                ("count", models.BigIntegerField(db_index=True, verbose_name="number of shares")),
                (
                    "begin",
                    models.BigIntegerField(blank=True, db_index=True, default=None, null=True, verbose_name="first share number"),
                ),
                (
                    "last",
                    models.BigIntegerField(blank=True, db_index=True, default=None, null=True, verbose_name="last share number"),
                ),
                (
                    "price",
                    models.DecimalField(
                        blank=True,
                        db_index=True,
                        decimal_places=2,
                        default=None,
                        max_digits=10,
                        null=True,
                        verbose_name="price",
                    ),
                ),
                (
                    "record_date",
                    models.DateTimeField(blank=True, db_index=True, default=None, editable=False, null=True, verbose_name="record date"),
                ),
                (
                    "timestamp",
                    models.DateTimeField(blank=True, db_index=True, default=django.utils.timezone.now, verbose_name="timestamp"),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        db_index=True,
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name="created",
                    ),
                ),
                ("last_modified", models.DateTimeField(auto_now=True, verbose_name="last modified")),
                ("notes", models.TextField(blank=True, verbose_name="notes")),
                (
                    "buyer",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="as_buyer",
                        to="jstocks.party",
                        verbose_name="buyer",
                    ),
                ),
                (
                    "seller",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="as_seller",
                        to="jstocks.party",
                        verbose_name="seller",
                    ),
                ),
            ],
            options={
                "verbose_name": "share transfer",
                "verbose_name_plural": "share transfers",
            },
        ),
        migrations.CreateModel(
            name="ShareType",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid1,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                        verbose_name="unique identifier",
                    ),
                ),
                (
                    "name",
                    jutil.modelfields.SafeCharField(db_index=True, help_text="For example: Series A", max_length=64, verbose_name="name"),
                ),
                (
                    "identifier",
                    jutil.modelfields.SafeCharField(db_index=True, help_text="For example: A", max_length=16, verbose_name="identifier"),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        db_index=True,
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name="created",
                    ),
                ),
                ("last_modified", models.DateTimeField(auto_now=True, verbose_name="last modified")),
                ("notes", models.TextField(blank=True, verbose_name="notes")),
            ],
            options={
                "verbose_name": "share type",
                "verbose_name_plural": "share types",
            },
        ),
        migrations.CreateModel(
            name="Issuer",
            fields=[
                (
                    "party_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to="jstocks.party",
                    ),
                ),
            ],
            options={
                "verbose_name": "issuer",
                "verbose_name_plural": "issuers",
            },
            bases=("jstocks.party",),
        ),
        migrations.CreateModel(
            name="Tx",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                (
                    "account",
                    models.CharField(
                        choices=[("S", "stock"), ("D", "dividend"), ("C", "cash")],
                        db_index=True,
                        max_length=2,
                        verbose_name="account",
                    ),
                ),
                (
                    "amount",
                    models.DecimalField(
                        blank=True,
                        db_index=True,
                        decimal_places=2,
                        default=None,
                        max_digits=10,
                        null=True,
                        verbose_name="amount",
                    ),
                ),
                (
                    "count",
                    models.IntegerField(blank=True, db_index=True, default=None, null=True, verbose_name="count"),
                ),
                (
                    "timestamp",
                    models.DateTimeField(
                        blank=True,
                        db_index=True,
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name="timestamp",
                    ),
                ),
                (
                    "entry",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="tx_set",
                        to="jstocks.journalentry",
                        verbose_name="journal entry",
                    ),
                ),
                (
                    "owner",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="tx_set",
                        to="jstocks.party",
                        verbose_name="owner",
                    ),
                ),
                (
                    "share_type",
                    models.ForeignKey(
                        blank=True,
                        default=None,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="tx_set",
                        to="jstocks.sharetype",
                        verbose_name="share type",
                    ),
                ),
            ],
            options={
                "verbose_name": "transaction",
                "verbose_name_plural": "transactions",
            },
        ),
        migrations.CreateModel(
            name="ShareTransferAttachment",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("file", models.FileField(blank=True, upload_to="uploads", verbose_name="file")),
                (
                    "context",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="attachment_set",
                        to="jstocks.sharetransfer",
                        verbose_name="context object",
                    ),
                ),
            ],
            options={
                "verbose_name": "attachment",
                "verbose_name_plural": "attachments",
            },
        ),
        migrations.AddField(
            model_name="sharetransfer",
            name="share_type",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.PROTECT,
                related_name="+",
                to="jstocks.sharetype",
                verbose_name="share type",
            ),
        ),
        migrations.CreateModel(
            name="ShareSeq",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("begin", models.BigIntegerField(db_index=True, verbose_name="first share number")),
                ("last", models.BigIntegerField(db_index=True, verbose_name="last share number")),
                (
                    "entry",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="seq_set",
                        to="jstocks.journalentry",
                        verbose_name="journal entry",
                    ),
                ),
                (
                    "shares",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="shareseq_set",
                        to="jstocks.shares",
                        verbose_name="shares",
                    ),
                ),
            ],
            options={
                "verbose_name": "share sequence",
                "verbose_name_plural": "share sequences",
            },
        ),
        migrations.AddField(
            model_name="shares",
            name="share_type",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="AuthorizedShares_set",
                to="jstocks.sharetype",
                verbose_name="share type",
            ),
        ),
        migrations.CreateModel(
            name="ShareAllocationAttachment",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("file", models.FileField(blank=True, upload_to="uploads", verbose_name="file")),
                (
                    "context",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="attachment_set",
                        to="jstocks.shareallocation",
                        verbose_name="context object",
                    ),
                ),
            ],
            options={
                "verbose_name": "attachment",
                "verbose_name_plural": "attachments",
            },
        ),
        migrations.AddField(
            model_name="shareallocation",
            name="share_type",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.PROTECT,
                related_name="+",
                to="jstocks.sharetype",
                verbose_name="share type",
            ),
        ),
        migrations.AddField(
            model_name="shareallocation",
            name="shares",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.PROTECT,
                related_name="allocation_set",
                to="jstocks.shares",
                verbose_name="authorized shares",
            ),
        ),
        migrations.AddField(
            model_name="shareallocation",
            name="subscriber",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.PROTECT,
                related_name="as_subscriber",
                to="jstocks.party",
                verbose_name="subscriber",
            ),
        ),
        migrations.CreateModel(
            name="OwnedStock",
            fields=[],
            options={
                "verbose_name": "owned stock",
                "verbose_name_plural": "owned stocks",
                "proxy": True,
                "indexes": [],
                "constraints": [],
            },
            bases=("jstocks.tx",),
        ),
        migrations.AddField(
            model_name="sharetype",
            name="issuer",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="stocktype_set",
                to="jstocks.issuer",
                verbose_name="issuer",
            ),
        ),
        migrations.AddConstraint(
            model_name="sharetransfer",
            constraint=models.UniqueConstraint(fields=("share_type", "identifier"), name="unique_sharetransfer_share_type_identifier"),
        ),
        migrations.AddConstraint(
            model_name="shareallocation",
            constraint=models.UniqueConstraint(fields=("share_type", "identifier"), name="unique_shareallocation_share_type_identifier"),
        ),
        migrations.AddField(
            model_name="issuer",
            name="created_by",
            field=models.ForeignKey(
                editable=False,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="+",
                to=settings.AUTH_USER_MODEL,
                verbose_name="created by",
            ),
        ),
        migrations.AddConstraint(
            model_name="sharetype",
            constraint=models.UniqueConstraint(fields=("issuer", "identifier"), name="unique_issuer_identifier"),
        ),
    ]
