# -*- coding: utf-8 -*-
# This file is auto-generated, don't edit it. Thanks.
from Tea.model import TeaModel


class AbortCampaignRequest(TeaModel):
    def __init__(self, campaign_id=None, instance_id=None):
        self.campaign_id = campaign_id  # type: str
        self.instance_id = instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AbortCampaignRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.campaign_id is not None:
            result['CampaignId'] = self.campaign_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CampaignId') is not None:
            self.campaign_id = m.get('CampaignId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class AbortCampaignResponseBody(TeaModel):
    def __init__(self, code=None, http_status_code=None, message=None, request_id=None):
        # code
        self.code = code  # type: str
        # httpStatusCode
        self.http_status_code = http_status_code  # type: str
        # message
        self.message = message  # type: str
        # Id of the request
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AbortCampaignResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AbortCampaignResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: AbortCampaignResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AbortCampaignResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = AbortCampaignResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddNumbersToSkillGroupRequest(TeaModel):
    def __init__(self, instance_id=None, number_list=None, skill_group_id=None):
        self.instance_id = instance_id  # type: str
        self.number_list = number_list  # type: str
        self.skill_group_id = skill_group_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddNumbersToSkillGroupRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.number_list is not None:
            result['NumberList'] = self.number_list
        if self.skill_group_id is not None:
            result['SkillGroupId'] = self.skill_group_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('NumberList') is not None:
            self.number_list = m.get('NumberList')
        if m.get('SkillGroupId') is not None:
            self.skill_group_id = m.get('SkillGroupId')
        return self


class AddNumbersToSkillGroupResponseBody(TeaModel):
    def __init__(self, code=None, http_status_code=None, message=None, request_id=None):
        self.code = code  # type: str
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddNumbersToSkillGroupResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddNumbersToSkillGroupResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: AddNumbersToSkillGroupResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AddNumbersToSkillGroupResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = AddNumbersToSkillGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddPersonalNumbersToUserRequest(TeaModel):
    def __init__(self, instance_id=None, number_list=None, user_id=None):
        self.instance_id = instance_id  # type: str
        self.number_list = number_list  # type: str
        self.user_id = user_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddPersonalNumbersToUserRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.number_list is not None:
            result['NumberList'] = self.number_list
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('NumberList') is not None:
            self.number_list = m.get('NumberList')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class AddPersonalNumbersToUserResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: list[str]
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddPersonalNumbersToUserResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddPersonalNumbersToUserResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: AddPersonalNumbersToUserResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AddPersonalNumbersToUserResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = AddPersonalNumbersToUserResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddPhoneNumberToSkillGroupsRequest(TeaModel):
    def __init__(self, instance_id=None, number=None, skill_group_id_list=None):
        self.instance_id = instance_id  # type: str
        self.number = number  # type: str
        self.skill_group_id_list = skill_group_id_list  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddPhoneNumberToSkillGroupsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.number is not None:
            result['Number'] = self.number
        if self.skill_group_id_list is not None:
            result['SkillGroupIdList'] = self.skill_group_id_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Number') is not None:
            self.number = m.get('Number')
        if m.get('SkillGroupIdList') is not None:
            self.skill_group_id_list = m.get('SkillGroupIdList')
        return self


class AddPhoneNumberToSkillGroupsResponseBody(TeaModel):
    def __init__(self, code=None, http_status_code=None, message=None, request_id=None):
        self.code = code  # type: str
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddPhoneNumberToSkillGroupsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddPhoneNumberToSkillGroupsResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: AddPhoneNumberToSkillGroupsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AddPhoneNumberToSkillGroupsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = AddPhoneNumberToSkillGroupsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddPhoneNumbersRequest(TeaModel):
    def __init__(self, contact_flow_id=None, instance_id=None, number_group_id=None, number_list=None, usage=None):
        self.contact_flow_id = contact_flow_id  # type: str
        self.instance_id = instance_id  # type: str
        self.number_group_id = number_group_id  # type: str
        self.number_list = number_list  # type: str
        self.usage = usage  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddPhoneNumbersRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.contact_flow_id is not None:
            result['ContactFlowId'] = self.contact_flow_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.number_group_id is not None:
            result['NumberGroupId'] = self.number_group_id
        if self.number_list is not None:
            result['NumberList'] = self.number_list
        if self.usage is not None:
            result['Usage'] = self.usage
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ContactFlowId') is not None:
            self.contact_flow_id = m.get('ContactFlowId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('NumberGroupId') is not None:
            self.number_group_id = m.get('NumberGroupId')
        if m.get('NumberList') is not None:
            self.number_list = m.get('NumberList')
        if m.get('Usage') is not None:
            self.usage = m.get('Usage')
        return self


class AddPhoneNumbersResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: list[str]
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddPhoneNumbersResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddPhoneNumbersResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: AddPhoneNumbersResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AddPhoneNumbersResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = AddPhoneNumbersResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddSkillGroupsToUserRequest(TeaModel):
    def __init__(self, instance_id=None, skill_level_list=None, user_id=None):
        self.instance_id = instance_id  # type: str
        self.skill_level_list = skill_level_list  # type: str
        self.user_id = user_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddSkillGroupsToUserRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.skill_level_list is not None:
            result['SkillLevelList'] = self.skill_level_list
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('SkillLevelList') is not None:
            self.skill_level_list = m.get('SkillLevelList')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class AddSkillGroupsToUserResponseBody(TeaModel):
    def __init__(self, code=None, http_status_code=None, message=None, params=None, request_id=None):
        self.code = code  # type: str
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.params = params  # type: list[str]
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddSkillGroupsToUserResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.params is not None:
            result['Params'] = self.params
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Params') is not None:
            self.params = m.get('Params')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddSkillGroupsToUserResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: AddSkillGroupsToUserResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AddSkillGroupsToUserResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = AddSkillGroupsToUserResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddUsersToSkillGroupRequest(TeaModel):
    def __init__(self, instance_id=None, skill_group_id=None, user_skill_level_list=None):
        self.instance_id = instance_id  # type: str
        self.skill_group_id = skill_group_id  # type: str
        self.user_skill_level_list = user_skill_level_list  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddUsersToSkillGroupRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.skill_group_id is not None:
            result['SkillGroupId'] = self.skill_group_id
        if self.user_skill_level_list is not None:
            result['UserSkillLevelList'] = self.user_skill_level_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('SkillGroupId') is not None:
            self.skill_group_id = m.get('SkillGroupId')
        if m.get('UserSkillLevelList') is not None:
            self.user_skill_level_list = m.get('UserSkillLevelList')
        return self


class AddUsersToSkillGroupResponseBody(TeaModel):
    def __init__(self, code=None, http_status_code=None, message=None, request_id=None):
        self.code = code  # type: str
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddUsersToSkillGroupResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddUsersToSkillGroupResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: AddUsersToSkillGroupResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AddUsersToSkillGroupResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = AddUsersToSkillGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AnswerCallRequest(TeaModel):
    def __init__(self, device_id=None, instance_id=None, job_id=None, user_id=None):
        self.device_id = device_id  # type: str
        self.instance_id = instance_id  # type: str
        self.job_id = job_id  # type: str
        self.user_id = user_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AnswerCallRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class AnswerCallResponseBodyDataCallContextChannelContexts(TeaModel):
    def __init__(self, associated_data=None, call_type=None, channel_id=None, channel_state=None, destination=None,
                 job_id=None, originator=None, release_initiator=None, release_reason=None, skill_group_id=None,
                 timestamp=None, user_extension=None, user_id=None):
        self.associated_data = associated_data  # type: dict[str, any]
        self.call_type = call_type  # type: str
        self.channel_id = channel_id  # type: str
        self.channel_state = channel_state  # type: str
        self.destination = destination  # type: str
        self.job_id = job_id  # type: str
        self.originator = originator  # type: str
        self.release_initiator = release_initiator  # type: str
        self.release_reason = release_reason  # type: str
        self.skill_group_id = skill_group_id  # type: str
        self.timestamp = timestamp  # type: long
        self.user_extension = user_extension  # type: str
        self.user_id = user_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AnswerCallResponseBodyDataCallContextChannelContexts, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.associated_data is not None:
            result['AssociatedData'] = self.associated_data
        if self.call_type is not None:
            result['CallType'] = self.call_type
        if self.channel_id is not None:
            result['ChannelId'] = self.channel_id
        if self.channel_state is not None:
            result['ChannelState'] = self.channel_state
        if self.destination is not None:
            result['Destination'] = self.destination
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.originator is not None:
            result['Originator'] = self.originator
        if self.release_initiator is not None:
            result['ReleaseInitiator'] = self.release_initiator
        if self.release_reason is not None:
            result['ReleaseReason'] = self.release_reason
        if self.skill_group_id is not None:
            result['SkillGroupId'] = self.skill_group_id
        if self.timestamp is not None:
            result['Timestamp'] = self.timestamp
        if self.user_extension is not None:
            result['UserExtension'] = self.user_extension
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AssociatedData') is not None:
            self.associated_data = m.get('AssociatedData')
        if m.get('CallType') is not None:
            self.call_type = m.get('CallType')
        if m.get('ChannelId') is not None:
            self.channel_id = m.get('ChannelId')
        if m.get('ChannelState') is not None:
            self.channel_state = m.get('ChannelState')
        if m.get('Destination') is not None:
            self.destination = m.get('Destination')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('Originator') is not None:
            self.originator = m.get('Originator')
        if m.get('ReleaseInitiator') is not None:
            self.release_initiator = m.get('ReleaseInitiator')
        if m.get('ReleaseReason') is not None:
            self.release_reason = m.get('ReleaseReason')
        if m.get('SkillGroupId') is not None:
            self.skill_group_id = m.get('SkillGroupId')
        if m.get('Timestamp') is not None:
            self.timestamp = m.get('Timestamp')
        if m.get('UserExtension') is not None:
            self.user_extension = m.get('UserExtension')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class AnswerCallResponseBodyDataCallContext(TeaModel):
    def __init__(self, channel_contexts=None, instance_id=None, job_id=None):
        self.channel_contexts = channel_contexts  # type: list[AnswerCallResponseBodyDataCallContextChannelContexts]
        self.instance_id = instance_id  # type: str
        self.job_id = job_id  # type: str

    def validate(self):
        if self.channel_contexts:
            for k in self.channel_contexts:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(AnswerCallResponseBodyDataCallContext, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ChannelContexts'] = []
        if self.channel_contexts is not None:
            for k in self.channel_contexts:
                result['ChannelContexts'].append(k.to_map() if k else None)
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.channel_contexts = []
        if m.get('ChannelContexts') is not None:
            for k in m.get('ChannelContexts'):
                temp_model = AnswerCallResponseBodyDataCallContextChannelContexts()
                self.channel_contexts.append(temp_model.from_map(k))
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class AnswerCallResponseBodyDataUserContext(TeaModel):
    def __init__(self, break_code=None, device_id=None, extension=None, heartbeat=None, instance_id=None,
                 job_id=None, mobile=None, outbound_scenario=None, reserved=None, signed_skill_group_id_list=None,
                 user_id=None, user_state=None, work_mode=None):
        self.break_code = break_code  # type: str
        self.device_id = device_id  # type: str
        self.extension = extension  # type: str
        self.heartbeat = heartbeat  # type: long
        self.instance_id = instance_id  # type: str
        self.job_id = job_id  # type: str
        self.mobile = mobile  # type: str
        self.outbound_scenario = outbound_scenario  # type: bool
        self.reserved = reserved  # type: long
        self.signed_skill_group_id_list = signed_skill_group_id_list  # type: list[str]
        self.user_id = user_id  # type: str
        self.user_state = user_state  # type: str
        self.work_mode = work_mode  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AnswerCallResponseBodyDataUserContext, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.break_code is not None:
            result['BreakCode'] = self.break_code
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.extension is not None:
            result['Extension'] = self.extension
        if self.heartbeat is not None:
            result['Heartbeat'] = self.heartbeat
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.mobile is not None:
            result['Mobile'] = self.mobile
        if self.outbound_scenario is not None:
            result['OutboundScenario'] = self.outbound_scenario
        if self.reserved is not None:
            result['Reserved'] = self.reserved
        if self.signed_skill_group_id_list is not None:
            result['SignedSkillGroupIdList'] = self.signed_skill_group_id_list
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.user_state is not None:
            result['UserState'] = self.user_state
        if self.work_mode is not None:
            result['WorkMode'] = self.work_mode
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BreakCode') is not None:
            self.break_code = m.get('BreakCode')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('Extension') is not None:
            self.extension = m.get('Extension')
        if m.get('Heartbeat') is not None:
            self.heartbeat = m.get('Heartbeat')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('Mobile') is not None:
            self.mobile = m.get('Mobile')
        if m.get('OutboundScenario') is not None:
            self.outbound_scenario = m.get('OutboundScenario')
        if m.get('Reserved') is not None:
            self.reserved = m.get('Reserved')
        if m.get('SignedSkillGroupIdList') is not None:
            self.signed_skill_group_id_list = m.get('SignedSkillGroupIdList')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('UserState') is not None:
            self.user_state = m.get('UserState')
        if m.get('WorkMode') is not None:
            self.work_mode = m.get('WorkMode')
        return self


class AnswerCallResponseBodyData(TeaModel):
    def __init__(self, call_context=None, context_id=None, user_context=None):
        self.call_context = call_context  # type: AnswerCallResponseBodyDataCallContext
        self.context_id = context_id  # type: long
        self.user_context = user_context  # type: AnswerCallResponseBodyDataUserContext

    def validate(self):
        if self.call_context:
            self.call_context.validate()
        if self.user_context:
            self.user_context.validate()

    def to_map(self):
        _map = super(AnswerCallResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.call_context is not None:
            result['CallContext'] = self.call_context.to_map()
        if self.context_id is not None:
            result['ContextId'] = self.context_id
        if self.user_context is not None:
            result['UserContext'] = self.user_context.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CallContext') is not None:
            temp_model = AnswerCallResponseBodyDataCallContext()
            self.call_context = temp_model.from_map(m['CallContext'])
        if m.get('ContextId') is not None:
            self.context_id = m.get('ContextId')
        if m.get('UserContext') is not None:
            temp_model = AnswerCallResponseBodyDataUserContext()
            self.user_context = temp_model.from_map(m['UserContext'])
        return self


class AnswerCallResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, params=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: AnswerCallResponseBodyData
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.params = params  # type: list[str]
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(AnswerCallResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.params is not None:
            result['Params'] = self.params
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = AnswerCallResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Params') is not None:
            self.params = m.get('Params')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AnswerCallResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: AnswerCallResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AnswerCallResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = AnswerCallResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AssignUsersRequest(TeaModel):
    def __init__(self, instance_id=None, ram_id_list=None, role_id=None, skill_level_list=None, work_mode=None):
        self.instance_id = instance_id  # type: str
        self.ram_id_list = ram_id_list  # type: str
        self.role_id = role_id  # type: str
        self.skill_level_list = skill_level_list  # type: str
        self.work_mode = work_mode  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AssignUsersRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.ram_id_list is not None:
            result['RamIdList'] = self.ram_id_list
        if self.role_id is not None:
            result['RoleId'] = self.role_id
        if self.skill_level_list is not None:
            result['SkillLevelList'] = self.skill_level_list
        if self.work_mode is not None:
            result['WorkMode'] = self.work_mode
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('RamIdList') is not None:
            self.ram_id_list = m.get('RamIdList')
        if m.get('RoleId') is not None:
            self.role_id = m.get('RoleId')
        if m.get('SkillLevelList') is not None:
            self.skill_level_list = m.get('SkillLevelList')
        if m.get('WorkMode') is not None:
            self.work_mode = m.get('WorkMode')
        return self


class AssignUsersResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, request_id=None, sync=None,
                 workflow_id=None):
        self.code = code  # type: str
        self.data = data  # type: str
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.sync = sync  # type: str
        self.workflow_id = workflow_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AssignUsersResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.sync is not None:
            result['Sync'] = self.sync
        if self.workflow_id is not None:
            result['WorkflowId'] = self.workflow_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Sync') is not None:
            self.sync = m.get('Sync')
        if m.get('WorkflowId') is not None:
            self.workflow_id = m.get('WorkflowId')
        return self


class AssignUsersResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: AssignUsersResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AssignUsersResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = AssignUsersResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BargeInCallRequest(TeaModel):
    def __init__(self, barged_user_id=None, device_id=None, instance_id=None, job_id=None, timeout_seconds=None,
                 user_id=None):
        self.barged_user_id = barged_user_id  # type: str
        self.device_id = device_id  # type: str
        self.instance_id = instance_id  # type: str
        self.job_id = job_id  # type: str
        self.timeout_seconds = timeout_seconds  # type: int
        self.user_id = user_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BargeInCallRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.barged_user_id is not None:
            result['BargedUserId'] = self.barged_user_id
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.timeout_seconds is not None:
            result['TimeoutSeconds'] = self.timeout_seconds
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BargedUserId') is not None:
            self.barged_user_id = m.get('BargedUserId')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('TimeoutSeconds') is not None:
            self.timeout_seconds = m.get('TimeoutSeconds')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class BargeInCallResponseBodyDataCallContextChannelContexts(TeaModel):
    def __init__(self, associated_data=None, call_type=None, channel_flags=None, channel_id=None,
                 channel_state=None, destination=None, index=None, job_id=None, originator=None, release_initiator=None,
                 release_reason=None, skill_group_id=None, timestamp=None, user_extension=None, user_id=None):
        self.associated_data = associated_data  # type: dict[str, any]
        self.call_type = call_type  # type: str
        self.channel_flags = channel_flags  # type: str
        self.channel_id = channel_id  # type: str
        self.channel_state = channel_state  # type: str
        self.destination = destination  # type: str
        self.index = index  # type: int
        self.job_id = job_id  # type: str
        self.originator = originator  # type: str
        self.release_initiator = release_initiator  # type: str
        self.release_reason = release_reason  # type: str
        self.skill_group_id = skill_group_id  # type: str
        self.timestamp = timestamp  # type: long
        self.user_extension = user_extension  # type: str
        self.user_id = user_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BargeInCallResponseBodyDataCallContextChannelContexts, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.associated_data is not None:
            result['AssociatedData'] = self.associated_data
        if self.call_type is not None:
            result['CallType'] = self.call_type
        if self.channel_flags is not None:
            result['ChannelFlags'] = self.channel_flags
        if self.channel_id is not None:
            result['ChannelId'] = self.channel_id
        if self.channel_state is not None:
            result['ChannelState'] = self.channel_state
        if self.destination is not None:
            result['Destination'] = self.destination
        if self.index is not None:
            result['Index'] = self.index
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.originator is not None:
            result['Originator'] = self.originator
        if self.release_initiator is not None:
            result['ReleaseInitiator'] = self.release_initiator
        if self.release_reason is not None:
            result['ReleaseReason'] = self.release_reason
        if self.skill_group_id is not None:
            result['SkillGroupId'] = self.skill_group_id
        if self.timestamp is not None:
            result['Timestamp'] = self.timestamp
        if self.user_extension is not None:
            result['UserExtension'] = self.user_extension
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AssociatedData') is not None:
            self.associated_data = m.get('AssociatedData')
        if m.get('CallType') is not None:
            self.call_type = m.get('CallType')
        if m.get('ChannelFlags') is not None:
            self.channel_flags = m.get('ChannelFlags')
        if m.get('ChannelId') is not None:
            self.channel_id = m.get('ChannelId')
        if m.get('ChannelState') is not None:
            self.channel_state = m.get('ChannelState')
        if m.get('Destination') is not None:
            self.destination = m.get('Destination')
        if m.get('Index') is not None:
            self.index = m.get('Index')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('Originator') is not None:
            self.originator = m.get('Originator')
        if m.get('ReleaseInitiator') is not None:
            self.release_initiator = m.get('ReleaseInitiator')
        if m.get('ReleaseReason') is not None:
            self.release_reason = m.get('ReleaseReason')
        if m.get('SkillGroupId') is not None:
            self.skill_group_id = m.get('SkillGroupId')
        if m.get('Timestamp') is not None:
            self.timestamp = m.get('Timestamp')
        if m.get('UserExtension') is not None:
            self.user_extension = m.get('UserExtension')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class BargeInCallResponseBodyDataCallContext(TeaModel):
    def __init__(self, call_type=None, channel_contexts=None, instance_id=None, job_id=None):
        self.call_type = call_type  # type: str
        self.channel_contexts = channel_contexts  # type: list[BargeInCallResponseBodyDataCallContextChannelContexts]
        self.instance_id = instance_id  # type: str
        self.job_id = job_id  # type: str

    def validate(self):
        if self.channel_contexts:
            for k in self.channel_contexts:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(BargeInCallResponseBodyDataCallContext, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.call_type is not None:
            result['CallType'] = self.call_type
        result['ChannelContexts'] = []
        if self.channel_contexts is not None:
            for k in self.channel_contexts:
                result['ChannelContexts'].append(k.to_map() if k else None)
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CallType') is not None:
            self.call_type = m.get('CallType')
        self.channel_contexts = []
        if m.get('ChannelContexts') is not None:
            for k in m.get('ChannelContexts'):
                temp_model = BargeInCallResponseBodyDataCallContextChannelContexts()
                self.channel_contexts.append(temp_model.from_map(k))
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class BargeInCallResponseBodyDataUserContext(TeaModel):
    def __init__(self, break_code=None, device_id=None, extension=None, heartbeat=None, instance_id=None,
                 job_id=None, mobile=None, outbound_scenario=None, reserved=None, signed_skill_group_id_list=None,
                 user_id=None, user_state=None, work_mode=None):
        self.break_code = break_code  # type: str
        self.device_id = device_id  # type: str
        self.extension = extension  # type: str
        self.heartbeat = heartbeat  # type: long
        self.instance_id = instance_id  # type: str
        self.job_id = job_id  # type: str
        self.mobile = mobile  # type: str
        self.outbound_scenario = outbound_scenario  # type: bool
        self.reserved = reserved  # type: long
        self.signed_skill_group_id_list = signed_skill_group_id_list  # type: list[str]
        self.user_id = user_id  # type: str
        self.user_state = user_state  # type: str
        self.work_mode = work_mode  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BargeInCallResponseBodyDataUserContext, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.break_code is not None:
            result['BreakCode'] = self.break_code
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.extension is not None:
            result['Extension'] = self.extension
        if self.heartbeat is not None:
            result['Heartbeat'] = self.heartbeat
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.mobile is not None:
            result['Mobile'] = self.mobile
        if self.outbound_scenario is not None:
            result['OutboundScenario'] = self.outbound_scenario
        if self.reserved is not None:
            result['Reserved'] = self.reserved
        if self.signed_skill_group_id_list is not None:
            result['SignedSkillGroupIdList'] = self.signed_skill_group_id_list
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.user_state is not None:
            result['UserState'] = self.user_state
        if self.work_mode is not None:
            result['WorkMode'] = self.work_mode
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BreakCode') is not None:
            self.break_code = m.get('BreakCode')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('Extension') is not None:
            self.extension = m.get('Extension')
        if m.get('Heartbeat') is not None:
            self.heartbeat = m.get('Heartbeat')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('Mobile') is not None:
            self.mobile = m.get('Mobile')
        if m.get('OutboundScenario') is not None:
            self.outbound_scenario = m.get('OutboundScenario')
        if m.get('Reserved') is not None:
            self.reserved = m.get('Reserved')
        if m.get('SignedSkillGroupIdList') is not None:
            self.signed_skill_group_id_list = m.get('SignedSkillGroupIdList')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('UserState') is not None:
            self.user_state = m.get('UserState')
        if m.get('WorkMode') is not None:
            self.work_mode = m.get('WorkMode')
        return self


class BargeInCallResponseBodyData(TeaModel):
    def __init__(self, call_context=None, user_context=None):
        self.call_context = call_context  # type: BargeInCallResponseBodyDataCallContext
        self.user_context = user_context  # type: BargeInCallResponseBodyDataUserContext

    def validate(self):
        if self.call_context:
            self.call_context.validate()
        if self.user_context:
            self.user_context.validate()

    def to_map(self):
        _map = super(BargeInCallResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.call_context is not None:
            result['CallContext'] = self.call_context.to_map()
        if self.user_context is not None:
            result['UserContext'] = self.user_context.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CallContext') is not None:
            temp_model = BargeInCallResponseBodyDataCallContext()
            self.call_context = temp_model.from_map(m['CallContext'])
        if m.get('UserContext') is not None:
            temp_model = BargeInCallResponseBodyDataUserContext()
            self.user_context = temp_model.from_map(m['UserContext'])
        return self


class BargeInCallResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, params=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: BargeInCallResponseBodyData
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.params = params  # type: list[str]
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(BargeInCallResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.params is not None:
            result['Params'] = self.params
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = BargeInCallResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Params') is not None:
            self.params = m.get('Params')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class BargeInCallResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: BargeInCallResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(BargeInCallResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = BargeInCallResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BlindTransferRequest(TeaModel):
    def __init__(self, device_id=None, instance_id=None, job_id=None, timeout_seconds=None, transferee=None,
                 transferor=None, user_id=None):
        self.device_id = device_id  # type: str
        self.instance_id = instance_id  # type: str
        self.job_id = job_id  # type: str
        self.timeout_seconds = timeout_seconds  # type: int
        self.transferee = transferee  # type: str
        self.transferor = transferor  # type: str
        self.user_id = user_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BlindTransferRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.timeout_seconds is not None:
            result['TimeoutSeconds'] = self.timeout_seconds
        if self.transferee is not None:
            result['Transferee'] = self.transferee
        if self.transferor is not None:
            result['Transferor'] = self.transferor
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('TimeoutSeconds') is not None:
            self.timeout_seconds = m.get('TimeoutSeconds')
        if m.get('Transferee') is not None:
            self.transferee = m.get('Transferee')
        if m.get('Transferor') is not None:
            self.transferor = m.get('Transferor')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class BlindTransferResponseBodyDataCallContextChannelContexts(TeaModel):
    def __init__(self, associated_data=None, call_type=None, channel_flags=None, channel_id=None,
                 channel_state=None, destination=None, job_id=None, originator=None, release_initiator=None, release_reason=None,
                 timestamp=None, user_extension=None, user_id=None):
        self.associated_data = associated_data  # type: dict[str, any]
        self.call_type = call_type  # type: str
        self.channel_flags = channel_flags  # type: str
        self.channel_id = channel_id  # type: str
        self.channel_state = channel_state  # type: str
        self.destination = destination  # type: str
        self.job_id = job_id  # type: str
        self.originator = originator  # type: str
        self.release_initiator = release_initiator  # type: str
        self.release_reason = release_reason  # type: str
        self.timestamp = timestamp  # type: long
        self.user_extension = user_extension  # type: str
        self.user_id = user_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BlindTransferResponseBodyDataCallContextChannelContexts, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.associated_data is not None:
            result['AssociatedData'] = self.associated_data
        if self.call_type is not None:
            result['CallType'] = self.call_type
        if self.channel_flags is not None:
            result['ChannelFlags'] = self.channel_flags
        if self.channel_id is not None:
            result['ChannelId'] = self.channel_id
        if self.channel_state is not None:
            result['ChannelState'] = self.channel_state
        if self.destination is not None:
            result['Destination'] = self.destination
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.originator is not None:
            result['Originator'] = self.originator
        if self.release_initiator is not None:
            result['ReleaseInitiator'] = self.release_initiator
        if self.release_reason is not None:
            result['ReleaseReason'] = self.release_reason
        if self.timestamp is not None:
            result['Timestamp'] = self.timestamp
        if self.user_extension is not None:
            result['UserExtension'] = self.user_extension
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AssociatedData') is not None:
            self.associated_data = m.get('AssociatedData')
        if m.get('CallType') is not None:
            self.call_type = m.get('CallType')
        if m.get('ChannelFlags') is not None:
            self.channel_flags = m.get('ChannelFlags')
        if m.get('ChannelId') is not None:
            self.channel_id = m.get('ChannelId')
        if m.get('ChannelState') is not None:
            self.channel_state = m.get('ChannelState')
        if m.get('Destination') is not None:
            self.destination = m.get('Destination')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('Originator') is not None:
            self.originator = m.get('Originator')
        if m.get('ReleaseInitiator') is not None:
            self.release_initiator = m.get('ReleaseInitiator')
        if m.get('ReleaseReason') is not None:
            self.release_reason = m.get('ReleaseReason')
        if m.get('Timestamp') is not None:
            self.timestamp = m.get('Timestamp')
        if m.get('UserExtension') is not None:
            self.user_extension = m.get('UserExtension')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class BlindTransferResponseBodyDataCallContext(TeaModel):
    def __init__(self, call_type=None, channel_contexts=None, instance_id=None, job_id=None):
        self.call_type = call_type  # type: str
        self.channel_contexts = channel_contexts  # type: list[BlindTransferResponseBodyDataCallContextChannelContexts]
        self.instance_id = instance_id  # type: str
        self.job_id = job_id  # type: str

    def validate(self):
        if self.channel_contexts:
            for k in self.channel_contexts:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(BlindTransferResponseBodyDataCallContext, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.call_type is not None:
            result['CallType'] = self.call_type
        result['ChannelContexts'] = []
        if self.channel_contexts is not None:
            for k in self.channel_contexts:
                result['ChannelContexts'].append(k.to_map() if k else None)
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CallType') is not None:
            self.call_type = m.get('CallType')
        self.channel_contexts = []
        if m.get('ChannelContexts') is not None:
            for k in m.get('ChannelContexts'):
                temp_model = BlindTransferResponseBodyDataCallContextChannelContexts()
                self.channel_contexts.append(temp_model.from_map(k))
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class BlindTransferResponseBodyDataUserContext(TeaModel):
    def __init__(self, break_code=None, device_id=None, extension=None, heartbeat=None, instance_id=None,
                 job_id=None, mobile=None, outbound_scenario=None, reserved=None, signed_skill_group_id_list=None,
                 user_id=None, user_state=None, work_mode=None):
        self.break_code = break_code  # type: str
        self.device_id = device_id  # type: str
        self.extension = extension  # type: str
        self.heartbeat = heartbeat  # type: long
        self.instance_id = instance_id  # type: str
        self.job_id = job_id  # type: str
        self.mobile = mobile  # type: str
        self.outbound_scenario = outbound_scenario  # type: bool
        self.reserved = reserved  # type: long
        self.signed_skill_group_id_list = signed_skill_group_id_list  # type: list[str]
        self.user_id = user_id  # type: str
        self.user_state = user_state  # type: str
        self.work_mode = work_mode  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BlindTransferResponseBodyDataUserContext, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.break_code is not None:
            result['BreakCode'] = self.break_code
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.extension is not None:
            result['Extension'] = self.extension
        if self.heartbeat is not None:
            result['Heartbeat'] = self.heartbeat
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.mobile is not None:
            result['Mobile'] = self.mobile
        if self.outbound_scenario is not None:
            result['OutboundScenario'] = self.outbound_scenario
        if self.reserved is not None:
            result['Reserved'] = self.reserved
        if self.signed_skill_group_id_list is not None:
            result['SignedSkillGroupIdList'] = self.signed_skill_group_id_list
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.user_state is not None:
            result['UserState'] = self.user_state
        if self.work_mode is not None:
            result['WorkMode'] = self.work_mode
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BreakCode') is not None:
            self.break_code = m.get('BreakCode')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('Extension') is not None:
            self.extension = m.get('Extension')
        if m.get('Heartbeat') is not None:
            self.heartbeat = m.get('Heartbeat')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('Mobile') is not None:
            self.mobile = m.get('Mobile')
        if m.get('OutboundScenario') is not None:
            self.outbound_scenario = m.get('OutboundScenario')
        if m.get('Reserved') is not None:
            self.reserved = m.get('Reserved')
        if m.get('SignedSkillGroupIdList') is not None:
            self.signed_skill_group_id_list = m.get('SignedSkillGroupIdList')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('UserState') is not None:
            self.user_state = m.get('UserState')
        if m.get('WorkMode') is not None:
            self.work_mode = m.get('WorkMode')
        return self


class BlindTransferResponseBodyData(TeaModel):
    def __init__(self, call_context=None, user_context=None):
        self.call_context = call_context  # type: BlindTransferResponseBodyDataCallContext
        self.user_context = user_context  # type: BlindTransferResponseBodyDataUserContext

    def validate(self):
        if self.call_context:
            self.call_context.validate()
        if self.user_context:
            self.user_context.validate()

    def to_map(self):
        _map = super(BlindTransferResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.call_context is not None:
            result['CallContext'] = self.call_context.to_map()
        if self.user_context is not None:
            result['UserContext'] = self.user_context.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CallContext') is not None:
            temp_model = BlindTransferResponseBodyDataCallContext()
            self.call_context = temp_model.from_map(m['CallContext'])
        if m.get('UserContext') is not None:
            temp_model = BlindTransferResponseBodyDataUserContext()
            self.user_context = temp_model.from_map(m['UserContext'])
        return self


class BlindTransferResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, params=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: BlindTransferResponseBodyData
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.params = params  # type: list[str]
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(BlindTransferResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.params is not None:
            result['Params'] = self.params
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = BlindTransferResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Params') is not None:
            self.params = m.get('Params')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class BlindTransferResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: BlindTransferResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(BlindTransferResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = BlindTransferResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CancelAttendedTransferRequest(TeaModel):
    def __init__(self, device_id=None, instance_id=None, job_id=None, user_id=None):
        self.device_id = device_id  # type: str
        self.instance_id = instance_id  # type: str
        self.job_id = job_id  # type: str
        self.user_id = user_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CancelAttendedTransferRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class CancelAttendedTransferResponseBodyDataCallContextChannelContexts(TeaModel):
    def __init__(self, associated_data=None, call_type=None, channel_flags=None, channel_id=None,
                 channel_state=None, destination=None, index=None, job_id=None, originator=None, release_initiator=None,
                 release_reason=None, timestamp=None, user_extension=None, user_id=None):
        self.associated_data = associated_data  # type: dict[str, any]
        self.call_type = call_type  # type: str
        self.channel_flags = channel_flags  # type: str
        self.channel_id = channel_id  # type: str
        self.channel_state = channel_state  # type: str
        self.destination = destination  # type: str
        self.index = index  # type: int
        self.job_id = job_id  # type: str
        self.originator = originator  # type: str
        self.release_initiator = release_initiator  # type: str
        self.release_reason = release_reason  # type: str
        self.timestamp = timestamp  # type: long
        self.user_extension = user_extension  # type: str
        self.user_id = user_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CancelAttendedTransferResponseBodyDataCallContextChannelContexts, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.associated_data is not None:
            result['AssociatedData'] = self.associated_data
        if self.call_type is not None:
            result['CallType'] = self.call_type
        if self.channel_flags is not None:
            result['ChannelFlags'] = self.channel_flags
        if self.channel_id is not None:
            result['ChannelId'] = self.channel_id
        if self.channel_state is not None:
            result['ChannelState'] = self.channel_state
        if self.destination is not None:
            result['Destination'] = self.destination
        if self.index is not None:
            result['Index'] = self.index
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.originator is not None:
            result['Originator'] = self.originator
        if self.release_initiator is not None:
            result['ReleaseInitiator'] = self.release_initiator
        if self.release_reason is not None:
            result['ReleaseReason'] = self.release_reason
        if self.timestamp is not None:
            result['Timestamp'] = self.timestamp
        if self.user_extension is not None:
            result['UserExtension'] = self.user_extension
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AssociatedData') is not None:
            self.associated_data = m.get('AssociatedData')
        if m.get('CallType') is not None:
            self.call_type = m.get('CallType')
        if m.get('ChannelFlags') is not None:
            self.channel_flags = m.get('ChannelFlags')
        if m.get('ChannelId') is not None:
            self.channel_id = m.get('ChannelId')
        if m.get('ChannelState') is not None:
            self.channel_state = m.get('ChannelState')
        if m.get('Destination') is not None:
            self.destination = m.get('Destination')
        if m.get('Index') is not None:
            self.index = m.get('Index')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('Originator') is not None:
            self.originator = m.get('Originator')
        if m.get('ReleaseInitiator') is not None:
            self.release_initiator = m.get('ReleaseInitiator')
        if m.get('ReleaseReason') is not None:
            self.release_reason = m.get('ReleaseReason')
        if m.get('Timestamp') is not None:
            self.timestamp = m.get('Timestamp')
        if m.get('UserExtension') is not None:
            self.user_extension = m.get('UserExtension')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class CancelAttendedTransferResponseBodyDataCallContext(TeaModel):
    def __init__(self, call_type=None, channel_contexts=None, instance_id=None, job_id=None):
        self.call_type = call_type  # type: str
        self.channel_contexts = channel_contexts  # type: list[CancelAttendedTransferResponseBodyDataCallContextChannelContexts]
        self.instance_id = instance_id  # type: str
        self.job_id = job_id  # type: str

    def validate(self):
        if self.channel_contexts:
            for k in self.channel_contexts:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CancelAttendedTransferResponseBodyDataCallContext, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.call_type is not None:
            result['CallType'] = self.call_type
        result['ChannelContexts'] = []
        if self.channel_contexts is not None:
            for k in self.channel_contexts:
                result['ChannelContexts'].append(k.to_map() if k else None)
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CallType') is not None:
            self.call_type = m.get('CallType')
        self.channel_contexts = []
        if m.get('ChannelContexts') is not None:
            for k in m.get('ChannelContexts'):
                temp_model = CancelAttendedTransferResponseBodyDataCallContextChannelContexts()
                self.channel_contexts.append(temp_model.from_map(k))
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class CancelAttendedTransferResponseBodyDataUserContext(TeaModel):
    def __init__(self, break_code=None, device_id=None, extension=None, heartbeat=None, instance_id=None,
                 job_id=None, mobile=None, outbound_scenario=None, reserved=None, signed_skill_group_id_list=None,
                 user_id=None, user_state=None, work_mode=None):
        self.break_code = break_code  # type: str
        self.device_id = device_id  # type: str
        self.extension = extension  # type: str
        self.heartbeat = heartbeat  # type: long
        self.instance_id = instance_id  # type: str
        self.job_id = job_id  # type: str
        self.mobile = mobile  # type: str
        self.outbound_scenario = outbound_scenario  # type: bool
        self.reserved = reserved  # type: long
        self.signed_skill_group_id_list = signed_skill_group_id_list  # type: list[str]
        self.user_id = user_id  # type: str
        self.user_state = user_state  # type: str
        self.work_mode = work_mode  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CancelAttendedTransferResponseBodyDataUserContext, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.break_code is not None:
            result['BreakCode'] = self.break_code
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.extension is not None:
            result['Extension'] = self.extension
        if self.heartbeat is not None:
            result['Heartbeat'] = self.heartbeat
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.mobile is not None:
            result['Mobile'] = self.mobile
        if self.outbound_scenario is not None:
            result['OutboundScenario'] = self.outbound_scenario
        if self.reserved is not None:
            result['Reserved'] = self.reserved
        if self.signed_skill_group_id_list is not None:
            result['SignedSkillGroupIdList'] = self.signed_skill_group_id_list
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.user_state is not None:
            result['UserState'] = self.user_state
        if self.work_mode is not None:
            result['WorkMode'] = self.work_mode
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BreakCode') is not None:
            self.break_code = m.get('BreakCode')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('Extension') is not None:
            self.extension = m.get('Extension')
        if m.get('Heartbeat') is not None:
            self.heartbeat = m.get('Heartbeat')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('Mobile') is not None:
            self.mobile = m.get('Mobile')
        if m.get('OutboundScenario') is not None:
            self.outbound_scenario = m.get('OutboundScenario')
        if m.get('Reserved') is not None:
            self.reserved = m.get('Reserved')
        if m.get('SignedSkillGroupIdList') is not None:
            self.signed_skill_group_id_list = m.get('SignedSkillGroupIdList')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('UserState') is not None:
            self.user_state = m.get('UserState')
        if m.get('WorkMode') is not None:
            self.work_mode = m.get('WorkMode')
        return self


class CancelAttendedTransferResponseBodyData(TeaModel):
    def __init__(self, call_context=None, context_id=None, user_context=None):
        self.call_context = call_context  # type: CancelAttendedTransferResponseBodyDataCallContext
        self.context_id = context_id  # type: long
        self.user_context = user_context  # type: CancelAttendedTransferResponseBodyDataUserContext

    def validate(self):
        if self.call_context:
            self.call_context.validate()
        if self.user_context:
            self.user_context.validate()

    def to_map(self):
        _map = super(CancelAttendedTransferResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.call_context is not None:
            result['CallContext'] = self.call_context.to_map()
        if self.context_id is not None:
            result['ContextId'] = self.context_id
        if self.user_context is not None:
            result['UserContext'] = self.user_context.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CallContext') is not None:
            temp_model = CancelAttendedTransferResponseBodyDataCallContext()
            self.call_context = temp_model.from_map(m['CallContext'])
        if m.get('ContextId') is not None:
            self.context_id = m.get('ContextId')
        if m.get('UserContext') is not None:
            temp_model = CancelAttendedTransferResponseBodyDataUserContext()
            self.user_context = temp_model.from_map(m['UserContext'])
        return self


class CancelAttendedTransferResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, params=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: CancelAttendedTransferResponseBodyData
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.params = params  # type: list[str]
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(CancelAttendedTransferResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.params is not None:
            result['Params'] = self.params
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = CancelAttendedTransferResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Params') is not None:
            self.params = m.get('Params')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CancelAttendedTransferResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: CancelAttendedTransferResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CancelAttendedTransferResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CancelAttendedTransferResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ChangeWorkModeRequest(TeaModel):
    def __init__(self, device_id=None, instance_id=None, user_id=None, work_mode=None):
        self.device_id = device_id  # type: str
        self.instance_id = instance_id  # type: str
        self.user_id = user_id  # type: str
        self.work_mode = work_mode  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ChangeWorkModeRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.work_mode is not None:
            result['WorkMode'] = self.work_mode
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('WorkMode') is not None:
            self.work_mode = m.get('WorkMode')
        return self


class ChangeWorkModeResponseBodyData(TeaModel):
    def __init__(self, break_code=None, device_id=None, extension=None, instance_id=None, job_id=None,
                 outbound_scenario=None, signed_skill_group_id_list=None, user_id=None, user_state=None, work_mode=None):
        self.break_code = break_code  # type: str
        self.device_id = device_id  # type: str
        self.extension = extension  # type: str
        self.instance_id = instance_id  # type: str
        self.job_id = job_id  # type: str
        self.outbound_scenario = outbound_scenario  # type: bool
        self.signed_skill_group_id_list = signed_skill_group_id_list  # type: list[str]
        self.user_id = user_id  # type: str
        self.user_state = user_state  # type: str
        self.work_mode = work_mode  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ChangeWorkModeResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.break_code is not None:
            result['BreakCode'] = self.break_code
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.extension is not None:
            result['Extension'] = self.extension
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.outbound_scenario is not None:
            result['OutboundScenario'] = self.outbound_scenario
        if self.signed_skill_group_id_list is not None:
            result['SignedSkillGroupIdList'] = self.signed_skill_group_id_list
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.user_state is not None:
            result['UserState'] = self.user_state
        if self.work_mode is not None:
            result['WorkMode'] = self.work_mode
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BreakCode') is not None:
            self.break_code = m.get('BreakCode')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('Extension') is not None:
            self.extension = m.get('Extension')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('OutboundScenario') is not None:
            self.outbound_scenario = m.get('OutboundScenario')
        if m.get('SignedSkillGroupIdList') is not None:
            self.signed_skill_group_id_list = m.get('SignedSkillGroupIdList')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('UserState') is not None:
            self.user_state = m.get('UserState')
        if m.get('WorkMode') is not None:
            self.work_mode = m.get('WorkMode')
        return self


class ChangeWorkModeResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, params=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: ChangeWorkModeResponseBodyData
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.params = params  # type: list[str]
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(ChangeWorkModeResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.params is not None:
            result['Params'] = self.params
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = ChangeWorkModeResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Params') is not None:
            self.params = m.get('Params')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ChangeWorkModeResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ChangeWorkModeResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ChangeWorkModeResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ChangeWorkModeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CoachCallRequest(TeaModel):
    def __init__(self, coached_user_id=None, device_id=None, instance_id=None, job_id=None, timeout_seconds=None,
                 user_id=None):
        self.coached_user_id = coached_user_id  # type: str
        self.device_id = device_id  # type: str
        self.instance_id = instance_id  # type: str
        self.job_id = job_id  # type: str
        self.timeout_seconds = timeout_seconds  # type: int
        self.user_id = user_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CoachCallRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.coached_user_id is not None:
            result['CoachedUserId'] = self.coached_user_id
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.timeout_seconds is not None:
            result['TimeoutSeconds'] = self.timeout_seconds
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CoachedUserId') is not None:
            self.coached_user_id = m.get('CoachedUserId')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('TimeoutSeconds') is not None:
            self.timeout_seconds = m.get('TimeoutSeconds')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class CoachCallResponseBodyDataCallContextChannelContexts(TeaModel):
    def __init__(self, associated_data=None, call_type=None, channel_flags=None, channel_id=None,
                 channel_state=None, destination=None, index=None, job_id=None, originator=None, release_initiator=None,
                 release_reason=None, skill_group_id=None, timestamp=None, user_extension=None, user_id=None):
        self.associated_data = associated_data  # type: dict[str, any]
        self.call_type = call_type  # type: str
        self.channel_flags = channel_flags  # type: str
        self.channel_id = channel_id  # type: str
        self.channel_state = channel_state  # type: str
        self.destination = destination  # type: str
        self.index = index  # type: int
        self.job_id = job_id  # type: str
        self.originator = originator  # type: str
        self.release_initiator = release_initiator  # type: str
        self.release_reason = release_reason  # type: str
        self.skill_group_id = skill_group_id  # type: str
        self.timestamp = timestamp  # type: long
        self.user_extension = user_extension  # type: str
        self.user_id = user_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CoachCallResponseBodyDataCallContextChannelContexts, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.associated_data is not None:
            result['AssociatedData'] = self.associated_data
        if self.call_type is not None:
            result['CallType'] = self.call_type
        if self.channel_flags is not None:
            result['ChannelFlags'] = self.channel_flags
        if self.channel_id is not None:
            result['ChannelId'] = self.channel_id
        if self.channel_state is not None:
            result['ChannelState'] = self.channel_state
        if self.destination is not None:
            result['Destination'] = self.destination
        if self.index is not None:
            result['Index'] = self.index
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.originator is not None:
            result['Originator'] = self.originator
        if self.release_initiator is not None:
            result['ReleaseInitiator'] = self.release_initiator
        if self.release_reason is not None:
            result['ReleaseReason'] = self.release_reason
        if self.skill_group_id is not None:
            result['SkillGroupId'] = self.skill_group_id
        if self.timestamp is not None:
            result['Timestamp'] = self.timestamp
        if self.user_extension is not None:
            result['UserExtension'] = self.user_extension
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AssociatedData') is not None:
            self.associated_data = m.get('AssociatedData')
        if m.get('CallType') is not None:
            self.call_type = m.get('CallType')
        if m.get('ChannelFlags') is not None:
            self.channel_flags = m.get('ChannelFlags')
        if m.get('ChannelId') is not None:
            self.channel_id = m.get('ChannelId')
        if m.get('ChannelState') is not None:
            self.channel_state = m.get('ChannelState')
        if m.get('Destination') is not None:
            self.destination = m.get('Destination')
        if m.get('Index') is not None:
            self.index = m.get('Index')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('Originator') is not None:
            self.originator = m.get('Originator')
        if m.get('ReleaseInitiator') is not None:
            self.release_initiator = m.get('ReleaseInitiator')
        if m.get('ReleaseReason') is not None:
            self.release_reason = m.get('ReleaseReason')
        if m.get('SkillGroupId') is not None:
            self.skill_group_id = m.get('SkillGroupId')
        if m.get('Timestamp') is not None:
            self.timestamp = m.get('Timestamp')
        if m.get('UserExtension') is not None:
            self.user_extension = m.get('UserExtension')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class CoachCallResponseBodyDataCallContext(TeaModel):
    def __init__(self, call_type=None, channel_contexts=None, instance_id=None, job_id=None):
        self.call_type = call_type  # type: str
        self.channel_contexts = channel_contexts  # type: list[CoachCallResponseBodyDataCallContextChannelContexts]
        self.instance_id = instance_id  # type: str
        self.job_id = job_id  # type: str

    def validate(self):
        if self.channel_contexts:
            for k in self.channel_contexts:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CoachCallResponseBodyDataCallContext, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.call_type is not None:
            result['CallType'] = self.call_type
        result['ChannelContexts'] = []
        if self.channel_contexts is not None:
            for k in self.channel_contexts:
                result['ChannelContexts'].append(k.to_map() if k else None)
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CallType') is not None:
            self.call_type = m.get('CallType')
        self.channel_contexts = []
        if m.get('ChannelContexts') is not None:
            for k in m.get('ChannelContexts'):
                temp_model = CoachCallResponseBodyDataCallContextChannelContexts()
                self.channel_contexts.append(temp_model.from_map(k))
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class CoachCallResponseBodyDataUserContext(TeaModel):
    def __init__(self, break_code=None, device_id=None, device_state=None, extension=None, heartbeat=None,
                 instance_id=None, job_id=None, mobile=None, outbound_scenario=None, reserved=None,
                 signed_skill_group_id_list=None, uri=None, user_id=None, user_state=None, work_mode=None):
        self.break_code = break_code  # type: str
        self.device_id = device_id  # type: str
        self.device_state = device_state  # type: str
        self.extension = extension  # type: str
        self.heartbeat = heartbeat  # type: long
        self.instance_id = instance_id  # type: str
        self.job_id = job_id  # type: str
        self.mobile = mobile  # type: str
        self.outbound_scenario = outbound_scenario  # type: bool
        self.reserved = reserved  # type: long
        self.signed_skill_group_id_list = signed_skill_group_id_list  # type: list[str]
        self.uri = uri  # type: str
        self.user_id = user_id  # type: str
        self.user_state = user_state  # type: str
        self.work_mode = work_mode  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CoachCallResponseBodyDataUserContext, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.break_code is not None:
            result['BreakCode'] = self.break_code
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.device_state is not None:
            result['DeviceState'] = self.device_state
        if self.extension is not None:
            result['Extension'] = self.extension
        if self.heartbeat is not None:
            result['Heartbeat'] = self.heartbeat
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.mobile is not None:
            result['Mobile'] = self.mobile
        if self.outbound_scenario is not None:
            result['OutboundScenario'] = self.outbound_scenario
        if self.reserved is not None:
            result['Reserved'] = self.reserved
        if self.signed_skill_group_id_list is not None:
            result['SignedSkillGroupIdList'] = self.signed_skill_group_id_list
        if self.uri is not None:
            result['Uri'] = self.uri
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.user_state is not None:
            result['UserState'] = self.user_state
        if self.work_mode is not None:
            result['WorkMode'] = self.work_mode
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BreakCode') is not None:
            self.break_code = m.get('BreakCode')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('DeviceState') is not None:
            self.device_state = m.get('DeviceState')
        if m.get('Extension') is not None:
            self.extension = m.get('Extension')
        if m.get('Heartbeat') is not None:
            self.heartbeat = m.get('Heartbeat')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('Mobile') is not None:
            self.mobile = m.get('Mobile')
        if m.get('OutboundScenario') is not None:
            self.outbound_scenario = m.get('OutboundScenario')
        if m.get('Reserved') is not None:
            self.reserved = m.get('Reserved')
        if m.get('SignedSkillGroupIdList') is not None:
            self.signed_skill_group_id_list = m.get('SignedSkillGroupIdList')
        if m.get('Uri') is not None:
            self.uri = m.get('Uri')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('UserState') is not None:
            self.user_state = m.get('UserState')
        if m.get('WorkMode') is not None:
            self.work_mode = m.get('WorkMode')
        return self


class CoachCallResponseBodyData(TeaModel):
    def __init__(self, call_context=None, user_context=None):
        self.call_context = call_context  # type: CoachCallResponseBodyDataCallContext
        self.user_context = user_context  # type: CoachCallResponseBodyDataUserContext

    def validate(self):
        if self.call_context:
            self.call_context.validate()
        if self.user_context:
            self.user_context.validate()

    def to_map(self):
        _map = super(CoachCallResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.call_context is not None:
            result['CallContext'] = self.call_context.to_map()
        if self.user_context is not None:
            result['UserContext'] = self.user_context.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CallContext') is not None:
            temp_model = CoachCallResponseBodyDataCallContext()
            self.call_context = temp_model.from_map(m['CallContext'])
        if m.get('UserContext') is not None:
            temp_model = CoachCallResponseBodyDataUserContext()
            self.user_context = temp_model.from_map(m['UserContext'])
        return self


class CoachCallResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, params=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: CoachCallResponseBodyData
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.params = params  # type: list[str]
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(CoachCallResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.params is not None:
            result['Params'] = self.params
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = CoachCallResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Params') is not None:
            self.params = m.get('Params')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CoachCallResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: CoachCallResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CoachCallResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CoachCallResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CompleteAttendedTransferRequest(TeaModel):
    def __init__(self, device_id=None, instance_id=None, job_id=None, user_id=None):
        self.device_id = device_id  # type: str
        self.instance_id = instance_id  # type: str
        self.job_id = job_id  # type: str
        self.user_id = user_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CompleteAttendedTransferRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class CompleteAttendedTransferResponseBodyDataCallContextChannelContexts(TeaModel):
    def __init__(self, associated_data=None, call_type=None, channel_flags=None, channel_id=None,
                 channel_state=None, destination=None, index=None, job_id=None, originator=None, release_initiator=None,
                 release_reason=None, skill_group_id=None, timestamp=None, user_extension=None, user_id=None):
        self.associated_data = associated_data  # type: dict[str, any]
        self.call_type = call_type  # type: str
        self.channel_flags = channel_flags  # type: str
        self.channel_id = channel_id  # type: str
        self.channel_state = channel_state  # type: str
        self.destination = destination  # type: str
        self.index = index  # type: int
        self.job_id = job_id  # type: str
        self.originator = originator  # type: str
        self.release_initiator = release_initiator  # type: str
        self.release_reason = release_reason  # type: str
        self.skill_group_id = skill_group_id  # type: str
        self.timestamp = timestamp  # type: long
        self.user_extension = user_extension  # type: str
        self.user_id = user_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CompleteAttendedTransferResponseBodyDataCallContextChannelContexts, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.associated_data is not None:
            result['AssociatedData'] = self.associated_data
        if self.call_type is not None:
            result['CallType'] = self.call_type
        if self.channel_flags is not None:
            result['ChannelFlags'] = self.channel_flags
        if self.channel_id is not None:
            result['ChannelId'] = self.channel_id
        if self.channel_state is not None:
            result['ChannelState'] = self.channel_state
        if self.destination is not None:
            result['Destination'] = self.destination
        if self.index is not None:
            result['Index'] = self.index
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.originator is not None:
            result['Originator'] = self.originator
        if self.release_initiator is not None:
            result['ReleaseInitiator'] = self.release_initiator
        if self.release_reason is not None:
            result['ReleaseReason'] = self.release_reason
        if self.skill_group_id is not None:
            result['SkillGroupId'] = self.skill_group_id
        if self.timestamp is not None:
            result['Timestamp'] = self.timestamp
        if self.user_extension is not None:
            result['UserExtension'] = self.user_extension
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AssociatedData') is not None:
            self.associated_data = m.get('AssociatedData')
        if m.get('CallType') is not None:
            self.call_type = m.get('CallType')
        if m.get('ChannelFlags') is not None:
            self.channel_flags = m.get('ChannelFlags')
        if m.get('ChannelId') is not None:
            self.channel_id = m.get('ChannelId')
        if m.get('ChannelState') is not None:
            self.channel_state = m.get('ChannelState')
        if m.get('Destination') is not None:
            self.destination = m.get('Destination')
        if m.get('Index') is not None:
            self.index = m.get('Index')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('Originator') is not None:
            self.originator = m.get('Originator')
        if m.get('ReleaseInitiator') is not None:
            self.release_initiator = m.get('ReleaseInitiator')
        if m.get('ReleaseReason') is not None:
            self.release_reason = m.get('ReleaseReason')
        if m.get('SkillGroupId') is not None:
            self.skill_group_id = m.get('SkillGroupId')
        if m.get('Timestamp') is not None:
            self.timestamp = m.get('Timestamp')
        if m.get('UserExtension') is not None:
            self.user_extension = m.get('UserExtension')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class CompleteAttendedTransferResponseBodyDataCallContext(TeaModel):
    def __init__(self, call_type=None, channel_contexts=None, instance_id=None, job_id=None):
        self.call_type = call_type  # type: str
        self.channel_contexts = channel_contexts  # type: list[CompleteAttendedTransferResponseBodyDataCallContextChannelContexts]
        self.instance_id = instance_id  # type: str
        self.job_id = job_id  # type: str

    def validate(self):
        if self.channel_contexts:
            for k in self.channel_contexts:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CompleteAttendedTransferResponseBodyDataCallContext, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.call_type is not None:
            result['CallType'] = self.call_type
        result['ChannelContexts'] = []
        if self.channel_contexts is not None:
            for k in self.channel_contexts:
                result['ChannelContexts'].append(k.to_map() if k else None)
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CallType') is not None:
            self.call_type = m.get('CallType')
        self.channel_contexts = []
        if m.get('ChannelContexts') is not None:
            for k in m.get('ChannelContexts'):
                temp_model = CompleteAttendedTransferResponseBodyDataCallContextChannelContexts()
                self.channel_contexts.append(temp_model.from_map(k))
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class CompleteAttendedTransferResponseBodyDataUserContext(TeaModel):
    def __init__(self, break_code=None, device_id=None, extension=None, heartbeat=None, instance_id=None,
                 job_id=None, mobile=None, outbound_scenario=None, reserved=None, signed_skill_group_id_list=None,
                 user_id=None, user_state=None, work_mode=None):
        self.break_code = break_code  # type: str
        self.device_id = device_id  # type: str
        self.extension = extension  # type: str
        self.heartbeat = heartbeat  # type: long
        self.instance_id = instance_id  # type: str
        self.job_id = job_id  # type: str
        self.mobile = mobile  # type: str
        self.outbound_scenario = outbound_scenario  # type: bool
        self.reserved = reserved  # type: long
        self.signed_skill_group_id_list = signed_skill_group_id_list  # type: list[str]
        self.user_id = user_id  # type: str
        self.user_state = user_state  # type: str
        self.work_mode = work_mode  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CompleteAttendedTransferResponseBodyDataUserContext, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.break_code is not None:
            result['BreakCode'] = self.break_code
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.extension is not None:
            result['Extension'] = self.extension
        if self.heartbeat is not None:
            result['Heartbeat'] = self.heartbeat
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.mobile is not None:
            result['Mobile'] = self.mobile
        if self.outbound_scenario is not None:
            result['OutboundScenario'] = self.outbound_scenario
        if self.reserved is not None:
            result['Reserved'] = self.reserved
        if self.signed_skill_group_id_list is not None:
            result['SignedSkillGroupIdList'] = self.signed_skill_group_id_list
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.user_state is not None:
            result['UserState'] = self.user_state
        if self.work_mode is not None:
            result['WorkMode'] = self.work_mode
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BreakCode') is not None:
            self.break_code = m.get('BreakCode')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('Extension') is not None:
            self.extension = m.get('Extension')
        if m.get('Heartbeat') is not None:
            self.heartbeat = m.get('Heartbeat')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('Mobile') is not None:
            self.mobile = m.get('Mobile')
        if m.get('OutboundScenario') is not None:
            self.outbound_scenario = m.get('OutboundScenario')
        if m.get('Reserved') is not None:
            self.reserved = m.get('Reserved')
        if m.get('SignedSkillGroupIdList') is not None:
            self.signed_skill_group_id_list = m.get('SignedSkillGroupIdList')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('UserState') is not None:
            self.user_state = m.get('UserState')
        if m.get('WorkMode') is not None:
            self.work_mode = m.get('WorkMode')
        return self


class CompleteAttendedTransferResponseBodyData(TeaModel):
    def __init__(self, call_context=None, context_id=None, user_context=None):
        self.call_context = call_context  # type: CompleteAttendedTransferResponseBodyDataCallContext
        self.context_id = context_id  # type: long
        self.user_context = user_context  # type: CompleteAttendedTransferResponseBodyDataUserContext

    def validate(self):
        if self.call_context:
            self.call_context.validate()
        if self.user_context:
            self.user_context.validate()

    def to_map(self):
        _map = super(CompleteAttendedTransferResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.call_context is not None:
            result['CallContext'] = self.call_context.to_map()
        if self.context_id is not None:
            result['ContextId'] = self.context_id
        if self.user_context is not None:
            result['UserContext'] = self.user_context.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CallContext') is not None:
            temp_model = CompleteAttendedTransferResponseBodyDataCallContext()
            self.call_context = temp_model.from_map(m['CallContext'])
        if m.get('ContextId') is not None:
            self.context_id = m.get('ContextId')
        if m.get('UserContext') is not None:
            temp_model = CompleteAttendedTransferResponseBodyDataUserContext()
            self.user_context = temp_model.from_map(m['UserContext'])
        return self


class CompleteAttendedTransferResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, params=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: CompleteAttendedTransferResponseBodyData
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.params = params  # type: list[str]
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(CompleteAttendedTransferResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.params is not None:
            result['Params'] = self.params
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = CompleteAttendedTransferResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Params') is not None:
            self.params = m.get('Params')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CompleteAttendedTransferResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: CompleteAttendedTransferResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CompleteAttendedTransferResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CompleteAttendedTransferResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateCampaignRequestCaseList(TeaModel):
    def __init__(self, custom_variables=None, phone_number=None, reference_id=None):
        self.custom_variables = custom_variables  # type: str
        self.phone_number = phone_number  # type: str
        self.reference_id = reference_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateCampaignRequestCaseList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.custom_variables is not None:
            result['CustomVariables'] = self.custom_variables
        if self.phone_number is not None:
            result['PhoneNumber'] = self.phone_number
        if self.reference_id is not None:
            result['ReferenceId'] = self.reference_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CustomVariables') is not None:
            self.custom_variables = m.get('CustomVariables')
        if m.get('PhoneNumber') is not None:
            self.phone_number = m.get('PhoneNumber')
        if m.get('ReferenceId') is not None:
            self.reference_id = m.get('ReferenceId')
        return self


class CreateCampaignRequest(TeaModel):
    def __init__(self, callable_time=None, case_file_key=None, case_list=None, contact_flow_id=None, end_time=None,
                 instance_id=None, max_attempt_count=None, min_attempt_interval=None, name=None, queue_id=None, simulation=None,
                 simulation_parameters=None, start_time=None, strategy_parameters=None, strategy_type=None):
        self.callable_time = callable_time  # type: str
        self.case_file_key = case_file_key  # type: str
        self.case_list = case_list  # type: list[CreateCampaignRequestCaseList]
        self.contact_flow_id = contact_flow_id  # type: str
        self.end_time = end_time  # type: str
        self.instance_id = instance_id  # type: str
        self.max_attempt_count = max_attempt_count  # type: long
        self.min_attempt_interval = min_attempt_interval  # type: long
        self.name = name  # type: str
        self.queue_id = queue_id  # type: str
        self.simulation = simulation  # type: bool
        self.simulation_parameters = simulation_parameters  # type: str
        self.start_time = start_time  # type: str
        self.strategy_parameters = strategy_parameters  # type: str
        self.strategy_type = strategy_type  # type: str

    def validate(self):
        if self.case_list:
            for k in self.case_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CreateCampaignRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.callable_time is not None:
            result['CallableTime'] = self.callable_time
        if self.case_file_key is not None:
            result['CaseFileKey'] = self.case_file_key
        result['CaseList'] = []
        if self.case_list is not None:
            for k in self.case_list:
                result['CaseList'].append(k.to_map() if k else None)
        if self.contact_flow_id is not None:
            result['ContactFlowId'] = self.contact_flow_id
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.max_attempt_count is not None:
            result['MaxAttemptCount'] = self.max_attempt_count
        if self.min_attempt_interval is not None:
            result['MinAttemptInterval'] = self.min_attempt_interval
        if self.name is not None:
            result['Name'] = self.name
        if self.queue_id is not None:
            result['QueueId'] = self.queue_id
        if self.simulation is not None:
            result['Simulation'] = self.simulation
        if self.simulation_parameters is not None:
            result['SimulationParameters'] = self.simulation_parameters
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.strategy_parameters is not None:
            result['StrategyParameters'] = self.strategy_parameters
        if self.strategy_type is not None:
            result['StrategyType'] = self.strategy_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CallableTime') is not None:
            self.callable_time = m.get('CallableTime')
        if m.get('CaseFileKey') is not None:
            self.case_file_key = m.get('CaseFileKey')
        self.case_list = []
        if m.get('CaseList') is not None:
            for k in m.get('CaseList'):
                temp_model = CreateCampaignRequestCaseList()
                self.case_list.append(temp_model.from_map(k))
        if m.get('ContactFlowId') is not None:
            self.contact_flow_id = m.get('ContactFlowId')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('MaxAttemptCount') is not None:
            self.max_attempt_count = m.get('MaxAttemptCount')
        if m.get('MinAttemptInterval') is not None:
            self.min_attempt_interval = m.get('MinAttemptInterval')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('QueueId') is not None:
            self.queue_id = m.get('QueueId')
        if m.get('Simulation') is not None:
            self.simulation = m.get('Simulation')
        if m.get('SimulationParameters') is not None:
            self.simulation_parameters = m.get('SimulationParameters')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('StrategyParameters') is not None:
            self.strategy_parameters = m.get('StrategyParameters')
        if m.get('StrategyType') is not None:
            self.strategy_type = m.get('StrategyType')
        return self


class CreateCampaignShrinkRequest(TeaModel):
    def __init__(self, callable_time=None, case_file_key=None, case_list_shrink=None, contact_flow_id=None,
                 end_time=None, instance_id=None, max_attempt_count=None, min_attempt_interval=None, name=None,
                 queue_id=None, simulation=None, simulation_parameters=None, start_time=None, strategy_parameters=None,
                 strategy_type=None):
        self.callable_time = callable_time  # type: str
        self.case_file_key = case_file_key  # type: str
        self.case_list_shrink = case_list_shrink  # type: str
        self.contact_flow_id = contact_flow_id  # type: str
        self.end_time = end_time  # type: str
        self.instance_id = instance_id  # type: str
        self.max_attempt_count = max_attempt_count  # type: long
        self.min_attempt_interval = min_attempt_interval  # type: long
        self.name = name  # type: str
        self.queue_id = queue_id  # type: str
        self.simulation = simulation  # type: bool
        self.simulation_parameters = simulation_parameters  # type: str
        self.start_time = start_time  # type: str
        self.strategy_parameters = strategy_parameters  # type: str
        self.strategy_type = strategy_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateCampaignShrinkRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.callable_time is not None:
            result['CallableTime'] = self.callable_time
        if self.case_file_key is not None:
            result['CaseFileKey'] = self.case_file_key
        if self.case_list_shrink is not None:
            result['CaseList'] = self.case_list_shrink
        if self.contact_flow_id is not None:
            result['ContactFlowId'] = self.contact_flow_id
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.max_attempt_count is not None:
            result['MaxAttemptCount'] = self.max_attempt_count
        if self.min_attempt_interval is not None:
            result['MinAttemptInterval'] = self.min_attempt_interval
        if self.name is not None:
            result['Name'] = self.name
        if self.queue_id is not None:
            result['QueueId'] = self.queue_id
        if self.simulation is not None:
            result['Simulation'] = self.simulation
        if self.simulation_parameters is not None:
            result['SimulationParameters'] = self.simulation_parameters
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.strategy_parameters is not None:
            result['StrategyParameters'] = self.strategy_parameters
        if self.strategy_type is not None:
            result['StrategyType'] = self.strategy_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CallableTime') is not None:
            self.callable_time = m.get('CallableTime')
        if m.get('CaseFileKey') is not None:
            self.case_file_key = m.get('CaseFileKey')
        if m.get('CaseList') is not None:
            self.case_list_shrink = m.get('CaseList')
        if m.get('ContactFlowId') is not None:
            self.contact_flow_id = m.get('ContactFlowId')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('MaxAttemptCount') is not None:
            self.max_attempt_count = m.get('MaxAttemptCount')
        if m.get('MinAttemptInterval') is not None:
            self.min_attempt_interval = m.get('MinAttemptInterval')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('QueueId') is not None:
            self.queue_id = m.get('QueueId')
        if m.get('Simulation') is not None:
            self.simulation = m.get('Simulation')
        if m.get('SimulationParameters') is not None:
            self.simulation_parameters = m.get('SimulationParameters')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('StrategyParameters') is not None:
            self.strategy_parameters = m.get('StrategyParameters')
        if m.get('StrategyType') is not None:
            self.strategy_type = m.get('StrategyType')
        return self


class CreateCampaignResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, request_id=None):
        # code
        self.code = code  # type: str
        # campaign id
        self.data = data  # type: str
        self.http_status_code = http_status_code  # type: long
        # message
        self.message = message  # type: str
        # Id of the request
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateCampaignResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateCampaignResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: CreateCampaignResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateCampaignResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateCampaignResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateInstanceRequest(TeaModel):
    def __init__(self, admin_ram_id_list=None, description=None, domain_name=None, name=None, number_list=None):
        self.admin_ram_id_list = admin_ram_id_list  # type: str
        self.description = description  # type: str
        self.domain_name = domain_name  # type: str
        self.name = name  # type: str
        self.number_list = number_list  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateInstanceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.admin_ram_id_list is not None:
            result['AdminRamIdList'] = self.admin_ram_id_list
        if self.description is not None:
            result['Description'] = self.description
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.name is not None:
            result['Name'] = self.name
        if self.number_list is not None:
            result['NumberList'] = self.number_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AdminRamIdList') is not None:
            self.admin_ram_id_list = m.get('AdminRamIdList')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('NumberList') is not None:
            self.number_list = m.get('NumberList')
        return self


class CreateInstanceResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, params=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: str
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.params = params  # type: list[str]
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateInstanceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.params is not None:
            result['Params'] = self.params
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Params') is not None:
            self.params = m.get('Params')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateInstanceResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: CreateInstanceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateInstanceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateSkillGroupRequest(TeaModel):
    def __init__(self, description=None, display_name=None, instance_id=None, name=None):
        self.description = description  # type: str
        self.display_name = display_name  # type: str
        self.instance_id = instance_id  # type: str
        self.name = name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateSkillGroupRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.display_name is not None:
            result['DisplayName'] = self.display_name
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DisplayName') is not None:
            self.display_name = m.get('DisplayName')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class CreateSkillGroupResponseBodyData(TeaModel):
    def __init__(self, description=None, instance_id=None, name=None, skill_group_id=None):
        self.description = description  # type: str
        self.instance_id = instance_id  # type: str
        self.name = name  # type: str
        self.skill_group_id = skill_group_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateSkillGroupResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.name is not None:
            result['Name'] = self.name
        if self.skill_group_id is not None:
            result['SkillGroupId'] = self.skill_group_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('SkillGroupId') is not None:
            self.skill_group_id = m.get('SkillGroupId')
        return self


class CreateSkillGroupResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: CreateSkillGroupResponseBodyData
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(CreateSkillGroupResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = CreateSkillGroupResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateSkillGroupResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: CreateSkillGroupResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateSkillGroupResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateSkillGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateUserRequest(TeaModel):
    def __init__(self, display_name=None, email=None, instance_id=None, login_name=None, mobile=None,
                 reset_password=None, role_id=None, skill_level_list=None, work_mode=None):
        self.display_name = display_name  # type: str
        self.email = email  # type: str
        self.instance_id = instance_id  # type: str
        self.login_name = login_name  # type: str
        self.mobile = mobile  # type: str
        self.reset_password = reset_password  # type: bool
        self.role_id = role_id  # type: str
        self.skill_level_list = skill_level_list  # type: str
        self.work_mode = work_mode  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateUserRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.display_name is not None:
            result['DisplayName'] = self.display_name
        if self.email is not None:
            result['Email'] = self.email
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.login_name is not None:
            result['LoginName'] = self.login_name
        if self.mobile is not None:
            result['Mobile'] = self.mobile
        if self.reset_password is not None:
            result['ResetPassword'] = self.reset_password
        if self.role_id is not None:
            result['RoleId'] = self.role_id
        if self.skill_level_list is not None:
            result['SkillLevelList'] = self.skill_level_list
        if self.work_mode is not None:
            result['WorkMode'] = self.work_mode
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DisplayName') is not None:
            self.display_name = m.get('DisplayName')
        if m.get('Email') is not None:
            self.email = m.get('Email')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('LoginName') is not None:
            self.login_name = m.get('LoginName')
        if m.get('Mobile') is not None:
            self.mobile = m.get('Mobile')
        if m.get('ResetPassword') is not None:
            self.reset_password = m.get('ResetPassword')
        if m.get('RoleId') is not None:
            self.role_id = m.get('RoleId')
        if m.get('SkillLevelList') is not None:
            self.skill_level_list = m.get('SkillLevelList')
        if m.get('WorkMode') is not None:
            self.work_mode = m.get('WorkMode')
        return self


class CreateUserResponseBodyData(TeaModel):
    def __init__(self, display_name=None, email=None, extension=None, login_name=None, mobile=None, user_id=None,
                 work_mode=None):
        self.display_name = display_name  # type: str
        self.email = email  # type: str
        self.extension = extension  # type: str
        self.login_name = login_name  # type: str
        self.mobile = mobile  # type: str
        self.user_id = user_id  # type: str
        self.work_mode = work_mode  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateUserResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.display_name is not None:
            result['DisplayName'] = self.display_name
        if self.email is not None:
            result['Email'] = self.email
        if self.extension is not None:
            result['Extension'] = self.extension
        if self.login_name is not None:
            result['LoginName'] = self.login_name
        if self.mobile is not None:
            result['Mobile'] = self.mobile
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.work_mode is not None:
            result['WorkMode'] = self.work_mode
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DisplayName') is not None:
            self.display_name = m.get('DisplayName')
        if m.get('Email') is not None:
            self.email = m.get('Email')
        if m.get('Extension') is not None:
            self.extension = m.get('Extension')
        if m.get('LoginName') is not None:
            self.login_name = m.get('LoginName')
        if m.get('Mobile') is not None:
            self.mobile = m.get('Mobile')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('WorkMode') is not None:
            self.work_mode = m.get('WorkMode')
        return self


class CreateUserResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, params=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: CreateUserResponseBodyData
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.params = params  # type: list[str]
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(CreateUserResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.params is not None:
            result['Params'] = self.params
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = CreateUserResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Params') is not None:
            self.params = m.get('Params')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateUserResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: CreateUserResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateUserResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateUserResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteSkillGroupRequest(TeaModel):
    def __init__(self, force=None, instance_id=None, skill_group_id=None):
        self.force = force  # type: bool
        self.instance_id = instance_id  # type: str
        self.skill_group_id = skill_group_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteSkillGroupRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.force is not None:
            result['Force'] = self.force
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.skill_group_id is not None:
            result['SkillGroupId'] = self.skill_group_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Force') is not None:
            self.force = m.get('Force')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('SkillGroupId') is not None:
            self.skill_group_id = m.get('SkillGroupId')
        return self


class DeleteSkillGroupResponseBody(TeaModel):
    def __init__(self, code=None, http_status_code=None, message=None, request_id=None):
        self.code = code  # type: str
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteSkillGroupResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteSkillGroupResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DeleteSkillGroupResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteSkillGroupResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteSkillGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetCallDetailRecordRequest(TeaModel):
    def __init__(self, contact_id=None, instance_id=None):
        self.contact_id = contact_id  # type: str
        self.instance_id = instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetCallDetailRecordRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.contact_id is not None:
            result['ContactId'] = self.contact_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ContactId') is not None:
            self.contact_id = m.get('ContactId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class GetCallDetailRecordResponseBodyDataAgentEventsEventSequence(TeaModel):
    def __init__(self, event=None, event_time=None):
        self.event = event  # type: str
        self.event_time = event_time  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetCallDetailRecordResponseBodyDataAgentEventsEventSequence, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.event is not None:
            result['Event'] = self.event
        if self.event_time is not None:
            result['EventTime'] = self.event_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Event') is not None:
            self.event = m.get('Event')
        if m.get('EventTime') is not None:
            self.event_time = m.get('EventTime')
        return self


class GetCallDetailRecordResponseBodyDataAgentEvents(TeaModel):
    def __init__(self, agent_id=None, agent_name=None, event_sequence=None, skill_group_id=None):
        self.agent_id = agent_id  # type: str
        self.agent_name = agent_name  # type: str
        self.event_sequence = event_sequence  # type: list[GetCallDetailRecordResponseBodyDataAgentEventsEventSequence]
        self.skill_group_id = skill_group_id  # type: str

    def validate(self):
        if self.event_sequence:
            for k in self.event_sequence:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetCallDetailRecordResponseBodyDataAgentEvents, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_id is not None:
            result['AgentId'] = self.agent_id
        if self.agent_name is not None:
            result['AgentName'] = self.agent_name
        result['EventSequence'] = []
        if self.event_sequence is not None:
            for k in self.event_sequence:
                result['EventSequence'].append(k.to_map() if k else None)
        if self.skill_group_id is not None:
            result['SkillGroupId'] = self.skill_group_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AgentId') is not None:
            self.agent_id = m.get('AgentId')
        if m.get('AgentName') is not None:
            self.agent_name = m.get('AgentName')
        self.event_sequence = []
        if m.get('EventSequence') is not None:
            for k in m.get('EventSequence'):
                temp_model = GetCallDetailRecordResponseBodyDataAgentEventsEventSequence()
                self.event_sequence.append(temp_model.from_map(k))
        if m.get('SkillGroupId') is not None:
            self.skill_group_id = m.get('SkillGroupId')
        return self


class GetCallDetailRecordResponseBodyDataCustomerEventsEventSequence(TeaModel):
    def __init__(self, event=None, event_time=None):
        self.event = event  # type: str
        self.event_time = event_time  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetCallDetailRecordResponseBodyDataCustomerEventsEventSequence, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.event is not None:
            result['Event'] = self.event
        if self.event_time is not None:
            result['EventTime'] = self.event_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Event') is not None:
            self.event = m.get('Event')
        if m.get('EventTime') is not None:
            self.event_time = m.get('EventTime')
        return self


class GetCallDetailRecordResponseBodyDataCustomerEvents(TeaModel):
    def __init__(self, customer_id=None, event_sequence=None):
        self.customer_id = customer_id  # type: str
        self.event_sequence = event_sequence  # type: list[GetCallDetailRecordResponseBodyDataCustomerEventsEventSequence]

    def validate(self):
        if self.event_sequence:
            for k in self.event_sequence:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetCallDetailRecordResponseBodyDataCustomerEvents, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.customer_id is not None:
            result['CustomerId'] = self.customer_id
        result['EventSequence'] = []
        if self.event_sequence is not None:
            for k in self.event_sequence:
                result['EventSequence'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CustomerId') is not None:
            self.customer_id = m.get('CustomerId')
        self.event_sequence = []
        if m.get('EventSequence') is not None:
            for k in m.get('EventSequence'):
                temp_model = GetCallDetailRecordResponseBodyDataCustomerEventsEventSequence()
                self.event_sequence.append(temp_model.from_map(k))
        return self


class GetCallDetailRecordResponseBodyDataIvrEventsEventSequence(TeaModel):
    def __init__(self, event=None, event_time=None):
        self.event = event  # type: str
        self.event_time = event_time  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetCallDetailRecordResponseBodyDataIvrEventsEventSequence, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.event is not None:
            result['Event'] = self.event
        if self.event_time is not None:
            result['EventTime'] = self.event_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Event') is not None:
            self.event = m.get('Event')
        if m.get('EventTime') is not None:
            self.event_time = m.get('EventTime')
        return self


class GetCallDetailRecordResponseBodyDataIvrEvents(TeaModel):
    def __init__(self, event_sequence=None, flow_id=None):
        self.event_sequence = event_sequence  # type: list[GetCallDetailRecordResponseBodyDataIvrEventsEventSequence]
        self.flow_id = flow_id  # type: str

    def validate(self):
        if self.event_sequence:
            for k in self.event_sequence:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetCallDetailRecordResponseBodyDataIvrEvents, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['EventSequence'] = []
        if self.event_sequence is not None:
            for k in self.event_sequence:
                result['EventSequence'].append(k.to_map() if k else None)
        if self.flow_id is not None:
            result['FlowId'] = self.flow_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.event_sequence = []
        if m.get('EventSequence') is not None:
            for k in m.get('EventSequence'):
                temp_model = GetCallDetailRecordResponseBodyDataIvrEventsEventSequence()
                self.event_sequence.append(temp_model.from_map(k))
        if m.get('FlowId') is not None:
            self.flow_id = m.get('FlowId')
        return self


class GetCallDetailRecordResponseBodyDataQueueEventsEventSequence(TeaModel):
    def __init__(self, event=None, event_time=None):
        self.event = event  # type: str
        self.event_time = event_time  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetCallDetailRecordResponseBodyDataQueueEventsEventSequence, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.event is not None:
            result['Event'] = self.event
        if self.event_time is not None:
            result['EventTime'] = self.event_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Event') is not None:
            self.event = m.get('Event')
        if m.get('EventTime') is not None:
            self.event_time = m.get('EventTime')
        return self


class GetCallDetailRecordResponseBodyDataQueueEvents(TeaModel):
    def __init__(self, event_sequence=None, flow_id=None, queue_id=None, queue_name=None, queue_type=None):
        self.event_sequence = event_sequence  # type: list[GetCallDetailRecordResponseBodyDataQueueEventsEventSequence]
        self.flow_id = flow_id  # type: str
        self.queue_id = queue_id  # type: str
        self.queue_name = queue_name  # type: str
        self.queue_type = queue_type  # type: int

    def validate(self):
        if self.event_sequence:
            for k in self.event_sequence:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetCallDetailRecordResponseBodyDataQueueEvents, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['EventSequence'] = []
        if self.event_sequence is not None:
            for k in self.event_sequence:
                result['EventSequence'].append(k.to_map() if k else None)
        if self.flow_id is not None:
            result['FlowId'] = self.flow_id
        if self.queue_id is not None:
            result['QueueId'] = self.queue_id
        if self.queue_name is not None:
            result['QueueName'] = self.queue_name
        if self.queue_type is not None:
            result['QueueType'] = self.queue_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.event_sequence = []
        if m.get('EventSequence') is not None:
            for k in m.get('EventSequence'):
                temp_model = GetCallDetailRecordResponseBodyDataQueueEventsEventSequence()
                self.event_sequence.append(temp_model.from_map(k))
        if m.get('FlowId') is not None:
            self.flow_id = m.get('FlowId')
        if m.get('QueueId') is not None:
            self.queue_id = m.get('QueueId')
        if m.get('QueueName') is not None:
            self.queue_name = m.get('QueueName')
        if m.get('QueueType') is not None:
            self.queue_type = m.get('QueueType')
        return self


class GetCallDetailRecordResponseBodyData(TeaModel):
    def __init__(self, agent_events=None, agent_ids=None, agent_names=None, call_duration=None, called_number=None,
                 callee_location=None, caller_location=None, calling_number=None, contact_disposition=None, contact_id=None,
                 contact_type=None, customer_events=None, early_media_state=None, established_time=None, instance_id=None,
                 ivr_events=None, queue_events=None, recording_ready=None, release_initiator=None, release_time=None,
                 satisfaction=None, satisfaction_survey_channel=None, satisfaction_survey_offered=None, skill_group_ids=None,
                 skill_group_names=None, start_time=None):
        self.agent_events = agent_events  # type: list[GetCallDetailRecordResponseBodyDataAgentEvents]
        self.agent_ids = agent_ids  # type: str
        self.agent_names = agent_names  # type: str
        self.call_duration = call_duration  # type: long
        self.called_number = called_number  # type: str
        self.callee_location = callee_location  # type: str
        self.caller_location = caller_location  # type: str
        self.calling_number = calling_number  # type: str
        self.contact_disposition = contact_disposition  # type: str
        self.contact_id = contact_id  # type: str
        self.contact_type = contact_type  # type: str
        self.customer_events = customer_events  # type: list[GetCallDetailRecordResponseBodyDataCustomerEvents]
        self.early_media_state = early_media_state  # type: str
        self.established_time = established_time  # type: long
        self.instance_id = instance_id  # type: str
        self.ivr_events = ivr_events  # type: list[GetCallDetailRecordResponseBodyDataIvrEvents]
        self.queue_events = queue_events  # type: list[GetCallDetailRecordResponseBodyDataQueueEvents]
        self.recording_ready = recording_ready  # type: bool
        self.release_initiator = release_initiator  # type: str
        self.release_time = release_time  # type: long
        self.satisfaction = satisfaction  # type: int
        self.satisfaction_survey_channel = satisfaction_survey_channel  # type: str
        self.satisfaction_survey_offered = satisfaction_survey_offered  # type: bool
        self.skill_group_ids = skill_group_ids  # type: str
        self.skill_group_names = skill_group_names  # type: str
        self.start_time = start_time  # type: long

    def validate(self):
        if self.agent_events:
            for k in self.agent_events:
                if k:
                    k.validate()
        if self.customer_events:
            for k in self.customer_events:
                if k:
                    k.validate()
        if self.ivr_events:
            for k in self.ivr_events:
                if k:
                    k.validate()
        if self.queue_events:
            for k in self.queue_events:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetCallDetailRecordResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AgentEvents'] = []
        if self.agent_events is not None:
            for k in self.agent_events:
                result['AgentEvents'].append(k.to_map() if k else None)
        if self.agent_ids is not None:
            result['AgentIds'] = self.agent_ids
        if self.agent_names is not None:
            result['AgentNames'] = self.agent_names
        if self.call_duration is not None:
            result['CallDuration'] = self.call_duration
        if self.called_number is not None:
            result['CalledNumber'] = self.called_number
        if self.callee_location is not None:
            result['CalleeLocation'] = self.callee_location
        if self.caller_location is not None:
            result['CallerLocation'] = self.caller_location
        if self.calling_number is not None:
            result['CallingNumber'] = self.calling_number
        if self.contact_disposition is not None:
            result['ContactDisposition'] = self.contact_disposition
        if self.contact_id is not None:
            result['ContactId'] = self.contact_id
        if self.contact_type is not None:
            result['ContactType'] = self.contact_type
        result['CustomerEvents'] = []
        if self.customer_events is not None:
            for k in self.customer_events:
                result['CustomerEvents'].append(k.to_map() if k else None)
        if self.early_media_state is not None:
            result['EarlyMediaState'] = self.early_media_state
        if self.established_time is not None:
            result['EstablishedTime'] = self.established_time
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        result['IvrEvents'] = []
        if self.ivr_events is not None:
            for k in self.ivr_events:
                result['IvrEvents'].append(k.to_map() if k else None)
        result['QueueEvents'] = []
        if self.queue_events is not None:
            for k in self.queue_events:
                result['QueueEvents'].append(k.to_map() if k else None)
        if self.recording_ready is not None:
            result['RecordingReady'] = self.recording_ready
        if self.release_initiator is not None:
            result['ReleaseInitiator'] = self.release_initiator
        if self.release_time is not None:
            result['ReleaseTime'] = self.release_time
        if self.satisfaction is not None:
            result['Satisfaction'] = self.satisfaction
        if self.satisfaction_survey_channel is not None:
            result['SatisfactionSurveyChannel'] = self.satisfaction_survey_channel
        if self.satisfaction_survey_offered is not None:
            result['SatisfactionSurveyOffered'] = self.satisfaction_survey_offered
        if self.skill_group_ids is not None:
            result['SkillGroupIds'] = self.skill_group_ids
        if self.skill_group_names is not None:
            result['SkillGroupNames'] = self.skill_group_names
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.agent_events = []
        if m.get('AgentEvents') is not None:
            for k in m.get('AgentEvents'):
                temp_model = GetCallDetailRecordResponseBodyDataAgentEvents()
                self.agent_events.append(temp_model.from_map(k))
        if m.get('AgentIds') is not None:
            self.agent_ids = m.get('AgentIds')
        if m.get('AgentNames') is not None:
            self.agent_names = m.get('AgentNames')
        if m.get('CallDuration') is not None:
            self.call_duration = m.get('CallDuration')
        if m.get('CalledNumber') is not None:
            self.called_number = m.get('CalledNumber')
        if m.get('CalleeLocation') is not None:
            self.callee_location = m.get('CalleeLocation')
        if m.get('CallerLocation') is not None:
            self.caller_location = m.get('CallerLocation')
        if m.get('CallingNumber') is not None:
            self.calling_number = m.get('CallingNumber')
        if m.get('ContactDisposition') is not None:
            self.contact_disposition = m.get('ContactDisposition')
        if m.get('ContactId') is not None:
            self.contact_id = m.get('ContactId')
        if m.get('ContactType') is not None:
            self.contact_type = m.get('ContactType')
        self.customer_events = []
        if m.get('CustomerEvents') is not None:
            for k in m.get('CustomerEvents'):
                temp_model = GetCallDetailRecordResponseBodyDataCustomerEvents()
                self.customer_events.append(temp_model.from_map(k))
        if m.get('EarlyMediaState') is not None:
            self.early_media_state = m.get('EarlyMediaState')
        if m.get('EstablishedTime') is not None:
            self.established_time = m.get('EstablishedTime')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        self.ivr_events = []
        if m.get('IvrEvents') is not None:
            for k in m.get('IvrEvents'):
                temp_model = GetCallDetailRecordResponseBodyDataIvrEvents()
                self.ivr_events.append(temp_model.from_map(k))
        self.queue_events = []
        if m.get('QueueEvents') is not None:
            for k in m.get('QueueEvents'):
                temp_model = GetCallDetailRecordResponseBodyDataQueueEvents()
                self.queue_events.append(temp_model.from_map(k))
        if m.get('RecordingReady') is not None:
            self.recording_ready = m.get('RecordingReady')
        if m.get('ReleaseInitiator') is not None:
            self.release_initiator = m.get('ReleaseInitiator')
        if m.get('ReleaseTime') is not None:
            self.release_time = m.get('ReleaseTime')
        if m.get('Satisfaction') is not None:
            self.satisfaction = m.get('Satisfaction')
        if m.get('SatisfactionSurveyChannel') is not None:
            self.satisfaction_survey_channel = m.get('SatisfactionSurveyChannel')
        if m.get('SatisfactionSurveyOffered') is not None:
            self.satisfaction_survey_offered = m.get('SatisfactionSurveyOffered')
        if m.get('SkillGroupIds') is not None:
            self.skill_group_ids = m.get('SkillGroupIds')
        if m.get('SkillGroupNames') is not None:
            self.skill_group_names = m.get('SkillGroupNames')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class GetCallDetailRecordResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: GetCallDetailRecordResponseBodyData
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetCallDetailRecordResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetCallDetailRecordResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetCallDetailRecordResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: GetCallDetailRecordResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetCallDetailRecordResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetCallDetailRecordResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetCampaignRequest(TeaModel):
    def __init__(self, campaign_id=None, instance_id=None):
        self.campaign_id = campaign_id  # type: str
        self.instance_id = instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetCampaignRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.campaign_id is not None:
            result['CampaignId'] = self.campaign_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CampaignId') is not None:
            self.campaign_id = m.get('CampaignId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class GetCampaignResponseBodyData(TeaModel):
    def __init__(self, actual_end_time=None, actual_start_time=None, campaign_id=None, cases_aborted=None,
                 cases_connected=None, cases_uncompleted=None, max_attempt_count=None, min_attempt_interval=None, name=None,
                 planed_end_time=None, planed_start_time=None, queue_id=None, queue_name=None, simulation=None,
                 simulation_parameters=None, state=None, strategy_parameters=None, strategy_type=None, total_cases=None):
        self.actual_end_time = actual_end_time  # type: long
        self.actual_start_time = actual_start_time  # type: long
        # id
        self.campaign_id = campaign_id  # type: str
        self.cases_aborted = cases_aborted  # type: long
        self.cases_connected = cases_connected  # type: long
        self.cases_uncompleted = cases_uncompleted  # type: long
        self.max_attempt_count = max_attempt_count  # type: long
        self.min_attempt_interval = min_attempt_interval  # type: long
        self.name = name  # type: str
        self.planed_end_time = planed_end_time  # type: long
        self.planed_start_time = planed_start_time  # type: long
        self.queue_id = queue_id  # type: str
        self.queue_name = queue_name  # type: str
        self.simulation = simulation  # type: bool
        self.simulation_parameters = simulation_parameters  # type: str
        self.state = state  # type: str
        self.strategy_parameters = strategy_parameters  # type: str
        self.strategy_type = strategy_type  # type: str
        self.total_cases = total_cases  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetCampaignResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.actual_end_time is not None:
            result['ActualEndTime'] = self.actual_end_time
        if self.actual_start_time is not None:
            result['ActualStartTime'] = self.actual_start_time
        if self.campaign_id is not None:
            result['CampaignId'] = self.campaign_id
        if self.cases_aborted is not None:
            result['CasesAborted'] = self.cases_aborted
        if self.cases_connected is not None:
            result['CasesConnected'] = self.cases_connected
        if self.cases_uncompleted is not None:
            result['CasesUncompleted'] = self.cases_uncompleted
        if self.max_attempt_count is not None:
            result['MaxAttemptCount'] = self.max_attempt_count
        if self.min_attempt_interval is not None:
            result['MinAttemptInterval'] = self.min_attempt_interval
        if self.name is not None:
            result['Name'] = self.name
        if self.planed_end_time is not None:
            result['PlanedEndTime'] = self.planed_end_time
        if self.planed_start_time is not None:
            result['PlanedStartTime'] = self.planed_start_time
        if self.queue_id is not None:
            result['QueueId'] = self.queue_id
        if self.queue_name is not None:
            result['QueueName'] = self.queue_name
        if self.simulation is not None:
            result['Simulation'] = self.simulation
        if self.simulation_parameters is not None:
            result['SimulationParameters'] = self.simulation_parameters
        if self.state is not None:
            result['State'] = self.state
        if self.strategy_parameters is not None:
            result['StrategyParameters'] = self.strategy_parameters
        if self.strategy_type is not None:
            result['StrategyType'] = self.strategy_type
        if self.total_cases is not None:
            result['TotalCases'] = self.total_cases
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ActualEndTime') is not None:
            self.actual_end_time = m.get('ActualEndTime')
        if m.get('ActualStartTime') is not None:
            self.actual_start_time = m.get('ActualStartTime')
        if m.get('CampaignId') is not None:
            self.campaign_id = m.get('CampaignId')
        if m.get('CasesAborted') is not None:
            self.cases_aborted = m.get('CasesAborted')
        if m.get('CasesConnected') is not None:
            self.cases_connected = m.get('CasesConnected')
        if m.get('CasesUncompleted') is not None:
            self.cases_uncompleted = m.get('CasesUncompleted')
        if m.get('MaxAttemptCount') is not None:
            self.max_attempt_count = m.get('MaxAttemptCount')
        if m.get('MinAttemptInterval') is not None:
            self.min_attempt_interval = m.get('MinAttemptInterval')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PlanedEndTime') is not None:
            self.planed_end_time = m.get('PlanedEndTime')
        if m.get('PlanedStartTime') is not None:
            self.planed_start_time = m.get('PlanedStartTime')
        if m.get('QueueId') is not None:
            self.queue_id = m.get('QueueId')
        if m.get('QueueName') is not None:
            self.queue_name = m.get('QueueName')
        if m.get('Simulation') is not None:
            self.simulation = m.get('Simulation')
        if m.get('SimulationParameters') is not None:
            self.simulation_parameters = m.get('SimulationParameters')
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('StrategyParameters') is not None:
            self.strategy_parameters = m.get('StrategyParameters')
        if m.get('StrategyType') is not None:
            self.strategy_type = m.get('StrategyType')
        if m.get('TotalCases') is not None:
            self.total_cases = m.get('TotalCases')
        return self


class GetCampaignResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: GetCampaignResponseBodyData
        self.http_status_code = http_status_code  # type: long
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetCampaignResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetCampaignResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetCampaignResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: GetCampaignResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetCampaignResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetCampaignResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetCaseFileUploadUrlRequest(TeaModel):
    def __init__(self, file_name=None, instance_id=None):
        self.file_name = file_name  # type: str
        self.instance_id = instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetCaseFileUploadUrlRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.file_name is not None:
            result['FileName'] = self.file_name
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class GetCaseFileUploadUrlResponseBodyData(TeaModel):
    def __init__(self, case_file_key=None, url=None):
        self.case_file_key = case_file_key  # type: str
        self.url = url  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetCaseFileUploadUrlResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.case_file_key is not None:
            result['CaseFileKey'] = self.case_file_key
        if self.url is not None:
            result['Url'] = self.url
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CaseFileKey') is not None:
            self.case_file_key = m.get('CaseFileKey')
        if m.get('Url') is not None:
            self.url = m.get('Url')
        return self


class GetCaseFileUploadUrlResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: GetCaseFileUploadUrlResponseBodyData
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetCaseFileUploadUrlResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetCaseFileUploadUrlResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetCaseFileUploadUrlResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: GetCaseFileUploadUrlResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetCaseFileUploadUrlResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetCaseFileUploadUrlResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetHistoricalCallerReportRequest(TeaModel):
    def __init__(self, calling_number=None, instance_id=None, start_time=None, stop_time=None):
        self.calling_number = calling_number  # type: str
        self.instance_id = instance_id  # type: str
        self.start_time = start_time  # type: long
        self.stop_time = stop_time  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetHistoricalCallerReportRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.calling_number is not None:
            result['CallingNumber'] = self.calling_number
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.stop_time is not None:
            result['StopTime'] = self.stop_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CallingNumber') is not None:
            self.calling_number = m.get('CallingNumber')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('StopTime') is not None:
            self.stop_time = m.get('StopTime')
        return self


class GetHistoricalCallerReportResponseBodyData(TeaModel):
    def __init__(self, last_calling_time=None, total_calls=None):
        self.last_calling_time = last_calling_time  # type: long
        self.total_calls = total_calls  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetHistoricalCallerReportResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.last_calling_time is not None:
            result['LastCallingTime'] = self.last_calling_time
        if self.total_calls is not None:
            result['TotalCalls'] = self.total_calls
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('LastCallingTime') is not None:
            self.last_calling_time = m.get('LastCallingTime')
        if m.get('TotalCalls') is not None:
            self.total_calls = m.get('TotalCalls')
        return self


class GetHistoricalCallerReportResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: GetHistoricalCallerReportResponseBodyData
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetHistoricalCallerReportResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetHistoricalCallerReportResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetHistoricalCallerReportResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: GetHistoricalCallerReportResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetHistoricalCallerReportResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetHistoricalCallerReportResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetHistoricalInstanceReportRequest(TeaModel):
    def __init__(self, end_time=None, instance_id=None, start_time=None):
        self.end_time = end_time  # type: long
        self.instance_id = instance_id  # type: str
        self.start_time = start_time  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetHistoricalInstanceReportRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class GetHistoricalInstanceReportResponseBodyDataInbound(TeaModel):
    def __init__(self, abandon_rate=None, average_abandon_time=None, average_abandoned_in_ivrtime=None,
                 average_abandoned_in_queue_time=None, average_abandoned_in_ring_time=None, average_hold_time=None, average_ring_time=None,
                 average_talk_time=None, average_wait_time=None, average_work_time=None, calls_abandoned=None,
                 calls_abandoned_in_ivr=None, calls_abandoned_in_queue=None, calls_abandoned_in_ring=None,
                 calls_abandoned_in_voice_navigator=None, calls_attended_transferred=None, calls_blind_transferred=None,
                 calls_forward_to_outside_number=None, calls_handled=None, calls_hold=None, calls_ivrexception=None, calls_offered=None,
                 calls_queued=None, calls_queuing_failed=None, calls_queuing_overflow=None, calls_queuing_timeout=None,
                 calls_ringed=None, calls_voicemail=None, handle_rate=None, max_abandon_time=None,
                 max_abandoned_in_ivrtime=None, max_abandoned_in_queue_time=None, max_abandoned_in_ring_time=None, max_hold_time=None,
                 max_ring_time=None, max_talk_time=None, max_wait_time=None, max_work_time=None, satisfaction_index=None,
                 satisfaction_rate=None, satisfaction_surveys_offered=None, satisfaction_surveys_responded=None,
                 service_level_20=None, total_abandon_time=None, total_abandoned_in_ivrtime=None,
                 total_abandoned_in_queue_time=None, total_abandoned_in_ring_time=None, total_hold_time=None, total_ring_time=None,
                 total_talk_time=None, total_wait_time=None, total_work_time=None):
        self.abandon_rate = abandon_rate  # type: float
        self.average_abandon_time = average_abandon_time  # type: float
        self.average_abandoned_in_ivrtime = average_abandoned_in_ivrtime  # type: float
        self.average_abandoned_in_queue_time = average_abandoned_in_queue_time  # type: float
        self.average_abandoned_in_ring_time = average_abandoned_in_ring_time  # type: float
        self.average_hold_time = average_hold_time  # type: float
        self.average_ring_time = average_ring_time  # type: float
        self.average_talk_time = average_talk_time  # type: float
        self.average_wait_time = average_wait_time  # type: float
        self.average_work_time = average_work_time  # type: float
        self.calls_abandoned = calls_abandoned  # type: long
        self.calls_abandoned_in_ivr = calls_abandoned_in_ivr  # type: long
        self.calls_abandoned_in_queue = calls_abandoned_in_queue  # type: long
        self.calls_abandoned_in_ring = calls_abandoned_in_ring  # type: long
        self.calls_abandoned_in_voice_navigator = calls_abandoned_in_voice_navigator  # type: long
        self.calls_attended_transferred = calls_attended_transferred  # type: long
        self.calls_blind_transferred = calls_blind_transferred  # type: long
        self.calls_forward_to_outside_number = calls_forward_to_outside_number  # type: long
        self.calls_handled = calls_handled  # type: long
        self.calls_hold = calls_hold  # type: long
        self.calls_ivrexception = calls_ivrexception  # type: long
        self.calls_offered = calls_offered  # type: long
        self.calls_queued = calls_queued  # type: long
        self.calls_queuing_failed = calls_queuing_failed  # type: long
        self.calls_queuing_overflow = calls_queuing_overflow  # type: long
        self.calls_queuing_timeout = calls_queuing_timeout  # type: long
        self.calls_ringed = calls_ringed  # type: long
        self.calls_voicemail = calls_voicemail  # type: long
        self.handle_rate = handle_rate  # type: float
        self.max_abandon_time = max_abandon_time  # type: long
        self.max_abandoned_in_ivrtime = max_abandoned_in_ivrtime  # type: long
        self.max_abandoned_in_queue_time = max_abandoned_in_queue_time  # type: long
        self.max_abandoned_in_ring_time = max_abandoned_in_ring_time  # type: long
        self.max_hold_time = max_hold_time  # type: long
        self.max_ring_time = max_ring_time  # type: long
        self.max_talk_time = max_talk_time  # type: long
        self.max_wait_time = max_wait_time  # type: long
        self.max_work_time = max_work_time  # type: long
        self.satisfaction_index = satisfaction_index  # type: float
        self.satisfaction_rate = satisfaction_rate  # type: float
        self.satisfaction_surveys_offered = satisfaction_surveys_offered  # type: long
        self.satisfaction_surveys_responded = satisfaction_surveys_responded  # type: long
        self.service_level_20 = service_level_20  # type: float
        self.total_abandon_time = total_abandon_time  # type: long
        self.total_abandoned_in_ivrtime = total_abandoned_in_ivrtime  # type: long
        self.total_abandoned_in_queue_time = total_abandoned_in_queue_time  # type: long
        self.total_abandoned_in_ring_time = total_abandoned_in_ring_time  # type: long
        self.total_hold_time = total_hold_time  # type: long
        self.total_ring_time = total_ring_time  # type: long
        self.total_talk_time = total_talk_time  # type: long
        self.total_wait_time = total_wait_time  # type: long
        self.total_work_time = total_work_time  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetHistoricalInstanceReportResponseBodyDataInbound, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.abandon_rate is not None:
            result['AbandonRate'] = self.abandon_rate
        if self.average_abandon_time is not None:
            result['AverageAbandonTime'] = self.average_abandon_time
        if self.average_abandoned_in_ivrtime is not None:
            result['AverageAbandonedInIVRTime'] = self.average_abandoned_in_ivrtime
        if self.average_abandoned_in_queue_time is not None:
            result['AverageAbandonedInQueueTime'] = self.average_abandoned_in_queue_time
        if self.average_abandoned_in_ring_time is not None:
            result['AverageAbandonedInRingTime'] = self.average_abandoned_in_ring_time
        if self.average_hold_time is not None:
            result['AverageHoldTime'] = self.average_hold_time
        if self.average_ring_time is not None:
            result['AverageRingTime'] = self.average_ring_time
        if self.average_talk_time is not None:
            result['AverageTalkTime'] = self.average_talk_time
        if self.average_wait_time is not None:
            result['AverageWaitTime'] = self.average_wait_time
        if self.average_work_time is not None:
            result['AverageWorkTime'] = self.average_work_time
        if self.calls_abandoned is not None:
            result['CallsAbandoned'] = self.calls_abandoned
        if self.calls_abandoned_in_ivr is not None:
            result['CallsAbandonedInIVR'] = self.calls_abandoned_in_ivr
        if self.calls_abandoned_in_queue is not None:
            result['CallsAbandonedInQueue'] = self.calls_abandoned_in_queue
        if self.calls_abandoned_in_ring is not None:
            result['CallsAbandonedInRing'] = self.calls_abandoned_in_ring
        if self.calls_abandoned_in_voice_navigator is not None:
            result['CallsAbandonedInVoiceNavigator'] = self.calls_abandoned_in_voice_navigator
        if self.calls_attended_transferred is not None:
            result['CallsAttendedTransferred'] = self.calls_attended_transferred
        if self.calls_blind_transferred is not None:
            result['CallsBlindTransferred'] = self.calls_blind_transferred
        if self.calls_forward_to_outside_number is not None:
            result['CallsForwardToOutsideNumber'] = self.calls_forward_to_outside_number
        if self.calls_handled is not None:
            result['CallsHandled'] = self.calls_handled
        if self.calls_hold is not None:
            result['CallsHold'] = self.calls_hold
        if self.calls_ivrexception is not None:
            result['CallsIVRException'] = self.calls_ivrexception
        if self.calls_offered is not None:
            result['CallsOffered'] = self.calls_offered
        if self.calls_queued is not None:
            result['CallsQueued'] = self.calls_queued
        if self.calls_queuing_failed is not None:
            result['CallsQueuingFailed'] = self.calls_queuing_failed
        if self.calls_queuing_overflow is not None:
            result['CallsQueuingOverflow'] = self.calls_queuing_overflow
        if self.calls_queuing_timeout is not None:
            result['CallsQueuingTimeout'] = self.calls_queuing_timeout
        if self.calls_ringed is not None:
            result['CallsRinged'] = self.calls_ringed
        if self.calls_voicemail is not None:
            result['CallsVoicemail'] = self.calls_voicemail
        if self.handle_rate is not None:
            result['HandleRate'] = self.handle_rate
        if self.max_abandon_time is not None:
            result['MaxAbandonTime'] = self.max_abandon_time
        if self.max_abandoned_in_ivrtime is not None:
            result['MaxAbandonedInIVRTime'] = self.max_abandoned_in_ivrtime
        if self.max_abandoned_in_queue_time is not None:
            result['MaxAbandonedInQueueTime'] = self.max_abandoned_in_queue_time
        if self.max_abandoned_in_ring_time is not None:
            result['MaxAbandonedInRingTime'] = self.max_abandoned_in_ring_time
        if self.max_hold_time is not None:
            result['MaxHoldTime'] = self.max_hold_time
        if self.max_ring_time is not None:
            result['MaxRingTime'] = self.max_ring_time
        if self.max_talk_time is not None:
            result['MaxTalkTime'] = self.max_talk_time
        if self.max_wait_time is not None:
            result['MaxWaitTime'] = self.max_wait_time
        if self.max_work_time is not None:
            result['MaxWorkTime'] = self.max_work_time
        if self.satisfaction_index is not None:
            result['SatisfactionIndex'] = self.satisfaction_index
        if self.satisfaction_rate is not None:
            result['SatisfactionRate'] = self.satisfaction_rate
        if self.satisfaction_surveys_offered is not None:
            result['SatisfactionSurveysOffered'] = self.satisfaction_surveys_offered
        if self.satisfaction_surveys_responded is not None:
            result['SatisfactionSurveysResponded'] = self.satisfaction_surveys_responded
        if self.service_level_20 is not None:
            result['ServiceLevel20'] = self.service_level_20
        if self.total_abandon_time is not None:
            result['TotalAbandonTime'] = self.total_abandon_time
        if self.total_abandoned_in_ivrtime is not None:
            result['TotalAbandonedInIVRTime'] = self.total_abandoned_in_ivrtime
        if self.total_abandoned_in_queue_time is not None:
            result['TotalAbandonedInQueueTime'] = self.total_abandoned_in_queue_time
        if self.total_abandoned_in_ring_time is not None:
            result['TotalAbandonedInRingTime'] = self.total_abandoned_in_ring_time
        if self.total_hold_time is not None:
            result['TotalHoldTime'] = self.total_hold_time
        if self.total_ring_time is not None:
            result['TotalRingTime'] = self.total_ring_time
        if self.total_talk_time is not None:
            result['TotalTalkTime'] = self.total_talk_time
        if self.total_wait_time is not None:
            result['TotalWaitTime'] = self.total_wait_time
        if self.total_work_time is not None:
            result['TotalWorkTime'] = self.total_work_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AbandonRate') is not None:
            self.abandon_rate = m.get('AbandonRate')
        if m.get('AverageAbandonTime') is not None:
            self.average_abandon_time = m.get('AverageAbandonTime')
        if m.get('AverageAbandonedInIVRTime') is not None:
            self.average_abandoned_in_ivrtime = m.get('AverageAbandonedInIVRTime')
        if m.get('AverageAbandonedInQueueTime') is not None:
            self.average_abandoned_in_queue_time = m.get('AverageAbandonedInQueueTime')
        if m.get('AverageAbandonedInRingTime') is not None:
            self.average_abandoned_in_ring_time = m.get('AverageAbandonedInRingTime')
        if m.get('AverageHoldTime') is not None:
            self.average_hold_time = m.get('AverageHoldTime')
        if m.get('AverageRingTime') is not None:
            self.average_ring_time = m.get('AverageRingTime')
        if m.get('AverageTalkTime') is not None:
            self.average_talk_time = m.get('AverageTalkTime')
        if m.get('AverageWaitTime') is not None:
            self.average_wait_time = m.get('AverageWaitTime')
        if m.get('AverageWorkTime') is not None:
            self.average_work_time = m.get('AverageWorkTime')
        if m.get('CallsAbandoned') is not None:
            self.calls_abandoned = m.get('CallsAbandoned')
        if m.get('CallsAbandonedInIVR') is not None:
            self.calls_abandoned_in_ivr = m.get('CallsAbandonedInIVR')
        if m.get('CallsAbandonedInQueue') is not None:
            self.calls_abandoned_in_queue = m.get('CallsAbandonedInQueue')
        if m.get('CallsAbandonedInRing') is not None:
            self.calls_abandoned_in_ring = m.get('CallsAbandonedInRing')
        if m.get('CallsAbandonedInVoiceNavigator') is not None:
            self.calls_abandoned_in_voice_navigator = m.get('CallsAbandonedInVoiceNavigator')
        if m.get('CallsAttendedTransferred') is not None:
            self.calls_attended_transferred = m.get('CallsAttendedTransferred')
        if m.get('CallsBlindTransferred') is not None:
            self.calls_blind_transferred = m.get('CallsBlindTransferred')
        if m.get('CallsForwardToOutsideNumber') is not None:
            self.calls_forward_to_outside_number = m.get('CallsForwardToOutsideNumber')
        if m.get('CallsHandled') is not None:
            self.calls_handled = m.get('CallsHandled')
        if m.get('CallsHold') is not None:
            self.calls_hold = m.get('CallsHold')
        if m.get('CallsIVRException') is not None:
            self.calls_ivrexception = m.get('CallsIVRException')
        if m.get('CallsOffered') is not None:
            self.calls_offered = m.get('CallsOffered')
        if m.get('CallsQueued') is not None:
            self.calls_queued = m.get('CallsQueued')
        if m.get('CallsQueuingFailed') is not None:
            self.calls_queuing_failed = m.get('CallsQueuingFailed')
        if m.get('CallsQueuingOverflow') is not None:
            self.calls_queuing_overflow = m.get('CallsQueuingOverflow')
        if m.get('CallsQueuingTimeout') is not None:
            self.calls_queuing_timeout = m.get('CallsQueuingTimeout')
        if m.get('CallsRinged') is not None:
            self.calls_ringed = m.get('CallsRinged')
        if m.get('CallsVoicemail') is not None:
            self.calls_voicemail = m.get('CallsVoicemail')
        if m.get('HandleRate') is not None:
            self.handle_rate = m.get('HandleRate')
        if m.get('MaxAbandonTime') is not None:
            self.max_abandon_time = m.get('MaxAbandonTime')
        if m.get('MaxAbandonedInIVRTime') is not None:
            self.max_abandoned_in_ivrtime = m.get('MaxAbandonedInIVRTime')
        if m.get('MaxAbandonedInQueueTime') is not None:
            self.max_abandoned_in_queue_time = m.get('MaxAbandonedInQueueTime')
        if m.get('MaxAbandonedInRingTime') is not None:
            self.max_abandoned_in_ring_time = m.get('MaxAbandonedInRingTime')
        if m.get('MaxHoldTime') is not None:
            self.max_hold_time = m.get('MaxHoldTime')
        if m.get('MaxRingTime') is not None:
            self.max_ring_time = m.get('MaxRingTime')
        if m.get('MaxTalkTime') is not None:
            self.max_talk_time = m.get('MaxTalkTime')
        if m.get('MaxWaitTime') is not None:
            self.max_wait_time = m.get('MaxWaitTime')
        if m.get('MaxWorkTime') is not None:
            self.max_work_time = m.get('MaxWorkTime')
        if m.get('SatisfactionIndex') is not None:
            self.satisfaction_index = m.get('SatisfactionIndex')
        if m.get('SatisfactionRate') is not None:
            self.satisfaction_rate = m.get('SatisfactionRate')
        if m.get('SatisfactionSurveysOffered') is not None:
            self.satisfaction_surveys_offered = m.get('SatisfactionSurveysOffered')
        if m.get('SatisfactionSurveysResponded') is not None:
            self.satisfaction_surveys_responded = m.get('SatisfactionSurveysResponded')
        if m.get('ServiceLevel20') is not None:
            self.service_level_20 = m.get('ServiceLevel20')
        if m.get('TotalAbandonTime') is not None:
            self.total_abandon_time = m.get('TotalAbandonTime')
        if m.get('TotalAbandonedInIVRTime') is not None:
            self.total_abandoned_in_ivrtime = m.get('TotalAbandonedInIVRTime')
        if m.get('TotalAbandonedInQueueTime') is not None:
            self.total_abandoned_in_queue_time = m.get('TotalAbandonedInQueueTime')
        if m.get('TotalAbandonedInRingTime') is not None:
            self.total_abandoned_in_ring_time = m.get('TotalAbandonedInRingTime')
        if m.get('TotalHoldTime') is not None:
            self.total_hold_time = m.get('TotalHoldTime')
        if m.get('TotalRingTime') is not None:
            self.total_ring_time = m.get('TotalRingTime')
        if m.get('TotalTalkTime') is not None:
            self.total_talk_time = m.get('TotalTalkTime')
        if m.get('TotalWaitTime') is not None:
            self.total_wait_time = m.get('TotalWaitTime')
        if m.get('TotalWorkTime') is not None:
            self.total_work_time = m.get('TotalWorkTime')
        return self


class GetHistoricalInstanceReportResponseBodyDataOutbound(TeaModel):
    def __init__(self, answer_rate=None, average_dialing_time=None, average_hold_time=None, average_ring_time=None,
                 average_talk_time=None, average_work_time=None, calls_answered=None, calls_attended_transferred=None,
                 calls_blind_transferred=None, calls_dialed=None, calls_hold=None, calls_ringed=None, max_dialing_time=None,
                 max_hold_time=None, max_ring_time=None, max_talk_time=None, max_work_time=None, satisfaction_index=None,
                 satisfaction_rate=None, satisfaction_surveys_offered=None, satisfaction_surveys_responded=None,
                 total_dialing_time=None, total_hold_time=None, total_ring_time=None, total_talk_time=None, total_work_time=None):
        self.answer_rate = answer_rate  # type: float
        self.average_dialing_time = average_dialing_time  # type: float
        self.average_hold_time = average_hold_time  # type: float
        self.average_ring_time = average_ring_time  # type: float
        self.average_talk_time = average_talk_time  # type: float
        self.average_work_time = average_work_time  # type: float
        self.calls_answered = calls_answered  # type: long
        self.calls_attended_transferred = calls_attended_transferred  # type: long
        self.calls_blind_transferred = calls_blind_transferred  # type: long
        self.calls_dialed = calls_dialed  # type: long
        self.calls_hold = calls_hold  # type: int
        self.calls_ringed = calls_ringed  # type: long
        self.max_dialing_time = max_dialing_time  # type: long
        self.max_hold_time = max_hold_time  # type: long
        self.max_ring_time = max_ring_time  # type: long
        self.max_talk_time = max_talk_time  # type: long
        self.max_work_time = max_work_time  # type: long
        self.satisfaction_index = satisfaction_index  # type: float
        self.satisfaction_rate = satisfaction_rate  # type: float
        self.satisfaction_surveys_offered = satisfaction_surveys_offered  # type: long
        self.satisfaction_surveys_responded = satisfaction_surveys_responded  # type: long
        self.total_dialing_time = total_dialing_time  # type: long
        self.total_hold_time = total_hold_time  # type: long
        self.total_ring_time = total_ring_time  # type: long
        self.total_talk_time = total_talk_time  # type: long
        self.total_work_time = total_work_time  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetHistoricalInstanceReportResponseBodyDataOutbound, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.answer_rate is not None:
            result['AnswerRate'] = self.answer_rate
        if self.average_dialing_time is not None:
            result['AverageDialingTime'] = self.average_dialing_time
        if self.average_hold_time is not None:
            result['AverageHoldTime'] = self.average_hold_time
        if self.average_ring_time is not None:
            result['AverageRingTime'] = self.average_ring_time
        if self.average_talk_time is not None:
            result['AverageTalkTime'] = self.average_talk_time
        if self.average_work_time is not None:
            result['AverageWorkTime'] = self.average_work_time
        if self.calls_answered is not None:
            result['CallsAnswered'] = self.calls_answered
        if self.calls_attended_transferred is not None:
            result['CallsAttendedTransferred'] = self.calls_attended_transferred
        if self.calls_blind_transferred is not None:
            result['CallsBlindTransferred'] = self.calls_blind_transferred
        if self.calls_dialed is not None:
            result['CallsDialed'] = self.calls_dialed
        if self.calls_hold is not None:
            result['CallsHold'] = self.calls_hold
        if self.calls_ringed is not None:
            result['CallsRinged'] = self.calls_ringed
        if self.max_dialing_time is not None:
            result['MaxDialingTime'] = self.max_dialing_time
        if self.max_hold_time is not None:
            result['MaxHoldTime'] = self.max_hold_time
        if self.max_ring_time is not None:
            result['MaxRingTime'] = self.max_ring_time
        if self.max_talk_time is not None:
            result['MaxTalkTime'] = self.max_talk_time
        if self.max_work_time is not None:
            result['MaxWorkTime'] = self.max_work_time
        if self.satisfaction_index is not None:
            result['SatisfactionIndex'] = self.satisfaction_index
        if self.satisfaction_rate is not None:
            result['SatisfactionRate'] = self.satisfaction_rate
        if self.satisfaction_surveys_offered is not None:
            result['SatisfactionSurveysOffered'] = self.satisfaction_surveys_offered
        if self.satisfaction_surveys_responded is not None:
            result['SatisfactionSurveysResponded'] = self.satisfaction_surveys_responded
        if self.total_dialing_time is not None:
            result['TotalDialingTime'] = self.total_dialing_time
        if self.total_hold_time is not None:
            result['TotalHoldTime'] = self.total_hold_time
        if self.total_ring_time is not None:
            result['TotalRingTime'] = self.total_ring_time
        if self.total_talk_time is not None:
            result['TotalTalkTime'] = self.total_talk_time
        if self.total_work_time is not None:
            result['TotalWorkTime'] = self.total_work_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AnswerRate') is not None:
            self.answer_rate = m.get('AnswerRate')
        if m.get('AverageDialingTime') is not None:
            self.average_dialing_time = m.get('AverageDialingTime')
        if m.get('AverageHoldTime') is not None:
            self.average_hold_time = m.get('AverageHoldTime')
        if m.get('AverageRingTime') is not None:
            self.average_ring_time = m.get('AverageRingTime')
        if m.get('AverageTalkTime') is not None:
            self.average_talk_time = m.get('AverageTalkTime')
        if m.get('AverageWorkTime') is not None:
            self.average_work_time = m.get('AverageWorkTime')
        if m.get('CallsAnswered') is not None:
            self.calls_answered = m.get('CallsAnswered')
        if m.get('CallsAttendedTransferred') is not None:
            self.calls_attended_transferred = m.get('CallsAttendedTransferred')
        if m.get('CallsBlindTransferred') is not None:
            self.calls_blind_transferred = m.get('CallsBlindTransferred')
        if m.get('CallsDialed') is not None:
            self.calls_dialed = m.get('CallsDialed')
        if m.get('CallsHold') is not None:
            self.calls_hold = m.get('CallsHold')
        if m.get('CallsRinged') is not None:
            self.calls_ringed = m.get('CallsRinged')
        if m.get('MaxDialingTime') is not None:
            self.max_dialing_time = m.get('MaxDialingTime')
        if m.get('MaxHoldTime') is not None:
            self.max_hold_time = m.get('MaxHoldTime')
        if m.get('MaxRingTime') is not None:
            self.max_ring_time = m.get('MaxRingTime')
        if m.get('MaxTalkTime') is not None:
            self.max_talk_time = m.get('MaxTalkTime')
        if m.get('MaxWorkTime') is not None:
            self.max_work_time = m.get('MaxWorkTime')
        if m.get('SatisfactionIndex') is not None:
            self.satisfaction_index = m.get('SatisfactionIndex')
        if m.get('SatisfactionRate') is not None:
            self.satisfaction_rate = m.get('SatisfactionRate')
        if m.get('SatisfactionSurveysOffered') is not None:
            self.satisfaction_surveys_offered = m.get('SatisfactionSurveysOffered')
        if m.get('SatisfactionSurveysResponded') is not None:
            self.satisfaction_surveys_responded = m.get('SatisfactionSurveysResponded')
        if m.get('TotalDialingTime') is not None:
            self.total_dialing_time = m.get('TotalDialingTime')
        if m.get('TotalHoldTime') is not None:
            self.total_hold_time = m.get('TotalHoldTime')
        if m.get('TotalRingTime') is not None:
            self.total_ring_time = m.get('TotalRingTime')
        if m.get('TotalTalkTime') is not None:
            self.total_talk_time = m.get('TotalTalkTime')
        if m.get('TotalWorkTime') is not None:
            self.total_work_time = m.get('TotalWorkTime')
        return self


class GetHistoricalInstanceReportResponseBodyDataOverall(TeaModel):
    def __init__(self, average_break_time=None, average_hold_time=None, average_ready_time=None,
                 average_talk_time=None, average_work_time=None, max_break_time=None, max_hold_time=None, max_ready_time=None,
                 max_talk_time=None, max_work_time=None, occupancy_rate=None, satisfaction_index=None, satisfaction_rate=None,
                 satisfaction_surveys_offered=None, satisfaction_surveys_responded=None, total_break_time=None, total_calls=None,
                 total_hold_time=None, total_logged_in_time=None, total_ready_time=None, total_talk_time=None,
                 total_work_time=None):
        self.average_break_time = average_break_time  # type: float
        self.average_hold_time = average_hold_time  # type: float
        self.average_ready_time = average_ready_time  # type: float
        self.average_talk_time = average_talk_time  # type: float
        self.average_work_time = average_work_time  # type: float
        self.max_break_time = max_break_time  # type: long
        self.max_hold_time = max_hold_time  # type: long
        self.max_ready_time = max_ready_time  # type: long
        self.max_talk_time = max_talk_time  # type: long
        self.max_work_time = max_work_time  # type: long
        self.occupancy_rate = occupancy_rate  # type: float
        self.satisfaction_index = satisfaction_index  # type: float
        self.satisfaction_rate = satisfaction_rate  # type: float
        self.satisfaction_surveys_offered = satisfaction_surveys_offered  # type: long
        self.satisfaction_surveys_responded = satisfaction_surveys_responded  # type: long
        self.total_break_time = total_break_time  # type: long
        self.total_calls = total_calls  # type: long
        self.total_hold_time = total_hold_time  # type: long
        self.total_logged_in_time = total_logged_in_time  # type: long
        self.total_ready_time = total_ready_time  # type: long
        self.total_talk_time = total_talk_time  # type: long
        self.total_work_time = total_work_time  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetHistoricalInstanceReportResponseBodyDataOverall, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.average_break_time is not None:
            result['AverageBreakTime'] = self.average_break_time
        if self.average_hold_time is not None:
            result['AverageHoldTime'] = self.average_hold_time
        if self.average_ready_time is not None:
            result['AverageReadyTime'] = self.average_ready_time
        if self.average_talk_time is not None:
            result['AverageTalkTime'] = self.average_talk_time
        if self.average_work_time is not None:
            result['AverageWorkTime'] = self.average_work_time
        if self.max_break_time is not None:
            result['MaxBreakTime'] = self.max_break_time
        if self.max_hold_time is not None:
            result['MaxHoldTime'] = self.max_hold_time
        if self.max_ready_time is not None:
            result['MaxReadyTime'] = self.max_ready_time
        if self.max_talk_time is not None:
            result['MaxTalkTime'] = self.max_talk_time
        if self.max_work_time is not None:
            result['MaxWorkTime'] = self.max_work_time
        if self.occupancy_rate is not None:
            result['OccupancyRate'] = self.occupancy_rate
        if self.satisfaction_index is not None:
            result['SatisfactionIndex'] = self.satisfaction_index
        if self.satisfaction_rate is not None:
            result['SatisfactionRate'] = self.satisfaction_rate
        if self.satisfaction_surveys_offered is not None:
            result['SatisfactionSurveysOffered'] = self.satisfaction_surveys_offered
        if self.satisfaction_surveys_responded is not None:
            result['SatisfactionSurveysResponded'] = self.satisfaction_surveys_responded
        if self.total_break_time is not None:
            result['TotalBreakTime'] = self.total_break_time
        if self.total_calls is not None:
            result['TotalCalls'] = self.total_calls
        if self.total_hold_time is not None:
            result['TotalHoldTime'] = self.total_hold_time
        if self.total_logged_in_time is not None:
            result['TotalLoggedInTime'] = self.total_logged_in_time
        if self.total_ready_time is not None:
            result['TotalReadyTime'] = self.total_ready_time
        if self.total_talk_time is not None:
            result['TotalTalkTime'] = self.total_talk_time
        if self.total_work_time is not None:
            result['TotalWorkTime'] = self.total_work_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AverageBreakTime') is not None:
            self.average_break_time = m.get('AverageBreakTime')
        if m.get('AverageHoldTime') is not None:
            self.average_hold_time = m.get('AverageHoldTime')
        if m.get('AverageReadyTime') is not None:
            self.average_ready_time = m.get('AverageReadyTime')
        if m.get('AverageTalkTime') is not None:
            self.average_talk_time = m.get('AverageTalkTime')
        if m.get('AverageWorkTime') is not None:
            self.average_work_time = m.get('AverageWorkTime')
        if m.get('MaxBreakTime') is not None:
            self.max_break_time = m.get('MaxBreakTime')
        if m.get('MaxHoldTime') is not None:
            self.max_hold_time = m.get('MaxHoldTime')
        if m.get('MaxReadyTime') is not None:
            self.max_ready_time = m.get('MaxReadyTime')
        if m.get('MaxTalkTime') is not None:
            self.max_talk_time = m.get('MaxTalkTime')
        if m.get('MaxWorkTime') is not None:
            self.max_work_time = m.get('MaxWorkTime')
        if m.get('OccupancyRate') is not None:
            self.occupancy_rate = m.get('OccupancyRate')
        if m.get('SatisfactionIndex') is not None:
            self.satisfaction_index = m.get('SatisfactionIndex')
        if m.get('SatisfactionRate') is not None:
            self.satisfaction_rate = m.get('SatisfactionRate')
        if m.get('SatisfactionSurveysOffered') is not None:
            self.satisfaction_surveys_offered = m.get('SatisfactionSurveysOffered')
        if m.get('SatisfactionSurveysResponded') is not None:
            self.satisfaction_surveys_responded = m.get('SatisfactionSurveysResponded')
        if m.get('TotalBreakTime') is not None:
            self.total_break_time = m.get('TotalBreakTime')
        if m.get('TotalCalls') is not None:
            self.total_calls = m.get('TotalCalls')
        if m.get('TotalHoldTime') is not None:
            self.total_hold_time = m.get('TotalHoldTime')
        if m.get('TotalLoggedInTime') is not None:
            self.total_logged_in_time = m.get('TotalLoggedInTime')
        if m.get('TotalReadyTime') is not None:
            self.total_ready_time = m.get('TotalReadyTime')
        if m.get('TotalTalkTime') is not None:
            self.total_talk_time = m.get('TotalTalkTime')
        if m.get('TotalWorkTime') is not None:
            self.total_work_time = m.get('TotalWorkTime')
        return self


class GetHistoricalInstanceReportResponseBodyData(TeaModel):
    def __init__(self, inbound=None, outbound=None, overall=None):
        self.inbound = inbound  # type: GetHistoricalInstanceReportResponseBodyDataInbound
        self.outbound = outbound  # type: GetHistoricalInstanceReportResponseBodyDataOutbound
        self.overall = overall  # type: GetHistoricalInstanceReportResponseBodyDataOverall

    def validate(self):
        if self.inbound:
            self.inbound.validate()
        if self.outbound:
            self.outbound.validate()
        if self.overall:
            self.overall.validate()

    def to_map(self):
        _map = super(GetHistoricalInstanceReportResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.inbound is not None:
            result['Inbound'] = self.inbound.to_map()
        if self.outbound is not None:
            result['Outbound'] = self.outbound.to_map()
        if self.overall is not None:
            result['Overall'] = self.overall.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Inbound') is not None:
            temp_model = GetHistoricalInstanceReportResponseBodyDataInbound()
            self.inbound = temp_model.from_map(m['Inbound'])
        if m.get('Outbound') is not None:
            temp_model = GetHistoricalInstanceReportResponseBodyDataOutbound()
            self.outbound = temp_model.from_map(m['Outbound'])
        if m.get('Overall') is not None:
            temp_model = GetHistoricalInstanceReportResponseBodyDataOverall()
            self.overall = temp_model.from_map(m['Overall'])
        return self


class GetHistoricalInstanceReportResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: GetHistoricalInstanceReportResponseBodyData
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetHistoricalInstanceReportResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetHistoricalInstanceReportResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetHistoricalInstanceReportResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: GetHistoricalInstanceReportResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetHistoricalInstanceReportResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetHistoricalInstanceReportResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetInstanceRequest(TeaModel):
    def __init__(self, instance_id=None):
        self.instance_id = instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetInstanceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class GetInstanceResponseBodyDataAdminList(TeaModel):
    def __init__(self, display_name=None, email=None, extension=None, instance_id=None, login_name=None, mobile=None,
                 role_id=None, role_name=None, user_id=None, work_mode=None):
        self.display_name = display_name  # type: str
        self.email = email  # type: str
        self.extension = extension  # type: str
        self.instance_id = instance_id  # type: str
        self.login_name = login_name  # type: str
        self.mobile = mobile  # type: str
        self.role_id = role_id  # type: str
        self.role_name = role_name  # type: str
        self.user_id = user_id  # type: str
        self.work_mode = work_mode  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetInstanceResponseBodyDataAdminList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.display_name is not None:
            result['DisplayName'] = self.display_name
        if self.email is not None:
            result['Email'] = self.email
        if self.extension is not None:
            result['Extension'] = self.extension
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.login_name is not None:
            result['LoginName'] = self.login_name
        if self.mobile is not None:
            result['Mobile'] = self.mobile
        if self.role_id is not None:
            result['RoleId'] = self.role_id
        if self.role_name is not None:
            result['RoleName'] = self.role_name
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.work_mode is not None:
            result['WorkMode'] = self.work_mode
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DisplayName') is not None:
            self.display_name = m.get('DisplayName')
        if m.get('Email') is not None:
            self.email = m.get('Email')
        if m.get('Extension') is not None:
            self.extension = m.get('Extension')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('LoginName') is not None:
            self.login_name = m.get('LoginName')
        if m.get('Mobile') is not None:
            self.mobile = m.get('Mobile')
        if m.get('RoleId') is not None:
            self.role_id = m.get('RoleId')
        if m.get('RoleName') is not None:
            self.role_name = m.get('RoleName')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('WorkMode') is not None:
            self.work_mode = m.get('WorkMode')
        return self


class GetInstanceResponseBodyDataNumberListSkillGroups(TeaModel):
    def __init__(self, description=None, display_name=None, instance_id=None, name=None, phone_number_count=None,
                 skill_group_id=None, user_count=None):
        self.description = description  # type: str
        self.display_name = display_name  # type: str
        self.instance_id = instance_id  # type: str
        self.name = name  # type: str
        self.phone_number_count = phone_number_count  # type: int
        self.skill_group_id = skill_group_id  # type: str
        self.user_count = user_count  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetInstanceResponseBodyDataNumberListSkillGroups, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.display_name is not None:
            result['DisplayName'] = self.display_name
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.name is not None:
            result['Name'] = self.name
        if self.phone_number_count is not None:
            result['PhoneNumberCount'] = self.phone_number_count
        if self.skill_group_id is not None:
            result['SkillGroupId'] = self.skill_group_id
        if self.user_count is not None:
            result['UserCount'] = self.user_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DisplayName') is not None:
            self.display_name = m.get('DisplayName')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PhoneNumberCount') is not None:
            self.phone_number_count = m.get('PhoneNumberCount')
        if m.get('SkillGroupId') is not None:
            self.skill_group_id = m.get('SkillGroupId')
        if m.get('UserCount') is not None:
            self.user_count = m.get('UserCount')
        return self


class GetInstanceResponseBodyDataNumberList(TeaModel):
    def __init__(self, active=None, city=None, contact_flow_id=None, instance_id=None, number=None, province=None,
                 skill_groups=None, usage=None, user_id=None):
        self.active = active  # type: bool
        self.city = city  # type: str
        self.contact_flow_id = contact_flow_id  # type: str
        self.instance_id = instance_id  # type: str
        self.number = number  # type: str
        self.province = province  # type: str
        self.skill_groups = skill_groups  # type: list[GetInstanceResponseBodyDataNumberListSkillGroups]
        self.usage = usage  # type: str
        self.user_id = user_id  # type: str

    def validate(self):
        if self.skill_groups:
            for k in self.skill_groups:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetInstanceResponseBodyDataNumberList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.active is not None:
            result['Active'] = self.active
        if self.city is not None:
            result['City'] = self.city
        if self.contact_flow_id is not None:
            result['ContactFlowId'] = self.contact_flow_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.number is not None:
            result['Number'] = self.number
        if self.province is not None:
            result['Province'] = self.province
        result['SkillGroups'] = []
        if self.skill_groups is not None:
            for k in self.skill_groups:
                result['SkillGroups'].append(k.to_map() if k else None)
        if self.usage is not None:
            result['Usage'] = self.usage
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Active') is not None:
            self.active = m.get('Active')
        if m.get('City') is not None:
            self.city = m.get('City')
        if m.get('ContactFlowId') is not None:
            self.contact_flow_id = m.get('ContactFlowId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Number') is not None:
            self.number = m.get('Number')
        if m.get('Province') is not None:
            self.province = m.get('Province')
        self.skill_groups = []
        if m.get('SkillGroups') is not None:
            for k in m.get('SkillGroups'):
                temp_model = GetInstanceResponseBodyDataNumberListSkillGroups()
                self.skill_groups.append(temp_model.from_map(k))
        if m.get('Usage') is not None:
            self.usage = m.get('Usage')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class GetInstanceResponseBodyData(TeaModel):
    def __init__(self, admin_list=None, aliyun_uid=None, console_url=None, description=None, domain_name=None,
                 id=None, name=None, number_list=None, status=None):
        self.admin_list = admin_list  # type: list[GetInstanceResponseBodyDataAdminList]
        self.aliyun_uid = aliyun_uid  # type: str
        self.console_url = console_url  # type: str
        self.description = description  # type: str
        self.domain_name = domain_name  # type: str
        self.id = id  # type: str
        self.name = name  # type: str
        self.number_list = number_list  # type: list[GetInstanceResponseBodyDataNumberList]
        self.status = status  # type: str

    def validate(self):
        if self.admin_list:
            for k in self.admin_list:
                if k:
                    k.validate()
        if self.number_list:
            for k in self.number_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetInstanceResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AdminList'] = []
        if self.admin_list is not None:
            for k in self.admin_list:
                result['AdminList'].append(k.to_map() if k else None)
        if self.aliyun_uid is not None:
            result['AliyunUid'] = self.aliyun_uid
        if self.console_url is not None:
            result['ConsoleUrl'] = self.console_url
        if self.description is not None:
            result['Description'] = self.description
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.id is not None:
            result['Id'] = self.id
        if self.name is not None:
            result['Name'] = self.name
        result['NumberList'] = []
        if self.number_list is not None:
            for k in self.number_list:
                result['NumberList'].append(k.to_map() if k else None)
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.admin_list = []
        if m.get('AdminList') is not None:
            for k in m.get('AdminList'):
                temp_model = GetInstanceResponseBodyDataAdminList()
                self.admin_list.append(temp_model.from_map(k))
        if m.get('AliyunUid') is not None:
            self.aliyun_uid = m.get('AliyunUid')
        if m.get('ConsoleUrl') is not None:
            self.console_url = m.get('ConsoleUrl')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        self.number_list = []
        if m.get('NumberList') is not None:
            for k in m.get('NumberList'):
                temp_model = GetInstanceResponseBodyDataNumberList()
                self.number_list.append(temp_model.from_map(k))
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class GetInstanceResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, params=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: GetInstanceResponseBodyData
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.params = params  # type: list[str]
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetInstanceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.params is not None:
            result['Params'] = self.params
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetInstanceResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Params') is not None:
            self.params = m.get('Params')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetInstanceResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: GetInstanceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetInstanceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetInstanceTrendingReportRequest(TeaModel):
    def __init__(self, end_time=None, instance_id=None, start_time=None):
        self.end_time = end_time  # type: long
        self.instance_id = instance_id  # type: str
        self.start_time = start_time  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetInstanceTrendingReportRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class GetInstanceTrendingReportResponseBodyDataInbound(TeaModel):
    def __init__(self, calls_abandoned_in_ivr=None, calls_abandoned_in_queue=None, calls_abandoned_in_ring=None,
                 calls_handled=None, calls_queued=None, stats_time=None, total_calls=None):
        self.calls_abandoned_in_ivr = calls_abandoned_in_ivr  # type: long
        self.calls_abandoned_in_queue = calls_abandoned_in_queue  # type: long
        self.calls_abandoned_in_ring = calls_abandoned_in_ring  # type: long
        self.calls_handled = calls_handled  # type: long
        self.calls_queued = calls_queued  # type: long
        self.stats_time = stats_time  # type: long
        self.total_calls = total_calls  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetInstanceTrendingReportResponseBodyDataInbound, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.calls_abandoned_in_ivr is not None:
            result['CallsAbandonedInIVR'] = self.calls_abandoned_in_ivr
        if self.calls_abandoned_in_queue is not None:
            result['CallsAbandonedInQueue'] = self.calls_abandoned_in_queue
        if self.calls_abandoned_in_ring is not None:
            result['CallsAbandonedInRing'] = self.calls_abandoned_in_ring
        if self.calls_handled is not None:
            result['CallsHandled'] = self.calls_handled
        if self.calls_queued is not None:
            result['CallsQueued'] = self.calls_queued
        if self.stats_time is not None:
            result['StatsTime'] = self.stats_time
        if self.total_calls is not None:
            result['TotalCalls'] = self.total_calls
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CallsAbandonedInIVR') is not None:
            self.calls_abandoned_in_ivr = m.get('CallsAbandonedInIVR')
        if m.get('CallsAbandonedInQueue') is not None:
            self.calls_abandoned_in_queue = m.get('CallsAbandonedInQueue')
        if m.get('CallsAbandonedInRing') is not None:
            self.calls_abandoned_in_ring = m.get('CallsAbandonedInRing')
        if m.get('CallsHandled') is not None:
            self.calls_handled = m.get('CallsHandled')
        if m.get('CallsQueued') is not None:
            self.calls_queued = m.get('CallsQueued')
        if m.get('StatsTime') is not None:
            self.stats_time = m.get('StatsTime')
        if m.get('TotalCalls') is not None:
            self.total_calls = m.get('TotalCalls')
        return self


class GetInstanceTrendingReportResponseBodyDataOutbound(TeaModel):
    def __init__(self, calls_answered=None, stats_time=None, total_calls=None):
        self.calls_answered = calls_answered  # type: long
        self.stats_time = stats_time  # type: long
        self.total_calls = total_calls  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetInstanceTrendingReportResponseBodyDataOutbound, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.calls_answered is not None:
            result['CallsAnswered'] = self.calls_answered
        if self.stats_time is not None:
            result['StatsTime'] = self.stats_time
        if self.total_calls is not None:
            result['TotalCalls'] = self.total_calls
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CallsAnswered') is not None:
            self.calls_answered = m.get('CallsAnswered')
        if m.get('StatsTime') is not None:
            self.stats_time = m.get('StatsTime')
        if m.get('TotalCalls') is not None:
            self.total_calls = m.get('TotalCalls')
        return self


class GetInstanceTrendingReportResponseBodyData(TeaModel):
    def __init__(self, inbound=None, outbound=None):
        self.inbound = inbound  # type: list[GetInstanceTrendingReportResponseBodyDataInbound]
        self.outbound = outbound  # type: list[GetInstanceTrendingReportResponseBodyDataOutbound]

    def validate(self):
        if self.inbound:
            for k in self.inbound:
                if k:
                    k.validate()
        if self.outbound:
            for k in self.outbound:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetInstanceTrendingReportResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Inbound'] = []
        if self.inbound is not None:
            for k in self.inbound:
                result['Inbound'].append(k.to_map() if k else None)
        result['Outbound'] = []
        if self.outbound is not None:
            for k in self.outbound:
                result['Outbound'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.inbound = []
        if m.get('Inbound') is not None:
            for k in m.get('Inbound'):
                temp_model = GetInstanceTrendingReportResponseBodyDataInbound()
                self.inbound.append(temp_model.from_map(k))
        self.outbound = []
        if m.get('Outbound') is not None:
            for k in m.get('Outbound'):
                temp_model = GetInstanceTrendingReportResponseBodyDataOutbound()
                self.outbound.append(temp_model.from_map(k))
        return self


class GetInstanceTrendingReportResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: GetInstanceTrendingReportResponseBodyData
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetInstanceTrendingReportResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetInstanceTrendingReportResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetInstanceTrendingReportResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: GetInstanceTrendingReportResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetInstanceTrendingReportResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetInstanceTrendingReportResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetLoginDetailsRequest(TeaModel):
    def __init__(self, instance_id=None, user_id=None):
        self.instance_id = instance_id  # type: str
        self.user_id = user_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetLoginDetailsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class GetLoginDetailsResponseBodyData(TeaModel):
    def __init__(self, agent_server_url=None, device_ext=None, device_id=None, device_state=None, display_name=None,
                 extension=None, signature=None, signature_2=None, sip_server_url=None, user_id=None, user_key=None,
                 user_key_2=None, work_mode=None):
        self.agent_server_url = agent_server_url  # type: str
        self.device_ext = device_ext  # type: str
        self.device_id = device_id  # type: str
        self.device_state = device_state  # type: str
        self.display_name = display_name  # type: str
        self.extension = extension  # type: str
        self.signature = signature  # type: str
        self.signature_2 = signature_2  # type: str
        self.sip_server_url = sip_server_url  # type: str
        self.user_id = user_id  # type: str
        self.user_key = user_key  # type: str
        self.user_key_2 = user_key_2  # type: str
        self.work_mode = work_mode  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetLoginDetailsResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_server_url is not None:
            result['AgentServerUrl'] = self.agent_server_url
        if self.device_ext is not None:
            result['DeviceExt'] = self.device_ext
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.device_state is not None:
            result['DeviceState'] = self.device_state
        if self.display_name is not None:
            result['DisplayName'] = self.display_name
        if self.extension is not None:
            result['Extension'] = self.extension
        if self.signature is not None:
            result['Signature'] = self.signature
        if self.signature_2 is not None:
            result['Signature2'] = self.signature_2
        if self.sip_server_url is not None:
            result['SipServerUrl'] = self.sip_server_url
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.user_key is not None:
            result['UserKey'] = self.user_key
        if self.user_key_2 is not None:
            result['UserKey2'] = self.user_key_2
        if self.work_mode is not None:
            result['WorkMode'] = self.work_mode
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AgentServerUrl') is not None:
            self.agent_server_url = m.get('AgentServerUrl')
        if m.get('DeviceExt') is not None:
            self.device_ext = m.get('DeviceExt')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('DeviceState') is not None:
            self.device_state = m.get('DeviceState')
        if m.get('DisplayName') is not None:
            self.display_name = m.get('DisplayName')
        if m.get('Extension') is not None:
            self.extension = m.get('Extension')
        if m.get('Signature') is not None:
            self.signature = m.get('Signature')
        if m.get('Signature2') is not None:
            self.signature_2 = m.get('Signature2')
        if m.get('SipServerUrl') is not None:
            self.sip_server_url = m.get('SipServerUrl')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('UserKey') is not None:
            self.user_key = m.get('UserKey')
        if m.get('UserKey2') is not None:
            self.user_key_2 = m.get('UserKey2')
        if m.get('WorkMode') is not None:
            self.work_mode = m.get('WorkMode')
        return self


class GetLoginDetailsResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, params=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: GetLoginDetailsResponseBodyData
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.params = params  # type: list[str]
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetLoginDetailsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.params is not None:
            result['Params'] = self.params
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetLoginDetailsResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Params') is not None:
            self.params = m.get('Params')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetLoginDetailsResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: GetLoginDetailsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetLoginDetailsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetLoginDetailsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetMonoRecordingRequest(TeaModel):
    def __init__(self, contact_id=None, instance_id=None):
        self.contact_id = contact_id  # type: str
        self.instance_id = instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetMonoRecordingRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.contact_id is not None:
            result['ContactId'] = self.contact_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ContactId') is not None:
            self.contact_id = m.get('ContactId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class GetMonoRecordingResponseBodyData(TeaModel):
    def __init__(self, file_name=None, file_url=None):
        self.file_name = file_name  # type: str
        self.file_url = file_url  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetMonoRecordingResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.file_name is not None:
            result['FileName'] = self.file_name
        if self.file_url is not None:
            result['FileUrl'] = self.file_url
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        if m.get('FileUrl') is not None:
            self.file_url = m.get('FileUrl')
        return self


class GetMonoRecordingResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: GetMonoRecordingResponseBodyData
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetMonoRecordingResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetMonoRecordingResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetMonoRecordingResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: GetMonoRecordingResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetMonoRecordingResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetMonoRecordingResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetMultiChannelRecordingRequest(TeaModel):
    def __init__(self, contact_id=None, instance_id=None):
        self.contact_id = contact_id  # type: str
        self.instance_id = instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetMultiChannelRecordingRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.contact_id is not None:
            result['ContactId'] = self.contact_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ContactId') is not None:
            self.contact_id = m.get('ContactId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class GetMultiChannelRecordingResponseBodyData(TeaModel):
    def __init__(self, file_name=None, file_url=None):
        self.file_name = file_name  # type: str
        self.file_url = file_url  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetMultiChannelRecordingResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.file_name is not None:
            result['FileName'] = self.file_name
        if self.file_url is not None:
            result['FileUrl'] = self.file_url
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        if m.get('FileUrl') is not None:
            self.file_url = m.get('FileUrl')
        return self


class GetMultiChannelRecordingResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: GetMultiChannelRecordingResponseBodyData
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetMultiChannelRecordingResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetMultiChannelRecordingResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetMultiChannelRecordingResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: GetMultiChannelRecordingResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetMultiChannelRecordingResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetMultiChannelRecordingResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetNumberLocationRequest(TeaModel):
    def __init__(self, instance_id=None, number=None):
        self.instance_id = instance_id  # type: str
        self.number = number  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetNumberLocationRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.number is not None:
            result['Number'] = self.number
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Number') is not None:
            self.number = m.get('Number')
        return self


class GetNumberLocationResponseBodyData(TeaModel):
    def __init__(self, city=None, number=None, province=None):
        self.city = city  # type: str
        self.number = number  # type: str
        self.province = province  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetNumberLocationResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.city is not None:
            result['City'] = self.city
        if self.number is not None:
            result['Number'] = self.number
        if self.province is not None:
            result['Province'] = self.province
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('City') is not None:
            self.city = m.get('City')
        if m.get('Number') is not None:
            self.number = m.get('Number')
        if m.get('Province') is not None:
            self.province = m.get('Province')
        return self


class GetNumberLocationResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: GetNumberLocationResponseBodyData
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetNumberLocationResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetNumberLocationResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetNumberLocationResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: GetNumberLocationResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetNumberLocationResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetNumberLocationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetRealtimeInstanceStatesRequest(TeaModel):
    def __init__(self, instance_id=None):
        self.instance_id = instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetRealtimeInstanceStatesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class GetRealtimeInstanceStatesResponseBodyData(TeaModel):
    def __init__(self, breaking_agents=None, instance_id=None, interactive_calls=None, logged_in_agents=None,
                 longest_waiting_time=None, ready_agents=None, talking_agents=None, total_agents=None, waiting_calls=None,
                 working_agents=None):
        self.breaking_agents = breaking_agents  # type: long
        self.instance_id = instance_id  # type: str
        self.interactive_calls = interactive_calls  # type: long
        self.logged_in_agents = logged_in_agents  # type: long
        self.longest_waiting_time = longest_waiting_time  # type: long
        self.ready_agents = ready_agents  # type: long
        self.talking_agents = talking_agents  # type: long
        self.total_agents = total_agents  # type: long
        self.waiting_calls = waiting_calls  # type: long
        self.working_agents = working_agents  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetRealtimeInstanceStatesResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.breaking_agents is not None:
            result['BreakingAgents'] = self.breaking_agents
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.interactive_calls is not None:
            result['InteractiveCalls'] = self.interactive_calls
        if self.logged_in_agents is not None:
            result['LoggedInAgents'] = self.logged_in_agents
        if self.longest_waiting_time is not None:
            result['LongestWaitingTime'] = self.longest_waiting_time
        if self.ready_agents is not None:
            result['ReadyAgents'] = self.ready_agents
        if self.talking_agents is not None:
            result['TalkingAgents'] = self.talking_agents
        if self.total_agents is not None:
            result['TotalAgents'] = self.total_agents
        if self.waiting_calls is not None:
            result['WaitingCalls'] = self.waiting_calls
        if self.working_agents is not None:
            result['WorkingAgents'] = self.working_agents
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BreakingAgents') is not None:
            self.breaking_agents = m.get('BreakingAgents')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InteractiveCalls') is not None:
            self.interactive_calls = m.get('InteractiveCalls')
        if m.get('LoggedInAgents') is not None:
            self.logged_in_agents = m.get('LoggedInAgents')
        if m.get('LongestWaitingTime') is not None:
            self.longest_waiting_time = m.get('LongestWaitingTime')
        if m.get('ReadyAgents') is not None:
            self.ready_agents = m.get('ReadyAgents')
        if m.get('TalkingAgents') is not None:
            self.talking_agents = m.get('TalkingAgents')
        if m.get('TotalAgents') is not None:
            self.total_agents = m.get('TotalAgents')
        if m.get('WaitingCalls') is not None:
            self.waiting_calls = m.get('WaitingCalls')
        if m.get('WorkingAgents') is not None:
            self.working_agents = m.get('WorkingAgents')
        return self


class GetRealtimeInstanceStatesResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: GetRealtimeInstanceStatesResponseBodyData
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetRealtimeInstanceStatesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetRealtimeInstanceStatesResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetRealtimeInstanceStatesResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: GetRealtimeInstanceStatesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetRealtimeInstanceStatesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetRealtimeInstanceStatesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetTurnCredentialsRequest(TeaModel):
    def __init__(self, instance_id=None, user_id=None):
        self.instance_id = instance_id  # type: str
        self.user_id = user_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetTurnCredentialsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class GetTurnCredentialsResponseBodyData(TeaModel):
    def __init__(self, password=None, user_name=None):
        self.password = password  # type: str
        self.user_name = user_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetTurnCredentialsResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.password is not None:
            result['Password'] = self.password
        if self.user_name is not None:
            result['UserName'] = self.user_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Password') is not None:
            self.password = m.get('Password')
        if m.get('UserName') is not None:
            self.user_name = m.get('UserName')
        return self


class GetTurnCredentialsResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, params=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: GetTurnCredentialsResponseBodyData
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.params = params  # type: list[str]
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetTurnCredentialsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.params is not None:
            result['Params'] = self.params
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetTurnCredentialsResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Params') is not None:
            self.params = m.get('Params')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetTurnCredentialsResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: GetTurnCredentialsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetTurnCredentialsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetTurnCredentialsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetTurnServerListRequest(TeaModel):
    def __init__(self, instance_id=None):
        self.instance_id = instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetTurnServerListRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class GetTurnServerListResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, params=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: str
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.params = params  # type: list[str]
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetTurnServerListResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.params is not None:
            result['Params'] = self.params
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Params') is not None:
            self.params = m.get('Params')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetTurnServerListResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: GetTurnServerListResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetTurnServerListResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetTurnServerListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetUserRequest(TeaModel):
    def __init__(self, extension=None, instance_id=None, user_id=None):
        self.extension = extension  # type: str
        self.instance_id = instance_id  # type: str
        self.user_id = user_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetUserRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.extension is not None:
            result['Extension'] = self.extension
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Extension') is not None:
            self.extension = m.get('Extension')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class GetUserResponseBodyData(TeaModel):
    def __init__(self, device_ext=None, device_id=None, device_state=None, display_name=None, email=None,
                 extension=None, instance_id=None, login_name=None, mobile=None, role_id=None, role_name=None, user_id=None,
                 work_mode=None):
        self.device_ext = device_ext  # type: str
        self.device_id = device_id  # type: str
        self.device_state = device_state  # type: str
        self.display_name = display_name  # type: str
        self.email = email  # type: str
        self.extension = extension  # type: str
        self.instance_id = instance_id  # type: str
        self.login_name = login_name  # type: str
        self.mobile = mobile  # type: str
        self.role_id = role_id  # type: str
        self.role_name = role_name  # type: str
        self.user_id = user_id  # type: str
        self.work_mode = work_mode  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetUserResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_ext is not None:
            result['DeviceExt'] = self.device_ext
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.device_state is not None:
            result['DeviceState'] = self.device_state
        if self.display_name is not None:
            result['DisplayName'] = self.display_name
        if self.email is not None:
            result['Email'] = self.email
        if self.extension is not None:
            result['Extension'] = self.extension
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.login_name is not None:
            result['LoginName'] = self.login_name
        if self.mobile is not None:
            result['Mobile'] = self.mobile
        if self.role_id is not None:
            result['RoleId'] = self.role_id
        if self.role_name is not None:
            result['RoleName'] = self.role_name
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.work_mode is not None:
            result['WorkMode'] = self.work_mode
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeviceExt') is not None:
            self.device_ext = m.get('DeviceExt')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('DeviceState') is not None:
            self.device_state = m.get('DeviceState')
        if m.get('DisplayName') is not None:
            self.display_name = m.get('DisplayName')
        if m.get('Email') is not None:
            self.email = m.get('Email')
        if m.get('Extension') is not None:
            self.extension = m.get('Extension')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('LoginName') is not None:
            self.login_name = m.get('LoginName')
        if m.get('Mobile') is not None:
            self.mobile = m.get('Mobile')
        if m.get('RoleId') is not None:
            self.role_id = m.get('RoleId')
        if m.get('RoleName') is not None:
            self.role_name = m.get('RoleName')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('WorkMode') is not None:
            self.work_mode = m.get('WorkMode')
        return self


class GetUserResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, params=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: GetUserResponseBodyData
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.params = params  # type: list[str]
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetUserResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.params is not None:
            result['Params'] = self.params
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetUserResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Params') is not None:
            self.params = m.get('Params')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetUserResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: GetUserResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetUserResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetUserResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class HoldCallRequest(TeaModel):
    def __init__(self, channel_id=None, device_id=None, instance_id=None, job_id=None, music=None, user_id=None):
        self.channel_id = channel_id  # type: str
        self.device_id = device_id  # type: str
        self.instance_id = instance_id  # type: str
        self.job_id = job_id  # type: str
        self.music = music  # type: str
        self.user_id = user_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(HoldCallRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.channel_id is not None:
            result['ChannelId'] = self.channel_id
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.music is not None:
            result['Music'] = self.music
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ChannelId') is not None:
            self.channel_id = m.get('ChannelId')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('Music') is not None:
            self.music = m.get('Music')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class HoldCallResponseBodyDataCallContextChannelContexts(TeaModel):
    def __init__(self, associated_data=None, call_type=None, channel_id=None, channel_state=None, destination=None,
                 job_id=None, originator=None, release_initiator=None, release_reason=None, skill_group_id=None,
                 timestamp=None, user_extension=None, user_id=None):
        self.associated_data = associated_data  # type: dict[str, any]
        self.call_type = call_type  # type: str
        self.channel_id = channel_id  # type: str
        self.channel_state = channel_state  # type: str
        self.destination = destination  # type: str
        self.job_id = job_id  # type: str
        self.originator = originator  # type: str
        self.release_initiator = release_initiator  # type: str
        self.release_reason = release_reason  # type: str
        self.skill_group_id = skill_group_id  # type: str
        self.timestamp = timestamp  # type: long
        self.user_extension = user_extension  # type: str
        self.user_id = user_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(HoldCallResponseBodyDataCallContextChannelContexts, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.associated_data is not None:
            result['AssociatedData'] = self.associated_data
        if self.call_type is not None:
            result['CallType'] = self.call_type
        if self.channel_id is not None:
            result['ChannelId'] = self.channel_id
        if self.channel_state is not None:
            result['ChannelState'] = self.channel_state
        if self.destination is not None:
            result['Destination'] = self.destination
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.originator is not None:
            result['Originator'] = self.originator
        if self.release_initiator is not None:
            result['ReleaseInitiator'] = self.release_initiator
        if self.release_reason is not None:
            result['ReleaseReason'] = self.release_reason
        if self.skill_group_id is not None:
            result['SkillGroupId'] = self.skill_group_id
        if self.timestamp is not None:
            result['Timestamp'] = self.timestamp
        if self.user_extension is not None:
            result['UserExtension'] = self.user_extension
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AssociatedData') is not None:
            self.associated_data = m.get('AssociatedData')
        if m.get('CallType') is not None:
            self.call_type = m.get('CallType')
        if m.get('ChannelId') is not None:
            self.channel_id = m.get('ChannelId')
        if m.get('ChannelState') is not None:
            self.channel_state = m.get('ChannelState')
        if m.get('Destination') is not None:
            self.destination = m.get('Destination')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('Originator') is not None:
            self.originator = m.get('Originator')
        if m.get('ReleaseInitiator') is not None:
            self.release_initiator = m.get('ReleaseInitiator')
        if m.get('ReleaseReason') is not None:
            self.release_reason = m.get('ReleaseReason')
        if m.get('SkillGroupId') is not None:
            self.skill_group_id = m.get('SkillGroupId')
        if m.get('Timestamp') is not None:
            self.timestamp = m.get('Timestamp')
        if m.get('UserExtension') is not None:
            self.user_extension = m.get('UserExtension')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class HoldCallResponseBodyDataCallContext(TeaModel):
    def __init__(self, call_type=None, channel_contexts=None, instance_id=None, job_id=None):
        self.call_type = call_type  # type: str
        self.channel_contexts = channel_contexts  # type: list[HoldCallResponseBodyDataCallContextChannelContexts]
        self.instance_id = instance_id  # type: str
        self.job_id = job_id  # type: str

    def validate(self):
        if self.channel_contexts:
            for k in self.channel_contexts:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(HoldCallResponseBodyDataCallContext, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.call_type is not None:
            result['CallType'] = self.call_type
        result['ChannelContexts'] = []
        if self.channel_contexts is not None:
            for k in self.channel_contexts:
                result['ChannelContexts'].append(k.to_map() if k else None)
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CallType') is not None:
            self.call_type = m.get('CallType')
        self.channel_contexts = []
        if m.get('ChannelContexts') is not None:
            for k in m.get('ChannelContexts'):
                temp_model = HoldCallResponseBodyDataCallContextChannelContexts()
                self.channel_contexts.append(temp_model.from_map(k))
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class HoldCallResponseBodyDataUserContext(TeaModel):
    def __init__(self, break_code=None, device_id=None, extension=None, heartbeat=None, instance_id=None,
                 job_id=None, mobile=None, outbound_scenario=None, reserved=None, signed_skill_group_id_list=None,
                 user_id=None, user_state=None, work_mode=None):
        self.break_code = break_code  # type: str
        self.device_id = device_id  # type: str
        self.extension = extension  # type: str
        self.heartbeat = heartbeat  # type: long
        self.instance_id = instance_id  # type: str
        self.job_id = job_id  # type: str
        self.mobile = mobile  # type: str
        self.outbound_scenario = outbound_scenario  # type: bool
        self.reserved = reserved  # type: long
        self.signed_skill_group_id_list = signed_skill_group_id_list  # type: list[str]
        self.user_id = user_id  # type: str
        self.user_state = user_state  # type: str
        self.work_mode = work_mode  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(HoldCallResponseBodyDataUserContext, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.break_code is not None:
            result['BreakCode'] = self.break_code
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.extension is not None:
            result['Extension'] = self.extension
        if self.heartbeat is not None:
            result['Heartbeat'] = self.heartbeat
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.mobile is not None:
            result['Mobile'] = self.mobile
        if self.outbound_scenario is not None:
            result['OutboundScenario'] = self.outbound_scenario
        if self.reserved is not None:
            result['Reserved'] = self.reserved
        if self.signed_skill_group_id_list is not None:
            result['SignedSkillGroupIdList'] = self.signed_skill_group_id_list
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.user_state is not None:
            result['UserState'] = self.user_state
        if self.work_mode is not None:
            result['WorkMode'] = self.work_mode
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BreakCode') is not None:
            self.break_code = m.get('BreakCode')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('Extension') is not None:
            self.extension = m.get('Extension')
        if m.get('Heartbeat') is not None:
            self.heartbeat = m.get('Heartbeat')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('Mobile') is not None:
            self.mobile = m.get('Mobile')
        if m.get('OutboundScenario') is not None:
            self.outbound_scenario = m.get('OutboundScenario')
        if m.get('Reserved') is not None:
            self.reserved = m.get('Reserved')
        if m.get('SignedSkillGroupIdList') is not None:
            self.signed_skill_group_id_list = m.get('SignedSkillGroupIdList')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('UserState') is not None:
            self.user_state = m.get('UserState')
        if m.get('WorkMode') is not None:
            self.work_mode = m.get('WorkMode')
        return self


class HoldCallResponseBodyData(TeaModel):
    def __init__(self, call_context=None, user_context=None):
        self.call_context = call_context  # type: HoldCallResponseBodyDataCallContext
        self.user_context = user_context  # type: HoldCallResponseBodyDataUserContext

    def validate(self):
        if self.call_context:
            self.call_context.validate()
        if self.user_context:
            self.user_context.validate()

    def to_map(self):
        _map = super(HoldCallResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.call_context is not None:
            result['CallContext'] = self.call_context.to_map()
        if self.user_context is not None:
            result['UserContext'] = self.user_context.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CallContext') is not None:
            temp_model = HoldCallResponseBodyDataCallContext()
            self.call_context = temp_model.from_map(m['CallContext'])
        if m.get('UserContext') is not None:
            temp_model = HoldCallResponseBodyDataUserContext()
            self.user_context = temp_model.from_map(m['UserContext'])
        return self


class HoldCallResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, params=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: HoldCallResponseBodyData
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.params = params  # type: list[str]
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(HoldCallResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.params is not None:
            result['Params'] = self.params
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = HoldCallResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Params') is not None:
            self.params = m.get('Params')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class HoldCallResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: HoldCallResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(HoldCallResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = HoldCallResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class InitiateAttendedTransferRequest(TeaModel):
    def __init__(self, device_id=None, instance_id=None, job_id=None, timeout_seconds=None, transferee=None,
                 transferor=None, user_id=None):
        self.device_id = device_id  # type: str
        self.instance_id = instance_id  # type: str
        self.job_id = job_id  # type: str
        self.timeout_seconds = timeout_seconds  # type: int
        self.transferee = transferee  # type: str
        self.transferor = transferor  # type: str
        self.user_id = user_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(InitiateAttendedTransferRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.timeout_seconds is not None:
            result['TimeoutSeconds'] = self.timeout_seconds
        if self.transferee is not None:
            result['Transferee'] = self.transferee
        if self.transferor is not None:
            result['Transferor'] = self.transferor
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('TimeoutSeconds') is not None:
            self.timeout_seconds = m.get('TimeoutSeconds')
        if m.get('Transferee') is not None:
            self.transferee = m.get('Transferee')
        if m.get('Transferor') is not None:
            self.transferor = m.get('Transferor')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class InitiateAttendedTransferResponseBodyDataCallContextChannelContexts(TeaModel):
    def __init__(self, associated_data=None, call_type=None, channel_flags=None, channel_id=None,
                 channel_state=None, destination=None, index=None, job_id=None, originator=None, release_initiator=None,
                 release_reason=None, skill_group_id=None, timestamp=None, user_extension=None, user_id=None):
        self.associated_data = associated_data  # type: dict[str, any]
        self.call_type = call_type  # type: str
        self.channel_flags = channel_flags  # type: str
        self.channel_id = channel_id  # type: str
        self.channel_state = channel_state  # type: str
        self.destination = destination  # type: str
        self.index = index  # type: int
        self.job_id = job_id  # type: str
        self.originator = originator  # type: str
        self.release_initiator = release_initiator  # type: str
        self.release_reason = release_reason  # type: str
        self.skill_group_id = skill_group_id  # type: str
        self.timestamp = timestamp  # type: long
        self.user_extension = user_extension  # type: str
        self.user_id = user_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(InitiateAttendedTransferResponseBodyDataCallContextChannelContexts, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.associated_data is not None:
            result['AssociatedData'] = self.associated_data
        if self.call_type is not None:
            result['CallType'] = self.call_type
        if self.channel_flags is not None:
            result['ChannelFlags'] = self.channel_flags
        if self.channel_id is not None:
            result['ChannelId'] = self.channel_id
        if self.channel_state is not None:
            result['ChannelState'] = self.channel_state
        if self.destination is not None:
            result['Destination'] = self.destination
        if self.index is not None:
            result['Index'] = self.index
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.originator is not None:
            result['Originator'] = self.originator
        if self.release_initiator is not None:
            result['ReleaseInitiator'] = self.release_initiator
        if self.release_reason is not None:
            result['ReleaseReason'] = self.release_reason
        if self.skill_group_id is not None:
            result['SkillGroupId'] = self.skill_group_id
        if self.timestamp is not None:
            result['Timestamp'] = self.timestamp
        if self.user_extension is not None:
            result['UserExtension'] = self.user_extension
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AssociatedData') is not None:
            self.associated_data = m.get('AssociatedData')
        if m.get('CallType') is not None:
            self.call_type = m.get('CallType')
        if m.get('ChannelFlags') is not None:
            self.channel_flags = m.get('ChannelFlags')
        if m.get('ChannelId') is not None:
            self.channel_id = m.get('ChannelId')
        if m.get('ChannelState') is not None:
            self.channel_state = m.get('ChannelState')
        if m.get('Destination') is not None:
            self.destination = m.get('Destination')
        if m.get('Index') is not None:
            self.index = m.get('Index')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('Originator') is not None:
            self.originator = m.get('Originator')
        if m.get('ReleaseInitiator') is not None:
            self.release_initiator = m.get('ReleaseInitiator')
        if m.get('ReleaseReason') is not None:
            self.release_reason = m.get('ReleaseReason')
        if m.get('SkillGroupId') is not None:
            self.skill_group_id = m.get('SkillGroupId')
        if m.get('Timestamp') is not None:
            self.timestamp = m.get('Timestamp')
        if m.get('UserExtension') is not None:
            self.user_extension = m.get('UserExtension')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class InitiateAttendedTransferResponseBodyDataCallContext(TeaModel):
    def __init__(self, call_type=None, channel_contexts=None, instance_id=None, job_id=None):
        self.call_type = call_type  # type: str
        self.channel_contexts = channel_contexts  # type: list[InitiateAttendedTransferResponseBodyDataCallContextChannelContexts]
        self.instance_id = instance_id  # type: str
        self.job_id = job_id  # type: str

    def validate(self):
        if self.channel_contexts:
            for k in self.channel_contexts:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(InitiateAttendedTransferResponseBodyDataCallContext, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.call_type is not None:
            result['CallType'] = self.call_type
        result['ChannelContexts'] = []
        if self.channel_contexts is not None:
            for k in self.channel_contexts:
                result['ChannelContexts'].append(k.to_map() if k else None)
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CallType') is not None:
            self.call_type = m.get('CallType')
        self.channel_contexts = []
        if m.get('ChannelContexts') is not None:
            for k in m.get('ChannelContexts'):
                temp_model = InitiateAttendedTransferResponseBodyDataCallContextChannelContexts()
                self.channel_contexts.append(temp_model.from_map(k))
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class InitiateAttendedTransferResponseBodyDataUserContext(TeaModel):
    def __init__(self, break_code=None, device_id=None, extension=None, heartbeat=None, instance_id=None,
                 job_id=None, mobile=None, outbound_scenario=None, reserved=None, signed_skill_group_id_list=None,
                 user_id=None, user_state=None, work_mode=None):
        self.break_code = break_code  # type: str
        self.device_id = device_id  # type: str
        self.extension = extension  # type: str
        self.heartbeat = heartbeat  # type: long
        self.instance_id = instance_id  # type: str
        self.job_id = job_id  # type: str
        self.mobile = mobile  # type: str
        self.outbound_scenario = outbound_scenario  # type: bool
        self.reserved = reserved  # type: long
        self.signed_skill_group_id_list = signed_skill_group_id_list  # type: list[str]
        self.user_id = user_id  # type: str
        self.user_state = user_state  # type: str
        self.work_mode = work_mode  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(InitiateAttendedTransferResponseBodyDataUserContext, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.break_code is not None:
            result['BreakCode'] = self.break_code
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.extension is not None:
            result['Extension'] = self.extension
        if self.heartbeat is not None:
            result['Heartbeat'] = self.heartbeat
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.mobile is not None:
            result['Mobile'] = self.mobile
        if self.outbound_scenario is not None:
            result['OutboundScenario'] = self.outbound_scenario
        if self.reserved is not None:
            result['Reserved'] = self.reserved
        if self.signed_skill_group_id_list is not None:
            result['SignedSkillGroupIdList'] = self.signed_skill_group_id_list
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.user_state is not None:
            result['UserState'] = self.user_state
        if self.work_mode is not None:
            result['WorkMode'] = self.work_mode
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BreakCode') is not None:
            self.break_code = m.get('BreakCode')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('Extension') is not None:
            self.extension = m.get('Extension')
        if m.get('Heartbeat') is not None:
            self.heartbeat = m.get('Heartbeat')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('Mobile') is not None:
            self.mobile = m.get('Mobile')
        if m.get('OutboundScenario') is not None:
            self.outbound_scenario = m.get('OutboundScenario')
        if m.get('Reserved') is not None:
            self.reserved = m.get('Reserved')
        if m.get('SignedSkillGroupIdList') is not None:
            self.signed_skill_group_id_list = m.get('SignedSkillGroupIdList')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('UserState') is not None:
            self.user_state = m.get('UserState')
        if m.get('WorkMode') is not None:
            self.work_mode = m.get('WorkMode')
        return self


class InitiateAttendedTransferResponseBodyData(TeaModel):
    def __init__(self, call_context=None, context_id=None, user_context=None):
        self.call_context = call_context  # type: InitiateAttendedTransferResponseBodyDataCallContext
        self.context_id = context_id  # type: long
        self.user_context = user_context  # type: InitiateAttendedTransferResponseBodyDataUserContext

    def validate(self):
        if self.call_context:
            self.call_context.validate()
        if self.user_context:
            self.user_context.validate()

    def to_map(self):
        _map = super(InitiateAttendedTransferResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.call_context is not None:
            result['CallContext'] = self.call_context.to_map()
        if self.context_id is not None:
            result['ContextId'] = self.context_id
        if self.user_context is not None:
            result['UserContext'] = self.user_context.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CallContext') is not None:
            temp_model = InitiateAttendedTransferResponseBodyDataCallContext()
            self.call_context = temp_model.from_map(m['CallContext'])
        if m.get('ContextId') is not None:
            self.context_id = m.get('ContextId')
        if m.get('UserContext') is not None:
            temp_model = InitiateAttendedTransferResponseBodyDataUserContext()
            self.user_context = temp_model.from_map(m['UserContext'])
        return self


class InitiateAttendedTransferResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, params=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: InitiateAttendedTransferResponseBodyData
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.params = params  # type: list[str]
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(InitiateAttendedTransferResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.params is not None:
            result['Params'] = self.params
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = InitiateAttendedTransferResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Params') is not None:
            self.params = m.get('Params')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class InitiateAttendedTransferResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: InitiateAttendedTransferResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(InitiateAttendedTransferResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = InitiateAttendedTransferResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class InterceptCallRequest(TeaModel):
    def __init__(self, device_id=None, instance_id=None, intercepted_user_id=None, job_id=None,
                 timeout_seconds=None, user_id=None):
        self.device_id = device_id  # type: str
        self.instance_id = instance_id  # type: str
        self.intercepted_user_id = intercepted_user_id  # type: str
        self.job_id = job_id  # type: str
        self.timeout_seconds = timeout_seconds  # type: int
        self.user_id = user_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(InterceptCallRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.intercepted_user_id is not None:
            result['InterceptedUserId'] = self.intercepted_user_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.timeout_seconds is not None:
            result['TimeoutSeconds'] = self.timeout_seconds
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InterceptedUserId') is not None:
            self.intercepted_user_id = m.get('InterceptedUserId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('TimeoutSeconds') is not None:
            self.timeout_seconds = m.get('TimeoutSeconds')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class InterceptCallResponseBodyDataCallContextChannelContexts(TeaModel):
    def __init__(self, associated_data=None, call_type=None, channel_flags=None, channel_id=None,
                 channel_state=None, destination=None, index=None, job_id=None, originator=None, release_initiator=None,
                 release_reason=None, skill_group_id=None, timestamp=None, user_extension=None, user_id=None):
        self.associated_data = associated_data  # type: dict[str, any]
        self.call_type = call_type  # type: str
        self.channel_flags = channel_flags  # type: str
        self.channel_id = channel_id  # type: str
        self.channel_state = channel_state  # type: str
        self.destination = destination  # type: str
        self.index = index  # type: int
        self.job_id = job_id  # type: str
        self.originator = originator  # type: str
        self.release_initiator = release_initiator  # type: str
        self.release_reason = release_reason  # type: str
        self.skill_group_id = skill_group_id  # type: str
        self.timestamp = timestamp  # type: long
        self.user_extension = user_extension  # type: str
        self.user_id = user_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(InterceptCallResponseBodyDataCallContextChannelContexts, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.associated_data is not None:
            result['AssociatedData'] = self.associated_data
        if self.call_type is not None:
            result['CallType'] = self.call_type
        if self.channel_flags is not None:
            result['ChannelFlags'] = self.channel_flags
        if self.channel_id is not None:
            result['ChannelId'] = self.channel_id
        if self.channel_state is not None:
            result['ChannelState'] = self.channel_state
        if self.destination is not None:
            result['Destination'] = self.destination
        if self.index is not None:
            result['Index'] = self.index
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.originator is not None:
            result['Originator'] = self.originator
        if self.release_initiator is not None:
            result['ReleaseInitiator'] = self.release_initiator
        if self.release_reason is not None:
            result['ReleaseReason'] = self.release_reason
        if self.skill_group_id is not None:
            result['SkillGroupId'] = self.skill_group_id
        if self.timestamp is not None:
            result['Timestamp'] = self.timestamp
        if self.user_extension is not None:
            result['UserExtension'] = self.user_extension
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AssociatedData') is not None:
            self.associated_data = m.get('AssociatedData')
        if m.get('CallType') is not None:
            self.call_type = m.get('CallType')
        if m.get('ChannelFlags') is not None:
            self.channel_flags = m.get('ChannelFlags')
        if m.get('ChannelId') is not None:
            self.channel_id = m.get('ChannelId')
        if m.get('ChannelState') is not None:
            self.channel_state = m.get('ChannelState')
        if m.get('Destination') is not None:
            self.destination = m.get('Destination')
        if m.get('Index') is not None:
            self.index = m.get('Index')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('Originator') is not None:
            self.originator = m.get('Originator')
        if m.get('ReleaseInitiator') is not None:
            self.release_initiator = m.get('ReleaseInitiator')
        if m.get('ReleaseReason') is not None:
            self.release_reason = m.get('ReleaseReason')
        if m.get('SkillGroupId') is not None:
            self.skill_group_id = m.get('SkillGroupId')
        if m.get('Timestamp') is not None:
            self.timestamp = m.get('Timestamp')
        if m.get('UserExtension') is not None:
            self.user_extension = m.get('UserExtension')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class InterceptCallResponseBodyDataCallContext(TeaModel):
    def __init__(self, call_type=None, channel_contexts=None, instance_id=None, job_id=None):
        self.call_type = call_type  # type: str
        self.channel_contexts = channel_contexts  # type: list[InterceptCallResponseBodyDataCallContextChannelContexts]
        self.instance_id = instance_id  # type: str
        self.job_id = job_id  # type: str

    def validate(self):
        if self.channel_contexts:
            for k in self.channel_contexts:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(InterceptCallResponseBodyDataCallContext, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.call_type is not None:
            result['CallType'] = self.call_type
        result['ChannelContexts'] = []
        if self.channel_contexts is not None:
            for k in self.channel_contexts:
                result['ChannelContexts'].append(k.to_map() if k else None)
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CallType') is not None:
            self.call_type = m.get('CallType')
        self.channel_contexts = []
        if m.get('ChannelContexts') is not None:
            for k in m.get('ChannelContexts'):
                temp_model = InterceptCallResponseBodyDataCallContextChannelContexts()
                self.channel_contexts.append(temp_model.from_map(k))
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class InterceptCallResponseBodyDataUserContext(TeaModel):
    def __init__(self, break_code=None, device_id=None, extension=None, heartbeat=None, instance_id=None,
                 job_id=None, mobile=None, outbound_scenario=None, reserved=None, signed_skill_group_id_list=None,
                 user_id=None, user_state=None, work_mode=None):
        self.break_code = break_code  # type: str
        self.device_id = device_id  # type: str
        self.extension = extension  # type: str
        self.heartbeat = heartbeat  # type: long
        self.instance_id = instance_id  # type: str
        self.job_id = job_id  # type: str
        self.mobile = mobile  # type: str
        self.outbound_scenario = outbound_scenario  # type: bool
        self.reserved = reserved  # type: long
        self.signed_skill_group_id_list = signed_skill_group_id_list  # type: list[str]
        self.user_id = user_id  # type: str
        self.user_state = user_state  # type: str
        self.work_mode = work_mode  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(InterceptCallResponseBodyDataUserContext, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.break_code is not None:
            result['BreakCode'] = self.break_code
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.extension is not None:
            result['Extension'] = self.extension
        if self.heartbeat is not None:
            result['Heartbeat'] = self.heartbeat
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.mobile is not None:
            result['Mobile'] = self.mobile
        if self.outbound_scenario is not None:
            result['OutboundScenario'] = self.outbound_scenario
        if self.reserved is not None:
            result['Reserved'] = self.reserved
        if self.signed_skill_group_id_list is not None:
            result['SignedSkillGroupIdList'] = self.signed_skill_group_id_list
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.user_state is not None:
            result['UserState'] = self.user_state
        if self.work_mode is not None:
            result['WorkMode'] = self.work_mode
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BreakCode') is not None:
            self.break_code = m.get('BreakCode')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('Extension') is not None:
            self.extension = m.get('Extension')
        if m.get('Heartbeat') is not None:
            self.heartbeat = m.get('Heartbeat')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('Mobile') is not None:
            self.mobile = m.get('Mobile')
        if m.get('OutboundScenario') is not None:
            self.outbound_scenario = m.get('OutboundScenario')
        if m.get('Reserved') is not None:
            self.reserved = m.get('Reserved')
        if m.get('SignedSkillGroupIdList') is not None:
            self.signed_skill_group_id_list = m.get('SignedSkillGroupIdList')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('UserState') is not None:
            self.user_state = m.get('UserState')
        if m.get('WorkMode') is not None:
            self.work_mode = m.get('WorkMode')
        return self


class InterceptCallResponseBodyData(TeaModel):
    def __init__(self, call_context=None, user_context=None):
        self.call_context = call_context  # type: InterceptCallResponseBodyDataCallContext
        self.user_context = user_context  # type: InterceptCallResponseBodyDataUserContext

    def validate(self):
        if self.call_context:
            self.call_context.validate()
        if self.user_context:
            self.user_context.validate()

    def to_map(self):
        _map = super(InterceptCallResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.call_context is not None:
            result['CallContext'] = self.call_context.to_map()
        if self.user_context is not None:
            result['UserContext'] = self.user_context.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CallContext') is not None:
            temp_model = InterceptCallResponseBodyDataCallContext()
            self.call_context = temp_model.from_map(m['CallContext'])
        if m.get('UserContext') is not None:
            temp_model = InterceptCallResponseBodyDataUserContext()
            self.user_context = temp_model.from_map(m['UserContext'])
        return self


class InterceptCallResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, params=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: InterceptCallResponseBodyData
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.params = params  # type: list[str]
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(InterceptCallResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.params is not None:
            result['Params'] = self.params
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = InterceptCallResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Params') is not None:
            self.params = m.get('Params')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class InterceptCallResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: InterceptCallResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(InterceptCallResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = InterceptCallResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class LaunchAuthenticationRequest(TeaModel):
    def __init__(self, contact_flow_id=None, device_id=None, instance_id=None, job_id=None, user_id=None):
        self.contact_flow_id = contact_flow_id  # type: str
        self.device_id = device_id  # type: str
        self.instance_id = instance_id  # type: str
        self.job_id = job_id  # type: str
        self.user_id = user_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(LaunchAuthenticationRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.contact_flow_id is not None:
            result['ContactFlowId'] = self.contact_flow_id
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ContactFlowId') is not None:
            self.contact_flow_id = m.get('ContactFlowId')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class LaunchAuthenticationResponseBodyDataCallContextChannelContexts(TeaModel):
    def __init__(self, associated_data=None, call_type=None, channel_flags=None, channel_id=None,
                 channel_state=None, destination=None, index=None, job_id=None, originator=None, release_initiator=None,
                 release_reason=None, skill_group_id=None, timestamp=None, user_extension=None, user_id=None):
        self.associated_data = associated_data  # type: dict[str, any]
        self.call_type = call_type  # type: str
        self.channel_flags = channel_flags  # type: str
        self.channel_id = channel_id  # type: str
        self.channel_state = channel_state  # type: str
        self.destination = destination  # type: str
        self.index = index  # type: int
        self.job_id = job_id  # type: str
        self.originator = originator  # type: str
        self.release_initiator = release_initiator  # type: str
        self.release_reason = release_reason  # type: str
        self.skill_group_id = skill_group_id  # type: str
        self.timestamp = timestamp  # type: long
        self.user_extension = user_extension  # type: str
        self.user_id = user_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(LaunchAuthenticationResponseBodyDataCallContextChannelContexts, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.associated_data is not None:
            result['AssociatedData'] = self.associated_data
        if self.call_type is not None:
            result['CallType'] = self.call_type
        if self.channel_flags is not None:
            result['ChannelFlags'] = self.channel_flags
        if self.channel_id is not None:
            result['ChannelId'] = self.channel_id
        if self.channel_state is not None:
            result['ChannelState'] = self.channel_state
        if self.destination is not None:
            result['Destination'] = self.destination
        if self.index is not None:
            result['Index'] = self.index
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.originator is not None:
            result['Originator'] = self.originator
        if self.release_initiator is not None:
            result['ReleaseInitiator'] = self.release_initiator
        if self.release_reason is not None:
            result['ReleaseReason'] = self.release_reason
        if self.skill_group_id is not None:
            result['SkillGroupId'] = self.skill_group_id
        if self.timestamp is not None:
            result['Timestamp'] = self.timestamp
        if self.user_extension is not None:
            result['UserExtension'] = self.user_extension
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AssociatedData') is not None:
            self.associated_data = m.get('AssociatedData')
        if m.get('CallType') is not None:
            self.call_type = m.get('CallType')
        if m.get('ChannelFlags') is not None:
            self.channel_flags = m.get('ChannelFlags')
        if m.get('ChannelId') is not None:
            self.channel_id = m.get('ChannelId')
        if m.get('ChannelState') is not None:
            self.channel_state = m.get('ChannelState')
        if m.get('Destination') is not None:
            self.destination = m.get('Destination')
        if m.get('Index') is not None:
            self.index = m.get('Index')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('Originator') is not None:
            self.originator = m.get('Originator')
        if m.get('ReleaseInitiator') is not None:
            self.release_initiator = m.get('ReleaseInitiator')
        if m.get('ReleaseReason') is not None:
            self.release_reason = m.get('ReleaseReason')
        if m.get('SkillGroupId') is not None:
            self.skill_group_id = m.get('SkillGroupId')
        if m.get('Timestamp') is not None:
            self.timestamp = m.get('Timestamp')
        if m.get('UserExtension') is not None:
            self.user_extension = m.get('UserExtension')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class LaunchAuthenticationResponseBodyDataCallContext(TeaModel):
    def __init__(self, call_type=None, channel_contexts=None, instance_id=None, job_id=None):
        self.call_type = call_type  # type: str
        self.channel_contexts = channel_contexts  # type: list[LaunchAuthenticationResponseBodyDataCallContextChannelContexts]
        self.instance_id = instance_id  # type: str
        self.job_id = job_id  # type: str

    def validate(self):
        if self.channel_contexts:
            for k in self.channel_contexts:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(LaunchAuthenticationResponseBodyDataCallContext, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.call_type is not None:
            result['CallType'] = self.call_type
        result['ChannelContexts'] = []
        if self.channel_contexts is not None:
            for k in self.channel_contexts:
                result['ChannelContexts'].append(k.to_map() if k else None)
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CallType') is not None:
            self.call_type = m.get('CallType')
        self.channel_contexts = []
        if m.get('ChannelContexts') is not None:
            for k in m.get('ChannelContexts'):
                temp_model = LaunchAuthenticationResponseBodyDataCallContextChannelContexts()
                self.channel_contexts.append(temp_model.from_map(k))
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class LaunchAuthenticationResponseBodyDataUserContext(TeaModel):
    def __init__(self, break_code=None, device_id=None, extension=None, heartbeat=None, instance_id=None,
                 job_id=None, mobile=None, outbound_scenario=None, reserved=None, signed_skill_group_id_list=None,
                 user_id=None, user_state=None, work_mode=None):
        self.break_code = break_code  # type: str
        self.device_id = device_id  # type: str
        self.extension = extension  # type: str
        self.heartbeat = heartbeat  # type: long
        self.instance_id = instance_id  # type: str
        self.job_id = job_id  # type: str
        self.mobile = mobile  # type: str
        self.outbound_scenario = outbound_scenario  # type: bool
        self.reserved = reserved  # type: long
        self.signed_skill_group_id_list = signed_skill_group_id_list  # type: list[str]
        self.user_id = user_id  # type: str
        self.user_state = user_state  # type: str
        self.work_mode = work_mode  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(LaunchAuthenticationResponseBodyDataUserContext, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.break_code is not None:
            result['BreakCode'] = self.break_code
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.extension is not None:
            result['Extension'] = self.extension
        if self.heartbeat is not None:
            result['Heartbeat'] = self.heartbeat
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.mobile is not None:
            result['Mobile'] = self.mobile
        if self.outbound_scenario is not None:
            result['OutboundScenario'] = self.outbound_scenario
        if self.reserved is not None:
            result['Reserved'] = self.reserved
        if self.signed_skill_group_id_list is not None:
            result['SignedSkillGroupIdList'] = self.signed_skill_group_id_list
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.user_state is not None:
            result['UserState'] = self.user_state
        if self.work_mode is not None:
            result['WorkMode'] = self.work_mode
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BreakCode') is not None:
            self.break_code = m.get('BreakCode')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('Extension') is not None:
            self.extension = m.get('Extension')
        if m.get('Heartbeat') is not None:
            self.heartbeat = m.get('Heartbeat')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('Mobile') is not None:
            self.mobile = m.get('Mobile')
        if m.get('OutboundScenario') is not None:
            self.outbound_scenario = m.get('OutboundScenario')
        if m.get('Reserved') is not None:
            self.reserved = m.get('Reserved')
        if m.get('SignedSkillGroupIdList') is not None:
            self.signed_skill_group_id_list = m.get('SignedSkillGroupIdList')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('UserState') is not None:
            self.user_state = m.get('UserState')
        if m.get('WorkMode') is not None:
            self.work_mode = m.get('WorkMode')
        return self


class LaunchAuthenticationResponseBodyData(TeaModel):
    def __init__(self, call_context=None, user_context=None):
        self.call_context = call_context  # type: LaunchAuthenticationResponseBodyDataCallContext
        self.user_context = user_context  # type: LaunchAuthenticationResponseBodyDataUserContext

    def validate(self):
        if self.call_context:
            self.call_context.validate()
        if self.user_context:
            self.user_context.validate()

    def to_map(self):
        _map = super(LaunchAuthenticationResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.call_context is not None:
            result['CallContext'] = self.call_context.to_map()
        if self.user_context is not None:
            result['UserContext'] = self.user_context.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CallContext') is not None:
            temp_model = LaunchAuthenticationResponseBodyDataCallContext()
            self.call_context = temp_model.from_map(m['CallContext'])
        if m.get('UserContext') is not None:
            temp_model = LaunchAuthenticationResponseBodyDataUserContext()
            self.user_context = temp_model.from_map(m['UserContext'])
        return self


class LaunchAuthenticationResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, params=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: LaunchAuthenticationResponseBodyData
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.params = params  # type: list[str]
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(LaunchAuthenticationResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.params is not None:
            result['Params'] = self.params
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = LaunchAuthenticationResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Params') is not None:
            self.params = m.get('Params')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class LaunchAuthenticationResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: LaunchAuthenticationResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(LaunchAuthenticationResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = LaunchAuthenticationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class LaunchSurveyRequest(TeaModel):
    def __init__(self, contact_flow_id=None, device_id=None, instance_id=None, job_id=None, user_id=None):
        self.contact_flow_id = contact_flow_id  # type: str
        self.device_id = device_id  # type: str
        self.instance_id = instance_id  # type: str
        self.job_id = job_id  # type: str
        self.user_id = user_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(LaunchSurveyRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.contact_flow_id is not None:
            result['ContactFlowId'] = self.contact_flow_id
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ContactFlowId') is not None:
            self.contact_flow_id = m.get('ContactFlowId')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class LaunchSurveyResponseBodyDataCallContextChannelContexts(TeaModel):
    def __init__(self, associated_data=None, call_type=None, channel_flags=None, channel_id=None,
                 channel_state=None, destination=None, index=None, job_id=None, originator=None, release_initiator=None,
                 release_reason=None, skill_group_id=None, timestamp=None, user_extension=None, user_id=None):
        self.associated_data = associated_data  # type: dict[str, any]
        self.call_type = call_type  # type: str
        self.channel_flags = channel_flags  # type: str
        self.channel_id = channel_id  # type: str
        self.channel_state = channel_state  # type: str
        self.destination = destination  # type: str
        self.index = index  # type: int
        self.job_id = job_id  # type: str
        self.originator = originator  # type: str
        self.release_initiator = release_initiator  # type: str
        self.release_reason = release_reason  # type: str
        self.skill_group_id = skill_group_id  # type: str
        self.timestamp = timestamp  # type: long
        self.user_extension = user_extension  # type: str
        self.user_id = user_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(LaunchSurveyResponseBodyDataCallContextChannelContexts, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.associated_data is not None:
            result['AssociatedData'] = self.associated_data
        if self.call_type is not None:
            result['CallType'] = self.call_type
        if self.channel_flags is not None:
            result['ChannelFlags'] = self.channel_flags
        if self.channel_id is not None:
            result['ChannelId'] = self.channel_id
        if self.channel_state is not None:
            result['ChannelState'] = self.channel_state
        if self.destination is not None:
            result['Destination'] = self.destination
        if self.index is not None:
            result['Index'] = self.index
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.originator is not None:
            result['Originator'] = self.originator
        if self.release_initiator is not None:
            result['ReleaseInitiator'] = self.release_initiator
        if self.release_reason is not None:
            result['ReleaseReason'] = self.release_reason
        if self.skill_group_id is not None:
            result['SkillGroupId'] = self.skill_group_id
        if self.timestamp is not None:
            result['Timestamp'] = self.timestamp
        if self.user_extension is not None:
            result['UserExtension'] = self.user_extension
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AssociatedData') is not None:
            self.associated_data = m.get('AssociatedData')
        if m.get('CallType') is not None:
            self.call_type = m.get('CallType')
        if m.get('ChannelFlags') is not None:
            self.channel_flags = m.get('ChannelFlags')
        if m.get('ChannelId') is not None:
            self.channel_id = m.get('ChannelId')
        if m.get('ChannelState') is not None:
            self.channel_state = m.get('ChannelState')
        if m.get('Destination') is not None:
            self.destination = m.get('Destination')
        if m.get('Index') is not None:
            self.index = m.get('Index')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('Originator') is not None:
            self.originator = m.get('Originator')
        if m.get('ReleaseInitiator') is not None:
            self.release_initiator = m.get('ReleaseInitiator')
        if m.get('ReleaseReason') is not None:
            self.release_reason = m.get('ReleaseReason')
        if m.get('SkillGroupId') is not None:
            self.skill_group_id = m.get('SkillGroupId')
        if m.get('Timestamp') is not None:
            self.timestamp = m.get('Timestamp')
        if m.get('UserExtension') is not None:
            self.user_extension = m.get('UserExtension')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class LaunchSurveyResponseBodyDataCallContext(TeaModel):
    def __init__(self, call_type=None, channel_contexts=None, instance_id=None, job_id=None):
        self.call_type = call_type  # type: str
        self.channel_contexts = channel_contexts  # type: list[LaunchSurveyResponseBodyDataCallContextChannelContexts]
        self.instance_id = instance_id  # type: str
        self.job_id = job_id  # type: str

    def validate(self):
        if self.channel_contexts:
            for k in self.channel_contexts:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(LaunchSurveyResponseBodyDataCallContext, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.call_type is not None:
            result['CallType'] = self.call_type
        result['ChannelContexts'] = []
        if self.channel_contexts is not None:
            for k in self.channel_contexts:
                result['ChannelContexts'].append(k.to_map() if k else None)
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CallType') is not None:
            self.call_type = m.get('CallType')
        self.channel_contexts = []
        if m.get('ChannelContexts') is not None:
            for k in m.get('ChannelContexts'):
                temp_model = LaunchSurveyResponseBodyDataCallContextChannelContexts()
                self.channel_contexts.append(temp_model.from_map(k))
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class LaunchSurveyResponseBodyDataUserContext(TeaModel):
    def __init__(self, break_code=None, device_id=None, extension=None, heartbeat=None, instance_id=None,
                 job_id=None, mobile=None, outbound_scenario=None, reserved=None, signed_skill_group_id_list=None,
                 user_id=None, user_state=None, work_mode=None):
        self.break_code = break_code  # type: str
        self.device_id = device_id  # type: str
        self.extension = extension  # type: str
        self.heartbeat = heartbeat  # type: long
        self.instance_id = instance_id  # type: str
        self.job_id = job_id  # type: str
        self.mobile = mobile  # type: str
        self.outbound_scenario = outbound_scenario  # type: bool
        self.reserved = reserved  # type: long
        self.signed_skill_group_id_list = signed_skill_group_id_list  # type: list[str]
        self.user_id = user_id  # type: str
        self.user_state = user_state  # type: str
        self.work_mode = work_mode  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(LaunchSurveyResponseBodyDataUserContext, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.break_code is not None:
            result['BreakCode'] = self.break_code
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.extension is not None:
            result['Extension'] = self.extension
        if self.heartbeat is not None:
            result['Heartbeat'] = self.heartbeat
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.mobile is not None:
            result['Mobile'] = self.mobile
        if self.outbound_scenario is not None:
            result['OutboundScenario'] = self.outbound_scenario
        if self.reserved is not None:
            result['Reserved'] = self.reserved
        if self.signed_skill_group_id_list is not None:
            result['SignedSkillGroupIdList'] = self.signed_skill_group_id_list
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.user_state is not None:
            result['UserState'] = self.user_state
        if self.work_mode is not None:
            result['WorkMode'] = self.work_mode
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BreakCode') is not None:
            self.break_code = m.get('BreakCode')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('Extension') is not None:
            self.extension = m.get('Extension')
        if m.get('Heartbeat') is not None:
            self.heartbeat = m.get('Heartbeat')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('Mobile') is not None:
            self.mobile = m.get('Mobile')
        if m.get('OutboundScenario') is not None:
            self.outbound_scenario = m.get('OutboundScenario')
        if m.get('Reserved') is not None:
            self.reserved = m.get('Reserved')
        if m.get('SignedSkillGroupIdList') is not None:
            self.signed_skill_group_id_list = m.get('SignedSkillGroupIdList')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('UserState') is not None:
            self.user_state = m.get('UserState')
        if m.get('WorkMode') is not None:
            self.work_mode = m.get('WorkMode')
        return self


class LaunchSurveyResponseBodyData(TeaModel):
    def __init__(self, call_context=None, user_context=None):
        self.call_context = call_context  # type: LaunchSurveyResponseBodyDataCallContext
        self.user_context = user_context  # type: LaunchSurveyResponseBodyDataUserContext

    def validate(self):
        if self.call_context:
            self.call_context.validate()
        if self.user_context:
            self.user_context.validate()

    def to_map(self):
        _map = super(LaunchSurveyResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.call_context is not None:
            result['CallContext'] = self.call_context.to_map()
        if self.user_context is not None:
            result['UserContext'] = self.user_context.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CallContext') is not None:
            temp_model = LaunchSurveyResponseBodyDataCallContext()
            self.call_context = temp_model.from_map(m['CallContext'])
        if m.get('UserContext') is not None:
            temp_model = LaunchSurveyResponseBodyDataUserContext()
            self.user_context = temp_model.from_map(m['UserContext'])
        return self


class LaunchSurveyResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, params=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: LaunchSurveyResponseBodyData
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.params = params  # type: list[str]
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(LaunchSurveyResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.params is not None:
            result['Params'] = self.params
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = LaunchSurveyResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Params') is not None:
            self.params = m.get('Params')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class LaunchSurveyResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: LaunchSurveyResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(LaunchSurveyResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = LaunchSurveyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListAgentStateLogsRequest(TeaModel):
    def __init__(self, agent_id=None, end_time=None, instance_id=None, start_time=None):
        self.agent_id = agent_id  # type: str
        self.end_time = end_time  # type: long
        self.instance_id = instance_id  # type: str
        self.start_time = start_time  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListAgentStateLogsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_id is not None:
            result['AgentId'] = self.agent_id
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AgentId') is not None:
            self.agent_id = m.get('AgentId')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class ListAgentStateLogsResponseBodyData(TeaModel):
    def __init__(self, duration=None, start_time=None, state=None, state_code=None):
        self.duration = duration  # type: long
        self.start_time = start_time  # type: long
        self.state = state  # type: str
        self.state_code = state_code  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListAgentStateLogsResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.state is not None:
            result['State'] = self.state
        if self.state_code is not None:
            result['StateCode'] = self.state_code
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('StateCode') is not None:
            self.state_code = m.get('StateCode')
        return self


class ListAgentStateLogsResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: list[ListAgentStateLogsResponseBodyData]
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListAgentStateLogsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = ListAgentStateLogsResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListAgentStateLogsResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ListAgentStateLogsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListAgentStateLogsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListAgentStateLogsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListAttemptsRequest(TeaModel):
    def __init__(self, agent_id=None, attempt_id=None, callee=None, caller=None, campaign_id=None, case_id=None,
                 contact_id=None, end_time=None, instance_id=None, page_number=None, page_size=None, queue_id=None,
                 start_time=None):
        # 坐席ID
        self.agent_id = agent_id  # type: str
        # 记录ID
        self.attempt_id = attempt_id  # type: str
        # 被叫
        self.callee = callee  # type: str
        # 主叫
        self.caller = caller  # type: str
        # 活动ID
        self.campaign_id = campaign_id  # type: str
        # CaseID
        self.case_id = case_id  # type: str
        # 话务ID
        self.contact_id = contact_id  # type: str
        # 结束时间
        self.end_time = end_time  # type: long
        # 实例ID
        self.instance_id = instance_id  # type: str
        # 页码
        self.page_number = page_number  # type: int
        # 页大小
        self.page_size = page_size  # type: int
        # 队列ID
        self.queue_id = queue_id  # type: str
        # 开始时间
        self.start_time = start_time  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListAttemptsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_id is not None:
            result['AgentId'] = self.agent_id
        if self.attempt_id is not None:
            result['AttemptId'] = self.attempt_id
        if self.callee is not None:
            result['Callee'] = self.callee
        if self.caller is not None:
            result['Caller'] = self.caller
        if self.campaign_id is not None:
            result['CampaignId'] = self.campaign_id
        if self.case_id is not None:
            result['CaseId'] = self.case_id
        if self.contact_id is not None:
            result['ContactId'] = self.contact_id
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.queue_id is not None:
            result['QueueId'] = self.queue_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AgentId') is not None:
            self.agent_id = m.get('AgentId')
        if m.get('AttemptId') is not None:
            self.attempt_id = m.get('AttemptId')
        if m.get('Callee') is not None:
            self.callee = m.get('Callee')
        if m.get('Caller') is not None:
            self.caller = m.get('Caller')
        if m.get('CampaignId') is not None:
            self.campaign_id = m.get('CampaignId')
        if m.get('CaseId') is not None:
            self.case_id = m.get('CaseId')
        if m.get('ContactId') is not None:
            self.contact_id = m.get('ContactId')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('QueueId') is not None:
            self.queue_id = m.get('QueueId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class ListAttemptsResponseBodyDataList(TeaModel):
    def __init__(self, agent_established_time=None, agent_id=None, agent_ring_duration=None,
                 assign_agent_time=None, attempt_id=None, callee=None, caller=None, campaign_id=None, case_id=None, contact_id=None,
                 customer_established_time=None, customer_released_time=None, dial_duration=None, dial_time=None, enqueue_time=None,
                 enter_ivr_time=None, instance_id=None, ivr_duration=None, queue_duration=None, queue_id=None):
        self.agent_established_time = agent_established_time  # type: long
        self.agent_id = agent_id  # type: str
        self.agent_ring_duration = agent_ring_duration  # type: long
        self.assign_agent_time = assign_agent_time  # type: long
        self.attempt_id = attempt_id  # type: str
        self.callee = callee  # type: str
        self.caller = caller  # type: str
        self.campaign_id = campaign_id  # type: str
        self.case_id = case_id  # type: str
        self.contact_id = contact_id  # type: str
        self.customer_established_time = customer_established_time  # type: long
        self.customer_released_time = customer_released_time  # type: long
        self.dial_duration = dial_duration  # type: long
        self.dial_time = dial_time  # type: long
        self.enqueue_time = enqueue_time  # type: long
        self.enter_ivr_time = enter_ivr_time  # type: long
        self.instance_id = instance_id  # type: str
        self.ivr_duration = ivr_duration  # type: long
        self.queue_duration = queue_duration  # type: long
        self.queue_id = queue_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListAttemptsResponseBodyDataList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_established_time is not None:
            result['AgentEstablishedTime'] = self.agent_established_time
        if self.agent_id is not None:
            result['AgentId'] = self.agent_id
        if self.agent_ring_duration is not None:
            result['AgentRingDuration'] = self.agent_ring_duration
        if self.assign_agent_time is not None:
            result['AssignAgentTime'] = self.assign_agent_time
        if self.attempt_id is not None:
            result['AttemptId'] = self.attempt_id
        if self.callee is not None:
            result['Callee'] = self.callee
        if self.caller is not None:
            result['Caller'] = self.caller
        if self.campaign_id is not None:
            result['CampaignId'] = self.campaign_id
        if self.case_id is not None:
            result['CaseId'] = self.case_id
        if self.contact_id is not None:
            result['ContactId'] = self.contact_id
        if self.customer_established_time is not None:
            result['CustomerEstablishedTime'] = self.customer_established_time
        if self.customer_released_time is not None:
            result['CustomerReleasedTime'] = self.customer_released_time
        if self.dial_duration is not None:
            result['DialDuration'] = self.dial_duration
        if self.dial_time is not None:
            result['DialTime'] = self.dial_time
        if self.enqueue_time is not None:
            result['EnqueueTime'] = self.enqueue_time
        if self.enter_ivr_time is not None:
            result['EnterIvrTime'] = self.enter_ivr_time
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.ivr_duration is not None:
            result['IvrDuration'] = self.ivr_duration
        if self.queue_duration is not None:
            result['QueueDuration'] = self.queue_duration
        if self.queue_id is not None:
            result['QueueId'] = self.queue_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AgentEstablishedTime') is not None:
            self.agent_established_time = m.get('AgentEstablishedTime')
        if m.get('AgentId') is not None:
            self.agent_id = m.get('AgentId')
        if m.get('AgentRingDuration') is not None:
            self.agent_ring_duration = m.get('AgentRingDuration')
        if m.get('AssignAgentTime') is not None:
            self.assign_agent_time = m.get('AssignAgentTime')
        if m.get('AttemptId') is not None:
            self.attempt_id = m.get('AttemptId')
        if m.get('Callee') is not None:
            self.callee = m.get('Callee')
        if m.get('Caller') is not None:
            self.caller = m.get('Caller')
        if m.get('CampaignId') is not None:
            self.campaign_id = m.get('CampaignId')
        if m.get('CaseId') is not None:
            self.case_id = m.get('CaseId')
        if m.get('ContactId') is not None:
            self.contact_id = m.get('ContactId')
        if m.get('CustomerEstablishedTime') is not None:
            self.customer_established_time = m.get('CustomerEstablishedTime')
        if m.get('CustomerReleasedTime') is not None:
            self.customer_released_time = m.get('CustomerReleasedTime')
        if m.get('DialDuration') is not None:
            self.dial_duration = m.get('DialDuration')
        if m.get('DialTime') is not None:
            self.dial_time = m.get('DialTime')
        if m.get('EnqueueTime') is not None:
            self.enqueue_time = m.get('EnqueueTime')
        if m.get('EnterIvrTime') is not None:
            self.enter_ivr_time = m.get('EnterIvrTime')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('IvrDuration') is not None:
            self.ivr_duration = m.get('IvrDuration')
        if m.get('QueueDuration') is not None:
            self.queue_duration = m.get('QueueDuration')
        if m.get('QueueId') is not None:
            self.queue_id = m.get('QueueId')
        return self


class ListAttemptsResponseBodyData(TeaModel):
    def __init__(self, list=None, page_number=None, page_size=None, total_count=None):
        self.list = list  # type: list[ListAttemptsResponseBodyDataList]
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.total_count = total_count  # type: int

    def validate(self):
        if self.list:
            for k in self.list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListAttemptsResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['List'] = []
        if self.list is not None:
            for k in self.list:
                result['List'].append(k.to_map() if k else None)
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.list = []
        if m.get('List') is not None:
            for k in m.get('List'):
                temp_model = ListAttemptsResponseBodyDataList()
                self.list.append(temp_model.from_map(k))
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListAttemptsResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: ListAttemptsResponseBodyData
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(ListAttemptsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = ListAttemptsResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListAttemptsResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ListAttemptsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListAttemptsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListAttemptsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListBriefSkillGroupsRequest(TeaModel):
    def __init__(self, instance_id=None, page_number=None, page_size=None, search_pattern=None):
        self.instance_id = instance_id  # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.search_pattern = search_pattern  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListBriefSkillGroupsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.search_pattern is not None:
            result['SearchPattern'] = self.search_pattern
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('SearchPattern') is not None:
            self.search_pattern = m.get('SearchPattern')
        return self


class ListBriefSkillGroupsResponseBodyDataList(TeaModel):
    def __init__(self, description=None, display_name=None, instance_id=None, phone_number_count=None,
                 skill_group_id=None, skill_group_name=None, user_count=None):
        self.description = description  # type: str
        self.display_name = display_name  # type: str
        self.instance_id = instance_id  # type: str
        self.phone_number_count = phone_number_count  # type: int
        self.skill_group_id = skill_group_id  # type: str
        self.skill_group_name = skill_group_name  # type: str
        self.user_count = user_count  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListBriefSkillGroupsResponseBodyDataList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.display_name is not None:
            result['DisplayName'] = self.display_name
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.phone_number_count is not None:
            result['PhoneNumberCount'] = self.phone_number_count
        if self.skill_group_id is not None:
            result['SkillGroupId'] = self.skill_group_id
        if self.skill_group_name is not None:
            result['SkillGroupName'] = self.skill_group_name
        if self.user_count is not None:
            result['UserCount'] = self.user_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DisplayName') is not None:
            self.display_name = m.get('DisplayName')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PhoneNumberCount') is not None:
            self.phone_number_count = m.get('PhoneNumberCount')
        if m.get('SkillGroupId') is not None:
            self.skill_group_id = m.get('SkillGroupId')
        if m.get('SkillGroupName') is not None:
            self.skill_group_name = m.get('SkillGroupName')
        if m.get('UserCount') is not None:
            self.user_count = m.get('UserCount')
        return self


class ListBriefSkillGroupsResponseBodyData(TeaModel):
    def __init__(self, list=None, page_number=None, page_size=None, total_count=None):
        self.list = list  # type: list[ListBriefSkillGroupsResponseBodyDataList]
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.total_count = total_count  # type: int

    def validate(self):
        if self.list:
            for k in self.list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListBriefSkillGroupsResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['List'] = []
        if self.list is not None:
            for k in self.list:
                result['List'].append(k.to_map() if k else None)
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.list = []
        if m.get('List') is not None:
            for k in m.get('List'):
                temp_model = ListBriefSkillGroupsResponseBodyDataList()
                self.list.append(temp_model.from_map(k))
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListBriefSkillGroupsResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: ListBriefSkillGroupsResponseBodyData
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(ListBriefSkillGroupsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = ListBriefSkillGroupsResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListBriefSkillGroupsResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ListBriefSkillGroupsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListBriefSkillGroupsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListBriefSkillGroupsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListCallDetailRecordsRequest(TeaModel):
    def __init__(self, agent_id=None, called_number=None, calling_number=None, contact_disposition=None,
                 contact_id=None, contact_type=None, criteria=None, early_media_state_list=None, end_time=None,
                 instance_id=None, order_by_field=None, page_number=None, page_size=None, satisfaction_description_list=None,
                 satisfaction_list=None, satisfaction_survey_channel=None, skill_group_id=None, sort_order=None, start_time=None):
        self.agent_id = agent_id  # type: str
        self.called_number = called_number  # type: str
        self.calling_number = calling_number  # type: str
        self.contact_disposition = contact_disposition  # type: str
        self.contact_id = contact_id  # type: str
        self.contact_type = contact_type  # type: str
        self.criteria = criteria  # type: str
        self.early_media_state_list = early_media_state_list  # type: str
        self.end_time = end_time  # type: long
        self.instance_id = instance_id  # type: str
        self.order_by_field = order_by_field  # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.satisfaction_description_list = satisfaction_description_list  # type: str
        self.satisfaction_list = satisfaction_list  # type: str
        self.satisfaction_survey_channel = satisfaction_survey_channel  # type: str
        self.skill_group_id = skill_group_id  # type: str
        self.sort_order = sort_order  # type: str
        self.start_time = start_time  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListCallDetailRecordsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_id is not None:
            result['AgentId'] = self.agent_id
        if self.called_number is not None:
            result['CalledNumber'] = self.called_number
        if self.calling_number is not None:
            result['CallingNumber'] = self.calling_number
        if self.contact_disposition is not None:
            result['ContactDisposition'] = self.contact_disposition
        if self.contact_id is not None:
            result['ContactId'] = self.contact_id
        if self.contact_type is not None:
            result['ContactType'] = self.contact_type
        if self.criteria is not None:
            result['Criteria'] = self.criteria
        if self.early_media_state_list is not None:
            result['EarlyMediaStateList'] = self.early_media_state_list
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.order_by_field is not None:
            result['OrderByField'] = self.order_by_field
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.satisfaction_description_list is not None:
            result['SatisfactionDescriptionList'] = self.satisfaction_description_list
        if self.satisfaction_list is not None:
            result['SatisfactionList'] = self.satisfaction_list
        if self.satisfaction_survey_channel is not None:
            result['SatisfactionSurveyChannel'] = self.satisfaction_survey_channel
        if self.skill_group_id is not None:
            result['SkillGroupId'] = self.skill_group_id
        if self.sort_order is not None:
            result['SortOrder'] = self.sort_order
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AgentId') is not None:
            self.agent_id = m.get('AgentId')
        if m.get('CalledNumber') is not None:
            self.called_number = m.get('CalledNumber')
        if m.get('CallingNumber') is not None:
            self.calling_number = m.get('CallingNumber')
        if m.get('ContactDisposition') is not None:
            self.contact_disposition = m.get('ContactDisposition')
        if m.get('ContactId') is not None:
            self.contact_id = m.get('ContactId')
        if m.get('ContactType') is not None:
            self.contact_type = m.get('ContactType')
        if m.get('Criteria') is not None:
            self.criteria = m.get('Criteria')
        if m.get('EarlyMediaStateList') is not None:
            self.early_media_state_list = m.get('EarlyMediaStateList')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('OrderByField') is not None:
            self.order_by_field = m.get('OrderByField')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('SatisfactionDescriptionList') is not None:
            self.satisfaction_description_list = m.get('SatisfactionDescriptionList')
        if m.get('SatisfactionList') is not None:
            self.satisfaction_list = m.get('SatisfactionList')
        if m.get('SatisfactionSurveyChannel') is not None:
            self.satisfaction_survey_channel = m.get('SatisfactionSurveyChannel')
        if m.get('SkillGroupId') is not None:
            self.skill_group_id = m.get('SkillGroupId')
        if m.get('SortOrder') is not None:
            self.sort_order = m.get('SortOrder')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class ListCallDetailRecordsResponseBodyDataList(TeaModel):
    def __init__(self, additional_broker=None, agent_ids=None, agent_names=None, broker=None, call_duration=None,
                 called_number=None, callee_location=None, caller_location=None, calling_number=None, contact_disposition=None,
                 contact_id=None, contact_type=None, early_media_state=None, established_time=None, instance_id=None,
                 ivr_time=None, queue_time=None, recording_duration=None, recording_ready=None, release_initiator=None,
                 release_time=None, ring_time=None, satisfaction_description=None, satisfaction_index=None,
                 satisfaction_survey_channel=None, satisfaction_survey_offered=None, skill_group_ids=None, skill_group_names=None,
                 start_time=None, wait_time=None):
        self.additional_broker = additional_broker  # type: str
        self.agent_ids = agent_ids  # type: str
        self.agent_names = agent_names  # type: str
        self.broker = broker  # type: str
        self.call_duration = call_duration  # type: str
        self.called_number = called_number  # type: str
        self.callee_location = callee_location  # type: str
        self.caller_location = caller_location  # type: str
        self.calling_number = calling_number  # type: str
        self.contact_disposition = contact_disposition  # type: str
        self.contact_id = contact_id  # type: str
        self.contact_type = contact_type  # type: str
        self.early_media_state = early_media_state  # type: str
        self.established_time = established_time  # type: long
        self.instance_id = instance_id  # type: str
        self.ivr_time = ivr_time  # type: long
        self.queue_time = queue_time  # type: long
        self.recording_duration = recording_duration  # type: long
        self.recording_ready = recording_ready  # type: bool
        self.release_initiator = release_initiator  # type: str
        self.release_time = release_time  # type: long
        self.ring_time = ring_time  # type: long
        self.satisfaction_description = satisfaction_description  # type: str
        self.satisfaction_index = satisfaction_index  # type: int
        self.satisfaction_survey_channel = satisfaction_survey_channel  # type: str
        self.satisfaction_survey_offered = satisfaction_survey_offered  # type: bool
        self.skill_group_ids = skill_group_ids  # type: str
        self.skill_group_names = skill_group_names  # type: str
        self.start_time = start_time  # type: long
        self.wait_time = wait_time  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListCallDetailRecordsResponseBodyDataList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.additional_broker is not None:
            result['AdditionalBroker'] = self.additional_broker
        if self.agent_ids is not None:
            result['AgentIds'] = self.agent_ids
        if self.agent_names is not None:
            result['AgentNames'] = self.agent_names
        if self.broker is not None:
            result['Broker'] = self.broker
        if self.call_duration is not None:
            result['CallDuration'] = self.call_duration
        if self.called_number is not None:
            result['CalledNumber'] = self.called_number
        if self.callee_location is not None:
            result['CalleeLocation'] = self.callee_location
        if self.caller_location is not None:
            result['CallerLocation'] = self.caller_location
        if self.calling_number is not None:
            result['CallingNumber'] = self.calling_number
        if self.contact_disposition is not None:
            result['ContactDisposition'] = self.contact_disposition
        if self.contact_id is not None:
            result['ContactId'] = self.contact_id
        if self.contact_type is not None:
            result['ContactType'] = self.contact_type
        if self.early_media_state is not None:
            result['EarlyMediaState'] = self.early_media_state
        if self.established_time is not None:
            result['EstablishedTime'] = self.established_time
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.ivr_time is not None:
            result['IvrTime'] = self.ivr_time
        if self.queue_time is not None:
            result['QueueTime'] = self.queue_time
        if self.recording_duration is not None:
            result['RecordingDuration'] = self.recording_duration
        if self.recording_ready is not None:
            result['RecordingReady'] = self.recording_ready
        if self.release_initiator is not None:
            result['ReleaseInitiator'] = self.release_initiator
        if self.release_time is not None:
            result['ReleaseTime'] = self.release_time
        if self.ring_time is not None:
            result['RingTime'] = self.ring_time
        if self.satisfaction_description is not None:
            result['SatisfactionDescription'] = self.satisfaction_description
        if self.satisfaction_index is not None:
            result['SatisfactionIndex'] = self.satisfaction_index
        if self.satisfaction_survey_channel is not None:
            result['SatisfactionSurveyChannel'] = self.satisfaction_survey_channel
        if self.satisfaction_survey_offered is not None:
            result['SatisfactionSurveyOffered'] = self.satisfaction_survey_offered
        if self.skill_group_ids is not None:
            result['SkillGroupIds'] = self.skill_group_ids
        if self.skill_group_names is not None:
            result['SkillGroupNames'] = self.skill_group_names
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.wait_time is not None:
            result['WaitTime'] = self.wait_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AdditionalBroker') is not None:
            self.additional_broker = m.get('AdditionalBroker')
        if m.get('AgentIds') is not None:
            self.agent_ids = m.get('AgentIds')
        if m.get('AgentNames') is not None:
            self.agent_names = m.get('AgentNames')
        if m.get('Broker') is not None:
            self.broker = m.get('Broker')
        if m.get('CallDuration') is not None:
            self.call_duration = m.get('CallDuration')
        if m.get('CalledNumber') is not None:
            self.called_number = m.get('CalledNumber')
        if m.get('CalleeLocation') is not None:
            self.callee_location = m.get('CalleeLocation')
        if m.get('CallerLocation') is not None:
            self.caller_location = m.get('CallerLocation')
        if m.get('CallingNumber') is not None:
            self.calling_number = m.get('CallingNumber')
        if m.get('ContactDisposition') is not None:
            self.contact_disposition = m.get('ContactDisposition')
        if m.get('ContactId') is not None:
            self.contact_id = m.get('ContactId')
        if m.get('ContactType') is not None:
            self.contact_type = m.get('ContactType')
        if m.get('EarlyMediaState') is not None:
            self.early_media_state = m.get('EarlyMediaState')
        if m.get('EstablishedTime') is not None:
            self.established_time = m.get('EstablishedTime')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('IvrTime') is not None:
            self.ivr_time = m.get('IvrTime')
        if m.get('QueueTime') is not None:
            self.queue_time = m.get('QueueTime')
        if m.get('RecordingDuration') is not None:
            self.recording_duration = m.get('RecordingDuration')
        if m.get('RecordingReady') is not None:
            self.recording_ready = m.get('RecordingReady')
        if m.get('ReleaseInitiator') is not None:
            self.release_initiator = m.get('ReleaseInitiator')
        if m.get('ReleaseTime') is not None:
            self.release_time = m.get('ReleaseTime')
        if m.get('RingTime') is not None:
            self.ring_time = m.get('RingTime')
        if m.get('SatisfactionDescription') is not None:
            self.satisfaction_description = m.get('SatisfactionDescription')
        if m.get('SatisfactionIndex') is not None:
            self.satisfaction_index = m.get('SatisfactionIndex')
        if m.get('SatisfactionSurveyChannel') is not None:
            self.satisfaction_survey_channel = m.get('SatisfactionSurveyChannel')
        if m.get('SatisfactionSurveyOffered') is not None:
            self.satisfaction_survey_offered = m.get('SatisfactionSurveyOffered')
        if m.get('SkillGroupIds') is not None:
            self.skill_group_ids = m.get('SkillGroupIds')
        if m.get('SkillGroupNames') is not None:
            self.skill_group_names = m.get('SkillGroupNames')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('WaitTime') is not None:
            self.wait_time = m.get('WaitTime')
        return self


class ListCallDetailRecordsResponseBodyData(TeaModel):
    def __init__(self, list=None, page_number=None, page_size=None, total_count=None):
        self.list = list  # type: list[ListCallDetailRecordsResponseBodyDataList]
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.total_count = total_count  # type: int

    def validate(self):
        if self.list:
            for k in self.list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListCallDetailRecordsResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['List'] = []
        if self.list is not None:
            for k in self.list:
                result['List'].append(k.to_map() if k else None)
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.list = []
        if m.get('List') is not None:
            for k in m.get('List'):
                temp_model = ListCallDetailRecordsResponseBodyDataList()
                self.list.append(temp_model.from_map(k))
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListCallDetailRecordsResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: ListCallDetailRecordsResponseBodyData
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(ListCallDetailRecordsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = ListCallDetailRecordsResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListCallDetailRecordsResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ListCallDetailRecordsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListCallDetailRecordsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListCallDetailRecordsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListCampaignTrendingReportRequest(TeaModel):
    def __init__(self, campaign_id=None, end_time=None, instance_id=None, start_time=None):
        # 活动ID
        self.campaign_id = campaign_id  # type: str
        # 结束时间
        self.end_time = end_time  # type: long
        # 实例ID
        self.instance_id = instance_id  # type: str
        # 开始时间
        self.start_time = start_time  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListCampaignTrendingReportRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.campaign_id is not None:
            result['CampaignId'] = self.campaign_id
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CampaignId') is not None:
            self.campaign_id = m.get('CampaignId')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class ListCampaignTrendingReportResponseBodyData(TeaModel):
    def __init__(self, break_agents=None, concurrency=None, datetime=None, logged_in_agents=None, ready_agents=None,
                 talk_agents=None, work_agents=None):
        self.break_agents = break_agents  # type: long
        self.concurrency = concurrency  # type: long
        self.datetime = datetime  # type: long
        self.logged_in_agents = logged_in_agents  # type: long
        self.ready_agents = ready_agents  # type: long
        self.talk_agents = talk_agents  # type: long
        self.work_agents = work_agents  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListCampaignTrendingReportResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.break_agents is not None:
            result['BreakAgents'] = self.break_agents
        if self.concurrency is not None:
            result['Concurrency'] = self.concurrency
        if self.datetime is not None:
            result['Datetime'] = self.datetime
        if self.logged_in_agents is not None:
            result['LoggedInAgents'] = self.logged_in_agents
        if self.ready_agents is not None:
            result['ReadyAgents'] = self.ready_agents
        if self.talk_agents is not None:
            result['TalkAgents'] = self.talk_agents
        if self.work_agents is not None:
            result['WorkAgents'] = self.work_agents
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BreakAgents') is not None:
            self.break_agents = m.get('BreakAgents')
        if m.get('Concurrency') is not None:
            self.concurrency = m.get('Concurrency')
        if m.get('Datetime') is not None:
            self.datetime = m.get('Datetime')
        if m.get('LoggedInAgents') is not None:
            self.logged_in_agents = m.get('LoggedInAgents')
        if m.get('ReadyAgents') is not None:
            self.ready_agents = m.get('ReadyAgents')
        if m.get('TalkAgents') is not None:
            self.talk_agents = m.get('TalkAgents')
        if m.get('WorkAgents') is not None:
            self.work_agents = m.get('WorkAgents')
        return self


class ListCampaignTrendingReportResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: list[ListCampaignTrendingReportResponseBodyData]
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListCampaignTrendingReportResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = ListCampaignTrendingReportResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListCampaignTrendingReportResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ListCampaignTrendingReportResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListCampaignTrendingReportResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListCampaignTrendingReportResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListCampaignsRequest(TeaModel):
    def __init__(self, actual_start_time_from=None, actual_start_time_to=None, instance_id=None, name=None,
                 page_number=None, page_size=None, planed_start_time_from=None, planed_start_time_to=None, queue_id=None,
                 state=None):
        self.actual_start_time_from = actual_start_time_from  # type: str
        self.actual_start_time_to = actual_start_time_to  # type: str
        self.instance_id = instance_id  # type: str
        self.name = name  # type: str
        self.page_number = page_number  # type: long
        self.page_size = page_size  # type: long
        self.planed_start_time_from = planed_start_time_from  # type: str
        self.planed_start_time_to = planed_start_time_to  # type: str
        self.queue_id = queue_id  # type: str
        self.state = state  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListCampaignsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.actual_start_time_from is not None:
            result['ActualStartTimeFrom'] = self.actual_start_time_from
        if self.actual_start_time_to is not None:
            result['ActualStartTimeTo'] = self.actual_start_time_to
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.name is not None:
            result['Name'] = self.name
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.planed_start_time_from is not None:
            result['PlanedStartTimeFrom'] = self.planed_start_time_from
        if self.planed_start_time_to is not None:
            result['PlanedStartTimeTo'] = self.planed_start_time_to
        if self.queue_id is not None:
            result['QueueId'] = self.queue_id
        if self.state is not None:
            result['State'] = self.state
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ActualStartTimeFrom') is not None:
            self.actual_start_time_from = m.get('ActualStartTimeFrom')
        if m.get('ActualStartTimeTo') is not None:
            self.actual_start_time_to = m.get('ActualStartTimeTo')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PlanedStartTimeFrom') is not None:
            self.planed_start_time_from = m.get('PlanedStartTimeFrom')
        if m.get('PlanedStartTimeTo') is not None:
            self.planed_start_time_to = m.get('PlanedStartTimeTo')
        if m.get('QueueId') is not None:
            self.queue_id = m.get('QueueId')
        if m.get('State') is not None:
            self.state = m.get('State')
        return self


class ListCampaignsResponseBodyDataList(TeaModel):
    def __init__(self, actual_end_time=None, actual_start_time=None, campaign_id=None, cases_aborted=None,
                 cases_connected=None, cases_uncompleted=None, max_attempt_count=None, min_attempt_interval=None, name=None,
                 planed_end_time=None, planed_start_time=None, queue_id=None, queue_name=None, simulation=None, state=None,
                 strategy_parameters=None, strategy_type=None, total_cases=None):
        self.actual_end_time = actual_end_time  # type: long
        self.actual_start_time = actual_start_time  # type: long
        # id
        self.campaign_id = campaign_id  # type: str
        self.cases_aborted = cases_aborted  # type: long
        self.cases_connected = cases_connected  # type: long
        self.cases_uncompleted = cases_uncompleted  # type: long
        self.max_attempt_count = max_attempt_count  # type: long
        self.min_attempt_interval = min_attempt_interval  # type: long
        self.name = name  # type: str
        self.planed_end_time = planed_end_time  # type: long
        self.planed_start_time = planed_start_time  # type: long
        self.queue_id = queue_id  # type: str
        self.queue_name = queue_name  # type: str
        self.simulation = simulation  # type: bool
        # state
        self.state = state  # type: str
        self.strategy_parameters = strategy_parameters  # type: str
        self.strategy_type = strategy_type  # type: str
        self.total_cases = total_cases  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListCampaignsResponseBodyDataList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.actual_end_time is not None:
            result['ActualEndTime'] = self.actual_end_time
        if self.actual_start_time is not None:
            result['ActualStartTime'] = self.actual_start_time
        if self.campaign_id is not None:
            result['CampaignId'] = self.campaign_id
        if self.cases_aborted is not None:
            result['CasesAborted'] = self.cases_aborted
        if self.cases_connected is not None:
            result['CasesConnected'] = self.cases_connected
        if self.cases_uncompleted is not None:
            result['CasesUncompleted'] = self.cases_uncompleted
        if self.max_attempt_count is not None:
            result['MaxAttemptCount'] = self.max_attempt_count
        if self.min_attempt_interval is not None:
            result['MinAttemptInterval'] = self.min_attempt_interval
        if self.name is not None:
            result['Name'] = self.name
        if self.planed_end_time is not None:
            result['PlanedEndTime'] = self.planed_end_time
        if self.planed_start_time is not None:
            result['PlanedStartTime'] = self.planed_start_time
        if self.queue_id is not None:
            result['QueueId'] = self.queue_id
        if self.queue_name is not None:
            result['QueueName'] = self.queue_name
        if self.simulation is not None:
            result['Simulation'] = self.simulation
        if self.state is not None:
            result['State'] = self.state
        if self.strategy_parameters is not None:
            result['StrategyParameters'] = self.strategy_parameters
        if self.strategy_type is not None:
            result['StrategyType'] = self.strategy_type
        if self.total_cases is not None:
            result['TotalCases'] = self.total_cases
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ActualEndTime') is not None:
            self.actual_end_time = m.get('ActualEndTime')
        if m.get('ActualStartTime') is not None:
            self.actual_start_time = m.get('ActualStartTime')
        if m.get('CampaignId') is not None:
            self.campaign_id = m.get('CampaignId')
        if m.get('CasesAborted') is not None:
            self.cases_aborted = m.get('CasesAborted')
        if m.get('CasesConnected') is not None:
            self.cases_connected = m.get('CasesConnected')
        if m.get('CasesUncompleted') is not None:
            self.cases_uncompleted = m.get('CasesUncompleted')
        if m.get('MaxAttemptCount') is not None:
            self.max_attempt_count = m.get('MaxAttemptCount')
        if m.get('MinAttemptInterval') is not None:
            self.min_attempt_interval = m.get('MinAttemptInterval')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PlanedEndTime') is not None:
            self.planed_end_time = m.get('PlanedEndTime')
        if m.get('PlanedStartTime') is not None:
            self.planed_start_time = m.get('PlanedStartTime')
        if m.get('QueueId') is not None:
            self.queue_id = m.get('QueueId')
        if m.get('QueueName') is not None:
            self.queue_name = m.get('QueueName')
        if m.get('Simulation') is not None:
            self.simulation = m.get('Simulation')
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('StrategyParameters') is not None:
            self.strategy_parameters = m.get('StrategyParameters')
        if m.get('StrategyType') is not None:
            self.strategy_type = m.get('StrategyType')
        if m.get('TotalCases') is not None:
            self.total_cases = m.get('TotalCases')
        return self


class ListCampaignsResponseBodyData(TeaModel):
    def __init__(self, list=None, page_number=None, page_size=None, total_count=None):
        self.list = list  # type: list[ListCampaignsResponseBodyDataList]
        self.page_number = page_number  # type: long
        self.page_size = page_size  # type: long
        self.total_count = total_count  # type: long

    def validate(self):
        if self.list:
            for k in self.list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListCampaignsResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['List'] = []
        if self.list is not None:
            for k in self.list:
                result['List'].append(k.to_map() if k else None)
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.list = []
        if m.get('List') is not None:
            for k in m.get('List'):
                temp_model = ListCampaignsResponseBodyDataList()
                self.list.append(temp_model.from_map(k))
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListCampaignsResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: ListCampaignsResponseBodyData
        self.http_status_code = http_status_code  # type: long
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(ListCampaignsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = ListCampaignsResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ListCampaignsResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ListCampaignsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListCampaignsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListCampaignsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListCasesRequest(TeaModel):
    def __init__(self, campaign_id=None, instance_id=None, page_number=None, page_size=None, phone_number=None):
        self.campaign_id = campaign_id  # type: str
        self.instance_id = instance_id  # type: str
        self.page_number = page_number  # type: long
        self.page_size = page_size  # type: long
        self.phone_number = phone_number  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListCasesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.campaign_id is not None:
            result['CampaignId'] = self.campaign_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.phone_number is not None:
            result['PhoneNumber'] = self.phone_number
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CampaignId') is not None:
            self.campaign_id = m.get('CampaignId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PhoneNumber') is not None:
            self.phone_number = m.get('PhoneNumber')
        return self


class ListCasesResponseBodyDataList(TeaModel):
    def __init__(self, abandon_type=None, attempt_count=None, case_id=None, custom_variables=None, expand_info=None,
                 failure_reason=None, phone_number=None, state=None):
        self.abandon_type = abandon_type  # type: str
        self.attempt_count = attempt_count  # type: long
        self.case_id = case_id  # type: str
        self.custom_variables = custom_variables  # type: str
        self.expand_info = expand_info  # type: str
        self.failure_reason = failure_reason  # type: str
        self.phone_number = phone_number  # type: str
        self.state = state  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListCasesResponseBodyDataList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.abandon_type is not None:
            result['AbandonType'] = self.abandon_type
        if self.attempt_count is not None:
            result['AttemptCount'] = self.attempt_count
        if self.case_id is not None:
            result['CaseId'] = self.case_id
        if self.custom_variables is not None:
            result['CustomVariables'] = self.custom_variables
        if self.expand_info is not None:
            result['ExpandInfo'] = self.expand_info
        if self.failure_reason is not None:
            result['FailureReason'] = self.failure_reason
        if self.phone_number is not None:
            result['PhoneNumber'] = self.phone_number
        if self.state is not None:
            result['State'] = self.state
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AbandonType') is not None:
            self.abandon_type = m.get('AbandonType')
        if m.get('AttemptCount') is not None:
            self.attempt_count = m.get('AttemptCount')
        if m.get('CaseId') is not None:
            self.case_id = m.get('CaseId')
        if m.get('CustomVariables') is not None:
            self.custom_variables = m.get('CustomVariables')
        if m.get('ExpandInfo') is not None:
            self.expand_info = m.get('ExpandInfo')
        if m.get('FailureReason') is not None:
            self.failure_reason = m.get('FailureReason')
        if m.get('PhoneNumber') is not None:
            self.phone_number = m.get('PhoneNumber')
        if m.get('State') is not None:
            self.state = m.get('State')
        return self


class ListCasesResponseBodyData(TeaModel):
    def __init__(self, list=None, page_number=None, page_size=None, total_count=None):
        self.list = list  # type: list[ListCasesResponseBodyDataList]
        self.page_number = page_number  # type: long
        self.page_size = page_size  # type: long
        self.total_count = total_count  # type: long

    def validate(self):
        if self.list:
            for k in self.list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListCasesResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['List'] = []
        if self.list is not None:
            for k in self.list:
                result['List'].append(k.to_map() if k else None)
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.list = []
        if m.get('List') is not None:
            for k in m.get('List'):
                temp_model = ListCasesResponseBodyDataList()
                self.list.append(temp_model.from_map(k))
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListCasesResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        # data
        self.data = data  # type: ListCasesResponseBodyData
        self.http_status_code = http_status_code  # type: long
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(ListCasesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = ListCasesResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ListCasesResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ListCasesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListCasesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListCasesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListConfigItemsRequest(TeaModel):
    def __init__(self, instance_id=None, object_id=None, object_type=None):
        self.instance_id = instance_id  # type: str
        self.object_id = object_id  # type: str
        self.object_type = object_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListConfigItemsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.object_id is not None:
            result['ObjectId'] = self.object_id
        if self.object_type is not None:
            result['ObjectType'] = self.object_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ObjectId') is not None:
            self.object_id = m.get('ObjectId')
        if m.get('ObjectType') is not None:
            self.object_type = m.get('ObjectType')
        return self


class ListConfigItemsResponseBodyData(TeaModel):
    def __init__(self, instance_id=None, name=None, object_id=None, object_type=None, value=None):
        self.instance_id = instance_id  # type: str
        self.name = name  # type: str
        self.object_id = object_id  # type: str
        self.object_type = object_type  # type: str
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListConfigItemsResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.name is not None:
            result['Name'] = self.name
        if self.object_id is not None:
            result['ObjectId'] = self.object_id
        if self.object_type is not None:
            result['ObjectType'] = self.object_type
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('ObjectId') is not None:
            self.object_id = m.get('ObjectId')
        if m.get('ObjectType') is not None:
            self.object_type = m.get('ObjectType')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class ListConfigItemsResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, params=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: list[ListConfigItemsResponseBodyData]
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.params = params  # type: list[str]
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListConfigItemsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.params is not None:
            result['Params'] = self.params
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = ListConfigItemsResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Params') is not None:
            self.params = m.get('Params')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListConfigItemsResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ListConfigItemsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListConfigItemsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListConfigItemsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListContactFlowsRequest(TeaModel):
    def __init__(self, instance_id=None, page_number=None, page_size=None, type=None):
        self.instance_id = instance_id  # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListContactFlowsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class ListContactFlowsResponseBodyDataList(TeaModel):
    def __init__(self, contact_flow_id=None, created_time=None, definition=None, description=None, draft_id=None,
                 editor=None, instance_id=None, name=None, number_list=None, published=None, type=None, updated_time=None):
        self.contact_flow_id = contact_flow_id  # type: str
        self.created_time = created_time  # type: str
        self.definition = definition  # type: str
        self.description = description  # type: str
        self.draft_id = draft_id  # type: str
        self.editor = editor  # type: str
        self.instance_id = instance_id  # type: str
        self.name = name  # type: str
        self.number_list = number_list  # type: list[str]
        self.published = published  # type: bool
        self.type = type  # type: str
        self.updated_time = updated_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListContactFlowsResponseBodyDataList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.contact_flow_id is not None:
            result['ContactFlowId'] = self.contact_flow_id
        if self.created_time is not None:
            result['CreatedTime'] = self.created_time
        if self.definition is not None:
            result['Definition'] = self.definition
        if self.description is not None:
            result['Description'] = self.description
        if self.draft_id is not None:
            result['DraftId'] = self.draft_id
        if self.editor is not None:
            result['Editor'] = self.editor
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.name is not None:
            result['Name'] = self.name
        if self.number_list is not None:
            result['NumberList'] = self.number_list
        if self.published is not None:
            result['Published'] = self.published
        if self.type is not None:
            result['Type'] = self.type
        if self.updated_time is not None:
            result['UpdatedTime'] = self.updated_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ContactFlowId') is not None:
            self.contact_flow_id = m.get('ContactFlowId')
        if m.get('CreatedTime') is not None:
            self.created_time = m.get('CreatedTime')
        if m.get('Definition') is not None:
            self.definition = m.get('Definition')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DraftId') is not None:
            self.draft_id = m.get('DraftId')
        if m.get('Editor') is not None:
            self.editor = m.get('Editor')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('NumberList') is not None:
            self.number_list = m.get('NumberList')
        if m.get('Published') is not None:
            self.published = m.get('Published')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('UpdatedTime') is not None:
            self.updated_time = m.get('UpdatedTime')
        return self


class ListContactFlowsResponseBodyData(TeaModel):
    def __init__(self, list=None, page_number=None, page_size=None, total_count=None):
        self.list = list  # type: list[ListContactFlowsResponseBodyDataList]
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.total_count = total_count  # type: int

    def validate(self):
        if self.list:
            for k in self.list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListContactFlowsResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['List'] = []
        if self.list is not None:
            for k in self.list:
                result['List'].append(k.to_map() if k else None)
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.list = []
        if m.get('List') is not None:
            for k in m.get('List'):
                temp_model = ListContactFlowsResponseBodyDataList()
                self.list.append(temp_model.from_map(k))
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListContactFlowsResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: ListContactFlowsResponseBodyData
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(ListContactFlowsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = ListContactFlowsResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListContactFlowsResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ListContactFlowsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListContactFlowsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListContactFlowsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListDevicesRequest(TeaModel):
    def __init__(self, instance_id=None, user_id=None):
        self.instance_id = instance_id  # type: str
        self.user_id = user_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListDevicesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class ListDevicesResponseBodyData(TeaModel):
    def __init__(self, call_id=None, contact=None, device_id=None, expires=None, extension=None, instance_id=None,
                 user_id=None):
        self.call_id = call_id  # type: str
        self.contact = contact  # type: str
        self.device_id = device_id  # type: str
        self.expires = expires  # type: long
        self.extension = extension  # type: str
        self.instance_id = instance_id  # type: str
        self.user_id = user_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListDevicesResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.call_id is not None:
            result['CallId'] = self.call_id
        if self.contact is not None:
            result['Contact'] = self.contact
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.expires is not None:
            result['Expires'] = self.expires
        if self.extension is not None:
            result['Extension'] = self.extension
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CallId') is not None:
            self.call_id = m.get('CallId')
        if m.get('Contact') is not None:
            self.contact = m.get('Contact')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('Expires') is not None:
            self.expires = m.get('Expires')
        if m.get('Extension') is not None:
            self.extension = m.get('Extension')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class ListDevicesResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, params=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: list[ListDevicesResponseBodyData]
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.params = params  # type: list[str]
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListDevicesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.params is not None:
            result['Params'] = self.params
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = ListDevicesResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Params') is not None:
            self.params = m.get('Params')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListDevicesResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ListDevicesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListDevicesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListDevicesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListHistoricalAgentReportRequest(TeaModel):
    def __init__(self, agent_id_list=None, instance_id=None, page_number=None, page_size=None, start_time=None,
                 stop_time=None):
        self.agent_id_list = agent_id_list  # type: str
        self.instance_id = instance_id  # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.start_time = start_time  # type: long
        self.stop_time = stop_time  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListHistoricalAgentReportRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_id_list is not None:
            result['AgentIdList'] = self.agent_id_list
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.stop_time is not None:
            result['StopTime'] = self.stop_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AgentIdList') is not None:
            self.agent_id_list = m.get('AgentIdList')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('StopTime') is not None:
            self.stop_time = m.get('StopTime')
        return self


class ListHistoricalAgentReportResponseBodyDataListInbound(TeaModel):
    def __init__(self, average_hold_time=None, average_ring_time=None, average_talk_time=None,
                 average_work_time=None, calls_attended_transfer_in=None, calls_attended_transfer_out=None,
                 calls_blind_transfer_in=None, calls_blind_transfer_out=None, calls_handled=None, calls_hold=None, calls_offered=None,
                 calls_ringed=None, handle_rate=None, max_hold_time=None, max_ring_time=None, max_talk_time=None,
                 max_work_time=None, satisfaction_index=None, satisfaction_rate=None, satisfaction_surveys_offered=None,
                 satisfaction_surveys_responded=None, total_hold_time=None, total_ring_time=None, total_talk_time=None, total_work_time=None):
        self.average_hold_time = average_hold_time  # type: float
        self.average_ring_time = average_ring_time  # type: float
        self.average_talk_time = average_talk_time  # type: float
        self.average_work_time = average_work_time  # type: float
        self.calls_attended_transfer_in = calls_attended_transfer_in  # type: long
        self.calls_attended_transfer_out = calls_attended_transfer_out  # type: long
        self.calls_blind_transfer_in = calls_blind_transfer_in  # type: long
        self.calls_blind_transfer_out = calls_blind_transfer_out  # type: long
        self.calls_handled = calls_handled  # type: long
        self.calls_hold = calls_hold  # type: long
        self.calls_offered = calls_offered  # type: long
        self.calls_ringed = calls_ringed  # type: long
        self.handle_rate = handle_rate  # type: float
        self.max_hold_time = max_hold_time  # type: long
        self.max_ring_time = max_ring_time  # type: long
        self.max_talk_time = max_talk_time  # type: long
        self.max_work_time = max_work_time  # type: long
        self.satisfaction_index = satisfaction_index  # type: float
        self.satisfaction_rate = satisfaction_rate  # type: float
        self.satisfaction_surveys_offered = satisfaction_surveys_offered  # type: long
        self.satisfaction_surveys_responded = satisfaction_surveys_responded  # type: long
        self.total_hold_time = total_hold_time  # type: long
        self.total_ring_time = total_ring_time  # type: long
        self.total_talk_time = total_talk_time  # type: long
        self.total_work_time = total_work_time  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListHistoricalAgentReportResponseBodyDataListInbound, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.average_hold_time is not None:
            result['AverageHoldTime'] = self.average_hold_time
        if self.average_ring_time is not None:
            result['AverageRingTime'] = self.average_ring_time
        if self.average_talk_time is not None:
            result['AverageTalkTime'] = self.average_talk_time
        if self.average_work_time is not None:
            result['AverageWorkTime'] = self.average_work_time
        if self.calls_attended_transfer_in is not None:
            result['CallsAttendedTransferIn'] = self.calls_attended_transfer_in
        if self.calls_attended_transfer_out is not None:
            result['CallsAttendedTransferOut'] = self.calls_attended_transfer_out
        if self.calls_blind_transfer_in is not None:
            result['CallsBlindTransferIn'] = self.calls_blind_transfer_in
        if self.calls_blind_transfer_out is not None:
            result['CallsBlindTransferOut'] = self.calls_blind_transfer_out
        if self.calls_handled is not None:
            result['CallsHandled'] = self.calls_handled
        if self.calls_hold is not None:
            result['CallsHold'] = self.calls_hold
        if self.calls_offered is not None:
            result['CallsOffered'] = self.calls_offered
        if self.calls_ringed is not None:
            result['CallsRinged'] = self.calls_ringed
        if self.handle_rate is not None:
            result['HandleRate'] = self.handle_rate
        if self.max_hold_time is not None:
            result['MaxHoldTime'] = self.max_hold_time
        if self.max_ring_time is not None:
            result['MaxRingTime'] = self.max_ring_time
        if self.max_talk_time is not None:
            result['MaxTalkTime'] = self.max_talk_time
        if self.max_work_time is not None:
            result['MaxWorkTime'] = self.max_work_time
        if self.satisfaction_index is not None:
            result['SatisfactionIndex'] = self.satisfaction_index
        if self.satisfaction_rate is not None:
            result['SatisfactionRate'] = self.satisfaction_rate
        if self.satisfaction_surveys_offered is not None:
            result['SatisfactionSurveysOffered'] = self.satisfaction_surveys_offered
        if self.satisfaction_surveys_responded is not None:
            result['SatisfactionSurveysResponded'] = self.satisfaction_surveys_responded
        if self.total_hold_time is not None:
            result['TotalHoldTime'] = self.total_hold_time
        if self.total_ring_time is not None:
            result['TotalRingTime'] = self.total_ring_time
        if self.total_talk_time is not None:
            result['TotalTalkTime'] = self.total_talk_time
        if self.total_work_time is not None:
            result['TotalWorkTime'] = self.total_work_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AverageHoldTime') is not None:
            self.average_hold_time = m.get('AverageHoldTime')
        if m.get('AverageRingTime') is not None:
            self.average_ring_time = m.get('AverageRingTime')
        if m.get('AverageTalkTime') is not None:
            self.average_talk_time = m.get('AverageTalkTime')
        if m.get('AverageWorkTime') is not None:
            self.average_work_time = m.get('AverageWorkTime')
        if m.get('CallsAttendedTransferIn') is not None:
            self.calls_attended_transfer_in = m.get('CallsAttendedTransferIn')
        if m.get('CallsAttendedTransferOut') is not None:
            self.calls_attended_transfer_out = m.get('CallsAttendedTransferOut')
        if m.get('CallsBlindTransferIn') is not None:
            self.calls_blind_transfer_in = m.get('CallsBlindTransferIn')
        if m.get('CallsBlindTransferOut') is not None:
            self.calls_blind_transfer_out = m.get('CallsBlindTransferOut')
        if m.get('CallsHandled') is not None:
            self.calls_handled = m.get('CallsHandled')
        if m.get('CallsHold') is not None:
            self.calls_hold = m.get('CallsHold')
        if m.get('CallsOffered') is not None:
            self.calls_offered = m.get('CallsOffered')
        if m.get('CallsRinged') is not None:
            self.calls_ringed = m.get('CallsRinged')
        if m.get('HandleRate') is not None:
            self.handle_rate = m.get('HandleRate')
        if m.get('MaxHoldTime') is not None:
            self.max_hold_time = m.get('MaxHoldTime')
        if m.get('MaxRingTime') is not None:
            self.max_ring_time = m.get('MaxRingTime')
        if m.get('MaxTalkTime') is not None:
            self.max_talk_time = m.get('MaxTalkTime')
        if m.get('MaxWorkTime') is not None:
            self.max_work_time = m.get('MaxWorkTime')
        if m.get('SatisfactionIndex') is not None:
            self.satisfaction_index = m.get('SatisfactionIndex')
        if m.get('SatisfactionRate') is not None:
            self.satisfaction_rate = m.get('SatisfactionRate')
        if m.get('SatisfactionSurveysOffered') is not None:
            self.satisfaction_surveys_offered = m.get('SatisfactionSurveysOffered')
        if m.get('SatisfactionSurveysResponded') is not None:
            self.satisfaction_surveys_responded = m.get('SatisfactionSurveysResponded')
        if m.get('TotalHoldTime') is not None:
            self.total_hold_time = m.get('TotalHoldTime')
        if m.get('TotalRingTime') is not None:
            self.total_ring_time = m.get('TotalRingTime')
        if m.get('TotalTalkTime') is not None:
            self.total_talk_time = m.get('TotalTalkTime')
        if m.get('TotalWorkTime') is not None:
            self.total_work_time = m.get('TotalWorkTime')
        return self


class ListHistoricalAgentReportResponseBodyDataListOutbound(TeaModel):
    def __init__(self, answer_rate=None, average_dialing_time=None, average_hold_time=None, average_ring_time=None,
                 average_talk_time=None, average_work_time=None, calls_answered=None, calls_attended_transfer_in=None,
                 calls_attended_transfer_out=None, calls_blind_transfer_in=None, calls_blind_transfer_out=None, calls_dialed=None,
                 calls_hold=None, calls_ringed=None, max_dialing_time=None, max_hold_time=None, max_ring_time=None,
                 max_talk_time=None, max_work_time=None, satisfaction_index=None, satisfaction_rate=None,
                 satisfaction_surveys_offered=None, satisfaction_surveys_responded=None, total_dialing_time=None, total_hold_time=None,
                 total_ring_time=None, total_talk_time=None, total_work_time=None):
        self.answer_rate = answer_rate  # type: float
        self.average_dialing_time = average_dialing_time  # type: float
        self.average_hold_time = average_hold_time  # type: float
        self.average_ring_time = average_ring_time  # type: float
        self.average_talk_time = average_talk_time  # type: float
        self.average_work_time = average_work_time  # type: float
        self.calls_answered = calls_answered  # type: long
        self.calls_attended_transfer_in = calls_attended_transfer_in  # type: long
        self.calls_attended_transfer_out = calls_attended_transfer_out  # type: long
        self.calls_blind_transfer_in = calls_blind_transfer_in  # type: long
        self.calls_blind_transfer_out = calls_blind_transfer_out  # type: long
        self.calls_dialed = calls_dialed  # type: long
        self.calls_hold = calls_hold  # type: long
        self.calls_ringed = calls_ringed  # type: long
        self.max_dialing_time = max_dialing_time  # type: long
        self.max_hold_time = max_hold_time  # type: long
        self.max_ring_time = max_ring_time  # type: long
        self.max_talk_time = max_talk_time  # type: long
        self.max_work_time = max_work_time  # type: long
        self.satisfaction_index = satisfaction_index  # type: float
        self.satisfaction_rate = satisfaction_rate  # type: float
        self.satisfaction_surveys_offered = satisfaction_surveys_offered  # type: long
        self.satisfaction_surveys_responded = satisfaction_surveys_responded  # type: long
        self.total_dialing_time = total_dialing_time  # type: long
        self.total_hold_time = total_hold_time  # type: long
        self.total_ring_time = total_ring_time  # type: long
        self.total_talk_time = total_talk_time  # type: long
        self.total_work_time = total_work_time  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListHistoricalAgentReportResponseBodyDataListOutbound, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.answer_rate is not None:
            result['AnswerRate'] = self.answer_rate
        if self.average_dialing_time is not None:
            result['AverageDialingTime'] = self.average_dialing_time
        if self.average_hold_time is not None:
            result['AverageHoldTime'] = self.average_hold_time
        if self.average_ring_time is not None:
            result['AverageRingTime'] = self.average_ring_time
        if self.average_talk_time is not None:
            result['AverageTalkTime'] = self.average_talk_time
        if self.average_work_time is not None:
            result['AverageWorkTime'] = self.average_work_time
        if self.calls_answered is not None:
            result['CallsAnswered'] = self.calls_answered
        if self.calls_attended_transfer_in is not None:
            result['CallsAttendedTransferIn'] = self.calls_attended_transfer_in
        if self.calls_attended_transfer_out is not None:
            result['CallsAttendedTransferOut'] = self.calls_attended_transfer_out
        if self.calls_blind_transfer_in is not None:
            result['CallsBlindTransferIn'] = self.calls_blind_transfer_in
        if self.calls_blind_transfer_out is not None:
            result['CallsBlindTransferOut'] = self.calls_blind_transfer_out
        if self.calls_dialed is not None:
            result['CallsDialed'] = self.calls_dialed
        if self.calls_hold is not None:
            result['CallsHold'] = self.calls_hold
        if self.calls_ringed is not None:
            result['CallsRinged'] = self.calls_ringed
        if self.max_dialing_time is not None:
            result['MaxDialingTime'] = self.max_dialing_time
        if self.max_hold_time is not None:
            result['MaxHoldTime'] = self.max_hold_time
        if self.max_ring_time is not None:
            result['MaxRingTime'] = self.max_ring_time
        if self.max_talk_time is not None:
            result['MaxTalkTime'] = self.max_talk_time
        if self.max_work_time is not None:
            result['MaxWorkTime'] = self.max_work_time
        if self.satisfaction_index is not None:
            result['SatisfactionIndex'] = self.satisfaction_index
        if self.satisfaction_rate is not None:
            result['SatisfactionRate'] = self.satisfaction_rate
        if self.satisfaction_surveys_offered is not None:
            result['SatisfactionSurveysOffered'] = self.satisfaction_surveys_offered
        if self.satisfaction_surveys_responded is not None:
            result['SatisfactionSurveysResponded'] = self.satisfaction_surveys_responded
        if self.total_dialing_time is not None:
            result['TotalDialingTime'] = self.total_dialing_time
        if self.total_hold_time is not None:
            result['TotalHoldTime'] = self.total_hold_time
        if self.total_ring_time is not None:
            result['TotalRingTime'] = self.total_ring_time
        if self.total_talk_time is not None:
            result['TotalTalkTime'] = self.total_talk_time
        if self.total_work_time is not None:
            result['TotalWorkTime'] = self.total_work_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AnswerRate') is not None:
            self.answer_rate = m.get('AnswerRate')
        if m.get('AverageDialingTime') is not None:
            self.average_dialing_time = m.get('AverageDialingTime')
        if m.get('AverageHoldTime') is not None:
            self.average_hold_time = m.get('AverageHoldTime')
        if m.get('AverageRingTime') is not None:
            self.average_ring_time = m.get('AverageRingTime')
        if m.get('AverageTalkTime') is not None:
            self.average_talk_time = m.get('AverageTalkTime')
        if m.get('AverageWorkTime') is not None:
            self.average_work_time = m.get('AverageWorkTime')
        if m.get('CallsAnswered') is not None:
            self.calls_answered = m.get('CallsAnswered')
        if m.get('CallsAttendedTransferIn') is not None:
            self.calls_attended_transfer_in = m.get('CallsAttendedTransferIn')
        if m.get('CallsAttendedTransferOut') is not None:
            self.calls_attended_transfer_out = m.get('CallsAttendedTransferOut')
        if m.get('CallsBlindTransferIn') is not None:
            self.calls_blind_transfer_in = m.get('CallsBlindTransferIn')
        if m.get('CallsBlindTransferOut') is not None:
            self.calls_blind_transfer_out = m.get('CallsBlindTransferOut')
        if m.get('CallsDialed') is not None:
            self.calls_dialed = m.get('CallsDialed')
        if m.get('CallsHold') is not None:
            self.calls_hold = m.get('CallsHold')
        if m.get('CallsRinged') is not None:
            self.calls_ringed = m.get('CallsRinged')
        if m.get('MaxDialingTime') is not None:
            self.max_dialing_time = m.get('MaxDialingTime')
        if m.get('MaxHoldTime') is not None:
            self.max_hold_time = m.get('MaxHoldTime')
        if m.get('MaxRingTime') is not None:
            self.max_ring_time = m.get('MaxRingTime')
        if m.get('MaxTalkTime') is not None:
            self.max_talk_time = m.get('MaxTalkTime')
        if m.get('MaxWorkTime') is not None:
            self.max_work_time = m.get('MaxWorkTime')
        if m.get('SatisfactionIndex') is not None:
            self.satisfaction_index = m.get('SatisfactionIndex')
        if m.get('SatisfactionRate') is not None:
            self.satisfaction_rate = m.get('SatisfactionRate')
        if m.get('SatisfactionSurveysOffered') is not None:
            self.satisfaction_surveys_offered = m.get('SatisfactionSurveysOffered')
        if m.get('SatisfactionSurveysResponded') is not None:
            self.satisfaction_surveys_responded = m.get('SatisfactionSurveysResponded')
        if m.get('TotalDialingTime') is not None:
            self.total_dialing_time = m.get('TotalDialingTime')
        if m.get('TotalHoldTime') is not None:
            self.total_hold_time = m.get('TotalHoldTime')
        if m.get('TotalRingTime') is not None:
            self.total_ring_time = m.get('TotalRingTime')
        if m.get('TotalTalkTime') is not None:
            self.total_talk_time = m.get('TotalTalkTime')
        if m.get('TotalWorkTime') is not None:
            self.total_work_time = m.get('TotalWorkTime')
        return self


class ListHistoricalAgentReportResponseBodyDataListOverall(TeaModel):
    def __init__(self, average_break_time=None, average_hold_time=None, average_ready_time=None,
                 average_talk_time=None, average_work_time=None, max_break_time=None, max_hold_time=None, max_ready_time=None,
                 max_talk_time=None, max_work_time=None, occupancy_rate=None, satisfaction_index=None, satisfaction_rate=None,
                 satisfaction_surveys_offered=None, satisfaction_surveys_responded=None, total_break_time=None, total_calls=None,
                 total_hold_time=None, total_logged_in_time=None, total_ready_time=None, total_talk_time=None,
                 total_work_time=None):
        self.average_break_time = average_break_time  # type: float
        self.average_hold_time = average_hold_time  # type: float
        self.average_ready_time = average_ready_time  # type: float
        self.average_talk_time = average_talk_time  # type: float
        self.average_work_time = average_work_time  # type: float
        self.max_break_time = max_break_time  # type: long
        self.max_hold_time = max_hold_time  # type: long
        self.max_ready_time = max_ready_time  # type: long
        self.max_talk_time = max_talk_time  # type: long
        self.max_work_time = max_work_time  # type: long
        self.occupancy_rate = occupancy_rate  # type: float
        self.satisfaction_index = satisfaction_index  # type: float
        self.satisfaction_rate = satisfaction_rate  # type: float
        self.satisfaction_surveys_offered = satisfaction_surveys_offered  # type: long
        self.satisfaction_surveys_responded = satisfaction_surveys_responded  # type: long
        self.total_break_time = total_break_time  # type: long
        self.total_calls = total_calls  # type: long
        self.total_hold_time = total_hold_time  # type: long
        self.total_logged_in_time = total_logged_in_time  # type: long
        self.total_ready_time = total_ready_time  # type: long
        self.total_talk_time = total_talk_time  # type: long
        self.total_work_time = total_work_time  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListHistoricalAgentReportResponseBodyDataListOverall, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.average_break_time is not None:
            result['AverageBreakTime'] = self.average_break_time
        if self.average_hold_time is not None:
            result['AverageHoldTime'] = self.average_hold_time
        if self.average_ready_time is not None:
            result['AverageReadyTime'] = self.average_ready_time
        if self.average_talk_time is not None:
            result['AverageTalkTime'] = self.average_talk_time
        if self.average_work_time is not None:
            result['AverageWorkTime'] = self.average_work_time
        if self.max_break_time is not None:
            result['MaxBreakTime'] = self.max_break_time
        if self.max_hold_time is not None:
            result['MaxHoldTime'] = self.max_hold_time
        if self.max_ready_time is not None:
            result['MaxReadyTime'] = self.max_ready_time
        if self.max_talk_time is not None:
            result['MaxTalkTime'] = self.max_talk_time
        if self.max_work_time is not None:
            result['MaxWorkTime'] = self.max_work_time
        if self.occupancy_rate is not None:
            result['OccupancyRate'] = self.occupancy_rate
        if self.satisfaction_index is not None:
            result['SatisfactionIndex'] = self.satisfaction_index
        if self.satisfaction_rate is not None:
            result['SatisfactionRate'] = self.satisfaction_rate
        if self.satisfaction_surveys_offered is not None:
            result['SatisfactionSurveysOffered'] = self.satisfaction_surveys_offered
        if self.satisfaction_surveys_responded is not None:
            result['SatisfactionSurveysResponded'] = self.satisfaction_surveys_responded
        if self.total_break_time is not None:
            result['TotalBreakTime'] = self.total_break_time
        if self.total_calls is not None:
            result['TotalCalls'] = self.total_calls
        if self.total_hold_time is not None:
            result['TotalHoldTime'] = self.total_hold_time
        if self.total_logged_in_time is not None:
            result['TotalLoggedInTime'] = self.total_logged_in_time
        if self.total_ready_time is not None:
            result['TotalReadyTime'] = self.total_ready_time
        if self.total_talk_time is not None:
            result['TotalTalkTime'] = self.total_talk_time
        if self.total_work_time is not None:
            result['TotalWorkTime'] = self.total_work_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AverageBreakTime') is not None:
            self.average_break_time = m.get('AverageBreakTime')
        if m.get('AverageHoldTime') is not None:
            self.average_hold_time = m.get('AverageHoldTime')
        if m.get('AverageReadyTime') is not None:
            self.average_ready_time = m.get('AverageReadyTime')
        if m.get('AverageTalkTime') is not None:
            self.average_talk_time = m.get('AverageTalkTime')
        if m.get('AverageWorkTime') is not None:
            self.average_work_time = m.get('AverageWorkTime')
        if m.get('MaxBreakTime') is not None:
            self.max_break_time = m.get('MaxBreakTime')
        if m.get('MaxHoldTime') is not None:
            self.max_hold_time = m.get('MaxHoldTime')
        if m.get('MaxReadyTime') is not None:
            self.max_ready_time = m.get('MaxReadyTime')
        if m.get('MaxTalkTime') is not None:
            self.max_talk_time = m.get('MaxTalkTime')
        if m.get('MaxWorkTime') is not None:
            self.max_work_time = m.get('MaxWorkTime')
        if m.get('OccupancyRate') is not None:
            self.occupancy_rate = m.get('OccupancyRate')
        if m.get('SatisfactionIndex') is not None:
            self.satisfaction_index = m.get('SatisfactionIndex')
        if m.get('SatisfactionRate') is not None:
            self.satisfaction_rate = m.get('SatisfactionRate')
        if m.get('SatisfactionSurveysOffered') is not None:
            self.satisfaction_surveys_offered = m.get('SatisfactionSurveysOffered')
        if m.get('SatisfactionSurveysResponded') is not None:
            self.satisfaction_surveys_responded = m.get('SatisfactionSurveysResponded')
        if m.get('TotalBreakTime') is not None:
            self.total_break_time = m.get('TotalBreakTime')
        if m.get('TotalCalls') is not None:
            self.total_calls = m.get('TotalCalls')
        if m.get('TotalHoldTime') is not None:
            self.total_hold_time = m.get('TotalHoldTime')
        if m.get('TotalLoggedInTime') is not None:
            self.total_logged_in_time = m.get('TotalLoggedInTime')
        if m.get('TotalReadyTime') is not None:
            self.total_ready_time = m.get('TotalReadyTime')
        if m.get('TotalTalkTime') is not None:
            self.total_talk_time = m.get('TotalTalkTime')
        if m.get('TotalWorkTime') is not None:
            self.total_work_time = m.get('TotalWorkTime')
        return self


class ListHistoricalAgentReportResponseBodyDataList(TeaModel):
    def __init__(self, agent_id=None, agent_name=None, display_id=None, inbound=None, outbound=None, overall=None):
        self.agent_id = agent_id  # type: str
        self.agent_name = agent_name  # type: str
        self.display_id = display_id  # type: str
        self.inbound = inbound  # type: ListHistoricalAgentReportResponseBodyDataListInbound
        self.outbound = outbound  # type: ListHistoricalAgentReportResponseBodyDataListOutbound
        self.overall = overall  # type: ListHistoricalAgentReportResponseBodyDataListOverall

    def validate(self):
        if self.inbound:
            self.inbound.validate()
        if self.outbound:
            self.outbound.validate()
        if self.overall:
            self.overall.validate()

    def to_map(self):
        _map = super(ListHistoricalAgentReportResponseBodyDataList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_id is not None:
            result['AgentId'] = self.agent_id
        if self.agent_name is not None:
            result['AgentName'] = self.agent_name
        if self.display_id is not None:
            result['DisplayId'] = self.display_id
        if self.inbound is not None:
            result['Inbound'] = self.inbound.to_map()
        if self.outbound is not None:
            result['Outbound'] = self.outbound.to_map()
        if self.overall is not None:
            result['Overall'] = self.overall.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AgentId') is not None:
            self.agent_id = m.get('AgentId')
        if m.get('AgentName') is not None:
            self.agent_name = m.get('AgentName')
        if m.get('DisplayId') is not None:
            self.display_id = m.get('DisplayId')
        if m.get('Inbound') is not None:
            temp_model = ListHistoricalAgentReportResponseBodyDataListInbound()
            self.inbound = temp_model.from_map(m['Inbound'])
        if m.get('Outbound') is not None:
            temp_model = ListHistoricalAgentReportResponseBodyDataListOutbound()
            self.outbound = temp_model.from_map(m['Outbound'])
        if m.get('Overall') is not None:
            temp_model = ListHistoricalAgentReportResponseBodyDataListOverall()
            self.overall = temp_model.from_map(m['Overall'])
        return self


class ListHistoricalAgentReportResponseBodyData(TeaModel):
    def __init__(self, list=None, page_number=None, page_size=None, total_count=None):
        self.list = list  # type: list[ListHistoricalAgentReportResponseBodyDataList]
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.total_count = total_count  # type: int

    def validate(self):
        if self.list:
            for k in self.list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListHistoricalAgentReportResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['List'] = []
        if self.list is not None:
            for k in self.list:
                result['List'].append(k.to_map() if k else None)
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.list = []
        if m.get('List') is not None:
            for k in m.get('List'):
                temp_model = ListHistoricalAgentReportResponseBodyDataList()
                self.list.append(temp_model.from_map(k))
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListHistoricalAgentReportResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: ListHistoricalAgentReportResponseBodyData
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(ListHistoricalAgentReportResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = ListHistoricalAgentReportResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListHistoricalAgentReportResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ListHistoricalAgentReportResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListHistoricalAgentReportResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListHistoricalAgentReportResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListHistoricalSkillGroupReportRequest(TeaModel):
    def __init__(self, end_time=None, instance_id=None, page_number=None, page_size=None, skill_group_id_list=None,
                 start_time=None):
        self.end_time = end_time  # type: long
        self.instance_id = instance_id  # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.skill_group_id_list = skill_group_id_list  # type: str
        self.start_time = start_time  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListHistoricalSkillGroupReportRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.skill_group_id_list is not None:
            result['SkillGroupIdList'] = self.skill_group_id_list
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('SkillGroupIdList') is not None:
            self.skill_group_id_list = m.get('SkillGroupIdList')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class ListHistoricalSkillGroupReportResponseBodyDataListInbound(TeaModel):
    def __init__(self, abandon_rate=None, average_abandon_time=None, average_abandoned_in_queue_time=None,
                 average_abandoned_in_ring_time=None, average_hold_time=None, average_ring_time=None, average_talk_time=None,
                 average_wait_time=None, average_work_time=None, calls_abandoned=None, calls_abandoned_in_queue=None,
                 calls_abandoned_in_ring=None, calls_attended_transfer_in=None, calls_attended_transfer_out=None,
                 calls_blind_transfer_in=None, calls_blind_transfer_out=None, calls_handled=None, calls_hold=None, calls_offered=None,
                 calls_overflow=None, calls_queued=None, calls_ringed=None, calls_timeout=None, handle_rate=None,
                 max_abandon_time=None, max_abandoned_in_queue_time=None, max_abandoned_in_ring_time=None, max_hold_time=None,
                 max_ring_time=None, max_talk_time=None, max_wait_time=None, max_work_time=None, satisfaction_index=None,
                 satisfaction_rate=None, satisfaction_surveys_offered=None, satisfaction_surveys_responded=None,
                 service_level_20=None, total_abandon_time=None, total_abandoned_in_queue_time=None,
                 total_abandoned_in_ring_time=None, total_hold_time=None, total_ring_time=None, total_talk_time=None, total_wait_time=None,
                 total_work_time=None):
        self.abandon_rate = abandon_rate  # type: float
        self.average_abandon_time = average_abandon_time  # type: float
        self.average_abandoned_in_queue_time = average_abandoned_in_queue_time  # type: float
        self.average_abandoned_in_ring_time = average_abandoned_in_ring_time  # type: float
        self.average_hold_time = average_hold_time  # type: float
        self.average_ring_time = average_ring_time  # type: float
        self.average_talk_time = average_talk_time  # type: float
        self.average_wait_time = average_wait_time  # type: float
        self.average_work_time = average_work_time  # type: float
        self.calls_abandoned = calls_abandoned  # type: long
        self.calls_abandoned_in_queue = calls_abandoned_in_queue  # type: long
        self.calls_abandoned_in_ring = calls_abandoned_in_ring  # type: long
        self.calls_attended_transfer_in = calls_attended_transfer_in  # type: long
        self.calls_attended_transfer_out = calls_attended_transfer_out  # type: long
        self.calls_blind_transfer_in = calls_blind_transfer_in  # type: long
        self.calls_blind_transfer_out = calls_blind_transfer_out  # type: long
        self.calls_handled = calls_handled  # type: long
        self.calls_hold = calls_hold  # type: long
        self.calls_offered = calls_offered  # type: long
        self.calls_overflow = calls_overflow  # type: long
        self.calls_queued = calls_queued  # type: long
        self.calls_ringed = calls_ringed  # type: long
        self.calls_timeout = calls_timeout  # type: long
        self.handle_rate = handle_rate  # type: float
        self.max_abandon_time = max_abandon_time  # type: long
        self.max_abandoned_in_queue_time = max_abandoned_in_queue_time  # type: long
        self.max_abandoned_in_ring_time = max_abandoned_in_ring_time  # type: long
        self.max_hold_time = max_hold_time  # type: long
        self.max_ring_time = max_ring_time  # type: long
        self.max_talk_time = max_talk_time  # type: long
        self.max_wait_time = max_wait_time  # type: long
        self.max_work_time = max_work_time  # type: long
        self.satisfaction_index = satisfaction_index  # type: float
        self.satisfaction_rate = satisfaction_rate  # type: float
        self.satisfaction_surveys_offered = satisfaction_surveys_offered  # type: long
        self.satisfaction_surveys_responded = satisfaction_surveys_responded  # type: long
        self.service_level_20 = service_level_20  # type: float
        self.total_abandon_time = total_abandon_time  # type: long
        self.total_abandoned_in_queue_time = total_abandoned_in_queue_time  # type: long
        self.total_abandoned_in_ring_time = total_abandoned_in_ring_time  # type: long
        self.total_hold_time = total_hold_time  # type: long
        self.total_ring_time = total_ring_time  # type: long
        self.total_talk_time = total_talk_time  # type: long
        self.total_wait_time = total_wait_time  # type: long
        self.total_work_time = total_work_time  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListHistoricalSkillGroupReportResponseBodyDataListInbound, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.abandon_rate is not None:
            result['AbandonRate'] = self.abandon_rate
        if self.average_abandon_time is not None:
            result['AverageAbandonTime'] = self.average_abandon_time
        if self.average_abandoned_in_queue_time is not None:
            result['AverageAbandonedInQueueTime'] = self.average_abandoned_in_queue_time
        if self.average_abandoned_in_ring_time is not None:
            result['AverageAbandonedInRingTime'] = self.average_abandoned_in_ring_time
        if self.average_hold_time is not None:
            result['AverageHoldTime'] = self.average_hold_time
        if self.average_ring_time is not None:
            result['AverageRingTime'] = self.average_ring_time
        if self.average_talk_time is not None:
            result['AverageTalkTime'] = self.average_talk_time
        if self.average_wait_time is not None:
            result['AverageWaitTime'] = self.average_wait_time
        if self.average_work_time is not None:
            result['AverageWorkTime'] = self.average_work_time
        if self.calls_abandoned is not None:
            result['CallsAbandoned'] = self.calls_abandoned
        if self.calls_abandoned_in_queue is not None:
            result['CallsAbandonedInQueue'] = self.calls_abandoned_in_queue
        if self.calls_abandoned_in_ring is not None:
            result['CallsAbandonedInRing'] = self.calls_abandoned_in_ring
        if self.calls_attended_transfer_in is not None:
            result['CallsAttendedTransferIn'] = self.calls_attended_transfer_in
        if self.calls_attended_transfer_out is not None:
            result['CallsAttendedTransferOut'] = self.calls_attended_transfer_out
        if self.calls_blind_transfer_in is not None:
            result['CallsBlindTransferIn'] = self.calls_blind_transfer_in
        if self.calls_blind_transfer_out is not None:
            result['CallsBlindTransferOut'] = self.calls_blind_transfer_out
        if self.calls_handled is not None:
            result['CallsHandled'] = self.calls_handled
        if self.calls_hold is not None:
            result['CallsHold'] = self.calls_hold
        if self.calls_offered is not None:
            result['CallsOffered'] = self.calls_offered
        if self.calls_overflow is not None:
            result['CallsOverflow'] = self.calls_overflow
        if self.calls_queued is not None:
            result['CallsQueued'] = self.calls_queued
        if self.calls_ringed is not None:
            result['CallsRinged'] = self.calls_ringed
        if self.calls_timeout is not None:
            result['CallsTimeout'] = self.calls_timeout
        if self.handle_rate is not None:
            result['HandleRate'] = self.handle_rate
        if self.max_abandon_time is not None:
            result['MaxAbandonTime'] = self.max_abandon_time
        if self.max_abandoned_in_queue_time is not None:
            result['MaxAbandonedInQueueTime'] = self.max_abandoned_in_queue_time
        if self.max_abandoned_in_ring_time is not None:
            result['MaxAbandonedInRingTime'] = self.max_abandoned_in_ring_time
        if self.max_hold_time is not None:
            result['MaxHoldTime'] = self.max_hold_time
        if self.max_ring_time is not None:
            result['MaxRingTime'] = self.max_ring_time
        if self.max_talk_time is not None:
            result['MaxTalkTime'] = self.max_talk_time
        if self.max_wait_time is not None:
            result['MaxWaitTime'] = self.max_wait_time
        if self.max_work_time is not None:
            result['MaxWorkTime'] = self.max_work_time
        if self.satisfaction_index is not None:
            result['SatisfactionIndex'] = self.satisfaction_index
        if self.satisfaction_rate is not None:
            result['SatisfactionRate'] = self.satisfaction_rate
        if self.satisfaction_surveys_offered is not None:
            result['SatisfactionSurveysOffered'] = self.satisfaction_surveys_offered
        if self.satisfaction_surveys_responded is not None:
            result['SatisfactionSurveysResponded'] = self.satisfaction_surveys_responded
        if self.service_level_20 is not None:
            result['ServiceLevel20'] = self.service_level_20
        if self.total_abandon_time is not None:
            result['TotalAbandonTime'] = self.total_abandon_time
        if self.total_abandoned_in_queue_time is not None:
            result['TotalAbandonedInQueueTime'] = self.total_abandoned_in_queue_time
        if self.total_abandoned_in_ring_time is not None:
            result['TotalAbandonedInRingTime'] = self.total_abandoned_in_ring_time
        if self.total_hold_time is not None:
            result['TotalHoldTime'] = self.total_hold_time
        if self.total_ring_time is not None:
            result['TotalRingTime'] = self.total_ring_time
        if self.total_talk_time is not None:
            result['TotalTalkTime'] = self.total_talk_time
        if self.total_wait_time is not None:
            result['TotalWaitTime'] = self.total_wait_time
        if self.total_work_time is not None:
            result['TotalWorkTime'] = self.total_work_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AbandonRate') is not None:
            self.abandon_rate = m.get('AbandonRate')
        if m.get('AverageAbandonTime') is not None:
            self.average_abandon_time = m.get('AverageAbandonTime')
        if m.get('AverageAbandonedInQueueTime') is not None:
            self.average_abandoned_in_queue_time = m.get('AverageAbandonedInQueueTime')
        if m.get('AverageAbandonedInRingTime') is not None:
            self.average_abandoned_in_ring_time = m.get('AverageAbandonedInRingTime')
        if m.get('AverageHoldTime') is not None:
            self.average_hold_time = m.get('AverageHoldTime')
        if m.get('AverageRingTime') is not None:
            self.average_ring_time = m.get('AverageRingTime')
        if m.get('AverageTalkTime') is not None:
            self.average_talk_time = m.get('AverageTalkTime')
        if m.get('AverageWaitTime') is not None:
            self.average_wait_time = m.get('AverageWaitTime')
        if m.get('AverageWorkTime') is not None:
            self.average_work_time = m.get('AverageWorkTime')
        if m.get('CallsAbandoned') is not None:
            self.calls_abandoned = m.get('CallsAbandoned')
        if m.get('CallsAbandonedInQueue') is not None:
            self.calls_abandoned_in_queue = m.get('CallsAbandonedInQueue')
        if m.get('CallsAbandonedInRing') is not None:
            self.calls_abandoned_in_ring = m.get('CallsAbandonedInRing')
        if m.get('CallsAttendedTransferIn') is not None:
            self.calls_attended_transfer_in = m.get('CallsAttendedTransferIn')
        if m.get('CallsAttendedTransferOut') is not None:
            self.calls_attended_transfer_out = m.get('CallsAttendedTransferOut')
        if m.get('CallsBlindTransferIn') is not None:
            self.calls_blind_transfer_in = m.get('CallsBlindTransferIn')
        if m.get('CallsBlindTransferOut') is not None:
            self.calls_blind_transfer_out = m.get('CallsBlindTransferOut')
        if m.get('CallsHandled') is not None:
            self.calls_handled = m.get('CallsHandled')
        if m.get('CallsHold') is not None:
            self.calls_hold = m.get('CallsHold')
        if m.get('CallsOffered') is not None:
            self.calls_offered = m.get('CallsOffered')
        if m.get('CallsOverflow') is not None:
            self.calls_overflow = m.get('CallsOverflow')
        if m.get('CallsQueued') is not None:
            self.calls_queued = m.get('CallsQueued')
        if m.get('CallsRinged') is not None:
            self.calls_ringed = m.get('CallsRinged')
        if m.get('CallsTimeout') is not None:
            self.calls_timeout = m.get('CallsTimeout')
        if m.get('HandleRate') is not None:
            self.handle_rate = m.get('HandleRate')
        if m.get('MaxAbandonTime') is not None:
            self.max_abandon_time = m.get('MaxAbandonTime')
        if m.get('MaxAbandonedInQueueTime') is not None:
            self.max_abandoned_in_queue_time = m.get('MaxAbandonedInQueueTime')
        if m.get('MaxAbandonedInRingTime') is not None:
            self.max_abandoned_in_ring_time = m.get('MaxAbandonedInRingTime')
        if m.get('MaxHoldTime') is not None:
            self.max_hold_time = m.get('MaxHoldTime')
        if m.get('MaxRingTime') is not None:
            self.max_ring_time = m.get('MaxRingTime')
        if m.get('MaxTalkTime') is not None:
            self.max_talk_time = m.get('MaxTalkTime')
        if m.get('MaxWaitTime') is not None:
            self.max_wait_time = m.get('MaxWaitTime')
        if m.get('MaxWorkTime') is not None:
            self.max_work_time = m.get('MaxWorkTime')
        if m.get('SatisfactionIndex') is not None:
            self.satisfaction_index = m.get('SatisfactionIndex')
        if m.get('SatisfactionRate') is not None:
            self.satisfaction_rate = m.get('SatisfactionRate')
        if m.get('SatisfactionSurveysOffered') is not None:
            self.satisfaction_surveys_offered = m.get('SatisfactionSurveysOffered')
        if m.get('SatisfactionSurveysResponded') is not None:
            self.satisfaction_surveys_responded = m.get('SatisfactionSurveysResponded')
        if m.get('ServiceLevel20') is not None:
            self.service_level_20 = m.get('ServiceLevel20')
        if m.get('TotalAbandonTime') is not None:
            self.total_abandon_time = m.get('TotalAbandonTime')
        if m.get('TotalAbandonedInQueueTime') is not None:
            self.total_abandoned_in_queue_time = m.get('TotalAbandonedInQueueTime')
        if m.get('TotalAbandonedInRingTime') is not None:
            self.total_abandoned_in_ring_time = m.get('TotalAbandonedInRingTime')
        if m.get('TotalHoldTime') is not None:
            self.total_hold_time = m.get('TotalHoldTime')
        if m.get('TotalRingTime') is not None:
            self.total_ring_time = m.get('TotalRingTime')
        if m.get('TotalTalkTime') is not None:
            self.total_talk_time = m.get('TotalTalkTime')
        if m.get('TotalWaitTime') is not None:
            self.total_wait_time = m.get('TotalWaitTime')
        if m.get('TotalWorkTime') is not None:
            self.total_work_time = m.get('TotalWorkTime')
        return self


class ListHistoricalSkillGroupReportResponseBodyDataListOutbound(TeaModel):
    def __init__(self, answer_rate=None, average_dialing_time=None, average_hold_time=None, average_ring_time=None,
                 average_talk_time=None, average_work_time=None, calls_answered=None, calls_attended_transfer_in=None,
                 calls_attended_transfer_out=None, calls_blind_transfer_in=None, calls_blind_transfer_out=None, calls_dialed=None,
                 calls_hold=None, calls_ringed=None, max_dialing_time=None, max_hold_time=None, max_ring_time=None,
                 max_talk_time=None, max_work_time=None, satisfaction_index=None, satisfaction_rate=None,
                 satisfaction_surveys_offered=None, satisfaction_surveys_responded=None, total_dialing_time=None, total_hold_time=None,
                 total_ring_time=None, total_talk_time=None, total_work_time=None):
        self.answer_rate = answer_rate  # type: float
        self.average_dialing_time = average_dialing_time  # type: float
        self.average_hold_time = average_hold_time  # type: float
        self.average_ring_time = average_ring_time  # type: float
        self.average_talk_time = average_talk_time  # type: float
        self.average_work_time = average_work_time  # type: float
        self.calls_answered = calls_answered  # type: long
        self.calls_attended_transfer_in = calls_attended_transfer_in  # type: long
        self.calls_attended_transfer_out = calls_attended_transfer_out  # type: long
        self.calls_blind_transfer_in = calls_blind_transfer_in  # type: long
        self.calls_blind_transfer_out = calls_blind_transfer_out  # type: long
        self.calls_dialed = calls_dialed  # type: long
        self.calls_hold = calls_hold  # type: long
        self.calls_ringed = calls_ringed  # type: long
        self.max_dialing_time = max_dialing_time  # type: long
        self.max_hold_time = max_hold_time  # type: long
        self.max_ring_time = max_ring_time  # type: long
        self.max_talk_time = max_talk_time  # type: long
        self.max_work_time = max_work_time  # type: long
        self.satisfaction_index = satisfaction_index  # type: float
        self.satisfaction_rate = satisfaction_rate  # type: float
        self.satisfaction_surveys_offered = satisfaction_surveys_offered  # type: long
        self.satisfaction_surveys_responded = satisfaction_surveys_responded  # type: long
        self.total_dialing_time = total_dialing_time  # type: long
        self.total_hold_time = total_hold_time  # type: long
        self.total_ring_time = total_ring_time  # type: long
        self.total_talk_time = total_talk_time  # type: long
        self.total_work_time = total_work_time  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListHistoricalSkillGroupReportResponseBodyDataListOutbound, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.answer_rate is not None:
            result['AnswerRate'] = self.answer_rate
        if self.average_dialing_time is not None:
            result['AverageDialingTime'] = self.average_dialing_time
        if self.average_hold_time is not None:
            result['AverageHoldTime'] = self.average_hold_time
        if self.average_ring_time is not None:
            result['AverageRingTime'] = self.average_ring_time
        if self.average_talk_time is not None:
            result['AverageTalkTime'] = self.average_talk_time
        if self.average_work_time is not None:
            result['AverageWorkTime'] = self.average_work_time
        if self.calls_answered is not None:
            result['CallsAnswered'] = self.calls_answered
        if self.calls_attended_transfer_in is not None:
            result['CallsAttendedTransferIn'] = self.calls_attended_transfer_in
        if self.calls_attended_transfer_out is not None:
            result['CallsAttendedTransferOut'] = self.calls_attended_transfer_out
        if self.calls_blind_transfer_in is not None:
            result['CallsBlindTransferIn'] = self.calls_blind_transfer_in
        if self.calls_blind_transfer_out is not None:
            result['CallsBlindTransferOut'] = self.calls_blind_transfer_out
        if self.calls_dialed is not None:
            result['CallsDialed'] = self.calls_dialed
        if self.calls_hold is not None:
            result['CallsHold'] = self.calls_hold
        if self.calls_ringed is not None:
            result['CallsRinged'] = self.calls_ringed
        if self.max_dialing_time is not None:
            result['MaxDialingTime'] = self.max_dialing_time
        if self.max_hold_time is not None:
            result['MaxHoldTime'] = self.max_hold_time
        if self.max_ring_time is not None:
            result['MaxRingTime'] = self.max_ring_time
        if self.max_talk_time is not None:
            result['MaxTalkTime'] = self.max_talk_time
        if self.max_work_time is not None:
            result['MaxWorkTime'] = self.max_work_time
        if self.satisfaction_index is not None:
            result['SatisfactionIndex'] = self.satisfaction_index
        if self.satisfaction_rate is not None:
            result['SatisfactionRate'] = self.satisfaction_rate
        if self.satisfaction_surveys_offered is not None:
            result['SatisfactionSurveysOffered'] = self.satisfaction_surveys_offered
        if self.satisfaction_surveys_responded is not None:
            result['SatisfactionSurveysResponded'] = self.satisfaction_surveys_responded
        if self.total_dialing_time is not None:
            result['TotalDialingTime'] = self.total_dialing_time
        if self.total_hold_time is not None:
            result['TotalHoldTime'] = self.total_hold_time
        if self.total_ring_time is not None:
            result['TotalRingTime'] = self.total_ring_time
        if self.total_talk_time is not None:
            result['TotalTalkTime'] = self.total_talk_time
        if self.total_work_time is not None:
            result['TotalWorkTime'] = self.total_work_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AnswerRate') is not None:
            self.answer_rate = m.get('AnswerRate')
        if m.get('AverageDialingTime') is not None:
            self.average_dialing_time = m.get('AverageDialingTime')
        if m.get('AverageHoldTime') is not None:
            self.average_hold_time = m.get('AverageHoldTime')
        if m.get('AverageRingTime') is not None:
            self.average_ring_time = m.get('AverageRingTime')
        if m.get('AverageTalkTime') is not None:
            self.average_talk_time = m.get('AverageTalkTime')
        if m.get('AverageWorkTime') is not None:
            self.average_work_time = m.get('AverageWorkTime')
        if m.get('CallsAnswered') is not None:
            self.calls_answered = m.get('CallsAnswered')
        if m.get('CallsAttendedTransferIn') is not None:
            self.calls_attended_transfer_in = m.get('CallsAttendedTransferIn')
        if m.get('CallsAttendedTransferOut') is not None:
            self.calls_attended_transfer_out = m.get('CallsAttendedTransferOut')
        if m.get('CallsBlindTransferIn') is not None:
            self.calls_blind_transfer_in = m.get('CallsBlindTransferIn')
        if m.get('CallsBlindTransferOut') is not None:
            self.calls_blind_transfer_out = m.get('CallsBlindTransferOut')
        if m.get('CallsDialed') is not None:
            self.calls_dialed = m.get('CallsDialed')
        if m.get('CallsHold') is not None:
            self.calls_hold = m.get('CallsHold')
        if m.get('CallsRinged') is not None:
            self.calls_ringed = m.get('CallsRinged')
        if m.get('MaxDialingTime') is not None:
            self.max_dialing_time = m.get('MaxDialingTime')
        if m.get('MaxHoldTime') is not None:
            self.max_hold_time = m.get('MaxHoldTime')
        if m.get('MaxRingTime') is not None:
            self.max_ring_time = m.get('MaxRingTime')
        if m.get('MaxTalkTime') is not None:
            self.max_talk_time = m.get('MaxTalkTime')
        if m.get('MaxWorkTime') is not None:
            self.max_work_time = m.get('MaxWorkTime')
        if m.get('SatisfactionIndex') is not None:
            self.satisfaction_index = m.get('SatisfactionIndex')
        if m.get('SatisfactionRate') is not None:
            self.satisfaction_rate = m.get('SatisfactionRate')
        if m.get('SatisfactionSurveysOffered') is not None:
            self.satisfaction_surveys_offered = m.get('SatisfactionSurveysOffered')
        if m.get('SatisfactionSurveysResponded') is not None:
            self.satisfaction_surveys_responded = m.get('SatisfactionSurveysResponded')
        if m.get('TotalDialingTime') is not None:
            self.total_dialing_time = m.get('TotalDialingTime')
        if m.get('TotalHoldTime') is not None:
            self.total_hold_time = m.get('TotalHoldTime')
        if m.get('TotalRingTime') is not None:
            self.total_ring_time = m.get('TotalRingTime')
        if m.get('TotalTalkTime') is not None:
            self.total_talk_time = m.get('TotalTalkTime')
        if m.get('TotalWorkTime') is not None:
            self.total_work_time = m.get('TotalWorkTime')
        return self


class ListHistoricalSkillGroupReportResponseBodyDataListOverall(TeaModel):
    def __init__(self, average_break_time=None, average_hold_time=None, average_ready_time=None,
                 average_talk_time=None, average_work_time=None, max_break_time=None, max_hold_time=None, max_ready_time=None,
                 max_talk_time=None, max_work_time=None, occupancy_rate=None, satisfaction_index=None, satisfaction_rate=None,
                 satisfaction_surveys_offered=None, satisfaction_surveys_responded=None, total_break_time=None, total_calls=None,
                 total_hold_time=None, total_logged_in_time=None, total_ready_time=None, total_talk_time=None,
                 total_work_time=None):
        self.average_break_time = average_break_time  # type: float
        self.average_hold_time = average_hold_time  # type: float
        self.average_ready_time = average_ready_time  # type: float
        self.average_talk_time = average_talk_time  # type: float
        self.average_work_time = average_work_time  # type: float
        self.max_break_time = max_break_time  # type: long
        self.max_hold_time = max_hold_time  # type: long
        self.max_ready_time = max_ready_time  # type: long
        self.max_talk_time = max_talk_time  # type: long
        self.max_work_time = max_work_time  # type: long
        self.occupancy_rate = occupancy_rate  # type: float
        self.satisfaction_index = satisfaction_index  # type: float
        self.satisfaction_rate = satisfaction_rate  # type: float
        self.satisfaction_surveys_offered = satisfaction_surveys_offered  # type: long
        self.satisfaction_surveys_responded = satisfaction_surveys_responded  # type: long
        self.total_break_time = total_break_time  # type: long
        self.total_calls = total_calls  # type: long
        self.total_hold_time = total_hold_time  # type: long
        self.total_logged_in_time = total_logged_in_time  # type: long
        self.total_ready_time = total_ready_time  # type: long
        self.total_talk_time = total_talk_time  # type: long
        self.total_work_time = total_work_time  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListHistoricalSkillGroupReportResponseBodyDataListOverall, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.average_break_time is not None:
            result['AverageBreakTime'] = self.average_break_time
        if self.average_hold_time is not None:
            result['AverageHoldTime'] = self.average_hold_time
        if self.average_ready_time is not None:
            result['AverageReadyTime'] = self.average_ready_time
        if self.average_talk_time is not None:
            result['AverageTalkTime'] = self.average_talk_time
        if self.average_work_time is not None:
            result['AverageWorkTime'] = self.average_work_time
        if self.max_break_time is not None:
            result['MaxBreakTime'] = self.max_break_time
        if self.max_hold_time is not None:
            result['MaxHoldTime'] = self.max_hold_time
        if self.max_ready_time is not None:
            result['MaxReadyTime'] = self.max_ready_time
        if self.max_talk_time is not None:
            result['MaxTalkTime'] = self.max_talk_time
        if self.max_work_time is not None:
            result['MaxWorkTime'] = self.max_work_time
        if self.occupancy_rate is not None:
            result['OccupancyRate'] = self.occupancy_rate
        if self.satisfaction_index is not None:
            result['SatisfactionIndex'] = self.satisfaction_index
        if self.satisfaction_rate is not None:
            result['SatisfactionRate'] = self.satisfaction_rate
        if self.satisfaction_surveys_offered is not None:
            result['SatisfactionSurveysOffered'] = self.satisfaction_surveys_offered
        if self.satisfaction_surveys_responded is not None:
            result['SatisfactionSurveysResponded'] = self.satisfaction_surveys_responded
        if self.total_break_time is not None:
            result['TotalBreakTime'] = self.total_break_time
        if self.total_calls is not None:
            result['TotalCalls'] = self.total_calls
        if self.total_hold_time is not None:
            result['TotalHoldTime'] = self.total_hold_time
        if self.total_logged_in_time is not None:
            result['TotalLoggedInTime'] = self.total_logged_in_time
        if self.total_ready_time is not None:
            result['TotalReadyTime'] = self.total_ready_time
        if self.total_talk_time is not None:
            result['TotalTalkTime'] = self.total_talk_time
        if self.total_work_time is not None:
            result['TotalWorkTime'] = self.total_work_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AverageBreakTime') is not None:
            self.average_break_time = m.get('AverageBreakTime')
        if m.get('AverageHoldTime') is not None:
            self.average_hold_time = m.get('AverageHoldTime')
        if m.get('AverageReadyTime') is not None:
            self.average_ready_time = m.get('AverageReadyTime')
        if m.get('AverageTalkTime') is not None:
            self.average_talk_time = m.get('AverageTalkTime')
        if m.get('AverageWorkTime') is not None:
            self.average_work_time = m.get('AverageWorkTime')
        if m.get('MaxBreakTime') is not None:
            self.max_break_time = m.get('MaxBreakTime')
        if m.get('MaxHoldTime') is not None:
            self.max_hold_time = m.get('MaxHoldTime')
        if m.get('MaxReadyTime') is not None:
            self.max_ready_time = m.get('MaxReadyTime')
        if m.get('MaxTalkTime') is not None:
            self.max_talk_time = m.get('MaxTalkTime')
        if m.get('MaxWorkTime') is not None:
            self.max_work_time = m.get('MaxWorkTime')
        if m.get('OccupancyRate') is not None:
            self.occupancy_rate = m.get('OccupancyRate')
        if m.get('SatisfactionIndex') is not None:
            self.satisfaction_index = m.get('SatisfactionIndex')
        if m.get('SatisfactionRate') is not None:
            self.satisfaction_rate = m.get('SatisfactionRate')
        if m.get('SatisfactionSurveysOffered') is not None:
            self.satisfaction_surveys_offered = m.get('SatisfactionSurveysOffered')
        if m.get('SatisfactionSurveysResponded') is not None:
            self.satisfaction_surveys_responded = m.get('SatisfactionSurveysResponded')
        if m.get('TotalBreakTime') is not None:
            self.total_break_time = m.get('TotalBreakTime')
        if m.get('TotalCalls') is not None:
            self.total_calls = m.get('TotalCalls')
        if m.get('TotalHoldTime') is not None:
            self.total_hold_time = m.get('TotalHoldTime')
        if m.get('TotalLoggedInTime') is not None:
            self.total_logged_in_time = m.get('TotalLoggedInTime')
        if m.get('TotalReadyTime') is not None:
            self.total_ready_time = m.get('TotalReadyTime')
        if m.get('TotalTalkTime') is not None:
            self.total_talk_time = m.get('TotalTalkTime')
        if m.get('TotalWorkTime') is not None:
            self.total_work_time = m.get('TotalWorkTime')
        return self


class ListHistoricalSkillGroupReportResponseBodyDataList(TeaModel):
    def __init__(self, inbound=None, outbound=None, overall=None, skill_group_id=None, skill_group_name=None):
        self.inbound = inbound  # type: ListHistoricalSkillGroupReportResponseBodyDataListInbound
        self.outbound = outbound  # type: ListHistoricalSkillGroupReportResponseBodyDataListOutbound
        self.overall = overall  # type: ListHistoricalSkillGroupReportResponseBodyDataListOverall
        self.skill_group_id = skill_group_id  # type: str
        self.skill_group_name = skill_group_name  # type: str

    def validate(self):
        if self.inbound:
            self.inbound.validate()
        if self.outbound:
            self.outbound.validate()
        if self.overall:
            self.overall.validate()

    def to_map(self):
        _map = super(ListHistoricalSkillGroupReportResponseBodyDataList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.inbound is not None:
            result['Inbound'] = self.inbound.to_map()
        if self.outbound is not None:
            result['Outbound'] = self.outbound.to_map()
        if self.overall is not None:
            result['Overall'] = self.overall.to_map()
        if self.skill_group_id is not None:
            result['SkillGroupId'] = self.skill_group_id
        if self.skill_group_name is not None:
            result['SkillGroupName'] = self.skill_group_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Inbound') is not None:
            temp_model = ListHistoricalSkillGroupReportResponseBodyDataListInbound()
            self.inbound = temp_model.from_map(m['Inbound'])
        if m.get('Outbound') is not None:
            temp_model = ListHistoricalSkillGroupReportResponseBodyDataListOutbound()
            self.outbound = temp_model.from_map(m['Outbound'])
        if m.get('Overall') is not None:
            temp_model = ListHistoricalSkillGroupReportResponseBodyDataListOverall()
            self.overall = temp_model.from_map(m['Overall'])
        if m.get('SkillGroupId') is not None:
            self.skill_group_id = m.get('SkillGroupId')
        if m.get('SkillGroupName') is not None:
            self.skill_group_name = m.get('SkillGroupName')
        return self


class ListHistoricalSkillGroupReportResponseBodyData(TeaModel):
    def __init__(self, list=None, page_number=None, page_size=None, total_count=None):
        self.list = list  # type: list[ListHistoricalSkillGroupReportResponseBodyDataList]
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.total_count = total_count  # type: int

    def validate(self):
        if self.list:
            for k in self.list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListHistoricalSkillGroupReportResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['List'] = []
        if self.list is not None:
            for k in self.list:
                result['List'].append(k.to_map() if k else None)
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.list = []
        if m.get('List') is not None:
            for k in m.get('List'):
                temp_model = ListHistoricalSkillGroupReportResponseBodyDataList()
                self.list.append(temp_model.from_map(k))
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListHistoricalSkillGroupReportResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: ListHistoricalSkillGroupReportResponseBodyData
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(ListHistoricalSkillGroupReportResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = ListHistoricalSkillGroupReportResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListHistoricalSkillGroupReportResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ListHistoricalSkillGroupReportResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListHistoricalSkillGroupReportResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListHistoricalSkillGroupReportResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListInstancesRequest(TeaModel):
    def __init__(self, page_number=None, page_size=None):
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListInstancesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class ListInstancesResponseBodyDataListAdminList(TeaModel):
    def __init__(self, display_name=None, email=None, extension=None, instance_id=None, login_name=None, mobile=None,
                 role_id=None, role_name=None, user_id=None, work_mode=None):
        self.display_name = display_name  # type: str
        self.email = email  # type: str
        self.extension = extension  # type: str
        self.instance_id = instance_id  # type: str
        self.login_name = login_name  # type: str
        self.mobile = mobile  # type: str
        self.role_id = role_id  # type: str
        self.role_name = role_name  # type: str
        self.user_id = user_id  # type: str
        self.work_mode = work_mode  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListInstancesResponseBodyDataListAdminList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.display_name is not None:
            result['DisplayName'] = self.display_name
        if self.email is not None:
            result['Email'] = self.email
        if self.extension is not None:
            result['Extension'] = self.extension
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.login_name is not None:
            result['LoginName'] = self.login_name
        if self.mobile is not None:
            result['Mobile'] = self.mobile
        if self.role_id is not None:
            result['RoleId'] = self.role_id
        if self.role_name is not None:
            result['RoleName'] = self.role_name
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.work_mode is not None:
            result['WorkMode'] = self.work_mode
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DisplayName') is not None:
            self.display_name = m.get('DisplayName')
        if m.get('Email') is not None:
            self.email = m.get('Email')
        if m.get('Extension') is not None:
            self.extension = m.get('Extension')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('LoginName') is not None:
            self.login_name = m.get('LoginName')
        if m.get('Mobile') is not None:
            self.mobile = m.get('Mobile')
        if m.get('RoleId') is not None:
            self.role_id = m.get('RoleId')
        if m.get('RoleName') is not None:
            self.role_name = m.get('RoleName')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('WorkMode') is not None:
            self.work_mode = m.get('WorkMode')
        return self


class ListInstancesResponseBodyDataListNumberList(TeaModel):
    def __init__(self, number=None):
        self.number = number  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListInstancesResponseBodyDataListNumberList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.number is not None:
            result['Number'] = self.number
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Number') is not None:
            self.number = m.get('Number')
        return self


class ListInstancesResponseBodyDataList(TeaModel):
    def __init__(self, admin_list=None, aliyun_uid=None, console_url=None, create_time=None, description=None,
                 domain_name=None, id=None, name=None, number_list=None, status=None):
        self.admin_list = admin_list  # type: list[ListInstancesResponseBodyDataListAdminList]
        self.aliyun_uid = aliyun_uid  # type: str
        self.console_url = console_url  # type: str
        self.create_time = create_time  # type: long
        self.description = description  # type: str
        self.domain_name = domain_name  # type: str
        self.id = id  # type: str
        self.name = name  # type: str
        self.number_list = number_list  # type: list[ListInstancesResponseBodyDataListNumberList]
        self.status = status  # type: str

    def validate(self):
        if self.admin_list:
            for k in self.admin_list:
                if k:
                    k.validate()
        if self.number_list:
            for k in self.number_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListInstancesResponseBodyDataList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AdminList'] = []
        if self.admin_list is not None:
            for k in self.admin_list:
                result['AdminList'].append(k.to_map() if k else None)
        if self.aliyun_uid is not None:
            result['AliyunUid'] = self.aliyun_uid
        if self.console_url is not None:
            result['ConsoleUrl'] = self.console_url
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.description is not None:
            result['Description'] = self.description
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.id is not None:
            result['Id'] = self.id
        if self.name is not None:
            result['Name'] = self.name
        result['NumberList'] = []
        if self.number_list is not None:
            for k in self.number_list:
                result['NumberList'].append(k.to_map() if k else None)
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.admin_list = []
        if m.get('AdminList') is not None:
            for k in m.get('AdminList'):
                temp_model = ListInstancesResponseBodyDataListAdminList()
                self.admin_list.append(temp_model.from_map(k))
        if m.get('AliyunUid') is not None:
            self.aliyun_uid = m.get('AliyunUid')
        if m.get('ConsoleUrl') is not None:
            self.console_url = m.get('ConsoleUrl')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        self.number_list = []
        if m.get('NumberList') is not None:
            for k in m.get('NumberList'):
                temp_model = ListInstancesResponseBodyDataListNumberList()
                self.number_list.append(temp_model.from_map(k))
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class ListInstancesResponseBodyData(TeaModel):
    def __init__(self, list=None, page_number=None, page_size=None, total_count=None):
        self.list = list  # type: list[ListInstancesResponseBodyDataList]
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.total_count = total_count  # type: int

    def validate(self):
        if self.list:
            for k in self.list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListInstancesResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['List'] = []
        if self.list is not None:
            for k in self.list:
                result['List'].append(k.to_map() if k else None)
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.list = []
        if m.get('List') is not None:
            for k in m.get('List'):
                temp_model = ListInstancesResponseBodyDataList()
                self.list.append(temp_model.from_map(k))
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListInstancesResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, params=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: ListInstancesResponseBodyData
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.params = params  # type: list[str]
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(ListInstancesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.params is not None:
            result['Params'] = self.params
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = ListInstancesResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Params') is not None:
            self.params = m.get('Params')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListInstancesResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ListInstancesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListInstancesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListInstancesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListInstancesOfUserRequest(TeaModel):
    def __init__(self, page_number=None, page_size=None):
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListInstancesOfUserRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class ListInstancesOfUserResponseBodyDataListAdminList(TeaModel):
    def __init__(self, display_name=None, email=None, extension=None, instance_id=None, login_name=None, mobile=None,
                 role_id=None, role_name=None, user_id=None, work_mode=None):
        self.display_name = display_name  # type: str
        self.email = email  # type: str
        self.extension = extension  # type: str
        self.instance_id = instance_id  # type: str
        self.login_name = login_name  # type: str
        self.mobile = mobile  # type: str
        self.role_id = role_id  # type: str
        self.role_name = role_name  # type: str
        self.user_id = user_id  # type: str
        self.work_mode = work_mode  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListInstancesOfUserResponseBodyDataListAdminList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.display_name is not None:
            result['DisplayName'] = self.display_name
        if self.email is not None:
            result['Email'] = self.email
        if self.extension is not None:
            result['Extension'] = self.extension
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.login_name is not None:
            result['LoginName'] = self.login_name
        if self.mobile is not None:
            result['Mobile'] = self.mobile
        if self.role_id is not None:
            result['RoleId'] = self.role_id
        if self.role_name is not None:
            result['RoleName'] = self.role_name
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.work_mode is not None:
            result['WorkMode'] = self.work_mode
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DisplayName') is not None:
            self.display_name = m.get('DisplayName')
        if m.get('Email') is not None:
            self.email = m.get('Email')
        if m.get('Extension') is not None:
            self.extension = m.get('Extension')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('LoginName') is not None:
            self.login_name = m.get('LoginName')
        if m.get('Mobile') is not None:
            self.mobile = m.get('Mobile')
        if m.get('RoleId') is not None:
            self.role_id = m.get('RoleId')
        if m.get('RoleName') is not None:
            self.role_name = m.get('RoleName')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('WorkMode') is not None:
            self.work_mode = m.get('WorkMode')
        return self


class ListInstancesOfUserResponseBodyDataListNumberListSkillGroups(TeaModel):
    def __init__(self, description=None, display_name=None, instance_id=None, name=None, phone_number_count=None,
                 skill_group_id=None, user_count=None):
        self.description = description  # type: str
        self.display_name = display_name  # type: str
        self.instance_id = instance_id  # type: str
        self.name = name  # type: str
        self.phone_number_count = phone_number_count  # type: int
        self.skill_group_id = skill_group_id  # type: str
        self.user_count = user_count  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListInstancesOfUserResponseBodyDataListNumberListSkillGroups, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.display_name is not None:
            result['DisplayName'] = self.display_name
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.name is not None:
            result['Name'] = self.name
        if self.phone_number_count is not None:
            result['PhoneNumberCount'] = self.phone_number_count
        if self.skill_group_id is not None:
            result['SkillGroupId'] = self.skill_group_id
        if self.user_count is not None:
            result['UserCount'] = self.user_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DisplayName') is not None:
            self.display_name = m.get('DisplayName')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PhoneNumberCount') is not None:
            self.phone_number_count = m.get('PhoneNumberCount')
        if m.get('SkillGroupId') is not None:
            self.skill_group_id = m.get('SkillGroupId')
        if m.get('UserCount') is not None:
            self.user_count = m.get('UserCount')
        return self


class ListInstancesOfUserResponseBodyDataListNumberList(TeaModel):
    def __init__(self, active=None, city=None, contact_flow_id=None, instance_id=None, number=None, province=None,
                 skill_groups=None, usage=None, user_id=None):
        self.active = active  # type: bool
        self.city = city  # type: str
        self.contact_flow_id = contact_flow_id  # type: str
        self.instance_id = instance_id  # type: str
        self.number = number  # type: str
        self.province = province  # type: str
        self.skill_groups = skill_groups  # type: list[ListInstancesOfUserResponseBodyDataListNumberListSkillGroups]
        self.usage = usage  # type: str
        self.user_id = user_id  # type: str

    def validate(self):
        if self.skill_groups:
            for k in self.skill_groups:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListInstancesOfUserResponseBodyDataListNumberList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.active is not None:
            result['Active'] = self.active
        if self.city is not None:
            result['City'] = self.city
        if self.contact_flow_id is not None:
            result['ContactFlowId'] = self.contact_flow_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.number is not None:
            result['Number'] = self.number
        if self.province is not None:
            result['Province'] = self.province
        result['SkillGroups'] = []
        if self.skill_groups is not None:
            for k in self.skill_groups:
                result['SkillGroups'].append(k.to_map() if k else None)
        if self.usage is not None:
            result['Usage'] = self.usage
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Active') is not None:
            self.active = m.get('Active')
        if m.get('City') is not None:
            self.city = m.get('City')
        if m.get('ContactFlowId') is not None:
            self.contact_flow_id = m.get('ContactFlowId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Number') is not None:
            self.number = m.get('Number')
        if m.get('Province') is not None:
            self.province = m.get('Province')
        self.skill_groups = []
        if m.get('SkillGroups') is not None:
            for k in m.get('SkillGroups'):
                temp_model = ListInstancesOfUserResponseBodyDataListNumberListSkillGroups()
                self.skill_groups.append(temp_model.from_map(k))
        if m.get('Usage') is not None:
            self.usage = m.get('Usage')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class ListInstancesOfUserResponseBodyDataList(TeaModel):
    def __init__(self, admin_list=None, aliyun_uid=None, console_url=None, description=None, domain_name=None,
                 id=None, name=None, number_list=None, status=None):
        self.admin_list = admin_list  # type: list[ListInstancesOfUserResponseBodyDataListAdminList]
        self.aliyun_uid = aliyun_uid  # type: str
        self.console_url = console_url  # type: str
        self.description = description  # type: str
        self.domain_name = domain_name  # type: str
        self.id = id  # type: str
        self.name = name  # type: str
        self.number_list = number_list  # type: list[ListInstancesOfUserResponseBodyDataListNumberList]
        self.status = status  # type: str

    def validate(self):
        if self.admin_list:
            for k in self.admin_list:
                if k:
                    k.validate()
        if self.number_list:
            for k in self.number_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListInstancesOfUserResponseBodyDataList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AdminList'] = []
        if self.admin_list is not None:
            for k in self.admin_list:
                result['AdminList'].append(k.to_map() if k else None)
        if self.aliyun_uid is not None:
            result['AliyunUid'] = self.aliyun_uid
        if self.console_url is not None:
            result['ConsoleUrl'] = self.console_url
        if self.description is not None:
            result['Description'] = self.description
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.id is not None:
            result['Id'] = self.id
        if self.name is not None:
            result['Name'] = self.name
        result['NumberList'] = []
        if self.number_list is not None:
            for k in self.number_list:
                result['NumberList'].append(k.to_map() if k else None)
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.admin_list = []
        if m.get('AdminList') is not None:
            for k in m.get('AdminList'):
                temp_model = ListInstancesOfUserResponseBodyDataListAdminList()
                self.admin_list.append(temp_model.from_map(k))
        if m.get('AliyunUid') is not None:
            self.aliyun_uid = m.get('AliyunUid')
        if m.get('ConsoleUrl') is not None:
            self.console_url = m.get('ConsoleUrl')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        self.number_list = []
        if m.get('NumberList') is not None:
            for k in m.get('NumberList'):
                temp_model = ListInstancesOfUserResponseBodyDataListNumberList()
                self.number_list.append(temp_model.from_map(k))
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class ListInstancesOfUserResponseBodyData(TeaModel):
    def __init__(self, list=None, page_number=None, page_size=None, total_count=None):
        self.list = list  # type: list[ListInstancesOfUserResponseBodyDataList]
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.total_count = total_count  # type: int

    def validate(self):
        if self.list:
            for k in self.list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListInstancesOfUserResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['List'] = []
        if self.list is not None:
            for k in self.list:
                result['List'].append(k.to_map() if k else None)
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.list = []
        if m.get('List') is not None:
            for k in m.get('List'):
                temp_model = ListInstancesOfUserResponseBodyDataList()
                self.list.append(temp_model.from_map(k))
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListInstancesOfUserResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, params=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: ListInstancesOfUserResponseBodyData
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.params = params  # type: list[str]
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(ListInstancesOfUserResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.params is not None:
            result['Params'] = self.params
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = ListInstancesOfUserResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Params') is not None:
            self.params = m.get('Params')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListInstancesOfUserResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ListInstancesOfUserResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListInstancesOfUserResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListInstancesOfUserResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListIntervalAgentReportRequest(TeaModel):
    def __init__(self, agent_id=None, end_time=None, instance_id=None, interval=None, start_time=None):
        self.agent_id = agent_id  # type: str
        self.end_time = end_time  # type: long
        self.instance_id = instance_id  # type: str
        self.interval = interval  # type: str
        self.start_time = start_time  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListIntervalAgentReportRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_id is not None:
            result['AgentId'] = self.agent_id
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.interval is not None:
            result['Interval'] = self.interval
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AgentId') is not None:
            self.agent_id = m.get('AgentId')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Interval') is not None:
            self.interval = m.get('Interval')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class ListIntervalAgentReportResponseBodyDataInbound(TeaModel):
    def __init__(self, average_hold_time=None, average_ring_time=None, average_talk_time=None,
                 average_work_time=None, calls_attended_transfer_in=None, calls_attended_transfer_out=None,
                 calls_blind_transfer_in=None, calls_blind_transfer_out=None, calls_handled=None, calls_hold=None, calls_offered=None,
                 calls_ringed=None, handle_rate=None, max_hold_time=None, max_ring_time=None, max_talk_time=None,
                 max_work_time=None, satisfaction_index=None, satisfaction_rate=None, satisfaction_surveys_offered=None,
                 satisfaction_surveys_responded=None, total_hold_time=None, total_ring_time=None, total_talk_time=None, total_work_time=None):
        self.average_hold_time = average_hold_time  # type: float
        self.average_ring_time = average_ring_time  # type: float
        self.average_talk_time = average_talk_time  # type: float
        self.average_work_time = average_work_time  # type: float
        self.calls_attended_transfer_in = calls_attended_transfer_in  # type: long
        self.calls_attended_transfer_out = calls_attended_transfer_out  # type: long
        self.calls_blind_transfer_in = calls_blind_transfer_in  # type: long
        self.calls_blind_transfer_out = calls_blind_transfer_out  # type: long
        self.calls_handled = calls_handled  # type: long
        self.calls_hold = calls_hold  # type: long
        self.calls_offered = calls_offered  # type: long
        self.calls_ringed = calls_ringed  # type: long
        self.handle_rate = handle_rate  # type: float
        self.max_hold_time = max_hold_time  # type: long
        self.max_ring_time = max_ring_time  # type: long
        self.max_talk_time = max_talk_time  # type: long
        self.max_work_time = max_work_time  # type: long
        self.satisfaction_index = satisfaction_index  # type: float
        self.satisfaction_rate = satisfaction_rate  # type: float
        self.satisfaction_surveys_offered = satisfaction_surveys_offered  # type: long
        self.satisfaction_surveys_responded = satisfaction_surveys_responded  # type: long
        self.total_hold_time = total_hold_time  # type: long
        self.total_ring_time = total_ring_time  # type: long
        self.total_talk_time = total_talk_time  # type: long
        self.total_work_time = total_work_time  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListIntervalAgentReportResponseBodyDataInbound, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.average_hold_time is not None:
            result['AverageHoldTime'] = self.average_hold_time
        if self.average_ring_time is not None:
            result['AverageRingTime'] = self.average_ring_time
        if self.average_talk_time is not None:
            result['AverageTalkTime'] = self.average_talk_time
        if self.average_work_time is not None:
            result['AverageWorkTime'] = self.average_work_time
        if self.calls_attended_transfer_in is not None:
            result['CallsAttendedTransferIn'] = self.calls_attended_transfer_in
        if self.calls_attended_transfer_out is not None:
            result['CallsAttendedTransferOut'] = self.calls_attended_transfer_out
        if self.calls_blind_transfer_in is not None:
            result['CallsBlindTransferIn'] = self.calls_blind_transfer_in
        if self.calls_blind_transfer_out is not None:
            result['CallsBlindTransferOut'] = self.calls_blind_transfer_out
        if self.calls_handled is not None:
            result['CallsHandled'] = self.calls_handled
        if self.calls_hold is not None:
            result['CallsHold'] = self.calls_hold
        if self.calls_offered is not None:
            result['CallsOffered'] = self.calls_offered
        if self.calls_ringed is not None:
            result['CallsRinged'] = self.calls_ringed
        if self.handle_rate is not None:
            result['HandleRate'] = self.handle_rate
        if self.max_hold_time is not None:
            result['MaxHoldTime'] = self.max_hold_time
        if self.max_ring_time is not None:
            result['MaxRingTime'] = self.max_ring_time
        if self.max_talk_time is not None:
            result['MaxTalkTime'] = self.max_talk_time
        if self.max_work_time is not None:
            result['MaxWorkTime'] = self.max_work_time
        if self.satisfaction_index is not None:
            result['SatisfactionIndex'] = self.satisfaction_index
        if self.satisfaction_rate is not None:
            result['SatisfactionRate'] = self.satisfaction_rate
        if self.satisfaction_surveys_offered is not None:
            result['SatisfactionSurveysOffered'] = self.satisfaction_surveys_offered
        if self.satisfaction_surveys_responded is not None:
            result['SatisfactionSurveysResponded'] = self.satisfaction_surveys_responded
        if self.total_hold_time is not None:
            result['TotalHoldTime'] = self.total_hold_time
        if self.total_ring_time is not None:
            result['TotalRingTime'] = self.total_ring_time
        if self.total_talk_time is not None:
            result['TotalTalkTime'] = self.total_talk_time
        if self.total_work_time is not None:
            result['TotalWorkTime'] = self.total_work_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AverageHoldTime') is not None:
            self.average_hold_time = m.get('AverageHoldTime')
        if m.get('AverageRingTime') is not None:
            self.average_ring_time = m.get('AverageRingTime')
        if m.get('AverageTalkTime') is not None:
            self.average_talk_time = m.get('AverageTalkTime')
        if m.get('AverageWorkTime') is not None:
            self.average_work_time = m.get('AverageWorkTime')
        if m.get('CallsAttendedTransferIn') is not None:
            self.calls_attended_transfer_in = m.get('CallsAttendedTransferIn')
        if m.get('CallsAttendedTransferOut') is not None:
            self.calls_attended_transfer_out = m.get('CallsAttendedTransferOut')
        if m.get('CallsBlindTransferIn') is not None:
            self.calls_blind_transfer_in = m.get('CallsBlindTransferIn')
        if m.get('CallsBlindTransferOut') is not None:
            self.calls_blind_transfer_out = m.get('CallsBlindTransferOut')
        if m.get('CallsHandled') is not None:
            self.calls_handled = m.get('CallsHandled')
        if m.get('CallsHold') is not None:
            self.calls_hold = m.get('CallsHold')
        if m.get('CallsOffered') is not None:
            self.calls_offered = m.get('CallsOffered')
        if m.get('CallsRinged') is not None:
            self.calls_ringed = m.get('CallsRinged')
        if m.get('HandleRate') is not None:
            self.handle_rate = m.get('HandleRate')
        if m.get('MaxHoldTime') is not None:
            self.max_hold_time = m.get('MaxHoldTime')
        if m.get('MaxRingTime') is not None:
            self.max_ring_time = m.get('MaxRingTime')
        if m.get('MaxTalkTime') is not None:
            self.max_talk_time = m.get('MaxTalkTime')
        if m.get('MaxWorkTime') is not None:
            self.max_work_time = m.get('MaxWorkTime')
        if m.get('SatisfactionIndex') is not None:
            self.satisfaction_index = m.get('SatisfactionIndex')
        if m.get('SatisfactionRate') is not None:
            self.satisfaction_rate = m.get('SatisfactionRate')
        if m.get('SatisfactionSurveysOffered') is not None:
            self.satisfaction_surveys_offered = m.get('SatisfactionSurveysOffered')
        if m.get('SatisfactionSurveysResponded') is not None:
            self.satisfaction_surveys_responded = m.get('SatisfactionSurveysResponded')
        if m.get('TotalHoldTime') is not None:
            self.total_hold_time = m.get('TotalHoldTime')
        if m.get('TotalRingTime') is not None:
            self.total_ring_time = m.get('TotalRingTime')
        if m.get('TotalTalkTime') is not None:
            self.total_talk_time = m.get('TotalTalkTime')
        if m.get('TotalWorkTime') is not None:
            self.total_work_time = m.get('TotalWorkTime')
        return self


class ListIntervalAgentReportResponseBodyDataOutbound(TeaModel):
    def __init__(self, answer_rate=None, average_dialing_time=None, average_hold_time=None, average_ring_time=None,
                 average_talk_time=None, average_work_time=None, calls_answered=None, calls_attended_transfer_in=None,
                 calls_attended_transfer_out=None, calls_blind_transfer_in=None, calls_blind_transfer_out=None, calls_dialed=None,
                 calls_hold=None, calls_ringed=None, max_dialing_time=None, max_hold_time=None, max_ring_time=None,
                 max_talk_time=None, max_work_time=None, satisfaction_index=None, satisfaction_rate=None,
                 satisfaction_surveys_offered=None, satisfaction_surveys_responded=None, total_dialing_time=None, total_hold_time=None,
                 total_ring_time=None, total_talk_time=None, total_work_time=None):
        self.answer_rate = answer_rate  # type: float
        self.average_dialing_time = average_dialing_time  # type: float
        self.average_hold_time = average_hold_time  # type: float
        self.average_ring_time = average_ring_time  # type: float
        self.average_talk_time = average_talk_time  # type: float
        self.average_work_time = average_work_time  # type: float
        self.calls_answered = calls_answered  # type: long
        self.calls_attended_transfer_in = calls_attended_transfer_in  # type: long
        self.calls_attended_transfer_out = calls_attended_transfer_out  # type: long
        self.calls_blind_transfer_in = calls_blind_transfer_in  # type: long
        self.calls_blind_transfer_out = calls_blind_transfer_out  # type: long
        self.calls_dialed = calls_dialed  # type: long
        self.calls_hold = calls_hold  # type: long
        self.calls_ringed = calls_ringed  # type: long
        self.max_dialing_time = max_dialing_time  # type: long
        self.max_hold_time = max_hold_time  # type: long
        self.max_ring_time = max_ring_time  # type: long
        self.max_talk_time = max_talk_time  # type: long
        self.max_work_time = max_work_time  # type: long
        self.satisfaction_index = satisfaction_index  # type: float
        self.satisfaction_rate = satisfaction_rate  # type: float
        self.satisfaction_surveys_offered = satisfaction_surveys_offered  # type: long
        self.satisfaction_surveys_responded = satisfaction_surveys_responded  # type: long
        self.total_dialing_time = total_dialing_time  # type: long
        self.total_hold_time = total_hold_time  # type: long
        self.total_ring_time = total_ring_time  # type: long
        self.total_talk_time = total_talk_time  # type: long
        self.total_work_time = total_work_time  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListIntervalAgentReportResponseBodyDataOutbound, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.answer_rate is not None:
            result['AnswerRate'] = self.answer_rate
        if self.average_dialing_time is not None:
            result['AverageDialingTime'] = self.average_dialing_time
        if self.average_hold_time is not None:
            result['AverageHoldTime'] = self.average_hold_time
        if self.average_ring_time is not None:
            result['AverageRingTime'] = self.average_ring_time
        if self.average_talk_time is not None:
            result['AverageTalkTime'] = self.average_talk_time
        if self.average_work_time is not None:
            result['AverageWorkTime'] = self.average_work_time
        if self.calls_answered is not None:
            result['CallsAnswered'] = self.calls_answered
        if self.calls_attended_transfer_in is not None:
            result['CallsAttendedTransferIn'] = self.calls_attended_transfer_in
        if self.calls_attended_transfer_out is not None:
            result['CallsAttendedTransferOut'] = self.calls_attended_transfer_out
        if self.calls_blind_transfer_in is not None:
            result['CallsBlindTransferIn'] = self.calls_blind_transfer_in
        if self.calls_blind_transfer_out is not None:
            result['CallsBlindTransferOut'] = self.calls_blind_transfer_out
        if self.calls_dialed is not None:
            result['CallsDialed'] = self.calls_dialed
        if self.calls_hold is not None:
            result['CallsHold'] = self.calls_hold
        if self.calls_ringed is not None:
            result['CallsRinged'] = self.calls_ringed
        if self.max_dialing_time is not None:
            result['MaxDialingTime'] = self.max_dialing_time
        if self.max_hold_time is not None:
            result['MaxHoldTime'] = self.max_hold_time
        if self.max_ring_time is not None:
            result['MaxRingTime'] = self.max_ring_time
        if self.max_talk_time is not None:
            result['MaxTalkTime'] = self.max_talk_time
        if self.max_work_time is not None:
            result['MaxWorkTime'] = self.max_work_time
        if self.satisfaction_index is not None:
            result['SatisfactionIndex'] = self.satisfaction_index
        if self.satisfaction_rate is not None:
            result['SatisfactionRate'] = self.satisfaction_rate
        if self.satisfaction_surveys_offered is not None:
            result['SatisfactionSurveysOffered'] = self.satisfaction_surveys_offered
        if self.satisfaction_surveys_responded is not None:
            result['SatisfactionSurveysResponded'] = self.satisfaction_surveys_responded
        if self.total_dialing_time is not None:
            result['TotalDialingTime'] = self.total_dialing_time
        if self.total_hold_time is not None:
            result['TotalHoldTime'] = self.total_hold_time
        if self.total_ring_time is not None:
            result['TotalRingTime'] = self.total_ring_time
        if self.total_talk_time is not None:
            result['TotalTalkTime'] = self.total_talk_time
        if self.total_work_time is not None:
            result['TotalWorkTime'] = self.total_work_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AnswerRate') is not None:
            self.answer_rate = m.get('AnswerRate')
        if m.get('AverageDialingTime') is not None:
            self.average_dialing_time = m.get('AverageDialingTime')
        if m.get('AverageHoldTime') is not None:
            self.average_hold_time = m.get('AverageHoldTime')
        if m.get('AverageRingTime') is not None:
            self.average_ring_time = m.get('AverageRingTime')
        if m.get('AverageTalkTime') is not None:
            self.average_talk_time = m.get('AverageTalkTime')
        if m.get('AverageWorkTime') is not None:
            self.average_work_time = m.get('AverageWorkTime')
        if m.get('CallsAnswered') is not None:
            self.calls_answered = m.get('CallsAnswered')
        if m.get('CallsAttendedTransferIn') is not None:
            self.calls_attended_transfer_in = m.get('CallsAttendedTransferIn')
        if m.get('CallsAttendedTransferOut') is not None:
            self.calls_attended_transfer_out = m.get('CallsAttendedTransferOut')
        if m.get('CallsBlindTransferIn') is not None:
            self.calls_blind_transfer_in = m.get('CallsBlindTransferIn')
        if m.get('CallsBlindTransferOut') is not None:
            self.calls_blind_transfer_out = m.get('CallsBlindTransferOut')
        if m.get('CallsDialed') is not None:
            self.calls_dialed = m.get('CallsDialed')
        if m.get('CallsHold') is not None:
            self.calls_hold = m.get('CallsHold')
        if m.get('CallsRinged') is not None:
            self.calls_ringed = m.get('CallsRinged')
        if m.get('MaxDialingTime') is not None:
            self.max_dialing_time = m.get('MaxDialingTime')
        if m.get('MaxHoldTime') is not None:
            self.max_hold_time = m.get('MaxHoldTime')
        if m.get('MaxRingTime') is not None:
            self.max_ring_time = m.get('MaxRingTime')
        if m.get('MaxTalkTime') is not None:
            self.max_talk_time = m.get('MaxTalkTime')
        if m.get('MaxWorkTime') is not None:
            self.max_work_time = m.get('MaxWorkTime')
        if m.get('SatisfactionIndex') is not None:
            self.satisfaction_index = m.get('SatisfactionIndex')
        if m.get('SatisfactionRate') is not None:
            self.satisfaction_rate = m.get('SatisfactionRate')
        if m.get('SatisfactionSurveysOffered') is not None:
            self.satisfaction_surveys_offered = m.get('SatisfactionSurveysOffered')
        if m.get('SatisfactionSurveysResponded') is not None:
            self.satisfaction_surveys_responded = m.get('SatisfactionSurveysResponded')
        if m.get('TotalDialingTime') is not None:
            self.total_dialing_time = m.get('TotalDialingTime')
        if m.get('TotalHoldTime') is not None:
            self.total_hold_time = m.get('TotalHoldTime')
        if m.get('TotalRingTime') is not None:
            self.total_ring_time = m.get('TotalRingTime')
        if m.get('TotalTalkTime') is not None:
            self.total_talk_time = m.get('TotalTalkTime')
        if m.get('TotalWorkTime') is not None:
            self.total_work_time = m.get('TotalWorkTime')
        return self


class ListIntervalAgentReportResponseBodyDataOverall(TeaModel):
    def __init__(self, average_break_time=None, average_hold_time=None, average_ready_time=None,
                 average_talk_time=None, average_work_time=None, first_check_in_time=None, last_checkout_time=None,
                 max_break_time=None, max_hold_time=None, max_ready_time=None, max_talk_time=None, max_work_time=None,
                 occupancy_rate=None, satisfaction_index=None, satisfaction_rate=None, satisfaction_surveys_offered=None,
                 satisfaction_surveys_responded=None, total_break_time=None, total_calls=None, total_hold_time=None, total_logged_in_time=None,
                 total_ready_time=None, total_talk_time=None, total_work_time=None):
        self.average_break_time = average_break_time  # type: float
        self.average_hold_time = average_hold_time  # type: float
        self.average_ready_time = average_ready_time  # type: float
        self.average_talk_time = average_talk_time  # type: float
        self.average_work_time = average_work_time  # type: float
        self.first_check_in_time = first_check_in_time  # type: long
        self.last_checkout_time = last_checkout_time  # type: long
        self.max_break_time = max_break_time  # type: long
        self.max_hold_time = max_hold_time  # type: long
        self.max_ready_time = max_ready_time  # type: long
        self.max_talk_time = max_talk_time  # type: long
        self.max_work_time = max_work_time  # type: long
        self.occupancy_rate = occupancy_rate  # type: float
        self.satisfaction_index = satisfaction_index  # type: float
        self.satisfaction_rate = satisfaction_rate  # type: float
        self.satisfaction_surveys_offered = satisfaction_surveys_offered  # type: long
        self.satisfaction_surveys_responded = satisfaction_surveys_responded  # type: long
        self.total_break_time = total_break_time  # type: long
        self.total_calls = total_calls  # type: long
        self.total_hold_time = total_hold_time  # type: long
        self.total_logged_in_time = total_logged_in_time  # type: long
        self.total_ready_time = total_ready_time  # type: long
        self.total_talk_time = total_talk_time  # type: long
        self.total_work_time = total_work_time  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListIntervalAgentReportResponseBodyDataOverall, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.average_break_time is not None:
            result['AverageBreakTime'] = self.average_break_time
        if self.average_hold_time is not None:
            result['AverageHoldTime'] = self.average_hold_time
        if self.average_ready_time is not None:
            result['AverageReadyTime'] = self.average_ready_time
        if self.average_talk_time is not None:
            result['AverageTalkTime'] = self.average_talk_time
        if self.average_work_time is not None:
            result['AverageWorkTime'] = self.average_work_time
        if self.first_check_in_time is not None:
            result['FirstCheckInTime'] = self.first_check_in_time
        if self.last_checkout_time is not None:
            result['LastCheckoutTime'] = self.last_checkout_time
        if self.max_break_time is not None:
            result['MaxBreakTime'] = self.max_break_time
        if self.max_hold_time is not None:
            result['MaxHoldTime'] = self.max_hold_time
        if self.max_ready_time is not None:
            result['MaxReadyTime'] = self.max_ready_time
        if self.max_talk_time is not None:
            result['MaxTalkTime'] = self.max_talk_time
        if self.max_work_time is not None:
            result['MaxWorkTime'] = self.max_work_time
        if self.occupancy_rate is not None:
            result['OccupancyRate'] = self.occupancy_rate
        if self.satisfaction_index is not None:
            result['SatisfactionIndex'] = self.satisfaction_index
        if self.satisfaction_rate is not None:
            result['SatisfactionRate'] = self.satisfaction_rate
        if self.satisfaction_surveys_offered is not None:
            result['SatisfactionSurveysOffered'] = self.satisfaction_surveys_offered
        if self.satisfaction_surveys_responded is not None:
            result['SatisfactionSurveysResponded'] = self.satisfaction_surveys_responded
        if self.total_break_time is not None:
            result['TotalBreakTime'] = self.total_break_time
        if self.total_calls is not None:
            result['TotalCalls'] = self.total_calls
        if self.total_hold_time is not None:
            result['TotalHoldTime'] = self.total_hold_time
        if self.total_logged_in_time is not None:
            result['TotalLoggedInTime'] = self.total_logged_in_time
        if self.total_ready_time is not None:
            result['TotalReadyTime'] = self.total_ready_time
        if self.total_talk_time is not None:
            result['TotalTalkTime'] = self.total_talk_time
        if self.total_work_time is not None:
            result['TotalWorkTime'] = self.total_work_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AverageBreakTime') is not None:
            self.average_break_time = m.get('AverageBreakTime')
        if m.get('AverageHoldTime') is not None:
            self.average_hold_time = m.get('AverageHoldTime')
        if m.get('AverageReadyTime') is not None:
            self.average_ready_time = m.get('AverageReadyTime')
        if m.get('AverageTalkTime') is not None:
            self.average_talk_time = m.get('AverageTalkTime')
        if m.get('AverageWorkTime') is not None:
            self.average_work_time = m.get('AverageWorkTime')
        if m.get('FirstCheckInTime') is not None:
            self.first_check_in_time = m.get('FirstCheckInTime')
        if m.get('LastCheckoutTime') is not None:
            self.last_checkout_time = m.get('LastCheckoutTime')
        if m.get('MaxBreakTime') is not None:
            self.max_break_time = m.get('MaxBreakTime')
        if m.get('MaxHoldTime') is not None:
            self.max_hold_time = m.get('MaxHoldTime')
        if m.get('MaxReadyTime') is not None:
            self.max_ready_time = m.get('MaxReadyTime')
        if m.get('MaxTalkTime') is not None:
            self.max_talk_time = m.get('MaxTalkTime')
        if m.get('MaxWorkTime') is not None:
            self.max_work_time = m.get('MaxWorkTime')
        if m.get('OccupancyRate') is not None:
            self.occupancy_rate = m.get('OccupancyRate')
        if m.get('SatisfactionIndex') is not None:
            self.satisfaction_index = m.get('SatisfactionIndex')
        if m.get('SatisfactionRate') is not None:
            self.satisfaction_rate = m.get('SatisfactionRate')
        if m.get('SatisfactionSurveysOffered') is not None:
            self.satisfaction_surveys_offered = m.get('SatisfactionSurveysOffered')
        if m.get('SatisfactionSurveysResponded') is not None:
            self.satisfaction_surveys_responded = m.get('SatisfactionSurveysResponded')
        if m.get('TotalBreakTime') is not None:
            self.total_break_time = m.get('TotalBreakTime')
        if m.get('TotalCalls') is not None:
            self.total_calls = m.get('TotalCalls')
        if m.get('TotalHoldTime') is not None:
            self.total_hold_time = m.get('TotalHoldTime')
        if m.get('TotalLoggedInTime') is not None:
            self.total_logged_in_time = m.get('TotalLoggedInTime')
        if m.get('TotalReadyTime') is not None:
            self.total_ready_time = m.get('TotalReadyTime')
        if m.get('TotalTalkTime') is not None:
            self.total_talk_time = m.get('TotalTalkTime')
        if m.get('TotalWorkTime') is not None:
            self.total_work_time = m.get('TotalWorkTime')
        return self


class ListIntervalAgentReportResponseBodyData(TeaModel):
    def __init__(self, inbound=None, outbound=None, overall=None, stats_time=None):
        self.inbound = inbound  # type: ListIntervalAgentReportResponseBodyDataInbound
        self.outbound = outbound  # type: ListIntervalAgentReportResponseBodyDataOutbound
        self.overall = overall  # type: ListIntervalAgentReportResponseBodyDataOverall
        self.stats_time = stats_time  # type: long

    def validate(self):
        if self.inbound:
            self.inbound.validate()
        if self.outbound:
            self.outbound.validate()
        if self.overall:
            self.overall.validate()

    def to_map(self):
        _map = super(ListIntervalAgentReportResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.inbound is not None:
            result['Inbound'] = self.inbound.to_map()
        if self.outbound is not None:
            result['Outbound'] = self.outbound.to_map()
        if self.overall is not None:
            result['Overall'] = self.overall.to_map()
        if self.stats_time is not None:
            result['StatsTime'] = self.stats_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Inbound') is not None:
            temp_model = ListIntervalAgentReportResponseBodyDataInbound()
            self.inbound = temp_model.from_map(m['Inbound'])
        if m.get('Outbound') is not None:
            temp_model = ListIntervalAgentReportResponseBodyDataOutbound()
            self.outbound = temp_model.from_map(m['Outbound'])
        if m.get('Overall') is not None:
            temp_model = ListIntervalAgentReportResponseBodyDataOverall()
            self.overall = temp_model.from_map(m['Overall'])
        if m.get('StatsTime') is not None:
            self.stats_time = m.get('StatsTime')
        return self


class ListIntervalAgentReportResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: list[ListIntervalAgentReportResponseBodyData]
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListIntervalAgentReportResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = ListIntervalAgentReportResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListIntervalAgentReportResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ListIntervalAgentReportResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListIntervalAgentReportResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListIntervalAgentReportResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListIntervalInstanceReportRequest(TeaModel):
    def __init__(self, end_time=None, instance_id=None, interval=None, start_time=None):
        self.end_time = end_time  # type: long
        self.instance_id = instance_id  # type: str
        self.interval = interval  # type: str
        self.start_time = start_time  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListIntervalInstanceReportRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.interval is not None:
            result['Interval'] = self.interval
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Interval') is not None:
            self.interval = m.get('Interval')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class ListIntervalInstanceReportResponseBodyDataInbound(TeaModel):
    def __init__(self, abandoned_rate=None, average_abandon_time=None, average_abandoned_in_ivrtime=None,
                 average_abandoned_in_queue_time=None, average_abandoned_in_ring_time=None, average_hold_time=None, average_ring_time=None,
                 average_talk_time=None, average_wait_time=None, average_work_time=None, calls_abandoned=None,
                 calls_abandoned_in_ivr=None, calls_abandoned_in_queue=None, calls_abandoned_in_ring=None,
                 calls_abandoned_in_voice_navigator=None, calls_attended_transferred=None, calls_blind_transferred=None,
                 calls_forward_to_outside_number=None, calls_handled=None, calls_hold=None, calls_ivrexception=None, calls_offered=None,
                 calls_queued=None, calls_queuing_failed=None, calls_queuing_overflow=None, calls_queuing_timeout=None,
                 calls_ringed=None, calls_voicemail=None, handle_rate=None, max_abandon_time=None,
                 max_abandoned_in_ivrtime=None, max_abandoned_in_queue_time=None, max_abandoned_in_ring_time=None, max_hold_time=None,
                 max_ring_time=None, max_talk_time=None, max_wait_time=None, max_work_time=None, satisfaction_index=None,
                 satisfaction_rate=None, satisfaction_surveys_offered=None, satisfaction_surveys_responded=None,
                 service_level_20=None, total_abandon_time=None, total_abandoned_in_ivrtime=None,
                 total_abandoned_in_queue_time=None, total_abandoned_in_ring_time=None, total_hold_time=None, total_ring_time=None,
                 total_talk_time=None, total_wait_time=None, total_work_time=None):
        self.abandoned_rate = abandoned_rate  # type: float
        self.average_abandon_time = average_abandon_time  # type: float
        self.average_abandoned_in_ivrtime = average_abandoned_in_ivrtime  # type: float
        self.average_abandoned_in_queue_time = average_abandoned_in_queue_time  # type: float
        self.average_abandoned_in_ring_time = average_abandoned_in_ring_time  # type: float
        self.average_hold_time = average_hold_time  # type: float
        self.average_ring_time = average_ring_time  # type: float
        self.average_talk_time = average_talk_time  # type: float
        self.average_wait_time = average_wait_time  # type: float
        self.average_work_time = average_work_time  # type: float
        self.calls_abandoned = calls_abandoned  # type: long
        self.calls_abandoned_in_ivr = calls_abandoned_in_ivr  # type: long
        self.calls_abandoned_in_queue = calls_abandoned_in_queue  # type: long
        self.calls_abandoned_in_ring = calls_abandoned_in_ring  # type: long
        self.calls_abandoned_in_voice_navigator = calls_abandoned_in_voice_navigator  # type: long
        self.calls_attended_transferred = calls_attended_transferred  # type: long
        self.calls_blind_transferred = calls_blind_transferred  # type: long
        self.calls_forward_to_outside_number = calls_forward_to_outside_number  # type: long
        self.calls_handled = calls_handled  # type: long
        self.calls_hold = calls_hold  # type: long
        self.calls_ivrexception = calls_ivrexception  # type: long
        self.calls_offered = calls_offered  # type: long
        self.calls_queued = calls_queued  # type: long
        self.calls_queuing_failed = calls_queuing_failed  # type: long
        self.calls_queuing_overflow = calls_queuing_overflow  # type: long
        self.calls_queuing_timeout = calls_queuing_timeout  # type: long
        self.calls_ringed = calls_ringed  # type: long
        self.calls_voicemail = calls_voicemail  # type: long
        self.handle_rate = handle_rate  # type: float
        self.max_abandon_time = max_abandon_time  # type: long
        self.max_abandoned_in_ivrtime = max_abandoned_in_ivrtime  # type: long
        self.max_abandoned_in_queue_time = max_abandoned_in_queue_time  # type: long
        self.max_abandoned_in_ring_time = max_abandoned_in_ring_time  # type: long
        self.max_hold_time = max_hold_time  # type: long
        self.max_ring_time = max_ring_time  # type: long
        self.max_talk_time = max_talk_time  # type: long
        self.max_wait_time = max_wait_time  # type: long
        self.max_work_time = max_work_time  # type: long
        self.satisfaction_index = satisfaction_index  # type: float
        self.satisfaction_rate = satisfaction_rate  # type: float
        self.satisfaction_surveys_offered = satisfaction_surveys_offered  # type: long
        self.satisfaction_surveys_responded = satisfaction_surveys_responded  # type: long
        self.service_level_20 = service_level_20  # type: float
        self.total_abandon_time = total_abandon_time  # type: long
        self.total_abandoned_in_ivrtime = total_abandoned_in_ivrtime  # type: long
        self.total_abandoned_in_queue_time = total_abandoned_in_queue_time  # type: long
        self.total_abandoned_in_ring_time = total_abandoned_in_ring_time  # type: long
        self.total_hold_time = total_hold_time  # type: long
        self.total_ring_time = total_ring_time  # type: long
        self.total_talk_time = total_talk_time  # type: long
        self.total_wait_time = total_wait_time  # type: long
        self.total_work_time = total_work_time  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListIntervalInstanceReportResponseBodyDataInbound, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.abandoned_rate is not None:
            result['AbandonedRate'] = self.abandoned_rate
        if self.average_abandon_time is not None:
            result['AverageAbandonTime'] = self.average_abandon_time
        if self.average_abandoned_in_ivrtime is not None:
            result['AverageAbandonedInIVRTime'] = self.average_abandoned_in_ivrtime
        if self.average_abandoned_in_queue_time is not None:
            result['AverageAbandonedInQueueTime'] = self.average_abandoned_in_queue_time
        if self.average_abandoned_in_ring_time is not None:
            result['AverageAbandonedInRingTime'] = self.average_abandoned_in_ring_time
        if self.average_hold_time is not None:
            result['AverageHoldTime'] = self.average_hold_time
        if self.average_ring_time is not None:
            result['AverageRingTime'] = self.average_ring_time
        if self.average_talk_time is not None:
            result['AverageTalkTime'] = self.average_talk_time
        if self.average_wait_time is not None:
            result['AverageWaitTime'] = self.average_wait_time
        if self.average_work_time is not None:
            result['AverageWorkTime'] = self.average_work_time
        if self.calls_abandoned is not None:
            result['CallsAbandoned'] = self.calls_abandoned
        if self.calls_abandoned_in_ivr is not None:
            result['CallsAbandonedInIVR'] = self.calls_abandoned_in_ivr
        if self.calls_abandoned_in_queue is not None:
            result['CallsAbandonedInQueue'] = self.calls_abandoned_in_queue
        if self.calls_abandoned_in_ring is not None:
            result['CallsAbandonedInRing'] = self.calls_abandoned_in_ring
        if self.calls_abandoned_in_voice_navigator is not None:
            result['CallsAbandonedInVoiceNavigator'] = self.calls_abandoned_in_voice_navigator
        if self.calls_attended_transferred is not None:
            result['CallsAttendedTransferred'] = self.calls_attended_transferred
        if self.calls_blind_transferred is not None:
            result['CallsBlindTransferred'] = self.calls_blind_transferred
        if self.calls_forward_to_outside_number is not None:
            result['CallsForwardToOutsideNumber'] = self.calls_forward_to_outside_number
        if self.calls_handled is not None:
            result['CallsHandled'] = self.calls_handled
        if self.calls_hold is not None:
            result['CallsHold'] = self.calls_hold
        if self.calls_ivrexception is not None:
            result['CallsIVRException'] = self.calls_ivrexception
        if self.calls_offered is not None:
            result['CallsOffered'] = self.calls_offered
        if self.calls_queued is not None:
            result['CallsQueued'] = self.calls_queued
        if self.calls_queuing_failed is not None:
            result['CallsQueuingFailed'] = self.calls_queuing_failed
        if self.calls_queuing_overflow is not None:
            result['CallsQueuingOverflow'] = self.calls_queuing_overflow
        if self.calls_queuing_timeout is not None:
            result['CallsQueuingTimeout'] = self.calls_queuing_timeout
        if self.calls_ringed is not None:
            result['CallsRinged'] = self.calls_ringed
        if self.calls_voicemail is not None:
            result['CallsVoicemail'] = self.calls_voicemail
        if self.handle_rate is not None:
            result['HandleRate'] = self.handle_rate
        if self.max_abandon_time is not None:
            result['MaxAbandonTime'] = self.max_abandon_time
        if self.max_abandoned_in_ivrtime is not None:
            result['MaxAbandonedInIVRTime'] = self.max_abandoned_in_ivrtime
        if self.max_abandoned_in_queue_time is not None:
            result['MaxAbandonedInQueueTime'] = self.max_abandoned_in_queue_time
        if self.max_abandoned_in_ring_time is not None:
            result['MaxAbandonedInRingTime'] = self.max_abandoned_in_ring_time
        if self.max_hold_time is not None:
            result['MaxHoldTime'] = self.max_hold_time
        if self.max_ring_time is not None:
            result['MaxRingTime'] = self.max_ring_time
        if self.max_talk_time is not None:
            result['MaxTalkTime'] = self.max_talk_time
        if self.max_wait_time is not None:
            result['MaxWaitTime'] = self.max_wait_time
        if self.max_work_time is not None:
            result['MaxWorkTime'] = self.max_work_time
        if self.satisfaction_index is not None:
            result['SatisfactionIndex'] = self.satisfaction_index
        if self.satisfaction_rate is not None:
            result['SatisfactionRate'] = self.satisfaction_rate
        if self.satisfaction_surveys_offered is not None:
            result['SatisfactionSurveysOffered'] = self.satisfaction_surveys_offered
        if self.satisfaction_surveys_responded is not None:
            result['SatisfactionSurveysResponded'] = self.satisfaction_surveys_responded
        if self.service_level_20 is not None:
            result['ServiceLevel20'] = self.service_level_20
        if self.total_abandon_time is not None:
            result['TotalAbandonTime'] = self.total_abandon_time
        if self.total_abandoned_in_ivrtime is not None:
            result['TotalAbandonedInIVRTime'] = self.total_abandoned_in_ivrtime
        if self.total_abandoned_in_queue_time is not None:
            result['TotalAbandonedInQueueTime'] = self.total_abandoned_in_queue_time
        if self.total_abandoned_in_ring_time is not None:
            result['TotalAbandonedInRingTime'] = self.total_abandoned_in_ring_time
        if self.total_hold_time is not None:
            result['TotalHoldTime'] = self.total_hold_time
        if self.total_ring_time is not None:
            result['TotalRingTime'] = self.total_ring_time
        if self.total_talk_time is not None:
            result['TotalTalkTime'] = self.total_talk_time
        if self.total_wait_time is not None:
            result['TotalWaitTime'] = self.total_wait_time
        if self.total_work_time is not None:
            result['TotalWorkTime'] = self.total_work_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AbandonedRate') is not None:
            self.abandoned_rate = m.get('AbandonedRate')
        if m.get('AverageAbandonTime') is not None:
            self.average_abandon_time = m.get('AverageAbandonTime')
        if m.get('AverageAbandonedInIVRTime') is not None:
            self.average_abandoned_in_ivrtime = m.get('AverageAbandonedInIVRTime')
        if m.get('AverageAbandonedInQueueTime') is not None:
            self.average_abandoned_in_queue_time = m.get('AverageAbandonedInQueueTime')
        if m.get('AverageAbandonedInRingTime') is not None:
            self.average_abandoned_in_ring_time = m.get('AverageAbandonedInRingTime')
        if m.get('AverageHoldTime') is not None:
            self.average_hold_time = m.get('AverageHoldTime')
        if m.get('AverageRingTime') is not None:
            self.average_ring_time = m.get('AverageRingTime')
        if m.get('AverageTalkTime') is not None:
            self.average_talk_time = m.get('AverageTalkTime')
        if m.get('AverageWaitTime') is not None:
            self.average_wait_time = m.get('AverageWaitTime')
        if m.get('AverageWorkTime') is not None:
            self.average_work_time = m.get('AverageWorkTime')
        if m.get('CallsAbandoned') is not None:
            self.calls_abandoned = m.get('CallsAbandoned')
        if m.get('CallsAbandonedInIVR') is not None:
            self.calls_abandoned_in_ivr = m.get('CallsAbandonedInIVR')
        if m.get('CallsAbandonedInQueue') is not None:
            self.calls_abandoned_in_queue = m.get('CallsAbandonedInQueue')
        if m.get('CallsAbandonedInRing') is not None:
            self.calls_abandoned_in_ring = m.get('CallsAbandonedInRing')
        if m.get('CallsAbandonedInVoiceNavigator') is not None:
            self.calls_abandoned_in_voice_navigator = m.get('CallsAbandonedInVoiceNavigator')
        if m.get('CallsAttendedTransferred') is not None:
            self.calls_attended_transferred = m.get('CallsAttendedTransferred')
        if m.get('CallsBlindTransferred') is not None:
            self.calls_blind_transferred = m.get('CallsBlindTransferred')
        if m.get('CallsForwardToOutsideNumber') is not None:
            self.calls_forward_to_outside_number = m.get('CallsForwardToOutsideNumber')
        if m.get('CallsHandled') is not None:
            self.calls_handled = m.get('CallsHandled')
        if m.get('CallsHold') is not None:
            self.calls_hold = m.get('CallsHold')
        if m.get('CallsIVRException') is not None:
            self.calls_ivrexception = m.get('CallsIVRException')
        if m.get('CallsOffered') is not None:
            self.calls_offered = m.get('CallsOffered')
        if m.get('CallsQueued') is not None:
            self.calls_queued = m.get('CallsQueued')
        if m.get('CallsQueuingFailed') is not None:
            self.calls_queuing_failed = m.get('CallsQueuingFailed')
        if m.get('CallsQueuingOverflow') is not None:
            self.calls_queuing_overflow = m.get('CallsQueuingOverflow')
        if m.get('CallsQueuingTimeout') is not None:
            self.calls_queuing_timeout = m.get('CallsQueuingTimeout')
        if m.get('CallsRinged') is not None:
            self.calls_ringed = m.get('CallsRinged')
        if m.get('CallsVoicemail') is not None:
            self.calls_voicemail = m.get('CallsVoicemail')
        if m.get('HandleRate') is not None:
            self.handle_rate = m.get('HandleRate')
        if m.get('MaxAbandonTime') is not None:
            self.max_abandon_time = m.get('MaxAbandonTime')
        if m.get('MaxAbandonedInIVRTime') is not None:
            self.max_abandoned_in_ivrtime = m.get('MaxAbandonedInIVRTime')
        if m.get('MaxAbandonedInQueueTime') is not None:
            self.max_abandoned_in_queue_time = m.get('MaxAbandonedInQueueTime')
        if m.get('MaxAbandonedInRingTime') is not None:
            self.max_abandoned_in_ring_time = m.get('MaxAbandonedInRingTime')
        if m.get('MaxHoldTime') is not None:
            self.max_hold_time = m.get('MaxHoldTime')
        if m.get('MaxRingTime') is not None:
            self.max_ring_time = m.get('MaxRingTime')
        if m.get('MaxTalkTime') is not None:
            self.max_talk_time = m.get('MaxTalkTime')
        if m.get('MaxWaitTime') is not None:
            self.max_wait_time = m.get('MaxWaitTime')
        if m.get('MaxWorkTime') is not None:
            self.max_work_time = m.get('MaxWorkTime')
        if m.get('SatisfactionIndex') is not None:
            self.satisfaction_index = m.get('SatisfactionIndex')
        if m.get('SatisfactionRate') is not None:
            self.satisfaction_rate = m.get('SatisfactionRate')
        if m.get('SatisfactionSurveysOffered') is not None:
            self.satisfaction_surveys_offered = m.get('SatisfactionSurveysOffered')
        if m.get('SatisfactionSurveysResponded') is not None:
            self.satisfaction_surveys_responded = m.get('SatisfactionSurveysResponded')
        if m.get('ServiceLevel20') is not None:
            self.service_level_20 = m.get('ServiceLevel20')
        if m.get('TotalAbandonTime') is not None:
            self.total_abandon_time = m.get('TotalAbandonTime')
        if m.get('TotalAbandonedInIVRTime') is not None:
            self.total_abandoned_in_ivrtime = m.get('TotalAbandonedInIVRTime')
        if m.get('TotalAbandonedInQueueTime') is not None:
            self.total_abandoned_in_queue_time = m.get('TotalAbandonedInQueueTime')
        if m.get('TotalAbandonedInRingTime') is not None:
            self.total_abandoned_in_ring_time = m.get('TotalAbandonedInRingTime')
        if m.get('TotalHoldTime') is not None:
            self.total_hold_time = m.get('TotalHoldTime')
        if m.get('TotalRingTime') is not None:
            self.total_ring_time = m.get('TotalRingTime')
        if m.get('TotalTalkTime') is not None:
            self.total_talk_time = m.get('TotalTalkTime')
        if m.get('TotalWaitTime') is not None:
            self.total_wait_time = m.get('TotalWaitTime')
        if m.get('TotalWorkTime') is not None:
            self.total_work_time = m.get('TotalWorkTime')
        return self


class ListIntervalInstanceReportResponseBodyDataOutbound(TeaModel):
    def __init__(self, answer_rate=None, average_dialing_time=None, average_hold_time=None, average_ring_time=None,
                 average_talk_time=None, average_work_time=None, calls_answered=None, calls_attended_transferred=None,
                 calls_blind_transferred=None, calls_dialed=None, calls_hold=None, calls_ringed=None, max_dialing_time=None,
                 max_hold_time=None, max_ring_time=None, max_talk_time=None, max_work_time=None, satisfaction_index=None,
                 satisfaction_rate=None, satisfaction_surveys_offered=None, satisfaction_surveys_responded=None,
                 total_dialing_time=None, total_hold_time=None, total_ring_time=None, total_talk_time=None, total_work_time=None):
        self.answer_rate = answer_rate  # type: float
        self.average_dialing_time = average_dialing_time  # type: float
        self.average_hold_time = average_hold_time  # type: float
        self.average_ring_time = average_ring_time  # type: float
        self.average_talk_time = average_talk_time  # type: float
        self.average_work_time = average_work_time  # type: float
        self.calls_answered = calls_answered  # type: long
        self.calls_attended_transferred = calls_attended_transferred  # type: long
        self.calls_blind_transferred = calls_blind_transferred  # type: long
        self.calls_dialed = calls_dialed  # type: long
        self.calls_hold = calls_hold  # type: long
        self.calls_ringed = calls_ringed  # type: long
        self.max_dialing_time = max_dialing_time  # type: long
        self.max_hold_time = max_hold_time  # type: long
        self.max_ring_time = max_ring_time  # type: long
        self.max_talk_time = max_talk_time  # type: long
        self.max_work_time = max_work_time  # type: long
        self.satisfaction_index = satisfaction_index  # type: float
        self.satisfaction_rate = satisfaction_rate  # type: float
        self.satisfaction_surveys_offered = satisfaction_surveys_offered  # type: long
        self.satisfaction_surveys_responded = satisfaction_surveys_responded  # type: long
        self.total_dialing_time = total_dialing_time  # type: long
        self.total_hold_time = total_hold_time  # type: long
        self.total_ring_time = total_ring_time  # type: long
        self.total_talk_time = total_talk_time  # type: long
        self.total_work_time = total_work_time  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListIntervalInstanceReportResponseBodyDataOutbound, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.answer_rate is not None:
            result['AnswerRate'] = self.answer_rate
        if self.average_dialing_time is not None:
            result['AverageDialingTime'] = self.average_dialing_time
        if self.average_hold_time is not None:
            result['AverageHoldTime'] = self.average_hold_time
        if self.average_ring_time is not None:
            result['AverageRingTime'] = self.average_ring_time
        if self.average_talk_time is not None:
            result['AverageTalkTime'] = self.average_talk_time
        if self.average_work_time is not None:
            result['AverageWorkTime'] = self.average_work_time
        if self.calls_answered is not None:
            result['CallsAnswered'] = self.calls_answered
        if self.calls_attended_transferred is not None:
            result['CallsAttendedTransferred'] = self.calls_attended_transferred
        if self.calls_blind_transferred is not None:
            result['CallsBlindTransferred'] = self.calls_blind_transferred
        if self.calls_dialed is not None:
            result['CallsDialed'] = self.calls_dialed
        if self.calls_hold is not None:
            result['CallsHold'] = self.calls_hold
        if self.calls_ringed is not None:
            result['CallsRinged'] = self.calls_ringed
        if self.max_dialing_time is not None:
            result['MaxDialingTime'] = self.max_dialing_time
        if self.max_hold_time is not None:
            result['MaxHoldTime'] = self.max_hold_time
        if self.max_ring_time is not None:
            result['MaxRingTime'] = self.max_ring_time
        if self.max_talk_time is not None:
            result['MaxTalkTime'] = self.max_talk_time
        if self.max_work_time is not None:
            result['MaxWorkTime'] = self.max_work_time
        if self.satisfaction_index is not None:
            result['SatisfactionIndex'] = self.satisfaction_index
        if self.satisfaction_rate is not None:
            result['SatisfactionRate'] = self.satisfaction_rate
        if self.satisfaction_surveys_offered is not None:
            result['SatisfactionSurveysOffered'] = self.satisfaction_surveys_offered
        if self.satisfaction_surveys_responded is not None:
            result['SatisfactionSurveysResponded'] = self.satisfaction_surveys_responded
        if self.total_dialing_time is not None:
            result['TotalDialingTime'] = self.total_dialing_time
        if self.total_hold_time is not None:
            result['TotalHoldTime'] = self.total_hold_time
        if self.total_ring_time is not None:
            result['TotalRingTime'] = self.total_ring_time
        if self.total_talk_time is not None:
            result['TotalTalkTime'] = self.total_talk_time
        if self.total_work_time is not None:
            result['TotalWorkTime'] = self.total_work_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AnswerRate') is not None:
            self.answer_rate = m.get('AnswerRate')
        if m.get('AverageDialingTime') is not None:
            self.average_dialing_time = m.get('AverageDialingTime')
        if m.get('AverageHoldTime') is not None:
            self.average_hold_time = m.get('AverageHoldTime')
        if m.get('AverageRingTime') is not None:
            self.average_ring_time = m.get('AverageRingTime')
        if m.get('AverageTalkTime') is not None:
            self.average_talk_time = m.get('AverageTalkTime')
        if m.get('AverageWorkTime') is not None:
            self.average_work_time = m.get('AverageWorkTime')
        if m.get('CallsAnswered') is not None:
            self.calls_answered = m.get('CallsAnswered')
        if m.get('CallsAttendedTransferred') is not None:
            self.calls_attended_transferred = m.get('CallsAttendedTransferred')
        if m.get('CallsBlindTransferred') is not None:
            self.calls_blind_transferred = m.get('CallsBlindTransferred')
        if m.get('CallsDialed') is not None:
            self.calls_dialed = m.get('CallsDialed')
        if m.get('CallsHold') is not None:
            self.calls_hold = m.get('CallsHold')
        if m.get('CallsRinged') is not None:
            self.calls_ringed = m.get('CallsRinged')
        if m.get('MaxDialingTime') is not None:
            self.max_dialing_time = m.get('MaxDialingTime')
        if m.get('MaxHoldTime') is not None:
            self.max_hold_time = m.get('MaxHoldTime')
        if m.get('MaxRingTime') is not None:
            self.max_ring_time = m.get('MaxRingTime')
        if m.get('MaxTalkTime') is not None:
            self.max_talk_time = m.get('MaxTalkTime')
        if m.get('MaxWorkTime') is not None:
            self.max_work_time = m.get('MaxWorkTime')
        if m.get('SatisfactionIndex') is not None:
            self.satisfaction_index = m.get('SatisfactionIndex')
        if m.get('SatisfactionRate') is not None:
            self.satisfaction_rate = m.get('SatisfactionRate')
        if m.get('SatisfactionSurveysOffered') is not None:
            self.satisfaction_surveys_offered = m.get('SatisfactionSurveysOffered')
        if m.get('SatisfactionSurveysResponded') is not None:
            self.satisfaction_surveys_responded = m.get('SatisfactionSurveysResponded')
        if m.get('TotalDialingTime') is not None:
            self.total_dialing_time = m.get('TotalDialingTime')
        if m.get('TotalHoldTime') is not None:
            self.total_hold_time = m.get('TotalHoldTime')
        if m.get('TotalRingTime') is not None:
            self.total_ring_time = m.get('TotalRingTime')
        if m.get('TotalTalkTime') is not None:
            self.total_talk_time = m.get('TotalTalkTime')
        if m.get('TotalWorkTime') is not None:
            self.total_work_time = m.get('TotalWorkTime')
        return self


class ListIntervalInstanceReportResponseBodyDataOverall(TeaModel):
    def __init__(self, average_break_time=None, average_hold_time=None, average_ready_time=None,
                 average_talk_time=None, average_work_time=None, max_break_time=None, max_hold_time=None, max_ready_time=None,
                 max_talk_time=None, max_work_time=None, occupancy_rate=None, satisfaction_index=None, satisfaction_rate=None,
                 satisfaction_surveys_offered=None, satisfaction_surveys_responded=None, total_break_time=None, total_calls=None,
                 total_hold_time=None, total_logged_in_time=None, total_ready_time=None, total_talk_time=None,
                 total_work_time=None):
        self.average_break_time = average_break_time  # type: float
        self.average_hold_time = average_hold_time  # type: float
        self.average_ready_time = average_ready_time  # type: float
        self.average_talk_time = average_talk_time  # type: float
        self.average_work_time = average_work_time  # type: float
        self.max_break_time = max_break_time  # type: long
        self.max_hold_time = max_hold_time  # type: long
        self.max_ready_time = max_ready_time  # type: long
        self.max_talk_time = max_talk_time  # type: long
        self.max_work_time = max_work_time  # type: long
        self.occupancy_rate = occupancy_rate  # type: float
        self.satisfaction_index = satisfaction_index  # type: float
        self.satisfaction_rate = satisfaction_rate  # type: float
        self.satisfaction_surveys_offered = satisfaction_surveys_offered  # type: long
        self.satisfaction_surveys_responded = satisfaction_surveys_responded  # type: long
        self.total_break_time = total_break_time  # type: long
        self.total_calls = total_calls  # type: long
        self.total_hold_time = total_hold_time  # type: long
        self.total_logged_in_time = total_logged_in_time  # type: long
        self.total_ready_time = total_ready_time  # type: long
        self.total_talk_time = total_talk_time  # type: long
        self.total_work_time = total_work_time  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListIntervalInstanceReportResponseBodyDataOverall, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.average_break_time is not None:
            result['AverageBreakTime'] = self.average_break_time
        if self.average_hold_time is not None:
            result['AverageHoldTime'] = self.average_hold_time
        if self.average_ready_time is not None:
            result['AverageReadyTime'] = self.average_ready_time
        if self.average_talk_time is not None:
            result['AverageTalkTime'] = self.average_talk_time
        if self.average_work_time is not None:
            result['AverageWorkTime'] = self.average_work_time
        if self.max_break_time is not None:
            result['MaxBreakTime'] = self.max_break_time
        if self.max_hold_time is not None:
            result['MaxHoldTime'] = self.max_hold_time
        if self.max_ready_time is not None:
            result['MaxReadyTime'] = self.max_ready_time
        if self.max_talk_time is not None:
            result['MaxTalkTime'] = self.max_talk_time
        if self.max_work_time is not None:
            result['MaxWorkTime'] = self.max_work_time
        if self.occupancy_rate is not None:
            result['OccupancyRate'] = self.occupancy_rate
        if self.satisfaction_index is not None:
            result['SatisfactionIndex'] = self.satisfaction_index
        if self.satisfaction_rate is not None:
            result['SatisfactionRate'] = self.satisfaction_rate
        if self.satisfaction_surveys_offered is not None:
            result['SatisfactionSurveysOffered'] = self.satisfaction_surveys_offered
        if self.satisfaction_surveys_responded is not None:
            result['SatisfactionSurveysResponded'] = self.satisfaction_surveys_responded
        if self.total_break_time is not None:
            result['TotalBreakTime'] = self.total_break_time
        if self.total_calls is not None:
            result['TotalCalls'] = self.total_calls
        if self.total_hold_time is not None:
            result['TotalHoldTime'] = self.total_hold_time
        if self.total_logged_in_time is not None:
            result['TotalLoggedInTime'] = self.total_logged_in_time
        if self.total_ready_time is not None:
            result['TotalReadyTime'] = self.total_ready_time
        if self.total_talk_time is not None:
            result['TotalTalkTime'] = self.total_talk_time
        if self.total_work_time is not None:
            result['TotalWorkTime'] = self.total_work_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AverageBreakTime') is not None:
            self.average_break_time = m.get('AverageBreakTime')
        if m.get('AverageHoldTime') is not None:
            self.average_hold_time = m.get('AverageHoldTime')
        if m.get('AverageReadyTime') is not None:
            self.average_ready_time = m.get('AverageReadyTime')
        if m.get('AverageTalkTime') is not None:
            self.average_talk_time = m.get('AverageTalkTime')
        if m.get('AverageWorkTime') is not None:
            self.average_work_time = m.get('AverageWorkTime')
        if m.get('MaxBreakTime') is not None:
            self.max_break_time = m.get('MaxBreakTime')
        if m.get('MaxHoldTime') is not None:
            self.max_hold_time = m.get('MaxHoldTime')
        if m.get('MaxReadyTime') is not None:
            self.max_ready_time = m.get('MaxReadyTime')
        if m.get('MaxTalkTime') is not None:
            self.max_talk_time = m.get('MaxTalkTime')
        if m.get('MaxWorkTime') is not None:
            self.max_work_time = m.get('MaxWorkTime')
        if m.get('OccupancyRate') is not None:
            self.occupancy_rate = m.get('OccupancyRate')
        if m.get('SatisfactionIndex') is not None:
            self.satisfaction_index = m.get('SatisfactionIndex')
        if m.get('SatisfactionRate') is not None:
            self.satisfaction_rate = m.get('SatisfactionRate')
        if m.get('SatisfactionSurveysOffered') is not None:
            self.satisfaction_surveys_offered = m.get('SatisfactionSurveysOffered')
        if m.get('SatisfactionSurveysResponded') is not None:
            self.satisfaction_surveys_responded = m.get('SatisfactionSurveysResponded')
        if m.get('TotalBreakTime') is not None:
            self.total_break_time = m.get('TotalBreakTime')
        if m.get('TotalCalls') is not None:
            self.total_calls = m.get('TotalCalls')
        if m.get('TotalHoldTime') is not None:
            self.total_hold_time = m.get('TotalHoldTime')
        if m.get('TotalLoggedInTime') is not None:
            self.total_logged_in_time = m.get('TotalLoggedInTime')
        if m.get('TotalReadyTime') is not None:
            self.total_ready_time = m.get('TotalReadyTime')
        if m.get('TotalTalkTime') is not None:
            self.total_talk_time = m.get('TotalTalkTime')
        if m.get('TotalWorkTime') is not None:
            self.total_work_time = m.get('TotalWorkTime')
        return self


class ListIntervalInstanceReportResponseBodyData(TeaModel):
    def __init__(self, inbound=None, outbound=None, overall=None, stats_time=None):
        self.inbound = inbound  # type: ListIntervalInstanceReportResponseBodyDataInbound
        self.outbound = outbound  # type: ListIntervalInstanceReportResponseBodyDataOutbound
        self.overall = overall  # type: ListIntervalInstanceReportResponseBodyDataOverall
        self.stats_time = stats_time  # type: long

    def validate(self):
        if self.inbound:
            self.inbound.validate()
        if self.outbound:
            self.outbound.validate()
        if self.overall:
            self.overall.validate()

    def to_map(self):
        _map = super(ListIntervalInstanceReportResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.inbound is not None:
            result['Inbound'] = self.inbound.to_map()
        if self.outbound is not None:
            result['Outbound'] = self.outbound.to_map()
        if self.overall is not None:
            result['Overall'] = self.overall.to_map()
        if self.stats_time is not None:
            result['StatsTime'] = self.stats_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Inbound') is not None:
            temp_model = ListIntervalInstanceReportResponseBodyDataInbound()
            self.inbound = temp_model.from_map(m['Inbound'])
        if m.get('Outbound') is not None:
            temp_model = ListIntervalInstanceReportResponseBodyDataOutbound()
            self.outbound = temp_model.from_map(m['Outbound'])
        if m.get('Overall') is not None:
            temp_model = ListIntervalInstanceReportResponseBodyDataOverall()
            self.overall = temp_model.from_map(m['Overall'])
        if m.get('StatsTime') is not None:
            self.stats_time = m.get('StatsTime')
        return self


class ListIntervalInstanceReportResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: list[ListIntervalInstanceReportResponseBodyData]
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListIntervalInstanceReportResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = ListIntervalInstanceReportResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListIntervalInstanceReportResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ListIntervalInstanceReportResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListIntervalInstanceReportResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListIntervalInstanceReportResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListIntervalSkillGroupReportRequest(TeaModel):
    def __init__(self, end_time=None, instance_id=None, interval=None, skill_group_id=None, start_time=None):
        self.end_time = end_time  # type: long
        self.instance_id = instance_id  # type: str
        self.interval = interval  # type: str
        self.skill_group_id = skill_group_id  # type: str
        self.start_time = start_time  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListIntervalSkillGroupReportRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.interval is not None:
            result['Interval'] = self.interval
        if self.skill_group_id is not None:
            result['SkillGroupId'] = self.skill_group_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Interval') is not None:
            self.interval = m.get('Interval')
        if m.get('SkillGroupId') is not None:
            self.skill_group_id = m.get('SkillGroupId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class ListIntervalSkillGroupReportResponseBodyDataInbound(TeaModel):
    def __init__(self, abandon_rate=None, average_abandon_time=None, average_abandoned_in_queue_time=None,
                 average_abandoned_in_ring_time=None, average_hold_time=None, average_ring_time=None, average_talk_time=None,
                 average_wait_time=None, average_work_time=None, calls_abandoned=None, calls_abandoned_in_queue=None,
                 calls_abandoned_in_ring=None, calls_attended_transfer_in=None, calls_attended_transfer_out=None,
                 calls_blind_transfer_in=None, calls_blind_transfer_out=None, calls_handled=None, calls_hold=None, calls_offered=None,
                 calls_overflow=None, calls_queued=None, calls_ringed=None, calls_timeout=None, handle_rate=None,
                 max_abandon_time=None, max_abandoned_in_queue_time=None, max_abandoned_in_ring_time=None, max_hold_time=None,
                 max_ring_time=None, max_talk_time=None, max_wait_time=None, max_work_time=None, satisfaction_index=None,
                 satisfaction_rate=None, satisfaction_surveys_offered=None, satisfaction_surveys_responded=None,
                 service_level_20=None, total_abandon_time=None, total_abandoned_in_queue_time=None,
                 total_abandoned_in_ring_time=None, total_hold_time=None, total_ring_time=None, total_talk_time=None, total_wait_time=None,
                 total_work_time=None):
        self.abandon_rate = abandon_rate  # type: float
        self.average_abandon_time = average_abandon_time  # type: float
        self.average_abandoned_in_queue_time = average_abandoned_in_queue_time  # type: float
        self.average_abandoned_in_ring_time = average_abandoned_in_ring_time  # type: float
        self.average_hold_time = average_hold_time  # type: float
        self.average_ring_time = average_ring_time  # type: float
        self.average_talk_time = average_talk_time  # type: float
        self.average_wait_time = average_wait_time  # type: float
        self.average_work_time = average_work_time  # type: float
        self.calls_abandoned = calls_abandoned  # type: long
        self.calls_abandoned_in_queue = calls_abandoned_in_queue  # type: long
        self.calls_abandoned_in_ring = calls_abandoned_in_ring  # type: long
        self.calls_attended_transfer_in = calls_attended_transfer_in  # type: long
        self.calls_attended_transfer_out = calls_attended_transfer_out  # type: long
        self.calls_blind_transfer_in = calls_blind_transfer_in  # type: long
        self.calls_blind_transfer_out = calls_blind_transfer_out  # type: long
        self.calls_handled = calls_handled  # type: long
        self.calls_hold = calls_hold  # type: long
        self.calls_offered = calls_offered  # type: long
        self.calls_overflow = calls_overflow  # type: long
        self.calls_queued = calls_queued  # type: long
        self.calls_ringed = calls_ringed  # type: long
        self.calls_timeout = calls_timeout  # type: long
        self.handle_rate = handle_rate  # type: float
        self.max_abandon_time = max_abandon_time  # type: long
        self.max_abandoned_in_queue_time = max_abandoned_in_queue_time  # type: long
        self.max_abandoned_in_ring_time = max_abandoned_in_ring_time  # type: long
        self.max_hold_time = max_hold_time  # type: long
        self.max_ring_time = max_ring_time  # type: long
        self.max_talk_time = max_talk_time  # type: long
        self.max_wait_time = max_wait_time  # type: long
        self.max_work_time = max_work_time  # type: long
        self.satisfaction_index = satisfaction_index  # type: float
        self.satisfaction_rate = satisfaction_rate  # type: float
        self.satisfaction_surveys_offered = satisfaction_surveys_offered  # type: long
        self.satisfaction_surveys_responded = satisfaction_surveys_responded  # type: long
        self.service_level_20 = service_level_20  # type: float
        self.total_abandon_time = total_abandon_time  # type: long
        self.total_abandoned_in_queue_time = total_abandoned_in_queue_time  # type: long
        self.total_abandoned_in_ring_time = total_abandoned_in_ring_time  # type: long
        self.total_hold_time = total_hold_time  # type: long
        self.total_ring_time = total_ring_time  # type: long
        self.total_talk_time = total_talk_time  # type: long
        self.total_wait_time = total_wait_time  # type: long
        self.total_work_time = total_work_time  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListIntervalSkillGroupReportResponseBodyDataInbound, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.abandon_rate is not None:
            result['AbandonRate'] = self.abandon_rate
        if self.average_abandon_time is not None:
            result['AverageAbandonTime'] = self.average_abandon_time
        if self.average_abandoned_in_queue_time is not None:
            result['AverageAbandonedInQueueTime'] = self.average_abandoned_in_queue_time
        if self.average_abandoned_in_ring_time is not None:
            result['AverageAbandonedInRingTime'] = self.average_abandoned_in_ring_time
        if self.average_hold_time is not None:
            result['AverageHoldTime'] = self.average_hold_time
        if self.average_ring_time is not None:
            result['AverageRingTime'] = self.average_ring_time
        if self.average_talk_time is not None:
            result['AverageTalkTime'] = self.average_talk_time
        if self.average_wait_time is not None:
            result['AverageWaitTime'] = self.average_wait_time
        if self.average_work_time is not None:
            result['AverageWorkTime'] = self.average_work_time
        if self.calls_abandoned is not None:
            result['CallsAbandoned'] = self.calls_abandoned
        if self.calls_abandoned_in_queue is not None:
            result['CallsAbandonedInQueue'] = self.calls_abandoned_in_queue
        if self.calls_abandoned_in_ring is not None:
            result['CallsAbandonedInRing'] = self.calls_abandoned_in_ring
        if self.calls_attended_transfer_in is not None:
            result['CallsAttendedTransferIn'] = self.calls_attended_transfer_in
        if self.calls_attended_transfer_out is not None:
            result['CallsAttendedTransferOut'] = self.calls_attended_transfer_out
        if self.calls_blind_transfer_in is not None:
            result['CallsBlindTransferIn'] = self.calls_blind_transfer_in
        if self.calls_blind_transfer_out is not None:
            result['CallsBlindTransferOut'] = self.calls_blind_transfer_out
        if self.calls_handled is not None:
            result['CallsHandled'] = self.calls_handled
        if self.calls_hold is not None:
            result['CallsHold'] = self.calls_hold
        if self.calls_offered is not None:
            result['CallsOffered'] = self.calls_offered
        if self.calls_overflow is not None:
            result['CallsOverflow'] = self.calls_overflow
        if self.calls_queued is not None:
            result['CallsQueued'] = self.calls_queued
        if self.calls_ringed is not None:
            result['CallsRinged'] = self.calls_ringed
        if self.calls_timeout is not None:
            result['CallsTimeout'] = self.calls_timeout
        if self.handle_rate is not None:
            result['HandleRate'] = self.handle_rate
        if self.max_abandon_time is not None:
            result['MaxAbandonTime'] = self.max_abandon_time
        if self.max_abandoned_in_queue_time is not None:
            result['MaxAbandonedInQueueTime'] = self.max_abandoned_in_queue_time
        if self.max_abandoned_in_ring_time is not None:
            result['MaxAbandonedInRingTime'] = self.max_abandoned_in_ring_time
        if self.max_hold_time is not None:
            result['MaxHoldTime'] = self.max_hold_time
        if self.max_ring_time is not None:
            result['MaxRingTime'] = self.max_ring_time
        if self.max_talk_time is not None:
            result['MaxTalkTime'] = self.max_talk_time
        if self.max_wait_time is not None:
            result['MaxWaitTime'] = self.max_wait_time
        if self.max_work_time is not None:
            result['MaxWorkTime'] = self.max_work_time
        if self.satisfaction_index is not None:
            result['SatisfactionIndex'] = self.satisfaction_index
        if self.satisfaction_rate is not None:
            result['SatisfactionRate'] = self.satisfaction_rate
        if self.satisfaction_surveys_offered is not None:
            result['SatisfactionSurveysOffered'] = self.satisfaction_surveys_offered
        if self.satisfaction_surveys_responded is not None:
            result['SatisfactionSurveysResponded'] = self.satisfaction_surveys_responded
        if self.service_level_20 is not None:
            result['ServiceLevel20'] = self.service_level_20
        if self.total_abandon_time is not None:
            result['TotalAbandonTime'] = self.total_abandon_time
        if self.total_abandoned_in_queue_time is not None:
            result['TotalAbandonedInQueueTime'] = self.total_abandoned_in_queue_time
        if self.total_abandoned_in_ring_time is not None:
            result['TotalAbandonedInRingTime'] = self.total_abandoned_in_ring_time
        if self.total_hold_time is not None:
            result['TotalHoldTime'] = self.total_hold_time
        if self.total_ring_time is not None:
            result['TotalRingTime'] = self.total_ring_time
        if self.total_talk_time is not None:
            result['TotalTalkTime'] = self.total_talk_time
        if self.total_wait_time is not None:
            result['TotalWaitTime'] = self.total_wait_time
        if self.total_work_time is not None:
            result['TotalWorkTime'] = self.total_work_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AbandonRate') is not None:
            self.abandon_rate = m.get('AbandonRate')
        if m.get('AverageAbandonTime') is not None:
            self.average_abandon_time = m.get('AverageAbandonTime')
        if m.get('AverageAbandonedInQueueTime') is not None:
            self.average_abandoned_in_queue_time = m.get('AverageAbandonedInQueueTime')
        if m.get('AverageAbandonedInRingTime') is not None:
            self.average_abandoned_in_ring_time = m.get('AverageAbandonedInRingTime')
        if m.get('AverageHoldTime') is not None:
            self.average_hold_time = m.get('AverageHoldTime')
        if m.get('AverageRingTime') is not None:
            self.average_ring_time = m.get('AverageRingTime')
        if m.get('AverageTalkTime') is not None:
            self.average_talk_time = m.get('AverageTalkTime')
        if m.get('AverageWaitTime') is not None:
            self.average_wait_time = m.get('AverageWaitTime')
        if m.get('AverageWorkTime') is not None:
            self.average_work_time = m.get('AverageWorkTime')
        if m.get('CallsAbandoned') is not None:
            self.calls_abandoned = m.get('CallsAbandoned')
        if m.get('CallsAbandonedInQueue') is not None:
            self.calls_abandoned_in_queue = m.get('CallsAbandonedInQueue')
        if m.get('CallsAbandonedInRing') is not None:
            self.calls_abandoned_in_ring = m.get('CallsAbandonedInRing')
        if m.get('CallsAttendedTransferIn') is not None:
            self.calls_attended_transfer_in = m.get('CallsAttendedTransferIn')
        if m.get('CallsAttendedTransferOut') is not None:
            self.calls_attended_transfer_out = m.get('CallsAttendedTransferOut')
        if m.get('CallsBlindTransferIn') is not None:
            self.calls_blind_transfer_in = m.get('CallsBlindTransferIn')
        if m.get('CallsBlindTransferOut') is not None:
            self.calls_blind_transfer_out = m.get('CallsBlindTransferOut')
        if m.get('CallsHandled') is not None:
            self.calls_handled = m.get('CallsHandled')
        if m.get('CallsHold') is not None:
            self.calls_hold = m.get('CallsHold')
        if m.get('CallsOffered') is not None:
            self.calls_offered = m.get('CallsOffered')
        if m.get('CallsOverflow') is not None:
            self.calls_overflow = m.get('CallsOverflow')
        if m.get('CallsQueued') is not None:
            self.calls_queued = m.get('CallsQueued')
        if m.get('CallsRinged') is not None:
            self.calls_ringed = m.get('CallsRinged')
        if m.get('CallsTimeout') is not None:
            self.calls_timeout = m.get('CallsTimeout')
        if m.get('HandleRate') is not None:
            self.handle_rate = m.get('HandleRate')
        if m.get('MaxAbandonTime') is not None:
            self.max_abandon_time = m.get('MaxAbandonTime')
        if m.get('MaxAbandonedInQueueTime') is not None:
            self.max_abandoned_in_queue_time = m.get('MaxAbandonedInQueueTime')
        if m.get('MaxAbandonedInRingTime') is not None:
            self.max_abandoned_in_ring_time = m.get('MaxAbandonedInRingTime')
        if m.get('MaxHoldTime') is not None:
            self.max_hold_time = m.get('MaxHoldTime')
        if m.get('MaxRingTime') is not None:
            self.max_ring_time = m.get('MaxRingTime')
        if m.get('MaxTalkTime') is not None:
            self.max_talk_time = m.get('MaxTalkTime')
        if m.get('MaxWaitTime') is not None:
            self.max_wait_time = m.get('MaxWaitTime')
        if m.get('MaxWorkTime') is not None:
            self.max_work_time = m.get('MaxWorkTime')
        if m.get('SatisfactionIndex') is not None:
            self.satisfaction_index = m.get('SatisfactionIndex')
        if m.get('SatisfactionRate') is not None:
            self.satisfaction_rate = m.get('SatisfactionRate')
        if m.get('SatisfactionSurveysOffered') is not None:
            self.satisfaction_surveys_offered = m.get('SatisfactionSurveysOffered')
        if m.get('SatisfactionSurveysResponded') is not None:
            self.satisfaction_surveys_responded = m.get('SatisfactionSurveysResponded')
        if m.get('ServiceLevel20') is not None:
            self.service_level_20 = m.get('ServiceLevel20')
        if m.get('TotalAbandonTime') is not None:
            self.total_abandon_time = m.get('TotalAbandonTime')
        if m.get('TotalAbandonedInQueueTime') is not None:
            self.total_abandoned_in_queue_time = m.get('TotalAbandonedInQueueTime')
        if m.get('TotalAbandonedInRingTime') is not None:
            self.total_abandoned_in_ring_time = m.get('TotalAbandonedInRingTime')
        if m.get('TotalHoldTime') is not None:
            self.total_hold_time = m.get('TotalHoldTime')
        if m.get('TotalRingTime') is not None:
            self.total_ring_time = m.get('TotalRingTime')
        if m.get('TotalTalkTime') is not None:
            self.total_talk_time = m.get('TotalTalkTime')
        if m.get('TotalWaitTime') is not None:
            self.total_wait_time = m.get('TotalWaitTime')
        if m.get('TotalWorkTime') is not None:
            self.total_work_time = m.get('TotalWorkTime')
        return self


class ListIntervalSkillGroupReportResponseBodyDataOutbound(TeaModel):
    def __init__(self, answer_rate=None, average_dialing_time=None, average_hold_time=None, average_ring_time=None,
                 average_talk_time=None, average_work_time=None, calls_answered=None, calls_attended_transfer_in=None,
                 calls_attended_transfer_out=None, calls_blind_transfer_in=None, calls_blind_transfer_out=None, calls_dialed=None,
                 calls_hold=None, calls_ringed=None, max_dialing_time=None, max_hold_time=None, max_ring_time=None,
                 max_talk_time=None, max_work_time=None, satisfaction_index=None, satisfaction_rate=None,
                 satisfaction_surveys_offered=None, satisfaction_surveys_responded=None, total_dialing_time=None, total_hold_time=None,
                 total_ring_time=None, total_talk_time=None, total_work_time=None):
        self.answer_rate = answer_rate  # type: float
        self.average_dialing_time = average_dialing_time  # type: float
        self.average_hold_time = average_hold_time  # type: float
        self.average_ring_time = average_ring_time  # type: float
        self.average_talk_time = average_talk_time  # type: float
        self.average_work_time = average_work_time  # type: float
        self.calls_answered = calls_answered  # type: long
        self.calls_attended_transfer_in = calls_attended_transfer_in  # type: long
        self.calls_attended_transfer_out = calls_attended_transfer_out  # type: long
        self.calls_blind_transfer_in = calls_blind_transfer_in  # type: long
        self.calls_blind_transfer_out = calls_blind_transfer_out  # type: long
        self.calls_dialed = calls_dialed  # type: long
        self.calls_hold = calls_hold  # type: long
        self.calls_ringed = calls_ringed  # type: long
        self.max_dialing_time = max_dialing_time  # type: long
        self.max_hold_time = max_hold_time  # type: long
        self.max_ring_time = max_ring_time  # type: long
        self.max_talk_time = max_talk_time  # type: long
        self.max_work_time = max_work_time  # type: long
        self.satisfaction_index = satisfaction_index  # type: float
        self.satisfaction_rate = satisfaction_rate  # type: float
        self.satisfaction_surveys_offered = satisfaction_surveys_offered  # type: long
        self.satisfaction_surveys_responded = satisfaction_surveys_responded  # type: long
        self.total_dialing_time = total_dialing_time  # type: long
        self.total_hold_time = total_hold_time  # type: long
        self.total_ring_time = total_ring_time  # type: long
        self.total_talk_time = total_talk_time  # type: long
        self.total_work_time = total_work_time  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListIntervalSkillGroupReportResponseBodyDataOutbound, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.answer_rate is not None:
            result['AnswerRate'] = self.answer_rate
        if self.average_dialing_time is not None:
            result['AverageDialingTime'] = self.average_dialing_time
        if self.average_hold_time is not None:
            result['AverageHoldTime'] = self.average_hold_time
        if self.average_ring_time is not None:
            result['AverageRingTime'] = self.average_ring_time
        if self.average_talk_time is not None:
            result['AverageTalkTime'] = self.average_talk_time
        if self.average_work_time is not None:
            result['AverageWorkTime'] = self.average_work_time
        if self.calls_answered is not None:
            result['CallsAnswered'] = self.calls_answered
        if self.calls_attended_transfer_in is not None:
            result['CallsAttendedTransferIn'] = self.calls_attended_transfer_in
        if self.calls_attended_transfer_out is not None:
            result['CallsAttendedTransferOut'] = self.calls_attended_transfer_out
        if self.calls_blind_transfer_in is not None:
            result['CallsBlindTransferIn'] = self.calls_blind_transfer_in
        if self.calls_blind_transfer_out is not None:
            result['CallsBlindTransferOut'] = self.calls_blind_transfer_out
        if self.calls_dialed is not None:
            result['CallsDialed'] = self.calls_dialed
        if self.calls_hold is not None:
            result['CallsHold'] = self.calls_hold
        if self.calls_ringed is not None:
            result['CallsRinged'] = self.calls_ringed
        if self.max_dialing_time is not None:
            result['MaxDialingTime'] = self.max_dialing_time
        if self.max_hold_time is not None:
            result['MaxHoldTime'] = self.max_hold_time
        if self.max_ring_time is not None:
            result['MaxRingTime'] = self.max_ring_time
        if self.max_talk_time is not None:
            result['MaxTalkTime'] = self.max_talk_time
        if self.max_work_time is not None:
            result['MaxWorkTime'] = self.max_work_time
        if self.satisfaction_index is not None:
            result['SatisfactionIndex'] = self.satisfaction_index
        if self.satisfaction_rate is not None:
            result['SatisfactionRate'] = self.satisfaction_rate
        if self.satisfaction_surveys_offered is not None:
            result['SatisfactionSurveysOffered'] = self.satisfaction_surveys_offered
        if self.satisfaction_surveys_responded is not None:
            result['SatisfactionSurveysResponded'] = self.satisfaction_surveys_responded
        if self.total_dialing_time is not None:
            result['TotalDialingTime'] = self.total_dialing_time
        if self.total_hold_time is not None:
            result['TotalHoldTime'] = self.total_hold_time
        if self.total_ring_time is not None:
            result['TotalRingTime'] = self.total_ring_time
        if self.total_talk_time is not None:
            result['TotalTalkTime'] = self.total_talk_time
        if self.total_work_time is not None:
            result['TotalWorkTime'] = self.total_work_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AnswerRate') is not None:
            self.answer_rate = m.get('AnswerRate')
        if m.get('AverageDialingTime') is not None:
            self.average_dialing_time = m.get('AverageDialingTime')
        if m.get('AverageHoldTime') is not None:
            self.average_hold_time = m.get('AverageHoldTime')
        if m.get('AverageRingTime') is not None:
            self.average_ring_time = m.get('AverageRingTime')
        if m.get('AverageTalkTime') is not None:
            self.average_talk_time = m.get('AverageTalkTime')
        if m.get('AverageWorkTime') is not None:
            self.average_work_time = m.get('AverageWorkTime')
        if m.get('CallsAnswered') is not None:
            self.calls_answered = m.get('CallsAnswered')
        if m.get('CallsAttendedTransferIn') is not None:
            self.calls_attended_transfer_in = m.get('CallsAttendedTransferIn')
        if m.get('CallsAttendedTransferOut') is not None:
            self.calls_attended_transfer_out = m.get('CallsAttendedTransferOut')
        if m.get('CallsBlindTransferIn') is not None:
            self.calls_blind_transfer_in = m.get('CallsBlindTransferIn')
        if m.get('CallsBlindTransferOut') is not None:
            self.calls_blind_transfer_out = m.get('CallsBlindTransferOut')
        if m.get('CallsDialed') is not None:
            self.calls_dialed = m.get('CallsDialed')
        if m.get('CallsHold') is not None:
            self.calls_hold = m.get('CallsHold')
        if m.get('CallsRinged') is not None:
            self.calls_ringed = m.get('CallsRinged')
        if m.get('MaxDialingTime') is not None:
            self.max_dialing_time = m.get('MaxDialingTime')
        if m.get('MaxHoldTime') is not None:
            self.max_hold_time = m.get('MaxHoldTime')
        if m.get('MaxRingTime') is not None:
            self.max_ring_time = m.get('MaxRingTime')
        if m.get('MaxTalkTime') is not None:
            self.max_talk_time = m.get('MaxTalkTime')
        if m.get('MaxWorkTime') is not None:
            self.max_work_time = m.get('MaxWorkTime')
        if m.get('SatisfactionIndex') is not None:
            self.satisfaction_index = m.get('SatisfactionIndex')
        if m.get('SatisfactionRate') is not None:
            self.satisfaction_rate = m.get('SatisfactionRate')
        if m.get('SatisfactionSurveysOffered') is not None:
            self.satisfaction_surveys_offered = m.get('SatisfactionSurveysOffered')
        if m.get('SatisfactionSurveysResponded') is not None:
            self.satisfaction_surveys_responded = m.get('SatisfactionSurveysResponded')
        if m.get('TotalDialingTime') is not None:
            self.total_dialing_time = m.get('TotalDialingTime')
        if m.get('TotalHoldTime') is not None:
            self.total_hold_time = m.get('TotalHoldTime')
        if m.get('TotalRingTime') is not None:
            self.total_ring_time = m.get('TotalRingTime')
        if m.get('TotalTalkTime') is not None:
            self.total_talk_time = m.get('TotalTalkTime')
        if m.get('TotalWorkTime') is not None:
            self.total_work_time = m.get('TotalWorkTime')
        return self


class ListIntervalSkillGroupReportResponseBodyDataOverall(TeaModel):
    def __init__(self, average_break_time=None, average_hold_time=None, average_ready_time=None,
                 average_talk_time=None, average_work_time=None, max_break_time=None, max_hold_time=None, max_ready_time=None,
                 max_talk_time=None, max_work_time=None, occupancy_rate=None, satisfaction_index=None, satisfaction_rate=None,
                 satisfaction_surveys_offered=None, satisfaction_surveys_responded=None, total_break_time=None, total_calls=None,
                 total_hold_time=None, total_logged_in_time=None, total_ready_time=None, total_talk_time=None,
                 total_work_time=None):
        self.average_break_time = average_break_time  # type: float
        self.average_hold_time = average_hold_time  # type: float
        self.average_ready_time = average_ready_time  # type: float
        self.average_talk_time = average_talk_time  # type: float
        self.average_work_time = average_work_time  # type: float
        self.max_break_time = max_break_time  # type: long
        self.max_hold_time = max_hold_time  # type: long
        self.max_ready_time = max_ready_time  # type: long
        self.max_talk_time = max_talk_time  # type: long
        self.max_work_time = max_work_time  # type: long
        self.occupancy_rate = occupancy_rate  # type: float
        self.satisfaction_index = satisfaction_index  # type: float
        self.satisfaction_rate = satisfaction_rate  # type: float
        self.satisfaction_surveys_offered = satisfaction_surveys_offered  # type: long
        self.satisfaction_surveys_responded = satisfaction_surveys_responded  # type: long
        self.total_break_time = total_break_time  # type: long
        self.total_calls = total_calls  # type: long
        self.total_hold_time = total_hold_time  # type: long
        self.total_logged_in_time = total_logged_in_time  # type: long
        self.total_ready_time = total_ready_time  # type: long
        self.total_talk_time = total_talk_time  # type: long
        self.total_work_time = total_work_time  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListIntervalSkillGroupReportResponseBodyDataOverall, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.average_break_time is not None:
            result['AverageBreakTime'] = self.average_break_time
        if self.average_hold_time is not None:
            result['AverageHoldTime'] = self.average_hold_time
        if self.average_ready_time is not None:
            result['AverageReadyTime'] = self.average_ready_time
        if self.average_talk_time is not None:
            result['AverageTalkTime'] = self.average_talk_time
        if self.average_work_time is not None:
            result['AverageWorkTime'] = self.average_work_time
        if self.max_break_time is not None:
            result['MaxBreakTime'] = self.max_break_time
        if self.max_hold_time is not None:
            result['MaxHoldTime'] = self.max_hold_time
        if self.max_ready_time is not None:
            result['MaxReadyTime'] = self.max_ready_time
        if self.max_talk_time is not None:
            result['MaxTalkTime'] = self.max_talk_time
        if self.max_work_time is not None:
            result['MaxWorkTime'] = self.max_work_time
        if self.occupancy_rate is not None:
            result['OccupancyRate'] = self.occupancy_rate
        if self.satisfaction_index is not None:
            result['SatisfactionIndex'] = self.satisfaction_index
        if self.satisfaction_rate is not None:
            result['SatisfactionRate'] = self.satisfaction_rate
        if self.satisfaction_surveys_offered is not None:
            result['SatisfactionSurveysOffered'] = self.satisfaction_surveys_offered
        if self.satisfaction_surveys_responded is not None:
            result['SatisfactionSurveysResponded'] = self.satisfaction_surveys_responded
        if self.total_break_time is not None:
            result['TotalBreakTime'] = self.total_break_time
        if self.total_calls is not None:
            result['TotalCalls'] = self.total_calls
        if self.total_hold_time is not None:
            result['TotalHoldTime'] = self.total_hold_time
        if self.total_logged_in_time is not None:
            result['TotalLoggedInTime'] = self.total_logged_in_time
        if self.total_ready_time is not None:
            result['TotalReadyTime'] = self.total_ready_time
        if self.total_talk_time is not None:
            result['TotalTalkTime'] = self.total_talk_time
        if self.total_work_time is not None:
            result['TotalWorkTime'] = self.total_work_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AverageBreakTime') is not None:
            self.average_break_time = m.get('AverageBreakTime')
        if m.get('AverageHoldTime') is not None:
            self.average_hold_time = m.get('AverageHoldTime')
        if m.get('AverageReadyTime') is not None:
            self.average_ready_time = m.get('AverageReadyTime')
        if m.get('AverageTalkTime') is not None:
            self.average_talk_time = m.get('AverageTalkTime')
        if m.get('AverageWorkTime') is not None:
            self.average_work_time = m.get('AverageWorkTime')
        if m.get('MaxBreakTime') is not None:
            self.max_break_time = m.get('MaxBreakTime')
        if m.get('MaxHoldTime') is not None:
            self.max_hold_time = m.get('MaxHoldTime')
        if m.get('MaxReadyTime') is not None:
            self.max_ready_time = m.get('MaxReadyTime')
        if m.get('MaxTalkTime') is not None:
            self.max_talk_time = m.get('MaxTalkTime')
        if m.get('MaxWorkTime') is not None:
            self.max_work_time = m.get('MaxWorkTime')
        if m.get('OccupancyRate') is not None:
            self.occupancy_rate = m.get('OccupancyRate')
        if m.get('SatisfactionIndex') is not None:
            self.satisfaction_index = m.get('SatisfactionIndex')
        if m.get('SatisfactionRate') is not None:
            self.satisfaction_rate = m.get('SatisfactionRate')
        if m.get('SatisfactionSurveysOffered') is not None:
            self.satisfaction_surveys_offered = m.get('SatisfactionSurveysOffered')
        if m.get('SatisfactionSurveysResponded') is not None:
            self.satisfaction_surveys_responded = m.get('SatisfactionSurveysResponded')
        if m.get('TotalBreakTime') is not None:
            self.total_break_time = m.get('TotalBreakTime')
        if m.get('TotalCalls') is not None:
            self.total_calls = m.get('TotalCalls')
        if m.get('TotalHoldTime') is not None:
            self.total_hold_time = m.get('TotalHoldTime')
        if m.get('TotalLoggedInTime') is not None:
            self.total_logged_in_time = m.get('TotalLoggedInTime')
        if m.get('TotalReadyTime') is not None:
            self.total_ready_time = m.get('TotalReadyTime')
        if m.get('TotalTalkTime') is not None:
            self.total_talk_time = m.get('TotalTalkTime')
        if m.get('TotalWorkTime') is not None:
            self.total_work_time = m.get('TotalWorkTime')
        return self


class ListIntervalSkillGroupReportResponseBodyData(TeaModel):
    def __init__(self, inbound=None, outbound=None, overall=None, stats_time=None):
        self.inbound = inbound  # type: ListIntervalSkillGroupReportResponseBodyDataInbound
        self.outbound = outbound  # type: ListIntervalSkillGroupReportResponseBodyDataOutbound
        self.overall = overall  # type: ListIntervalSkillGroupReportResponseBodyDataOverall
        self.stats_time = stats_time  # type: long

    def validate(self):
        if self.inbound:
            self.inbound.validate()
        if self.outbound:
            self.outbound.validate()
        if self.overall:
            self.overall.validate()

    def to_map(self):
        _map = super(ListIntervalSkillGroupReportResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.inbound is not None:
            result['Inbound'] = self.inbound.to_map()
        if self.outbound is not None:
            result['Outbound'] = self.outbound.to_map()
        if self.overall is not None:
            result['Overall'] = self.overall.to_map()
        if self.stats_time is not None:
            result['StatsTime'] = self.stats_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Inbound') is not None:
            temp_model = ListIntervalSkillGroupReportResponseBodyDataInbound()
            self.inbound = temp_model.from_map(m['Inbound'])
        if m.get('Outbound') is not None:
            temp_model = ListIntervalSkillGroupReportResponseBodyDataOutbound()
            self.outbound = temp_model.from_map(m['Outbound'])
        if m.get('Overall') is not None:
            temp_model = ListIntervalSkillGroupReportResponseBodyDataOverall()
            self.overall = temp_model.from_map(m['Overall'])
        if m.get('StatsTime') is not None:
            self.stats_time = m.get('StatsTime')
        return self


class ListIntervalSkillGroupReportResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: list[ListIntervalSkillGroupReportResponseBodyData]
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListIntervalSkillGroupReportResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = ListIntervalSkillGroupReportResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListIntervalSkillGroupReportResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ListIntervalSkillGroupReportResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListIntervalSkillGroupReportResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListIntervalSkillGroupReportResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListIvrTrackingDetailsRequest(TeaModel):
    def __init__(self, contact_id=None, instance_id=None, page_number=None, page_size=None):
        self.contact_id = contact_id  # type: str
        self.instance_id = instance_id  # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListIvrTrackingDetailsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.contact_id is not None:
            result['ContactId'] = self.contact_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ContactId') is not None:
            self.contact_id = m.get('ContactId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class ListIvrTrackingDetailsResponseBodyDataList(TeaModel):
    def __init__(self, callee=None, caller=None, channel_id=None, channel_variables=None, contact_id=None,
                 enter_time=None, flow_id=None, flow_name=None, instance=None, leave_time=None, node_exit_code=None,
                 node_id=None, node_name=None, node_properties=None, node_type=None, node_variables=None):
        self.callee = callee  # type: str
        self.caller = caller  # type: str
        self.channel_id = channel_id  # type: str
        self.channel_variables = channel_variables  # type: str
        self.contact_id = contact_id  # type: str
        self.enter_time = enter_time  # type: long
        self.flow_id = flow_id  # type: str
        self.flow_name = flow_name  # type: str
        self.instance = instance  # type: str
        self.leave_time = leave_time  # type: long
        self.node_exit_code = node_exit_code  # type: str
        self.node_id = node_id  # type: str
        self.node_name = node_name  # type: str
        self.node_properties = node_properties  # type: dict[str, any]
        self.node_type = node_type  # type: str
        self.node_variables = node_variables  # type: dict[str, any]

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListIvrTrackingDetailsResponseBodyDataList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.callee is not None:
            result['Callee'] = self.callee
        if self.caller is not None:
            result['Caller'] = self.caller
        if self.channel_id is not None:
            result['ChannelId'] = self.channel_id
        if self.channel_variables is not None:
            result['ChannelVariables'] = self.channel_variables
        if self.contact_id is not None:
            result['ContactId'] = self.contact_id
        if self.enter_time is not None:
            result['EnterTime'] = self.enter_time
        if self.flow_id is not None:
            result['FlowId'] = self.flow_id
        if self.flow_name is not None:
            result['FlowName'] = self.flow_name
        if self.instance is not None:
            result['Instance'] = self.instance
        if self.leave_time is not None:
            result['LeaveTime'] = self.leave_time
        if self.node_exit_code is not None:
            result['NodeExitCode'] = self.node_exit_code
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.node_name is not None:
            result['NodeName'] = self.node_name
        if self.node_properties is not None:
            result['NodeProperties'] = self.node_properties
        if self.node_type is not None:
            result['NodeType'] = self.node_type
        if self.node_variables is not None:
            result['NodeVariables'] = self.node_variables
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Callee') is not None:
            self.callee = m.get('Callee')
        if m.get('Caller') is not None:
            self.caller = m.get('Caller')
        if m.get('ChannelId') is not None:
            self.channel_id = m.get('ChannelId')
        if m.get('ChannelVariables') is not None:
            self.channel_variables = m.get('ChannelVariables')
        if m.get('ContactId') is not None:
            self.contact_id = m.get('ContactId')
        if m.get('EnterTime') is not None:
            self.enter_time = m.get('EnterTime')
        if m.get('FlowId') is not None:
            self.flow_id = m.get('FlowId')
        if m.get('FlowName') is not None:
            self.flow_name = m.get('FlowName')
        if m.get('Instance') is not None:
            self.instance = m.get('Instance')
        if m.get('LeaveTime') is not None:
            self.leave_time = m.get('LeaveTime')
        if m.get('NodeExitCode') is not None:
            self.node_exit_code = m.get('NodeExitCode')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('NodeName') is not None:
            self.node_name = m.get('NodeName')
        if m.get('NodeProperties') is not None:
            self.node_properties = m.get('NodeProperties')
        if m.get('NodeType') is not None:
            self.node_type = m.get('NodeType')
        if m.get('NodeVariables') is not None:
            self.node_variables = m.get('NodeVariables')
        return self


class ListIvrTrackingDetailsResponseBodyData(TeaModel):
    def __init__(self, list=None, page_number=None, page_size=None, total_count=None):
        self.list = list  # type: list[ListIvrTrackingDetailsResponseBodyDataList]
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.total_count = total_count  # type: int

    def validate(self):
        if self.list:
            for k in self.list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListIvrTrackingDetailsResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['List'] = []
        if self.list is not None:
            for k in self.list:
                result['List'].append(k.to_map() if k else None)
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.list = []
        if m.get('List') is not None:
            for k in m.get('List'):
                temp_model = ListIvrTrackingDetailsResponseBodyDataList()
                self.list.append(temp_model.from_map(k))
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListIvrTrackingDetailsResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: ListIvrTrackingDetailsResponseBodyData
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(ListIvrTrackingDetailsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = ListIvrTrackingDetailsResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListIvrTrackingDetailsResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ListIvrTrackingDetailsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListIvrTrackingDetailsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListIvrTrackingDetailsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListOutboundNumbersOfUserRequest(TeaModel):
    def __init__(self, instance_id=None, page_number=None, page_size=None, skill_group_id_list=None, user_id=None):
        self.instance_id = instance_id  # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.skill_group_id_list = skill_group_id_list  # type: str
        self.user_id = user_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListOutboundNumbersOfUserRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.skill_group_id_list is not None:
            result['SkillGroupIdList'] = self.skill_group_id_list
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('SkillGroupIdList') is not None:
            self.skill_group_id_list = m.get('SkillGroupIdList')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class ListOutboundNumbersOfUserResponseBodyDataList(TeaModel):
    def __init__(self, city=None, number=None, province=None):
        self.city = city  # type: str
        self.number = number  # type: str
        self.province = province  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListOutboundNumbersOfUserResponseBodyDataList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.city is not None:
            result['City'] = self.city
        if self.number is not None:
            result['Number'] = self.number
        if self.province is not None:
            result['Province'] = self.province
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('City') is not None:
            self.city = m.get('City')
        if m.get('Number') is not None:
            self.number = m.get('Number')
        if m.get('Province') is not None:
            self.province = m.get('Province')
        return self


class ListOutboundNumbersOfUserResponseBodyData(TeaModel):
    def __init__(self, list=None, page_number=None, page_size=None, total_count=None):
        self.list = list  # type: list[ListOutboundNumbersOfUserResponseBodyDataList]
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.total_count = total_count  # type: int

    def validate(self):
        if self.list:
            for k in self.list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListOutboundNumbersOfUserResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['List'] = []
        if self.list is not None:
            for k in self.list:
                result['List'].append(k.to_map() if k else None)
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.list = []
        if m.get('List') is not None:
            for k in m.get('List'):
                temp_model = ListOutboundNumbersOfUserResponseBodyDataList()
                self.list.append(temp_model.from_map(k))
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListOutboundNumbersOfUserResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: ListOutboundNumbersOfUserResponseBodyData
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(ListOutboundNumbersOfUserResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = ListOutboundNumbersOfUserResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListOutboundNumbersOfUserResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ListOutboundNumbersOfUserResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListOutboundNumbersOfUserResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListOutboundNumbersOfUserResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListPersonalNumbersOfUserRequest(TeaModel):
    def __init__(self, instance_id=None, is_member=None, page_number=None, page_size=None, search_pattern=None,
                 user_id=None):
        self.instance_id = instance_id  # type: str
        self.is_member = is_member  # type: bool
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.search_pattern = search_pattern  # type: str
        self.user_id = user_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListPersonalNumbersOfUserRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.is_member is not None:
            result['IsMember'] = self.is_member
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.search_pattern is not None:
            result['SearchPattern'] = self.search_pattern
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('IsMember') is not None:
            self.is_member = m.get('IsMember')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('SearchPattern') is not None:
            self.search_pattern = m.get('SearchPattern')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class ListPersonalNumbersOfUserResponseBodyDataList(TeaModel):
    def __init__(self, active=None, city=None, contact_flow_id=None, instance_id=None, number=None, province=None):
        self.active = active  # type: bool
        self.city = city  # type: str
        self.contact_flow_id = contact_flow_id  # type: str
        self.instance_id = instance_id  # type: str
        self.number = number  # type: str
        self.province = province  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListPersonalNumbersOfUserResponseBodyDataList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.active is not None:
            result['Active'] = self.active
        if self.city is not None:
            result['City'] = self.city
        if self.contact_flow_id is not None:
            result['ContactFlowId'] = self.contact_flow_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.number is not None:
            result['Number'] = self.number
        if self.province is not None:
            result['Province'] = self.province
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Active') is not None:
            self.active = m.get('Active')
        if m.get('City') is not None:
            self.city = m.get('City')
        if m.get('ContactFlowId') is not None:
            self.contact_flow_id = m.get('ContactFlowId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Number') is not None:
            self.number = m.get('Number')
        if m.get('Province') is not None:
            self.province = m.get('Province')
        return self


class ListPersonalNumbersOfUserResponseBodyData(TeaModel):
    def __init__(self, list=None, page_number=None, page_size=None, total_count=None):
        self.list = list  # type: list[ListPersonalNumbersOfUserResponseBodyDataList]
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.total_count = total_count  # type: int

    def validate(self):
        if self.list:
            for k in self.list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListPersonalNumbersOfUserResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['List'] = []
        if self.list is not None:
            for k in self.list:
                result['List'].append(k.to_map() if k else None)
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.list = []
        if m.get('List') is not None:
            for k in m.get('List'):
                temp_model = ListPersonalNumbersOfUserResponseBodyDataList()
                self.list.append(temp_model.from_map(k))
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListPersonalNumbersOfUserResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: ListPersonalNumbersOfUserResponseBodyData
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(ListPersonalNumbersOfUserResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = ListPersonalNumbersOfUserResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListPersonalNumbersOfUserResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ListPersonalNumbersOfUserResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListPersonalNumbersOfUserResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListPersonalNumbersOfUserResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListPhoneNumbersRequest(TeaModel):
    def __init__(self, active=None, instance_id=None, page_number=None, page_size=None, search_pattern=None,
                 usage=None):
        self.active = active  # type: bool
        self.instance_id = instance_id  # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.search_pattern = search_pattern  # type: str
        self.usage = usage  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListPhoneNumbersRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.active is not None:
            result['Active'] = self.active
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.search_pattern is not None:
            result['SearchPattern'] = self.search_pattern
        if self.usage is not None:
            result['Usage'] = self.usage
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Active') is not None:
            self.active = m.get('Active')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('SearchPattern') is not None:
            self.search_pattern = m.get('SearchPattern')
        if m.get('Usage') is not None:
            self.usage = m.get('Usage')
        return self


class ListPhoneNumbersResponseBodyDataListSkillGroups(TeaModel):
    def __init__(self, display_name=None, instance_id=None, name=None, skill_group_id=None):
        self.display_name = display_name  # type: str
        self.instance_id = instance_id  # type: str
        self.name = name  # type: str
        self.skill_group_id = skill_group_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListPhoneNumbersResponseBodyDataListSkillGroups, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.display_name is not None:
            result['DisplayName'] = self.display_name
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.name is not None:
            result['Name'] = self.name
        if self.skill_group_id is not None:
            result['SkillGroupId'] = self.skill_group_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DisplayName') is not None:
            self.display_name = m.get('DisplayName')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('SkillGroupId') is not None:
            self.skill_group_id = m.get('SkillGroupId')
        return self


class ListPhoneNumbersResponseBodyDataList(TeaModel):
    def __init__(self, active=None, city=None, contact_flow_id=None, contact_flow_name=None, create_time=None,
                 instance_id=None, number=None, provider=None, province=None, skill_groups=None, tags=None, usage=None,
                 user_id=None):
        self.active = active  # type: bool
        self.city = city  # type: str
        self.contact_flow_id = contact_flow_id  # type: str
        self.contact_flow_name = contact_flow_name  # type: str
        self.create_time = create_time  # type: str
        self.instance_id = instance_id  # type: str
        self.number = number  # type: str
        self.provider = provider  # type: str
        self.province = province  # type: str
        self.skill_groups = skill_groups  # type: list[ListPhoneNumbersResponseBodyDataListSkillGroups]
        self.tags = tags  # type: str
        self.usage = usage  # type: str
        self.user_id = user_id  # type: str

    def validate(self):
        if self.skill_groups:
            for k in self.skill_groups:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListPhoneNumbersResponseBodyDataList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.active is not None:
            result['Active'] = self.active
        if self.city is not None:
            result['City'] = self.city
        if self.contact_flow_id is not None:
            result['ContactFlowId'] = self.contact_flow_id
        if self.contact_flow_name is not None:
            result['ContactFlowName'] = self.contact_flow_name
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.number is not None:
            result['Number'] = self.number
        if self.provider is not None:
            result['Provider'] = self.provider
        if self.province is not None:
            result['Province'] = self.province
        result['SkillGroups'] = []
        if self.skill_groups is not None:
            for k in self.skill_groups:
                result['SkillGroups'].append(k.to_map() if k else None)
        if self.tags is not None:
            result['Tags'] = self.tags
        if self.usage is not None:
            result['Usage'] = self.usage
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Active') is not None:
            self.active = m.get('Active')
        if m.get('City') is not None:
            self.city = m.get('City')
        if m.get('ContactFlowId') is not None:
            self.contact_flow_id = m.get('ContactFlowId')
        if m.get('ContactFlowName') is not None:
            self.contact_flow_name = m.get('ContactFlowName')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Number') is not None:
            self.number = m.get('Number')
        if m.get('Provider') is not None:
            self.provider = m.get('Provider')
        if m.get('Province') is not None:
            self.province = m.get('Province')
        self.skill_groups = []
        if m.get('SkillGroups') is not None:
            for k in m.get('SkillGroups'):
                temp_model = ListPhoneNumbersResponseBodyDataListSkillGroups()
                self.skill_groups.append(temp_model.from_map(k))
        if m.get('Tags') is not None:
            self.tags = m.get('Tags')
        if m.get('Usage') is not None:
            self.usage = m.get('Usage')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class ListPhoneNumbersResponseBodyData(TeaModel):
    def __init__(self, list=None, page_number=None, page_size=None, total_count=None):
        self.list = list  # type: list[ListPhoneNumbersResponseBodyDataList]
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.total_count = total_count  # type: int

    def validate(self):
        if self.list:
            for k in self.list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListPhoneNumbersResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['List'] = []
        if self.list is not None:
            for k in self.list:
                result['List'].append(k.to_map() if k else None)
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.list = []
        if m.get('List') is not None:
            for k in m.get('List'):
                temp_model = ListPhoneNumbersResponseBodyDataList()
                self.list.append(temp_model.from_map(k))
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListPhoneNumbersResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, page_number=None, page_size=None,
                 request_id=None):
        self.code = code  # type: str
        self.data = data  # type: ListPhoneNumbersResponseBodyData
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(ListPhoneNumbersResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = ListPhoneNumbersResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListPhoneNumbersResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ListPhoneNumbersResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListPhoneNumbersResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListPhoneNumbersResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListPhoneNumbersOfSkillGroupRequest(TeaModel):
    def __init__(self, active=None, instance_id=None, is_member=None, page_number=None, page_size=None,
                 search_pattern=None, skill_group_id=None):
        self.active = active  # type: bool
        self.instance_id = instance_id  # type: str
        self.is_member = is_member  # type: bool
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.search_pattern = search_pattern  # type: str
        self.skill_group_id = skill_group_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListPhoneNumbersOfSkillGroupRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.active is not None:
            result['Active'] = self.active
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.is_member is not None:
            result['IsMember'] = self.is_member
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.search_pattern is not None:
            result['SearchPattern'] = self.search_pattern
        if self.skill_group_id is not None:
            result['SkillGroupId'] = self.skill_group_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Active') is not None:
            self.active = m.get('Active')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('IsMember') is not None:
            self.is_member = m.get('IsMember')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('SearchPattern') is not None:
            self.search_pattern = m.get('SearchPattern')
        if m.get('SkillGroupId') is not None:
            self.skill_group_id = m.get('SkillGroupId')
        return self


class ListPhoneNumbersOfSkillGroupResponseBodyDataList(TeaModel):
    def __init__(self, active=None, city=None, contact_flow_id=None, instance_id=None, number=None, province=None,
                 usage=None):
        self.active = active  # type: bool
        self.city = city  # type: str
        self.contact_flow_id = contact_flow_id  # type: str
        self.instance_id = instance_id  # type: str
        self.number = number  # type: str
        self.province = province  # type: str
        self.usage = usage  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListPhoneNumbersOfSkillGroupResponseBodyDataList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.active is not None:
            result['Active'] = self.active
        if self.city is not None:
            result['City'] = self.city
        if self.contact_flow_id is not None:
            result['ContactFlowId'] = self.contact_flow_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.number is not None:
            result['Number'] = self.number
        if self.province is not None:
            result['Province'] = self.province
        if self.usage is not None:
            result['Usage'] = self.usage
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Active') is not None:
            self.active = m.get('Active')
        if m.get('City') is not None:
            self.city = m.get('City')
        if m.get('ContactFlowId') is not None:
            self.contact_flow_id = m.get('ContactFlowId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Number') is not None:
            self.number = m.get('Number')
        if m.get('Province') is not None:
            self.province = m.get('Province')
        if m.get('Usage') is not None:
            self.usage = m.get('Usage')
        return self


class ListPhoneNumbersOfSkillGroupResponseBodyData(TeaModel):
    def __init__(self, list=None, page_number=None, page_size=None, total_count=None):
        self.list = list  # type: list[ListPhoneNumbersOfSkillGroupResponseBodyDataList]
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.total_count = total_count  # type: int

    def validate(self):
        if self.list:
            for k in self.list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListPhoneNumbersOfSkillGroupResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['List'] = []
        if self.list is not None:
            for k in self.list:
                result['List'].append(k.to_map() if k else None)
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.list = []
        if m.get('List') is not None:
            for k in m.get('List'):
                temp_model = ListPhoneNumbersOfSkillGroupResponseBodyDataList()
                self.list.append(temp_model.from_map(k))
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListPhoneNumbersOfSkillGroupResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: ListPhoneNumbersOfSkillGroupResponseBodyData
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(ListPhoneNumbersOfSkillGroupResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = ListPhoneNumbersOfSkillGroupResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListPhoneNumbersOfSkillGroupResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ListPhoneNumbersOfSkillGroupResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListPhoneNumbersOfSkillGroupResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListPhoneNumbersOfSkillGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListPrivilegesOfUserRequest(TeaModel):
    def __init__(self, instance_id=None):
        self.instance_id = instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListPrivilegesOfUserRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class ListPrivilegesOfUserResponseBodyData(TeaModel):
    def __init__(self, instance_id=None, name=None, scope=None):
        self.instance_id = instance_id  # type: str
        self.name = name  # type: str
        self.scope = scope  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListPrivilegesOfUserResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.name is not None:
            result['Name'] = self.name
        if self.scope is not None:
            result['Scope'] = self.scope
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Scope') is not None:
            self.scope = m.get('Scope')
        return self


class ListPrivilegesOfUserResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: list[ListPrivilegesOfUserResponseBodyData]
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListPrivilegesOfUserResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = ListPrivilegesOfUserResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListPrivilegesOfUserResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ListPrivilegesOfUserResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListPrivilegesOfUserResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListPrivilegesOfUserResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListRamUsersRequest(TeaModel):
    def __init__(self, instance_id=None, page_number=None, page_size=None, search_pattern=None):
        self.instance_id = instance_id  # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.search_pattern = search_pattern  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListRamUsersRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.search_pattern is not None:
            result['SearchPattern'] = self.search_pattern
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('SearchPattern') is not None:
            self.search_pattern = m.get('SearchPattern')
        return self


class ListRamUsersResponseBodyDataList(TeaModel):
    def __init__(self, aliyun_uid=None, display_name=None, email=None, login_name=None, mobile=None, primary=None,
                 ram_id=None):
        self.aliyun_uid = aliyun_uid  # type: long
        self.display_name = display_name  # type: str
        self.email = email  # type: str
        self.login_name = login_name  # type: str
        self.mobile = mobile  # type: str
        self.primary = primary  # type: bool
        self.ram_id = ram_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListRamUsersResponseBodyDataList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.aliyun_uid is not None:
            result['AliyunUid'] = self.aliyun_uid
        if self.display_name is not None:
            result['DisplayName'] = self.display_name
        if self.email is not None:
            result['Email'] = self.email
        if self.login_name is not None:
            result['LoginName'] = self.login_name
        if self.mobile is not None:
            result['Mobile'] = self.mobile
        if self.primary is not None:
            result['Primary'] = self.primary
        if self.ram_id is not None:
            result['RamId'] = self.ram_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AliyunUid') is not None:
            self.aliyun_uid = m.get('AliyunUid')
        if m.get('DisplayName') is not None:
            self.display_name = m.get('DisplayName')
        if m.get('Email') is not None:
            self.email = m.get('Email')
        if m.get('LoginName') is not None:
            self.login_name = m.get('LoginName')
        if m.get('Mobile') is not None:
            self.mobile = m.get('Mobile')
        if m.get('Primary') is not None:
            self.primary = m.get('Primary')
        if m.get('RamId') is not None:
            self.ram_id = m.get('RamId')
        return self


class ListRamUsersResponseBodyData(TeaModel):
    def __init__(self, list=None, page_number=None, page_size=None, total_count=None):
        self.list = list  # type: list[ListRamUsersResponseBodyDataList]
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.total_count = total_count  # type: int

    def validate(self):
        if self.list:
            for k in self.list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListRamUsersResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['List'] = []
        if self.list is not None:
            for k in self.list:
                result['List'].append(k.to_map() if k else None)
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.list = []
        if m.get('List') is not None:
            for k in m.get('List'):
                temp_model = ListRamUsersResponseBodyDataList()
                self.list.append(temp_model.from_map(k))
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListRamUsersResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, params=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: ListRamUsersResponseBodyData
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.params = params  # type: list[str]
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(ListRamUsersResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.params is not None:
            result['Params'] = self.params
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = ListRamUsersResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Params') is not None:
            self.params = m.get('Params')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListRamUsersResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ListRamUsersResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListRamUsersResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListRamUsersResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListRealtimeAgentStatesRequest(TeaModel):
    def __init__(self, agent_id_list=None, agent_name=None, instance_id=None, page_number=None, page_size=None,
                 skill_group_id=None, state_list=None):
        self.agent_id_list = agent_id_list  # type: str
        self.agent_name = agent_name  # type: str
        self.instance_id = instance_id  # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.skill_group_id = skill_group_id  # type: str
        self.state_list = state_list  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListRealtimeAgentStatesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_id_list is not None:
            result['AgentIdList'] = self.agent_id_list
        if self.agent_name is not None:
            result['AgentName'] = self.agent_name
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.skill_group_id is not None:
            result['SkillGroupId'] = self.skill_group_id
        if self.state_list is not None:
            result['StateList'] = self.state_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AgentIdList') is not None:
            self.agent_id_list = m.get('AgentIdList')
        if m.get('AgentName') is not None:
            self.agent_name = m.get('AgentName')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('SkillGroupId') is not None:
            self.skill_group_id = m.get('SkillGroupId')
        if m.get('StateList') is not None:
            self.state_list = m.get('StateList')
        return self


class ListRealtimeAgentStatesResponseBodyDataList(TeaModel):
    def __init__(self, agent_id=None, agent_name=None, counter_party=None, extension=None, instance_id=None,
                 skill_group_id_list=None, state=None, state_code=None, state_time=None):
        self.agent_id = agent_id  # type: str
        self.agent_name = agent_name  # type: str
        self.counter_party = counter_party  # type: str
        self.extension = extension  # type: str
        self.instance_id = instance_id  # type: str
        self.skill_group_id_list = skill_group_id_list  # type: list[str]
        self.state = state  # type: str
        self.state_code = state_code  # type: str
        self.state_time = state_time  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListRealtimeAgentStatesResponseBodyDataList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_id is not None:
            result['AgentId'] = self.agent_id
        if self.agent_name is not None:
            result['AgentName'] = self.agent_name
        if self.counter_party is not None:
            result['CounterParty'] = self.counter_party
        if self.extension is not None:
            result['Extension'] = self.extension
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.skill_group_id_list is not None:
            result['SkillGroupIdList'] = self.skill_group_id_list
        if self.state is not None:
            result['State'] = self.state
        if self.state_code is not None:
            result['StateCode'] = self.state_code
        if self.state_time is not None:
            result['StateTime'] = self.state_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AgentId') is not None:
            self.agent_id = m.get('AgentId')
        if m.get('AgentName') is not None:
            self.agent_name = m.get('AgentName')
        if m.get('CounterParty') is not None:
            self.counter_party = m.get('CounterParty')
        if m.get('Extension') is not None:
            self.extension = m.get('Extension')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('SkillGroupIdList') is not None:
            self.skill_group_id_list = m.get('SkillGroupIdList')
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('StateCode') is not None:
            self.state_code = m.get('StateCode')
        if m.get('StateTime') is not None:
            self.state_time = m.get('StateTime')
        return self


class ListRealtimeAgentStatesResponseBodyData(TeaModel):
    def __init__(self, list=None, page_number=None, page_size=None, total_count=None):
        self.list = list  # type: list[ListRealtimeAgentStatesResponseBodyDataList]
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.total_count = total_count  # type: int

    def validate(self):
        if self.list:
            for k in self.list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListRealtimeAgentStatesResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['List'] = []
        if self.list is not None:
            for k in self.list:
                result['List'].append(k.to_map() if k else None)
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.list = []
        if m.get('List') is not None:
            for k in m.get('List'):
                temp_model = ListRealtimeAgentStatesResponseBodyDataList()
                self.list.append(temp_model.from_map(k))
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListRealtimeAgentStatesResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: ListRealtimeAgentStatesResponseBodyData
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(ListRealtimeAgentStatesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = ListRealtimeAgentStatesResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListRealtimeAgentStatesResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ListRealtimeAgentStatesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListRealtimeAgentStatesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListRealtimeAgentStatesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListRealtimeSkillGroupStatesRequest(TeaModel):
    def __init__(self, instance_id=None, page_number=None, page_size=None, skill_group_id_list=None):
        self.instance_id = instance_id  # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.skill_group_id_list = skill_group_id_list  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListRealtimeSkillGroupStatesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.skill_group_id_list is not None:
            result['SkillGroupIdList'] = self.skill_group_id_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('SkillGroupIdList') is not None:
            self.skill_group_id_list = m.get('SkillGroupIdList')
        return self


class ListRealtimeSkillGroupStatesResponseBodyDataList(TeaModel):
    def __init__(self, breaking_agents=None, instance_id=None, logged_in_agents=None, longest_waiting_time=None,
                 ready_agents=None, skill_group_id=None, skill_group_name=None, talking_agents=None, waiting_calls=None,
                 working_agents=None):
        self.breaking_agents = breaking_agents  # type: long
        self.instance_id = instance_id  # type: str
        self.logged_in_agents = logged_in_agents  # type: long
        self.longest_waiting_time = longest_waiting_time  # type: long
        self.ready_agents = ready_agents  # type: long
        self.skill_group_id = skill_group_id  # type: str
        self.skill_group_name = skill_group_name  # type: str
        self.talking_agents = talking_agents  # type: long
        self.waiting_calls = waiting_calls  # type: long
        self.working_agents = working_agents  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListRealtimeSkillGroupStatesResponseBodyDataList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.breaking_agents is not None:
            result['BreakingAgents'] = self.breaking_agents
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.logged_in_agents is not None:
            result['LoggedInAgents'] = self.logged_in_agents
        if self.longest_waiting_time is not None:
            result['LongestWaitingTime'] = self.longest_waiting_time
        if self.ready_agents is not None:
            result['ReadyAgents'] = self.ready_agents
        if self.skill_group_id is not None:
            result['SkillGroupId'] = self.skill_group_id
        if self.skill_group_name is not None:
            result['SkillGroupName'] = self.skill_group_name
        if self.talking_agents is not None:
            result['TalkingAgents'] = self.talking_agents
        if self.waiting_calls is not None:
            result['WaitingCalls'] = self.waiting_calls
        if self.working_agents is not None:
            result['WorkingAgents'] = self.working_agents
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BreakingAgents') is not None:
            self.breaking_agents = m.get('BreakingAgents')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('LoggedInAgents') is not None:
            self.logged_in_agents = m.get('LoggedInAgents')
        if m.get('LongestWaitingTime') is not None:
            self.longest_waiting_time = m.get('LongestWaitingTime')
        if m.get('ReadyAgents') is not None:
            self.ready_agents = m.get('ReadyAgents')
        if m.get('SkillGroupId') is not None:
            self.skill_group_id = m.get('SkillGroupId')
        if m.get('SkillGroupName') is not None:
            self.skill_group_name = m.get('SkillGroupName')
        if m.get('TalkingAgents') is not None:
            self.talking_agents = m.get('TalkingAgents')
        if m.get('WaitingCalls') is not None:
            self.waiting_calls = m.get('WaitingCalls')
        if m.get('WorkingAgents') is not None:
            self.working_agents = m.get('WorkingAgents')
        return self


class ListRealtimeSkillGroupStatesResponseBodyData(TeaModel):
    def __init__(self, list=None, page_number=None, page_size=None, total_count=None):
        self.list = list  # type: list[ListRealtimeSkillGroupStatesResponseBodyDataList]
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.total_count = total_count  # type: int

    def validate(self):
        if self.list:
            for k in self.list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListRealtimeSkillGroupStatesResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['List'] = []
        if self.list is not None:
            for k in self.list:
                result['List'].append(k.to_map() if k else None)
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.list = []
        if m.get('List') is not None:
            for k in m.get('List'):
                temp_model = ListRealtimeSkillGroupStatesResponseBodyDataList()
                self.list.append(temp_model.from_map(k))
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListRealtimeSkillGroupStatesResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: ListRealtimeSkillGroupStatesResponseBodyData
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(ListRealtimeSkillGroupStatesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = ListRealtimeSkillGroupStatesResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListRealtimeSkillGroupStatesResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ListRealtimeSkillGroupStatesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListRealtimeSkillGroupStatesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListRealtimeSkillGroupStatesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListRecentCallDetailRecordsRequest(TeaModel):
    def __init__(self, criteria=None, end_time=None, instance_id=None, page_number=None, page_size=None,
                 start_time=None):
        self.criteria = criteria  # type: str
        self.end_time = end_time  # type: long
        self.instance_id = instance_id  # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.start_time = start_time  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListRecentCallDetailRecordsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.criteria is not None:
            result['Criteria'] = self.criteria
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Criteria') is not None:
            self.criteria = m.get('Criteria')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class ListRecentCallDetailRecordsResponseBodyDataList(TeaModel):
    def __init__(self, agent_ids=None, call_duration=None, called_number=None, calling_number=None,
                 contact_disposition=None, contact_id=None, contact_type=None, duration=None, instance_id=None, skill_group_ids=None,
                 start_time=None):
        self.agent_ids = agent_ids  # type: str
        self.call_duration = call_duration  # type: str
        self.called_number = called_number  # type: str
        self.calling_number = calling_number  # type: str
        self.contact_disposition = contact_disposition  # type: str
        self.contact_id = contact_id  # type: str
        self.contact_type = contact_type  # type: str
        self.duration = duration  # type: long
        self.instance_id = instance_id  # type: str
        self.skill_group_ids = skill_group_ids  # type: str
        self.start_time = start_time  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListRecentCallDetailRecordsResponseBodyDataList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_ids is not None:
            result['AgentIds'] = self.agent_ids
        if self.call_duration is not None:
            result['CallDuration'] = self.call_duration
        if self.called_number is not None:
            result['CalledNumber'] = self.called_number
        if self.calling_number is not None:
            result['CallingNumber'] = self.calling_number
        if self.contact_disposition is not None:
            result['ContactDisposition'] = self.contact_disposition
        if self.contact_id is not None:
            result['ContactId'] = self.contact_id
        if self.contact_type is not None:
            result['ContactType'] = self.contact_type
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.skill_group_ids is not None:
            result['SkillGroupIds'] = self.skill_group_ids
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AgentIds') is not None:
            self.agent_ids = m.get('AgentIds')
        if m.get('CallDuration') is not None:
            self.call_duration = m.get('CallDuration')
        if m.get('CalledNumber') is not None:
            self.called_number = m.get('CalledNumber')
        if m.get('CallingNumber') is not None:
            self.calling_number = m.get('CallingNumber')
        if m.get('ContactDisposition') is not None:
            self.contact_disposition = m.get('ContactDisposition')
        if m.get('ContactId') is not None:
            self.contact_id = m.get('ContactId')
        if m.get('ContactType') is not None:
            self.contact_type = m.get('ContactType')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('SkillGroupIds') is not None:
            self.skill_group_ids = m.get('SkillGroupIds')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class ListRecentCallDetailRecordsResponseBodyData(TeaModel):
    def __init__(self, list=None, page_number=None, page_size=None, total_count=None):
        self.list = list  # type: list[ListRecentCallDetailRecordsResponseBodyDataList]
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.total_count = total_count  # type: int

    def validate(self):
        if self.list:
            for k in self.list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListRecentCallDetailRecordsResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['List'] = []
        if self.list is not None:
            for k in self.list:
                result['List'].append(k.to_map() if k else None)
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.list = []
        if m.get('List') is not None:
            for k in m.get('List'):
                temp_model = ListRecentCallDetailRecordsResponseBodyDataList()
                self.list.append(temp_model.from_map(k))
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListRecentCallDetailRecordsResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: ListRecentCallDetailRecordsResponseBodyData
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(ListRecentCallDetailRecordsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = ListRecentCallDetailRecordsResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListRecentCallDetailRecordsResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ListRecentCallDetailRecordsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListRecentCallDetailRecordsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListRecentCallDetailRecordsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListRolesRequest(TeaModel):
    def __init__(self, instance_id=None):
        self.instance_id = instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListRolesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class ListRolesResponseBodyData(TeaModel):
    def __init__(self, name=None, role_id=None):
        self.name = name  # type: str
        self.role_id = role_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListRolesResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.role_id is not None:
            result['RoleId'] = self.role_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('RoleId') is not None:
            self.role_id = m.get('RoleId')
        return self


class ListRolesResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: list[ListRolesResponseBodyData]
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListRolesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = ListRolesResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListRolesResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ListRolesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListRolesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListRolesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListSipCallRecordsRequest(TeaModel):
    def __init__(self, contact_id_list=None, instance_id=None):
        self.contact_id_list = contact_id_list  # type: str
        self.instance_id = instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListSipCallRecordsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.contact_id_list is not None:
            result['ContactIdList'] = self.contact_id_list
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ContactIdList') is not None:
            self.contact_id_list = m.get('ContactIdList')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class ListSipCallRecordsResponseBodyData(TeaModel):
    def __init__(self, call_id=None, callee=None, callee_cluster_id=None, caller=None, caller_cluster_id=None,
                 contact_id=None, early_media_text=None, early_media_url=None, established_time=None, instance_id=None,
                 invite_time=None, last_response_code=None, last_response_text=None, release_reason_code=None,
                 released_time=None, ring_time=None):
        self.call_id = call_id  # type: str
        self.callee = callee  # type: str
        self.callee_cluster_id = callee_cluster_id  # type: str
        self.caller = caller  # type: str
        self.caller_cluster_id = caller_cluster_id  # type: str
        self.contact_id = contact_id  # type: str
        self.early_media_text = early_media_text  # type: str
        self.early_media_url = early_media_url  # type: str
        self.established_time = established_time  # type: long
        self.instance_id = instance_id  # type: str
        self.invite_time = invite_time  # type: long
        self.last_response_code = last_response_code  # type: int
        self.last_response_text = last_response_text  # type: str
        self.release_reason_code = release_reason_code  # type: int
        self.released_time = released_time  # type: long
        self.ring_time = ring_time  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListSipCallRecordsResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.call_id is not None:
            result['CallId'] = self.call_id
        if self.callee is not None:
            result['Callee'] = self.callee
        if self.callee_cluster_id is not None:
            result['CalleeClusterId'] = self.callee_cluster_id
        if self.caller is not None:
            result['Caller'] = self.caller
        if self.caller_cluster_id is not None:
            result['CallerClusterId'] = self.caller_cluster_id
        if self.contact_id is not None:
            result['ContactId'] = self.contact_id
        if self.early_media_text is not None:
            result['EarlyMediaText'] = self.early_media_text
        if self.early_media_url is not None:
            result['EarlyMediaUrl'] = self.early_media_url
        if self.established_time is not None:
            result['EstablishedTime'] = self.established_time
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.invite_time is not None:
            result['InviteTime'] = self.invite_time
        if self.last_response_code is not None:
            result['LastResponseCode'] = self.last_response_code
        if self.last_response_text is not None:
            result['LastResponseText'] = self.last_response_text
        if self.release_reason_code is not None:
            result['ReleaseReasonCode'] = self.release_reason_code
        if self.released_time is not None:
            result['ReleasedTime'] = self.released_time
        if self.ring_time is not None:
            result['RingTime'] = self.ring_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CallId') is not None:
            self.call_id = m.get('CallId')
        if m.get('Callee') is not None:
            self.callee = m.get('Callee')
        if m.get('CalleeClusterId') is not None:
            self.callee_cluster_id = m.get('CalleeClusterId')
        if m.get('Caller') is not None:
            self.caller = m.get('Caller')
        if m.get('CallerClusterId') is not None:
            self.caller_cluster_id = m.get('CallerClusterId')
        if m.get('ContactId') is not None:
            self.contact_id = m.get('ContactId')
        if m.get('EarlyMediaText') is not None:
            self.early_media_text = m.get('EarlyMediaText')
        if m.get('EarlyMediaUrl') is not None:
            self.early_media_url = m.get('EarlyMediaUrl')
        if m.get('EstablishedTime') is not None:
            self.established_time = m.get('EstablishedTime')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InviteTime') is not None:
            self.invite_time = m.get('InviteTime')
        if m.get('LastResponseCode') is not None:
            self.last_response_code = m.get('LastResponseCode')
        if m.get('LastResponseText') is not None:
            self.last_response_text = m.get('LastResponseText')
        if m.get('ReleaseReasonCode') is not None:
            self.release_reason_code = m.get('ReleaseReasonCode')
        if m.get('ReleasedTime') is not None:
            self.released_time = m.get('ReleasedTime')
        if m.get('RingTime') is not None:
            self.ring_time = m.get('RingTime')
        return self


class ListSipCallRecordsResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: list[ListSipCallRecordsResponseBodyData]
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListSipCallRecordsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = ListSipCallRecordsResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListSipCallRecordsResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ListSipCallRecordsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListSipCallRecordsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListSipCallRecordsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListSipTracesRequest(TeaModel):
    def __init__(self, call_id=None, instance_id=None):
        self.call_id = call_id  # type: str
        self.instance_id = instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListSipTracesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.call_id is not None:
            result['CallId'] = self.call_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CallId') is not None:
            self.call_id = m.get('CallId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class ListSipTracesResponseBodyData(TeaModel):
    def __init__(self, call_id=None, contact_id=None, destination_node_ip=None, first_line=None, payload=None,
                 source_node_ip=None, timestamp=None):
        self.call_id = call_id  # type: str
        self.contact_id = contact_id  # type: str
        self.destination_node_ip = destination_node_ip  # type: str
        self.first_line = first_line  # type: str
        self.payload = payload  # type: str
        self.source_node_ip = source_node_ip  # type: str
        self.timestamp = timestamp  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListSipTracesResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.call_id is not None:
            result['CallId'] = self.call_id
        if self.contact_id is not None:
            result['ContactId'] = self.contact_id
        if self.destination_node_ip is not None:
            result['DestinationNodeIp'] = self.destination_node_ip
        if self.first_line is not None:
            result['FirstLine'] = self.first_line
        if self.payload is not None:
            result['Payload'] = self.payload
        if self.source_node_ip is not None:
            result['SourceNodeIp'] = self.source_node_ip
        if self.timestamp is not None:
            result['Timestamp'] = self.timestamp
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CallId') is not None:
            self.call_id = m.get('CallId')
        if m.get('ContactId') is not None:
            self.contact_id = m.get('ContactId')
        if m.get('DestinationNodeIp') is not None:
            self.destination_node_ip = m.get('DestinationNodeIp')
        if m.get('FirstLine') is not None:
            self.first_line = m.get('FirstLine')
        if m.get('Payload') is not None:
            self.payload = m.get('Payload')
        if m.get('SourceNodeIp') is not None:
            self.source_node_ip = m.get('SourceNodeIp')
        if m.get('Timestamp') is not None:
            self.timestamp = m.get('Timestamp')
        return self


class ListSipTracesResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: list[ListSipTracesResponseBodyData]
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListSipTracesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = ListSipTracesResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListSipTracesResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ListSipTracesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListSipTracesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListSipTracesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListSkillGroupsRequest(TeaModel):
    def __init__(self, instance_id=None, page_number=None, page_size=None, search_pattern=None):
        self.instance_id = instance_id  # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.search_pattern = search_pattern  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListSkillGroupsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.search_pattern is not None:
            result['SearchPattern'] = self.search_pattern
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('SearchPattern') is not None:
            self.search_pattern = m.get('SearchPattern')
        return self


class ListSkillGroupsResponseBodyDataList(TeaModel):
    def __init__(self, description=None, display_name=None, instance_id=None, phone_number_count=None,
                 skill_group_id=None, skill_group_name=None, user_count=None):
        self.description = description  # type: str
        self.display_name = display_name  # type: str
        self.instance_id = instance_id  # type: str
        self.phone_number_count = phone_number_count  # type: int
        self.skill_group_id = skill_group_id  # type: str
        self.skill_group_name = skill_group_name  # type: str
        self.user_count = user_count  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListSkillGroupsResponseBodyDataList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.display_name is not None:
            result['DisplayName'] = self.display_name
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.phone_number_count is not None:
            result['PhoneNumberCount'] = self.phone_number_count
        if self.skill_group_id is not None:
            result['SkillGroupId'] = self.skill_group_id
        if self.skill_group_name is not None:
            result['SkillGroupName'] = self.skill_group_name
        if self.user_count is not None:
            result['UserCount'] = self.user_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DisplayName') is not None:
            self.display_name = m.get('DisplayName')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PhoneNumberCount') is not None:
            self.phone_number_count = m.get('PhoneNumberCount')
        if m.get('SkillGroupId') is not None:
            self.skill_group_id = m.get('SkillGroupId')
        if m.get('SkillGroupName') is not None:
            self.skill_group_name = m.get('SkillGroupName')
        if m.get('UserCount') is not None:
            self.user_count = m.get('UserCount')
        return self


class ListSkillGroupsResponseBodyData(TeaModel):
    def __init__(self, list=None, page_number=None, page_size=None, total_count=None):
        self.list = list  # type: list[ListSkillGroupsResponseBodyDataList]
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.total_count = total_count  # type: int

    def validate(self):
        if self.list:
            for k in self.list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListSkillGroupsResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['List'] = []
        if self.list is not None:
            for k in self.list:
                result['List'].append(k.to_map() if k else None)
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.list = []
        if m.get('List') is not None:
            for k in m.get('List'):
                temp_model = ListSkillGroupsResponseBodyDataList()
                self.list.append(temp_model.from_map(k))
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListSkillGroupsResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: ListSkillGroupsResponseBodyData
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(ListSkillGroupsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = ListSkillGroupsResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListSkillGroupsResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ListSkillGroupsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListSkillGroupsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListSkillGroupsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListSkillLevelsOfUserRequest(TeaModel):
    def __init__(self, instance_id=None, is_member=None, page_number=None, page_size=None, search_pattern=None,
                 user_id=None):
        self.instance_id = instance_id  # type: str
        self.is_member = is_member  # type: bool
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.search_pattern = search_pattern  # type: str
        self.user_id = user_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListSkillLevelsOfUserRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.is_member is not None:
            result['IsMember'] = self.is_member
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.search_pattern is not None:
            result['SearchPattern'] = self.search_pattern
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('IsMember') is not None:
            self.is_member = m.get('IsMember')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('SearchPattern') is not None:
            self.search_pattern = m.get('SearchPattern')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class ListSkillLevelsOfUserResponseBodyDataList(TeaModel):
    def __init__(self, skill_group_id=None, skill_group_name=None, skill_level=None):
        self.skill_group_id = skill_group_id  # type: str
        self.skill_group_name = skill_group_name  # type: str
        self.skill_level = skill_level  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListSkillLevelsOfUserResponseBodyDataList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.skill_group_id is not None:
            result['SkillGroupId'] = self.skill_group_id
        if self.skill_group_name is not None:
            result['SkillGroupName'] = self.skill_group_name
        if self.skill_level is not None:
            result['SkillLevel'] = self.skill_level
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('SkillGroupId') is not None:
            self.skill_group_id = m.get('SkillGroupId')
        if m.get('SkillGroupName') is not None:
            self.skill_group_name = m.get('SkillGroupName')
        if m.get('SkillLevel') is not None:
            self.skill_level = m.get('SkillLevel')
        return self


class ListSkillLevelsOfUserResponseBodyData(TeaModel):
    def __init__(self, list=None, page_number=None, page_size=None, total_count=None):
        self.list = list  # type: list[ListSkillLevelsOfUserResponseBodyDataList]
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.total_count = total_count  # type: int

    def validate(self):
        if self.list:
            for k in self.list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListSkillLevelsOfUserResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['List'] = []
        if self.list is not None:
            for k in self.list:
                result['List'].append(k.to_map() if k else None)
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.list = []
        if m.get('List') is not None:
            for k in m.get('List'):
                temp_model = ListSkillLevelsOfUserResponseBodyDataList()
                self.list.append(temp_model.from_map(k))
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListSkillLevelsOfUserResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: ListSkillLevelsOfUserResponseBodyData
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(ListSkillLevelsOfUserResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = ListSkillLevelsOfUserResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListSkillLevelsOfUserResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ListSkillLevelsOfUserResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListSkillLevelsOfUserResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListSkillLevelsOfUserResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListUnassignedNumbersRequest(TeaModel):
    def __init__(self, instance_id=None, page_number=None, page_size=None, search_pattern=None):
        self.instance_id = instance_id  # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.search_pattern = search_pattern  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListUnassignedNumbersRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.search_pattern is not None:
            result['SearchPattern'] = self.search_pattern
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('SearchPattern') is not None:
            self.search_pattern = m.get('SearchPattern')
        return self


class ListUnassignedNumbersResponseBodyDataList(TeaModel):
    def __init__(self, active=None, city=None, number=None, province=None, usage=None):
        self.active = active  # type: bool
        self.city = city  # type: str
        self.number = number  # type: str
        self.province = province  # type: str
        self.usage = usage  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListUnassignedNumbersResponseBodyDataList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.active is not None:
            result['Active'] = self.active
        if self.city is not None:
            result['City'] = self.city
        if self.number is not None:
            result['Number'] = self.number
        if self.province is not None:
            result['Province'] = self.province
        if self.usage is not None:
            result['Usage'] = self.usage
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Active') is not None:
            self.active = m.get('Active')
        if m.get('City') is not None:
            self.city = m.get('City')
        if m.get('Number') is not None:
            self.number = m.get('Number')
        if m.get('Province') is not None:
            self.province = m.get('Province')
        if m.get('Usage') is not None:
            self.usage = m.get('Usage')
        return self


class ListUnassignedNumbersResponseBodyData(TeaModel):
    def __init__(self, list=None, page_number=None, page_size=None, total_count=None):
        self.list = list  # type: list[ListUnassignedNumbersResponseBodyDataList]
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.total_count = total_count  # type: int

    def validate(self):
        if self.list:
            for k in self.list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListUnassignedNumbersResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['List'] = []
        if self.list is not None:
            for k in self.list:
                result['List'].append(k.to_map() if k else None)
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.list = []
        if m.get('List') is not None:
            for k in m.get('List'):
                temp_model = ListUnassignedNumbersResponseBodyDataList()
                self.list.append(temp_model.from_map(k))
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListUnassignedNumbersResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: ListUnassignedNumbersResponseBodyData
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(ListUnassignedNumbersResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = ListUnassignedNumbersResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListUnassignedNumbersResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ListUnassignedNumbersResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListUnassignedNumbersResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListUnassignedNumbersResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListUserLevelsOfSkillGroupRequest(TeaModel):
    def __init__(self, instance_id=None, is_member=None, page_number=None, page_size=None, search_pattern=None,
                 skill_group_id=None):
        self.instance_id = instance_id  # type: str
        self.is_member = is_member  # type: bool
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.search_pattern = search_pattern  # type: str
        self.skill_group_id = skill_group_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListUserLevelsOfSkillGroupRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.is_member is not None:
            result['IsMember'] = self.is_member
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.search_pattern is not None:
            result['SearchPattern'] = self.search_pattern
        if self.skill_group_id is not None:
            result['SkillGroupId'] = self.skill_group_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('IsMember') is not None:
            self.is_member = m.get('IsMember')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('SearchPattern') is not None:
            self.search_pattern = m.get('SearchPattern')
        if m.get('SkillGroupId') is not None:
            self.skill_group_id = m.get('SkillGroupId')
        return self


class ListUserLevelsOfSkillGroupResponseBodyDataList(TeaModel):
    def __init__(self, display_name=None, login_name=None, role_id=None, role_name=None, skill_group_id=None,
                 skill_group_name=None, skill_level=None, user_id=None):
        self.display_name = display_name  # type: str
        self.login_name = login_name  # type: str
        self.role_id = role_id  # type: str
        self.role_name = role_name  # type: str
        self.skill_group_id = skill_group_id  # type: str
        self.skill_group_name = skill_group_name  # type: str
        self.skill_level = skill_level  # type: int
        self.user_id = user_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListUserLevelsOfSkillGroupResponseBodyDataList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.display_name is not None:
            result['DisplayName'] = self.display_name
        if self.login_name is not None:
            result['LoginName'] = self.login_name
        if self.role_id is not None:
            result['RoleId'] = self.role_id
        if self.role_name is not None:
            result['RoleName'] = self.role_name
        if self.skill_group_id is not None:
            result['SkillGroupId'] = self.skill_group_id
        if self.skill_group_name is not None:
            result['SkillGroupName'] = self.skill_group_name
        if self.skill_level is not None:
            result['SkillLevel'] = self.skill_level
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DisplayName') is not None:
            self.display_name = m.get('DisplayName')
        if m.get('LoginName') is not None:
            self.login_name = m.get('LoginName')
        if m.get('RoleId') is not None:
            self.role_id = m.get('RoleId')
        if m.get('RoleName') is not None:
            self.role_name = m.get('RoleName')
        if m.get('SkillGroupId') is not None:
            self.skill_group_id = m.get('SkillGroupId')
        if m.get('SkillGroupName') is not None:
            self.skill_group_name = m.get('SkillGroupName')
        if m.get('SkillLevel') is not None:
            self.skill_level = m.get('SkillLevel')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class ListUserLevelsOfSkillGroupResponseBodyData(TeaModel):
    def __init__(self, list=None, page_number=None, page_size=None, total_count=None):
        self.list = list  # type: list[ListUserLevelsOfSkillGroupResponseBodyDataList]
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.total_count = total_count  # type: int

    def validate(self):
        if self.list:
            for k in self.list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListUserLevelsOfSkillGroupResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['List'] = []
        if self.list is not None:
            for k in self.list:
                result['List'].append(k.to_map() if k else None)
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.list = []
        if m.get('List') is not None:
            for k in m.get('List'):
                temp_model = ListUserLevelsOfSkillGroupResponseBodyDataList()
                self.list.append(temp_model.from_map(k))
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListUserLevelsOfSkillGroupResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: ListUserLevelsOfSkillGroupResponseBodyData
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(ListUserLevelsOfSkillGroupResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = ListUserLevelsOfSkillGroupResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListUserLevelsOfSkillGroupResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ListUserLevelsOfSkillGroupResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListUserLevelsOfSkillGroupResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListUserLevelsOfSkillGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListUsersRequest(TeaModel):
    def __init__(self, instance_id=None, page_number=None, page_size=None, search_pattern=None):
        self.instance_id = instance_id  # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.search_pattern = search_pattern  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListUsersRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.search_pattern is not None:
            result['SearchPattern'] = self.search_pattern
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('SearchPattern') is not None:
            self.search_pattern = m.get('SearchPattern')
        return self


class ListUsersResponseBodyDataListPersonalOutboundNumberList(TeaModel):
    def __init__(self, active=None, city=None, number=None, province=None, usage=None):
        self.active = active  # type: bool
        self.city = city  # type: str
        self.number = number  # type: str
        self.province = province  # type: str
        self.usage = usage  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListUsersResponseBodyDataListPersonalOutboundNumberList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.active is not None:
            result['Active'] = self.active
        if self.city is not None:
            result['City'] = self.city
        if self.number is not None:
            result['Number'] = self.number
        if self.province is not None:
            result['Province'] = self.province
        if self.usage is not None:
            result['Usage'] = self.usage
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Active') is not None:
            self.active = m.get('Active')
        if m.get('City') is not None:
            self.city = m.get('City')
        if m.get('Number') is not None:
            self.number = m.get('Number')
        if m.get('Province') is not None:
            self.province = m.get('Province')
        if m.get('Usage') is not None:
            self.usage = m.get('Usage')
        return self


class ListUsersResponseBodyDataListSkillLevelList(TeaModel):
    def __init__(self, skill_group_id=None, skill_group_name=None, skill_level=None):
        self.skill_group_id = skill_group_id  # type: str
        self.skill_group_name = skill_group_name  # type: str
        self.skill_level = skill_level  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListUsersResponseBodyDataListSkillLevelList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.skill_group_id is not None:
            result['SkillGroupId'] = self.skill_group_id
        if self.skill_group_name is not None:
            result['SkillGroupName'] = self.skill_group_name
        if self.skill_level is not None:
            result['SkillLevel'] = self.skill_level
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('SkillGroupId') is not None:
            self.skill_group_id = m.get('SkillGroupId')
        if m.get('SkillGroupName') is not None:
            self.skill_group_name = m.get('SkillGroupName')
        if m.get('SkillLevel') is not None:
            self.skill_level = m.get('SkillLevel')
        return self


class ListUsersResponseBodyDataList(TeaModel):
    def __init__(self, device_ext=None, device_id=None, device_state=None, display_id=None, display_name=None,
                 email=None, extension=None, login_name=None, mobile=None, personal_outbound_number_list=None,
                 primary_account=None, ram_id=None, role_id=None, role_name=None, skill_level_list=None, user_id=None,
                 work_mode=None):
        self.device_ext = device_ext  # type: str
        self.device_id = device_id  # type: str
        self.device_state = device_state  # type: str
        self.display_id = display_id  # type: str
        self.display_name = display_name  # type: str
        self.email = email  # type: str
        self.extension = extension  # type: str
        self.login_name = login_name  # type: str
        self.mobile = mobile  # type: str
        self.personal_outbound_number_list = personal_outbound_number_list  # type: list[ListUsersResponseBodyDataListPersonalOutboundNumberList]
        self.primary_account = primary_account  # type: bool
        self.ram_id = ram_id  # type: long
        self.role_id = role_id  # type: str
        self.role_name = role_name  # type: str
        self.skill_level_list = skill_level_list  # type: list[ListUsersResponseBodyDataListSkillLevelList]
        self.user_id = user_id  # type: str
        self.work_mode = work_mode  # type: str

    def validate(self):
        if self.personal_outbound_number_list:
            for k in self.personal_outbound_number_list:
                if k:
                    k.validate()
        if self.skill_level_list:
            for k in self.skill_level_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListUsersResponseBodyDataList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_ext is not None:
            result['DeviceExt'] = self.device_ext
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.device_state is not None:
            result['DeviceState'] = self.device_state
        if self.display_id is not None:
            result['DisplayId'] = self.display_id
        if self.display_name is not None:
            result['DisplayName'] = self.display_name
        if self.email is not None:
            result['Email'] = self.email
        if self.extension is not None:
            result['Extension'] = self.extension
        if self.login_name is not None:
            result['LoginName'] = self.login_name
        if self.mobile is not None:
            result['Mobile'] = self.mobile
        result['PersonalOutboundNumberList'] = []
        if self.personal_outbound_number_list is not None:
            for k in self.personal_outbound_number_list:
                result['PersonalOutboundNumberList'].append(k.to_map() if k else None)
        if self.primary_account is not None:
            result['PrimaryAccount'] = self.primary_account
        if self.ram_id is not None:
            result['RamId'] = self.ram_id
        if self.role_id is not None:
            result['RoleId'] = self.role_id
        if self.role_name is not None:
            result['RoleName'] = self.role_name
        result['SkillLevelList'] = []
        if self.skill_level_list is not None:
            for k in self.skill_level_list:
                result['SkillLevelList'].append(k.to_map() if k else None)
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.work_mode is not None:
            result['WorkMode'] = self.work_mode
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeviceExt') is not None:
            self.device_ext = m.get('DeviceExt')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('DeviceState') is not None:
            self.device_state = m.get('DeviceState')
        if m.get('DisplayId') is not None:
            self.display_id = m.get('DisplayId')
        if m.get('DisplayName') is not None:
            self.display_name = m.get('DisplayName')
        if m.get('Email') is not None:
            self.email = m.get('Email')
        if m.get('Extension') is not None:
            self.extension = m.get('Extension')
        if m.get('LoginName') is not None:
            self.login_name = m.get('LoginName')
        if m.get('Mobile') is not None:
            self.mobile = m.get('Mobile')
        self.personal_outbound_number_list = []
        if m.get('PersonalOutboundNumberList') is not None:
            for k in m.get('PersonalOutboundNumberList'):
                temp_model = ListUsersResponseBodyDataListPersonalOutboundNumberList()
                self.personal_outbound_number_list.append(temp_model.from_map(k))
        if m.get('PrimaryAccount') is not None:
            self.primary_account = m.get('PrimaryAccount')
        if m.get('RamId') is not None:
            self.ram_id = m.get('RamId')
        if m.get('RoleId') is not None:
            self.role_id = m.get('RoleId')
        if m.get('RoleName') is not None:
            self.role_name = m.get('RoleName')
        self.skill_level_list = []
        if m.get('SkillLevelList') is not None:
            for k in m.get('SkillLevelList'):
                temp_model = ListUsersResponseBodyDataListSkillLevelList()
                self.skill_level_list.append(temp_model.from_map(k))
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('WorkMode') is not None:
            self.work_mode = m.get('WorkMode')
        return self


class ListUsersResponseBodyData(TeaModel):
    def __init__(self, list=None, page_number=None, page_size=None, total_count=None):
        self.list = list  # type: list[ListUsersResponseBodyDataList]
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.total_count = total_count  # type: int

    def validate(self):
        if self.list:
            for k in self.list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListUsersResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['List'] = []
        if self.list is not None:
            for k in self.list:
                result['List'].append(k.to_map() if k else None)
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.list = []
        if m.get('List') is not None:
            for k in m.get('List'):
                temp_model = ListUsersResponseBodyDataList()
                self.list.append(temp_model.from_map(k))
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListUsersResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, params=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: ListUsersResponseBodyData
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.params = params  # type: list[str]
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(ListUsersResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.params is not None:
            result['Params'] = self.params
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = ListUsersResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Params') is not None:
            self.params = m.get('Params')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListUsersResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ListUsersResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListUsersResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListUsersResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class MakeCallRequest(TeaModel):
    def __init__(self, callee=None, caller=None, device_id=None, instance_id=None, masked_callee=None, tags=None,
                 timeout_seconds=None, user_id=None):
        self.callee = callee  # type: str
        self.caller = caller  # type: str
        self.device_id = device_id  # type: str
        self.instance_id = instance_id  # type: str
        self.masked_callee = masked_callee  # type: str
        self.tags = tags  # type: str
        self.timeout_seconds = timeout_seconds  # type: int
        self.user_id = user_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(MakeCallRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.callee is not None:
            result['Callee'] = self.callee
        if self.caller is not None:
            result['Caller'] = self.caller
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.masked_callee is not None:
            result['MaskedCallee'] = self.masked_callee
        if self.tags is not None:
            result['Tags'] = self.tags
        if self.timeout_seconds is not None:
            result['TimeoutSeconds'] = self.timeout_seconds
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Callee') is not None:
            self.callee = m.get('Callee')
        if m.get('Caller') is not None:
            self.caller = m.get('Caller')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('MaskedCallee') is not None:
            self.masked_callee = m.get('MaskedCallee')
        if m.get('Tags') is not None:
            self.tags = m.get('Tags')
        if m.get('TimeoutSeconds') is not None:
            self.timeout_seconds = m.get('TimeoutSeconds')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class MakeCallResponseBodyDataCallContextChannelContexts(TeaModel):
    def __init__(self, associated_data=None, call_type=None, channel_flags=None, channel_id=None,
                 channel_state=None, destination=None, job_id=None, originator=None, release_initiator=None, release_reason=None,
                 timestamp=None, user_extension=None, user_id=None):
        self.associated_data = associated_data  # type: dict[str, any]
        self.call_type = call_type  # type: str
        self.channel_flags = channel_flags  # type: str
        self.channel_id = channel_id  # type: str
        self.channel_state = channel_state  # type: str
        self.destination = destination  # type: str
        self.job_id = job_id  # type: str
        self.originator = originator  # type: str
        self.release_initiator = release_initiator  # type: str
        self.release_reason = release_reason  # type: str
        self.timestamp = timestamp  # type: long
        self.user_extension = user_extension  # type: str
        self.user_id = user_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(MakeCallResponseBodyDataCallContextChannelContexts, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.associated_data is not None:
            result['AssociatedData'] = self.associated_data
        if self.call_type is not None:
            result['CallType'] = self.call_type
        if self.channel_flags is not None:
            result['ChannelFlags'] = self.channel_flags
        if self.channel_id is not None:
            result['ChannelId'] = self.channel_id
        if self.channel_state is not None:
            result['ChannelState'] = self.channel_state
        if self.destination is not None:
            result['Destination'] = self.destination
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.originator is not None:
            result['Originator'] = self.originator
        if self.release_initiator is not None:
            result['ReleaseInitiator'] = self.release_initiator
        if self.release_reason is not None:
            result['ReleaseReason'] = self.release_reason
        if self.timestamp is not None:
            result['Timestamp'] = self.timestamp
        if self.user_extension is not None:
            result['UserExtension'] = self.user_extension
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AssociatedData') is not None:
            self.associated_data = m.get('AssociatedData')
        if m.get('CallType') is not None:
            self.call_type = m.get('CallType')
        if m.get('ChannelFlags') is not None:
            self.channel_flags = m.get('ChannelFlags')
        if m.get('ChannelId') is not None:
            self.channel_id = m.get('ChannelId')
        if m.get('ChannelState') is not None:
            self.channel_state = m.get('ChannelState')
        if m.get('Destination') is not None:
            self.destination = m.get('Destination')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('Originator') is not None:
            self.originator = m.get('Originator')
        if m.get('ReleaseInitiator') is not None:
            self.release_initiator = m.get('ReleaseInitiator')
        if m.get('ReleaseReason') is not None:
            self.release_reason = m.get('ReleaseReason')
        if m.get('Timestamp') is not None:
            self.timestamp = m.get('Timestamp')
        if m.get('UserExtension') is not None:
            self.user_extension = m.get('UserExtension')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class MakeCallResponseBodyDataCallContext(TeaModel):
    def __init__(self, call_type=None, channel_contexts=None, instance_id=None, job_id=None):
        self.call_type = call_type  # type: str
        self.channel_contexts = channel_contexts  # type: list[MakeCallResponseBodyDataCallContextChannelContexts]
        self.instance_id = instance_id  # type: str
        self.job_id = job_id  # type: str

    def validate(self):
        if self.channel_contexts:
            for k in self.channel_contexts:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(MakeCallResponseBodyDataCallContext, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.call_type is not None:
            result['CallType'] = self.call_type
        result['ChannelContexts'] = []
        if self.channel_contexts is not None:
            for k in self.channel_contexts:
                result['ChannelContexts'].append(k.to_map() if k else None)
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CallType') is not None:
            self.call_type = m.get('CallType')
        self.channel_contexts = []
        if m.get('ChannelContexts') is not None:
            for k in m.get('ChannelContexts'):
                temp_model = MakeCallResponseBodyDataCallContextChannelContexts()
                self.channel_contexts.append(temp_model.from_map(k))
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class MakeCallResponseBodyDataUserContext(TeaModel):
    def __init__(self, break_code=None, device_id=None, extension=None, instance_id=None, job_id=None,
                 outbound_scenario=None, signed_skill_group_id_list=None, user_id=None, user_state=None, work_mode=None):
        self.break_code = break_code  # type: str
        self.device_id = device_id  # type: str
        self.extension = extension  # type: str
        self.instance_id = instance_id  # type: str
        self.job_id = job_id  # type: str
        self.outbound_scenario = outbound_scenario  # type: bool
        self.signed_skill_group_id_list = signed_skill_group_id_list  # type: list[str]
        self.user_id = user_id  # type: str
        self.user_state = user_state  # type: str
        self.work_mode = work_mode  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(MakeCallResponseBodyDataUserContext, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.break_code is not None:
            result['BreakCode'] = self.break_code
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.extension is not None:
            result['Extension'] = self.extension
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.outbound_scenario is not None:
            result['OutboundScenario'] = self.outbound_scenario
        if self.signed_skill_group_id_list is not None:
            result['SignedSkillGroupIdList'] = self.signed_skill_group_id_list
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.user_state is not None:
            result['UserState'] = self.user_state
        if self.work_mode is not None:
            result['WorkMode'] = self.work_mode
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BreakCode') is not None:
            self.break_code = m.get('BreakCode')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('Extension') is not None:
            self.extension = m.get('Extension')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('OutboundScenario') is not None:
            self.outbound_scenario = m.get('OutboundScenario')
        if m.get('SignedSkillGroupIdList') is not None:
            self.signed_skill_group_id_list = m.get('SignedSkillGroupIdList')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('UserState') is not None:
            self.user_state = m.get('UserState')
        if m.get('WorkMode') is not None:
            self.work_mode = m.get('WorkMode')
        return self


class MakeCallResponseBodyData(TeaModel):
    def __init__(self, call_context=None, context_id=None, user_context=None):
        self.call_context = call_context  # type: MakeCallResponseBodyDataCallContext
        self.context_id = context_id  # type: long
        self.user_context = user_context  # type: MakeCallResponseBodyDataUserContext

    def validate(self):
        if self.call_context:
            self.call_context.validate()
        if self.user_context:
            self.user_context.validate()

    def to_map(self):
        _map = super(MakeCallResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.call_context is not None:
            result['CallContext'] = self.call_context.to_map()
        if self.context_id is not None:
            result['ContextId'] = self.context_id
        if self.user_context is not None:
            result['UserContext'] = self.user_context.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CallContext') is not None:
            temp_model = MakeCallResponseBodyDataCallContext()
            self.call_context = temp_model.from_map(m['CallContext'])
        if m.get('ContextId') is not None:
            self.context_id = m.get('ContextId')
        if m.get('UserContext') is not None:
            temp_model = MakeCallResponseBodyDataUserContext()
            self.user_context = temp_model.from_map(m['UserContext'])
        return self


class MakeCallResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, params=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: MakeCallResponseBodyData
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.params = params  # type: list[str]
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(MakeCallResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.params is not None:
            result['Params'] = self.params
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = MakeCallResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Params') is not None:
            self.params = m.get('Params')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class MakeCallResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: MakeCallResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(MakeCallResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = MakeCallResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ModifyInstanceRequest(TeaModel):
    def __init__(self, description=None, instance_id=None):
        self.description = description  # type: str
        self.instance_id = instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ModifyInstanceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class ModifyInstanceResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, params=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: str
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.params = params  # type: list[str]
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ModifyInstanceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.params is not None:
            result['Params'] = self.params
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Params') is not None:
            self.params = m.get('Params')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ModifyInstanceResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ModifyInstanceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ModifyInstanceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ModifyInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ModifyPhoneNumberRequest(TeaModel):
    def __init__(self, contact_flow_id=None, instance_id=None, number=None, usage=None):
        self.contact_flow_id = contact_flow_id  # type: str
        self.instance_id = instance_id  # type: str
        self.number = number  # type: str
        self.usage = usage  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ModifyPhoneNumberRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.contact_flow_id is not None:
            result['ContactFlowId'] = self.contact_flow_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.number is not None:
            result['Number'] = self.number
        if self.usage is not None:
            result['Usage'] = self.usage
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ContactFlowId') is not None:
            self.contact_flow_id = m.get('ContactFlowId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Number') is not None:
            self.number = m.get('Number')
        if m.get('Usage') is not None:
            self.usage = m.get('Usage')
        return self


class ModifyPhoneNumberResponseBody(TeaModel):
    def __init__(self, code=None, http_status_code=None, message=None, request_id=None):
        self.code = code  # type: str
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ModifyPhoneNumberResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ModifyPhoneNumberResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ModifyPhoneNumberResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ModifyPhoneNumberResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ModifyPhoneNumberResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ModifySkillGroupRequest(TeaModel):
    def __init__(self, description=None, display_name=None, instance_id=None, skill_group_id=None):
        self.description = description  # type: str
        self.display_name = display_name  # type: str
        self.instance_id = instance_id  # type: str
        self.skill_group_id = skill_group_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ModifySkillGroupRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.display_name is not None:
            result['DisplayName'] = self.display_name
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.skill_group_id is not None:
            result['SkillGroupId'] = self.skill_group_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DisplayName') is not None:
            self.display_name = m.get('DisplayName')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('SkillGroupId') is not None:
            self.skill_group_id = m.get('SkillGroupId')
        return self


class ModifySkillGroupResponseBody(TeaModel):
    def __init__(self, code=None, http_status_code=None, message=None, request_id=None):
        self.code = code  # type: str
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ModifySkillGroupResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ModifySkillGroupResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ModifySkillGroupResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ModifySkillGroupResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ModifySkillGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ModifySkillLevelsOfUserRequest(TeaModel):
    def __init__(self, instance_id=None, skill_level_list=None, user_id=None):
        self.instance_id = instance_id  # type: str
        self.skill_level_list = skill_level_list  # type: str
        self.user_id = user_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ModifySkillLevelsOfUserRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.skill_level_list is not None:
            result['SkillLevelList'] = self.skill_level_list
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('SkillLevelList') is not None:
            self.skill_level_list = m.get('SkillLevelList')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class ModifySkillLevelsOfUserResponseBody(TeaModel):
    def __init__(self, code=None, http_status_code=None, message=None, params=None, request_id=None):
        self.code = code  # type: str
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.params = params  # type: list[str]
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ModifySkillLevelsOfUserResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.params is not None:
            result['Params'] = self.params
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Params') is not None:
            self.params = m.get('Params')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ModifySkillLevelsOfUserResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ModifySkillLevelsOfUserResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ModifySkillLevelsOfUserResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ModifySkillLevelsOfUserResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ModifyUserRequest(TeaModel):
    def __init__(self, instance_id=None, mobile=None, role_id=None, user_id=None, work_mode=None):
        self.instance_id = instance_id  # type: str
        self.mobile = mobile  # type: str
        self.role_id = role_id  # type: str
        self.user_id = user_id  # type: str
        self.work_mode = work_mode  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ModifyUserRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.mobile is not None:
            result['Mobile'] = self.mobile
        if self.role_id is not None:
            result['RoleId'] = self.role_id
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.work_mode is not None:
            result['WorkMode'] = self.work_mode
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Mobile') is not None:
            self.mobile = m.get('Mobile')
        if m.get('RoleId') is not None:
            self.role_id = m.get('RoleId')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('WorkMode') is not None:
            self.work_mode = m.get('WorkMode')
        return self


class ModifyUserResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, params=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: str
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.params = params  # type: list[str]
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ModifyUserResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.params is not None:
            result['Params'] = self.params
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Params') is not None:
            self.params = m.get('Params')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ModifyUserResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ModifyUserResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ModifyUserResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ModifyUserResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ModifyUserLevelsOfSkillGroupRequest(TeaModel):
    def __init__(self, instance_id=None, skill_group_id=None, user_level_list=None):
        self.instance_id = instance_id  # type: str
        self.skill_group_id = skill_group_id  # type: str
        self.user_level_list = user_level_list  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ModifyUserLevelsOfSkillGroupRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.skill_group_id is not None:
            result['SkillGroupId'] = self.skill_group_id
        if self.user_level_list is not None:
            result['UserLevelList'] = self.user_level_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('SkillGroupId') is not None:
            self.skill_group_id = m.get('SkillGroupId')
        if m.get('UserLevelList') is not None:
            self.user_level_list = m.get('UserLevelList')
        return self


class ModifyUserLevelsOfSkillGroupResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: str
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ModifyUserLevelsOfSkillGroupResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ModifyUserLevelsOfSkillGroupResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ModifyUserLevelsOfSkillGroupResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ModifyUserLevelsOfSkillGroupResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ModifyUserLevelsOfSkillGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class MonitorCallRequest(TeaModel):
    def __init__(self, device_id=None, instance_id=None, monitored_user_id=None, timeout_seconds=None, user_id=None):
        self.device_id = device_id  # type: str
        self.instance_id = instance_id  # type: str
        self.monitored_user_id = monitored_user_id  # type: str
        self.timeout_seconds = timeout_seconds  # type: int
        self.user_id = user_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(MonitorCallRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.monitored_user_id is not None:
            result['MonitoredUserId'] = self.monitored_user_id
        if self.timeout_seconds is not None:
            result['TimeoutSeconds'] = self.timeout_seconds
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('MonitoredUserId') is not None:
            self.monitored_user_id = m.get('MonitoredUserId')
        if m.get('TimeoutSeconds') is not None:
            self.timeout_seconds = m.get('TimeoutSeconds')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class MonitorCallResponseBodyDataCallContextChannelContexts(TeaModel):
    def __init__(self, associated_data=None, call_type=None, channel_flags=None, channel_id=None,
                 channel_state=None, destination=None, index=None, job_id=None, originator=None, release_initiator=None,
                 release_reason=None, skill_group_id=None, timestamp=None, user_extension=None, user_id=None):
        self.associated_data = associated_data  # type: dict[str, any]
        self.call_type = call_type  # type: str
        self.channel_flags = channel_flags  # type: str
        self.channel_id = channel_id  # type: str
        self.channel_state = channel_state  # type: str
        self.destination = destination  # type: str
        self.index = index  # type: int
        self.job_id = job_id  # type: str
        self.originator = originator  # type: str
        self.release_initiator = release_initiator  # type: str
        self.release_reason = release_reason  # type: str
        self.skill_group_id = skill_group_id  # type: str
        self.timestamp = timestamp  # type: long
        self.user_extension = user_extension  # type: str
        self.user_id = user_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(MonitorCallResponseBodyDataCallContextChannelContexts, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.associated_data is not None:
            result['AssociatedData'] = self.associated_data
        if self.call_type is not None:
            result['CallType'] = self.call_type
        if self.channel_flags is not None:
            result['ChannelFlags'] = self.channel_flags
        if self.channel_id is not None:
            result['ChannelId'] = self.channel_id
        if self.channel_state is not None:
            result['ChannelState'] = self.channel_state
        if self.destination is not None:
            result['Destination'] = self.destination
        if self.index is not None:
            result['Index'] = self.index
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.originator is not None:
            result['Originator'] = self.originator
        if self.release_initiator is not None:
            result['ReleaseInitiator'] = self.release_initiator
        if self.release_reason is not None:
            result['ReleaseReason'] = self.release_reason
        if self.skill_group_id is not None:
            result['SkillGroupId'] = self.skill_group_id
        if self.timestamp is not None:
            result['Timestamp'] = self.timestamp
        if self.user_extension is not None:
            result['UserExtension'] = self.user_extension
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AssociatedData') is not None:
            self.associated_data = m.get('AssociatedData')
        if m.get('CallType') is not None:
            self.call_type = m.get('CallType')
        if m.get('ChannelFlags') is not None:
            self.channel_flags = m.get('ChannelFlags')
        if m.get('ChannelId') is not None:
            self.channel_id = m.get('ChannelId')
        if m.get('ChannelState') is not None:
            self.channel_state = m.get('ChannelState')
        if m.get('Destination') is not None:
            self.destination = m.get('Destination')
        if m.get('Index') is not None:
            self.index = m.get('Index')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('Originator') is not None:
            self.originator = m.get('Originator')
        if m.get('ReleaseInitiator') is not None:
            self.release_initiator = m.get('ReleaseInitiator')
        if m.get('ReleaseReason') is not None:
            self.release_reason = m.get('ReleaseReason')
        if m.get('SkillGroupId') is not None:
            self.skill_group_id = m.get('SkillGroupId')
        if m.get('Timestamp') is not None:
            self.timestamp = m.get('Timestamp')
        if m.get('UserExtension') is not None:
            self.user_extension = m.get('UserExtension')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class MonitorCallResponseBodyDataCallContext(TeaModel):
    def __init__(self, call_type=None, channel_contexts=None, instance_id=None, job_id=None):
        self.call_type = call_type  # type: str
        self.channel_contexts = channel_contexts  # type: list[MonitorCallResponseBodyDataCallContextChannelContexts]
        self.instance_id = instance_id  # type: str
        self.job_id = job_id  # type: str

    def validate(self):
        if self.channel_contexts:
            for k in self.channel_contexts:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(MonitorCallResponseBodyDataCallContext, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.call_type is not None:
            result['CallType'] = self.call_type
        result['ChannelContexts'] = []
        if self.channel_contexts is not None:
            for k in self.channel_contexts:
                result['ChannelContexts'].append(k.to_map() if k else None)
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CallType') is not None:
            self.call_type = m.get('CallType')
        self.channel_contexts = []
        if m.get('ChannelContexts') is not None:
            for k in m.get('ChannelContexts'):
                temp_model = MonitorCallResponseBodyDataCallContextChannelContexts()
                self.channel_contexts.append(temp_model.from_map(k))
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class MonitorCallResponseBodyDataUserContext(TeaModel):
    def __init__(self, break_code=None, device_id=None, extension=None, heartbeat=None, instance_id=None,
                 job_id=None, mobile=None, outbound_scenario=None, reserved=None, signed_skill_group_id_list=None,
                 user_id=None, user_state=None, work_mode=None):
        self.break_code = break_code  # type: str
        self.device_id = device_id  # type: str
        self.extension = extension  # type: str
        self.heartbeat = heartbeat  # type: long
        self.instance_id = instance_id  # type: str
        self.job_id = job_id  # type: str
        self.mobile = mobile  # type: str
        self.outbound_scenario = outbound_scenario  # type: bool
        self.reserved = reserved  # type: long
        self.signed_skill_group_id_list = signed_skill_group_id_list  # type: list[str]
        self.user_id = user_id  # type: str
        self.user_state = user_state  # type: str
        self.work_mode = work_mode  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(MonitorCallResponseBodyDataUserContext, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.break_code is not None:
            result['BreakCode'] = self.break_code
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.extension is not None:
            result['Extension'] = self.extension
        if self.heartbeat is not None:
            result['Heartbeat'] = self.heartbeat
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.mobile is not None:
            result['Mobile'] = self.mobile
        if self.outbound_scenario is not None:
            result['OutboundScenario'] = self.outbound_scenario
        if self.reserved is not None:
            result['Reserved'] = self.reserved
        if self.signed_skill_group_id_list is not None:
            result['SignedSkillGroupIdList'] = self.signed_skill_group_id_list
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.user_state is not None:
            result['UserState'] = self.user_state
        if self.work_mode is not None:
            result['WorkMode'] = self.work_mode
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BreakCode') is not None:
            self.break_code = m.get('BreakCode')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('Extension') is not None:
            self.extension = m.get('Extension')
        if m.get('Heartbeat') is not None:
            self.heartbeat = m.get('Heartbeat')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('Mobile') is not None:
            self.mobile = m.get('Mobile')
        if m.get('OutboundScenario') is not None:
            self.outbound_scenario = m.get('OutboundScenario')
        if m.get('Reserved') is not None:
            self.reserved = m.get('Reserved')
        if m.get('SignedSkillGroupIdList') is not None:
            self.signed_skill_group_id_list = m.get('SignedSkillGroupIdList')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('UserState') is not None:
            self.user_state = m.get('UserState')
        if m.get('WorkMode') is not None:
            self.work_mode = m.get('WorkMode')
        return self


class MonitorCallResponseBodyData(TeaModel):
    def __init__(self, call_context=None, user_context=None):
        self.call_context = call_context  # type: MonitorCallResponseBodyDataCallContext
        self.user_context = user_context  # type: MonitorCallResponseBodyDataUserContext

    def validate(self):
        if self.call_context:
            self.call_context.validate()
        if self.user_context:
            self.user_context.validate()

    def to_map(self):
        _map = super(MonitorCallResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.call_context is not None:
            result['CallContext'] = self.call_context.to_map()
        if self.user_context is not None:
            result['UserContext'] = self.user_context.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CallContext') is not None:
            temp_model = MonitorCallResponseBodyDataCallContext()
            self.call_context = temp_model.from_map(m['CallContext'])
        if m.get('UserContext') is not None:
            temp_model = MonitorCallResponseBodyDataUserContext()
            self.user_context = temp_model.from_map(m['UserContext'])
        return self


class MonitorCallResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, params=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: MonitorCallResponseBodyData
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.params = params  # type: list[str]
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(MonitorCallResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.params is not None:
            result['Params'] = self.params
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = MonitorCallResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Params') is not None:
            self.params = m.get('Params')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class MonitorCallResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: MonitorCallResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(MonitorCallResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = MonitorCallResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class MuteCallRequest(TeaModel):
    def __init__(self, channel_id=None, device_id=None, instance_id=None, job_id=None, user_id=None):
        self.channel_id = channel_id  # type: str
        self.device_id = device_id  # type: str
        self.instance_id = instance_id  # type: str
        self.job_id = job_id  # type: str
        self.user_id = user_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(MuteCallRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.channel_id is not None:
            result['ChannelId'] = self.channel_id
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ChannelId') is not None:
            self.channel_id = m.get('ChannelId')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class MuteCallResponseBodyDataCallContextChannelContexts(TeaModel):
    def __init__(self, associated_data=None, call_type=None, channel_flags=None, channel_id=None,
                 channel_state=None, destination=None, index=None, job_id=None, originator=None, release_initiator=None,
                 release_reason=None, timestamp=None, user_extension=None, user_id=None):
        self.associated_data = associated_data  # type: dict[str, any]
        self.call_type = call_type  # type: str
        self.channel_flags = channel_flags  # type: str
        self.channel_id = channel_id  # type: str
        self.channel_state = channel_state  # type: str
        self.destination = destination  # type: str
        self.index = index  # type: int
        self.job_id = job_id  # type: str
        self.originator = originator  # type: str
        self.release_initiator = release_initiator  # type: str
        self.release_reason = release_reason  # type: str
        self.timestamp = timestamp  # type: long
        self.user_extension = user_extension  # type: str
        self.user_id = user_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(MuteCallResponseBodyDataCallContextChannelContexts, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.associated_data is not None:
            result['AssociatedData'] = self.associated_data
        if self.call_type is not None:
            result['CallType'] = self.call_type
        if self.channel_flags is not None:
            result['ChannelFlags'] = self.channel_flags
        if self.channel_id is not None:
            result['ChannelId'] = self.channel_id
        if self.channel_state is not None:
            result['ChannelState'] = self.channel_state
        if self.destination is not None:
            result['Destination'] = self.destination
        if self.index is not None:
            result['Index'] = self.index
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.originator is not None:
            result['Originator'] = self.originator
        if self.release_initiator is not None:
            result['ReleaseInitiator'] = self.release_initiator
        if self.release_reason is not None:
            result['ReleaseReason'] = self.release_reason
        if self.timestamp is not None:
            result['Timestamp'] = self.timestamp
        if self.user_extension is not None:
            result['UserExtension'] = self.user_extension
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AssociatedData') is not None:
            self.associated_data = m.get('AssociatedData')
        if m.get('CallType') is not None:
            self.call_type = m.get('CallType')
        if m.get('ChannelFlags') is not None:
            self.channel_flags = m.get('ChannelFlags')
        if m.get('ChannelId') is not None:
            self.channel_id = m.get('ChannelId')
        if m.get('ChannelState') is not None:
            self.channel_state = m.get('ChannelState')
        if m.get('Destination') is not None:
            self.destination = m.get('Destination')
        if m.get('Index') is not None:
            self.index = m.get('Index')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('Originator') is not None:
            self.originator = m.get('Originator')
        if m.get('ReleaseInitiator') is not None:
            self.release_initiator = m.get('ReleaseInitiator')
        if m.get('ReleaseReason') is not None:
            self.release_reason = m.get('ReleaseReason')
        if m.get('Timestamp') is not None:
            self.timestamp = m.get('Timestamp')
        if m.get('UserExtension') is not None:
            self.user_extension = m.get('UserExtension')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class MuteCallResponseBodyDataCallContext(TeaModel):
    def __init__(self, call_type=None, channel_contexts=None, instance_id=None, job_id=None):
        self.call_type = call_type  # type: str
        self.channel_contexts = channel_contexts  # type: list[MuteCallResponseBodyDataCallContextChannelContexts]
        self.instance_id = instance_id  # type: str
        self.job_id = job_id  # type: str

    def validate(self):
        if self.channel_contexts:
            for k in self.channel_contexts:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(MuteCallResponseBodyDataCallContext, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.call_type is not None:
            result['CallType'] = self.call_type
        result['ChannelContexts'] = []
        if self.channel_contexts is not None:
            for k in self.channel_contexts:
                result['ChannelContexts'].append(k.to_map() if k else None)
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CallType') is not None:
            self.call_type = m.get('CallType')
        self.channel_contexts = []
        if m.get('ChannelContexts') is not None:
            for k in m.get('ChannelContexts'):
                temp_model = MuteCallResponseBodyDataCallContextChannelContexts()
                self.channel_contexts.append(temp_model.from_map(k))
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class MuteCallResponseBodyDataUserContext(TeaModel):
    def __init__(self, break_code=None, device_id=None, extension=None, heartbeat=None, instance_id=None,
                 job_id=None, mobile=None, outbound_scenario=None, reserved=None, signed_skill_group_id_list=None,
                 user_id=None, user_state=None, work_mode=None):
        self.break_code = break_code  # type: str
        self.device_id = device_id  # type: str
        self.extension = extension  # type: str
        self.heartbeat = heartbeat  # type: long
        self.instance_id = instance_id  # type: str
        self.job_id = job_id  # type: str
        self.mobile = mobile  # type: str
        self.outbound_scenario = outbound_scenario  # type: bool
        self.reserved = reserved  # type: long
        self.signed_skill_group_id_list = signed_skill_group_id_list  # type: list[str]
        self.user_id = user_id  # type: str
        self.user_state = user_state  # type: str
        self.work_mode = work_mode  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(MuteCallResponseBodyDataUserContext, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.break_code is not None:
            result['BreakCode'] = self.break_code
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.extension is not None:
            result['Extension'] = self.extension
        if self.heartbeat is not None:
            result['Heartbeat'] = self.heartbeat
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.mobile is not None:
            result['Mobile'] = self.mobile
        if self.outbound_scenario is not None:
            result['OutboundScenario'] = self.outbound_scenario
        if self.reserved is not None:
            result['Reserved'] = self.reserved
        if self.signed_skill_group_id_list is not None:
            result['SignedSkillGroupIdList'] = self.signed_skill_group_id_list
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.user_state is not None:
            result['UserState'] = self.user_state
        if self.work_mode is not None:
            result['WorkMode'] = self.work_mode
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BreakCode') is not None:
            self.break_code = m.get('BreakCode')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('Extension') is not None:
            self.extension = m.get('Extension')
        if m.get('Heartbeat') is not None:
            self.heartbeat = m.get('Heartbeat')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('Mobile') is not None:
            self.mobile = m.get('Mobile')
        if m.get('OutboundScenario') is not None:
            self.outbound_scenario = m.get('OutboundScenario')
        if m.get('Reserved') is not None:
            self.reserved = m.get('Reserved')
        if m.get('SignedSkillGroupIdList') is not None:
            self.signed_skill_group_id_list = m.get('SignedSkillGroupIdList')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('UserState') is not None:
            self.user_state = m.get('UserState')
        if m.get('WorkMode') is not None:
            self.work_mode = m.get('WorkMode')
        return self


class MuteCallResponseBodyData(TeaModel):
    def __init__(self, call_context=None, user_context=None):
        self.call_context = call_context  # type: MuteCallResponseBodyDataCallContext
        self.user_context = user_context  # type: MuteCallResponseBodyDataUserContext

    def validate(self):
        if self.call_context:
            self.call_context.validate()
        if self.user_context:
            self.user_context.validate()

    def to_map(self):
        _map = super(MuteCallResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.call_context is not None:
            result['CallContext'] = self.call_context.to_map()
        if self.user_context is not None:
            result['UserContext'] = self.user_context.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CallContext') is not None:
            temp_model = MuteCallResponseBodyDataCallContext()
            self.call_context = temp_model.from_map(m['CallContext'])
        if m.get('UserContext') is not None:
            temp_model = MuteCallResponseBodyDataUserContext()
            self.user_context = temp_model.from_map(m['UserContext'])
        return self


class MuteCallResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, params=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: MuteCallResponseBodyData
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.params = params  # type: list[str]
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(MuteCallResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.params is not None:
            result['Params'] = self.params
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = MuteCallResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Params') is not None:
            self.params = m.get('Params')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class MuteCallResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: MuteCallResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(MuteCallResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = MuteCallResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class PauseCampaignRequest(TeaModel):
    def __init__(self, campaign_id=None, instance_id=None):
        self.campaign_id = campaign_id  # type: str
        self.instance_id = instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(PauseCampaignRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.campaign_id is not None:
            result['CampaignId'] = self.campaign_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CampaignId') is not None:
            self.campaign_id = m.get('CampaignId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class PauseCampaignResponseBody(TeaModel):
    def __init__(self, code=None, http_status_code=None, message=None, request_id=None):
        # code
        self.code = code  # type: str
        # httpStatusCode
        self.http_status_code = http_status_code  # type: str
        # message
        self.message = message  # type: str
        # Id of the request
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(PauseCampaignResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class PauseCampaignResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: PauseCampaignResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(PauseCampaignResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = PauseCampaignResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class PickOutboundNumbersRequest(TeaModel):
    def __init__(self, called_number=None, count=None, instance_id=None, skill_group_id_list=None):
        self.called_number = called_number  # type: str
        self.count = count  # type: int
        self.instance_id = instance_id  # type: str
        self.skill_group_id_list = skill_group_id_list  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(PickOutboundNumbersRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.called_number is not None:
            result['CalledNumber'] = self.called_number
        if self.count is not None:
            result['Count'] = self.count
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.skill_group_id_list is not None:
            result['SkillGroupIdList'] = self.skill_group_id_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CalledNumber') is not None:
            self.called_number = m.get('CalledNumber')
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('SkillGroupIdList') is not None:
            self.skill_group_id_list = m.get('SkillGroupIdList')
        return self


class PickOutboundNumbersResponseBodyDataCallee(TeaModel):
    def __init__(self, city=None, number=None, province=None):
        self.city = city  # type: str
        self.number = number  # type: str
        self.province = province  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(PickOutboundNumbersResponseBodyDataCallee, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.city is not None:
            result['City'] = self.city
        if self.number is not None:
            result['Number'] = self.number
        if self.province is not None:
            result['Province'] = self.province
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('City') is not None:
            self.city = m.get('City')
        if m.get('Number') is not None:
            self.number = m.get('Number')
        if m.get('Province') is not None:
            self.province = m.get('Province')
        return self


class PickOutboundNumbersResponseBodyDataCaller(TeaModel):
    def __init__(self, city=None, number=None, province=None):
        self.city = city  # type: str
        self.number = number  # type: str
        self.province = province  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(PickOutboundNumbersResponseBodyDataCaller, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.city is not None:
            result['City'] = self.city
        if self.number is not None:
            result['Number'] = self.number
        if self.province is not None:
            result['Province'] = self.province
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('City') is not None:
            self.city = m.get('City')
        if m.get('Number') is not None:
            self.number = m.get('Number')
        if m.get('Province') is not None:
            self.province = m.get('Province')
        return self


class PickOutboundNumbersResponseBodyData(TeaModel):
    def __init__(self, callee=None, caller=None):
        self.callee = callee  # type: PickOutboundNumbersResponseBodyDataCallee
        self.caller = caller  # type: PickOutboundNumbersResponseBodyDataCaller

    def validate(self):
        if self.callee:
            self.callee.validate()
        if self.caller:
            self.caller.validate()

    def to_map(self):
        _map = super(PickOutboundNumbersResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.callee is not None:
            result['Callee'] = self.callee.to_map()
        if self.caller is not None:
            result['Caller'] = self.caller.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Callee') is not None:
            temp_model = PickOutboundNumbersResponseBodyDataCallee()
            self.callee = temp_model.from_map(m['Callee'])
        if m.get('Caller') is not None:
            temp_model = PickOutboundNumbersResponseBodyDataCaller()
            self.caller = temp_model.from_map(m['Caller'])
        return self


class PickOutboundNumbersResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: list[PickOutboundNumbersResponseBodyData]
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(PickOutboundNumbersResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = PickOutboundNumbersResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class PickOutboundNumbersResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: PickOutboundNumbersResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(PickOutboundNumbersResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = PickOutboundNumbersResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class PollUserStatusRequest(TeaModel):
    def __init__(self, device_id=None, instance_id=None, user_id=None):
        self.device_id = device_id  # type: str
        self.instance_id = instance_id  # type: str
        self.user_id = user_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(PollUserStatusRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class PollUserStatusResponseBodyDataCallContextChannelContexts(TeaModel):
    def __init__(self, associated_data=None, call_type=None, channel_flags=None, channel_id=None,
                 channel_state=None, channel_variables=None, destination=None, index=None, job_id=None, originator=None,
                 release_initiator=None, release_reason=None, skill_group_id=None, timestamp=None, user_extension=None, user_id=None):
        self.associated_data = associated_data  # type: dict[str, any]
        self.call_type = call_type  # type: str
        self.channel_flags = channel_flags  # type: str
        self.channel_id = channel_id  # type: str
        self.channel_state = channel_state  # type: str
        self.channel_variables = channel_variables  # type: str
        self.destination = destination  # type: str
        self.index = index  # type: int
        self.job_id = job_id  # type: str
        self.originator = originator  # type: str
        self.release_initiator = release_initiator  # type: str
        self.release_reason = release_reason  # type: str
        self.skill_group_id = skill_group_id  # type: str
        self.timestamp = timestamp  # type: long
        self.user_extension = user_extension  # type: str
        self.user_id = user_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(PollUserStatusResponseBodyDataCallContextChannelContexts, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.associated_data is not None:
            result['AssociatedData'] = self.associated_data
        if self.call_type is not None:
            result['CallType'] = self.call_type
        if self.channel_flags is not None:
            result['ChannelFlags'] = self.channel_flags
        if self.channel_id is not None:
            result['ChannelId'] = self.channel_id
        if self.channel_state is not None:
            result['ChannelState'] = self.channel_state
        if self.channel_variables is not None:
            result['ChannelVariables'] = self.channel_variables
        if self.destination is not None:
            result['Destination'] = self.destination
        if self.index is not None:
            result['Index'] = self.index
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.originator is not None:
            result['Originator'] = self.originator
        if self.release_initiator is not None:
            result['ReleaseInitiator'] = self.release_initiator
        if self.release_reason is not None:
            result['ReleaseReason'] = self.release_reason
        if self.skill_group_id is not None:
            result['SkillGroupId'] = self.skill_group_id
        if self.timestamp is not None:
            result['Timestamp'] = self.timestamp
        if self.user_extension is not None:
            result['UserExtension'] = self.user_extension
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AssociatedData') is not None:
            self.associated_data = m.get('AssociatedData')
        if m.get('CallType') is not None:
            self.call_type = m.get('CallType')
        if m.get('ChannelFlags') is not None:
            self.channel_flags = m.get('ChannelFlags')
        if m.get('ChannelId') is not None:
            self.channel_id = m.get('ChannelId')
        if m.get('ChannelState') is not None:
            self.channel_state = m.get('ChannelState')
        if m.get('ChannelVariables') is not None:
            self.channel_variables = m.get('ChannelVariables')
        if m.get('Destination') is not None:
            self.destination = m.get('Destination')
        if m.get('Index') is not None:
            self.index = m.get('Index')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('Originator') is not None:
            self.originator = m.get('Originator')
        if m.get('ReleaseInitiator') is not None:
            self.release_initiator = m.get('ReleaseInitiator')
        if m.get('ReleaseReason') is not None:
            self.release_reason = m.get('ReleaseReason')
        if m.get('SkillGroupId') is not None:
            self.skill_group_id = m.get('SkillGroupId')
        if m.get('Timestamp') is not None:
            self.timestamp = m.get('Timestamp')
        if m.get('UserExtension') is not None:
            self.user_extension = m.get('UserExtension')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class PollUserStatusResponseBodyDataCallContext(TeaModel):
    def __init__(self, call_type=None, channel_contexts=None, instance_id=None, job_id=None):
        self.call_type = call_type  # type: str
        self.channel_contexts = channel_contexts  # type: list[PollUserStatusResponseBodyDataCallContextChannelContexts]
        self.instance_id = instance_id  # type: str
        self.job_id = job_id  # type: str

    def validate(self):
        if self.channel_contexts:
            for k in self.channel_contexts:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(PollUserStatusResponseBodyDataCallContext, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.call_type is not None:
            result['CallType'] = self.call_type
        result['ChannelContexts'] = []
        if self.channel_contexts is not None:
            for k in self.channel_contexts:
                result['ChannelContexts'].append(k.to_map() if k else None)
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CallType') is not None:
            self.call_type = m.get('CallType')
        self.channel_contexts = []
        if m.get('ChannelContexts') is not None:
            for k in m.get('ChannelContexts'):
                temp_model = PollUserStatusResponseBodyDataCallContextChannelContexts()
                self.channel_contexts.append(temp_model.from_map(k))
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class PollUserStatusResponseBodyDataUserContext(TeaModel):
    def __init__(self, break_code=None, device_id=None, extension=None, heartbeat=None, instance_id=None,
                 job_id=None, mobile=None, outbound_scenario=None, reserved=None, signed_skill_group_id_list=None,
                 user_id=None, user_state=None, work_mode=None):
        self.break_code = break_code  # type: str
        self.device_id = device_id  # type: str
        self.extension = extension  # type: str
        self.heartbeat = heartbeat  # type: long
        self.instance_id = instance_id  # type: str
        self.job_id = job_id  # type: str
        self.mobile = mobile  # type: str
        self.outbound_scenario = outbound_scenario  # type: bool
        self.reserved = reserved  # type: long
        self.signed_skill_group_id_list = signed_skill_group_id_list  # type: list[str]
        self.user_id = user_id  # type: str
        self.user_state = user_state  # type: str
        self.work_mode = work_mode  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(PollUserStatusResponseBodyDataUserContext, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.break_code is not None:
            result['BreakCode'] = self.break_code
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.extension is not None:
            result['Extension'] = self.extension
        if self.heartbeat is not None:
            result['Heartbeat'] = self.heartbeat
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.mobile is not None:
            result['Mobile'] = self.mobile
        if self.outbound_scenario is not None:
            result['OutboundScenario'] = self.outbound_scenario
        if self.reserved is not None:
            result['Reserved'] = self.reserved
        if self.signed_skill_group_id_list is not None:
            result['SignedSkillGroupIdList'] = self.signed_skill_group_id_list
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.user_state is not None:
            result['UserState'] = self.user_state
        if self.work_mode is not None:
            result['WorkMode'] = self.work_mode
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BreakCode') is not None:
            self.break_code = m.get('BreakCode')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('Extension') is not None:
            self.extension = m.get('Extension')
        if m.get('Heartbeat') is not None:
            self.heartbeat = m.get('Heartbeat')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('Mobile') is not None:
            self.mobile = m.get('Mobile')
        if m.get('OutboundScenario') is not None:
            self.outbound_scenario = m.get('OutboundScenario')
        if m.get('Reserved') is not None:
            self.reserved = m.get('Reserved')
        if m.get('SignedSkillGroupIdList') is not None:
            self.signed_skill_group_id_list = m.get('SignedSkillGroupIdList')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('UserState') is not None:
            self.user_state = m.get('UserState')
        if m.get('WorkMode') is not None:
            self.work_mode = m.get('WorkMode')
        return self


class PollUserStatusResponseBodyData(TeaModel):
    def __init__(self, call_context=None, context_id=None, user_context=None):
        self.call_context = call_context  # type: PollUserStatusResponseBodyDataCallContext
        self.context_id = context_id  # type: long
        self.user_context = user_context  # type: PollUserStatusResponseBodyDataUserContext

    def validate(self):
        if self.call_context:
            self.call_context.validate()
        if self.user_context:
            self.user_context.validate()

    def to_map(self):
        _map = super(PollUserStatusResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.call_context is not None:
            result['CallContext'] = self.call_context.to_map()
        if self.context_id is not None:
            result['ContextId'] = self.context_id
        if self.user_context is not None:
            result['UserContext'] = self.user_context.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CallContext') is not None:
            temp_model = PollUserStatusResponseBodyDataCallContext()
            self.call_context = temp_model.from_map(m['CallContext'])
        if m.get('ContextId') is not None:
            self.context_id = m.get('ContextId')
        if m.get('UserContext') is not None:
            temp_model = PollUserStatusResponseBodyDataUserContext()
            self.user_context = temp_model.from_map(m['UserContext'])
        return self


class PollUserStatusResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, params=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: PollUserStatusResponseBodyData
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.params = params  # type: list[str]
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(PollUserStatusResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.params is not None:
            result['Params'] = self.params
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = PollUserStatusResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Params') is not None:
            self.params = m.get('Params')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class PollUserStatusResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: PollUserStatusResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(PollUserStatusResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = PollUserStatusResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ReadyForServiceRequest(TeaModel):
    def __init__(self, device_id=None, instance_id=None, outbound_scenario=None, user_id=None):
        self.device_id = device_id  # type: str
        self.instance_id = instance_id  # type: str
        self.outbound_scenario = outbound_scenario  # type: bool
        self.user_id = user_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ReadyForServiceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.outbound_scenario is not None:
            result['OutboundScenario'] = self.outbound_scenario
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('OutboundScenario') is not None:
            self.outbound_scenario = m.get('OutboundScenario')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class ReadyForServiceResponseBodyData(TeaModel):
    def __init__(self, break_code=None, device_id=None, extension=None, instance_id=None, job_id=None,
                 outbound_scenario=None, signed_skill_group_id_list=None, user_id=None, user_state=None, work_mode=None):
        self.break_code = break_code  # type: str
        self.device_id = device_id  # type: str
        self.extension = extension  # type: str
        self.instance_id = instance_id  # type: str
        self.job_id = job_id  # type: str
        self.outbound_scenario = outbound_scenario  # type: bool
        self.signed_skill_group_id_list = signed_skill_group_id_list  # type: list[str]
        self.user_id = user_id  # type: str
        self.user_state = user_state  # type: str
        self.work_mode = work_mode  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ReadyForServiceResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.break_code is not None:
            result['BreakCode'] = self.break_code
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.extension is not None:
            result['Extension'] = self.extension
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.outbound_scenario is not None:
            result['OutboundScenario'] = self.outbound_scenario
        if self.signed_skill_group_id_list is not None:
            result['SignedSkillGroupIdList'] = self.signed_skill_group_id_list
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.user_state is not None:
            result['UserState'] = self.user_state
        if self.work_mode is not None:
            result['WorkMode'] = self.work_mode
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BreakCode') is not None:
            self.break_code = m.get('BreakCode')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('Extension') is not None:
            self.extension = m.get('Extension')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('OutboundScenario') is not None:
            self.outbound_scenario = m.get('OutboundScenario')
        if m.get('SignedSkillGroupIdList') is not None:
            self.signed_skill_group_id_list = m.get('SignedSkillGroupIdList')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('UserState') is not None:
            self.user_state = m.get('UserState')
        if m.get('WorkMode') is not None:
            self.work_mode = m.get('WorkMode')
        return self


class ReadyForServiceResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, params=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: ReadyForServiceResponseBodyData
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.params = params  # type: list[str]
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(ReadyForServiceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.params is not None:
            result['Params'] = self.params
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = ReadyForServiceResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Params') is not None:
            self.params = m.get('Params')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ReadyForServiceResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ReadyForServiceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ReadyForServiceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ReadyForServiceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class RegisterDeviceRequest(TeaModel):
    def __init__(self, device_id=None, instance_id=None, password=None, user_id=None):
        self.device_id = device_id  # type: str
        self.instance_id = instance_id  # type: str
        self.password = password  # type: str
        self.user_id = user_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(RegisterDeviceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.password is not None:
            result['Password'] = self.password
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Password') is not None:
            self.password = m.get('Password')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class RegisterDeviceResponseBody(TeaModel):
    def __init__(self, code=None, http_status_code=None, message=None, params=None, request_id=None):
        self.code = code  # type: str
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.params = params  # type: list[str]
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(RegisterDeviceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.params is not None:
            result['Params'] = self.params
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Params') is not None:
            self.params = m.get('Params')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class RegisterDeviceResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: RegisterDeviceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(RegisterDeviceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = RegisterDeviceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class RegisterDevicesRequest(TeaModel):
    def __init__(self, device_id=None, instance_id=None, password=None, user_id_list_json=None):
        self.device_id = device_id  # type: str
        self.instance_id = instance_id  # type: str
        self.password = password  # type: str
        self.user_id_list_json = user_id_list_json  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(RegisterDevicesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.password is not None:
            result['Password'] = self.password
        if self.user_id_list_json is not None:
            result['UserIdListJson'] = self.user_id_list_json
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Password') is not None:
            self.password = m.get('Password')
        if m.get('UserIdListJson') is not None:
            self.user_id_list_json = m.get('UserIdListJson')
        return self


class RegisterDevicesResponseBody(TeaModel):
    def __init__(self, code=None, http_status_code=None, message=None, params=None, request_id=None):
        self.code = code  # type: str
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.params = params  # type: list[str]
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(RegisterDevicesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.params is not None:
            result['Params'] = self.params
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Params') is not None:
            self.params = m.get('Params')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class RegisterDevicesResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: RegisterDevicesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(RegisterDevicesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = RegisterDevicesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ReleaseCallRequest(TeaModel):
    def __init__(self, channel_id=None, device_id=None, instance_id=None, job_id=None, user_id=None):
        self.channel_id = channel_id  # type: str
        self.device_id = device_id  # type: str
        self.instance_id = instance_id  # type: str
        self.job_id = job_id  # type: str
        self.user_id = user_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ReleaseCallRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.channel_id is not None:
            result['ChannelId'] = self.channel_id
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ChannelId') is not None:
            self.channel_id = m.get('ChannelId')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class ReleaseCallResponseBodyDataCallContextChannelContexts(TeaModel):
    def __init__(self, associated_data=None, call_type=None, channel_id=None, channel_state=None, destination=None,
                 job_id=None, originator=None, release_initiator=None, release_reason=None, timestamp=None,
                 user_extension=None, user_id=None):
        self.associated_data = associated_data  # type: dict[str, any]
        self.call_type = call_type  # type: str
        self.channel_id = channel_id  # type: str
        self.channel_state = channel_state  # type: str
        self.destination = destination  # type: str
        self.job_id = job_id  # type: str
        self.originator = originator  # type: str
        self.release_initiator = release_initiator  # type: str
        self.release_reason = release_reason  # type: str
        self.timestamp = timestamp  # type: long
        self.user_extension = user_extension  # type: str
        self.user_id = user_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ReleaseCallResponseBodyDataCallContextChannelContexts, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.associated_data is not None:
            result['AssociatedData'] = self.associated_data
        if self.call_type is not None:
            result['CallType'] = self.call_type
        if self.channel_id is not None:
            result['ChannelId'] = self.channel_id
        if self.channel_state is not None:
            result['ChannelState'] = self.channel_state
        if self.destination is not None:
            result['Destination'] = self.destination
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.originator is not None:
            result['Originator'] = self.originator
        if self.release_initiator is not None:
            result['ReleaseInitiator'] = self.release_initiator
        if self.release_reason is not None:
            result['ReleaseReason'] = self.release_reason
        if self.timestamp is not None:
            result['Timestamp'] = self.timestamp
        if self.user_extension is not None:
            result['UserExtension'] = self.user_extension
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AssociatedData') is not None:
            self.associated_data = m.get('AssociatedData')
        if m.get('CallType') is not None:
            self.call_type = m.get('CallType')
        if m.get('ChannelId') is not None:
            self.channel_id = m.get('ChannelId')
        if m.get('ChannelState') is not None:
            self.channel_state = m.get('ChannelState')
        if m.get('Destination') is not None:
            self.destination = m.get('Destination')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('Originator') is not None:
            self.originator = m.get('Originator')
        if m.get('ReleaseInitiator') is not None:
            self.release_initiator = m.get('ReleaseInitiator')
        if m.get('ReleaseReason') is not None:
            self.release_reason = m.get('ReleaseReason')
        if m.get('Timestamp') is not None:
            self.timestamp = m.get('Timestamp')
        if m.get('UserExtension') is not None:
            self.user_extension = m.get('UserExtension')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class ReleaseCallResponseBodyDataCallContext(TeaModel):
    def __init__(self, channel_contexts=None, instance_id=None, job_id=None):
        self.channel_contexts = channel_contexts  # type: list[ReleaseCallResponseBodyDataCallContextChannelContexts]
        self.instance_id = instance_id  # type: str
        self.job_id = job_id  # type: str

    def validate(self):
        if self.channel_contexts:
            for k in self.channel_contexts:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ReleaseCallResponseBodyDataCallContext, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ChannelContexts'] = []
        if self.channel_contexts is not None:
            for k in self.channel_contexts:
                result['ChannelContexts'].append(k.to_map() if k else None)
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.channel_contexts = []
        if m.get('ChannelContexts') is not None:
            for k in m.get('ChannelContexts'):
                temp_model = ReleaseCallResponseBodyDataCallContextChannelContexts()
                self.channel_contexts.append(temp_model.from_map(k))
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class ReleaseCallResponseBodyDataUserContext(TeaModel):
    def __init__(self, break_code=None, device_id=None, extension=None, instance_id=None, job_id=None,
                 outbound_scenario=None, signed_skill_group_id_list=None, user_id=None, user_state=None, work_mode=None):
        self.break_code = break_code  # type: str
        self.device_id = device_id  # type: str
        self.extension = extension  # type: str
        self.instance_id = instance_id  # type: str
        self.job_id = job_id  # type: str
        self.outbound_scenario = outbound_scenario  # type: bool
        self.signed_skill_group_id_list = signed_skill_group_id_list  # type: list[str]
        self.user_id = user_id  # type: str
        self.user_state = user_state  # type: str
        self.work_mode = work_mode  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ReleaseCallResponseBodyDataUserContext, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.break_code is not None:
            result['BreakCode'] = self.break_code
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.extension is not None:
            result['Extension'] = self.extension
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.outbound_scenario is not None:
            result['OutboundScenario'] = self.outbound_scenario
        if self.signed_skill_group_id_list is not None:
            result['SignedSkillGroupIdList'] = self.signed_skill_group_id_list
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.user_state is not None:
            result['UserState'] = self.user_state
        if self.work_mode is not None:
            result['WorkMode'] = self.work_mode
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BreakCode') is not None:
            self.break_code = m.get('BreakCode')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('Extension') is not None:
            self.extension = m.get('Extension')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('OutboundScenario') is not None:
            self.outbound_scenario = m.get('OutboundScenario')
        if m.get('SignedSkillGroupIdList') is not None:
            self.signed_skill_group_id_list = m.get('SignedSkillGroupIdList')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('UserState') is not None:
            self.user_state = m.get('UserState')
        if m.get('WorkMode') is not None:
            self.work_mode = m.get('WorkMode')
        return self


class ReleaseCallResponseBodyData(TeaModel):
    def __init__(self, call_context=None, context_id=None, user_context=None):
        self.call_context = call_context  # type: ReleaseCallResponseBodyDataCallContext
        self.context_id = context_id  # type: long
        self.user_context = user_context  # type: ReleaseCallResponseBodyDataUserContext

    def validate(self):
        if self.call_context:
            self.call_context.validate()
        if self.user_context:
            self.user_context.validate()

    def to_map(self):
        _map = super(ReleaseCallResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.call_context is not None:
            result['CallContext'] = self.call_context.to_map()
        if self.context_id is not None:
            result['ContextId'] = self.context_id
        if self.user_context is not None:
            result['UserContext'] = self.user_context.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CallContext') is not None:
            temp_model = ReleaseCallResponseBodyDataCallContext()
            self.call_context = temp_model.from_map(m['CallContext'])
        if m.get('ContextId') is not None:
            self.context_id = m.get('ContextId')
        if m.get('UserContext') is not None:
            temp_model = ReleaseCallResponseBodyDataUserContext()
            self.user_context = temp_model.from_map(m['UserContext'])
        return self


class ReleaseCallResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, params=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: ReleaseCallResponseBodyData
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.params = params  # type: list[str]
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(ReleaseCallResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.params is not None:
            result['Params'] = self.params
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = ReleaseCallResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Params') is not None:
            self.params = m.get('Params')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ReleaseCallResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ReleaseCallResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ReleaseCallResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ReleaseCallResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class RemovePersonalNumbersFromUserRequest(TeaModel):
    def __init__(self, instance_id=None, number_list=None, user_id=None):
        self.instance_id = instance_id  # type: str
        self.number_list = number_list  # type: str
        self.user_id = user_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(RemovePersonalNumbersFromUserRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.number_list is not None:
            result['NumberList'] = self.number_list
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('NumberList') is not None:
            self.number_list = m.get('NumberList')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class RemovePersonalNumbersFromUserResponseBody(TeaModel):
    def __init__(self, code=None, http_status_code=None, message=None, request_id=None):
        self.code = code  # type: str
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(RemovePersonalNumbersFromUserResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class RemovePersonalNumbersFromUserResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: RemovePersonalNumbersFromUserResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(RemovePersonalNumbersFromUserResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = RemovePersonalNumbersFromUserResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class RemovePhoneNumberFromSkillGroupsRequest(TeaModel):
    def __init__(self, instance_id=None, number=None, skill_group_id_list=None):
        self.instance_id = instance_id  # type: str
        self.number = number  # type: str
        self.skill_group_id_list = skill_group_id_list  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(RemovePhoneNumberFromSkillGroupsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.number is not None:
            result['Number'] = self.number
        if self.skill_group_id_list is not None:
            result['SkillGroupIdList'] = self.skill_group_id_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Number') is not None:
            self.number = m.get('Number')
        if m.get('SkillGroupIdList') is not None:
            self.skill_group_id_list = m.get('SkillGroupIdList')
        return self


class RemovePhoneNumberFromSkillGroupsResponseBody(TeaModel):
    def __init__(self, code=None, http_status_code=None, message=None, request_id=None):
        self.code = code  # type: str
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(RemovePhoneNumberFromSkillGroupsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class RemovePhoneNumberFromSkillGroupsResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: RemovePhoneNumberFromSkillGroupsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(RemovePhoneNumberFromSkillGroupsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = RemovePhoneNumberFromSkillGroupsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class RemovePhoneNumbersRequest(TeaModel):
    def __init__(self, instance_id=None, number_list=None):
        self.instance_id = instance_id  # type: str
        self.number_list = number_list  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(RemovePhoneNumbersRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.number_list is not None:
            result['NumberList'] = self.number_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('NumberList') is not None:
            self.number_list = m.get('NumberList')
        return self


class RemovePhoneNumbersResponseBody(TeaModel):
    def __init__(self, code=None, data=None, failure_list=None, http_status_code=None, message=None, params=None,
                 request_id=None):
        self.code = code  # type: str
        self.data = data  # type: str
       