from __future__ import annotations
import sgx_dcap_quote_verify._core
import typing
import datetime

__all__ = [
    "VerificationStatus",
    "verify"
]


class VerificationStatus():
    """
    Members:

      STATUS_OK

      STATUS_UNSUPPORTED_CERT_FORMAT

      STATUS_SGX_ROOT_CA_MISSING

      STATUS_SGX_ROOT_CA_INVALID

      STATUS_SGX_ROOT_CA_INVALID_EXTENSIONS

      STATUS_SGX_ROOT_CA_INVALID_ISSUER

      STATUS_SGX_ROOT_CA_UNTRUSTED

      STATUS_SGX_INTERMEDIATE_CA_MISSING

      STATUS_SGX_INTERMEDIATE_CA_INVALID

      STATUS_SGX_INTERMEDIATE_CA_INVALID_EXTENSIONS

      STATUS_SGX_INTERMEDIATE_CA_INVALID_ISSUER

      STATUS_SGX_INTERMEDIATE_CA_REVOKED

      STATUS_SGX_PCK_MISSING

      STATUS_SGX_PCK_INVALID

      STATUS_SGX_PCK_INVALID_EXTENSIONS

      STATUS_SGX_PCK_INVALID_ISSUER

      STATUS_SGX_PCK_REVOKED

      STATUS_TRUSTED_ROOT_CA_INVALID

      STATUS_SGX_PCK_CERT_CHAIN_UNTRUSTED

      STATUS_SGX_TCB_INFO_UNSUPPORTED_FORMAT

      STATUS_SGX_TCB_INFO_INVALID

      STATUS_TCB_INFO_INVALID_SIGNATURE

      STATUS_SGX_TCB_SIGNING_CERT_MISSING

      STATUS_SGX_TCB_SIGNING_CERT_INVALID

      STATUS_SGX_TCB_SIGNING_CERT_INVALID_EXTENSIONS

      STATUS_SGX_TCB_SIGNING_CERT_INVALID_ISSUER

      STATUS_SGX_TCB_SIGNING_CERT_CHAIN_UNTRUSTED

      STATUS_SGX_TCB_SIGNING_CERT_REVOKED

      STATUS_SGX_CRL_UNSUPPORTED_FORMAT

      STATUS_SGX_CRL_UNKNOWN_ISSUER

      STATUS_SGX_CRL_INVALID

      STATUS_SGX_CRL_INVALID_EXTENSIONS

      STATUS_SGX_CRL_INVALID_SIGNATURE

      STATUS_SGX_CA_CERT_UNSUPPORTED_FORMAT

      STATUS_SGX_CA_CERT_INVALID

      STATUS_TRUSTED_ROOT_CA_UNSUPPORTED_FORMAT

      STATUS_MISSING_PARAMETERS

      STATUS_UNSUPPORTED_QUOTE_FORMAT

      STATUS_UNSUPPORTED_PCK_CERT_FORMAT

      STATUS_INVALID_PCK_CERT

      STATUS_UNSUPPORTED_PCK_RL_FORMAT

      STATUS_INVALID_PCK_CRL

      STATUS_UNSUPPORTED_TCB_INFO_FORMAT

      STATUS_PCK_REVOKED

      STATUS_TCB_INFO_MISMATCH

      STATUS_TCB_OUT_OF_DATE

      STATUS_TCB_REVOKED

      STATUS_TCB_CONFIGURATION_NEEDED

      STATUS_TCB_OUT_OF_DATE_CONFIGURATION_NEEDED

      STATUS_TCB_NOT_SUPPORTED

      STATUS_TCB_UNRECOGNIZED_STATUS

      STATUS_UNSUPPORTED_QE_CERTIFICATION

      STATUS_INVALID_QE_CERTIFICATION_DATA_SIZE

      STATUS_UNSUPPORTED_QE_CERTIFICATION_DATA_TYPE

      STATUS_PCK_CERT_MISMATCH

      STATUS_INVALID_QE_REPORT_SIGNATURE

      STATUS_INVALID_QE_REPORT_DATA

      STATUS_INVALID_QUOTE_SIGNATURE

      STATUS_SGX_QE_IDENTITY_UNSUPPORTED_FORMAT

      STATUS_SGX_QE_IDENTITY_INVALID

      STATUS_SGX_QE_IDENTITY_INVALID_SIGNATURE

      STATUS_SGX_ENCLAVE_REPORT_UNSUPPORTED_FORMAT

      STATUS_SGX_ENCLAVE_IDENTITY_UNSUPPORTED_FORMAT

      STATUS_SGX_ENCLAVE_IDENTITY_INVALID

      STATUS_SGX_ENCLAVE_IDENTITY_UNSUPPORTED_VERSION

      STATUS_SGX_ENCLAVE_IDENTITY_OUT_OF_DATE

      STATUS_SGX_ENCLAVE_REPORT_MISCSELECT_MISMATCH

      STATUS_SGX_ENCLAVE_REPORT_ATTRIBUTES_MISMATCH

      STATUS_SGX_ENCLAVE_REPORT_MRENCLAVE_MISMATCH

      STATUS_SGX_ENCLAVE_REPORT_MRSIGNER_MISMATCH

      STATUS_SGX_ENCLAVE_REPORT_ISVPRODID_MISMATCH

      STATUS_SGX_ENCLAVE_REPORT_ISVSVN_OUT_OF_DATE

      STATUS_UNSUPPORTED_QE_IDENTITY_FORMAT

      STATUS_QE_IDENTITY_OUT_OF_DATE

      STATUS_QE_IDENTITY_MISMATCH

      STATUS_SGX_TCB_INFO_EXPIRED

      STATUS_SGX_ENCLAVE_IDENTITY_INVALID_SIGNATURE

      STATUS_INVALID_PARAMETER

      STATUS_SGX_PCK_CERT_CHAIN_EXPIRED

      STATUS_SGX_CRL_EXPIRED

      STATUS_SGX_SIGNING_CERT_CHAIN_EXPIRED

      STATUS_SGX_ENCLAVE_IDENTITY_EXPIRED

      STATUS_TCB_SW_HARDENING_NEEDED

      STATUS_TCB_CONFIGURATION_AND_SW_HARDENING_NEEDED

      STATUS_SGX_ENCLAVE_REPORT_ISVSVN_REVOKED

      STATUS_TDX_MODULE_MISMATCH
    """
    def __eq__(self, other: object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __init__(self, value: int) -> None: ...
    def __int__(self) -> int: ...
    def __ne__(self, other: object) -> bool: ...
    def __repr__(self) -> str: ...
    def __setstate__(self, state: int) -> None: ...
    @property
    def name(self) -> str:
        """
        :type: str
        """
    @property
    def value(self) -> int:
        """
        :type: int
        """
    STATUS_INVALID_PARAMETER: sgx_dcap_quote_verify._core.VerificationStatus # value = <VerificationStatus.STATUS_INVALID_PARAMETER: 77>
    STATUS_INVALID_PCK_CERT: sgx_dcap_quote_verify._core.VerificationStatus # value = <VerificationStatus.STATUS_INVALID_PCK_CERT: 39>
    STATUS_INVALID_PCK_CRL: sgx_dcap_quote_verify._core.VerificationStatus # value = <VerificationStatus.STATUS_INVALID_PCK_CRL: 41>
    STATUS_INVALID_QE_CERTIFICATION_DATA_SIZE: sgx_dcap_quote_verify._core.VerificationStatus # value = <VerificationStatus.STATUS_INVALID_QE_CERTIFICATION_DATA_SIZE: 52>
    STATUS_INVALID_QE_REPORT_DATA: sgx_dcap_quote_verify._core.VerificationStatus # value = <VerificationStatus.STATUS_INVALID_QE_REPORT_DATA: 56>
    STATUS_INVALID_QE_REPORT_SIGNATURE: sgx_dcap_quote_verify._core.VerificationStatus # value = <VerificationStatus.STATUS_INVALID_QE_REPORT_SIGNATURE: 55>
    STATUS_INVALID_QUOTE_SIGNATURE: sgx_dcap_quote_verify._core.VerificationStatus # value = <VerificationStatus.STATUS_INVALID_QUOTE_SIGNATURE: 57>
    STATUS_MISSING_PARAMETERS: sgx_dcap_quote_verify._core.VerificationStatus # value = <VerificationStatus.STATUS_MISSING_PARAMETERS: 36>
    STATUS_OK: sgx_dcap_quote_verify._core.VerificationStatus # value = <VerificationStatus.STATUS_OK: 0>
    STATUS_PCK_CERT_MISMATCH: sgx_dcap_quote_verify._core.VerificationStatus # value = <VerificationStatus.STATUS_PCK_CERT_MISMATCH: 54>
    STATUS_PCK_REVOKED: sgx_dcap_quote_verify._core.VerificationStatus # value = <VerificationStatus.STATUS_PCK_REVOKED: 43>
    STATUS_QE_IDENTITY_MISMATCH: sgx_dcap_quote_verify._core.VerificationStatus # value = <VerificationStatus.STATUS_QE_IDENTITY_MISMATCH: 74>
    STATUS_QE_IDENTITY_OUT_OF_DATE: sgx_dcap_quote_verify._core.VerificationStatus # value = <VerificationStatus.STATUS_QE_IDENTITY_OUT_OF_DATE: 73>
    STATUS_SGX_CA_CERT_INVALID: sgx_dcap_quote_verify._core.VerificationStatus # value = <VerificationStatus.STATUS_SGX_CA_CERT_INVALID: 34>
    STATUS_SGX_CA_CERT_UNSUPPORTED_FORMAT: sgx_dcap_quote_verify._core.VerificationStatus # value = <VerificationStatus.STATUS_SGX_CA_CERT_UNSUPPORTED_FORMAT: 33>
    STATUS_SGX_CRL_EXPIRED: sgx_dcap_quote_verify._core.VerificationStatus # value = <VerificationStatus.STATUS_SGX_CRL_EXPIRED: 79>
    STATUS_SGX_CRL_INVALID: sgx_dcap_quote_verify._core.VerificationStatus # value = <VerificationStatus.STATUS_SGX_CRL_INVALID: 30>
    STATUS_SGX_CRL_INVALID_EXTENSIONS: sgx_dcap_quote_verify._core.VerificationStatus # value = <VerificationStatus.STATUS_SGX_CRL_INVALID_EXTENSIONS: 31>
    STATUS_SGX_CRL_INVALID_SIGNATURE: sgx_dcap_quote_verify._core.VerificationStatus # value = <VerificationStatus.STATUS_SGX_CRL_INVALID_SIGNATURE: 32>
    STATUS_SGX_CRL_UNKNOWN_ISSUER: sgx_dcap_quote_verify._core.VerificationStatus # value = <VerificationStatus.STATUS_SGX_CRL_UNKNOWN_ISSUER: 29>
    STATUS_SGX_CRL_UNSUPPORTED_FORMAT: sgx_dcap_quote_verify._core.VerificationStatus # value = <VerificationStatus.STATUS_SGX_CRL_UNSUPPORTED_FORMAT: 28>
    STATUS_SGX_ENCLAVE_IDENTITY_EXPIRED: sgx_dcap_quote_verify._core.VerificationStatus # value = <VerificationStatus.STATUS_SGX_ENCLAVE_IDENTITY_EXPIRED: 81>
    STATUS_SGX_ENCLAVE_IDENTITY_INVALID: sgx_dcap_quote_verify._core.VerificationStatus # value = <VerificationStatus.STATUS_SGX_ENCLAVE_IDENTITY_INVALID: 63>
    STATUS_SGX_ENCLAVE_IDENTITY_INVALID_SIGNATURE: sgx_dcap_quote_verify._core.VerificationStatus # value = <VerificationStatus.STATUS_SGX_ENCLAVE_IDENTITY_INVALID_SIGNATURE: 76>
    STATUS_SGX_ENCLAVE_IDENTITY_OUT_OF_DATE: sgx_dcap_quote_verify._core.VerificationStatus # value = <VerificationStatus.STATUS_SGX_ENCLAVE_IDENTITY_OUT_OF_DATE: 65>
    STATUS_SGX_ENCLAVE_IDENTITY_UNSUPPORTED_FORMAT: sgx_dcap_quote_verify._core.VerificationStatus # value = <VerificationStatus.STATUS_SGX_ENCLAVE_IDENTITY_UNSUPPORTED_FORMAT: 62>
    STATUS_SGX_ENCLAVE_IDENTITY_UNSUPPORTED_VERSION: sgx_dcap_quote_verify._core.VerificationStatus # value = <VerificationStatus.STATUS_SGX_ENCLAVE_IDENTITY_UNSUPPORTED_VERSION: 64>
    STATUS_SGX_ENCLAVE_REPORT_ATTRIBUTES_MISMATCH: sgx_dcap_quote_verify._core.VerificationStatus # value = <VerificationStatus.STATUS_SGX_ENCLAVE_REPORT_ATTRIBUTES_MISMATCH: 67>
    STATUS_SGX_ENCLAVE_REPORT_ISVPRODID_MISMATCH: sgx_dcap_quote_verify._core.VerificationStatus # value = <VerificationStatus.STATUS_SGX_ENCLAVE_REPORT_ISVPRODID_MISMATCH: 70>
    STATUS_SGX_ENCLAVE_REPORT_ISVSVN_OUT_OF_DATE: sgx_dcap_quote_verify._core.VerificationStatus # value = <VerificationStatus.STATUS_SGX_ENCLAVE_REPORT_ISVSVN_OUT_OF_DATE: 71>
    STATUS_SGX_ENCLAVE_REPORT_ISVSVN_REVOKED: sgx_dcap_quote_verify._core.VerificationStatus # value = <VerificationStatus.STATUS_SGX_ENCLAVE_REPORT_ISVSVN_REVOKED: 84>
    STATUS_SGX_ENCLAVE_REPORT_MISCSELECT_MISMATCH: sgx_dcap_quote_verify._core.VerificationStatus # value = <VerificationStatus.STATUS_SGX_ENCLAVE_REPORT_MISCSELECT_MISMATCH: 66>
    STATUS_SGX_ENCLAVE_REPORT_MRENCLAVE_MISMATCH: sgx_dcap_quote_verify._core.VerificationStatus # value = <VerificationStatus.STATUS_SGX_ENCLAVE_REPORT_MRENCLAVE_MISMATCH: 68>
    STATUS_SGX_ENCLAVE_REPORT_MRSIGNER_MISMATCH: sgx_dcap_quote_verify._core.VerificationStatus # value = <VerificationStatus.STATUS_SGX_ENCLAVE_REPORT_MRSIGNER_MISMATCH: 69>
    STATUS_SGX_ENCLAVE_REPORT_UNSUPPORTED_FORMAT: sgx_dcap_quote_verify._core.VerificationStatus # value = <VerificationStatus.STATUS_SGX_ENCLAVE_REPORT_UNSUPPORTED_FORMAT: 61>
    STATUS_SGX_INTERMEDIATE_CA_INVALID: sgx_dcap_quote_verify._core.VerificationStatus # value = <VerificationStatus.STATUS_SGX_INTERMEDIATE_CA_INVALID: 8>
    STATUS_SGX_INTERMEDIATE_CA_INVALID_EXTENSIONS: sgx_dcap_quote_verify._core.VerificationStatus # value = <VerificationStatus.STATUS_SGX_INTERMEDIATE_CA_INVALID_EXTENSIONS: 9>
    STATUS_SGX_INTERMEDIATE_CA_INVALID_ISSUER: sgx_dcap_quote_verify._core.VerificationStatus # value = <VerificationStatus.STATUS_SGX_INTERMEDIATE_CA_INVALID_ISSUER: 10>
    STATUS_SGX_INTERMEDIATE_CA_MISSING: sgx_dcap_quote_verify._core.VerificationStatus # value = <VerificationStatus.STATUS_SGX_INTERMEDIATE_CA_MISSING: 7>
    STATUS_SGX_INTERMEDIATE_CA_REVOKED: sgx_dcap_quote_verify._core.VerificationStatus # value = <VerificationStatus.STATUS_SGX_INTERMEDIATE_CA_REVOKED: 11>
    STATUS_SGX_PCK_CERT_CHAIN_EXPIRED: sgx_dcap_quote_verify._core.VerificationStatus # value = <VerificationStatus.STATUS_SGX_PCK_CERT_CHAIN_EXPIRED: 78>
    STATUS_SGX_PCK_CERT_CHAIN_UNTRUSTED: sgx_dcap_quote_verify._core.VerificationStatus # value = <VerificationStatus.STATUS_SGX_PCK_CERT_CHAIN_UNTRUSTED: 18>
    STATUS_SGX_PCK_INVALID: sgx_dcap_quote_verify._core.VerificationStatus # value = <VerificationStatus.STATUS_SGX_PCK_INVALID: 13>
    STATUS_SGX_PCK_INVALID_EXTENSIONS: sgx_dcap_quote_verify._core.VerificationStatus # value = <VerificationStatus.STATUS_SGX_PCK_INVALID_EXTENSIONS: 14>
    STATUS_SGX_PCK_INVALID_ISSUER: sgx_dcap_quote_verify._core.VerificationStatus # value = <VerificationStatus.STATUS_SGX_PCK_INVALID_ISSUER: 15>
    STATUS_SGX_PCK_MISSING: sgx_dcap_quote_verify._core.VerificationStatus # value = <VerificationStatus.STATUS_SGX_PCK_MISSING: 12>
    STATUS_SGX_PCK_REVOKED: sgx_dcap_quote_verify._core.VerificationStatus # value = <VerificationStatus.STATUS_SGX_PCK_REVOKED: 16>
    STATUS_SGX_QE_IDENTITY_INVALID: sgx_dcap_quote_verify._core.VerificationStatus # value = <VerificationStatus.STATUS_SGX_QE_IDENTITY_INVALID: 59>
    STATUS_SGX_QE_IDENTITY_INVALID_SIGNATURE: sgx_dcap_quote_verify._core.VerificationStatus # value = <VerificationStatus.STATUS_SGX_QE_IDENTITY_INVALID_SIGNATURE: 60>
    STATUS_SGX_QE_IDENTITY_UNSUPPORTED_FORMAT: sgx_dcap_quote_verify._core.VerificationStatus # value = <VerificationStatus.STATUS_SGX_QE_IDENTITY_UNSUPPORTED_FORMAT: 58>
    STATUS_SGX_ROOT_CA_INVALID: sgx_dcap_quote_verify._core.VerificationStatus # value = <VerificationStatus.STATUS_SGX_ROOT_CA_INVALID: 3>
    STATUS_SGX_ROOT_CA_INVALID_EXTENSIONS: sgx_dcap_quote_verify._core.VerificationStatus # value = <VerificationStatus.STATUS_SGX_ROOT_CA_INVALID_EXTENSIONS: 4>
    STATUS_SGX_ROOT_CA_INVALID_ISSUER: sgx_dcap_quote_verify._core.VerificationStatus # value = <VerificationStatus.STATUS_SGX_ROOT_CA_INVALID_ISSUER: 5>
    STATUS_SGX_ROOT_CA_MISSING: sgx_dcap_quote_verify._core.VerificationStatus # value = <VerificationStatus.STATUS_SGX_ROOT_CA_MISSING: 2>
    STATUS_SGX_ROOT_CA_UNTRUSTED: sgx_dcap_quote_verify._core.VerificationStatus # value = <VerificationStatus.STATUS_SGX_ROOT_CA_UNTRUSTED: 6>
    STATUS_SGX_SIGNING_CERT_CHAIN_EXPIRED: sgx_dcap_quote_verify._core.VerificationStatus # value = <VerificationStatus.STATUS_SGX_SIGNING_CERT_CHAIN_EXPIRED: 80>
    STATUS_SGX_TCB_INFO_EXPIRED: sgx_dcap_quote_verify._core.VerificationStatus # value = <VerificationStatus.STATUS_SGX_TCB_INFO_EXPIRED: 75>
    STATUS_SGX_TCB_INFO_INVALID: sgx_dcap_quote_verify._core.VerificationStatus # value = <VerificationStatus.STATUS_SGX_TCB_INFO_INVALID: 20>
    STATUS_SGX_TCB_INFO_UNSUPPORTED_FORMAT: sgx_dcap_quote_verify._core.VerificationStatus # value = <VerificationStatus.STATUS_SGX_TCB_INFO_UNSUPPORTED_FORMAT: 19>
    STATUS_SGX_TCB_SIGNING_CERT_CHAIN_UNTRUSTED: sgx_dcap_quote_verify._core.VerificationStatus # value = <VerificationStatus.STATUS_SGX_TCB_SIGNING_CERT_CHAIN_UNTRUSTED: 26>
    STATUS_SGX_TCB_SIGNING_CERT_INVALID: sgx_dcap_quote_verify._core.VerificationStatus # value = <VerificationStatus.STATUS_SGX_TCB_SIGNING_CERT_INVALID: 23>
    STATUS_SGX_TCB_SIGNING_CERT_INVALID_EXTENSIONS: sgx_dcap_quote_verify._core.VerificationStatus # value = <VerificationStatus.STATUS_SGX_TCB_SIGNING_CERT_INVALID_EXTENSIONS: 24>
    STATUS_SGX_TCB_SIGNING_CERT_INVALID_ISSUER: sgx_dcap_quote_verify._core.VerificationStatus # value = <VerificationStatus.STATUS_SGX_TCB_SIGNING_CERT_INVALID_ISSUER: 25>
    STATUS_SGX_TCB_SIGNING_CERT_MISSING: sgx_dcap_quote_verify._core.VerificationStatus # value = <VerificationStatus.STATUS_SGX_TCB_SIGNING_CERT_MISSING: 22>
    STATUS_SGX_TCB_SIGNING_CERT_REVOKED: sgx_dcap_quote_verify._core.VerificationStatus # value = <VerificationStatus.STATUS_SGX_TCB_SIGNING_CERT_REVOKED: 27>
    STATUS_TCB_CONFIGURATION_AND_SW_HARDENING_NEEDED: sgx_dcap_quote_verify._core.VerificationStatus # value = <VerificationStatus.STATUS_TCB_CONFIGURATION_AND_SW_HARDENING_NEEDED: 83>
    STATUS_TCB_CONFIGURATION_NEEDED: sgx_dcap_quote_verify._core.VerificationStatus # value = <VerificationStatus.STATUS_TCB_CONFIGURATION_NEEDED: 47>
    STATUS_TCB_INFO_INVALID_SIGNATURE: sgx_dcap_quote_verify._core.VerificationStatus # value = <VerificationStatus.STATUS_TCB_INFO_INVALID_SIGNATURE: 21>
    STATUS_TCB_INFO_MISMATCH: sgx_dcap_quote_verify._core.VerificationStatus # value = <VerificationStatus.STATUS_TCB_INFO_MISMATCH: 44>
    STATUS_TCB_NOT_SUPPORTED: sgx_dcap_quote_verify._core.VerificationStatus # value = <VerificationStatus.STATUS_TCB_NOT_SUPPORTED: 49>
    STATUS_TCB_OUT_OF_DATE: sgx_dcap_quote_verify._core.VerificationStatus # value = <VerificationStatus.STATUS_TCB_OUT_OF_DATE: 45>
    STATUS_TCB_OUT_OF_DATE_CONFIGURATION_NEEDED: sgx_dcap_quote_verify._core.VerificationStatus # value = <VerificationStatus.STATUS_TCB_OUT_OF_DATE_CONFIGURATION_NEEDED: 48>
    STATUS_TCB_REVOKED: sgx_dcap_quote_verify._core.VerificationStatus # value = <VerificationStatus.STATUS_TCB_REVOKED: 46>
    STATUS_TCB_SW_HARDENING_NEEDED: sgx_dcap_quote_verify._core.VerificationStatus # value = <VerificationStatus.STATUS_TCB_SW_HARDENING_NEEDED: 82>
    STATUS_TCB_UNRECOGNIZED_STATUS: sgx_dcap_quote_verify._core.VerificationStatus # value = <VerificationStatus.STATUS_TCB_UNRECOGNIZED_STATUS: 50>
    STATUS_TDX_MODULE_MISMATCH: sgx_dcap_quote_verify._core.VerificationStatus # value = <VerificationStatus.STATUS_TDX_MODULE_MISMATCH: 85>
    STATUS_TRUSTED_ROOT_CA_INVALID: sgx_dcap_quote_verify._core.VerificationStatus # value = <VerificationStatus.STATUS_TRUSTED_ROOT_CA_INVALID: 17>
    STATUS_TRUSTED_ROOT_CA_UNSUPPORTED_FORMAT: sgx_dcap_quote_verify._core.VerificationStatus # value = <VerificationStatus.STATUS_TRUSTED_ROOT_CA_UNSUPPORTED_FORMAT: 35>
    STATUS_UNSUPPORTED_CERT_FORMAT: sgx_dcap_quote_verify._core.VerificationStatus # value = <VerificationStatus.STATUS_UNSUPPORTED_CERT_FORMAT: 1>
    STATUS_UNSUPPORTED_PCK_CERT_FORMAT: sgx_dcap_quote_verify._core.VerificationStatus # value = <VerificationStatus.STATUS_UNSUPPORTED_PCK_CERT_FORMAT: 38>
    STATUS_UNSUPPORTED_PCK_RL_FORMAT: sgx_dcap_quote_verify._core.VerificationStatus # value = <VerificationStatus.STATUS_UNSUPPORTED_PCK_RL_FORMAT: 40>
    STATUS_UNSUPPORTED_QE_CERTIFICATION: sgx_dcap_quote_verify._core.VerificationStatus # value = <VerificationStatus.STATUS_UNSUPPORTED_QE_CERTIFICATION: 51>
    STATUS_UNSUPPORTED_QE_CERTIFICATION_DATA_TYPE: sgx_dcap_quote_verify._core.VerificationStatus # value = <VerificationStatus.STATUS_UNSUPPORTED_QE_CERTIFICATION_DATA_TYPE: 53>
    STATUS_UNSUPPORTED_QE_IDENTITY_FORMAT: sgx_dcap_quote_verify._core.VerificationStatus # value = <VerificationStatus.STATUS_UNSUPPORTED_QE_IDENTITY_FORMAT: 72>
    STATUS_UNSUPPORTED_QUOTE_FORMAT: sgx_dcap_quote_verify._core.VerificationStatus # value = <VerificationStatus.STATUS_UNSUPPORTED_QUOTE_FORMAT: 37>
    STATUS_UNSUPPORTED_TCB_INFO_FORMAT: sgx_dcap_quote_verify._core.VerificationStatus # value = <VerificationStatus.STATUS_UNSUPPORTED_TCB_INFO_FORMAT: 42>
    __members__: dict # value = {'STATUS_OK': <VerificationStatus.STATUS_OK: 0>, 'STATUS_UNSUPPORTED_CERT_FORMAT': <VerificationStatus.STATUS_UNSUPPORTED_CERT_FORMAT: 1>, 'STATUS_SGX_ROOT_CA_MISSING': <VerificationStatus.STATUS_SGX_ROOT_CA_MISSING: 2>, 'STATUS_SGX_ROOT_CA_INVALID': <VerificationStatus.STATUS_SGX_ROOT_CA_INVALID: 3>, 'STATUS_SGX_ROOT_CA_INVALID_EXTENSIONS': <VerificationStatus.STATUS_SGX_ROOT_CA_INVALID_EXTENSIONS: 4>, 'STATUS_SGX_ROOT_CA_INVALID_ISSUER': <VerificationStatus.STATUS_SGX_ROOT_CA_INVALID_ISSUER: 5>, 'STATUS_SGX_ROOT_CA_UNTRUSTED': <VerificationStatus.STATUS_SGX_ROOT_CA_UNTRUSTED: 6>, 'STATUS_SGX_INTERMEDIATE_CA_MISSING': <VerificationStatus.STATUS_SGX_INTERMEDIATE_CA_MISSING: 7>, 'STATUS_SGX_INTERMEDIATE_CA_INVALID': <VerificationStatus.STATUS_SGX_INTERMEDIATE_CA_INVALID: 8>, 'STATUS_SGX_INTERMEDIATE_CA_INVALID_EXTENSIONS': <VerificationStatus.STATUS_SGX_INTERMEDIATE_CA_INVALID_EXTENSIONS: 9>, 'STATUS_SGX_INTERMEDIATE_CA_INVALID_ISSUER': <VerificationStatus.STATUS_SGX_INTERMEDIATE_CA_INVALID_ISSUER: 10>, 'STATUS_SGX_INTERMEDIATE_CA_REVOKED': <VerificationStatus.STATUS_SGX_INTERMEDIATE_CA_REVOKED: 11>, 'STATUS_SGX_PCK_MISSING': <VerificationStatus.STATUS_SGX_PCK_MISSING: 12>, 'STATUS_SGX_PCK_INVALID': <VerificationStatus.STATUS_SGX_PCK_INVALID: 13>, 'STATUS_SGX_PCK_INVALID_EXTENSIONS': <VerificationStatus.STATUS_SGX_PCK_INVALID_EXTENSIONS: 14>, 'STATUS_SGX_PCK_INVALID_ISSUER': <VerificationStatus.STATUS_SGX_PCK_INVALID_ISSUER: 15>, 'STATUS_SGX_PCK_REVOKED': <VerificationStatus.STATUS_SGX_PCK_REVOKED: 16>, 'STATUS_TRUSTED_ROOT_CA_INVALID': <VerificationStatus.STATUS_TRUSTED_ROOT_CA_INVALID: 17>, 'STATUS_SGX_PCK_CERT_CHAIN_UNTRUSTED': <VerificationStatus.STATUS_SGX_PCK_CERT_CHAIN_UNTRUSTED: 18>, 'STATUS_SGX_TCB_INFO_UNSUPPORTED_FORMAT': <VerificationStatus.STATUS_SGX_TCB_INFO_UNSUPPORTED_FORMAT: 19>, 'STATUS_SGX_TCB_INFO_INVALID': <VerificationStatus.STATUS_SGX_TCB_INFO_INVALID: 20>, 'STATUS_TCB_INFO_INVALID_SIGNATURE': <VerificationStatus.STATUS_TCB_INFO_INVALID_SIGNATURE: 21>, 'STATUS_SGX_TCB_SIGNING_CERT_MISSING': <VerificationStatus.STATUS_SGX_TCB_SIGNING_CERT_MISSING: 22>, 'STATUS_SGX_TCB_SIGNING_CERT_INVALID': <VerificationStatus.STATUS_SGX_TCB_SIGNING_CERT_INVALID: 23>, 'STATUS_SGX_TCB_SIGNING_CERT_INVALID_EXTENSIONS': <VerificationStatus.STATUS_SGX_TCB_SIGNING_CERT_INVALID_EXTENSIONS: 24>, 'STATUS_SGX_TCB_SIGNING_CERT_INVALID_ISSUER': <VerificationStatus.STATUS_SGX_TCB_SIGNING_CERT_INVALID_ISSUER: 25>, 'STATUS_SGX_TCB_SIGNING_CERT_CHAIN_UNTRUSTED': <VerificationStatus.STATUS_SGX_TCB_SIGNING_CERT_CHAIN_UNTRUSTED: 26>, 'STATUS_SGX_TCB_SIGNING_CERT_REVOKED': <VerificationStatus.STATUS_SGX_TCB_SIGNING_CERT_REVOKED: 27>, 'STATUS_SGX_CRL_UNSUPPORTED_FORMAT': <VerificationStatus.STATUS_SGX_CRL_UNSUPPORTED_FORMAT: 28>, 'STATUS_SGX_CRL_UNKNOWN_ISSUER': <VerificationStatus.STATUS_SGX_CRL_UNKNOWN_ISSUER: 29>, 'STATUS_SGX_CRL_INVALID': <VerificationStatus.STATUS_SGX_CRL_INVALID: 30>, 'STATUS_SGX_CRL_INVALID_EXTENSIONS': <VerificationStatus.STATUS_SGX_CRL_INVALID_EXTENSIONS: 31>, 'STATUS_SGX_CRL_INVALID_SIGNATURE': <VerificationStatus.STATUS_SGX_CRL_INVALID_SIGNATURE: 32>, 'STATUS_SGX_CA_CERT_UNSUPPORTED_FORMAT': <VerificationStatus.STATUS_SGX_CA_CERT_UNSUPPORTED_FORMAT: 33>, 'STATUS_SGX_CA_CERT_INVALID': <VerificationStatus.STATUS_SGX_CA_CERT_INVALID: 34>, 'STATUS_TRUSTED_ROOT_CA_UNSUPPORTED_FORMAT': <VerificationStatus.STATUS_TRUSTED_ROOT_CA_UNSUPPORTED_FORMAT: 35>, 'STATUS_MISSING_PARAMETERS': <VerificationStatus.STATUS_MISSING_PARAMETERS: 36>, 'STATUS_UNSUPPORTED_QUOTE_FORMAT': <VerificationStatus.STATUS_UNSUPPORTED_QUOTE_FORMAT: 37>, 'STATUS_UNSUPPORTED_PCK_CERT_FORMAT': <VerificationStatus.STATUS_UNSUPPORTED_PCK_CERT_FORMAT: 38>, 'STATUS_INVALID_PCK_CERT': <VerificationStatus.STATUS_INVALID_PCK_CERT: 39>, 'STATUS_UNSUPPORTED_PCK_RL_FORMAT': <VerificationStatus.STATUS_UNSUPPORTED_PCK_RL_FORMAT: 40>, 'STATUS_INVALID_PCK_CRL': <VerificationStatus.STATUS_INVALID_PCK_CRL: 41>, 'STATUS_UNSUPPORTED_TCB_INFO_FORMAT': <VerificationStatus.STATUS_UNSUPPORTED_TCB_INFO_FORMAT: 42>, 'STATUS_PCK_REVOKED': <VerificationStatus.STATUS_PCK_REVOKED: 43>, 'STATUS_TCB_INFO_MISMATCH': <VerificationStatus.STATUS_TCB_INFO_MISMATCH: 44>, 'STATUS_TCB_OUT_OF_DATE': <VerificationStatus.STATUS_TCB_OUT_OF_DATE: 45>, 'STATUS_TCB_REVOKED': <VerificationStatus.STATUS_TCB_REVOKED: 46>, 'STATUS_TCB_CONFIGURATION_NEEDED': <VerificationStatus.STATUS_TCB_CONFIGURATION_NEEDED: 47>, 'STATUS_TCB_OUT_OF_DATE_CONFIGURATION_NEEDED': <VerificationStatus.STATUS_TCB_OUT_OF_DATE_CONFIGURATION_NEEDED: 48>, 'STATUS_TCB_NOT_SUPPORTED': <VerificationStatus.STATUS_TCB_NOT_SUPPORTED: 49>, 'STATUS_TCB_UNRECOGNIZED_STATUS': <VerificationStatus.STATUS_TCB_UNRECOGNIZED_STATUS: 50>, 'STATUS_UNSUPPORTED_QE_CERTIFICATION': <VerificationStatus.STATUS_UNSUPPORTED_QE_CERTIFICATION: 51>, 'STATUS_INVALID_QE_CERTIFICATION_DATA_SIZE': <VerificationStatus.STATUS_INVALID_QE_CERTIFICATION_DATA_SIZE: 52>, 'STATUS_UNSUPPORTED_QE_CERTIFICATION_DATA_TYPE': <VerificationStatus.STATUS_UNSUPPORTED_QE_CERTIFICATION_DATA_TYPE: 53>, 'STATUS_PCK_CERT_MISMATCH': <VerificationStatus.STATUS_PCK_CERT_MISMATCH: 54>, 'STATUS_INVALID_QE_REPORT_SIGNATURE': <VerificationStatus.STATUS_INVALID_QE_REPORT_SIGNATURE: 55>, 'STATUS_INVALID_QE_REPORT_DATA': <VerificationStatus.STATUS_INVALID_QE_REPORT_DATA: 56>, 'STATUS_INVALID_QUOTE_SIGNATURE': <VerificationStatus.STATUS_INVALID_QUOTE_SIGNATURE: 57>, 'STATUS_SGX_QE_IDENTITY_UNSUPPORTED_FORMAT': <VerificationStatus.STATUS_SGX_QE_IDENTITY_UNSUPPORTED_FORMAT: 58>, 'STATUS_SGX_QE_IDENTITY_INVALID': <VerificationStatus.STATUS_SGX_QE_IDENTITY_INVALID: 59>, 'STATUS_SGX_QE_IDENTITY_INVALID_SIGNATURE': <VerificationStatus.STATUS_SGX_QE_IDENTITY_INVALID_SIGNATURE: 60>, 'STATUS_SGX_ENCLAVE_REPORT_UNSUPPORTED_FORMAT': <VerificationStatus.STATUS_SGX_ENCLAVE_REPORT_UNSUPPORTED_FORMAT: 61>, 'STATUS_SGX_ENCLAVE_IDENTITY_UNSUPPORTED_FORMAT': <VerificationStatus.STATUS_SGX_ENCLAVE_IDENTITY_UNSUPPORTED_FORMAT: 62>, 'STATUS_SGX_ENCLAVE_IDENTITY_INVALID': <VerificationStatus.STATUS_SGX_ENCLAVE_IDENTITY_INVALID: 63>, 'STATUS_SGX_ENCLAVE_IDENTITY_UNSUPPORTED_VERSION': <VerificationStatus.STATUS_SGX_ENCLAVE_IDENTITY_UNSUPPORTED_VERSION: 64>, 'STATUS_SGX_ENCLAVE_IDENTITY_OUT_OF_DATE': <VerificationStatus.STATUS_SGX_ENCLAVE_IDENTITY_OUT_OF_DATE: 65>, 'STATUS_SGX_ENCLAVE_REPORT_MISCSELECT_MISMATCH': <VerificationStatus.STATUS_SGX_ENCLAVE_REPORT_MISCSELECT_MISMATCH: 66>, 'STATUS_SGX_ENCLAVE_REPORT_ATTRIBUTES_MISMATCH': <VerificationStatus.STATUS_SGX_ENCLAVE_REPORT_ATTRIBUTES_MISMATCH: 67>, 'STATUS_SGX_ENCLAVE_REPORT_MRENCLAVE_MISMATCH': <VerificationStatus.STATUS_SGX_ENCLAVE_REPORT_MRENCLAVE_MISMATCH: 68>, 'STATUS_SGX_ENCLAVE_REPORT_MRSIGNER_MISMATCH': <VerificationStatus.STATUS_SGX_ENCLAVE_REPORT_MRSIGNER_MISMATCH: 69>, 'STATUS_SGX_ENCLAVE_REPORT_ISVPRODID_MISMATCH': <VerificationStatus.STATUS_SGX_ENCLAVE_REPORT_ISVPRODID_MISMATCH: 70>, 'STATUS_SGX_ENCLAVE_REPORT_ISVSVN_OUT_OF_DATE': <VerificationStatus.STATUS_SGX_ENCLAVE_REPORT_ISVSVN_OUT_OF_DATE: 71>, 'STATUS_UNSUPPORTED_QE_IDENTITY_FORMAT': <VerificationStatus.STATUS_UNSUPPORTED_QE_IDENTITY_FORMAT: 72>, 'STATUS_QE_IDENTITY_OUT_OF_DATE': <VerificationStatus.STATUS_QE_IDENTITY_OUT_OF_DATE: 73>, 'STATUS_QE_IDENTITY_MISMATCH': <VerificationStatus.STATUS_QE_IDENTITY_MISMATCH: 74>, 'STATUS_SGX_TCB_INFO_EXPIRED': <VerificationStatus.STATUS_SGX_TCB_INFO_EXPIRED: 75>, 'STATUS_SGX_ENCLAVE_IDENTITY_INVALID_SIGNATURE': <VerificationStatus.STATUS_SGX_ENCLAVE_IDENTITY_INVALID_SIGNATURE: 76>, 'STATUS_INVALID_PARAMETER': <VerificationStatus.STATUS_INVALID_PARAMETER: 77>, 'STATUS_SGX_PCK_CERT_CHAIN_EXPIRED': <VerificationStatus.STATUS_SGX_PCK_CERT_CHAIN_EXPIRED: 78>, 'STATUS_SGX_CRL_EXPIRED': <VerificationStatus.STATUS_SGX_CRL_EXPIRED: 79>, 'STATUS_SGX_SIGNING_CERT_CHAIN_EXPIRED': <VerificationStatus.STATUS_SGX_SIGNING_CERT_CHAIN_EXPIRED: 80>, 'STATUS_SGX_ENCLAVE_IDENTITY_EXPIRED': <VerificationStatus.STATUS_SGX_ENCLAVE_IDENTITY_EXPIRED: 81>, 'STATUS_TCB_SW_HARDENING_NEEDED': <VerificationStatus.STATUS_TCB_SW_HARDENING_NEEDED: 82>, 'STATUS_TCB_CONFIGURATION_AND_SW_HARDENING_NEEDED': <VerificationStatus.STATUS_TCB_CONFIGURATION_AND_SW_HARDENING_NEEDED: 83>, 'STATUS_SGX_ENCLAVE_REPORT_ISVSVN_REVOKED': <VerificationStatus.STATUS_SGX_ENCLAVE_REPORT_ISVSVN_REVOKED: 84>, 'STATUS_TDX_MODULE_MISMATCH': <VerificationStatus.STATUS_TDX_MODULE_MISMATCH: 85>}
    pass
def verify(trusted_root_ca_certificate: str, pck_certificate: str, pck_signing_chain: str, root_ca_crl: str, intermediate_ca_crl: str, tcb_info: str, tcb_signing_chain: str, quote: bytes, qe_identity: str, expiration_date: datetime.datetime) -> bytes:
    pass
