from __future__ import annotations

from typing import TYPE_CHECKING

if TYPE_CHECKING:
    from typing import Dict, TypedDict

    class LensDict(TypedDict, total=False):
        name: str
        lensNA: float
        magnification: float
        immersion: str
        model: str
        correction: str
        workingDistance: float
        manufacturer: str


D: Dict[int, LensDict] = {
    10100: {
        "name": "Olympus 10X/0.30, S Plan Achromat, phase, IMT2",
        "lensNA": 0.30,
        "magnification": 10.0,
        "immersion": "Air",
        "model": "1-LP134",
        "correction": "Achromat",
    },
    10101: {
        "name": "Olympus 10X/0.40, DApo/340, IMT2",
        "lensNA": 0.40,
        "magnification": 10.0,
        "immersion": "Air",
        "model": "1-LB331",
        "correction": "Apo",
    },
    10102: {
        "name": "Olympus 10X/0.30, SPlan 10, Positive Low, phase, IMT2",
        "lensNA": 0.30,
        "magnification": 10.0,
        "immersion": "Air",
        "model": "1-LP134",
    },
    10103: {
        "name": "Olympus 4X/0.13, SPlan 4, Positive Low, phase, IMT2",
        "lensNA": 0.13,
        "magnification": 4.0,
        "immersion": "Air",
        "model": "1-LP124",
    },
    10104: {
        "name": "Olympus 10X/0.40, D Plan Apo UV, IMT2",
        "lensNA": 0.40,
        "magnification": 10.0,
        "immersion": "Air",
        "model": "1-LB331",
        "correction": "UV",
    },
    10105: {
        "name": "Olympus 10X/0.40, D Plan Apo UV, phase, fluor free, IMT2",
        "lensNA": 0.40,
        "magnification": 10.0,
        "workingDistance": 3.10,
        "immersion": "Air",
        "model": "1-LP331",
        "correction": "UV",
    },
    10106: {
        "name": "Olympus 4X/0.16, U Plan Apo, Infinity/-, IX70",
        "lensNA": 0.16,
        "magnification": 4.0,
        "workingDistance": 13.0,
        "immersion": "Air",
        "model": "1-UB822",
        "correction": "PlanApo",
    },
    10107: {
        "name": "Olympus 10X/0.40, U Plan Apo, IX70",
        "lensNA": 0.40,
        "magnification": 10.0,
        "workingDistance": 3.10,
        "immersion": "Air",
        "model": "1-UB823",
        "correction": "PlanApo",
    },
    10108: {
        "name": "Olympus 10X/0.25,C Plan Achromat, phase, IX70",
        "lensNA": 0.25,
        "magnification": 10.0,
        "workingDistance": 9.8,
        "immersion": "Air",
        "model": "1-UC243",
        "correction": "Achromat",
    },
    10109: {
        "name": "Olympus 10X/0.30, UPlanFl, IX70",
        "lensNA": 0.30,
        "magnification": 10.0,
        "immersion": "Air",
        "model": "1-UB532",
        "correction": "PlanFluor",
    },
    10110: {
        "name": "Olympus 4X/0.13",
        "lensNA": 0.13,
        "magnification": 4.0,
        "immersion": "Air",
    },
    10111: {
        "name": "Olympus 2X/0.08, SPlan FL 2",
        "lensNA": 0.08,
        "magnification": 2.0,
        "immersion": "Air",
    },
    10112: {
        "name": "Olympus 4X/0.13, UPlanFL, Infinity/170, IX70",
        "lensNA": 0.13,
        "magnification": 4.0,
        "immersion": "Air",
        "model": "1-UB522",
        "correction": "PlanFluor",
    },
    10113: {
        "name": "Olympus 1.25X/0.04, PlanApo, IX70",
        "lensNA": 0.04,
        "magnification": 1.25,
        "workingDistance": 5.1,
        "immersion": "Air",
        "model": "1-UB920",
        "correction": "PlanApo",
    },
    10114: {
        "name": "Olympus 2X/0.08, PlanApo, IX70",
        "lensNA": 0.08,
        "magnification": 2.0,
        "workingDistance": 6.0,
        "immersion": "Air",
        "model": "1-UB921",
        "correction": "PlanApo",
    },
    10115: {
        "name": "Olympus U-Plan S-Apo 10X/0.4",
        "lensNA": 0.40,
        "magnification": 10.0,
        "workingDistance": 3.1,
        "immersion": "Air",
        "model": "1-U2B823",
    },
    10116: {
        "name": "Olympus 4X/0.16, U-Plan S-Apo, UIS2, 1-U2B822",
        "lensNA": 0.16,
        "magnification": 4.0,
        "workingDistance": 13.0,
        "immersion": "Air",
        "model": "1-U2B822",
    },
    10117: {
        "name": "Olympus 10X/0.40, U-Plan S-Apo, UIS2, 1-U2B824",
        "lensNA": 0.40,
        "magnification": 10.0,
        "workingDistance": 3.1,
        "immersion": "Air",
        "model": "1-U2B824",
    },
    10200: {
        "name": "Olympus 20X/0.40, LWD, CD Plan Achromat, phase, IMT2",
        "lensNA": 0.40,
        "magnification": 20.0,
        "workingDistance": 3.0,
        "immersion": "Air",
        "correction": "Achromat",
    },
    10201: {
        "name": "Olympus 20X/0.65, DApo/340, IMT2, 1-LB343",
        "lensNA": 0.65,
        "magnification": 20.0,
        "workingDistance": 1.03,
        "immersion": "Air",
        "model": "1-LB343",
        "correction": "Apo",
    },
    10202: {
        "name": "Olympus 20X/0.40, ULWD, CDPlan 20PL, phase, IMT2, 1-LP146",
        "lensNA": 0.40,
        "magnification": 20.0,
        "immersion": "Air",
        "model": "1-LP146",
    },
    10203: {
        "name": "Olympus 20X/0.80, D Plan Apo/340, IMT2, 1-LB342",
        "lensNA": 0.80,
        "magnification": 20.0,
        "immersion": "Oil",
        "model": "1-LB342",
        "correction": "PlanApo",
    },
    10204: {
        "name": "Olympus 20X/0.70, D Plan Apo UV, IMT2, 1-LB341",
        "lensNA": 0.70,
        "magnification": 20.0,
        "immersion": "Air",
        "model": "1-LB341",
        "correction": "UV",
    },
    10205: {
        "name": "Olympus 20X/0.75, U Apo 340, IX70, 1-UB765",
        "lensNA": 0.75,
        "magnification": 20.0,
        "workingDistance": 0.55,
        "immersion": "Air",
        "model": "1-UB765",
        "correction": "Apo",
    },
    10206: {
        "name": "Olympus 20X/0.50, Phase, UPLFL, IX70, 1-UC525",
        "lensNA": 0.50,
        "magnification": 20.0,
        "workingDistance": 0.55,
        "immersion": "Air",
        "model": "1-UC525",
    },
    10207: {
        "name": "Olympus 20X/0.40, LWD, C Achromat, phase, IX70",
        "lensNA": 0.40,
        "magnification": 20.0,
        "workingDistance": 3.0,
        "immersion": "Air",
        "model": "1-UC145",
        "correction": "Achromat",
    },
    10208: {
        "name": "Olympus 20X/0.50, Phase, UPLFL, IX70, 1-UB525",
        "lensNA": 0.50,
        "magnification": 20.0,
        "workingDistance": 0.55,
        "immersion": "Air",
        "model": "1-UB525",
    },
    10209: {
        "name": "Olympus 20X/0.40, LCPLFL, Phase, IX70",
        "lensNA": 0.40,
        "magnification": 20.0,
        "workingDistance": 6.9,
        "immersion": "Air",
        "model": "1-UC345",
    },
    10210: {
        "name": "Olympus 20X/0.40, LCPLFL, IX70",
        "lensNA": 0.40,
        "magnification": 20.0,
        "workingDistance": 6.9,
        "immersion": "Air",
        "model": "1-UB345",
    },
    10211: {
        "name": "Olympus U-Plan S-Apo 20X/0.75",
        "lensNA": 0.75,
        "magnification": 20.0,
        "workingDistance": 0.65,
        "immersion": "Air",
        "model": "1-U2B825",
    },
    10212: {
        "name": "Olympus U-Plan Fluorite PH1 20X/0.45 w/Corr. Collar",
        "lensNA": 0.45,
        "magnification": 20.0,
        "immersion": "Air",
        "model": "1-U2C375",
    },
    10213: {
        "name": "Olympus U-Plan Fluorite PH1 20X/0.50",
        "lensNA": 0.50,
        "magnification": 20.0,
        "workingDistance": 2.0,
        "immersion": "Air",
        "model": "1-U2C525",
    },
    10214: {
        "name": "Olympus U-Apo 340nm 20X/0.75",
        "lensNA": 0.75,
        "magnification": 20.0,
        "workingDistance": 0.55,
        "immersion": "Air",
        "model": "1-UB765R",
    },
    10215: {
        "name": "Olympus 20X/0.45, LWD U-Plan FL, w/Corr. Collar, UIS2, 1-U2B375",
        "lensNA": 0.45,
        "magnification": 20.0,
        "workingDistance": 6.6,
        "immersion": "Air",
        "model": "1-U2B375",
        "correction": "PlanFluor",
    },
    10400: {
        "name": "Olympus 40X/0.55, LWD, CDPlan Achromat, phase, IMT2",
        "lensNA": 0.55,
        "magnification": 40.0,
        "workingDistance": 2.04,
        "immersion": "Air",
        "correction": "Achromat",
    },
    10401: {
        "name": "Olympus 40X/0.85, IMT2",
        "lensNA": 0.85,
        "magnification": 40.0,
        "workingDistance": 0.25,
        "immersion": "Air",
    },
    10402: {
        "name": "Olympus 40X/1.30, DApo/340, IMT2, 1-LB356",
        "lensNA": 1.30,
        "magnification": 40.0,
        "workingDistance": 0.12,
        "immersion": "Oil",
        "model": "1-LB356",
        "correction": "Apo",
    },
    10403: {
        "name": "Olympus 40X/1.35, UApo/340, IX70, 1-UB768",
        "lensNA": 1.35,
        "magnification": 40.0,
        "workingDistance": 0.10,
        "immersion": "Oil",
        "model": "1-UB768",
        "correction": "Apo",
    },
    10404: {
        "name": "Olympus 40X/0.85, U Plan Apo, IX70, 1-UB827",
        "lensNA": 0.85,
        "magnification": 40.0,
        "workingDistance": 0.20,
        "immersion": "Air",
        "model": "1-UB827",
        "correction": "PlanApo",
    },
    10405: {
        "name": "Olympus 40X/0.95, Plan Apo, IX70",
        "lensNA": 0.95,
        "magnification": 40.0,
        "workingDistance": 0.14,
        "immersion": "Air",
        "model": "1-UB927",
        "correction": "PlanApo",
    },
    10406: {
        "name": "Olympus 40X/1.0, U Plan Apo, Iris",
        "lensNA": 1.0,
        "magnification": 40.0,
        "immersion": "Oil",
        "model": "1-UB828",
        "correction": "PlanApo",
    },
    10407: {
        "name": "Olympus 40X/0.75, UPlanFl, IX70, 1-UB527",
        "lensNA": 0.75,
        "magnification": 40,
        "immersion": "Air",
        "model": "1-UB527",
        "correction": "PlanFluor",
    },
    10408: {
        "name": "Olympus 40X/0.60, LCPLFL, IX70",
        "lensNA": 0.60,
        "magnification": 40.0,
        "workingDistance": 2.15,
        "immersion": "Air",
        "model": "1-UB347",
    },
    10409: {
        "name": "Olympus 40X/0.60, LCPLFL, Phase, IX70",
        "lensNA": 0.60,
        "magnification": 40.0,
        "workingDistance": 2.15,
        "immersion": "Air",
        "model": "1-UC347",
    },
    10410: {
        "name": "Olympus 40X/1.15, UApo340, IX70",
        "lensNA": 1.15,
        "magnification": 40.0,
        "immersion": "Water",
        "model": "1-UB769",
    },
    10411: {
        "name": "Olympus 40X/0.75, UPlanFl, IX70, Ph2",
        "lensNA": 0.75,
        "magnification": 40,
        "immersion": "Air",
        "model": "1-UC527",
        "correction": "PlanFluor",
    },
    10412: {
        "name": "Olympus 40X/1.35, UApo/340, PSF, IX70",
        "lensNA": 1.35,
        "magnification": 40.0,
        "workingDistance": 0.10,
        "immersion": "Oil",
        "correction": "Apo",
    },
    10413: {
        "name": "Olympus U-Apo 340nm 40X/1.15 Water w/Corr. Collar",
        "lensNA": 1.15,
        "magnification": 40.0,
        "workingDistance": 0.26,
        "immersion": "Water",
        "model": "1-UB769R",
    },
    10414: {
        "name": "Olympus 40X/0.60, LWD U-Plan FL, w/Corr. Collar, UIS2, 1-U2B377",
        "lensNA": 0.60,
        "magnification": 40.0,
        "workingDistance": 2.7,
        "immersion": "Air",
        "model": "1-U2B377",
        "correction": "PlanFluor",
    },
    10415: {
        "name": "Olympus 40X/1.35, U-Apo O340, UIS2, 1-U2B768",
        "lensNA": 1.35,
        "magnification": 40.0,
        "workingDistance": 0.1,
        "immersion": "Oil",
        "model": "1-U2B768",
    },
    10416: {
        "name": "Olympus 40X/1.30, UPLFLN 40XO, U PLAN Fluorite 40X Oil, 1-U2B530",
        "lensNA": 1.30,
        "magnification": 40.0,
        "workingDistance": 0.2,
        "immersion": "Oil",
        "model": "1-U2B530",
    },
    10000: {
        "name": "Olympus 100X/1.30, DApo/340, IMT2",
        "lensNA": 1.30,
        "magnification": 100.0,
        "immersion": "Oil",
        "model": "1-LB393",
        "correction": "Apo",
    },
    10001: {
        "name": "Olympus 100X/1.30, D Plan Apo UV, IMT2",
        "lensNA": 1.30,
        "magnification": 100.0,
        "immersion": "Oil",
        "model": "1-LB392",
        "correction": "UV",
    },
    10002: {
        "name": "Olympus 100X/1.40, Plan Apo, IX70",
        "lensNA": 1.40,
        "magnification": 100.0,
        "workingDistance": 0.10,
        "immersion": "Oil",
        "model": "1-UB935",
        "correction": "PlanApo",
    },
    10003: {
        "name": "Olympus 100X/1.35, U Plan Apo, IX70",
        "lensNA": 1.35,
        "magnification": 100.0,
        "workingDistance": 0.10,
        "immersion": "Oil",
        "model": "1-UB836",
        "correction": "PlanApo",
    },
    10004: {
        "name": "Olympus 100X/1.30, UPLFL",
        "lensNA": 1.30,
        "magnification": 100.0,
        "immersion": "Oil",
        "model": "1-UB535",
    },
    10005: {
        "name": "Olympus 100X/1.35, U Plan Apo, PSF, IX70",
        "lensNA": 1.35,
        "magnification": 100.0,
        "workingDistance": 0.10,
        "immersion": "Oil",
        "correction": "PlanApo",
    },
    10006: {
        "name": "Olympus 100X/1.40, Plan Apo, PSF, IX70",
        "lensNA": 1.40,
        "magnification": 100.0,
        "workingDistance": 0.10,
        "immersion": "Oil",
        "correction": "PlanApo",
    },
    10007: {
        "name": "Olympus 100X/1.40, UPLS Apo, UIS2, 1-U2B836",
        "lensNA": 1.40,
        "magnification": 100.0,
        "workingDistance": 0.13,
        "immersion": "Oil",
        "model": "1-U2B836",
    },
    10008: {
        "name": "Olympus U-Plan Fluorite 100X/1.30",
        "lensNA": 1.30,
        "magnification": 100.0,
        "workingDistance": 0.20,
        "immersion": "Oil",
        "model": "1-U2B5352",
    },
    10009: {
        "name": "Olympus U-Plan Fluorite 100X/0.55-1.30 w/Corr. Collar",
        "lensNA": 1.30,
        "magnification": 100.0,
        "workingDistance": 0.20,
        "immersion": "Oil",
        "model": "1-U2B5362",
    },
    10010: {
        "name": "Olympus PlanApo TIRFM 100X/1.45",
        "lensNA": 1.45,
        "magnification": 100.0,
        "workingDistance": 0.10,
        "immersion": "Oil",
        "model": "1-UB617R",
        "correction": "PlanApo",
    },
    10011: {
        "name": "Olympus U-Apo N TIRF 100X/1.49 w/Corr. Collar",
        "lensNA": 1.49,
        "magnification": 100.0,
        "workingDistance": 0.10,
        "immersion": "Oil",
        "model": "1-U2B725",
    },
    10012: {
        "name": "Olympus 100X/0.95, PLFL, Corr Collar 0.14-0.20, Iris",
        "lensNA": 0.95,
        "magnification": 100.0,
        "workingDistance": 0.20,
        "immersion": "Air",
        "model": "XXXXXXXX",
    },
    11500: {
        "name": "Olympus U-Apo TIRFM 150X/1.45 w/Corr. Collar",
        "lensNA": 1.45,
        "magnification": 150.0,
        "workingDistance": 0.10,
        "immersion": "Oil",
        "model": "1-U2B618",
    },
    10600: {
        "name": "Olympus 60X/1.40, DApo/340, IMT2",
        "lensNA": 1.40,
        "magnification": 60.0,
        "workingDistance": 0.30,
        "immersion": "Oil",
        "correction": "Apo",
    },
    10601: {
        "name": "Olympus 60X/1.40, S Plan Apo, UV/340, IMT2",
        "lensNA": 1.40,
        "magnification": 60.0,
        "immersion": "Oil",
        "model": "1-LB751",
        "correction": "UV",
    },
    10602: {
        "name": "Olympus 60X/1.40, Plan Apo, IX70",
        "lensNA": 1.40,
        "magnification": 60.0,
        "workingDistance": 0.1,
        "immersion": "Oil",
        "model": "1-UB932",
        "correction": "PlanApo",
    },
    10603: {
        "name": "Olympus 60X/1.20, U Plan Apo, IX70",
        "lensNA": 1.20,
        "magnification": 60.0,
        "workingDistance": 0.25,
        "immersion": "Water",
        "model": "1-UB891",
        "correction": "PlanApo",
    },
    10604: {
        "name": "Olympus 60X/1.20, IMT2",
        "lensNA": 1.20,
        "magnification": 60.0,
        "workingDistance": 0.25,
        "immersion": "Water",
    },
    10605: {
        "name": "Olympus 60X/0.70, LCPLPL, IX70",
        "lensNA": 0.70,
        "magnification": 60.0,
        "workingDistance": 1.10,
        "immersion": "Air",
        "model": "1-UB351",
    },
    10606: {
        "name": "Olympus 60X/0.70, LCPLPL, Phase, IX70",
        "lensNA": 0.70,
        "magnification": 60.0,
        "workingDistance": 1.10,
        "immersion": "Air",
        "model": "1-UC351",
    },
    10607: {
        "name": "Olympus 60X/1.40, Plan Apo, Ph3",
        "lensNA": 1.40,
        "magnification": 60.0,
        "immersion": "Oil",
        "model": "1-UC932",
        "correction": "PlanApo",
    },
    10608: {
        "name": "Olympus 60X/1.25, UPLFL",
        "lensNA": 1.25,
        "magnification": 60.0,
        "immersion": "Oil",
        "model": "1-UB532",
    },
    10609: {
        "name": "Olympus 60X/1.40, Plan Apo, BFP-1, IX70",
        "lensNA": 1.40,
        "magnification": 60.0,
        "workingDistance": 0.15,
        "immersion": "Oil",
        "model": "1-UB933",
        "correction": "PlanApo",
    },
    10610: {
        "name": "Olympus 60X/1.40, Plan Apo, PSF, IX70",
        "lensNA": 1.40,
        "magnification": 60.0,
        "workingDistance": 0.15,
        "immersion": "Oil",
        "correction": "PlanApo",
    },
    10611: {
        "name": "Olympus 60X/1.20, U Plan Apo, Water, PSF, IX70",
        "lensNA": 1.20,
        "magnification": 60.0,
        "workingDistance": 0.25,
        "immersion": "Water",
        "correction": "PlanApo",
    },
    10612: {
        "name": "Olympus 60X/1.42, Plan Apo N, UIS2, 1-U2B933",
        "lensNA": 1.42,
        "magnification": 60.0,
        "workingDistance": 0.15,
        "immersion": "Oil",
        "model": "1-U2B933",
        "correction": "PlanApo",
    },
    10613: {
        "name": "Olympus PlanApo TIRFM 60X/1.45 w/Corr. Collar",
        "lensNA": 1.45,
        "magnification": 60.0,
        "workingDistance": 0.10,
        "immersion": "Oil",
        "model": "1-U2B616",
        "correction": "PlanApo",
    },
    10614: {
        "name": "Olympus Apo TIRFM 60X/1.49 w/Corr. Collar",
        "lensNA": 1.49,
        "magnification": 60.0,
        "workingDistance": 0.10,
        "immersion": "Oil",
        "model": "1-U2B617",
    },
    10615: {
        "name": "Olympus 60X/1.30, U-Apo N, Sil FV UIS2, PSF, w/Corr. Collar",
        "lensNA": 1.30,
        "magnification": 60.0,
        "workingDistance": 0.30,
        "immersion": "Other",
    },
    10616: {
        "name": "Olympus 60X/1.20, U-Plan S-Apo PSF, UIS2, 1-U2B893S",
        "lensNA": 1.20,
        "magnification": 60.0,
        "workingDistance": 0.28,
        "immersion": "Water",
        "model": "1-U2B893S",
    },
    10617: {
        "name": "Olympus 60X/1.49, APON 60XOTIRF, UIS2, 1-U2B720",
        "lensNA": 1.49,
        "magnification": 60.0,
        "workingDistance": 0.10,
        "immersion": "Oil",
        "model": "1-U2B720",
    },
    12201: {
        "name": "Nikon 20X/0.75, Plan Apo, CFI/60",
        "lensNA": 0.75,
        "magnification": 20.0,
        "workingDistance": 1.0,
        "immersion": "Air",
        "model": "93104",
        "correction": "PlanApo",
    },
    12202: {
        "name": "Nikon 20X/0.75, Plan Fluor, DIC M, CFI/60",
        "lensNA": 0.75,
        "magnification": 20.0,
        "immersion": "Multi",
        "model": "93146",
        "correction": "PlanFluor",
    },
    12203: {
        "name": "Nikon 20X/0.45, Plan Fluor ELWD, CFI/60",
        "lensNA": 0.45,
        "magnification": 20.0,
        "workingDistance": 7.4,
        "immersion": "Air",
        "model": "93150",
        "correction": "PlanFluor",
    },
    12204: {
        "name": "Nikon 20X/0.45, LU Plan EPI P, CFI/60",
        "lensNA": 0.45,
        "magnification": 20.0,
        "workingDistance": 4.50,
        "immersion": "Air",
        "model": "MUE01200/92777",
    },
    12205: {
        "name": "Nikon 20X/0.50, Plan Fluor, CFI/60",
        "lensNA": 0.50,
        "magnification": 20.0,
        "workingDistance": 2.10,
        "immersion": "Air",
        "model": "MRH00200/93135",
        "correction": "PlanFluor",
    },
    12206: {
        "name": "Nikon 20X/0.45, Plan Fluor, ELWD, Corr Collar 0-2.0, CFI/60",
        "lensNA": 0.45,
        "magnification": 20.0,
        "workingDistance": 7.00,
        "immersion": "Air",
        "model": "MRH08230",
        "correction": "PlanFluor",
    },
    12207: {
        "name": "Nikon 20X/0.75, Plan Apo, CFI/60",
        "lensNA": 0.75,
        "magnification": 20.0,
        "workingDistance": 1.00,
        "immersion": "Air",
        "model": "MRD00201, MRD00205",
        "correction": "PlanApo",
    },
    12208: {
        "name": "Nikon 20X/0.75, Super Fluor, CFI/60",
        "lensNA": 0.75,
        "magnification": 20.0,
        "workingDistance": 1.00,
        "immersion": "Air",
        "correction": "SuperFluor",
    },
    12401: {
        "name": "Nikon 40X/1.30, PlanFluar, 160mm tube length",
        "lensNA": 1.30,
        "magnification": 40.0,
        "workingDistance": 0.16,
        "immersion": "Oil",
        "model": "85028",
    },
    12402: {
        "name": "Nikon 40X/1.30, CF Fluor, 160mm tube length",
        "lensNA": 1.30,
        "magnification": 40.0,
        "workingDistance": 0.22,
        "immersion": "Oil",
        "model": "85004",
    },
    12403: {
        "name": "Nikon 40X/0.75, CF Fluor, 160mm tube length",
        "lensNA": 0.75,
        "magnification": 40.0,
        "immersion": "Air",
        "model": "140508",
    },
    12404: {
        "name": "Nikon 40X/1.30, S Fluor, CFI/60",
        "lensNA": 1.30,
        "magnification": 40.0,
        "workingDistance": 0.22,
        "immersion": "Oil",
    },
    12405: {
        "name": "Nikon 40X/0.95, Plan Apo, DIC M, CFI/60",
        "lensNA": 0.95,
        "magnification": 40.0,
        "immersion": "Air",
        "correction": "PlanApo",
    },
    12406: {
        "name": "Nikon 40X/1.00, DIC H, CFI/60",
        "lensNA": 1.00,
        "magnification": 40.0,
        "workingDistance": 0.16,
        "immersion": "Oil",
    },
    12407: {
        "name": "Nikon 40X/0.60, Plan Fluor, ELWD, Corr Collar, CFI/60",
        "lensNA": 0.60,
        "magnification": 40.0,
        "workingDistance": 3.2,
        "immersion": "Air",
        "correction": "PlanFluor",
    },
    12408: {
        "name": "Nikon 40X/0.60, Plan Fluor, ELWD, Corr Collar 0-2.0, CFI/60",
        "lensNA": 0.60,
        "magnification": 40.0,
        "workingDistance": 2.7,
        "immersion": "Air",
        "model": "MRH08430",
        "correction": "PlanFluor",
    },
    12409: {
        "name": "Nikon 40X/0.95, Plan Apo, Corr Collar 0.11-0.23, CFI/60",
        "lensNA": 0.95,
        "magnification": 40.0,
        "workingDistance": 0.14,
        "immersion": "Air",
        "model": "MRD00400",
        "correction": "PlanApo",
    },
    12410: {
        "name": "Nikon 40X/0.65, Plan Apo, NCG, CFI/60",
        "lensNA": 0.65,
        "magnification": 40.0,
        "workingDistance": 0.48,
        "immersion": "Air",
        "correction": "PlanApo",
    },
    12411: {
        "name": "Nikon 40X/0.95, Plan Apo, Corr Collar 0.11-0.23, CFI/60 Lambda",
        "lensNA": 0.95,
        "magnification": 40.0,
        "workingDistance": 0.14,
        "immersion": "Air",
        "model": "MRD00405",
        "correction": "PlanApo",
    },
    12412: {
        "name": "Nikon 40X/0.90, S Fluor, Corr Collar 0.11-0.23, CFI/60 Lambda",
        "lensNA": 0.90,
        "magnification": 40.0,
        "workingDistance": 0.30,
        "immersion": "Air",
        "model": "MRF00400",
    },
    12413: {
        "name": "Nikon 40X/0.75, Plan Fluor, CFI/60 Lambda",
        "lensNA": 0.75,
        "magnification": 40.0,
        "workingDistance": 0.66,
        "immersion": "Air",
        "correction": "PlanFluor",
    },
    12600: {
        "name": "Nikon 60X/1.40, CF N Plan Apochromat, 160mm tube length",
        "lensNA": 1.40,
        "magnification": 60.0,
        "workingDistance": 0.17,
        "immersion": "Oil",
        "model": "85020",
        "correction": "PlanApo",
    },
    12601: {
        "name": "Nikon 60X/1.40, Plan Apo, DIC H",
        "lensNA": 1.40,
        "magnification": 60.0,
        "workingDistance": 0.21,
        "immersion": "Oil",
        "model": "93108",
        "correction": "PlanApo",
    },
    12602: {
        "name": "Nikon 60X/1.20, Plan Apo, WI (Water), DIC H, CFI/60",
        "lensNA": 1.20,
        "magnification": 60.0,
        "workingDistance": 0.22,
        "immersion": "Water",
        "model": "93109",
        "correction": "PlanApo",
    },
    12603: {
        "name": "Nikon 60X/0.95, Plan Apo, Corr Collar 0.11-0.23, CFI/60",
        "lensNA": 0.95,
        "magnification": 60.0,
        "workingDistance": 0.15,
        "immersion": "Air",
        "model": "MRD00600",
        "correction": "PlanApo",
    },
    12604: {
        "name": "Nikon 60X/0.70, Plan Fluor, ELWD, Corr Collar 0.5-1.5, CFI/60",
        "lensNA": 0.70,
        "magnification": 60.0,
        "workingDistance": 1.5,
        "immersion": "Air",
        "model": "MRH08630",
        "correction": "PlanFluor",
    },
    12605: {
        "name": "Nikon 60X/0.95, Plan Apo, Corr Collar 0.11-0.23, CFI/60 Lambda",
        "lensNA": 0.95,
        "magnification": 60.0,
        "workingDistance": 0.15,
        "immersion": "Air",
        "model": "MRD00605",
        "correction": "PlanApo",
    },
    12606: {
        "name": "Nikon 60X/0.85, Plan Fluor, Corr Collar 0.11-0.23, CFI/60 Lambda",
        "lensNA": 0.85,
        "magnification": 60.0,
        "workingDistance": 0.30,
        "immersion": "Air",
        "model": "MRH00602",
        "correction": "PlanFluor",
    },
    12000: {
        "name": "Nikon 100X/1.40, CF N Plan Apochromat, 160mm tube length",
        "lensNA": 1.40,
        "magnification": 100.0,
        "workingDistance": 0.1,
        "immersion": "Oil",
        "model": "85025",
        "correction": "PlanApo",
    },
    12001: {
        "name": "Nikon 100X/1.30, CF Fluor, 160mm tube length",
        "lensNA": 1.30,
        "magnification": 100.0,
        "workingDistance": 0.14,
        "immersion": "Oil",
        "model": "85005",
    },
    12002: {
        "name": "Nikon 100X/1.30, CF UV F, 160mm tube length",
        "lensNA": 1.30,
        "magnification": 100.0,
        "workingDistance": 0.13,
        "immersion": "Glycerol",
        "model": "78821",
        "correction": "UV",
    },
    12003: {
        "name": "Nikon 100X/1.40, Plan Apo, DIC H, CFI/60",
        "lensNA": 1.40,
        "magnification": 100.0,
        "workingDistance": 0.13,
        "immersion": "Oil",
        "model": "93110",
        "correction": "PlanApo",
    },
    12004: {
        "name": "Nikon 100X/0.5-1.30, S Fluor, Oil Iris, CFI 60",
        "lensNA": 1.30,
        "magnification": 100.0,
        "workingDistance": 0.20,
        "immersion": "Oil",
        "model": "93129",
    },
    12005: {
        "name": "Nikon 100X/0.90, Plan Fluor, Corr Collar 0.14-0.20, CFI 60",
        "lensNA": 0.90,
        "magnification": 100.0,
        "workingDistance": 0.30,
        "immersion": "Air",
        "model": "MRH00900",
        "correction": "PlanFluor",
    },
    12101: {
        "name": "Nikon 2X/0.10, Plan Apo, 160mm tube length",
        "lensNA": 0.10,
        "magnification": 2.0,
        "immersion": "Air",
        "model": "202294",
        "correction": "PlanApo",
    },
    12102: {
        "name": "Nikon 4X/0.20, Plan Apo, 160mm tube length",
        "lensNA": 0.20,
        "magnification": 4.0,
        "immersion": "Air",
        "model": "108388",
        "correction": "PlanApo",
    },
    12103: {
        "name": "Nikon 4X/0.20, Plan Apo, CFI/60",
        "lensNA": 0.2,
        "magnification": 4.0,
        "workingDistance": 15.7,
        "immersion": "Air",
        "model": "93102",
        "correction": "PlanApo",
    },
    12104: {
        "name": "Nikon 10X/0.45, Plan Apo, CFI/60",
        "lensNA": 0.45,
        "magnification": 10.0,
        "workingDistance": 4.0,
        "immersion": "Air",
        "model": "93103",
        "correction": "PlanApo",
    },
    12105: {
        "name": "Nikon 10X/0.30, Plan Fluor, CFI/60",
        "lensNA": 0.30,
        "magnification": 10.0,
        "workingDistance": 16.0,
        "immersion": "Air",
        "model": "93134",
        "correction": "PlanFluor",
    },
    12106: {
        "name": "Nikon 10X/0.50, Super Fluor, CFI/60",
        "lensNA": 0.50,
        "magnification": 10.0,
        "workingDistance": 1.20,
        "immersion": "Air",
        "model": "MRF00100/93126",
        "correction": "SuperFluor",
    },
    12107: {
        "name": "Nikon 10X/0.25, Plan Achromat, CFI/60",
        "lensNA": 0.25,
        "magnification": 10.0,
        "workingDistance": 10.5,
        "immersion": "Air",
        "model": "93183",
        "correction": "Achromat",
    },
    12108: {
        "name": "Nikon 10X/0.25, Achromat Flatfield, CFI/60",
        "lensNA": 0.25,
        "magnification": 10.0,
        "workingDistance": 6.10,
        "immersion": "Air",
        "model": "93161",
        "correction": "Achromat",
    },
    12109: {
        "name": "Nikon 2X/0.10, Plan Apo, CFI/60",
        "lensNA": 0.1,
        "magnification": 2.0,
        "workingDistance": 8.50,
        "immersion": "Air",
        "model": "MRD00020, MRD00025",
        "correction": "PlanApo",
    },
    12110: {
        "name": "Nikon 4X/0.20, Plan Apo, CFI/60",
        "lensNA": 0.2,
        "magnification": 4.0,
        "workingDistance": 20.0,
        "immersion": "Air",
        "model": "MRD00041, MRD00045",
        "correction": "PlanApo",
    },
    12111: {
        "name": "Nikon 10X/0.45, Plan Apo, CFI/60",
        "lensNA": 0.45,
        "magnification": 10.0,
        "workingDistance": 4.00,
        "immersion": "Air",
        "model": "MRD00101, MRD00105",
        "correction": "PlanApo",
    },
    14001: {
        "name": "Zeiss 100X/1.40, Plan - APOCHROMAT",
        "lensNA": 1.40,
        "magnification": 100.0,
        "workingDistance": 0.1,
        "immersion": "Oil",
        "model": "44 07 08 (02)",
        "correction": "PlanApo",
    },
    14002: {
        "name": "Zeiss 100X/1.30, Oil Iris (0.8 - 1.30)",
        "lensNA": 1.30,
        "magnification": 100.0,
        "workingDistance": 0.1,
        "immersion": "Oil",
        "model": "44 07 86",
    },
    14003: {
        "name": "Zeiss 100X/1.40, Plan - APOCHROMAT",
        "lensNA": 1.40,
        "magnification": 100,
        "immersion": "Oil",
        "model": "44 07 80 (02)",
        "correction": "PlanApo",
    },
    14004: {
        "name": "Zeiss 100X/1.30, Planapo, 160mm tube length",
        "lensNA": 1.30,
        "magnification": 100.0,
        "immersion": "Oil",
        "model": "46 19 46 - 9903",
        "correction": "PlanApo",
    },
    14005: {
        "name": "Zeiss 100X/1.40, Oil Iris (0.7 - 1.40)",
        "lensNA": 1.40,
        "magnification": 100.0,
        "immersion": "Oil",
        "model": "44 07 86 (02)",
    },
    14006: {
        "name": "Zeiss 100X/1.30",
        "lensNA": 1.30,
        "magnification": 100.0,
        "immersion": "Oil",
    },
    14601: {
        "name": "Zeiss 63X/1.40, Plan - APOCHROMAT",
        "lensNA": 1.40,
        "magnification": 63.0,
        "workingDistance": 0.09,
        "immersion": "Oil",
        "model": "44 07 60 (03)",
        "correction": "PlanApo",
    },
    14602: {
        "name": "Zeiss 63X/1.40, Plan - APOCHROMAT, DIC",
        "lensNA": 1.40,
        "magnification": 63.0,
        "workingDistance": 0.09,
        "immersion": "Oil",
        "model": "44 07 62 (02)",
        "correction": "PlanApo",
    },
    14603: {
        "name": "Zeiss 63X/0.90, Achroplan, W, Ph3",
        "lensNA": 0.90,
        "magnification": 63.0,
        "immersion": "Water",
        "model": "44 00 69",
    },
    14604: {
        "name": "Zeiss 63X/1.20, C - APOCHROMAT, Water",
        "lensNA": 1.20,
        "magnification": 63.0,
        "workingDistance": 0.09,
        "immersion": "Water",
        "model": "44 06 68",
        "correction": "Apo",
    },
    14401: {
        "name": "Zeiss 40X/1.30, FLUAR",
        "lensNA": 1.30,
        "magnification": 40.0,
        "workingDistance": 0.14,
        "immersion": "Oil",
        "model": "44 02 55 (01)",
        "correction": "Fluar",
    },
    14402: {
        "name": "Zeiss 40X/1.00, Plan - APOCHROMAT, Phase3",
        "lensNA": 1.00,
        "magnification": 40.0,
        "immersion": "Oil",
        "model": "44 07 51",
        "correction": "PlanApo",
    },
    14403: {
        "name": "Zeiss 40X/1.20, Water Immersion, Corr Collar, C - APOCHROMAT",
        "lensNA": 1.20,
        "magnification": 40.0,
        "immersion": "Water",
        "model": "44 00 52",
        "correction": "Apo",
    },
    14404: {
        "name": "Zeiss 40X/0.75, Plan - NEOFLUAR, Phase2",
        "lensNA": 0.75,
        "magnification": 40.0,
        "immersion": "Air",
        "model": "44 03 51",
        "correction": "PlanNeofluar",
    },
    14405: {
        "name": "Zeiss 40X/1.30, Plan - NEOFLUAR",
        "lensNA": 1.30,
        "magnification": 40.0,
        "workingDistance": 0.15,
        "immersion": "Oil",
        "model": "44 04 50",
        "correction": "PlanNeofluar",
    },
    14406: {
        "name": "Zeiss 40X/0.60, LD ACHROPLAN, Phase2",
        "lensNA": 0.60,
        "magnification": 40.0,
        "immersion": "Air",
        "model": "44 08 65",
    },
    14407: {
        "name": "Zeiss 40X/1.30, Plan - NEOFLUAR, DIC, Strainfree",
        "lensNA": 1.30,
        "magnification": 40.0,
        "immersion": "Oil",
        "correction": "PlanNeofluar",
    },
    14301: {
        "name": "Zeiss 25X/0.80, Plan - NEOFLUAR",
        "lensNA": 0.80,
        "magnification": 25.0,
        "workingDistance": 0.80,
        "immersion": "Multi",
        "model": "44 05 44",
        "correction": "PlanNeofluar",
    },
    14302: {
        "name": "Zeiss 25X/0.80, Plan - NEOFLUAR, DIC",
        "lensNA": 0.80,
        "magnification": 25.0,
        "workingDistance": 0.80,
        "immersion": "Multi",
        "model": "44 05 42",
        "correction": "PlanNeofluar",
    },
    14303: {
        "name": "Zeiss 25X/0.80, Plan - NEOFLUAR, Phase2",
        "lensNA": 0.80,
        "magnification": 25.0,
        "immersion": "Air",
        "model": "44 05 45",
        "correction": "PlanNeofluar",
    },
    14201: {
        "name": "Zeiss 20X/0.50, Plan - NEOFLUAR, Phase2",
        "lensNA": 0.50,
        "magnification": 20.0,
        "immersion": "Air",
        "model": "44 03 41 (01)",
        "correction": "PlanNeofluar",
    },
    14202: {
        "name": "Zeiss 20X/0.60, Plan - APOCHROMAT",
        "lensNA": 0.60,
        "magnification": 20.0,
        "immersion": "Air",
        "model": "44 06 40",
        "correction": "PlanApo",
    },
    14203: {
        "name": "Zeiss 20X/0.75, PLAN APO",
        "lensNA": 0.75,
        "magnification": 20.0,
        "immersion": "Air",
        "model": "44 06 49",
        "correction": "PlanApo",
    },
    14204: {
        "name": "Zeiss 20X/0.75, Fluar",
        "lensNA": 0.75,
        "magnification": 20.0,
        "immersion": "Air",
        "model": "44 01 45",
        "correction": "Fluar",
    },
    14101: {
        "name": "Zeiss 10X/0.30, Plan - NEOFLUAR",
        "lensNA": 0.30,
        "magnification": 10.0,
        "immersion": "Air",
        "model": "44 03 30",
        "correction": "PlanNeofluar",
    },
    14102: {
        "name": "Zeiss 10X/0.25, Acrostigmat",
        "lensNA": 0.25,
        "magnification": 10.0,
        "immersion": "Air",
        "model": "44 01 31",
    },
    14103: {
        "name": "Zeiss 10X/0.25, Achroplan, Phase1",
        "lensNA": 0.25,
        "magnification": 10.0,
        "immersion": "Air",
        "model": "44 00 31",
    },
    14104: {
        "name": "Zeiss 10X/0.45, Plan - ApoChromat",
        "lensNA": 0.45,
        "magnification": 10.0,
        "immersion": "Air",
        "model": "44 06 39",
        "correction": "PlanApo",
    },
    14105: {
        "name": "Zeiss 5X/0.16, Plan - ApoChromat",
        "lensNA": 0.16,
        "magnification": 5.0,
        "immersion": "Air",
        "model": "44 06 20",
        "correction": "PlanApo",
    },
    18101: {
        "name": "API 4X, Plan Apo, AWCE",
        "lensNA": 0.20,
        "magnification": 4.0,
        "workingDistance": 3.33,
        "immersion": "Air",
        "correction": "PlanApo",
    },
    18102: {
        "name": "API 2.5X, Plan Apo, AWe",
        "lensNA": 0.20,
        "magnification": 2.46,
        "workingDistance": 2.883,
        "immersion": "Air",
        "correction": "PlanApo",
    },
    18103: {
        "name": "API 4X, Plan Apo, AWe",
        "lensNA": 0.20,
        "magnification": 4.0,
        "workingDistance": 2.883,
        "immersion": "Air",
        "correction": "PlanApo",
    },
    18104: {
        "name": "API 6X, Plan Apo, AWe",
        "lensNA": 0.45,
        "magnification": 6.15,
        "workingDistance": 2.883,
        "immersion": "Air",
        "correction": "PlanApo",
    },
    18105: {
        "name": "API 10X, Plan Apo, AWe, CW",
        "lensNA": 0.45,
        "magnification": 10.0,
        "workingDistance": 2.883,
        "immersion": "Air",
        "correction": "PlanApo",
    },
    18106: {
        "name": "API 1X, DIGE",
        "lensNA": 0.1,
        "magnification": 1.0,
        "workingDistance": 24.00,
        "immersion": "Air",
    },
    18107: {
        "name": "API 10X, BH",
        "lensNA": 0.15,
        "magnification": 10.0,
        "workingDistance": 15.00,
        "immersion": "Air",
        "correction": "PlanFluor",
        "manufacturer": "Nikon",
    },
    18108: {
        "name": "= 20.0,",
        "lensNA": 0.75,
        "correction": "PlanApo",
        "manufacturer": "Nikon",
    },
    18109: {
        "name": "= 40.0,",
        "lensNA": 0.95,
        "correction": "PlanApo",
        "manufacturer": "Nikon",
    },
    18110: {
        "name": "= 40.0,",
        "lensNA": 0.60,
        "correction": "PlanFluor",
        "manufacturer": "Nikon",
    },
    18111: {
        "name": "= 4.0,",
        "lensNA": 0.20,
        "correction": "PlanApo",
        "manufacturer": "Nikon",
    },
    18201: {
        "name": "API 20X, HiRes A, CW",
        "lensNA": 0.55,
        "magnification": 20.0,
        "workingDistance": 13.00,
        "immersion": "Air",
    },
    18202: {
        "name": "API 20X, HiRes B, CW",
        "lensNA": 0.50,
        "magnification": 20.0,
        "workingDistance": 13.00,
        "immersion": "Air",
    },
    18204: {
        "name": "API 20X, HiRes C, CW",
        "lensNA": 0.45,
        "magnification": 20.0,
        "workingDistance": 4.50,
        "immersion": "Air",
        "model": "MUE01200/92777",
    },
    18205: {
        "name": "API 20X, HiRes D, CW",
        "lensNA": 0.50,
        "magnification": 20.0,
        "workingDistance": 2.10,
        "immersion": "Air",
        "model": "MRH00200/93135",
    },
    18206: {
        "name": "API 20X, HiRes, MF",
        "lensNA": 0.55,
        "magnification": 20.0,
        "workingDistance": 2.10,
        "immersion": "Air",
    },
    18207: {
        "name": "API 20X, DF",
        "lensNA": 0.45,
        "magnification": 20.0,
        "workingDistance": 7.40,
        "immersion": "Air",
    },
    18208: {
        "name": "API 20X",
        "lensNA": 0.75,
        "magnification": 20.0,
        "workingDistance": 1.00,
        "immersion": "Air",
    },
    18401: {
        "name": "API 40X, NCG",
        "lensNA": 0.65,
        "magnification": 40.0,
        "workingDistance": 0.48,
        "immersion": "Air",
    },
    20007: {
        "name": "Applied Precision 100X/1.4",
        "lensNA": 1.4,
        "magnification": 100.0,
        "immersion": "Oil",
        "manufacturer": "Applied Precision",
    },
    1: {
        "name": "Zeiss 10X/.25",
        "lensNA": 0.25,
        "magnification": 10.0,
        "immersion": "Air",
        "manufacturer": "Zeiss",
    },
    2: {
        "name": "Zeiss 25X/.50",
        "lensNA": 0.50,
        "magnification": 25.0,
        "immersion": "Air",
        "manufacturer": "Zeiss",
    },
    3: {
        "name": "Zeiss 50X/1.00",
        "lensNA": 1.00,
        "magnification": 50.0,
        "immersion": "Oil",
        "manufacturer": "Zeiss",
    },
    4: {
        "name": "Zeiss 63X/1.25",
        "lensNA": 1.25,
        "magnification": 63.0,
        "immersion": "Oil",
        "manufacturer": "Zeiss",
    },
    5: {
        "name": "Zeiss 100X/1.30",
        "lensNA": 1.30,
        "magnification": 100.0,
        "immersion": "Oil",
        "manufacturer": "Zeiss",
    },
    6: {
        "name": "Neofluor 100X/1.30",
        "lensNA": 1.30,
        "magnification": 100.0,
        "immersion": "Oil",
        "correction": "Neofluor",
    },
    7: {
        "name": "Leitz Plan Apo Brightfield",
        "lensNA": 1.40,
        "magnification": 63.0,
        "immersion": "Oil",
        "correction": "PlanApo",
        "manufacturer": "Leitz",
    },
    8: {
        "name": "Coverslip-less water immersion",
        "lensNA": 1.20,
        "magnification": 63.0,
        "immersion": "Water",
    },
    9: {
        "name": "Olympus 10X/0.40",
        "lensNA": 0.40,
        "magnification": 10.0,
        "workingDistance": 0.30,
        "immersion": "Air",
        "manufacturer": "Olympus",
    },
    10: {
        "name": "Olympus 20X/0.80",
        "lensNA": 0.80,
        "magnification": 20.0,
        "workingDistance": 0.30,
        "immersion": "Oil",
        "manufacturer": "Olympus",
    },
    11: {
        "name": "Olympus 40X/1.30",
        "lensNA": 1.30,
        "magnification": 40.0,
        "workingDistance": 0.30,
        "immersion": "Oil",
        "manufacturer": "Olympus",
    },
    12: {
        "name": "Olympus 60X/1.40",
        "lensNA": 1.40,
        "magnification": 60.0,
        "workingDistance": 0.30,
        "immersion": "Oil",
        "manufacturer": "Olympus",
    },
    13: {
        "name": "Nikon 100X/1.40",
        "lensNA": 1.40,
        "magnification": 100.0,
        "workingDistance": 0.30,
        "immersion": "Oil",
        "manufacturer": "Nikon",
    },
}
