import iam = require('@aws-cdk/aws-iam');
import kms = require('@aws-cdk/aws-kms');
import lambda = require('@aws-cdk/aws-lambda');
import cdk = require('@aws-cdk/core');
/**
 * @stability stable
 */
export declare enum KeyLength {
    /**
     * @stability stable
     */
    L2048 = 2048,
    /**
     * @stability stable
     */
    L4096 = 4096
}
/**
 * Definition of EC2 Key Pair.
 *
 * @stability stable
 */
export interface KeyPairProps extends cdk.ResourceProps {
    /**
     * Name of the Key Pair.
     *
     * In AWS Secrets Manager the key will be prefixed with `ec2-private-key/`.
     *
     * The name can be up to 255 characters long. Valid characters include _, -, a-z, A-Z, and 0-9.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * The description for the key in AWS Secrets Manager.
     *
     * @default - ''
     * @stability stable
     */
    readonly description?: string;
    /**
     * Number of bits in the key.
     *
     * Valid options are 2048 and 4096
     *
     * @default - 2048
     * @stability stable
     */
    readonly keyLength?: KeyLength;
    /**
     * The KMS key to use to encrypt the private key with.
     *
     * This needs to be a key created in the same stack. You cannot use a key imported via ARN.
     *
     * @default - `alias/aws/secretsmanager`
     * @stability stable
     */
    readonly kms?: kms.Key;
    /**
     * Tags that will be applied to the private key in the AWS Secrets Manager.
     *
     * EC2 Key Pairs themselves don't support tags
     *
     * @default - `alias/aws/secretsmanager`
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    };
    /**
     * When the resource is destroyed, after how many days the private key in the AWS Secrets Manager should be deleted.
     *
     * Valid values are 0 and 7 to 30
     *
     * @default 0
     * @stability stable
     */
    readonly removePrivateKeyAfterDays?: number;
    /**
     * Prefix for the secret in AWS Secrets Manager.
     *
     * @default `ec2-private-key/`
     * @stability stable
     */
    readonly secretPrefix?: string;
    /**
     * A prefix for all resource names.
     *
     * By default all resources are prefixed with the stack name to avoid collisions with other stacks. This might cause problems when you work with long stack names and can be overridden through this parameter.
     *
     * @default Name of the stack
     * @stability stable
     */
    readonly resourcePrefix?: string;
}
/**
 * An EC2 Key Pair.
 *
 * @stability stable
 */
export declare class KeyPair extends cdk.Construct implements cdk.ITaggable {
    /**
     * The lambda function that is created.
     *
     * @stability stable
     */
    readonly lambda: lambda.IFunction;
    /**
     * ARN of the private key in AWS Secrets Manager.
     *
     * @stability stable
     */
    readonly arn: string;
    /**
     * Name of the Key Pair.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Resource tags.
     *
     * @stability stable
     */
    readonly tags: cdk.TagManager;
    /**
     * @stability stable
     */
    readonly prefix: string;
    /**
     * Defines a new EC2 Key Pair.
     *
     * The private key will be stored in AWS Secrets Manager
     *
     * @stability stable
     */
    constructor(scope: cdk.Construct, id: string, props: KeyPairProps);
    private ensureLambda;
    /**
     * Grants read access to the private key in AWS Secrets Manager.
     *
     * @stability stable
     */
    grantRead(grantee: iam.IGrantable): iam.Grant;
}
