import { IDependable, IResource } from '@aws-cdk/core';
import { IConnectable } from './connections';
/**
 * A client VPN endpoint.
 *
 * @stability stable
 */
export interface IClientVpnEndpoint extends IResource, IConnectable {
    /**
     * The endpoint ID.
     *
     * @stability stable
     */
    readonly endpointId: string;
    /**
     * Dependable that can be depended upon to force target networks associations.
     *
     * @stability stable
     */
    readonly targetNetworksAssociated: IDependable;
}
/**
 * A connection handler for client VPN endpoints.
 *
 * @stability stable
 */
export interface IClientVpnConnectionHandler {
    /**
     * The name of the function.
     *
     * @stability stable
     */
    readonly functionName: string;
    /**
     * The ARN of the function.
     *
     * @stability stable
     */
    readonly functionArn: string;
}
/**
 * Transport protocol for client VPN.
 *
 * @stability stable
 */
export declare enum TransportProtocol {
    /**
     * Transmission Control Protocol (TCP).
     *
     * @stability stable
     */
    TCP = "tcp",
    /**
     * User Datagram Protocol (UDP).
     *
     * @stability stable
     */
    UDP = "udp"
}
/**
 * Port for client VPN.
 *
 * @stability stable
 */
export declare enum VpnPort {
    /**
     * HTTPS.
     *
     * @stability stable
     */
    HTTPS = 443,
    /**
     * OpenVPN.
     *
     * @stability stable
     */
    OPENVPN = 1194
}
