"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TemplateAssertions = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("@aws-cdk/core");
const assert = require("./vendored/assert");
/**
 * (experimental) Suite of assertions that can be run on a CDK stack.
 *
 * Typically used, as part of unit tests, to validate that the rendered
 * CloudFormation template has expected resources and properties.
 *
 * @experimental
 */
class TemplateAssertions {
    constructor(template) {
        this.inspector = new assert.StackInspector(template);
    }
    /**
     * (experimental) Base your assertions on the CloudFormation template synthesized by a CDK `Stack`.
     *
     * @param stack the CDK Stack to run assertions on.
     * @experimental
     */
    static fromStack(stack) {
        return new TemplateAssertions(toTemplate(stack));
    }
    /**
     * (experimental) Base your assertions from an existing CloudFormation template formatted as a nested set of records.
     *
     * @param template the CloudFormation template formatted as a nested set of records.
     * @experimental
     */
    static fromTemplate(template) {
        return new TemplateAssertions(template);
    }
    /**
     * (experimental) Base your assertions from an existing CloudFormation template formatted as a string.
     *
     * @param template the CloudFormation template in.
     * @experimental
     */
    static fromString(template) {
        return new TemplateAssertions(JSON.parse(template));
    }
    /**
     * (experimental) Assert that the given number of resources of the given type exist in the template.
     *
     * @param type the resource type;
     * @param count number of expected instances.
     * @experimental
     */
    resourceCountIs(type, count) {
        const assertion = assert.countResources(type, count);
        assertion.assertOrThrow(this.inspector);
    }
    /**
     * (experimental) Assert that a resource of the given type and properties exists in the CloudFormation template.
     *
     * @param type the resource type;
     * @param props the 'Properties' section of the resource as should be expected in the template.
     * @experimental
     */
    hasResourceProperties(type, props) {
        const assertion = assert.haveResource(type, props, assert.ResourcePart.Properties);
        assertion.assertOrThrow(this.inspector);
    }
    /**
     * (experimental) Assert that a resource of the given type and given definition exists in the CloudFormation template.
     *
     * @param type the resource type;
     * @param props the entire defintion of the resource as should be expected in the template.
     * @experimental
     */
    hasResourceDefinition(type, props) {
        const assertion = assert.haveResource(type, props, assert.ResourcePart.CompleteDefinition);
        assertion.assertOrThrow(this.inspector);
    }
    /**
     * (experimental) Assert that the CloudFormation template matches the given value.
     *
     * @param expected the expected CloudFormation template as key-value pairs.
     * @experimental
     */
    templateMatches(expected) {
        const assertion = assert.matchTemplate(expected);
        assertion.assertOrThrow(this.inspector);
    }
}
exports.TemplateAssertions = TemplateAssertions;
_a = JSII_RTTI_SYMBOL_1;
TemplateAssertions[_a] = { fqn: "@aws-cdk/assertions.TemplateAssertions", version: "1.110.1" };
function toTemplate(stack) {
    const root = stack.node.root;
    if (!core_1.Stage.isStage(root)) {
        throw new Error('unexpected: all stacks must be part of a Stage or an App');
    }
    const assembly = root.synth();
    return assembly.getStackArtifact(stack.artifactId).template;
}
//# sourceMappingURL=data:application/json;base64,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