/*
 * Decompiled with CFR 0.152.
 */
package utils;

import config.Config;
import java.math.BigInteger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u000e\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004J\u000e\u0010\t\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\n\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007J\u0018\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u000e\u0010\u000e\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0004\u00a8\u0006\u000f"}, d2={"Lutils/SignUtilities;", "", "()V", "arbitraryPrecisionIntegerRepresentation", "Ljava/math/BigInteger;", "value", "bitWidth", "", "arbitraryPrecisionIntegerRepresentationFromCurrentVM", "maxSignedValueOfBitwidth", "maxUnsignedValueOfBitwidth", "minSignedValueOfBitwidth", "twosComplementRepresentation", "original", "twosComplementRepresentationForCurrentVM", "Shared"})
@SourceDebugExtension(value={"SMAP\nSignUtilities.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SignUtilities.kt\nutils/SignUtilities\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,64:1\n1#2:65\n*E\n"})
public final class SignUtilities {
    @NotNull
    public static final SignUtilities INSTANCE = new SignUtilities();

    private SignUtilities() {
    }

    @NotNull
    public final BigInteger twosComplementRepresentationForCurrentVM(@NotNull BigInteger original) {
        Intrinsics.checkNotNullParameter(original, "original");
        return this.twosComplementRepresentation(original, Config.INSTANCE.getVMConfig().getRegisterBitwidth());
    }

    private final BigInteger twosComplementRepresentation(BigInteger original, int bitWidth) {
        BigInteger bigInteger;
        if (!(original.bitLength() < bitWidth)) {
            boolean bl = false;
            String string = "Cannot fit " + original + " into a " + bitWidth + "-bit bitvector";
            throw new IllegalArgumentException(string.toString());
        }
        if (original.compareTo(BigInteger.ZERO) < 0) {
            BigInteger bigInteger2 = BigInteger.TWO.pow(bitWidth);
            Intrinsics.checkNotNullExpressionValue(bigInteger2, "TWO.pow(bitWidth)");
            BigInteger bigInteger3 = bigInteger2.add(original);
            bigInteger = bigInteger3;
            Intrinsics.checkNotNullExpressionValue(bigInteger3, "this.add(other)");
        } else {
            bigInteger = original;
        }
        return bigInteger;
    }

    @NotNull
    public final BigInteger arbitraryPrecisionIntegerRepresentationFromCurrentVM(@NotNull BigInteger value2) {
        Intrinsics.checkNotNullParameter(value2, "value");
        return this.arbitraryPrecisionIntegerRepresentation(value2, Config.INSTANCE.getVMConfig().getRegisterBitwidth());
    }

    private final BigInteger arbitraryPrecisionIntegerRepresentation(BigInteger value2, int bitWidth) {
        BigInteger bigInteger;
        if (value2.compareTo(this.maxSignedValueOfBitwidth(bitWidth)) <= 0) {
            bigInteger = value2;
        } else {
            BigInteger bigInteger2 = value2;
            BigInteger bigInteger3 = BigInteger.TWO.pow(bitWidth);
            Intrinsics.checkNotNullExpressionValue(bigInteger3, "TWO.pow(bitWidth)");
            BigInteger bigInteger4 = bigInteger2.subtract(bigInteger3);
            bigInteger = bigInteger4;
            Intrinsics.checkNotNullExpressionValue(bigInteger4, "this.subtract(other)");
        }
        return bigInteger;
    }

    @NotNull
    public final BigInteger minSignedValueOfBitwidth(int bitWidth) {
        if (!(bitWidth > 0)) {
            boolean bl = false;
            String string = "Value out of bounds for bitwidth: " + bitWidth;
            throw new IllegalArgumentException(string.toString());
        }
        BigInteger bigInteger = BigInteger.TWO.pow(bitWidth - 1).negate();
        Intrinsics.checkNotNullExpressionValue(bigInteger, "TWO.pow(bitWidth - 1).negate()");
        return bigInteger;
    }

    @NotNull
    public final BigInteger maxSignedValueOfBitwidth(int bitWidth) {
        return this.maxUnsignedValueOfBitwidth(bitWidth - 1);
    }

    @NotNull
    public final BigInteger maxUnsignedValueOfBitwidth(int bitWidth) {
        if (!(bitWidth >= 0)) {
            boolean bl = false;
            String string = "Value out of bounds for bitwidth: " + bitWidth;
            throw new IllegalArgumentException(string.toString());
        }
        BigInteger bigInteger = BigInteger.TWO.pow(bitWidth);
        Intrinsics.checkNotNullExpressionValue(bigInteger, "TWO.pow(bitWidth)");
        BigInteger bigInteger2 = bigInteger;
        BigInteger bigInteger3 = BigInteger.ONE;
        Intrinsics.checkNotNullExpressionValue(bigInteger3, "ONE");
        BigInteger bigInteger4 = bigInteger2.subtract(bigInteger3);
        Intrinsics.checkNotNullExpressionValue(bigInteger4, "this.subtract(other)");
        return bigInteger4;
    }
}

