/*
 * Decompiled with CFR 0.152.
 */
package scene;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import scene.ContractUniverse;
import scene.IContractClassIdentifiers;
import scene.IMethodIdentifiers;
import scene.MethodAttribute;
import scene.SceneQueryException;
import spec.cvlast.SolidityContract;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0014\u0010\u0002\u001a\u00020\u00032\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006H\u0016J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0016\u0010\t\u001a\u0004\u0018\u00010\u00032\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006H&J\u0012\u0010\t\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0007\u001a\u00020\bH&J\b\u0010\n\u001a\u00020\u000bH\u0016J\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\rH&J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\r2\u0006\u0010\u000e\u001a\u00020\bH\u0016J\u001c\u0010\u000f\u001a\u00020\u00102\n\u0010\u0011\u001a\u00060\u0005j\u0002`\u00062\u0006\u0010\u0012\u001a\u00020\bH\u0016J\u001c\u0010\u000f\u001a\u00020\u00102\n\u0010\u0011\u001a\u00060\u0005j\u0002`\u00062\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\bH\u0016J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00100\r2\u0006\u0010\u0012\u001a\u00020\bH&J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00030\rH&J\u001c\u0010\u0018\u001a\u00020\u00192\n\u0010\u0011\u001a\u00060\u0005j\u0002`\u00062\u0006\u0010\u0012\u001a\u00020\bH\u0016J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\bH\u0016JP\u0010\u001a\u001a\u0002H\u001b\"\u0004\b\u0000\u0010\u001c\"\u0004\b\u0001\u0010\u001b2\u0006\u0010\u001d\u001a\u0002H\u001c2\u0014\u0010\u001e\u001a\u0010\u0012\u0004\u0012\u0002H\u001c\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u001f2\u0006\u0010 \u001a\u00020!2\u0014\u0010\"\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u0001H\u001b0\u001fH\u0002\u00a8\u0006#"}, d2={"Lscene/ISceneIdentifiers;", "Ljava/io/Serializable;", "getContract", "Lscene/IContractClassIdentifiers;", "s", "Lspec/cvlast/SolidityContract;", "Lbridge/NamedContractIdentifier;", "a", "Ljava/math/BigInteger;", "getContractOrNull", "getContractUniverse", "Lscene/ContractUniverse;", "getContracts", "", "sighash", "getMethod", "Lscene/IMethodIdentifiers;", "contractName", "sigHash", "methodAttribute", "Lscene/MethodAttribute$Unique;", "contractId", "getMethods", "getPrecompiledContracts", "hasMethod", "", "thenGetContractProp", "R", "T", "k", "getter", "Lkotlin/Function1;", "msg", "", "tr", "Shared"})
public interface ISceneIdentifiers
extends Serializable {
    @NotNull
    public IContractClassIdentifiers getContract(@NotNull SolidityContract var1);

    @NotNull
    public IContractClassIdentifiers getContract(@NotNull BigInteger var1);

    @Nullable
    public IContractClassIdentifiers getContractOrNull(@NotNull SolidityContract var1);

    @Nullable
    public IContractClassIdentifiers getContractOrNull(@NotNull BigInteger var1);

    @NotNull
    public IMethodIdentifiers getMethod(@NotNull BigInteger var1, @NotNull BigInteger var2);

    @NotNull
    public IMethodIdentifiers getMethod(@NotNull SolidityContract var1, @NotNull BigInteger var2);

    @NotNull
    public IMethodIdentifiers getMethod(@NotNull SolidityContract var1, @NotNull MethodAttribute.Unique var2);

    @NotNull
    public IMethodIdentifiers getMethod(@NotNull BigInteger var1, @NotNull MethodAttribute.Unique var2);

    @NotNull
    public List<IMethodIdentifiers> getMethods(@NotNull BigInteger var1);

    public boolean hasMethod(@NotNull BigInteger var1, @NotNull BigInteger var2);

    public boolean hasMethod(@NotNull SolidityContract var1, @NotNull BigInteger var2);

    @NotNull
    public List<IContractClassIdentifiers> getContracts();

    @NotNull
    public ContractUniverse getContractUniverse();

    @NotNull
    public List<IContractClassIdentifiers> getPrecompiledContracts();

    @NotNull
    public List<IContractClassIdentifiers> getContracts(@NotNull BigInteger var1);

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    @SourceDebugExtension(value={"SMAP\nIScene.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IScene.kt\nscene/ISceneIdentifiers$DefaultImpls\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,192:1\n766#2:193\n857#2:194\n1747#2,3:195\n858#2:198\n*S KotlinDebug\n*F\n+ 1 IScene.kt\nscene/ISceneIdentifiers$DefaultImpls\n*L\n168#1:193\n168#1:194\n169#1:195,3\n168#1:198\n*E\n"})
    public static final class DefaultImpls {
        @NotNull
        public static IContractClassIdentifiers getContract(@NotNull ISceneIdentifiers $this, @NotNull SolidityContract s) {
            Intrinsics.checkNotNullParameter(s, "s");
            IContractClassIdentifiers iContractClassIdentifiers = $this.getContractOrNull(s);
            if (iContractClassIdentifiers == null) {
                throw new SceneQueryException("Asked for non-existing contract " + s);
            }
            return iContractClassIdentifiers;
        }

        @NotNull
        public static IContractClassIdentifiers getContract(@NotNull ISceneIdentifiers $this, @NotNull BigInteger a) {
            Intrinsics.checkNotNullParameter(a, "a");
            IContractClassIdentifiers iContractClassIdentifiers = $this.getContractOrNull(a);
            if (iContractClassIdentifiers == null) {
                throw new SceneQueryException("Asked for non-existing contract with instanceId " + a);
            }
            return iContractClassIdentifiers;
        }

        private static <T, R> R thenGetContractProp(ISceneIdentifiers $this, T k, Function1<? super T, ? extends IContractClassIdentifiers> getter, String msg, Function1<? super IContractClassIdentifiers, ? extends R> tr) {
            IContractClassIdentifiers iContractClassIdentifiers = getter.invoke(k);
            if (iContractClassIdentifiers == null) {
                throw new IllegalStateException(("No contract " + k + " in scene").toString());
            }
            IContractClassIdentifiers contr = iContractClassIdentifiers;
            R r = tr.invoke(contr);
            if (r == null) {
                throw new IllegalStateException((msg + " in contract " + contr.getName() + " in scene").toString());
            }
            return r;
        }

        @NotNull
        public static IMethodIdentifiers getMethod(@NotNull ISceneIdentifiers $this, @NotNull BigInteger contractId, @NotNull BigInteger sigHash) {
            Intrinsics.checkNotNullParameter(contractId, "contractId");
            Intrinsics.checkNotNullParameter(sigHash, "sigHash");
            return (IMethodIdentifiers)DefaultImpls.thenGetContractProp($this, contractId, (Function1)new Function1<BigInteger, IContractClassIdentifiers>((Object)$this){

                @Nullable
                public final IContractClassIdentifiers invoke(@NotNull BigInteger p0) {
                    Intrinsics.checkNotNullParameter(p0, "p0");
                    return ((ISceneIdentifiers)this.receiver).getContractOrNull(p0);
                }
            }, "No method with hash " + sigHash.toString(16), (Function1)new Function1<IContractClassIdentifiers, IMethodIdentifiers>(sigHash){
                final /* synthetic */ BigInteger $sigHash;
                {
                    this.$sigHash = $sigHash;
                    super(1);
                }

                @Nullable
                public final IMethodIdentifiers invoke(@NotNull IContractClassIdentifiers it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    return it.getMethodBySigHash(this.$sigHash);
                }
            });
        }

        @NotNull
        public static IMethodIdentifiers getMethod(@NotNull ISceneIdentifiers $this, @NotNull SolidityContract contractName, @NotNull BigInteger sigHash) {
            Intrinsics.checkNotNullParameter(contractName, "contractName");
            Intrinsics.checkNotNullParameter(sigHash, "sigHash");
            return (IMethodIdentifiers)DefaultImpls.thenGetContractProp($this, contractName, (Function1)new Function1<SolidityContract, IContractClassIdentifiers>((Object)$this){

                @Nullable
                public final IContractClassIdentifiers invoke(@NotNull SolidityContract p0) {
                    Intrinsics.checkNotNullParameter(p0, "p0");
                    return ((ISceneIdentifiers)this.receiver).getContractOrNull(p0);
                }
            }, "No method with hash " + sigHash, (Function1)new Function1<IContractClassIdentifiers, IMethodIdentifiers>(sigHash){
                final /* synthetic */ BigInteger $sigHash;
                {
                    this.$sigHash = $sigHash;
                    super(1);
                }

                @Nullable
                public final IMethodIdentifiers invoke(@NotNull IContractClassIdentifiers it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    return it.getMethodBySigHash(this.$sigHash);
                }
            });
        }

        @NotNull
        public static IMethodIdentifiers getMethod(@NotNull ISceneIdentifiers $this, @NotNull SolidityContract contractName, @NotNull MethodAttribute.Unique methodAttribute) {
            Intrinsics.checkNotNullParameter(contractName, "contractName");
            Intrinsics.checkNotNullParameter(methodAttribute, "methodAttribute");
            return (IMethodIdentifiers)DefaultImpls.thenGetContractProp($this, contractName, (Function1)new Function1<SolidityContract, IContractClassIdentifiers>((Object)$this){

                @Nullable
                public final IContractClassIdentifiers invoke(@NotNull SolidityContract p0) {
                    Intrinsics.checkNotNullParameter(p0, "p0");
                    return ((ISceneIdentifiers)this.receiver).getContractOrNull(p0);
                }
            }, "No method with attribute " + methodAttribute, (Function1)new Function1<IContractClassIdentifiers, IMethodIdentifiers>(methodAttribute){
                final /* synthetic */ MethodAttribute.Unique $methodAttribute;
                {
                    this.$methodAttribute = $methodAttribute;
                    super(1);
                }

                @Nullable
                public final IMethodIdentifiers invoke(@NotNull IContractClassIdentifiers it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    return it.getMethodByUniqueAttribute(this.$methodAttribute);
                }
            });
        }

        @NotNull
        public static IMethodIdentifiers getMethod(@NotNull ISceneIdentifiers $this, @NotNull BigInteger contractId, @NotNull MethodAttribute.Unique methodAttribute) {
            Intrinsics.checkNotNullParameter(contractId, "contractId");
            Intrinsics.checkNotNullParameter(methodAttribute, "methodAttribute");
            return (IMethodIdentifiers)DefaultImpls.thenGetContractProp($this, contractId, (Function1)new Function1<BigInteger, IContractClassIdentifiers>((Object)$this){

                @Nullable
                public final IContractClassIdentifiers invoke(@NotNull BigInteger p0) {
                    Intrinsics.checkNotNullParameter(p0, "p0");
                    return ((ISceneIdentifiers)this.receiver).getContractOrNull(p0);
                }
            }, "No method with attribute " + methodAttribute, (Function1)new Function1<IContractClassIdentifiers, IMethodIdentifiers>(methodAttribute){
                final /* synthetic */ MethodAttribute.Unique $methodAttribute;
                {
                    this.$methodAttribute = $methodAttribute;
                    super(1);
                }

                @Nullable
                public final IMethodIdentifiers invoke(@NotNull IContractClassIdentifiers it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    return it.getMethodByUniqueAttribute(this.$methodAttribute);
                }
            });
        }

        public static boolean hasMethod(@NotNull ISceneIdentifiers $this, @NotNull BigInteger contractId, @NotNull BigInteger sigHash) {
            Intrinsics.checkNotNullParameter(contractId, "contractId");
            Intrinsics.checkNotNullParameter(sigHash, "sigHash");
            IContractClassIdentifiers iContractClassIdentifiers = $this.getContractOrNull(contractId);
            return (iContractClassIdentifiers != null ? iContractClassIdentifiers.getMethodBySigHash(sigHash) : null) != null;
        }

        public static boolean hasMethod(@NotNull ISceneIdentifiers $this, @NotNull SolidityContract contractName, @NotNull BigInteger sigHash) {
            Intrinsics.checkNotNullParameter(contractName, "contractName");
            Intrinsics.checkNotNullParameter(sigHash, "sigHash");
            IContractClassIdentifiers iContractClassIdentifiers = $this.getContractOrNull(contractName);
            return (iContractClassIdentifiers != null ? iContractClassIdentifiers.getMethodBySigHash(sigHash) : null) != null;
        }

        @NotNull
        public static ContractUniverse getContractUniverse(@NotNull ISceneIdentifiers $this) {
            return ContractUniverse.ETHEREUM;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public static List<IContractClassIdentifiers> getContracts(@NotNull ISceneIdentifiers $this, @NotNull BigInteger sighash) {
            void $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter(sighash, "sighash");
            Iterable $this$filter$iv = $this.getContracts();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                boolean bl;
                block4: {
                    IContractClassIdentifiers it = (IContractClassIdentifiers)element$iv$iv;
                    boolean bl2 = false;
                    Iterable $this$any$iv = it.getMethods();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            IMethodIdentifiers method = (IMethodIdentifiers)element$iv;
                            boolean bl3 = false;
                            if (!Intrinsics.areEqual(method.getSigHash().getN(), sighash)) continue;
                            bl = true;
                            break block4;
                        }
                        bl = false;
                    }
                }
                if (!bl) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }
    }
}

