/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.util.cli;

import java.util.StringTokenizer;

public final class EnhancedStringTokenizer {
    private StringTokenizer cst = null;
    String cdelim;
    final boolean cdelimSingleChar;
    final char cdelimChar;
    boolean creturnDelims;
    String lastToken = null;
    boolean delimLast = true;

    public EnhancedStringTokenizer(String str2) {
        this(str2, " \t\n\r\f", false);
    }

    public EnhancedStringTokenizer(String str2, String delim) {
        this(str2, delim, false);
    }

    public EnhancedStringTokenizer(String str2, String delim, boolean returnDelims) {
        this.cst = new StringTokenizer(str2, delim, true);
        this.cdelim = delim;
        this.creturnDelims = returnDelims;
        this.cdelimSingleChar = delim.length() == 1;
        this.cdelimChar = delim.charAt(0);
    }

    public boolean hasMoreTokens() {
        return this.cst.hasMoreTokens();
    }

    private String internalNextToken() {
        if (this.lastToken != null) {
            String last2 = this.lastToken;
            this.lastToken = null;
            return last2;
        }
        String token2 = this.cst.nextToken();
        if (this.isDelim(token2)) {
            if (this.delimLast) {
                this.lastToken = token2;
                return "";
            }
            this.delimLast = true;
            return token2;
        }
        this.delimLast = false;
        return token2;
    }

    public String nextToken() {
        String token2 = this.internalNextToken();
        if (this.creturnDelims) {
            return token2;
        }
        if (this.isDelim(token2)) {
            return this.hasMoreTokens() ? this.internalNextToken() : "";
        }
        return token2;
    }

    private boolean isDelim(String str2) {
        if (str2.length() == 1) {
            char ch = str2.charAt(0);
            if (this.cdelimSingleChar ? this.cdelimChar == ch : this.cdelim.indexOf(ch) >= 0) {
                return true;
            }
        }
        return false;
    }
}

