/*
 * Decompiled with CFR 0.152.
 */
package com.certora.evmverifier.cvl;

import com.certora.evmverifier.cvl.KotlinizeResult;
import kotlinizable.Kotlinizable;
import org.jetbrains.annotations.NotNull;
import spec.TypeResolver;
import spec.cvlast.CVLImportedContract;
import spec.cvlast.CVLRange;
import spec.cvlast.CVLScope;
import spec.cvlast.ContractAliasDefinition;
import spec.cvlast.SolidityContract;
import spec.cvlast.typechecker.CVLError;
import utils.CollectingResult;

public class ImportedContract
implements Kotlinizable<CVLImportedContract>,
ContractAliasDefinition {
    public final String alias;
    public final String contractName;
    public final CVLRange cvlRange;

    public ImportedContract(String _id, String _contractName, CVLRange _cvlRange) {
        this.alias = _id;
        this.contractName = _contractName;
        this.cvlRange = _cvlRange;
    }

    public String toString() {
        return String.format(this.alias, this.contractName);
    }

    @Override
    public CollectingResult<CVLImportedContract, CVLError> kotlinize(TypeResolver resolver, CVLScope scope) {
        return KotlinizeResult.lift(new CVLImportedContract(this.alias, new SolidityContract(resolver.resolveContract(this.contractName)), this.cvlRange));
    }

    @Override
    @NotNull
    public String getContractName() {
        return this.contractName;
    }

    @Override
    @NotNull
    public String getAlias() {
        return this.alias;
    }

    @Override
    @NotNull
    public CVLRange getCvlRange() {
        return this.cvlRange;
    }
}

