/*
 * Decompiled with CFR 0.152.
 */
package spec;

import bridge.ContractInstanceInSDC;
import evm.SighashInt;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import spec.CVL;
import spec.CVLAstUtilKt;
import spec.cvlast.CVLDefinition;
import spec.cvlast.CVLFunction;
import spec.cvlast.CVLGhostDeclaration;
import spec.cvlast.CVLHook;
import spec.cvlast.CVLImportedContract;
import spec.cvlast.CVLInvariant;
import spec.cvlast.CVLScope;
import spec.cvlast.CVLSymbolTable;
import spec.cvlast.ContractFunction;
import spec.cvlast.ContractFunctionIdentifier;
import spec.cvlast.ContractReference;
import spec.cvlast.IRule;
import spec.cvlast.MethodParameterSignature;
import spec.cvlast.QualifiedFunctionNameKt;
import spec.cvlast.QualifiedMethodParameterSignature;
import spec.cvlast.SolidityContract;
import spec.cvlast.SortDeclaration;
import spec.cvlast.SpecCallSummary;
import spec.cvlast.typedescriptors.FromVMContext;
import spec.cvlast.typedescriptors.VMTypeDescriptor;
import utils.StableHashCode;
import utils.WithStableHashCodeIfSerialized;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b&\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\n\b\u0086\b\u0018\u00002\u00020\u0001:\bWXYZ[\\]^B\u00dd\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0018\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0005\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0007\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0007\u0012\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u0007\u0012\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u0007\u0012\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u0007\u0012\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u0007\u0012\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00060\u0007\u0012\u0006\u0010\u0018\u001a\u00020\u0019\u0012\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0007\u0012\u0006\u0010\u001c\u001a\u00020\u001d\u0012\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020 0\u0005\u0012\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020 0\u0005\u00a2\u0006\u0002\u0010#J\t\u00108\u001a\u00020\u0003H\u00c6\u0003J\u000f\u00109\u001a\b\u0012\u0004\u0012\u00020\u00060\u0007H\u00c6\u0003J\t\u0010:\u001a\u00020\u0019H\u00c6\u0003J\u000f\u0010;\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0007H\u00c6\u0003J\t\u0010<\u001a\u00020\u001dH\u00c6\u0003J\u0015\u0010=\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020 0\u0005H\u00c6\u0003J\u0015\u0010>\u001a\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020 0\u0005H\u00c6\u0003J\u001b\u0010?\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0005H\u00c6\u0003J\u000f\u0010@\u001a\b\u0012\u0004\u0012\u00020\n0\u0007H\u00c6\u0003J\u000f\u0010A\u001a\b\u0012\u0004\u0012\u00020\f0\u0007H\u00c6\u0003J\u000f\u0010B\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0007H\u00c6\u0003J\u000f\u0010C\u001a\b\u0012\u0004\u0012\u00020\u00100\u0007H\u00c6\u0003J\u000f\u0010D\u001a\b\u0012\u0004\u0012\u00020\u00120\u0007H\u00c6\u0003J\u000f\u0010E\u001a\b\u0012\u0004\u0012\u00020\u00140\u0007H\u00c6\u0003J\u000f\u0010F\u001a\b\u0012\u0004\u0012\u00020\u00160\u0007H\u00c6\u0003J\u00ff\u0001\u0010G\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u001a\b\u0002\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u00052\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u00072\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u00072\u000e\b\u0002\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00072\u000e\b\u0002\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u00072\u000e\b\u0002\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u00072\u000e\b\u0002\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u00072\u000e\b\u0002\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u00072\u000e\b\u0002\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00060\u00072\b\b\u0002\u0010\u0018\u001a\u00020\u00192\u000e\b\u0002\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00072\b\b\u0002\u0010\u001c\u001a\u00020\u001d2\u0014\b\u0002\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020 0\u00052\u0014\b\u0002\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020 0\u0005H\u00c6\u0001J\u0013\u0010H\u001a\u00020I2\b\u0010J\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u0010\u0010K\u001a\u0004\u0018\u00010\u00062\u0006\u0010L\u001a\u00020MJ\u0012\u0010N\u001a\u0004\u0018\u00010O2\b\b\u0002\u0010P\u001a\u00020MJ\u0018\u0010Q\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020S0R0\u0007J\t\u0010T\u001a\u00020UH\u00d6\u0001J\t\u0010V\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u001c\u001a\u00020\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0017\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00060\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010'R\u001d\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020 0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010'R\u0017\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010'R\u0017\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010'R#\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010*R\u001d\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020 0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u0010*R\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u0010'R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u00102R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u0010'R\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u0010'R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u0010'R\u0011\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u00107\u00a8\u0006_"}, d2={"Lspec/CVL;", "", "name", "", "importedFuncs", "", "Lbridge/ContractInstanceInSDC;", "", "Lspec/cvlast/ContractFunction;", "rules", "Lspec/cvlast/IRule;", "subs", "Lspec/cvlast/CVLFunction;", "invariants", "Lspec/cvlast/CVLInvariant;", "sorts", "Lspec/cvlast/SortDeclaration;", "ghosts", "Lspec/cvlast/CVLGhostDeclaration;", "definitions", "Lspec/cvlast/CVLDefinition;", "hooks", "Lspec/cvlast/CVLHook;", "contracts", "symbolTable", "Lspec/cvlast/CVLSymbolTable;", "importedContracts", "Lspec/cvlast/CVLImportedContract;", "astScope", "Lspec/cvlast/CVLScope;", "internal", "Lspec/CVL$SummarySignature$Internal;", "Lspec/cvlast/SpecCallSummary;", "external", "Lspec/CVL$SummarySignature$External;", "(Ljava/lang/String;Ljava/util/Map;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;Lspec/cvlast/CVLSymbolTable;Ljava/util/List;Lspec/cvlast/CVLScope;Ljava/util/Map;Ljava/util/Map;)V", "getAstScope", "()Lspec/cvlast/CVLScope;", "getContracts", "()Ljava/util/List;", "getDefinitions", "getExternal", "()Ljava/util/Map;", "getGhosts", "getHooks", "getImportedContracts", "getImportedFuncs", "getInternal", "getInvariants", "getName", "()Ljava/lang/String;", "getRules", "getSorts", "getSubs", "getSymbolTable", "()Lspec/cvlast/CVLSymbolTable;", "component1", "component10", "component11", "component12", "component13", "component14", "component15", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "equals", "", "other", "getContractInstance", "contractName", "Lspec/cvlast/ContractReference;", "getContractNameFromContractId", "Lspec/cvlast/SolidityContract;", "solidityContractId", "getContractVarIdToAddressAssociation", "Lkotlin/Pair;", "Ljava/math/BigInteger;", "hashCode", "", "toString", "ExternalExact", "ExternalWildcard", "InternalExact", "InternalWildcard", "SummaryKey", "SummaryKeyImpl", "SummarySignature", "SummaryTarget", "Shared"})
@SourceDebugExtension(value={"SMAP\nCVLAstUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CVLAstUtil.kt\nspec/CVL\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,730:1\n1#2:731\n1#2:742\n1603#3,9:732\n1855#3:741\n1856#3:743\n1612#3:744\n*S KotlinDebug\n*F\n+ 1 CVLAstUtil.kt\nspec/CVL\n*L\n146#1:742\n146#1:732,9\n146#1:741\n146#1:743\n146#1:744\n*E\n"})
public final class CVL {
    @NotNull
    private final String name;
    @NotNull
    private final Map<ContractInstanceInSDC, List<ContractFunction>> importedFuncs;
    @NotNull
    private final List<IRule> rules;
    @NotNull
    private final List<CVLFunction> subs;
    @NotNull
    private final List<CVLInvariant> invariants;
    @NotNull
    private final List<SortDeclaration> sorts;
    @NotNull
    private final List<CVLGhostDeclaration> ghosts;
    @NotNull
    private final List<CVLDefinition> definitions;
    @NotNull
    private final List<CVLHook> hooks;
    @NotNull
    private final List<ContractInstanceInSDC> contracts;
    @NotNull
    private final CVLSymbolTable symbolTable;
    @NotNull
    private final List<CVLImportedContract> importedContracts;
    @NotNull
    private final CVLScope astScope;
    @NotNull
    private final Map<SummarySignature.Internal, SpecCallSummary> internal;
    @NotNull
    private final Map<SummarySignature.External, SpecCallSummary> external;

    public CVL(@NotNull String name, @NotNull Map<ContractInstanceInSDC, ? extends List<ContractFunction>> importedFuncs, @NotNull List<? extends IRule> rules, @NotNull List<CVLFunction> subs, @NotNull List<CVLInvariant> invariants, @NotNull List<SortDeclaration> sorts, @NotNull List<? extends CVLGhostDeclaration> ghosts, @NotNull List<CVLDefinition> definitions, @NotNull List<CVLHook> hooks, @NotNull List<ContractInstanceInSDC> contracts, @NotNull CVLSymbolTable symbolTable, @NotNull List<CVLImportedContract> importedContracts, @NotNull CVLScope astScope, @NotNull Map<SummarySignature.Internal, ? extends SpecCallSummary> internal, @NotNull Map<SummarySignature.External, ? extends SpecCallSummary> external) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(importedFuncs, "importedFuncs");
        Intrinsics.checkNotNullParameter(rules, "rules");
        Intrinsics.checkNotNullParameter(subs, "subs");
        Intrinsics.checkNotNullParameter(invariants, "invariants");
        Intrinsics.checkNotNullParameter(sorts, "sorts");
        Intrinsics.checkNotNullParameter(ghosts, "ghosts");
        Intrinsics.checkNotNullParameter(definitions, "definitions");
        Intrinsics.checkNotNullParameter(hooks, "hooks");
        Intrinsics.checkNotNullParameter(contracts, "contracts");
        Intrinsics.checkNotNullParameter(symbolTable, "symbolTable");
        Intrinsics.checkNotNullParameter(importedContracts, "importedContracts");
        Intrinsics.checkNotNullParameter(astScope, "astScope");
        Intrinsics.checkNotNullParameter(internal, "internal");
        Intrinsics.checkNotNullParameter(external, "external");
        this.name = name;
        this.importedFuncs = importedFuncs;
        this.rules = rules;
        this.subs = subs;
        this.invariants = invariants;
        this.sorts = sorts;
        this.ghosts = ghosts;
        this.definitions = definitions;
        this.hooks = hooks;
        this.contracts = contracts;
        this.symbolTable = symbolTable;
        this.importedContracts = importedContracts;
        this.astScope = astScope;
        this.internal = internal;
        this.external = external;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final Map<ContractInstanceInSDC, List<ContractFunction>> getImportedFuncs() {
        return this.importedFuncs;
    }

    @NotNull
    public final List<IRule> getRules() {
        return this.rules;
    }

    @NotNull
    public final List<CVLFunction> getSubs() {
        return this.subs;
    }

    @NotNull
    public final List<CVLInvariant> getInvariants() {
        return this.invariants;
    }

    @NotNull
    public final List<SortDeclaration> getSorts() {
        return this.sorts;
    }

    @NotNull
    public final List<CVLGhostDeclaration> getGhosts() {
        return this.ghosts;
    }

    @NotNull
    public final List<CVLDefinition> getDefinitions() {
        return this.definitions;
    }

    @NotNull
    public final List<CVLHook> getHooks() {
        return this.hooks;
    }

    @NotNull
    public final List<ContractInstanceInSDC> getContracts() {
        return this.contracts;
    }

    @NotNull
    public final CVLSymbolTable getSymbolTable() {
        return this.symbolTable;
    }

    @NotNull
    public final List<CVLImportedContract> getImportedContracts() {
        return this.importedContracts;
    }

    @NotNull
    public final CVLScope getAstScope() {
        return this.astScope;
    }

    @NotNull
    public final Map<SummarySignature.Internal, SpecCallSummary> getInternal() {
        return this.internal;
    }

    @NotNull
    public final Map<SummarySignature.External, SpecCallSummary> getExternal() {
        return this.external;
    }

    @Nullable
    public final SolidityContract getContractNameFromContractId(@NotNull ContractReference solidityContractId) {
        Intrinsics.checkNotNullParameter(solidityContractId, "solidityContractId");
        return this.symbolTable.getContractNameFromContractId(solidityContractId);
    }

    public static /* synthetic */ SolidityContract getContractNameFromContractId$default(CVL cVL, ContractReference contractReference, int n, Object object) {
        if ((n & 1) != 0) {
            contractReference = SolidityContract.Companion.getCurrent();
        }
        return cVL.getContractNameFromContractId(contractReference);
    }

    @Nullable
    public final ContractInstanceInSDC getContractInstance(@NotNull ContractReference contractName) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter(contractName, "contractName");
            Iterable iterable = this.contracts;
            for (Object t : iterable) {
                ContractInstanceInSDC c = (ContractInstanceInSDC)t;
                boolean bl = false;
                if (!Intrinsics.areEqual(c.getName(), contractName.getName())) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Pair<String, BigInteger>> getContractVarIdToAddressAssociation() {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = this.importedContracts;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Pair<String, BigInteger> pair2;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            CVLImportedContract it = (CVLImportedContract)element$iv$iv;
            boolean bl2 = false;
            ContractInstanceInSDC contractInstance = this.getContractInstance(it.getSolidityContractName());
            if (contractInstance == null) {
                CVLAstUtilKt.access$getLogger$p().error("Could not find contract instance for " + it.getSolidityContractName() + " from imported contracts " + this.importedContracts);
                pair2 = null;
            } else {
                pair2 = TuplesKt.to(it.getSolidityContractVarId(), contractInstance.getAddress());
            }
            if (pair2 == null) continue;
            Pair<String, BigInteger> it$iv$iv = pair2;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final String component1() {
        return this.name;
    }

    @NotNull
    public final Map<ContractInstanceInSDC, List<ContractFunction>> component2() {
        return this.importedFuncs;
    }

    @NotNull
    public final List<IRule> component3() {
        return this.rules;
    }

    @NotNull
    public final List<CVLFunction> component4() {
        return this.subs;
    }

    @NotNull
    public final List<CVLInvariant> component5() {
        return this.invariants;
    }

    @NotNull
    public final List<SortDeclaration> component6() {
        return this.sorts;
    }

    @NotNull
    public final List<CVLGhostDeclaration> component7() {
        return this.ghosts;
    }

    @NotNull
    public final List<CVLDefinition> component8() {
        return this.definitions;
    }

    @NotNull
    public final List<CVLHook> component9() {
        return this.hooks;
    }

    @NotNull
    public final List<ContractInstanceInSDC> component10() {
        return this.contracts;
    }

    @NotNull
    public final CVLSymbolTable component11() {
        return this.symbolTable;
    }

    @NotNull
    public final List<CVLImportedContract> component12() {
        return this.importedContracts;
    }

    @NotNull
    public final CVLScope component13() {
        return this.astScope;
    }

    @NotNull
    public final Map<SummarySignature.Internal, SpecCallSummary> component14() {
        return this.internal;
    }

    @NotNull
    public final Map<SummarySignature.External, SpecCallSummary> component15() {
        return this.external;
    }

    @NotNull
    public final CVL copy(@NotNull String name, @NotNull Map<ContractInstanceInSDC, ? extends List<ContractFunction>> importedFuncs, @NotNull List<? extends IRule> rules, @NotNull List<CVLFunction> subs, @NotNull List<CVLInvariant> invariants, @NotNull List<SortDeclaration> sorts, @NotNull List<? extends CVLGhostDeclaration> ghosts, @NotNull List<CVLDefinition> definitions, @NotNull List<CVLHook> hooks, @NotNull List<ContractInstanceInSDC> contracts, @NotNull CVLSymbolTable symbolTable, @NotNull List<CVLImportedContract> importedContracts, @NotNull CVLScope astScope, @NotNull Map<SummarySignature.Internal, ? extends SpecCallSummary> internal, @NotNull Map<SummarySignature.External, ? extends SpecCallSummary> external) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(importedFuncs, "importedFuncs");
        Intrinsics.checkNotNullParameter(rules, "rules");
        Intrinsics.checkNotNullParameter(subs, "subs");
        Intrinsics.checkNotNullParameter(invariants, "invariants");
        Intrinsics.checkNotNullParameter(sorts, "sorts");
        Intrinsics.checkNotNullParameter(ghosts, "ghosts");
        Intrinsics.checkNotNullParameter(definitions, "definitions");
        Intrinsics.checkNotNullParameter(hooks, "hooks");
        Intrinsics.checkNotNullParameter(contracts, "contracts");
        Intrinsics.checkNotNullParameter(symbolTable, "symbolTable");
        Intrinsics.checkNotNullParameter(importedContracts, "importedContracts");
        Intrinsics.checkNotNullParameter(astScope, "astScope");
        Intrinsics.checkNotNullParameter(internal, "internal");
        Intrinsics.checkNotNullParameter(external, "external");
        return new CVL(name, importedFuncs, rules, subs, invariants, sorts, ghosts, definitions, hooks, contracts, symbolTable, importedContracts, astScope, internal, external);
    }

    public static /* synthetic */ CVL copy$default(CVL cVL, String string, Map map2, List list, List list2, List list3, List list4, List list5, List list6, List list7, List list8, CVLSymbolTable cVLSymbolTable, List list9, CVLScope cVLScope, Map map3, Map map4, int n, Object object) {
        if ((n & 1) != 0) {
            string = cVL.name;
        }
        if ((n & 2) != 0) {
            map2 = cVL.importedFuncs;
        }
        if ((n & 4) != 0) {
            list = cVL.rules;
        }
        if ((n & 8) != 0) {
            list2 = cVL.subs;
        }
        if ((n & 0x10) != 0) {
            list3 = cVL.invariants;
        }
        if ((n & 0x20) != 0) {
            list4 = cVL.sorts;
        }
        if ((n & 0x40) != 0) {
            list5 = cVL.ghosts;
        }
        if ((n & 0x80) != 0) {
            list6 = cVL.definitions;
        }
        if ((n & 0x100) != 0) {
            list7 = cVL.hooks;
        }
        if ((n & 0x200) != 0) {
            list8 = cVL.contracts;
        }
        if ((n & 0x400) != 0) {
            cVLSymbolTable = cVL.symbolTable;
        }
        if ((n & 0x800) != 0) {
            list9 = cVL.importedContracts;
        }
        if ((n & 0x1000) != 0) {
            cVLScope = cVL.astScope;
        }
        if ((n & 0x2000) != 0) {
            map3 = cVL.internal;
        }
        if ((n & 0x4000) != 0) {
            map4 = cVL.external;
        }
        return cVL.copy(string, map2, list, list2, list3, list4, list5, list6, list7, list8, cVLSymbolTable, list9, cVLScope, map3, map4);
    }

    @NotNull
    public String toString() {
        return "CVL(name=" + this.name + ", importedFuncs=" + this.importedFuncs + ", rules=" + this.rules + ", subs=" + this.subs + ", invariants=" + this.invariants + ", sorts=" + this.sorts + ", ghosts=" + this.ghosts + ", definitions=" + this.definitions + ", hooks=" + this.hooks + ", contracts=" + this.contracts + ", symbolTable=" + this.symbolTable + ", importedContracts=" + this.importedContracts + ", astScope=" + this.astScope + ", internal=" + this.internal + ", external=" + this.external + ")";
    }

    public int hashCode() {
        int result2 = this.name.hashCode();
        result2 = result2 * 31 + ((Object)this.importedFuncs).hashCode();
        result2 = result2 * 31 + ((Object)this.rules).hashCode();
        result2 = result2 * 31 + ((Object)this.subs).hashCode();
        result2 = result2 * 31 + ((Object)this.invariants).hashCode();
        result2 = result2 * 31 + ((Object)this.sorts).hashCode();
        result2 = result2 * 31 + ((Object)this.ghosts).hashCode();
        result2 = result2 * 31 + ((Object)this.definitions).hashCode();
        result2 = result2 * 31 + ((Object)this.hooks).hashCode();
        result2 = result2 * 31 + ((Object)this.contracts).hashCode();
        result2 = result2 * 31 + this.symbolTable.hashCode();
        result2 = result2 * 31 + ((Object)this.importedContracts).hashCode();
        result2 = result2 * 31 + this.astScope.hashCode();
        result2 = result2 * 31 + ((Object)this.internal).hashCode();
        result2 = result2 * 31 + ((Object)this.external).hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CVL)) {
            return false;
        }
        CVL cVL = (CVL)other;
        if (!Intrinsics.areEqual(this.name, cVL.name)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.importedFuncs, cVL.importedFuncs)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.rules, cVL.rules)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.subs, cVL.subs)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.invariants, cVL.invariants)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.sorts, cVL.sorts)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.ghosts, cVL.ghosts)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.definitions, cVL.definitions)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.hooks, cVL.hooks)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.contracts, cVL.contracts)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.symbolTable, cVL.symbolTable)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.importedContracts, cVL.importedContracts)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.astScope, cVL.astScope)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.internal, cVL.internal)) {
            return false;
        }
        return Intrinsics.areEqual(this.external, cVL.external);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\t\u0010\u0010\u001a\u00020\u0004H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0006H\u00c6\u0003J\u001d\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u00d6\u0003J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\t\u0010\u001b\u001a\u00020\tH\u00d6\u0001R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001c"}, d2={"Lspec/CVL$ExternalExact;", "Lspec/CVL$SummaryTarget$ExactFunction;", "Lspec/CVL$SummarySignature$External;", "sighashInt", "Levm/SighashInt;", "signature", "Lspec/cvlast/QualifiedMethodParameterSignature;", "(Levm/SighashInt;Lspec/cvlast/QualifiedMethodParameterSignature;)V", "methodId", "", "getMethodId", "()Ljava/lang/String;", "getSighashInt", "()Levm/SighashInt;", "getSignature", "()Lspec/cvlast/QualifiedMethodParameterSignature;", "component1", "component2", "copy", "equals", "", "other", "", "getKey", "Lspec/CVL$SummaryKey;", "hashCode", "", "toString", "Shared"})
    public static final class ExternalExact
    implements SummaryTarget.ExactFunction,
    SummarySignature.External {
        @NotNull
        private final SighashInt sighashInt;
        @NotNull
        private final QualifiedMethodParameterSignature signature;

        public ExternalExact(@NotNull SighashInt sighashInt, @NotNull QualifiedMethodParameterSignature signature) {
            Intrinsics.checkNotNullParameter(sighashInt, "sighashInt");
            Intrinsics.checkNotNullParameter(signature, "signature");
            this.sighashInt = sighashInt;
            this.signature = signature;
        }

        @Override
        @NotNull
        public SighashInt getSighashInt() {
            return this.sighashInt;
        }

        @Override
        @NotNull
        public QualifiedMethodParameterSignature getSignature() {
            return this.signature;
        }

        @Override
        @NotNull
        public String getMethodId() {
            return this.getSignature().getQualifiedMethodName().getMethodId();
        }

        @Override
        @NotNull
        public SummaryKey getKey() {
            return new SummaryKeyImpl<ContractFunctionIdentifier, SighashInt>(this.getSignature().getQualifiedMethodName(), this.getSighashInt());
        }

        @Override
        @NotNull
        public FromVMContext getArgContext() {
            return SummarySignature.External.DefaultImpls.getArgContext(this);
        }

        @Override
        @NotNull
        public String getNamedFuncSignature() {
            return SummaryTarget.ExactFunction.DefaultImpls.getNamedFuncSignature(this);
        }

        @Override
        @NotNull
        public String getFuncSignature() {
            return SummaryTarget.ExactFunction.DefaultImpls.getFuncSignature(this);
        }

        @NotNull
        public final SighashInt component1() {
            return this.sighashInt;
        }

        @NotNull
        public final QualifiedMethodParameterSignature component2() {
            return this.signature;
        }

        @NotNull
        public final ExternalExact copy(@NotNull SighashInt sighashInt, @NotNull QualifiedMethodParameterSignature signature) {
            Intrinsics.checkNotNullParameter(sighashInt, "sighashInt");
            Intrinsics.checkNotNullParameter(signature, "signature");
            return new ExternalExact(sighashInt, signature);
        }

        public static /* synthetic */ ExternalExact copy$default(ExternalExact externalExact, SighashInt sighashInt, QualifiedMethodParameterSignature qualifiedMethodParameterSignature, int n, Object object) {
            if ((n & 1) != 0) {
                sighashInt = externalExact.sighashInt;
            }
            if ((n & 2) != 0) {
                qualifiedMethodParameterSignature = externalExact.signature;
            }
            return externalExact.copy(sighashInt, qualifiedMethodParameterSignature);
        }

        @NotNull
        public String toString() {
            return "ExternalExact(sighashInt=" + this.sighashInt + ", signature=" + this.signature + ")";
        }

        public int hashCode() {
            int result2 = this.sighashInt.hashCode();
            result2 = result2 * 31 + this.signature.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ExternalExact)) {
                return false;
            }
            ExternalExact externalExact = (ExternalExact)other;
            if (!Intrinsics.areEqual(this.sighashInt, externalExact.sighashInt)) {
                return false;
            }
            return Intrinsics.areEqual(this.signature, externalExact.signature);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\t\u0010\u0012\u001a\u00020\u0004H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0006H\u00c6\u0003J\u001d\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u00d6\u0003J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\tH\u00d6\u0001R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001e"}, d2={"Lspec/CVL$ExternalWildcard;", "Lspec/CVL$SummaryTarget$AnyContract;", "Lspec/CVL$SummarySignature$External;", "sighashInt", "Levm/SighashInt;", "signature", "Lspec/cvlast/MethodParameterSignature;", "(Levm/SighashInt;Lspec/cvlast/MethodParameterSignature;)V", "methodId", "", "getMethodId", "()Ljava/lang/String;", "methodName", "getMethodName", "getSighashInt", "()Levm/SighashInt;", "getSignature", "()Lspec/cvlast/MethodParameterSignature;", "component1", "component2", "copy", "equals", "", "other", "", "getKey", "Lspec/CVL$SummaryKey;", "hashCode", "", "toString", "Shared"})
    public static final class ExternalWildcard
    implements SummaryTarget.AnyContract,
    SummarySignature.External {
        @NotNull
        private final SighashInt sighashInt;
        @NotNull
        private final MethodParameterSignature signature;
        @NotNull
        private final String methodName;

        public ExternalWildcard(@NotNull SighashInt sighashInt, @NotNull MethodParameterSignature signature) {
            Intrinsics.checkNotNullParameter(sighashInt, "sighashInt");
            Intrinsics.checkNotNullParameter(signature, "signature");
            this.sighashInt = sighashInt;
            this.signature = signature;
            this.methodName = this.getSignature().getFunctionName();
        }

        @Override
        @NotNull
        public SighashInt getSighashInt() {
            return this.sighashInt;
        }

        @Override
        @NotNull
        public MethodParameterSignature getSignature() {
            return this.signature;
        }

        @Override
        @NotNull
        public String getMethodId() {
            return this.getSignature().getFunctionName();
        }

        @Override
        @NotNull
        public String getMethodName() {
            return this.methodName;
        }

        @Override
        @NotNull
        public SummaryKey getKey() {
            return new SummaryKeyImpl<String, SighashInt>(this.getMethodName(), this.getSighashInt());
        }

        @Override
        @NotNull
        public FromVMContext getArgContext() {
            return SummarySignature.External.DefaultImpls.getArgContext(this);
        }

        @Override
        @NotNull
        public String getNamedFuncSignature() {
            return SummaryTarget.AnyContract.DefaultImpls.getNamedFuncSignature(this);
        }

        @Override
        @NotNull
        public String getFuncSignature() {
            return SummaryTarget.AnyContract.DefaultImpls.getFuncSignature(this);
        }

        @NotNull
        public final SighashInt component1() {
            return this.sighashInt;
        }

        @NotNull
        public final MethodParameterSignature component2() {
            return this.signature;
        }

        @NotNull
        public final ExternalWildcard copy(@NotNull SighashInt sighashInt, @NotNull MethodParameterSignature signature) {
            Intrinsics.checkNotNullParameter(sighashInt, "sighashInt");
            Intrinsics.checkNotNullParameter(signature, "signature");
            return new ExternalWildcard(sighashInt, signature);
        }

        public static /* synthetic */ ExternalWildcard copy$default(ExternalWildcard externalWildcard, SighashInt sighashInt, MethodParameterSignature methodParameterSignature, int n, Object object) {
            if ((n & 1) != 0) {
                sighashInt = externalWildcard.sighashInt;
            }
            if ((n & 2) != 0) {
                methodParameterSignature = externalWildcard.signature;
            }
            return externalWildcard.copy(sighashInt, methodParameterSignature);
        }

        @NotNull
        public String toString() {
            return "ExternalWildcard(sighashInt=" + this.sighashInt + ", signature=" + this.signature + ")";
        }

        public int hashCode() {
            int result2 = this.sighashInt.hashCode();
            result2 = result2 * 31 + this.signature.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ExternalWildcard)) {
                return false;
            }
            ExternalWildcard externalWildcard = (ExternalWildcard)other;
            if (!Intrinsics.areEqual(this.sighashInt, externalWildcard.sighashInt)) {
                return false;
            }
            return Intrinsics.areEqual(this.signature, externalWildcard.signature);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\t\u0010\f\u001a\u00020\u0004H\u00c6\u0003J\u0013\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u0004H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\u0010\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0003\u001a\u00020\u0004H\u0016J\t\u0010\u0017\u001a\u00020\u0007H\u00d6\u0001R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0018"}, d2={"Lspec/CVL$InternalExact;", "Lspec/CVL$SummaryTarget$ExactFunction;", "Lspec/CVL$SummarySignature$Internal;", "signature", "Lspec/cvlast/QualifiedMethodParameterSignature;", "(Lspec/cvlast/QualifiedMethodParameterSignature;)V", "methodId", "", "getMethodId", "()Ljava/lang/String;", "getSignature", "()Lspec/cvlast/QualifiedMethodParameterSignature;", "component1", "copy", "equals", "", "other", "", "getKey", "Lspec/CVL$SummaryKey;", "hashCode", "", "matches", "toString", "Shared"})
    public static final class InternalExact
    implements SummaryTarget.ExactFunction,
    SummarySignature.Internal {
        @NotNull
        private final QualifiedMethodParameterSignature signature;

        public InternalExact(@NotNull QualifiedMethodParameterSignature signature) {
            Intrinsics.checkNotNullParameter(signature, "signature");
            this.signature = signature;
        }

        @Override
        @NotNull
        public QualifiedMethodParameterSignature getSignature() {
            return this.signature;
        }

        @Override
        @NotNull
        public SummaryKey getKey() {
            return new SummaryKeyImpl<ContractFunctionIdentifier, List<VMTypeDescriptor>>(this.getSignature().getQualifiedMethodName(), this.getSignature().getParamTypes());
        }

        @Override
        @NotNull
        public String getMethodId() {
            return this.getSignature().getQualifiedMethodName().getMethodId();
        }

        @Override
        public boolean matches(@NotNull QualifiedMethodParameterSignature signature) {
            Intrinsics.checkNotNullParameter(signature, "signature");
            return this.getSignature().matchesContractAndParams(signature);
        }

        @Override
        @NotNull
        public FromVMContext getArgContext() {
            return SummarySignature.Internal.DefaultImpls.getArgContext(this);
        }

        @Override
        @NotNull
        public String getNamedFuncSignature() {
            return SummaryTarget.ExactFunction.DefaultImpls.getNamedFuncSignature(this);
        }

        @Override
        @NotNull
        public String getFuncSignature() {
            return SummaryTarget.ExactFunction.DefaultImpls.getFuncSignature(this);
        }

        @NotNull
        public final QualifiedMethodParameterSignature component1() {
            return this.signature;
        }

        @NotNull
        public final InternalExact copy(@NotNull QualifiedMethodParameterSignature signature) {
            Intrinsics.checkNotNullParameter(signature, "signature");
            return new InternalExact(signature);
        }

        public static /* synthetic */ InternalExact copy$default(InternalExact internalExact, QualifiedMethodParameterSignature qualifiedMethodParameterSignature, int n, Object object) {
            if ((n & 1) != 0) {
                qualifiedMethodParameterSignature = internalExact.signature;
            }
            return internalExact.copy(qualifiedMethodParameterSignature);
        }

        @NotNull
        public String toString() {
            return "InternalExact(signature=" + this.signature + ")";
        }

        public int hashCode() {
            return this.signature.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof InternalExact)) {
                return false;
            }
            InternalExact internalExact = (InternalExact)other;
            return Intrinsics.areEqual(this.signature, internalExact.signature);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\t\u0010\u000e\u001a\u00020\u0004H\u00c6\u0003J\u0013\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u0004H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u00d6\u0003J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\u0010\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0003\u001a\u00020\u0019H\u0016J\t\u0010\u001a\u001a\u00020\u0007H\u00d6\u0001R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\tR\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001b"}, d2={"Lspec/CVL$InternalWildcard;", "Lspec/CVL$SummaryTarget$AnyContract;", "Lspec/CVL$SummarySignature$Internal;", "signature", "Lspec/cvlast/MethodParameterSignature;", "(Lspec/cvlast/MethodParameterSignature;)V", "methodId", "", "getMethodId", "()Ljava/lang/String;", "methodName", "getMethodName", "getSignature", "()Lspec/cvlast/MethodParameterSignature;", "component1", "copy", "equals", "", "other", "", "getKey", "Lspec/CVL$SummaryKey;", "hashCode", "", "matches", "Lspec/cvlast/QualifiedMethodParameterSignature;", "toString", "Shared"})
    public static final class InternalWildcard
    implements SummaryTarget.AnyContract,
    SummarySignature.Internal {
        @NotNull
        private final MethodParameterSignature signature;

        public InternalWildcard(@NotNull MethodParameterSignature signature) {
            Intrinsics.checkNotNullParameter(signature, "signature");
            this.signature = signature;
        }

        @Override
        @NotNull
        public MethodParameterSignature getSignature() {
            return this.signature;
        }

        @Override
        @NotNull
        public SummaryKey getKey() {
            return new SummaryKeyImpl<String, List<VMTypeDescriptor>>(this.getMethodName(), this.getSignature().getParamTypes());
        }

        @Override
        @NotNull
        public String getMethodId() {
            return this.getSignature().getFunctionName();
        }

        @Override
        @NotNull
        public String getMethodName() {
            return this.getSignature().getFunctionName();
        }

        @Override
        public boolean matches(@NotNull QualifiedMethodParameterSignature signature) {
            Intrinsics.checkNotNullParameter(signature, "signature");
            return this.getSignature().matchesNameAndParams(signature);
        }

        @Override
        @NotNull
        public FromVMContext getArgContext() {
            return SummarySignature.Internal.DefaultImpls.getArgContext(this);
        }

        @Override
        @NotNull
        public String getNamedFuncSignature() {
            return SummaryTarget.AnyContract.DefaultImpls.getNamedFuncSignature(this);
        }

        @Override
        @NotNull
        public String getFuncSignature() {
            return SummaryTarget.AnyContract.DefaultImpls.getFuncSignature(this);
        }

        @NotNull
        public final MethodParameterSignature component1() {
            return this.signature;
        }

        @NotNull
        public final InternalWildcard copy(@NotNull MethodParameterSignature signature) {
            Intrinsics.checkNotNullParameter(signature, "signature");
            return new InternalWildcard(signature);
        }

        public static /* synthetic */ InternalWildcard copy$default(InternalWildcard internalWildcard, MethodParameterSignature methodParameterSignature, int n, Object object) {
            if ((n & 1) != 0) {
                methodParameterSignature = internalWildcard.signature;
            }
            return internalWildcard.copy(methodParameterSignature);
        }

        @NotNull
        public String toString() {
            return "InternalWildcard(signature=" + this.signature + ")";
        }

        public int hashCode() {
            return this.signature.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof InternalWildcard)) {
                return false;
            }
            InternalWildcard internalWildcard = (InternalWildcard)other;
            return Intrinsics.areEqual(this.signature, internalWildcard.signature);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u00012\u00020\u0002\u00a8\u0006\u0003"}, d2={"Lspec/CVL$SummaryKey;", "Ljava/io/Serializable;", "Lutils/StableHashCode;", "Shared"})
    public static interface SummaryKey
    extends Serializable,
    StableHashCode {
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u0000*\r\b\u0000\u0010\u0001*\u00020\u0003\u00a2\u0006\u0002\b\u0002*\r\b\u0001\u0010\u0004*\u00020\u0003\u00a2\u0006\u0002\b\u00022\u00020\u0005B\u0017\u0012\b\u0010\u0006\u001a\u0004\u0018\u00018\u0000\u0012\u0006\u0010\u0007\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\r\u001a\u0004\u0018\u00018\u0000H\u00c6\u0003\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u000e\u001a\u00028\u0001H\u00c6\u0003\u00a2\u0006\u0002\u0010\nJ0\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00002\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00018\u00002\b\b\u0002\u0010\u0007\u001a\u00028\u0001H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0010J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0003H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0015\u0010\u0006\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\t\u0010\nR\u0013\u0010\u0007\u001a\u00028\u0001\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\f\u0010\n\u00a8\u0006\u0018"}, d2={"Lspec/CVL$SummaryKeyImpl;", "N", "Lutils/WithStableHashCodeIfSerialized;", "", "S", "Lspec/CVL$SummaryKey;", "name", "sig", "(Ljava/lang/Object;Ljava/lang/Object;)V", "getName", "()Ljava/lang/Object;", "Ljava/lang/Object;", "getSig", "component1", "component2", "copy", "(Ljava/lang/Object;Ljava/lang/Object;)Lspec/CVL$SummaryKeyImpl;", "equals", "", "other", "hashCode", "", "toString", "", "Shared"})
    private static final class SummaryKeyImpl<@WithStableHashCodeIfSerialized N, @WithStableHashCodeIfSerialized S>
    implements SummaryKey {
        @Nullable
        private final N name;
        @NotNull
        private final S sig;

        public SummaryKeyImpl(@Nullable N name, @NotNull S sig) {
            Intrinsics.checkNotNullParameter(sig, "sig");
            this.name = name;
            this.sig = sig;
        }

        @Nullable
        public final N getName() {
            return this.name;
        }

        @NotNull
        public final S getSig() {
            return this.sig;
        }

        @Nullable
        public final N component1() {
            return this.name;
        }

        @NotNull
        public final S component2() {
            return this.sig;
        }

        @NotNull
        public final SummaryKeyImpl<N, S> copy(@Nullable N name, @NotNull S sig) {
            Intrinsics.checkNotNullParameter(sig, "sig");
            return new SummaryKeyImpl<N, S>(name, sig);
        }

        public static /* synthetic */ SummaryKeyImpl copy$default(SummaryKeyImpl summaryKeyImpl, Object object, Object object2, int n, Object object3) {
            if ((n & 1) != 0) {
                object = summaryKeyImpl.name;
            }
            if ((n & 2) != 0) {
                object2 = summaryKeyImpl.sig;
            }
            return summaryKeyImpl.copy(object, object2);
        }

        @NotNull
        public String toString() {
            return "SummaryKeyImpl(name=" + this.name + ", sig=" + this.sig + ")";
        }

        public int hashCode() {
            int result2 = this.name == null ? 0 : this.name.hashCode();
            result2 = result2 * 31 + this.sig.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SummaryKeyImpl)) {
                return false;
            }
            SummaryKeyImpl summaryKeyImpl = (SummaryKeyImpl)other;
            if (!Intrinsics.areEqual(this.name, summaryKeyImpl.name)) {
                return false;
            }
            return Intrinsics.areEqual(this.sig, summaryKeyImpl.sig);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u00002\u00020\u0001:\u0002\u0012\u0013J\b\u0010\u000e\u001a\u00020\u000fH&J\b\u0010\u0010\u001a\u00020\u0011H&R\u0014\u0010\u0002\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0014\u0010\u0006\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0005R\u0014\u0010\b\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0005R\u0012\u0010\n\u001a\u00020\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u0082\u0001\u0003\u0014\u0015\u0016\u00a8\u0006\u0017"}, d2={"Lspec/CVL$SummarySignature;", "Lutils/StableHashCode;", "funcSignature", "", "getFuncSignature", "()Ljava/lang/String;", "methodId", "getMethodId", "namedFuncSignature", "getNamedFuncSignature", "signature", "Lspec/cvlast/MethodParameterSignature;", "getSignature", "()Lspec/cvlast/MethodParameterSignature;", "getArgContext", "Lspec/cvlast/typedescriptors/FromVMContext;", "getKey", "Lspec/CVL$SummaryKey;", "External", "Internal", "Lspec/CVL$SummarySignature$External;", "Lspec/CVL$SummarySignature$Internal;", "Lspec/CVL$SummaryTarget;", "Shared"})
    public static interface SummarySignature
    extends StableHashCode {
        @NotNull
        public SummaryKey getKey();

        @NotNull
        public MethodParameterSignature getSignature();

        @NotNull
        public String getMethodId();

        @NotNull
        public FromVMContext getArgContext();

        @NotNull
        public String getNamedFuncSignature();

        @NotNull
        public String getFuncSignature();

        @Metadata(mv={1, 8, 0}, k=3, xi=48)
        public static final class DefaultImpls {
            @NotNull
            public static String getMethodId(@NotNull SummarySignature $this) {
                return $this.getSignature().getFunctionName();
            }

            @NotNull
            public static String getNamedFuncSignature(@NotNull SummarySignature $this) {
                return QualifiedFunctionNameKt.printMethodParameterSignature($this.getSignature());
            }

            @NotNull
            public static String getFuncSignature(@NotNull SummarySignature $this) {
                return $this.getMethodId() + CollectionsKt.joinToString$default($this.getSignature().getParams(), ", ", "(", ")", 0, null, funcSignature.1.INSTANCE, 24, null);
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u00002\u00020\u0001J\b\u0010\u0006\u001a\u00020\u0007H\u0016R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u0082\u0001\u0002\b\t\u00a8\u0006\n"}, d2={"Lspec/CVL$SummarySignature$External;", "Lspec/CVL$SummarySignature;", "sighashInt", "Levm/SighashInt;", "getSighashInt", "()Levm/SighashInt;", "getArgContext", "Lspec/cvlast/typedescriptors/FromVMContext;", "Lspec/CVL$ExternalExact;", "Lspec/CVL$ExternalWildcard;", "Shared"})
        public static interface External
        extends SummarySignature {
            @NotNull
            public SighashInt getSighashInt();

            @Override
            @NotNull
            public FromVMContext getArgContext();

            @Metadata(mv={1, 8, 0}, k=3, xi=48)
            public static final class DefaultImpls {
                @NotNull
                public static FromVMContext getArgContext(@NotNull External $this) {
                    return FromVMContext.ExternalSummaryArgBinding.INSTANCE;
                }

                @NotNull
                public static String getMethodId(@NotNull External $this) {
                    return spec.CVL$SummarySignature$DefaultImpls.getMethodId($this);
                }

                @NotNull
                public static String getNamedFuncSignature(@NotNull External $this) {
                    return spec.CVL$SummarySignature$DefaultImpls.getNamedFuncSignature($this);
                }

                @NotNull
                public static String getFuncSignature(@NotNull External $this) {
                    return spec.CVL$SummarySignature$DefaultImpls.getFuncSignature($this);
                }
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H\u0016J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&\u0082\u0001\u0002\b\t\u00a8\u0006\n"}, d2={"Lspec/CVL$SummarySignature$Internal;", "Lspec/CVL$SummarySignature;", "getArgContext", "Lspec/cvlast/typedescriptors/FromVMContext;", "matches", "", "signature", "Lspec/cvlast/QualifiedMethodParameterSignature;", "Lspec/CVL$InternalExact;", "Lspec/CVL$InternalWildcard;", "Shared"})
        public static interface Internal
        extends SummarySignature {
            public boolean matches(@NotNull QualifiedMethodParameterSignature var1);

            @Override
            @NotNull
            public FromVMContext getArgContext();

            @Metadata(mv={1, 8, 0}, k=3, xi=48)
            public static final class DefaultImpls {
                @NotNull
                public static FromVMContext getArgContext(@NotNull Internal $this) {
                    return FromVMContext.InternalSummaryArgBinding.INSTANCE;
                }

                @NotNull
                public static String getMethodId(@NotNull Internal $this) {
                    return spec.CVL$SummarySignature$DefaultImpls.getMethodId($this);
                }

                @NotNull
                public static String getNamedFuncSignature(@NotNull Internal $this) {
                    return spec.CVL$SummarySignature$DefaultImpls.getNamedFuncSignature($this);
                }

                @NotNull
                public static String getFuncSignature(@NotNull Internal $this) {
                    return spec.CVL$SummarySignature$DefaultImpls.getFuncSignature($this);
                }
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u00002\u00020\u0001:\u0002\u0002\u0003\u0082\u0001\u0002\u0004\u0005\u00a8\u0006\u0006"}, d2={"Lspec/CVL$SummaryTarget;", "Lspec/CVL$SummarySignature;", "AnyContract", "ExactFunction", "Lspec/CVL$SummaryTarget$AnyContract;", "Lspec/CVL$SummaryTarget$ExactFunction;", "Shared"})
    public static interface SummaryTarget
    extends SummarySignature {

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u00002\u00020\u0001R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u0082\u0001\u0002\u0006\u0007\u00a8\u0006\b"}, d2={"Lspec/CVL$SummaryTarget$AnyContract;", "Lspec/CVL$SummaryTarget;", "methodName", "", "getMethodName", "()Ljava/lang/String;", "Lspec/CVL$ExternalWildcard;", "Lspec/CVL$InternalWildcard;", "Shared"})
        public static interface AnyContract
        extends SummaryTarget {
            @NotNull
            public String getMethodName();

            @Metadata(mv={1, 8, 0}, k=3, xi=48)
            public static final class DefaultImpls {
                @NotNull
                public static String getMethodId(@NotNull AnyContract $this) {
                    return spec.CVL$SummaryTarget$DefaultImpls.getMethodId($this);
                }

                @NotNull
                public static String getNamedFuncSignature(@NotNull AnyContract $this) {
                    return spec.CVL$SummaryTarget$DefaultImpls.getNamedFuncSignature($this);
                }

                @NotNull
                public static String getFuncSignature(@NotNull AnyContract $this) {
                    return spec.CVL$SummaryTarget$DefaultImpls.getFuncSignature($this);
                }
            }
        }

        @Metadata(mv={1, 8, 0}, k=3, xi=48)
        public static final class DefaultImpls {
            @NotNull
            public static String getMethodId(@NotNull SummaryTarget $this) {
                return SummarySignature.DefaultImpls.getMethodId($this);
            }

            @NotNull
            public static String getNamedFuncSignature(@NotNull SummaryTarget $this) {
                return SummarySignature.DefaultImpls.getNamedFuncSignature($this);
            }

            @NotNull
            public static String getFuncSignature(@NotNull SummaryTarget $this) {
                return SummarySignature.DefaultImpls.getFuncSignature($this);
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u00002\u00020\u0001R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u0082\u0001\u0002\u0006\u0007\u00a8\u0006\b"}, d2={"Lspec/CVL$SummaryTarget$ExactFunction;", "Lspec/CVL$SummaryTarget;", "signature", "Lspec/cvlast/QualifiedMethodParameterSignature;", "getSignature", "()Lspec/cvlast/QualifiedMethodParameterSignature;", "Lspec/CVL$ExternalExact;", "Lspec/CVL$InternalExact;", "Shared"})
        public static interface ExactFunction
        extends SummaryTarget {
            @Override
            @NotNull
            public QualifiedMethodParameterSignature getSignature();

            @Metadata(mv={1, 8, 0}, k=3, xi=48)
            public static final class DefaultImpls {
                @NotNull
                public static String getMethodId(@NotNull ExactFunction $this) {
                    return spec.CVL$SummaryTarget$DefaultImpls.getMethodId($this);
                }

                @NotNull
                public static String getNamedFuncSignature(@NotNull ExactFunction $this) {
                    return spec.CVL$SummaryTarget$DefaultImpls.getNamedFuncSignature($this);
                }

                @NotNull
                public static String getFuncSignature(@NotNull ExactFunction $this) {
                    return spec.CVL$SummaryTarget$DefaultImpls.getFuncSignature($this);
                }
            }
        }
    }
}

